"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var path_1 = require("path");
var constants_1 = require("./constants");
var get_babel_rc_1 = require("./get-babel-rc");
var get_ts_config_1 = require("./get-ts-config");
function getCacheKey(fileData, filePath, jestConfigString, _a) {
    var instrument = _a.instrument, rootDir = _a.rootDir;
    var jestConfig = JSON.parse(jestConfigString) || {};
    delete jestConfig.cacheDirectory;
    delete jestConfig.name;
    return JSON.stringify([
        constants_1.MY_PACKAGE_CONTENT,
        fileData,
        path_1.relative(rootDir, filePath),
        jestConfig,
        get_ts_config_1.default(jestConfig),
        get_babel_rc_1.default(filePath),
        instrument,
    ]);
}
exports.default = getCacheKey;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2V0LWNhY2hlLWtleS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uL3NyYy91dGlscy9nZXQtY2FjaGUta2V5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQ0EsNkJBQWdDO0FBQ2hDLHlDQUFpRDtBQUNqRCwrQ0FBd0M7QUFDeEMsaURBQTBDO0FBRTFDLHFCQUNFLFFBQWdCLEVBQ2hCLFFBQWdCLEVBQ2hCLGdCQUF3QixFQUN4QixFQUE0QztRQUExQywwQkFBVSxFQUFFLG9CQUFPO0lBRXJCLElBQU0sVUFBVSxHQUF1QixJQUFJLENBQUMsS0FBSyxDQUFDLGdCQUFnQixDQUFDLElBQUksRUFBRSxDQUFDO0lBQzFFLE9BQU8sVUFBVSxDQUFDLGNBQWMsQ0FBQztJQUNqQyxPQUFPLFVBQVUsQ0FBQyxJQUFJLENBQUM7SUFFdkIsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDO1FBQ3BCLDhCQUFrQjtRQUNsQixRQUFRO1FBQ1IsZUFBUSxDQUFDLE9BQU8sRUFBRSxRQUFRLENBQUM7UUFDM0IsVUFBVTtRQUNWLHVCQUFXLENBQUMsVUFBVSxDQUFDO1FBQ3ZCLHNCQUFVLENBQUMsUUFBUSxDQUFDO1FBQ3BCLFVBQVU7S0FDWCxDQUFDLENBQUM7QUFDTCxDQUFDO0FBbkJELDhCQW1CQyJ9