var Images = {
  '20x20.png': 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAIAAAAC64paAAAABGdBTUEAAFjH/EfgAgAAACBjSFJNAAB6JQAAgIMAAPn/AACA5gAAdS4AAOpfAAA6lwAAF29p5MQrAAADmUlEQVR4nGJgKFUhGwEEAD0Awv8AAHUk////+fv57/bx5fDp2evezOTUv93JstW9pM2xlselib+afrmQcbOGZKx6VqZvSJ9jO5hYLpJNAHUkAgik+QdY55OPL26+unfm8eX9d45vhOg8trTzwKzanf2Fm1qTV1eGLgXrnAnU6aPY7QTUCBBAIM3vgDo/vLjx6t7px5f33T6+8cqexWc3AHV27J8J1FmwqSV5DVBnrvu8ZKsZ4bognY5irRZAjQABBNIM1nn39ONLe+8c33Bl9+Iz66ceXdKxb2b1jr78jS1JQDuXAHUmWc4I15kI1tliwVOnD9QIEEAgzddf3j0F1Hn72PoruxadWT/l6JL2fTNqgDo3NSetrghZkus2L9FyepjOBG/5bkfRFnPuOn3mCnWgRoAAAmk+9ejSnttHgToXnl035egioM7q7b15G5sSV5WHLMlxm5toMT1UG6izy0GkxYyrTg+ks0gJqBEggECad986uu7KrgVn1k0+AtQ5vQqsM2F1efCSbNe5CWCdXhCd3ECd5WoMRYoMubJAjQABBNK89vLOBWfWTjq6sBWksyd3Q2PCqrKgxUCd8ebTQrQmeMp12gsD7azVY4LozJFlyJAEagQIIJDm+UCdRxa17Z1WCdYZD9bpMgekU7PfU7bTTqjZlLNWF6SzUAGkM12KIUkcqBEggECaJx5e2ArWmQPWGbg4y3lOvNm0YITOGl3GclWGIgWGbIhOCYZYMaBGgAACaW7ZM7ViW3fO+oa4laUBi7Kc5sSZgnR6yEB16jCVqTIUAl0rw5AuCbIzVpwhQhSoESCAQJqBOrPXN8SuKPFflAnSOTVIA6TTVrDZhKNGhxGos0ABpDNNkiERbGeEGEMwSDNAAIE0Z62vj1kJ0uk4O9ZkapB6n7t0h61gE1CnNgNIpzxDNkSnOEOMGEO4KEOwCIOfCFAjQACBNMcA7VyY4Tg7xmRqoFqfG1CnQKMxR7U2QynYTiw6RRk8QTYDBBBIs9+iDIdZMcZQnTYCTcbs1dqMwEwHtDMLWSfYtSCdIgwuIJsBAgik2X52jNHUANVeVymgzkYj9motkEQ+UKc0Q6okQ4IEQzTYziBRBl9RBg+wTnthoBqAAAJpNprsr9rnKtluzd9oxAbUWQLRKcOQKsGQIA7TKcLgKwLS6QzWaSUE1AgQQCDNKr0gnXwNhkg6pVF1wuyE6zQRBGoECCAGSoohgAADADTmqQJpZXKFAAAAAElFTkSuQmCC',
  'bluesquidj.png': 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAZoAAACgCAMAAAACTlouAAAABGdBTUEAAK/INwWK6QAAABl0RVh0U29mdHdhcmUAQWRvYmUgSW1hZ2VSZWFkeXHJZTwAAAMAUExURRlNbCFggipwjhxYeSVtjTKCnTmQrSltjRRKbCRoiiRohjmNqxE8XCx5llXK5RhQbjSJpQszVEy51BI+YUGfuylwkix5mRRFZBxafBxSdC19nTF9nSJgfSxxkjSGpQ0+XRxQcCRgghRCZBFAYQw2Wix0kiBceiRihRxUcilsiyVqjRxYdhpYeTF8miRlgxRFaSJoilLD3R1ceDGCoVzY8xRIaTyatUmzzhlMaiVsigw5XCp4mj2cuQQqS1rS7CRefEOlwi18mhxObDSFohVMaiJlhip0kyxylQQiRCxujRpWdSJkgwQeRBpafBhOcBpWeRJIbCx6nUSqxTSKqTSCoShqiTWNqg5AXmPl/SJmiTWPrShukSp1liZwjk+92CBaeDKFojyVsRREYhJIaSBegS6BnhRGbBRBYTB6mR5gfhpUcjmSsQouUTyXtUmuyg04WRJFZ0Wtyip4ljR+nR5ggSp2mQ09WhRIZiZxkRhKbCx4kxpceggsTBJEZRpcfCJqjBJMbC56lzqVsiJtjTyTrxdKaTKGpRJMajB+oRhSdgMlSSp8mjeKpy18lzKKqBJCYwo4WRJFayJigyJsiydphwo4XCp9nRZQbyRcehJEYl/c9ixsiypylAw2VTSDpTSHqRtOai6CoSBYdjqWtTSLrQo9Wg4/YEerxyp4kzONqQUvTR5dgTN+mzaSryp6nDyTtTKDpQMnRj+hvTiPsAgwUUCiwS96nChlhShqjQo8XDKNrRRCaB5aezaHpjyYuRFCZxZIZlHF4jKKrCBWdjB2mhxWdAIcPyx2lSRmhRxUdCRkhSx0lRRObCBcfBpQchhQcBxefBxWdyJefBZObiBeexZOaxtSch5cfCRmiB5eeyJcexZMbB5efhxcexRMbBxUdix2lxpQbyRkhx5cfhhScBhQchZMbhxefiBefix0lxRObiNefhtScBxcfh5WdCBcfiZmhRhSciZmhx5Wdi52lxRMbh5Tdi50lx5UdC52lC50lCZjhyp6lyBWeCZkhDqTtEHYD6QAAI7/SURBVHjaYuAGAjY2bu6evc7GC1Oluv/wHleVZfLU1GTR4ox8pK6oqGg/I36RtobGUSA4KSmpoODktODq1TMNDRxgYGpaLg4Gpmlp+vuXycvLK/crQUSUlJSSgJS+fhoIBHDcOwMG089d+3YSZJqGhra20d0LIJDJOEld/Z/eCS5OTi0tFiBobmZhYWf39GQHcUA0uxYnJ9eJE3p6QHxKHegue/tbZ69LMDNrHz0KdRoMXDs3/cwZFwYGJwUFIOf85TNXgWwnhqtgqyFKIHqOXmSWkHhbV3fh5iV7e/srN8HOmMT4WGLPWaBA/CKIAuaLQA0aCCtApp85fw5ozWUkE0HgJMRUbWagLpCpV4CmKCqqq5/Sgzica/JksGeYZFWP81qLBUpJr2F1dhYQCF65MioquykXBhITW4AAIIAY2EDxwt3Ts3evM2uqlCMvb5UqE5Nm6JQpnJw3TnlPkrl0Vi1+0efPJzWA4Nq1c+ceguKG4TY4UkzBpL54Un+/8szaAn392v7wcOV0YJQogaNEXx9IlZebBnBwVAIBAwM/P//08+fOAT2hAQmZPUZXMkGAcZI30OnAmLHUZGdiAsZGLJOoKBMTOxywsGgB4wboQ6CqU6AEoygjc+X6HkjMaBw9efLbN1ConT9/TgEIHjIwXL16leHhNclvkufPNNy7/RAkeB5sNdBycBBqawODEBiGEtfPXrl0BQheZDKCQMqLF2dBYA/QcCi4ePHi/ZMnETF/HuiJa2B6+pOskzAZDbCZIGP37Nlz9g7QVzKvXwMdqn7K9QQXF9eUKaGhLCxMQACMmKI/joFSHR2srCHOcgJ9K8PC2NhaEhMTm5qys5sWg6IGGC0AAcQQFRUWLCDnHBISskY3g1cVCEARo+cNTJiMjJkXqrW1IakFGCMLQAnvKj8wZio50vQLoKGvv1upH5RZwmdCcwoU7AbmFlDclANj8DYo2QKBggIsjQFzDChFnr0kIwN2PdDxlsAcw8IOcrunp6esrPsc0VhojgFlomZoroHmmEtXgG4DxosGUnIG55arEJuAmeTqmcvnr0me8wOmH79zkuCoQ0ra4AwBAmfPgkyD5ZhMSFo/exYiCYp5bVjOwQbApkE9pA3Lg7Dcog7KMMCigAtUFLADMwvQV6ePH+fl7e5OTTUOmTdPzllObn7wkiXcbKBsAoyPqKiozZvXr9+8OWzlSoAAYhAQEGhLWJgKBFKNP1WZgCUHiyXnJ2B+AbnSCOS0k6DkcRnsY4Yz90CFWJopODuIz5wZvmyZMigelJUhxZiSUr9yODCaQFkHGnNpoLx1+/ZVEOA/fw6Svu4DA8bXtxoYHorq//6BYoazfvLkycBiLDaWCeQF0ejY2FhRIIgFxY+WZT0nFxc0v9i/lnlxE+Q0WFEGzjFAN565zMAAyi7A8gaYZcDg9jM/v3PnQO4HCl6eDsk1oHDUAIf49bNnL4FyDCS/lGRmvgCWEmBw6dIttXjtixeh2eb+SWg8nESKkpPQvAJKHxeZITENyoKgrAJKb+qPIjmB3rK0tNTUBBViIHC8SKxbSkqKFZxf5OQEBHp6QFUKMErYwADIXhIMBMBoAQjAVdm0HBCFYXh4UUh2slGkWPjY2LCUhVgpsZPSOwvvX1DKwnpKlvNT/AHjo+NrplAUO2Vv577PjIX32UyzO+e5z31dCuriVcsRzLUaq6Ew4Fg67fo9i0G2Xv+7m6YZD8MsYLdSHANfDqc4PTuGpKYxHo3xfKJxfAMBNRqMxtbMLrzmpTZAycyyxBkvdWKAY4FpSSqmI0fXF7qOL28Tc8towLJ8nq8w8XgcU5YYojHcr22/OECL5R/YGIXVxnmXKGoR3D2hMcjtO5o5VylLS8dQdVhlvy/EHv8wGDa8PXafdn7RH+z+w8H/0VwAOzYrM1vdbk4HaRfDwHvztzzyUhJi0Eso9BrlcqoqgwHJMM02Ve9jNkE5UEvFW+C8BRBDcfEa6QxI1Q8q0Dn1FO0vgRwHzMtZT6afcbm6AFyAQap8fUgtglxu9SuDCrN+RJQoKcEUQQozEIAVaE4KwHwPDhOQD6A1JKhyjAVV+cDsDgbAPH/8uLs7MO9ACjd2UIvEFVw+qDOufgwpaUCFGTBsrsELWgaIO2+DowfiXg5gDF1lWIBUjiIVPYjC7AKwCIJE0QVQUQQUqKt7i1aYwcpNWHEIzTFgz4AULrqFKBbB1T6odtGcDS6NY2PdjoNBo+6a4mJQvISEzAPlGGDuWLJkyS5gjgFFypIlh4KD98o5O7OyrpGSCgwECCCGjIxG3hi3WBZLYM0PzDHqjC/AFeDFoxpgT4MKBWDaCwgIMAXW5/qgml45XBkWA0D2smXCUCC/dClq1Ojrm4JzTCUDqJZRuHYN1JTQ8NKRqLvzghFcFp84ceMGpxao6gdFzK9fxxHgtLvsHCZgacbOviNUC1TL/AZWfimrH799C44XcEH78fx0fmDVt8DCBRolt8ERAmpwQJi3ISUcA7gV8BDaAgGFrBcwTKvvXrgDiYkLmS+A6eRFJiRqzl6/exdY0p1VA7UDYGUa0EINaH6BA3A9B25MgAqBKy9kZBhBEQONGk5OS0tQtR8tOsfNDZhjHoiJOUpJgWqOVFZjYMzIgXPN/L6+lStXhvWA2mFyzgnG4KpFtxGYV1QBAohBVdWtIpZlMtcJPe9JkxQVUx5LMPt7eWm8eQj0Mah2ue0CjJe0NEghpq9fsF8ZWOdDWmHAiAHmFHjULEPKNcBGc7k+qMEMDB4LSCv2/v2j2uCsr119N7OEEZjfQe6vrwdVkOAMcxoeLVXgmBEFNQMm19dz3uACl2bAttP1PeAcA0w3oBxzzu9MAyRX30ZEDcixwLiB5yBg/dhw5jak8XzZD9ZuB7kD2G7PlIGldVCGhDUBrkOyE7ApAG4AghvQ4LRwEq361wZXd8AWmcR1UPUPMuU30CA9UNUP7QTEisq6/zoNTHNiwLYyFACbAM5ywJiAAgEBObmEBGNgblqzRqq7e90661I3YBnmCRBADMAig11zygm9f8Dq9cUdYMRcvH8NWKNC6nsODpfW8nJYAdbfDwn9/vT0dGFhUKwog3MLLEb6+6ERo5SUlCQOaTNbLGCwuHoV2MbUALVx3y26dQsYFMAwmeR9ApTf2VkmN7NEiwIzDLAsRgJubqDqn8lzdugUUO1/Sh1UR4Mao7fiQU1GYBh9+/btmt8zoA1O8NwCyTLAWLCoNAVWcQHgqFlgAWmh/QAWftegBdrRRfEzIFXKlVuI1lnJc0hdc+u6hC8wAexhBjeEJUCNALAmUOEFZkN7RdrQNh6wpQyM4JvQztkpSJuMyxLoMRZNaKIDFmgZurrAumPNmuIQUMsMCYAKMFZwZgL2XXpB2UWWCdxZAAgghilTPn3Q85bJlAG35EE2A/M+/9WrLmCPgsox8aQkWPEFqleWKSuDooZHXn6pPKwgA+YjWH6BNJv1gaUfsKS/zA8qSfymn88CliDaOheZgUECbGBllni7ArswlqCWMrAdNsft9HFgdudFjpo5TCyawO4MsFkCTDXAdtmL6xeAxYwasI/1DlLQnzvn5wdqmVgwgPIHKB6AAESDelCgmOGohDTSGPxAANKl+QZK7UCn7FE7C24eXwcWZDLAcuxCCTBQFV8A22qQ9tnZ66Bi0wtUMQJVXTypASqMwU2HiyDLwQUzMM8A28pvfX0lgDEDjRrvU5CuJTBmLEFdZnagD2VBpUEVb6OuNChaQkLAVbyzMzha5gE7LcCIkXJ0/ANqiIkdB7WRZ2tOmXLjxo1IgABiABaywJx89y7QKf73IZ19cDMZXDikQUqyJEStDy63oFECp5eCIgdWmIH6M6BW2T1gHQxrEt2HJrDrarfsZRS99YAFMacWsK0cC87vv4CNF7HAQKDLYNUMsAngCXSiJrgvo/dPBtLRAIbLUQ1oJXwOnGNghRjQnWB2ZdrEiRPBIw/Q5gCkbwMaEQC6RfIbsJEFbwKAwGpQbgG2zMDpHTS+oCYBabaBrYMVZszQega9CQBvTAA1XLkCLArA3WbokAa7J6QJUOEGihje3l5gm7nDeN484w5QkQZqCsybF1IMaoRJSXUDfa6qCmr3AH0NLCa8vYFViyJAADG8fv36rBow5wIbgZIfQc1/YNoDJzxTUEkGrtGV+sGNL3C2gdT6y5Ytk+cBAVhVowxtQYMLMmhReNtiwUNQ0+gkKL3pgEoPGRkZbz0QODElFFj1R4sCM4wqKMOIAeMF2LSsAscMMEdDmmWg2t/bGxhy168DCx9QOr4P6r5M5weNSDBwwOt5i9YDwKqttfL2M0iJxlAJarObQrINeAACNA5wDuIUbWh/BtxRZ0wBFpMljKCAsLeXAZZs4KB+DCxAQCECjRZQVNwH55j7kC4/M2QUASigrR2vdgvSkIA0ACBdTAODei1gWebpySQ6Z47b8aqqKmDU6K6R7ugANwKAlQowTqQ7UkEVj6Mj0Oeg5DgnGliIgQoJkI/vPH78GCAAEVbPQlAUhpWkpGyKjkFKCeOtWwYpExltymLxC8TkL7j5BYrF/QFGo0EiH9e3H6GM8jzvOTjLGd/heZ+v13c+N5tP9tmD1rG7OOkAZKFh0EBSNP4JnB+2P9YiNoGYhfGH8QObH6f+efkby2TXoCDetAVgiApfqJ6BCCd0IiM0AkzPQMN6hVRGxlQdtbuR0uL+m1dsFdnuL7ZNHcMOWZaFObY97+DpwcAD7Ol2hbn0Gl+5v5RrwEs7hoFGqaTjSMtkp0FjgJqdPM8caDZZk7x4bwBl9C3tIWwx7dLvr4DDo3RRKYEGFU3AATTD+iwTxO6ZcNOjnOXzLgkSd91AQHOlBMuPFhpcRdQENoTj4l112td1rZbD6I8AYkAatUQuyPR3Q5vAM8NhBRekDINGDaJQg0UNbCQTFCTADANulcGS6eMURki3RB3crLQEN1xOI9UtwCwPyTWnT7uLRrNACrJTkM4/tDCDDsYAHWoB6maBQh2cW6CZFDTKCmaDW2iIVhu4ZXYeVJghD2leuAAfVYUM+0D7NKBWQLz2Ua+L0O4KBkAu2MARDWxuvgAXaBfgfZopobM9mcD9GVFwE4A3A9gCAEWLlDQou4DjRaq7txeUW4ClGGgs2RI01gEZgoKUpUC7AQJQYf0sBIRh3E0i9W4WBqVuEZtSdovJJINuU3YLi+k+gBhNPoTFfQFKkU7qTjnTDWZFBr/f81A82y1v79tzv78J7evMIfAD8tjQBZGxGFsJYNrIMMUvjelKMiovXwsgTKeu7FMyD2sQ58A30XEtoYCaG/ehkdcTkDDlXghzGdy6jGA1ksFiGnNpZsapzmnTtKx+GMaSs0r79V1yfxQZExDZVV62Bi4jXBi7MC49Qa83gSfwTQIfBW0KhMyYQhaOY3ue9ClxnNduxlK13WmY+as1lcO0JdcDpBeiB+DLcJjtnT+dQp64Ud88gwfodoWu8ftd6tnWMvczJLHXC3t5PJ9QlyTxkq5AXwbh1naIVoaDW+EtgIBRcw1YkJ1xgaS3ieBaPwnYPIZ19Jcp94M7+vDcAqlioHUMovaHjDHrp4HrZif+q9OnP4G0bx6/hg64e0dCxmJE57h/h2YWYEYHJiLdXl5wvLi7uwO7MpOBgJPzBrCHCewDVlf7Qqvha+AM42QBmo5oQFT9DBbAnFMLbXnchjQF0jg4zsBGAeDDAOAWALBieA1qNO+5BR5/BBZod+DDmtBiE8uwpgZsfAaWXcD9TGD03rp1Sw1kGtBYoGm/T50CN5uBrTNLaH8G6EVg+yYwcN06R9BAALCTPw3cbwFVqKpzQJ2X2aGhnKChDpALqnW0vcCNPw2QRy0AAgg2TgsaTIYMFJeLzwRFBTjEQaEP67/wWFlBav4yeGEWvgypVZYGGscEtcpAg1awMQxfYJcbWJirT/IGNpdhLX1oFwZUO4o5Ah0uxlulqgqKmO/uc0SjtepBA2b/QPVyJmR0+eiPk+BRMMhYDDCHgKIENhYDaqwU6E+EDNXB+zYMoNGbq5DZoXOQNjNspFmiDjYec/MOsAUA7GfL2MMAZIgK0quFdylPogxnQpubkMFVbe09d8ETTndeME769+8fZJQZNJoJ7s+4ubkB+zPgtMfbqwuq+qXWQToJpyHj6pZTuECtIhmgT+8agTvk4PwCqVYAAogBXKMCY6bVFDZoKd4PLMCWCYP7lZDWGJjmgQL5ZbAMAyzM+kGDnEngggw0ZHXG5So//zXJ+xBX7zl75w54KubUhw/AJpkmaJwP5GZQ1EBqfiCwti59cPz4T1CDeY4ouJrhunHi1CRFYLtR7S54eFkDWOCeBzbMpvOD3AkDtyHdrgBQS7K1FdSkhPVtQI1DSMsMBPyghRm4+n8MLLNAYXkT2AgAhUcJsEyTAXVnroAHm4FWwgoy5HoGNCgDY8CGRkFh+O5dfPweYNzcvXnzCij9gcfP6+ubIcMbqqePf2nMABbYUAAsyrZtE3vwANwEBZZjLMD6BdzOuXRF7eaFurvMXmBrJIERA/QP0CMAAQRLfKCmMlL3RQkYMUgFF0ZBBmkBhIfPFAcPFkCiBlqKgMtkDW1Qjxs8gukNbisDW5KgAVhZyPAlsLkcCOz6wltloHQEiRdQPwbY+U9ZDR3BPAmZTbx8DjL1ctsCUmaBx4BAhRq4IQbMTqAGM7j6Z4AMa8JHmaEDAOCoAfdAbsKbusBSJBPSHoAWZszoVf9J2JQo8tAmrAkA9CC0eISUj49AE07Nk4GFGbT6BxZia3QbITlGWipQzJoX3M4B9V9mg5rJp0DDQynQ8Vpw+08S0mEDt18AAogBVBCBRi6BoADYf4FVHaD6pUwemmuWIbfOwPEEKcxAXRnQpAx4VKQVWMwovIF0lL28dIC1v70MuA8DrPzrLUHzlsCUBCp+gZkG3NB3dASVZcAcA8wzbnMg8zKg9iOonfL6xWOQa7XBo/GgihxU0UAGwG/fBvf+gS18U1CDA9yH4bgNHappbXUBxssr8CwkPF6OwmdTgAn8CqwHAoqXFGDVzSgjcwlUvkFnzyAjmRqoZRjq7BkoWi5CmuDXr9+tu3AnBZgA/6mfuBEJjBpNTfA0JqTZ2djY2AtKhduA+UXsAWgS7Seo5veEtJQhk09AnzJDR2GA6erZ16/QIdpKgABUmT0OglAQhOVpS0mMldrIFaSysrLwBHY2dhRcwCtwCK5BTQwFmJDwk2BCQkg4gZ27s7LRCxBgeMzMN7NpfvH9OI4icQ90mUh/XOs/iUQZDWZLoZg1C73B1wny1DUDeoyu/bD/x1uazIuOi21jJCKlKJY55rLwPLrfY2hdx7zaMfbNMn01BSUzhjKiCuY8xADxSJWm7/unrEIrjJptm7UCINMO/KW5BYHg4dAaypJT1XYcDxWHZpBmNMmffUaZZqJDcyJnUMWmi7guVidhtUbMlB6SIcAkzZ0NlczHMYayMq8cJ4vqfk6JcX4mZQrmyfv6u+yzKh8BxACeVimHdF9gOSYcOYPwoBVswkhdzCTo/DI4XsD9mKPQgWXQ5KWeHjheYJUirB8Dcit8wAw0wgwZyQTm8U+gUcwLd+uggyMaSPPKIACa+7ZALszSoKUxqEADTZtdBpVhClCngGIG3Gn3Ovou/hakmge3yjIvgMeIQX0IUG+krg6tMDuJPK+M3pdBApAZ9LP29q+BxoIaAJaWk+EjTyBfbpMuBhdovb3A1pluxnG3itjYZtB6FFDtD+rzg6yGF2Sgds7VBcD4OQBdBwMQQAzQqh80CBMOBODYSVcWRhrqB8YMLNcoI41i7gaNYoKWbgAL9ssPwYEB6qox79lzRUZm0r8Tn27c4DSor58Mmu4HpSNIpx86oATrXkL6wSyTLS1DQz/8U3wNajhdgUzkQaMG2In3u3yv3QUyowwe9QePxYCiyLQSOi8DLExBo5igxsJDBUgaAdfdXrDZlD2gPHMFvEQENNUMyTYyV8AAWM/4+sLK+5OIKRlgxoOuzABWLVnTp59/cg0iAY0XkKmXQOM94OoUNFwLGq8F+fRBqTWoldMIbpQ5iokBWwMZjV+A3UtgjgGqAlf/jCnP7/r6AjtsoAHBc35+z742NNxzaW1tPWCqD+nBAAQQOGr6YTPI8IlKSG8SllMg8QSuiOAxow9tld27dwbc274PXeXzGFjVyigCm5HwgowJ5F5IOgI6uAoKQBED7grDRzG9gY3YGaCS5eweSKkCLcwgFaMFgxM0HsBzpqBxMtNKxPTZM2BLDJy9pp+TPHkfKWnDRzOvQwcAoHUNuJt5EzbhDOvOwMf8TyIy7HRg1GQ9uQz2JbxRwQybbFaEFGbQJSfg6X9QsRDoCIoa3TXSoOq/6LgbsNSeA6plwEPpoDUx4HaOFzj9XTvndxu6cAxUs+hDx2IAAogBGiPLYDGyDD4NA40aIA0txOArMnbrQ9aWBYBneEGDMtc0QDXtHlBbRWYSqPL3PvFhCrggkwW6CFz4gppikPYyOMe4q8qqyoIa07M1Q7nAK5gg/b7r4IkSSNB8gwwgMdwGzfVDV5NVciAml6HjMKDFYOBAvAzqUkEbupA21K1bl8CD/6Bxe2C0g8fNMu+A+zWgkS8Q/fospMVxFDzTB8mo8OU3kteuQXqt16AMoOkasPZe3V1QbTVJHdjO0YKtzABGAmiIYw0wRtZ1gxZogNuhvNAJKHBDBzL8BB4POgmsY85PB5bUC5wgHUtw7QKdIAMIIAbYeAwoP6QjV/dQABmogcUNqEwDDciAF/0BMw1oPEYB1C4DOtbX98IdYP4GVTGQPjF0gM/99OnTbiAAbpnxwnv+oJl/dibQlAwXaIaV8cWLF1euX38LLcyOngS3zB6CZo8un0FaJMMAmnjluAf0Dz+wo3PVpf3MmfPXvn0Dxg1ouR4iv3iBe1YwcAmyJkyRkbGkpAQ0uWl/68p16DwzOC2AQlwDnBpA3ShYyxs2ygOhr0Fi3QtcbgO13gGVjpNOcRnUgxZlyUL70g/EHGEjMlLd3aCxsqqfx+cAPWtpWQ9pl4Fq/3ht0LoTSQW/y8B0dxvUX4OsiCmonQkdxQcIIAakvgx8PAZpKgZzRQZ8GBNUyliA2stHIR1jcPUP7RODGsuglUvgFv5xLABS/TdPngxa+QepFGGlC6w+1ngCKZ8kYcvL4KszGIAxBcsx0PWgKIsy4UsoYRkGNE5UMgmlCXDr1h7YmAzq+s9z56EmfvuG1KUCOQVY6WhDTb5+9hZ8YSYX12Rw9f8LMvEkFig1bRpohLl4jfS2QLE/4FEoRF/GGzb5BFoSBOz4W1hAx5P1kVbAggMbIIAQuUYJUaAJo9Qxy4A9SyDohw5FFwArf2CHAhgs0Oof3GCuBrbuwcN7J0D9GGCrDFjwikKGMVXBY6+6uhnAbA2KlZ/gUQrQYiZgMxJamDFmPr9w9/r1s3v2IALq2nSQDUhRA4kK0Go2YPn1ELKs7RwkOaO2obRh/ZizSLnmBagN8OLSpReg1Wag5hq4H/MW3kT6Bo6K6Yg1UcA202VQB+kaPPdcgzScQe29s2rAwmyS94cpobOBANKXefDggdi2bdLSa9ZAxv+lpKWBDbMvoBICGDWi7Fqcn06BelOgNXQXL96/fxK26LcSWJhNhC6+0K+FBTZAAEGiZhmobaacLpwOH+cHxQiwzlGCDC7PFD8AnVYD6p0IHsJ8yM8PrBezToJXYzAbgQrdf7CVGJDsLfvrNHSeH1z6gqPGDZ5jwEuawekI1CkGuvjmzbuwHh8oZsDhdBlc9YJW+IFX//nxTweyQOEFWvUHHoNB1AonwXFy8SKwCXURWNqA+tjXL0FreWjOgYyd3QRPAFy6BR5iBjU44NXKOXDmABWP4NF4YOQDu0jXrqEs1vQCzZ5BIrrEWw88JQhebArOMOuA0QEe9odEDTCKdDN+usvOAXbcWFggtQxogV81pPmp8NDvMnjtnAW0MBPvBzWBk6CryQACiAG+agnShYF3Z8IRowIoc8vQ6h/oA9AciAY8e2PMK6NMx1TxwicxwVEDbqxowqdlIKvL1a4jlphpoPbAISXL+WvgtA3u50w/h9lPB487AvPAYWC6BlX/kMLsAiJKoMvMoB2Ko6gFGdRUcO4B1c2wMhQYV0gtM3D1D152ApkUnMwCLsx+/gTNMXeDppZZWUHTl9A+TRW0CTAZ5FNF5MIMaYIMPKEMDNqC/cirkgACEGnGKAhDQRC9gLUgBGy/B/AQEkib8lcR7LUNWHgFtbb2BrmAIN8miVGDYMBC8BLO7G6wTpfPzs7MPp0axckQYAYp1z2rzHGquBm/Ctsk95i5YBEb7N7d2/U2KCDVstxjvCRqMTFWwS6Yfc1sLyPl3owOn3j5CeobLxcfJJq9J/ctbcK/IeF0XExSWHFyUDRuaNAwM+a0dCQEc/DeP4I54iY0zzyXJwrc+l85lSmTSRrDqQ/kJUjUEhMzuiZJWSIjdfxznTar0DU5PqmvqJDcuGNuZM2gy5DtNXQBW3+bZcRh8TjHTI7Lw9XrTNSRpjmOouoOCyoaCtWp67aVmnaqRWRR8F8rAgsh+wkgcOMZUq0ogXPLMnBLjYenDDRMhlglA52PgY688V+FVYrwUcxHkeA11+zgKXFQW6UK2vNHXSpzHLZFhGVyPRd4+Ym3N7Asu3npEjDMPqONK0ILf3idPB3chboGlgC2bC4DexzQqgkW2l5g91w6K4ECgFUNZLz/7NnXt+IXHdXwQl1hfk0BNH4FmkSArV+/7AdptyuA+1WXQQkRMnQN6suAJs4UIUNQLNBOG6jELpYGxkaqMWjVTAg06wD7NKCYAfkYFDWTMjPB62MuXgQ2KIHtznsuSBthkpBXxIJiAiCAGJAWkAHLrqWgwRrUFhl8WZkpuCd+2Q/Wzs8CjS7fgo8uc4GWXoNGMZlAQxVIBRl4sQxskPm7u7soE7SFD4oa8CQzojBDKdBAWUID1J0A0lnnQeGTBeyVXwYXbGAXwFa7Qmbu4Yv5wCMoj8HRgbRABgr2QNp/iK4TKOT5H4KW3byCtvtcGsCtDtAuIv5zMKughRlogBQ0AQBq64RqzgZvlXlgbb2uG7Qy09gYEivg2AGWZ6A5QlVV8IouS06uU5NADUM1yEQPsHUGtAG2hg7aQkuCRw8wRvoBAohBCVJm9UOyEbh/A6aV+xHrY8EjMtABUVBeB7r35LtFoNlctUsyjJAF5ZycoeDF16BmGTR/PHhQBO5hillb80L6M25uc0BbAMAxAx57BffLZWQuXUGe+QUP/UIXr4Kq+WtZWU+eTJ8OLkJPZj0BDyt/+wZVAIpC2NpX+G4Y8NgMtFQDF0GQKGeGrf2U1IBWZpBScjp4qZofA3RdG//586CpIWDHCda/OQnOl6Bu0h1QXwbo40hoX0ZVtYq30XGbFDhi5s2b5wwCQBoYNdK6veCoARZnsc31ka6gpfQyV9T2AB14/yhobplhAXTZMiRywBNmSUrw6AEIIAYlzEyCPHoJ21OGmOC96gIuzIAdbfvXoP5CpvcJpFFMRPUPrGYCHUGOg0/JgBdlsrBosqOsMAdPmty89BpY10C3yxxFrZ8hu7+eaCAGHpFpSaRuDCjnaDPDpo+ZUQo1ZixbZSBFJHgm6BkHB2gdsUUraMgH0Z9BXr+O3JcBLZwFrTo9fRyyjgm0+A+xKHMeaLlZqhS0twmZiLrxCDQ2lFkHaYF8g4/ZwpbJwvs28KgBCCBYrkEaHUOKF3HI5C64fwkZxbx2TcHv/EcvHWbQ3B4wWry9wSsVQIv9YWNl4JJsBW9jBrDp2NjLywua4sv4Au7TgAbFRcGDM5bgNSSgxhmodwzONaAhGvj0ImQ+EcKEdcmRpvmh0XMSZSD44kV4paMN3X7BrI0AYFX379//hqhgFN4Asw04x4BGGG8Da2VQzgE1z88jGoCw9Y0gH4MW0nGBC7NQTci+PzExR901a1ghUQNaYA6JHFC5tkbKETTrAY0aYPENntG8Dsm4oKa6HzBzLljgBBscBM1B6etDd8kkJQEEEAO0ikfPMLDJaGBJVgketrp3BtxeBpYkQKcCc/b1CzfByxWncIFKM0uUmOHlbQQmJV1Qq76RtxdCQ7IOsMMMHeTjgvQ11SHrmUBzJTqwJXkakJgBlmNZWV5HMSe0YFGDZaAeuoBPG0aDl5FpwPLiSUgZBolnBQbQWIbkN+i2tWvAOgcyiAps48C7mpDiElhzSVy/fh00NurtDV+cCR6XAe3IlEJsy4DHDbBYC2EFDW0+eACKGpZ68DJURcgOGbC7TkK2BkHaz6CVWeA5QkgRBZrcLAcIINikgDhKfEALMdAiVdjo7jNI9S953x/Uj7mE0k7R0mSHFmbA0qwIvH+0uFhaOjBwXSCkCQCaBqiC9GeAMYi8zOw1dO+fNlJhBi2vIAM1WdCC7OhRzAKNKIAy/SIJX2QLbomBPAUuzDga4OMNl+E7aLM04AvXziIPzCCNMvP+6Qa3yqDbZZYsAe8nA0cQrFAD9mtEof2af//+gVYl3gX7FtqxhuzKgg13VCLWnnAABCDaalUQBqOo3bCmj2DxPQzi4opNsHzJquIrCCaj1pW9hSCuivIhtjWLSRCL55x7t9WxMNjl3vPbce1lsenP/OKD7+/sushQfCTyFzlgH1oyTNjdozwZy8RjmU1VUxzRqegVhXNiwHxqFfReBQK+JRVNxcxshi4/QIBrjMYAawpodQnWV3D8q3DzBi0eUMEkwWheAyTYh2D779RGYFx5NgnJxWQiioYP2Q5L2+O/ZEEnxQwnVm5WYbcK/kHDie7MS51TWmZa3yIImLk548vWlbVeWTfL8nx7wFLDVgMUWAn8KFr/Po8HqmI+13UclMIGddojC5USb5nm4q/5C0C0tdsgDMXAQBM6KiSyQVbIEkgIiSJ9KubIOGxAGykp+EgUFNmDIhU+3xm/AdJYvvh+BRKpGITUtXi6yDYz5XjPyE4kELc9V/sfuqK3DCCLEkkHFamjVAHH4oi89bJQoGn8OBvR/1vhBIgAmKfNA31yQaTKf/OnXbF0NGABwG0yjpTYpcx47UWcSh8h4TdW+YADdBCHmZFm6+n4PKUzwBeY0vH53DUan4zHzHZemDW0ZvfvdG5bdmXtXa4qL6NgZoBBAWRdRlTDZdaX5DuoD8A14znvbcF+sN8GPwHEAN2SUglaZA/MJAGgUqzSArIwBbze6+oZ6CQSuGW/B7TYH9j5nwSp/g04tYDtFHd38FIMYDMStIQUOlQBXnYNip4O0OwraLgCMnWmCdsyM6kE2DKTeQ3azqoNGsIHbwCAdF+AIfINPMEpCZ0dg0z1Q2MJrAg80gWdTvkGHZ2EKgZPt0DGWy6Dx0dBEuDOELicgkZNKwO0VwGdCgJW/7BxbEnYuQbAMoIZXJidBa9x9AZt/9fjgkxEuZ+OKRVzlF7DyuosN39JGHgTcyJ4gzkIZLNBtmWGsBaDalrw5LMlJ2QPF3iJNag54AtLkPBd75eBWWfBAtAOyIYGgABiaGi4d+Y2ZIEXqBUGWcvBwM8PjDgXyJob/vNPQb0+UKfL1/ctpAn5798JyJ44FiZQCxLUg/nz50+vVDFkmAKyIB60gVdqGrBQ04XsgJMF7wCAzPNNYkzJvHPlyhXQ4i+kkheYjqef/wgMmKyPwD4F+AgAflAJBOlfgJpqIDHQMOd0P0j3Bhx/5yASD8FjKtCzA4CKwWMhwNYXeKSS/yFEAFKK3YbsJXSB7M5mgOwpmA4b/gEvngX13PZARnvAu6SBUQPdCKgJ2TZTar0OlACd9/aEsYH3/ecu3gcCZmZm4GMZ2LiD58uB+56NvG5uoPkayNAUsBgHttRA3a7HsNkp0HQ3ZBs3P2gC7CHI1wABxABtWVcizYfA5kFAqwicoIv9IWdjVN+9cOXSLcQwBTtibjmwG1whIm8gCZlnnApt3VfBzvDQgjQBJgHLsStX7MH9dUSDGdEIgyxiAK1qg5ZD4N7HecQhGtBZFfhg5BlkxVdRPAOa3EGe7bkN8e0CYL3SAPM5tPqHD2FrAGN9UTzEfaCDMzJlZEAHHKg/ugFs9ICrGjdg8e0I3vu3t4cbHC+5wFixEQEBGxszUPQ0ZW9eMl/OmXUNqMIBHcgA6s2BlqZ6I819YzsuBAIAAgjYrmZgcAFtUwJVQiAOeIM/A//Dh+CkeA3cNgIfJAHsyqiBtixABmW0QiHNMmB3GLRHAbSiF5RdgLGy0Ng4hBW6CU4a2HAGjb8CS9s5okwskN7MiRP/JgELsluQAQBY1X0S3JQEJl2g1eBpZ+iJGcC6+TJoNQ2EBg+lPAQmbtAsATBpgRLZQwZ4C+fZs2fQzdbgrgIsaq5C0xukDAPNKsIkwItXwRM/TyHTM5CuP3jCB7SlA9IUBeYa0FwzeB0AF3giQBYybsbKauwsB4ya9cB4sQHHy1YHB4etkNjJXbw+ezN3jxzoFBOxIujoIbjM8AZtG7p5E5Q4b52F9OYgp5kgn04AEEAM4DIDlJVfXeaHzPZevswPqfXv3z95Enq4x1HtPaAtJK9fg1ZkwBZcgdvLoLqwF7zYGlqULUyQ2ysHLGNZpcG7FiBRAyzNRKNjm8FNSNBk8+vXr0EnzPjqeAH7LtDZZsjpN2fgB2aA2irgDbILbp8B0gtA+7EhRQ+4LQMZ7boHHu1igM5OV7aC1taAswG4iGaAKoe0fM6cge6IhgtcBvsYVJlKgiuiy9OvSUL8DOpl+krAuwmXrkCWAaiD65pQUKfmOLhmDQFlms3ZucCI2bQJGCsOQSDg4LBJBBQ3ucBCrUfOGJhgwWudwTuHpoAPcznhDaxq77wAlufgpQleoIHiRYveHYUWUaC4AQggBkl8J3wgrUhZDV30CN7bYwlaPTrH3R284MpRCjzj2mGMMlQBGuArlpbaFihmfRxxIBFkuALaKHsMdNITyDQMbLU5cvHTAC9uYJuZYWUtLGPA2jCwXFKJdGYAnM2Atg+XgQGSAho4IP2aa9NhDWa0qVL4WhxggQZK34gJZ2BRLup2/Diwp9ARspcbVP3nAnMMJGIKQQAYOVs32ZjlJrYA2wJyxsC46QbFDGjexpILejgFqKWWCV11dxG0Vm6GPbBFhDRUBRBADNDq9xssG4EbJ9DFVqBd/sAO12PIxpM7JZPADeYbNzgtwWvLTh//kgHq84MySwdocA8YJ3vBm66dwdtHpaUdHXtBG0mAhRm7piWogfLvn+LrS9fv+vrqgAcjL0o+ZABvtnh4GdjqgGyGv3cPtKj89r2Ge5Cq+jZ0ABDGQ5JAEUewGUB7hEyB+acSvNQTtt0WepjAbVhUgUZl/KC7CYFFyTeUYR9QEQ7dCsfsK1H3FlS2gdec/QMfp2MJGtk8Xrou1ViuB1jR5JqBSrKg5Xl55mCQl7ccGDkiNrmJbMBss1cuhFW3Uez4HOi8jR5owN0b1PkEnbsCaqmB18qBVpCACzaoEwACiAGpEwEet4J0XrQR8yCgVj2wz/76CqgvA2rUI9X+GdLgpjJo/AhlxzWwPFsDbDhP6/4DbAGo/pKNjtbiNODi0vNWlAEtYN0D3Yh3DRgn4KHxBRa3IekZ0R2GrDJnQE7vRAFg5CywaC0XLwBPYiCNy4JjBOmAgdvQPgRsfTTG8AJsZxpkE7qvxB7QPhpgtwG8UnNK6Gwm1SJHYPGdsJJtbZMNMGbAESMkZC4Ejpu85eC4+d/SwtazN6Q448uXX6D9NKCogUwggmaprlxC7BuBz77DxvwAAogB1kMD9xBOQpILeIO8F2h7PWSXP3i9tbq3nmukAXi8FXQSDmi3FWiWItXY2FkODQAzDWigBjyCdBq2lgTUagSviwf3++9Dd1vzgwoo5OAPgPd6wUubW8G7NKGj5qaw/jGoT4zEhvHLOTi+goahoFsfyg+0WkC2FaShRZ8fMJ+c4z8Dqv5BKxAgXSmM4Z+TkIXCsGHst48lIJ1txkmnPgG7DRVuK3h7U1mde8KAUQOKGXNQzIAAKG5A2cbGJjebLWylXEKqlNhx0MQN2iwVsHEBPkUCfLCbjhd42YH92T3QpT4AAQSLGmAjHlQLIcpY5nggULsE2oUC3gl3ApJW2KNlZX/+/FlV1dgIjBZgDQNsL8vthY/qQWuakBBpyOJ4N1BRBjpd7YOe+iTFlMePIUdlgPod4J1XldARV/B+PzADOlYEjhuQYDl49S50hTaRABSroIlDYNQwPKvkAC9Xvw1Zxw5uHtxm4D8H2rMDyS+grlQWdJDtJGKsB7p+Ezw+cRKyAxpYuOnoAEue14r/gPUt6OiZRuniecAGGjBqgsBZRigOBKCR4wDMNdlRYQLAmAm0fnAc3Hg2MICPHl6CrOsFde2ug3MMOLxf3Lnw9i2obXgWIIAYoF0WUHzNiH8H7v6iLN8CtUugO+GmWEJXKIJ3W6+BdF3ABRnSkCu4CdDREQjeBABasggeyfwHyzDAguyNAqLiDoBmEvBMhT50vEgcma0PO4QFOuqKoQA6xbEbth4VuqUUdhQbpJBzQmzAgTUm4KsxMLbQIDWGFJAWt0uC+r3XoIudZGT0uELZZb8f2dYBbDxnm21yKARFTVycIRCAIkcIHDe50BYaMGoeuIPLdWhwQGaprkACGTSGuAd8MMQVyOpf8I5fgABigM4sSoDG+ffAjtU7ewvUkr+TmcI4aZL3KfDcslZoKGy6Vay7G7R2xBg5XmAlmTOwpQ9asADKwMBkomkJHvufBNrKJCGhrf0ZPL3H7+ICrrbTEMEOm5aAssQhm6+BoL92N2QzNnjVyW7EpAUoIyFpEoecbgSLHfC2H6Dh4NLwK3iMA7T7DrTby+X2ZfACtunAfsy5a9Ay7CRk/ca56ZBjCWDjEPygiIQOE4CHCq5dO/nu8KL4+D0Sd0q8T1gyucUEbpjPnb0PWNcUmgsBI+bgwYPAuAHlm+UOm4C5BtgKCEmVQupywlpokxiBnRFobKQwgrb6guqeS2A++MBJgABigGQRxAIU6PItUEEGWloGHZCB7RuBzbaCusFI+UUAXvuD5o9A+3vB7WXQUOupSZMUwRkGVJBdA08gXQa3iyFFFCzd90NOU1MCrymBhHYSaPGCMOSkIqX+mbCVc0pY+CDVQG4tODogUQXJOeC4MTUNmAisbhig7T2kqAGXaKBpoWuwkxsvX4V0vZ0gQ8AuoCMKgI3ChnYwAGoFH333JCvrPvOeKzJ6U4CRI2Usx73eRsQhDxQ1fEAAjhvzvCBg+xmYa0DlmSMoakCHAUGjBtp6VgQWa+AVbaAtpeDTi0BxA13KeAkggBigCxtgy7bAkQYallAEdWOga+B3aEKO8gQWZODZ1uIQzAwDL8isi8D7SOcwxYK6/nrgvX+wlVcL+MEdigD041WUlKELsCCbrvvhp67A9vJgTJKjnykJOZZtJmQxN6xAg5V65bDDBZB7R9PPX4MPoMJOS0Fb8Q7exQtpbYBbGRA2qMoCLXz//Dfe/t+HUKafvazOwNoGETXAuIFEDbCu2SyQINXdDRp6BzaGNHfAogZyUiUMTCq5A9peCgQ3IcflTAKNTAMEEAN0YRUM3HmRAjoXZJLiP1CGAe31gy7G/HVcDFyQOTo6SkEOJ4Qe6QUtyEBH3wFLsu4/VaD8AhrLA60yZwRvVWSG7usFdtZdgN4rABVRkNMgwWt6gfkCfH5HeDr4XCIe8FJSyHk4oAWkSungdXKQJfHp4KUloD1AoPWMkEhTBikCLZyfmQTexAVUsBtRP0EaFbD+zW3QUZOX+WHNAMiGN3DXSuHhQ/Dxb5XQ3buQlgfSBHA/2CrQtn3w3O8zP7/zWdpqMh+YVHmlBNaabS00jzM8yAeJG3DUbBIxawFVNaB+N6iB5qlpqaWlFaoZCmqv6kFOhDlx6tRvSOEGDHZg+cII22XKWAIQQAywU4nAkQbOW+AzvcAHlcJ2yFTMmXP8AeI8LynU87zA50atWQM62QPcjZGFjPvreauDT1fT8QLX/AtArbFk0wLQ+Srw9VX94PVVPNCV77A91qA1cMuEkdb4ykPPX4HtXwSGPWx/NlwRvFwDb69Lh8/YwqZs4eMKHPdcwMtlQY1nUIkGHh8CAegsI2SCHuhMUEJJVwLZA13VKr9zZ1kZhK20f//+goLk9jNP7r9X52SJSQ1uElkOjBo+OyCARA2wEWCWCOpwzuuQaqwCnzfLxAI+HtVTcwrk6F1wB+cUUvZBAQABxCADWlJYXXcHslNrEvjACD1Qrx+0qAyy0MrNbcUKyFTMGlgHE2ntSAjoPC/QgYRivD9/qkJPj7jxARjxkIIMtFAJ0nUBrxlBKsCEQVlkpxUIQKLESkVFBcwGnX4DEQSHTBkwTHjAIWQFjT8rHmGUuINtAQISoCVc/YjlQPr6BeLg/g38ZBTQPAf/mTPgaSvwiCmiWwU5Mwl2uCsUAJ2XDwFWSGCn/DLlmeWtDA8l9yh+it62l80GHjV2oKjJCwK2zxLZQO2z7j9F4KiRBR9YoQU5SBRUIkFLNzg45T0JFgNAABBADIqKkMwCO5kIciTxlFDIQgzIopFG8CoMXXBzGbTKCmWkLARc84vFxICmJMDTrKDd8JCa3wtYkD0EHaoKzC+mkHOHlcHHqQFrhp07oTFSlj9hQj4kwKdOhUYSD1KE8ZRBmOmgeCyDy4LjCnIuizDSrvl0xOogxFHToBNSICM5/KCJKsiIJyiSQJNW96CxYgo6/kVcCZxPwM6bAAT5KmAgKLhlyxZBQUEgAw7m5vMIAy06oPD57AdV1p5cB/O4g3YmJibgqAGWZ8BM08K9d56xVG8jL3hlxBxR8BHW9ZPrgQE8RQs82QuekOSClm8nPnz49OnDB+iRagABxAA9KhJcK8E2LIOXx4IHY6pAh3gHSkuDD/GQSu1AyzAhxWvW6G4DNdqBHSpgkqgHWndCTwa8EA625tqi8jZ85Si4spaHhu5UUB7hAYZv/ty5+bAQh+WeqVaoABZhWGIOdgoI9GCwZbhPZ4Wdzw4/DBo2egN2XhK06cEDtRLoLHg0bFm1alVNDhDU1KwCgRogyMkRBDlT+ADDUZnY3rbFQUKGfCazZoGixhBYngWJ2DRtXgLsfhdDp0XAh7x5aoLPFwcf9w4+UhQ8iw+JG/C5Q+DNE2BBgABigFVHNyJB6y81NS0twScuggZjfgILMWDArwuUWlPMCjr+DnSe18IEaP8FNE0m1QtMEQ8enP71C1TBcIGGPoF9mDvgBYonTx49ec2P4TaskACf1AlO2qBsMBUULdBABhUVZWXyQKYKPLzzYfEFz0nQcgSWcXjQ4wtY6skLQ5t1kPoIvrERcnQd9PSU29CJgttQUOnSWg7pQoHbIMBkAbQaBMBRsmULNCpsQWAjAnQBuTWrtsydy5PU+jA+NKPHxtzQziQiAhg1fIag8myrzeLsKIEEYNvIsRGcadzBy4mYYpsh5VEsS7OlpuZszVDLegNOKNDS2gFqxIEiYrYnQAAxQPcigNcrM3mCl7yAT747fvxBYwawndwBnrQEzVoCcwl4vTV4WHmNtCOw1gdW+8fdZEXZ2WdDlouAzlV9f30PdDfROdA6ImDFD2kmAxthoMADBRwwZoARAokCFXD9YgUqPcBFB6xwg0UNUAGMVsm3gkSVFUoWQ+Qf6B4U6C4UZeXaAnDrGXK4EGTV1u3bSFMOoGYwuOMKrPrKyuDVHThWtuRAMgk0RiCkBwJ0AcHGjaDIEdY/936O3L48Q7tZEeCoOQjMNMCYAXY3wwQSwPNox4+ruoMWUIAW2TKBN32B1nyBj4JnZ2ffATlBFbzcuB5Y8AA7K6CzIQECiAHWpZwMPcDDHbQ0tooXfBLBOticcirkQG8IABdu4M3Mx3/+dJ8TDTrwBzp3CRuMOXryG3jJHTjDIBcUKOkcEgxz56pA6XxIKQKmraAxBso9MAX5cF1QYAVVCIstkMk7dy6F9JDABRvSQS2wE1PAczUN0NMrISclQo/gKdsJKWXBNQswq4Azim1XFygmwDnFAx2A4mzLsmcSWhtsCuPAMRMxC5xpCh3ADWcBOdC0FXzT12nIOdaQg8WQ7rIAM1AutwAd1Q8QQAz19eC5ZPboaNE5c+acBgFVyIGEoH2i06RSISsxgK1j0GYr1lTQ/tFt4BGy479A58uD1pW7guZTM0tSVoPyS9bHJ/z80/2ePQMmStDFA0lJkP0i8rCSClxW5UPKrLkTIHxw6INbQZCcA8tBEMbUqVMnzIVoAumC0SoTplrthNZbUxFZRxh21DH0NH19fdPWSsgSVPjxtqB9ra2m0AMThMFOA6UCSBEGzSvgfAKJGCjwQQbHgMBjY42gsOQktwQR84Mm4IiZBa5oCoF5BjQZsHcesBoAbYKGbS86Ddk9CC7PgCBaVFQ0mh1y8QgkippBh8IDw1VUtAIggBhiYectubtDD8LiBa+2BHX6Ybve1kAyCziuurutQaOoqqBjPEWjIY0M0Gwd+OSyiyclFR4yXHVxaedAnA4NbiuHyyMXGOCYAGeEfKSMoYKFnouceyaAyj0gDauMQALwYhHChDbT0pHOz4VscGRgQJ2rAU/qgN0GOo0H1B4DZpacnFU10KwCKbCwxwoYgMq0VVbiDxV/9pgFGcKzDDBmgPWMGWi1E7BLEwKsnqUcwUdYIPbkgdYWQQo2YCkFPmwEtLMVmGuA/Y5Y8KI+MAAIIAbIeUvQpWQrqiB73kHrLiFnEUJPJASVaIGgPmegdUwFuKz0ZIqGbYKXgSyMAbfIFKCb4IB5BnKxDWzEBdwIRm5fQQoP5AJNBYUBZYO5U6eiKgDFKYSdDy/9YAUatDcCPggB0uWcCD6q7R7ioAHI6khTUC0EbiuD3TYVHDXAHFODXJBhiRNQbgFGS47g1GXt1SeYWM2Wx/GBswykMIMOa7KF9YCaAKDVEZCZK9CxDtDF+qdBp22Cj1SAtg3A91uAm27QyAAtuAQIIAaQElX30zGgpWSNjeBju5ABaKeorq6jmBjoIGLr0hjwUjfNUFDvxRV85i3oxFvQAdGgNhmoE7MAerpaOaz6V1KGHaYGq7CRa31o2KPSc1FiZi6yOoSKqdCKaQKoOFNBtO2AsQI+s6U/KQl0VFv5gVZwYdbgchs6Cw3aq3sGXNlM1C+oBXf6QW6aAKr9YTU/sCDrQo4YUOkFySqgCqZGcC5P/zOJSSy9YWYOoIYZuP6HNJoLgzbZgDo0wIomAbxxcA1oHl7sT2NjRuPPn4jjkkGhDz5wBNJ7BO8Kh1wLoXoasr8SIIAYwPcrQPe7S68BLyIPlF4DProTtBgDlBvBefEnsKsPu1BmdugHcCF2U+0WZIbO/76kAnS/CnjBLvLpauDBmJ07oTkFOUOghD8OgDWOVKD9nnxokYjUFIAUaEhL60EjAeC5VNjiNNDA2bXp0yGjrNCjLYDVDTCx5MMiB9FKBscOrM63tV21Zcvc/PSkAxq39DQbBbJtQF0ZO1BfBtyZAQ+cgbIMaB0N6IoAyBojqe7uP6CtLMXFuo2gbSwopyeAjrSEHAYNueACHGeQWgUggBiAmQGYF1S/ZEiDVhkCu/3wkTKpQEcxXughvz9Vf4FyHguLZb0lsCcLGutXlLmkFh8PnsX2yjp/+TIDaEHY5TOwOWR92JgMqKkEaZnCMo0KrD0MqS3y5yKFMKy255mLVvFgRBkwq+RDWIi8COwdQc9vBx+iA546dXG5ClpU5+d32wW8aStLErI/BHy8uoUF+LyeWmBbgIcH3KsBNgRADecaKAAVbcBu5pYtoM7/sgIOPw01PZYY47BckeVCcQf5QL1/E+jQjHnecvDEZgtoTa1cAngVHiiJBzo6goZSpEFVAqhgA29xtY5xA1YrwBIOdBIssAEG3mQBykengeXe8SJQ+xgggBgcQWdAN4I6l6AVY429jsA4WbcOfIw60JjT4LEfUEkYDVoSC+wO3XgEmoJhZEx5/dpebdFRDdCGSuTbVMCjg+CoqYVeaAM75ha50WwFjZoJ4BiBNZinIjWS87FVQmj5CRynKGUZ5Ki28H7Y6UbPLl8GrS77KHkf1HJ8ApqiXHT48+fPixYtAm+VAg0kgY5VesbRCgTgOAIB2HGWoNHsmeIFprf5nxxVk+FicZMy7mmxcSgUMgTHCji7ACv+OGh+EbEBl2Q9PQICwJiR0gVHTSB4SwuwBS1mbS0G3XMMjxo3eIv6NLQYA2aYxsZGUOgDBBADL+T8QdDJneA1mOCWMeQ2DOgCd9A6ZS3QkZLgWl9d/ZQ64x3YJTKoZ3mBF7WDb+oSh+zihU/BQE7vRBp4Qe6WIIO56M0ALDS8MJubjzKSIww+Z1cJlGPACz3Ae/+ArgNtCpKQOHvrlj0SuHXlys27d6uBALzLkxl8zNI18Fa1a9euvXnz5lpWpxezxHUZ73+fdkTP4XVMCMvO3bo8D5xXwJkFkltAxRiwggEt2TRrWhvWJyAHumULcokD7EznVGAUZTRCT7OuQjsSBn5jD6R93KsLjQ1egAACFWiOUsA2hGM39NwuSJcFfGI3U0VsdDT4ziVgbonkfHQKtFP0dUrK6rcSEjo6/hfvw5ZQX4bOIHKkwaJGPAnSr0A6lAgWOeDCDcyE1A/QAQFI92QCuGszFQxUoCVfPmzIANTPgUUFaOjRigfWwhAGD5qCSzFQOQY+Hw00lXkNfIrpnuugw1nBmxtPAQGIPnHCFQRAQyTgAfoboB19kO3CoMMAQNs03GIebOsIkePmbkm02eSw3BwSKaCqBZRbINkFGC154BVnZrngxTPwDYMbjFNTwc1baSnwAU/SurrAwAU2p4pA+/PB58HAK5zTp48jRU0jsCW2DXQNF0AAMQSCN46BT/YDN/DAYA70ugXLyZPBF8iAlumCbrd5DVpFJsEM2XwgCar6QfvfwevGoVNQmLP9kJNvQIepgXMOaHyfB9TzEBYGFmBWkEgC0+CxNehAGbTVAB+TAUUiRHAnTHInNC+CZ1WgxxqYggqxr6BlzwpvfrwD14OgW2q8vU+Axnq5poBGRKKBILYCAtyOfznS+BMYIj+PHNkGbJ12pBpv2NDW1tYXHMbWkrsPsoRJCDx5aQcuwKCxAooWYGvMHBQrIsBYacreHAbMMKCIcZYDjc2HgBflgxvO24Aha73OEbxRTwpxpwU2AO5S/gFtHgPFCEAAMYC5CNmf4CkfaD8UPGLJBTnBA7St78Id6DgMaLfXfchmpKuwhXzQM7EtWg8o9cPPWYFNDYPyD6iE27l06dIy+EwIaGoKQu9cKl8GG5EGjbVA2g1gGUh0gC/7gJ1hLA+JEvAw9rL9sJ10yaatoNbYmzfAOv7NtXegsx1kZCZ5u7pGcoIP+fGMFgW2j0CbgMAAmDg7OjqMjY0T2gQE9u7d29PDzcbW0pJrZmOzaasDaCmmOXgdBh84q5hAahYTyEzZwTh4rQ9sKLNtjlqyJFgAUoqBBn3B59QUw44QAq/6Bp9o7Yjc9cSIF/Bh3YHQQ5aBAgABxAA7M/4n6HYf8PgbeOCAhQV6PoQMuO8CzCzX79b5+kK2KMPu6AQdEgI7fJmDA3p5TCuwaVaLlG/g50ZBTikCgmXLwiG1NQiAmm/gIIZd7gEEQCaIXQaNxGXLILqUIdMx4DFlEFBSmjlzZkEy5DhUPz+/6Q8fXtMARokaCFyRUVQHnS7NHg0aglJV/fnzC+jQZdDABmi6XE5u73zw3X5s2YuB2QO8zh8YIcuhSzDj4iCTyZBYgWQWO0hmAS8zywPWLiLg1hiwnQzKK87gUxyKQZO93ZCrA6SldR27ux1BTQHd3kZgXghcJ8ZbVYUzao5Dml7QRjGQDxBADEhNbPB0QqgWePQTcUjZJdBGA/Sjw6Bn+IBWO6BfJJOWhq1QQwOgHrhwOqwrjnRqEfjyCNhEM6hiT8fYmQ1ftQkaElPgvwo5yejdO8jFEqshV32BxtK1okFn5AP7ebyO3eDBc1CUgJYzrly5clfU5uz163OBeQSy7wKyYFlICLqUDBotCABeJwNexATMLJDapWlt1C5wrQ9aRwQZNoHlFOhZaLyIphVkw/GD4yQAgABigAxWq0L2v7JADsG+cePRKe+SzEzQ0puziLPcke7BhEYN/0MFp2ew1fiQLYeosQNbGQY7hQAWvErQCiIJxEiHLBdA3IKjpFRbux8EdkOOLYKu3zQ9AGrhtrq43AavODoHbEhpaGR5eelcXLQo/tatFykpKcDa3pUTdOFStGgFqPACl1vSwEIrAZi05wf3gG9a3Jyd3dSUawaKFVi0IGUWEOBDAaDFS9BVf4WgLQCgZeYt2VFh0LtmwbOM4NFfaXgB1giMEvBpG6DFYdtAB3Hy8hIRGz9BRytUgKoTYJQABBB4oIbJEzQx2gys8DlvgIYr/ykqMt4BX00BPv1YhxlyExV4Efu1a5B995BtFwsgK8khOw4hNw/Dsg74YG9ID+fAAfgiCnHYwNbu3ZC4Ax98i4jHctiiIsjwCgcHsAJxuX0ZDPxAJ0o8efLk48mjhxfBrvS9fv0O6CBtvX8ftn+CzJsD+9ZuX4ClVy/kYtJ58+Tmzw8GXeMXtpkNtN0Skllg8QLeD7McsioWvCwWHDeQlX6G8GWy4KX/oI0ZNja5TdDO/rwNCcbGkLtopk0DNcF0wbQ0aH/gH9BpCWAGqIz6g7cgQwVu4B1ioJkcgABiAG+vBBZi0G4LaN35JPB6/uvwQgz5cDLE2SHwHTHQ4UIGBtR9LJDVzKATfyGrWifC18/qp2EC5NsaIKcDI1+ojXR+j68v+KD4W2qgy/BACxpAhyxYTmbRhJ7lswK2xCQkBHopafChJUuWgG6LBe+DBe2yBFf1mzaBd8SAIwey+wKyllwInEFgy8qBfZbCwuXgWNmXC741G3KVOSizQLss4PIKGPy80IocBSAOTkIdn8E89xLa9QSv3tcEdSQBAohBE3xWNzC3gEoxdcjdl6BTSa5D48ULem0bIm6g1T8/fH8YsIEG2vQCW0x0mwFp6wVkZxj0qHnoLTPgVgP0kHMO6OkElRBTGi5DNvODzlp98wZ0bsB9/4t//4I676CNpCXgC4EZoefETZmyYwf4pjimCvCxq+AtfMDmqnQxeHmJgADozssw6A2+sIgBAzNI3GzaCinPgAUaqEiD7Y4BbcEA1SigDUxbgeUXqNcCrFjCwsCXmDsDG3WgZti2bY69f/4Aiy5g8+vBA+iBbw/AADyS8gB0iAIkYhAxcxrSOVH9Ce7PgJlMkFnln6BdyEyggy+j2UFHxXFGAgQQAydk4yeo16KoDlmhpKODlmHAy4Jhx+qCDqzgh3T+nfiR9kleZUC+agmxWhI1J319dpnhIWStBGQNxW3wHcT8DyGmTP948vPhz9/u3/8MObMOtAV59QvQWbOgawn1wN0T0M094CvIZX+dBvofNK7R2AseYILW9HLzIYsXe8JWgq9Whm3nX79+/f+mpqZEMDADRQ949yUodrZCIskByobslbWxMVvclA2+mRnYCnNOAMZKKmixHWilZDeo6wHOD+CjeIkqqiDb82XB62Hc3E7D7usFD2+CLogDndwD7kdCVtoABBBoAhpS49vb27+48/gt+LZYbeipx/CDYE7CjreGnH3IsAC6DRla30C2TF8FFW2wEd4Gl6ugQ6UgFzK7MADZV10awCcyAyPWBXzWLejin2vnYCebamRlPckC3Zh5S82o+u711YyKiuAePBAAeybArgkIzJ7NxOQGOZlYtYr3z59u0NAhdKUv+Lwrub3gJnFw8BJucJUPBaAbyaEMaFyBtyyb7YPEEDLYt29fbu7/7LVrs8GlFzCj7N0LXjxULN0B7TLCK3VgX5XI5hbokMdY0AWkoBYjiA06AxNcfs0Bnc3NBL+3D3JyjyIwNgACMHW2OgiCYRQubiQjjblZ3LwRbZRvUnSzOrkBLoHgCBYLGzfiHTDdcGIn0zBJ8pz3+MNbgET4tvP9nfc5dNQcgzs2AkMgmagX4lTsoSomZCFBpBCz0LqPm2+HeG197j8vvSldzVg/HkfhFXP4qWnkvJeT9So3/kN5DFX1hGJtz6zZpQ2mGo2uY/AxU8c9jxe1+bLndvg1tkwYoyizp9focGbBMv81FmHEkUSYXSKFXX/QJM65A8plGZ8athhFNgYXbGQxxPEgvLwoJlKvNMXPCKfaQaQ2Oi7pJUt9WeaS0j8jUTUYkiQhtrckqGbELdaCqaP4WCe+rws1XkLPV+YYFGOobbE0vr0FEIM68lVxmFvYwaftXMZy6jFkBTfm+aRIB5hCL8dDuRsbtr0Iekcv6JCRO5DLxtURtydDlp8Cm43gYpiX9yfknt5pwAZQ6hro2WPz0PYoygkgnd8DZIAvhgd2BYHNs0PB88GrsuEAWOQFHwICcNYCXyLPDWVA1teDh1pCQIf/dHeD5ychEQJbriQrC5ubdJcVBd++DR1ABkcN7IAryEHjkMlLUUgND56bgcwvgy99gqysgS3p5AIvtgXdd3ULdA3FBYAAYngMBHcen90D607CLzqGHXx5HnTS3mV+UEwAQ70BfDwl/MhY2CHLSNumIaeXQeMXciU39OYk0EUy/rD9PBJGRkagTW/AOh1Ybp2CrDOtB+UR0PnQkMBwc1tR1QhqhYJWJxhvAN8DC14/CrvcWg6xjQQM9s6fD94hByqE9oLDmBUUEZDyqEOqowN8Akgq+CRGY+OFC0E76oB6QKORkOwHruAdISM5jeBJEcgsPhMkEGNBi/s84TTk+nBPWdXTp8G9kTnuoBV5suDcVAFVBFqCUQEd+PIErWGCaoyFnlPqqWkJamAC4+YRsGmsKANe6Ay67UobIIAYYP3Ji5C9txrXYMfCgXebQDKH32Vg0+kceJ8DeEsKsL65PB1+yiL6jvb7Fy/ehx4LBzuBFgaAUbIaCB6vvpMJOeYOvIyXC1Kzx4JXwMU8eACp1kGgV3oNK/h2XtAJPZAABy+DF0Da1gNngo4gg0Sds3NCQgIoHqGrs6SLweWRmBioLMwADZ+ALzbs7XaUku7oAI2pgNbUAZvcoEIrBnzHjBvoOCbRaNggL7BtDjrKtRl8ezCEBi3EnDzZEnreGHjJbCwwUUFm/WWjwdeLQA5WBN8zzgKLCtDiDASXHXxoH2hk/xHkRHvQXEW1NugeCIAAYoCOv8CvvYCNv8CODQNfbX8V6XB4LIcLoJ0VhzhpEQZAB9uAxqwlHqdAtvxMAvVGQIeK1EOOHwQWApBbX0Hni62B7UVEKoGAMQCpN3r2om3rgS/yRTpgGTJ7Du5YOPaC+uS8xI6OQE5ub26GXEKFHYAGskCX1bLvADKBHE1YmMOWlXmiLTFjYcdCa0IMAgFgxECuB7108wLosDTI/nSAAGIAXTF8FHZGqB/k+B1Qt+UqpKaXVPCDnBCPdkg4tLyCbXKHntXnBT0x/jpogHEP9EzSu3frLryAXLXAyAiaKnl04wZowTto5FEUNDIP6pE0gm97lQYl9YQEWFurB1yDg/oToBo8GHTgWA8sakD98QRjyCGxIR3gNabg6xUcGzNAs4R//kD6FqBV8hXgeoEJZBeoYAGPf0AZ0HIKIghSUBHNolXPBQGgrt4jV9cbN0DdPiANFeYCL6oMhcbcDlB+ArYdd+wAstjhMaIJZ1iCahLIekx2zR1wBiiKQRU/qEP5W13xtT0ww9w0MgJ2JCHnVp88CRBADEjdSVAFfgZ8JAj/VZerFuD2MfygZYzMchJ6kCviaEvE+RRnwZePgPe5wXftnIIsvOaaUq8F6ZWo/vr15csX3kbQxp0OcI8EVK9DSy1Q4IObUcCeXhS4jl4S3AcvuMAZCdTLmAaed8/YJmYNBYg5J1XI3DlTNLhkgU4+gYum2bNBRRGYAboPAFj0sMAUAEMr8gZ0YwWo6AcBdWByAq0dUldHbLcAb2+tB12e4AmdBAZmgB2QTDIZEiVaWpZgSWjmAFu7Qwu8ww90ipKWFnxfJ3geDFjz11WD1otpwK4BBQgg+EEo3xCDyZKQA6mvXuaHbqnzu4x00iIwQjSg11HtAV8aukfC1xd0/DGQDSongeAuaGvvLbW7dzNB53PoQeYXwWenQla6g7bsgCdOQGuqwde8Q4Mb3IGHHMYXBunHA7OJQF8YuOEFPssDPEICnhSBLi1BzG+chgL3X5Dj16F1L7C/AC43gOEAavsB8wSkEYgCOGH5AboP6fdvdXXQeXIp0Ju7QKc6Qfa4wLYsgbctnfgQOhvSI4GVapqWU7hAUTJbE0TPBkeN1g52UHcSWKMCBUAFGUgt5KILSDcGdssg9AAu6D0JAAHEoADdew1uh11l4AdfN/YQdDrYefjOevDJitfAB3lKgmNVG5JB3j6GXHNxHbqj+hIog4AA6IAqUG7xBlUpwLILdApqvSWo1+sG7rCBdh1KgysU0MQJpLjqAxVYwMhYuxbWT9y8GRhDPaDeyvz5kM1vwLod2MnIcHT8AzoR/gF4phyUM0RFRUFFkmc0BLCDzyoATSSDChvIIvwb4LPYQcWHq56eK5DBGQlbnw8a0z11CjQ3Dd37Cil9M6+ADqgHMoFV8wtF6J5lb9CMA1ClHmQTDKQjPAW0uB9SVGlacnJxgqwF0uCoATLAuQd0zbMlOzSlANsAoaGQNAuePH7xWAI0FwZsjJ28Br4+B9QnBAgg0KiKAvTWFpSzxuCHg567hnmmENIZyteR9rvDLruC9E+gCQt8WTV4/8Ec9y8/eXnBlyIsROyfhtTuwO56FHRIBdx3h3Q0lhyC9E7AW6xCwHtFuyEnEoDW9YImyUGzl7N3gMt8cIEBKmU4oZkEkjk4IefjQzbnQW8I14O5UQ++GxkOQJkEfG3HzUvQK26hF3lOykTcXQ/figTdV4aZD0GlGLhgmwI+bwGWe+ClH+cUzFt7QJ186OFuwGgBCMDUtdsgDENBd6xEaiQ2oGECUEroswA9qVggpVsmgALkxiks0TKFlbt7dpIqUppIdu797Ltz5It/7gSMc1skfNsJYUhuJNUbplgqoGPve7nyoOgKiFnfRJkwGl1p7vhaovGo8YqpQOzVovDw5KJMv9P0ETix9vvovW9bX3dHHflNeGGx/LBx4ol5/V0upfIwtq6CPCYOVllsCFCtWeEV4R/POa+WPhMdepGpMXkuHtCAOlIxYZ9irFR9jnkpHBTCfxgSnhQTvK4JfPrISJK4+HgUSxOrqeukS4qEoyLONqvhHb65lpBnLxWu43O2hvlZyJIm3SSAGMBVCfjwNoWHlyGzY9BjICF3wYMOOjgJPQ0WlFkev5B5DZpfA9/Mi+RQkFtPQZInyOYP4L4K+ACon5Ath5AjxMFbpwVArS1g9R4VBRvhYstuWd+yeXNUGGyoBBgxcuDOSUgHaLmPWBGotwEZMAcNpYHLK2j2ABYmmsCiG5h6uULBW1jBCZoTvNMLiLxBaQZcnYP3qkLrdgj9+sXNm6DBU/AxpTfPXrqiZgRe/QQ/5d4XdPDJLWDFuQd0Azz0ypVMuI8hu8bA+/fBl/Ho6YFuiGMPBWYm8DgspHWwA0xb7ggFXy4I3b4JOTUAaOAeCWYd2ChM1kfQFWTQo8UAAgh2Whj4ZDCkKZjL6CeEXUQ+HQxyuzX4kis4gJYP0IMGgOWMJ/RQ7lLrwG3bwBHjDC7CgJklanP2//Xg/IFSkAHjBCiwcmUwZJ8oMLNM6+YFX84LuybKc/aUKZDyCWl/Hbg0gRVg4MVLSHW1N+jw1Su34Hdy3oTdYQMuSWDXcl+BnWh8FHH0/UXko/Aveh0FrwPB7WskJ4DoUGgTgJ0dqVDDdsI1M+qZz/Brc84ABKDqjFEQBoIoKghCbGwtYmthwH5L76A3SCMp7cVD5CY2OcIEUlgEAuL0gpdw/p9J0DRbJpDd+X+GnTczB+nbr3GeXrcCnKy7Bdey/UNQQfVBejrnkaZQFAU3u+jCBDElJfS3bXyuoOWQB97zuRxJ3PUIRomvKtTmLYzdx8OzgOy7uKA7kQxiVEpM1OuaHsp2osiPg4XBEKdNSwjz1LO6D/tjkZYAVlP0z3tQ3T7dPSrgFn34mBifV4zzJoopToSs2sq5q73qqwR0oSThiS+Js7PMYAnSzvv/LENoUK+EJwAPFSWo5pT556G2nIPr9Liu58QWtRAZDubzzjl7vgKIAXqi/W2LBeBr4Kc/hZ69yw87UhdR818/CzmOA0ttDy10QTULE3jEew7k3GdHyKHCoG5IMPgoZOjkCSi3rG1qys1NXA+OmzDo8OL8NjlQt36Nrq6YdcxLd1nw/QOgrYjguwvgAQ5rY8AE4OIoKsCbvSEHJNypuwus1W/dug5pt4Cv5gDGzt06pPsgQKkXdgYatBuNMqSxB9hbu7Vnj8TjFEXwBD3oogtkt4DOSJuN2sk/gWin14MaKFAnA+s+UBlaVy2BuH0CtJIfsjgZejScE0AAMZyBZiHoKbXgMWPYiconNWDngzNDT0m5iRQv6uAz0kAAWMDOBnWEQT06yEASqJFc9KcbfOojeB54/qEl3LCJE9BalvVNTYnQUgxSvYBayaDNu6A5kSNfQKOETOATCCCXD0DaVqfQIgARNSdOAJ0AuXkNpgaUYTLvgC8UVAf1G0BVBvKdQ8za2rC7IRB3csJGxbUR93zAz+0DtoEgB3KCb0pVnIS7QLvhCk6lwOYAp1YoeEcTqOcP7cdA7x+7BD5zE3SqKagvowCZfbyNfHg9QADBppDhp4WCLm0BnQ36DXIHBaitDb2H6gpS8wTSBzjxYUooqMkBLEghAx7g+2tAkyqgzdPgJjK4GwlaMsENbXxFgVYZgSboE6EtMTDoEUhISAVmFvD4omg0C6izACzEbri6ngKXlJA+gDesIIOWWh8gPSawn8E9DBjnBKR9DOqcAF3MmPICUm6Bzy9Evr8IfCnERcgwE6TjfVIDcl5+FvROYQ34SZzasFOvQIvcLgGbpaA1uqegRRkYgKdgoQxwfweUW1jAozKQbpUepIBNeQE65xl0UO19iNVvQEew3IYf4wranmRqmgwQQLBmAOJgHRf4mXqw20HA4y6gKQSUggxaD0NGIpqhI0aysu5uoI2gsFkVOfCiL0hBlpgIOpcafIhobiKk+7JryZIloP4kaMxFCnwmxS9gIcZuCQ9h1NwCySnw2h7cFde0hLVG9VCaAbDjecBnsF+B3vwEr921Ma/JQRwxDbmXE7k4hzeCkG/5hIXCCWj/5gTo1HTQGSeQ5skHeGHGCe9anYKeWX/hwl0j6L1ToINYFsDOeoXFBPiKboAAQj5y9wxoIBM8kgnKNichN8KCrjoENuchF7fCmsiwvvAUS0hBCj4vHFL1g8sx8GVu80BTVvODw7hh7eP/60GgBZJfokCXIoCrfGPIAWrgc7pAeV8L1IWf8kEPMrwDGlt0hZSZoPp0sgGwktXUBA2mT55sqbUD0l0AF2awxjSsUOM68Q80bAga0AXV9I8fQ28VBN1XCZ2aOok0THXtPOya52uYk1CIXAM+VBh0pCkQTFKHdBcgrRBQIcYSCkoiUyzBt1pxwuIFUh0D4xHYLgNXc3XPgdn2JPh0fdB8/JkGyKoX0K3p4GVeoEMwTAECCPmQA/D6CchdB5Lwqy2ALUZofxg8sIRwDOSqB3DMgC5yglz49BO8QycVenwtuP8CWvwFLsc2A/su6/+DZ3lBDTHQ4Atop8OajEbw5ivQnWKaoEIA1JYBtsm4wGtmQBM5lpDeJGQCigUyQgiZx5oM6TeAB3NhQ7mwEg1UADLKvAZv2IDcjsOMmP04CZ2ZOncNBs6dPw864RosgC9qLtzMlGFERA1SC+3GDVipxokEoAXZCVegc2RkoJfogqqJ+5DVSX7T+UHH54MPnrJoBUUN9GQQDoAAYuBAHIsMAuAp+5PwS2GhhRl0qOIUvEThRJq1AE2CiUIWVoGXkbJC17UAK3/IJQjQ1SzQMZhdK1dCp3lBp+2DL7aBri2B7qaH7JoHHV4EHiOGTm+wA8Wam2Fs+NwtZE5rB6RVBA8HUMxkZkKGVxgfI2bWUa75mo44EAWULi/DBnYZXDCvLsZZoMHah7BmAPwsE5SmJPiEWmiX6iysVfYNfHXObQsn8DXwaQHoZ+8CBBAD9MBjcMHmBx3qBA/2g6ZegN3LF6Dx/dfAwgyeeznBh6SBRoTAYQTZHApqKwMrGUepDvCgpTOoa9kHLcygy8Cy2cD9yT7wxLAz9BoE8GohVchuHibQ3A2ILQoBstBBanAMQOeAwTMvsaDt9eDhGrATQDUteGwxFFTdQnLNKfDlV2dfrF4N2gzE7AUJYdApU7DrFMB9CIvKSgsL6KHsYAkGcJl+HnxXLvgOUEjx4QW6knuPGvjehzuZLyBl+ymkNjysLaAFHiuCD0jAYuiUN+iKB+hlfdoXoXfp8EOuzQNfmg5eJglZPwxdnQwQQAyw1WKVkBtcwDEDbdC/fXsBfOYgqCP9+xRS8oAOXMGTL/icIfBpA46wkx8hayjAyyK4YaOVYSv7+kAt5HkhHeCrXoERs6IKsQHo+PEvsOF9dxg4ffzLF9AFIyBrQMvpQMtY3MHz7hVzwFfisrOD99xDZ3ZR7sd9bQ9sBu2BNMdArbCjGln8l8+A1mAtgDRH0S4egK7aegW+TQV5lgpatoNOjkXpPsAGpmDNkxOc9Vrg8VVQ6gCywYdrgc8wg87JqEFbhtDLPkFrwKCHwwagrBOHLGgFCCBEgQZSdRt6eQysi3kJchYxamFmUK/FrumJmNCTlT0NufJBtxi8viIEtIoFslgFEi2bYYOVAnLgwUpQ16URutwUuulqHeigVdAFBPCLopGWm4KzEWjIB7qM6PScOZARTibYqhTIdLElbIwKdDIfYwqwBHkh8/pW/GfUAgxx//ptxKGP8BPuoZIKCkjRogG+gPTWpbN7wEECjB7wnWknTsCHoGEryNDBKcjAKaM36MDe69CdFvdBG/nOnLkHOuzrGewqW+hxvPpIJ1EBBBADZIFrJbhHA1o9BrrwCpRrtHUgt1q/vgTuy4BbZJCLdULBhQfs8A7IlQ9FoLJMuhi0xgIyJRYMXhAWFrZr164oyGClM7gUAy/rAu2H+/MHtLm30RFyNqE06MIb0HqvjOPHURZDqrq5u385kpGR8QVlBv80eCUYUwV0rQs75OSdekhTCTxyCLqL/cJNNbX4Re+gd8P4Xb16G+n6h0rYYepIALKSlB9Urn+DTGhBDvAHHSB89s51WF1z9y74Bj/QvBtkdRZ0MFUPacQC3OuHXmyVAuxagQpW0HZR8HTYQ0jVDynBkM+ihDLA5RpAADGA9pJZQK5uhQ9pamggcg1oyBZ6zjO47wDuyzCBIqYZct4Q6MoHXvj9NZDzUmErXoLBC8LgMy6g86ACA7dJg3efgGjIKWuQY1aKpWE7fNFWowIbF6ANxMdRsxNs2z3sLAOcQ4fQ+73A/QeL24i9QMgLf2/D74RoAN1pL4l6ADS0GfAWWPOC53DQmwG4AKxrBT5USQK2yRJ6ynVlJTCTFCAdWJ0E3d8CP9MVIIDgl1lYuIA3DIMvPQD3/8EFK7AV7+0NPZaLU8syFLLmB7TihwkysHwcdO4zMJShJ9mEoEQN5PYH0Nagjo7UDuhd4ryNoIPTgZkGtPEadPEAZH+dtNQ29HgBreouBUbIz5+NGeDt2ihbUSBrX0DngoqCL74EtbbB02K//wFLEfAKCHCUPAGvKb3Mzw89hhtyRDqopVoOPmgYdpg95AIVSHPgIT/0MPt3SBOH0MLsJqKuQWmhwech4MdpQmaBQLcLx4Ob3xcvXgS2yvj5QQtaQeeRiEPP1929G3VvF/SMd4AAYoDcGwIueEEn5J48CWkCPAZPx9zJBC8Ch+3yAi9vAzaPICt6oMsUi0CXhsKjBrJ8Tw6+vsLYOAS0aV7XEbTmC3wzF3gfqRhoc5DuGvD6WPAdN46gU4jRMgV4xX1j40/Q+SFFYuAdESg5BtRUA10IJhodrWUA2goM7f8zptwB3SapDRlo97t81cXlDGQUygK0CQiSWywsDoCTrCnoSDTEhR6glcILICvjpz95kgUa4rwIjxpgan1xJ7OkBHQsM+pULiJqkHKLogzkVO1bavEXQff0PAF2mRTOXwYfSGIKPlgRdFQ1dLMX/N5aWOGWBhBADNBD9kCH61w+B8o10H0sdcDyFDRnBC/MgO3lHdB1VJCD0yBdGfCG6l7oHTag66nAa/iQjkvdBsstf0AVPi+EBh0ZCS3UILdYY9sZBCrAMsC76Ht5//yB7lfhRYoaWcjiFMgGx0eweHksAbtHEtSHuQYtQRgY0HYugC8dsFgAHhQ50LoALnEbVL4rIC0pBqZW+Fqhx5ApUXAPHGeBBo8a+L3jb8E39cAHlkFW6wMz8H7wnfX9iN3Iy5QRJ7iIAwTg6exREAaiIByw9gQpBfECW6S39xQBbS3tRLYUb+AxcghBRQgipJBVkNTWFr6ZeZutkiKEkGV5f/NN4dbb2DTJwhJWNFHNbKctvLe+yHFxjrENg19TVTsxVVzvvlZLRstCZwAgj5Cg1LVA6VAcj4mRcLmJXTQNoDo/e7Isl3SFEjZnkM9jlHK7YaZECd7eQm2IiGkjiVdzhnioATxeEAeBKv12pQNSGDlswvSSaZ0FPPaVMWYidwjR7rsYBBrIyzK8T4J/4eWqSu9MYQCr1j0HUlS0ysMF3umk3ThjgFM+zVb9GWSlxej2vKcCoPVuHsUhPYjrMSGymCBriIgdfQ3Oe/gLIAZwWw2SnkAtRtBltY9B8zKQy2r1wB1/UJQwQfsP7LD119BgBLUAoLuxgbU7aJdLR0hIh5RU9zrQsjDofelg9eBVzKogGlxBgben8ILOiwKFtirqmROgYQXwFdJ/QK0LcL7rBUUtuMIB91BBK7pBt+JwgrajnIJMKwMzDHhvEDPzZ41roFXB4Ks3X4E3ljCA6l1g5IALEsRoCNJ1OZVIl6xd9oO0Bb4dRerTgBbWAdOr3j/4fDsipwAb0JCMewqcayYxvsi8CRrFhFzTC75wGpxxA5ILoIf3gTYVA0sw8EbjMsRh1ZC9/PuBbQGAAIIVaLctFkCiBtgWeXsXmGFfMCqq/4OuhWtGGhiJhawkgxdm4El/SD0OLNCkIbtQHCHlzunT379DFmqLzoFU2rGiSBvlcGxwBK+vBXVewZUQtClXLB0IOamCF3yNJDipsFhC75FmLLlz8wro+qP3sHMNTsIu4IbvwoId4wzOMqblWG6/gcVWA2STEPwCjvuwiYS7d+sQk1WnILmFE6VPAxIBzftlZt68Atp0CZ4JgkzHLAC2LL6Cj+xHPelCHnSspDD8sGpItQPe6A0QQOACDZRkIFEDvota4u7NKy9kJp2CtMuA3RjQ+mvQuYOgvh3o4lpwbx12WUov9Ag1UG0DXkoJWiIGuh4NDECtJxbQjXygURXQNgDwAlbolhRgiQjORZCiEXx2TlERaJuZbq+jI7ALKg2JcLCpoKNBiiBZD7ScxhJ0vxeo2v0HmpZ5cQU8l7wHevU6eGfQOdA1nPwM8P2KkBsCIGWEaTniUHs4MIXdrHyVH3Kq20Pw5izw3TXgmAHW6S9Ah8f/Vj+lh1KQcSHN7nl7T8oErWB7cemsWjxk9TJokYxFq0s76AjW3fuhF1pAzvuEHXoFPasafMwS7IBqgACCFWiVoI1mbyCtM1BTBH7zNju86p8Dr/qR0zfoIDXEnlLI0Y+q0DraE9zShq3WhgFNtC0psIPbwKb9AbfEkTo+oGu9QEeyQfMXKMOA0spkTi7IrQknToE3CN2CbBA6inSuAfTaa36k4UNT5LsgkAFscAR2eRdkVAAYJOCwhdxIevPSJfhVdji7MphLy05Kgg+IhZ6pCDl2HXqYUhn4+Pd01ON3gaWcEtg5AAEEjxoLWNRUX7iTAt6spweeGwKPk0WDxhrdUaNGDCVOEPtIIUMo0eBDCLRA046hWpBF96AF2yzw8VBV8AgM3DRVaM0FWqoGPk8StM8bfGhF4Lpu6L3rkPMN2MFH7yK2o4BWjt05i9ggdBRyWTy4i3KVH1yrwzfNw25QgZ7MXY44yQB6jDq0HX37XgP4ZkhQ7xs80OtbXQ0aOwPdYgefctcEzZaB1gOEToE1moGVDGh/zBWocz7fPwlu6H3lgKUGyGEWsCPIYKeFySMfMw46h6S/tsDUFCCAkJoBCgoakKjJBK2U+QCa3QVNkoCG/N1On/51Gi3TQEe/IId3QOMFtCkFdE1LKGy24gSsNwYGoEs9YOfhq6JlQdAqWVDUgE9jBe8/Ax++I+0I2d8NPlwcNKPDAlmgeeMG+JipW2qgMb67kNVI8K1bCg+hA5igCUNg7T8RPCICOz0PdkBLP9IFOElJsOuJIN3P28BS7fw1SchMzZ6zd4Agk5ER3pcB3UzGzh7KBWSAJpemIO49AaWWS9ffSuiARlQhe5RApyrq6xdA7tuB3h4BO1sPdBYv+Iwq2FlJQHlQG3om0D0AAcQATSt+sO6mNjBqSrzh4zHg7aCnidyaIgvemtIMvqvtBNraF2jx6InRxoP1LgNBW+9h54aAGn2gA/jWiYEKM1V3WXBbORpyRDXkWDZ1+LKyW7BC/Sj6VAy0qwItTZDPZUEcoQ4H0PshEFNXEDO1QevPFBXVURfUghvt4O4eYpoI3DJbDdtLdh/YbAe6o+EeuNWRBC/IlskvRZx3ORV+Ahz8OGT4pT0AAQSKGnFI1IA2kTHvuf6CEbwvCXRXfSxodYw74TgBt2bBm6/AY783QCcN/gNVh6BJnlOgha2QShK0bgw01AO5qBe5oVYErP7FGiHHIML6SNu2iZUWFQFzzM/jsHiBbEc5BZ5XBq29vFB39+6e+EWLIKn7qMaT85AdvU4LGOAjmJCD88FBDzmlFXScEfSMKNAlBCABZejxtsBEGgDONOCp+IfXIE0AYKtIBho1p1y5gHl/Mqi01gwFtkQgC97BdwdDFuGDVpbrABsjP35cU3ACN5ZB1kMPhQOXVzuhF0moQA+0BB1vrQI7NBlcnglDLsACCCAGJfBNOeBcA4wZidUpwPIUfN+AJbjm/044r0DWhWtaslhO5gLfIwxexTop5c6FmzdfgA8jmDTJG7YmyABxRfFp6FmFvNCzjEA5BnKOsTToGDEx6wfQFpk7eLeqFmfkCfh2FPC0MvhEVmYvDdgto1lPgFX/bXAHE7XTnwQdCkkHhxDsNhx5eDKG5p4kcCKFDAmAN7GCuxKPYevswfPulqCarhl0xj9kcSYLaH8G+AiszAtnQftYzkow+1+UvAa6bxRYluqDDyGHXbUDrPonTIWdgIjtvF7QAYk7l0KOd1cCCCDMqGEERg1oSQZ4HTkRhRh0Mwsow4B7GeCdb6C9mlcgK+1fX7l+IRN8PgaorWnACdpi8+sXuPkNHSYDF2S64FPdQNv7gA1ncMOiCtIiY4LciAPtPOiBjQetPIYMgMBaZRpZ06eDTyU45wc7QuIrbC4EemUO6EovyCU4kIPxeEDnrEEvV4Gf1w0q0CpB9e45UO97D+jMldevFcGXyoA3CIEmEOF7OXdAd+5ACljQ2B1o1g6y2P8MfCoG0r2E2AjMKBNgJ1iC7lkBAtAR+VvmzoXeMTE3fwIwZsBRAxBAoKip1Q94Boyab7CoAV+lC9oh+gvUdUEqdqqQ5iRBXXzIRKMneBQH1MtQB+0XACVptet37949C71zHFyDekN2pMAPKHODVGDgHv4f8AAp5Dhk0FEvf7pBrXDI3nxZ0I5JLVCO0dP7BzTAG3QDC7DbAF3MDz7WCASuAcNj+vk34KMKIPOGiJIMcoo96Og1HmQAOpqwrEw+HDpCAm4hFOiDhwUWvLkmCV5JfAd8uTCwVAamKktI4xLYNwMW9KBcA90zcsPVmzEFPCXz+C4z6AJ4BvA9fbAbEIEVO6h6AZ/EB4oaWA6B37+yZRX4ahxByOUfoEN8IV1PgADClmtO3eAEXVqLWvtXwY9Qg51PDF9kAT48DbRaFDzwB7mpXQKx3BPWgfaGNi6QmwGQnhFs5BJ6Ag/4DP7TsGNCwNtRYKOX6ozo/QYNtFs0UeZCkpCqfHmUG3Agx+OCTvYEyyHqGvCczfQnWZAhzdWgSxahVT8LdEAEtFFIFnzfOHSJGbCaAd03Dp7mBl06Cr4RxxR80jWshkE7Dx4aK6AzpXNywAzQ5ThQUVClA4obgABMnbsNwkAQRBFEuAskZ0ZkJDgnoQhy6yQioAJEDkI0QwXYOMTBJbgD50iInZnDXA33252bnTfQbtnPj9W1yNb2uK5myfgsBRNq/Gub5yEER6emLEX7sGKMcdy0Jd0/nElAdhox8JQCmwY/83Bvd12vnZMgPWQiO13RfXIeV/43/LfURCxN9oncmm9+GIaMtsdtFNn8QC1GJLDKXu8PcX8nKhRKonTDqOKddm+6iMgqYBBAEIDq3LZ1/SysWJ2yj2Drgt7ZalWEMkAYIfeMvHHoRKcJWEpZYPX5iNiDZ4zZ6xddZP9lcY6wDyGKmCiNe81xgRDEa/XAVwAxgFzen1ReXu5y9Y12vIwiaC//FGDehU0DN24DH5GO2N4NO2wdfCgBqFH/AXT40CRGGXvIIqvrZy9durUHevuqxJ6zL0DrT6A7CSA3fCJFzQNIxFQhF5enoad9s0B2NJ2ArnwADeXevAnKk6COv442bJEMCEheU/BD3NkIbitDr8xBnP4NvzMC1E5VQb6PCFLTiOuD74UADc9Innz37p220d07oDqSKxTUooSNh4hGQ+e8Y5sn13OBx2UYgd2rW/GLgDnmoZNFayv8iqt00LHwYOutoBcggO/52ALOLfDbPsAHsXd1ddluhJz2DYwzYOSATuYFCCAG8NDATPBN1hrazJDTXUEL/mHnrGSA202BwPbSceyF2Y1HkCUSqCdBQralnIUu27oAmk3PxFKgYT8RzBO29x5SYAAb3+CiElaQwdYsg4YOIad/MyCuLgafmZ8Evf0JVpqAChLky2+s0C67gRdmDQ2gKTSNz/HAvgyolnkE3o0BucUENksFmyaCFGYlmeDRZfAJS6CblKAND8j4Cw/kvgMVyFHhKqB7vSC5BPkGKaTrikDRA7pkaguo4gEIIAbQfVfC/eIHWlv5r2nHv5ABRY2mJ3hzzHHQyV6gky8gpyKAzk4FnbMOKmrA6yWBFTSo8j8FuuTx7l1Q1MyIh9wAD1qf8C5e7SxoGTio0r4kkzkJsuUWsuaDiUn112nEiTvgw8FPzxEVhRwX4skO7vyEQjYmg5rjJXfuQO8NvQ67Ap75PrT6fwja5wju+ldCZnXFgT2VZcsQMQO+RAXUfYDcrKKCctI95OBu8BGSraA1YfxPsrx0dG6+AFb/6uBV3cAcIwo5bs0NNIgI2tbLxA65+vTEBz0ZmZtG2l5eJ8GX9D4DXZ0MujYSfPcY1ArwrS6wy722wE/Dx3r/CuQ2qY0bbcFxAxBADJC75JTEk5PPPAHVNSD3sIObAFXgkUsx0FFs0CbAaUiHn8US2IQELX83gKxfAc8s7lE7e2tG/CJtL8hmLi/4+iBgA9ReRvEfdFrDoB50aAD4QCNYZ/Y09PA8SF5kB6VIToN68PHS4L0B3qCFj2rg9RIX6uruInrbsJqf4ept8KRuACzJgq7LkYdc8LkTwshHvTIHepw05HZJYNSATlO/DJqxugYsOYwgxxM+Aq8c1gQmU9CWR/DmuDmQlgk7S73BDWDDB9havBQPW1b2jCM5eSL4oFFwQbZ0J6IMhbbDIDULMGKgF+P44ACgiyVqgFUOQAAxQG4xTE8SN7197jMwav5BogbcJPuzbl0g+BxpKUfwONlpaDdGU5MFegkXZKEVeLQkPv6dNmSvnTacXgRbVccIXfsJrGzARwdA5m7muMMWA4KyIrjPAJ2GAS/tcgXGCWgOfBK0j3kJ0ipD7IYBxwusigmAHPcJrWUgvQjIMdGgS9ZgR+Qj3asprAwfoSkvb284A+z9g1vMe9RmvJ50AnxH2WTQ+l4mUVnwrUugiSdwVxO0OQG0CA3cjwEmEfA0WSVHWsF+0KXVoNtGga2OCeDUABqIgdb6kOvwQPeveOCJF0jUgC79WAUQQAyQGybllWsLOJ7eZz4rA2ygWYKi5idkyh9yFhiwx4E0VwI6NKIePHT5D7RJ4jmwwQzqnMdre/n7g+5QgKxCAe/MAeYl0MYc0Lwc7EAtcNRALnGD3DwFmppjAh1SAT6aBzKkcAK0w9+bEbJ4RRG0uQ60KPU69Dwd8G6Y+8C6HzSpC2qqQi4+06/t74cceYvaZLWCDiQi7r8DX+sJ68sAI8bF5fL0j1n3ITuJLtnL/APFDPg8I9D5cnPcTkNutWZi0YQ3TbxBFysw35fsPOcHHt1O09/dr8wDb3TAui+g/JIDuREPXIx14Y8WxIVSGzcCBBADuLmmIr+sHxg1nf4SmaCoYRKFXGWnuwYy8QuMJF7w0K8ssNEIXyfBBZ7Hgm9dBbWb/EGljAbaCm61W/BpDvDIIPL8DeJMFyRT0S+vZgT1G+4ijpqG9WVQb5nQFxefCb3DW3kZ9OYCK6TqHz5+WAa+bhUlw4AHZcAr75BmqlhAS4Zg8xbwVSKghg94bejdamDEgLZggC/C2b1bKR029TIVVvXDCzJQzQ+tXXyIAeAL8gACiAFY+G2ZCyzQak05np5kvjRJj6ueRXQOeMwfdLJ3se42MeuiInDDFjzxC22bQFr0ior24L4MsAsDuvLxIjPk2GFIpgGVaPGQFdywXAP2Mmj3POgcCk/oimnoOAwXbBs+bLD6HzjioX0Z+GnTkPsLJSGlyJkzDWduV1beBg2KALveoJts02GXGYJLFug8CHw6pAw8egjJMLt3609MTm4H3wgtKXnyInN13R3QlAywx10P3voImrr4Cb3dDDJVBHaoK2hTNXjr0g9Qb+o2aMhfqR984jsPrF+pglKQQZpjREcMNGoAAogB2JbeIpgvnF6rf/vcu3h7UFaOFXUDrcfcBlrLArvoSxV6Qh67Jgt0FBwyOXEFcjIkaJgRaV83LGogm4YvXHgOWuz4D7qWHTSmYwk+BQnYIgVfGsrJGQm7DBk2tQvuCEHyJHjJ5C016OmTF0HjZdfOnefnBx/teRs27K+PdLsEfHB9mfzOMuilBGWQm6XBuQp8nDRodeDtM5CC7PNnbW0jI9CaTG/QymHwhB9kWhfaMpOFTHqDJptB2zGqdcBbyq5BYqagFjwMVFYGtGsqNGJU4AUZJGZIiBdIU23jRoAAYgC1pLcIWgkrF4CjRo8LfJTMcdDi8mLY3Su6jZAcDWpDgQ8j5IIWZuDNeDL2M0B3DGmgnYt2EdqvgR8w8A8x1YF0bM8JtGNK4IUY5OgE8NDPJXBNhrK9Hn5dMLAvE4BYCgGd4IV3W6ANNNgd0enA/LIbdIMqaM0qaPcGsHsJWkMELnSBzWXQ6OEU6AFziGMYgXEkGs0CXQF4Sp3xbDzokB/Jc+cuf4VNxcAuXIW0lREtshykprIPSVHj4QEQQKCoAbbUpgorHWDQOGp0BdirYZd1iwEWZqAtTKB7OUEnsuvygton4HoafLAq0JXeoEo68wVk5/0epHETcBV9EZJrmPeAN+heknkBqtC9IecLuLpCTgDl4oJv94dvjIVuWjnlPQm6P1ERMp8LWZEB3bZ07eFDhgULoEvGkO8xVoaMAIAv+ygDXbdeVsYDuUUFfEUn+CB2U/Bp35DRZckfn0EO9ZW4/gIYL//+nQKtUbUEnU0OXkwFbDaCTg8EHxLIAm6V/VMH9rGuM18EFacKwK6/KXigDthahs9bIobIQHcUQ6/EIy3LwKIGIIBAUZMDyjVKrQoa2tWZ3lyanr8eiAVCFolDTuUD7R2DRg14uBV8DrE3Uvfc1xdxFwQ49C4iCjZgzrllfwu0VJhREZYZvE+g3OUOXZwCzjXgngxiyz9kW8p18J5wZtgWewXQZAhkFHNiAWg+BBg+M+GziEjX0YdDb4ICrSnWh2YW2DJ00IlW8H3EqxnV1cFDfOAbbkBnCELGy6DHMM4GHz8DTDsg91frQNrLCyxaD4gnQa9OggxkI2p/6DhZDfR6Yh9SAShqAAIIVqAt60+ensV8Vv3TDk/ZB2Ji3eCoCQFvutgGGuU6rnraHbLsG9qfYQQ2mmFRo6MD6suAO4InYS00UJsAsoIb3O28Ah73gBwTg9jPBSogIMscoftVQIdYZILPUMu8AD7VgvHFdfTq32kB6MJAyHwIYhRzGWJWDHRBG2jtHRiACzDw9W2QJV0MFi7tZ6Y/AR0zCjr1UAd0dwd0JSb08B/I0i7oZqpY0FZSRA8OXPsf/QY6cBFYv8H6UJD8Ah9VBhVmW5AazOTEDRAABBAkalSsltWantfe8+JUKDuT+wPwRllnyIaYDimpddZFwCbAz1+yTNFaBgbQJsAk8OIvUHH14uwe0Nw8aB/qRdh2oYva4CJtj9otYG/kbd1b0PFIr6Gnp4ByA+R6LFAJAWkcgw6thSxHZQSyT4FKNNACFmCmAZ0U9vYt6PQYYK379DzoFPUFDND5kALIqD/oGuNlyqDLVUCFmjJiWgy2ugxpe5eCwpuH4HMBvKC3RawGNx5PQA5RgdyzAB1ahTbuQaOY3sDmoqIMsF0GrP5Bx12c87v8FbzaLx1lnG4urJ7ZAmovwy6R9CAvZnwAAggaNfL9pgz391yaBOzTuFVlSEM2MDuD72IDnXbMexzSeoRmGkjrDLSzGHKoALwZANvsjVygvQVtk68DjUEjtqZAV3QjHVgBawKcglc6kOVl8AHTi99QVmOYIiaWsQNx5AKs4QykAwRakXnyKOyI6epMjOPNoBt5kQ4xBZ0cBVryBlrEdB26GuMypC8Djhp5tLvGYRMx8MKMnHgB1zUAAQSOGmDjOanV7/NZxQ+aTKpF3VLGxnJye8FxAz4fDhI1suBj1qAOBbv0ynVISbMoPn4PZFALfDrHfUjUgOIGdtAIZFsIpPS7fvY1UDNSyw1cooHyEOT4BnCGyXwho/j69QvwtMzFi/cvSnaCzssHLcaErfZDupQVeUGMvj6w86kPulACtPwcvEbWggE0BXMNduQ0qMsPOtQNfpUH9CAE6NElkC4xOwscgM+TZXwBdDn4TP/7SCv+IA3CMmBzA+kia0iuWQVqnNmSnWVAUQMQQMAuZw6wy6nUyvBkj8wHTdkvwMJsYQJ0gwxoMwYoav6AooYJ3N2EXkUAjBrQWOP162dBU0igKABFCXhZLuhCSHALDXJQKnjABnyYyp6zkHuKQBPut25Bdu8wwqNGD7o3Esy/eVPtyiXw0nxmyKEU587xQzbGgnfIgBdimiIvXhKHX2OXBtkPsICfAXLpDf9DcI0P2ysLKsWuv3jxGnTQNXTH/T/Y0jJN8MGYsK0q4DNSwcc/nlJXfPFYQkIHMqh67SF47F8cvqocS9SsgkRNDbnVDHgEGiCAQAM1Klb7Ofw+6mS6WjL9zJAuDpm3F37cOPiIEkiugUZNpCt0Jnj1Y2AZ9Ro0D4DapzmJdgA0NOcgnagmAWsWoZ4PhbIt5Rbi+hzIqj8FULTAdmuj34aDsucecsMHaLMQxsGUsIMQoAdSgqPmH3J/C3EYAtL2Q9i5/qDrlBUg+3NhPdx+fAUaeMSMrGrGowtYmAEEEGh4M19Y30/y4nVvy1i37lTjDfODoTckgI9aAtY168QeHHcXhU25ngLvHS25Ax6feQ9pAlxDnAMBzEOQM+oRcaMNbVeDdsyBhjyBfR1gHXL27B3IYUS/f/8GNZUh5T4oCwFLuxlq8Rd1LoKuz/n4hJ8fclkEtON/+zb8Npw08Jwx9Hoo0A4ZP8hNXU9AFT3QCe/eQc4Ago4gQQYvL4HXroPObEyBbeyGngBUDz2LkYUFct7PCfBOWUVFmRc3jYyAGQa8LhSYe28jogZc11iVITUDILEDjBqyq5pjwKjZaLtqFUAAMeTn5/MkWfyIt58UKhrTndrWd2gJ6KRY0Olk8+WcWdeskQq0fnD6F6iVPxncOgOd5fXi5k34eCMzym0qeIAGBIP3qkDW2ly4AzrvBbIa4+bNmy9Ah7+A99hBOv8aQARZWrZgAfiEdvB+bpRdMeCr7GA7ZaEbl8EH7MEPmwNX+cx7JB6DagrogW7g8djXitCtGEjbMaE5B7ahGdiCBPm25DmoZQYeUwUfhsnBgcg1yvLyaEsyYFFDQTMAmGmAzW+AAGIQFlbSv90pwfhoh+wXqY4EAci511FhoONK9srNC5F2BDfPQC3KevC1g4oy4MkTcBYHj2CCZsyuSyAvo0AUavAog+6rRjr6DbRMdBKoxgdlF/ABDFfA1f/rSy/uwE48Rhpght2KAzrfoJID0kW57QLa5Qg5xvWcAvRcGdiCQSDtxQyqA700ji66ZS8jAznDEbR/GHIYAqIFgryBCXrCHPzAH5nXZ88+BhZm0KOwQVNmKIuolsEHaSBdTspbaMCIqdkyd8IEgABiAHYPLmdJTOJkl80oDtnbAz4cqwV0vg/kXIxi6QzwsCYTeGzvxol/k4AtMzV76GojHaC334HuwYSfuQo9MQkKJJGiCMy6CI+b62dfMIKGlUHD0uABGdAINegeHbV40EAmaHW5BvzelfPgjTL8/KDbcUAjNKBru0CFHKjkghwQchJ0tQSwAQK6lzN+kTZkrTLoziiJPfHx8eDu1d26urvXz0KOc71y5Q7I2kmMKZmM3mgbmSEjreBBpUnApuSMGfGglsxR8AnMfn6gHYfAPCMOvxYeeoMrz07QhBB0wBmaayCDZ6S3AFaBxjT3AwQQA+jcc6NJocAGADBiuNmgh5WBTmEA7Sov1s1oBN9YNNkSVCmCl5qhLgTDACdh2+1PSmIB0JxzFulsUtAoASN4oBStUXES/VYc6NU5Z6C34yAiHbo1GDQsvegWZCwUdCQV+NDAs4i1HhBrb0KsfQ1bYo5lu4we7OQy2MgqeIXI9OmQYzoqOdL0dyONpi5Dunsc3FKDDW+CIqeri7QhZ2BOA8aMsv6zZwABxAAskWT0LN16UxOC2cARk5u7+H92VFhwMKim6eX9+fMnaNy1HroWDjTZDL+rE9jZn3Erfg/sLFHoovCT38AnR5//KAmdVQEfGA05kQBeqCGS7xUZaD/nEmhcgfkofAkzvFiE7DE7f/5jFnjdCuTSbVjtdRF+IQ6k5gNdBwkaCwU1NmDHNV+HHcoEOgAVYu3NO+ADz4G5pgQ8OY4ZNaA9IuCBVUhlehI8qspgAWqMQBqHSUnQTeWgy3flYRcjWyHPopE2TgPqzGy0rVklyJN0+6OODkAAMWzfPkVTtZdVoC9qbdNi8PV7idlro1b2CUBiBrRjJhq6gAQ82HznCuTkN+ghB68vIa8+0gAvCgOlcWBfj/8a5IQ8l6tXL2NEja8vLOfUXQCf6mF/CTIjAyqOtBFbZWA3S/w4fPjwos/Q2usd+MZB6JU4wM7s48fwi10h03pwNngtIbRpBlpcAIoaYLY6CzkSEdzouJ7CiHGqJ3h5GTDBwOe8T0K3ucNuu0ZEDaRUg0QNaO2uFawVPRd5fNODmGjpAg3MTCjjSWLQUMs8wQUQQAyysu68UgkCYWzge3fBRzACaxrwaWXgwkyUBXpwJGI2GGVBGGJRGDDgn0DvugMdkog4r3gB4jQeSaSmwNlLaOeUAusX0OTbLTW0nhLo/J54aDkFylKfQYvEQNbXQYaAUExCZl+H9rtAuuErS8H0WaSznpH2AIK7VqdOQNfKgno+b2FRA9mCiF6goU4TIRVsoJINUuXUgEu1LtwzA+BRGWAE2uYIqgD7MRx+Xte9p2gyqQIEEMO2bR0hctxsTdArK0F3uYWF9Qg4G3dsE/vy5Thod2zoFHDNeErdGxQxL8C5BjlioKdIgvM8KMeD6koGBtjtnOC9keAr7M7BD1sDlz979kDqZ9BMDHh9B6gtwQytxL2QCipwsr9+B5jC7xrtATU6rlwBH5l998IdGRmIa2AHNiOB65BiE7yOFNYkkICKg3IOJGpkZEBrmr29SyDN+FOgM6tBzUZI1+es2h7wAiFgz01BwQ98eDz4GKiAtIn6u3fXKiUlQbeziYOPAVBCLHLmyc+fAG6vwdZpboREDmLtGXxdILBBBhqSEZybL6xk6ndRIuUGuxtvxpo1AAHEALrOfTPo6l0QgBRmoKuNjTukxEpj3OeA1yqAz147AV6qeOHslUv2l9AiBrqOAlyAgQ/0bgVFRyV4Nz54vBe0f+8y/zl4zoGeOA4+2RO0pwycri+9eAyb9dEG90SA3LegvS2gpPv2ArT/LgOsml5kZoI3vby4BD/bHHQPCGRBFDTrXAJfbQR3o5cX8mDEWXC9A4waYKEFKsKAsQHawaquDj4YEmj4WYhpoPWykHwLKsxuXz0D2oMIO60rzRRlsy7S3ePg9RvykHXWoNiBtwnga2lB2QjCBq+aUbHiUe4Xb+XPYl7tqiV6eluI3PweboAAYmADV/6gaAEf8MvGHQy5clo3A9wyg17ZDW6dIRVolxDnFINq/vvfwN2Pq/zQc4rBp66CjudptQBmmKvgbgm4Q3gf0TEFRwuwjNJGvdcDciMOeJwNdPnKFdC9bjdB1+OAdtQCI6T6Auz8HvAKOFB03YQdpH8BlmKAsQpK7heZkc9zRmVfP4uyk2HSJPAkBWSIdRLYl3evAw2B7amGrXqzgO7eAXevTCH7EUCHM4HrniToYDgobvr7Ibs28/OhI2s50DVPNeB55Rzw2mZBwbmgBZrK/bXJLgxvFtkrftox50EGq1wPG1tiIkAAMUBvdgXGDOh0TNBVPnIhxqzSGRlfQGvOYlks64FVzacT/2C3Jry+cwHSPdgD6cuAGlTgFj8/P/TSYegxY8Co0dc/ADo38jZEwo//PGj4RBt28jioQxQff/Ei+ICM66CSBnSq1RVgcN2tu3AH2LaVAQ1AyoBvsgVvxlMEZZdM2Eg+aIq6BHQ6KbQsA1Y7db7QM+ahHSPw8hFoLoReOApOEpDCDlqoQYdYwXeFeXtDr4Z4cecuyJd79oAKM9DtWPfvfwO10CwskM5RA53LqG8KPRtCX78AcrF4QUEB9CACUH2UDppLWgaqgfJBC0fBewNBDHCDTrm/H6j2QCvDNW01GW+9UCbZ4xnGcnu5sxeDbqkGCCAGyJXI4JjJhlw9LZewMFWqW+wBZCMgqDA7BVvacgVRxcLWg4M3LjBAF1EgVutDb1CfODHNFLRtFTQvCV7qnXVUWxvL+cnwdesXEOOOKJM66AB0mcyFEvD6QcSkjgRiHhzHWBH4tBnIUAby/p9JjAgrIYvqoG2GW+ARQtjR8pdRNu+iDRmhj7JCL5CHLSmBdoBgixJBEcrx7Jwk6GBj7Sv/Qpl+/awCXfUOzDDZiaALdjdtAgggBjNIJQNqmrEBGwACzs4hoHOYih48AB+GDTr8HFzHIDeaYVU/+KQR0Gj9VVAfvbIyDXLASADkLEl9UIKwgCyuAC30Bk+aSEL3WYN7iKBa3hdymBWwYgfXvK9TQPOgkEOtYPcMeyMtITgFvwDo9aVLL0BHBkCuawEdbaHtBTtj/uhR1GG9k8jXIu05+/gxrPg8ewl6Gg8jbCkCqKsFafcBi8Wze7TBC3k0svinn7l8/jzoAI+rDOBzgECrrBvOnIEd1XUbKFh5GyhyG3pbOdDP4HFXl1YQ4OAwPXAAclJwJYMf6MDGN5I//sarXQKd0BTKLurG6yiVyirQE8aW2ATMKuC7qQECiAEWL+DCDDTUXCyd8eUn+NzYaPAyEtCya9CYI/gWFwlm8KzFUVCTBRwxoNMHwe4B7SktABW9kMwMGbE/YGEBSWPgg6wUoDd+wqIGfn8POJCBtfprUEMWcuvPqQ8gcOLEhynQ23gwDrQCByKw0QZucIFWwh89ijI3AeqJgDffQO94O4m4sgrJbkjUgO6zmYRs6nXo4jroKcTQnaKgk7heQY+25YfcwQA7mgMiBpoeAtGg83AfgunpoEPQgB1w/iegmTyga45+ZgbdqHznBTBSplhaxrqpfsmQljZOaBMIC8tuWrwPfA81KGZEAAKIAdqVYQP2/8G9TNCKwOOQlYrgdc2gc6Mhw5nXkSZPYGeMgS7khmZe2OQJuIiFNilhJyjBDhcBHZ74DflGnLOX0HYVgmejvfU+TIFeTQNa5wnbZYv7PPqLmOfQnwRviYbcuvsNfR4J3WqMAg3UOoOfRoA0YAQZJ4JdV3oG0XsD3yCLGI6CA1DDELRLG5gi7l64cgW63O0GaIf75OaKOaViUtJrWJ3BQ2TA1ti+ffsg0WIDzDEAAQSNGmAdE9yWALqzXexBzJw5TLHgqRnXE6cUGV8AG/fg8Qr/+zA3gk7ms1gAOf4twNQUWN0XFBQgHe0Jbe3DZuchp7I7PXx4/vzHa0izjdBLJF5kIiZOQPMmlqGg0wVAK9MtIbdzgy98Rco1kNW2L+DHJoPvfgVX1khH0V978gR0tON5SE6FDrciT++dfY1oBkAWvGeCDghkZHwBW1wHvcgGNAEFC3bQyeng6/1AU0gKoLkhBdAZQ8DcADX7M3RuCNRnA4ErL0AlNKiZCWkCTpkSuoM9WlQUfBmpo1SHcYKcALC/z5aYC+2/gHMNqCRrAgggSNSAq39n0C1LYg9OA0uy2ObJXJCds6AzxnxB68yYQVN88LTzCtgeBtX66CfxwCaDkacfwWdYLYA2nqFhAyxTHr+Hh426+m/oWYWWk6G3v7FrAdMV6E7ZZshBtMj3PyDvUNPR0cZyacM38CWjDWf8kJIy+u0NyLkGct4fsPsPbq1lXqiu9oWNUKANtYIuH4DegA090xZ6swp0TA98PjZ0IAJ0JykoDE/BpxxAe2TnuP/6dfw4bwbkHqy9wcEro9ZmN0EjxgxW9QMBQIABAA95vaR+42rqAAAAAElFTkSuQmCC',
  'DisplaceChecker.png': 'data:image/png;base64,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',
  'inline2.png': 'data:image/png;base64,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',
  'sign.png': 'data:image/png;base64,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',
  'struct-symbol-01.png': 'data:image/png;base64,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'
};

var Tests1 = [
  {name: 'color-prop-01-b.svg', svg: '<svg version="1.1" baseProfile="basic" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Chris Lilley" status="accepted"\n    version="$Revision: 1.8 $" testname="$RCSfile: color-prop-01-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/color.html#ColorProperty">\n        <p>\n          This tests the \'color\' property and the \'currentColor\' value on fill, stroke, and stop-color properties.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n         There are three subtests. The first subtest, to the top left, is passed if the circle has a green fill. The second subtest,\n        to the top right, is passed if the circle has a green stroke. The third subtest shows a rectangle\n        with a gradient fill, which has three stops. The subtest is passed if central stop is green,\n        fading off to blue to the left and pale 	yellow to the right.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: color-prop-01-b.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <defs>\n      <linearGradient id="grad" color="green">\n        <stop offset="5%" stop-color="#60F"/>\n        <stop offset="50%" stop-color="currentColor"/>\n        <stop offset="95%" stop-color="#FF6"/>\n      </linearGradient>\n    </defs>\n    <g color="green">\n      <g color="inherit" fill="none" stroke="none">\n        <!-- inherit to check the property value, not the string, is being used -->\n        <circle cx="130" cy="80" r="60" fill="currentColor"/>\n        <circle cx="350" cy="80" r="60" stroke="currentColor" stroke-width="4"/>\n      </g>\n    </g>\n    <g color="blue">\n      <g color="inherit" fill="none" stroke="none">\n        <!-- blue color used to check color being scoped and inherited correctly -->\n        <rect x="60" y="215" width="360" height="80" fill="url(#grad)"/>\n      </g>\n    </g>\n    <g font-size="30" fill="black">\n      <text x="120" y="170">fill</text>\n      <text x="310" y="170">stroke</text>\n      <text x="180" y="205">stop-color</text>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.8 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'color-prop-02-f.svg', svg: '<svg version="1.1" baseProfile="full" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Chris Lilley" status="accepted"\n    version="$Revision: 1.9 $" testname="$RCSfile: color-prop-02-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/color.html#ColorProperty">\n        <p>\n          Tests if the color datatype is supported. There are multiple syntaxes for\n        specifying the same color, such as #37F and #3377FF. This test is focussed on the \n	X11 color names, which are not part of the tiny profile.\n	Each group of circles uses four forms - 6-digit hex, rbg() integer form, rgb() percentage form,\n        and named (\'X11\') colors. It does not use 3-digit hex, because the colors used in this test\n        cannot be represented in three digit form.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        For each of the nine groups of circles shown here, all circles must\n        be identical in color, and the same color as in the reference image. \n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: color-prop-02-f.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <!-- groups of five colors  -->\n    <g>\n      <circle cx="75" cy="40" r="20" fill="crimson"/>\n      <circle cx="115" cy="40" r="20" fill="#DC143C"/>\n      <circle cx="75" cy="80" r="20" fill="rgb(220,20,60)"/>\n      <circle cx="115" cy="80" r="20" fill="rgb(86.274509803921568627450980392157%,7.8431372549019607843137254901961%,23.529411764705882352941176470588%)"/>\n    </g>\n    <g>\n      <circle cx="200" cy="40" r="20" fill="palegreen"/>\n      <circle cx="240" cy="40" r="20" fill="#98FB98"/>\n      <circle cx="200" cy="80" r="20" fill="rgb(152, 251, 152)"/>\n      <circle cx="240" cy="80" r="20" fill="rgb(59.60784313725490196078431372549%,98.431372549019607843137254901961%,59.60784313725490196078431372549%)"/>\n    </g>\n    <g>\n      <circle cx="325" cy="40" r="20" fill="royalblue"/>\n      <circle cx="365" cy="40" r="20" fill="#4169E1"/>\n      <circle cx="325" cy="80" r="20" fill="rgb(65, 105, 225)"/>\n      <circle cx="365" cy="80" r="20" fill="rgb(25.490196078431372549019607843137%,41.176470588235294117647058823529%,88.235294117647058823529411764706%)"/>\n    </g>\n    <g>\n      <circle cx="75" cy="135" r="20" fill="firebrick"/>\n      <circle cx="115" cy="135" r="20" fill="#B22222"/>\n      <circle cx="75" cy="175" r="20" fill="rgb(178,34,34)"/>\n      <circle cx="115" cy="175" r="20" fill="rgb(69.803921568627450980392156862745%,13.333333333333333333333333333333%,13.333333333333333333333333333333%)"/>\n    </g>\n    <g>\n      <circle cx="200" cy="135" r="20" fill="seagreen"/>\n      <circle cx="240" cy="135" r="20" fill="#2E8B57"/>\n      <circle cx="200" cy="175" r="20" fill="rgb(46, 139, 87)"/>\n      <circle cx="240" cy="175" r="20" fill="rgb(18.039215686274509803921568627451%,54.509803921568627450980392156863%,34.117647058823529411764705882353%)"/>\n    </g>\n    <g>\n      <circle cx="325" cy="135" r="20" fill="mediumblue"/>\n      <circle cx="365" cy="135" r="20" fill="#0000CD"/>\n      <circle cx="325" cy="175" r="20" fill="rgb(0, 0, 205)"/>\n      <circle cx="365" cy="175" r="20" fill="rgb(0%,0%,80.39215686274509803921568627451%)"/>\n    </g>\n    <g>\n      <circle cx="75" cy="230" r="20" fill="indianred"/>\n      <circle cx="115" cy="230" r="20" fill="#CD5C5C"/>\n      <circle cx="75" cy="270" r="20" fill="rgb(205, 92, 92)"/>\n      <circle cx="115" cy="270" r="20" fill="rgb(80.39215686274509803921568627451%,36.078431372549019607843137254902%,36.078431372549019607843137254902%)"/>\n    </g>\n    <g>\n      <circle cx="200" cy="230" r="20" fill="lawngreen"/>\n      <circle cx="240" cy="230" r="20" fill="#7CFC00"/>\n      <circle cx="200" cy="270" r="20" fill="rgb(124, 252, 0)"/>\n      <circle cx="240" cy="270" r="20" fill="rgb(48.627450980392156862745098039216%,98.823529411764705882352941176471%,0%)"/>\n    </g>\n    <g>\n      <circle cx="325" cy="230" r="20" fill="mediumturquoise"/>\n      <circle cx="365" cy="230" r="20" fill="#48D1CC"/>\n      <circle cx="325" cy="270" r="20" fill="rgb(72, 209, 204)"/>\n      <circle cx="365" cy="270" r="20" fill="rgb(28.235294117647058823529411764706%,81.960784313725490196078431372549%,80%)"/>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.9 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'color-prop-03-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Chris Lilley" status="accepted"\n    version="$Revision: 1.9 $" testname="$RCSfile: color-prop-03-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/color.html#ColorProperty">\n        <p>\n          Tests if the color datatype is supported. There are multiple syntaxes for\n        specifying the same color, such as #37F and #3377FF.\nFor each of the six groups shown here,\n        each of the circles in the group uses one of the syntactical forms \n        </p>\n <p>\n        The first row uses five forms - 3-digit hex, 6-digit hex, rbg() integer form, rgb() percentage form,\n        and the \'HTML\' subset of the name (\'X11\') colors.\n      </p>\n      <p>\n        The second row uses only four forms - 3-digit hex, 6-digit hex, rbg() integer form, rgb() percentage form -\n        as there are no HTML or X11 names for those colors.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n     \n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        For each of the six groups of circles shown here, all circles must\n        be identical in color, and the same color as in the reference image. \n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: color-prop-03-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <!-- groups of five colors  -->\n    <g>\n      <circle cx="75" cy="40" r="20" fill="#f00"/>\n      <circle cx="115" cy="40" r="20" fill="#ff0000"/>\n      <circle cx="75" cy="80" r="20" fill="rgb(255,0,0)"/>\n      <circle cx="115" cy="80" r="20" fill="rgb(100%,0%,0%)"/>\n      <polygon points="95,40 115,60 95,80 75,60" fill="red"/>\n    </g>\n    <g>\n      <circle cx="200" cy="40" r="20" fill="#0f0"/>\n      <circle cx="240" cy="40" r="20" fill="#00ff00"/>\n      <circle cx="200" cy="80" r="20" fill="rgb(0,255,0)"/>\n      <circle cx="240" cy="80" r="20" fill="rgb(0%,100%,0%)"/>\n      <!-- \'lime\' (full intensity green) NOT \'green\' (half intensity green) -->\n      <polygon points="220,40 240,60 220,80 200,60" fill="lime"/>\n    </g>\n    <g>\n      <circle cx="325" cy="40" r="20" fill="#00f"/>\n      <circle cx="365" cy="40" r="20" fill="#0000ff"/>\n      <circle cx="325" cy="80" r="20" fill="rgb(0,0,255)"/>\n      <circle cx="365" cy="80" r="20" fill="rgb(0%,0%,100%)"/>\n      <polygon points="345,40 365,60 345,80 325,60" fill="blue"/>\n    </g>\n    <!-- no names for three digit colors except for 00 and ff -->\n    <!-- 11=17 22=34 33=51 44=68 55=85 66=102 77=119 \n     88=136 99=153 aa=170 bb=187 cc=204 dd=221 ee=238 -->\n    <g>\n      <circle cx="75" cy="135" r="20" fill="#a01"/>\n      <circle cx="115" cy="135" r="20" fill="#aa0011"/>\n      <circle cx="75" cy="175" r="20" fill="rgb(170,0,17)"/>\n      <circle cx="115" cy="175" r="20" fill="rgb(66.667%,0%,6.667%)"/>\n    </g>\n    <g>\n      <circle cx="200" cy="135" r="20" fill="#3b3"/>\n      <circle cx="240" cy="135" r="20" fill="#33bb33"/>\n      <circle cx="200" cy="175" r="20" fill="rgb(51,187,51)"/>\n      <circle cx="240" cy="175" r="20" fill="rgb(20%,73.333%,20%)"/>\n    </g>\n    <g>\n      <circle cx="325" cy="135" r="20" fill="#57e"/>\n      <circle cx="365" cy="135" r="20" fill="#5577ee"/>\n      <circle cx="325" cy="175" r="20" fill="rgb(85,119,238)"/>\n      <circle cx="365" cy="175" r="20" fill="rgb(33.333%,46.666%,93.333%)"/>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.9 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'color-prop-05-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="CL" author="CN" status="accepted"\n    version="$Revision: 1.8 $" testname="$RCSfile: color-prop-05-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/color.html#ColorProperty">\n      <p>\n        Tests the color that is used for the currentColor value in the fill\n        attribute when more than one color is specified.\n      </p>\n      <p>\n        This is illustrated using a single rectangle that is a child of a group\n        element. A fill is specified for the group element but not the\n        rectangle. Colour is specifed for the rectangle and the group element.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>Run the test. No interaction required.</p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The test is passed if the user agent renders the rectangle with a green\n        fill.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: color-prop-05-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <g fill="currentColor" color="lime">\n      <rect x="120" y="60" width="150" height="150" color="red"/>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.8 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'coords-coord-01-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="DJ" author="CN" status="accepted"\n    version="$Revision: 1.6 $" testname="$RCSfile: coords-coord-01-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/coords.html#InitialCoordinateSystem">\n      <p>\n        Tests the default initial coordinate system used by renderer.\n      </p>\n      <p>Should be 0,0 if not specified. This is illustrated by comparing blue boxes that are\n        missing a coordinate or all coordinates with yellow boxes that have the\n        correct coordinates specified.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The test is passed if there are three blue boxes,\n        with small yellow boxes rendered on top of them. These boxes should be\n        placed along the origin, and x and y axis.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: coords-coord-01-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n\n    <!-- Content of Test Case follows. -->\n\n    <g stroke="black" stroke-width="5">\n\n      <line x1="0" y1="0" x2="150" y2="0"/>\n\n      <line x1="0" y1="0" x2="0" y2="150"/>\n    </g>\n\n    <g fill="blue">\n      <rect width="15" height="15"/>\n\n      <rect x="150" width="15" height="15"/>\n\n      <rect y="150" width="15" height="15"/>\n    </g>\n\n    <g fill="yellow">\n      <rect x="0" y="0" width="10" height="10"/>\n\n      <rect x="150" y="0" width="10" height="10"/>\n\n      <rect x="0" y="150" width="10" height="10"/>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.6 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'coords-coord-02-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="DJ" author="CN" status="accepted"\n    version="$Revision: 1.7 $" testname="$RCSfile: coords-coord-02-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/coords.html#InitialCoordinateSystem">\n      <p>\n        Tests the default units used for the initial coordinate system. This is\n        illustrated by comparing blue boxes that have no units specified for their\n        coordinates, with yellow boxes that have px units specified for their\n        coordinates.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        This test should produce three blue boxes, with small yellow\n        boxes rendered on top of them. These boxes should be placed along the\n        origin, x and y axis.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: coords-coord-02-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n\n    <!-- Content of Test Case follows. -->\n\n    <g stroke="black" stroke-width="5">\n\n      <line x1="0px" y1="0px" x2="150px" y2="0px"/>\n\n      <line x1="0px" y1="0px" x2="0px" y2="150px"/>\n    </g>\n\n    <g fill="blue">\n      <rect x="0" y="0" width="15" height="15"/>\n\n      <rect x="150" y="0" width="15" height="15"/>\n\n      <rect x="0" y="150" width="15" height="15"/>\n    </g>\n\n    <g fill="yellow">\n      <rect x="0px" y="0px" width="10" height="10"/>\n\n      <rect x="150px" y="0px" width="10" height="10"/>\n\n      <rect x="0px" y="150px" width="10" height="10"/>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.7 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'coords-trans-01-b.svg', svg: '<svg version="1.1" baseProfile="basic" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Vincent Hardy" status="accepted"\n    version="$Revision: 1.6 $" testname="$RCSfile: coords-trans-01-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/coords.html#EstablishingANewUserSpace">\n      <p>\n        This test verifies the implementation of transforms. It tests elementary transforms\n        and transform nesting.\n        Note that for layout purposes, this test uses nesting of translation with the elementary  transforms.\n      </p>\n      <p>\n        The test uses the rect element, the fill color (solid primary colors) and transforms.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The rendered picture should match the reference image exactly except for variations in the labeling text.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: coords-trans-01-b.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <g transform="translate(0, 30)" font-size="13">\n      <!-- ====================================================================== -->\n      <!-- First, draw a test grid ============================================== -->\n      <!-- ====================================================================== -->\n      <g id="test-grid" stroke="#cccccc" stroke-width="1">\n        <line x1="10" y1="10.5" x2="470" y2="10.5"/>\n        <line x1="10" y1="20.5" x2="470" y2="20.5"/>\n        <line x1="10" y1="30.5" x2="470" y2="30.5"/>\n        <line x1="10" y1="40.5" x2="470" y2="40.5"/>\n        <line x1="10" y1="50.5" x2="470" y2="50.5"/>\n        <line x1="10" y1="60.5" x2="470" y2="60.5"/>\n        <line x1="10" y1="70.5" x2="470" y2="70.5"/>\n        <line x1="10" y1="80.5" x2="470" y2="80.5"/>\n        <line x1="10" y1="90.5" x2="470" y2="90.5"/>\n        <line x1="10" y1="100.5" x2="470" y2="100.5"/>\n        <line x1="10" y1="110.5" x2="470" y2="110.5"/>\n        <line x1="10" y1="120.5" x2="470" y2="120.5"/>\n        <line x1="10" y1="130.5" x2="470" y2="130.5"/>\n        <line x1="10" y1="140.5" x2="470" y2="140.5"/>\n        <line x1="10" y1="150.5" x2="470" y2="150.5"/>\n        <line x1="10" y1="160.5" x2="470" y2="160.5"/>\n        <line x1="10" y1="170.5" x2="470" y2="170.5"/>\n        <line x1="10" y1="180.5" x2="470" y2="180.5"/>\n        <line x1="10" y1="190.5" x2="470" y2="190.5"/>\n        <line x1="10" y1="200.5" x2="470" y2="200.5"/>\n        <line x1="10" y1="210.5" x2="470" y2="210.5"/>\n        <line x1="10" y1="220.5" x2="470" y2="220.5"/>\n        <line x1="10" y1="230.5" x2="470" y2="230.5"/>\n        <line x1="10" y1="240.5" x2="470" y2="240.5"/>\n        <line x1="10" y1="250.5" x2="470" y2="250.5"/>\n        <line x1="10" y1="260.5" x2="470" y2="260.5"/>\n        <line y1="10" x1="10.5" y2="260.5" x2="10.5"/>\n        <line y1="10" x1="20.5" y2="260.5" x2="20.5"/>\n        <line y1="10" x1="30.5" y2="260.5" x2="30.5"/>\n        <line y1="10" x1="40.5" y2="260.5" x2="40.5"/>\n        <line y1="10" x1="50.5" y2="260.5" x2="50.5"/>\n        <line y1="10" x1="60.5" y2="260.5" x2="60.5"/>\n        <line y1="10" x1="70.5" y2="260.5" x2="70.5"/>\n        <line y1="10" x1="80.5" y2="260.5" x2="80.5"/>\n        <line y1="10" x1="90.5" y2="260.5" x2="90.5"/>\n        <line y1="10" x1="100.5" y2="260.5" x2="100.5"/>\n        <line y1="10" x1="110.5" y2="260.5" x2="110.5"/>\n        <line y1="10" x1="120.5" y2="260.5" x2="120.5"/>\n        <line y1="10" x1="130.5" y2="260.5" x2="130.5"/>\n        <line y1="10" x1="140.5" y2="260.5" x2="140.5"/>\n        <line y1="10" x1="150.5" y2="260.5" x2="150.5"/>\n        <line y1="10" x1="160.5" y2="260.5" x2="160.5"/>\n        <line y1="10" x1="170.5" y2="260.5" x2="170.5"/>\n        <line y1="10" x1="180.5" y2="260.5" x2="180.5"/>\n        <line y1="10" x1="190.5" y2="260.5" x2="190.5"/>\n        <line y1="10" x1="200.5" y2="260.5" x2="200.5"/>\n        <line y1="10" x1="210.5" y2="260.5" x2="210.5"/>\n        <line y1="10" x1="220.5" y2="260.5" x2="220.5"/>\n        <line y1="10" x1="230.5" y2="260.5" x2="230.5"/>\n        <line y1="10" x1="240.5" y2="260.5" x2="240.5"/>\n        <line y1="10" x1="250.5" y2="260.5" x2="250.5"/>\n        <line y1="10" x1="260.5" y2="260.5" x2="260.5"/>\n        <line y1="10" x1="270.5" y2="260.5" x2="270.5"/>\n        <line y1="10" x1="280.5" y2="260.5" x2="280.5"/>\n        <line y1="10" x1="290.5" y2="260.5" x2="290.5"/>\n        <line y1="10" x1="300.5" y2="260.5" x2="300.5"/>\n        <line y1="10" x1="310.5" y2="260.5" x2="310.5"/>\n        <line y1="10" x1="320.5" y2="260.5" x2="320.5"/>\n        <line y1="10" x1="330.5" y2="260.5" x2="330.5"/>\n        <line y1="10" x1="340.5" y2="260.5" x2="340.5"/>\n        <line y1="10" x1="350.5" y2="260.5" x2="350.5"/>\n        <line y1="10" x1="360.5" y2="260.5" x2="360.5"/>\n        <line y1="10" x1="370.5" y2="260.5" x2="370.5"/>\n        <line y1="10" x1="380.5" y2="260.5" x2="380.5"/>\n        <line y1="10" x1="390.5" y2="260.5" x2="390.5"/>\n        <line y1="10" x1="400.5" y2="260.5" x2="400.5"/>\n        <line y1="10" x1="410.5" y2="260.5" x2="410.5"/>\n        <line y1="10" x1="420.5" y2="260.5" x2="420.5"/>\n        <line y1="10" x1="430.5" y2="260.5" x2="430.5"/>\n        <line y1="10" x1="440.5" y2="260.5" x2="440.5"/>\n        <line y1="10" x1="450.5" y2="260.5" x2="450.5"/>\n        <line y1="10" x1="460.5" y2="260.5" x2="460.5"/>\n        <line y1="10" x1="470.5" y2="260.5" x2="470.5"/>\n      </g>\n      <!-- ====================================================================== -->\n      <!-- Now, test elementary transforms. For each transform, 3 markers are     -->\n      <!-- placed where the user space is expected after transformations for the  -->\n      <!-- origin (black) and the points in (20, 0) (blue) and (0, 20) (red).     -->\n      <!-- Then, a blue line going from (0, 0) to (20, 0) is drawn and a red line -->\n      <!-- going from (0, 0) to (0, 20), after applying the elementary            -->\n      <!-- transformation. If the test succeeds, the red line should join the     -->\n      <!-- black marker to the red marker and the blue line the black marker to   -->\n      <!-- the blue marker.                                                       -->\n      <!-- ====================================================================== -->\n      <g id="elementary-transforms-test" transform="translate(0, 10)">\n        <g id="elementary-transforms">\n          <!-- Translate -->\n          <g transform="translate(50, 50)">\n            <rect x="0" y="0" width="20" height="2" fill="blue"/>\n            <rect x="0" y="0" width="2" height="20" fill="red"/>\n          </g>\n          <!-- Rotate -90 deg about (150, 70) -->\n          <g transform="translate(150, 70) rotate(-90)">\n            <rect x="0" y="0" width="20" height="2" fill="blue"/>\n            <rect x="0" y="0" width="2" height="20" fill="red"/>\n          </g>\n          <!-- Skew X -->\n          <g transform="translate(250, 50) skewX(45)">\n            <rect x="0" y="0" width="20" height="2" fill="blue"/>\n            <rect x="0" y="0" width="2" height="20" fill="red"/>\n          </g>\n          <!-- Skew Y -->\n          <g transform="translate(350, 50) skewY(45)">\n            <rect x="0" y="0" width="20" height="2" fill="blue"/>\n            <rect x="0" y="0" width="2" height="20" fill="red"/>\n          </g>\n          <!-- Scale 2 -->\n          <g transform="translate(210, 120) scale(2)">\n            <rect x="0" y="0" width="20" height="1" fill="blue"/>\n            <rect x="0" y="0" width="1" height="20" fill="red"/>\n          </g>\n        </g>\n        <!-- elementary-transforms -->\n        <!-- Draw all the markers -->\n        <g id="elementary-transforms-test-markers">\n          <!-- Translate -->\n          <text x="40" y="40">translate (50, 50)</text>\n          <rect x="48" y="48" width="5" height="5" fill="black"/>\n          <rect x="68" y="48" width="5" height="5" fill="blue"/>\n          <rect x="48" y="68" width="5" height="5" fill="red"/>\n          <!-- Rotate -90 deg about (150, 70) -->\n          <text x="140" y="40">rotate(-90)</text>\n          <rect x="148" y="68" width="5" height="5" fill="black"/>\n          <rect x="148" y="48" width="5" height="5" fill="blue"/>\n          <rect x="168" y="68" width="5" height="5" fill="red"/>\n          <!-- Skew X -->\n          <text x="240" y="40">skew x (45)</text>\n          <rect x="248" y="48" width="5" height="5" fill="black"/>\n          <rect x="268" y="48" width="5" height="5" fill="blue"/>\n          <rect x="268" y="68" width="5" height="5" fill="red"/>\n          <!-- Skew Y -->\n          <text x="340" y="40">skew y (45)</text>\n          <rect x="348" y="48" width="5" height="5" fill="black"/>\n          <rect x="368" y="68" width="5" height="5" fill="blue"/>\n          <rect x="348" y="68" width="5" height="5" fill="red"/>\n          <!-- Scale 2 -->\n          <text x="200" y="110">scale (2)</text>\n          <rect x="208" y="118" width="5" height="5" fill="black"/>\n          <rect x="248" y="118" width="5" height="5" fill="blue"/>\n          <rect x="208" y="158" width="5" height="5" fill="red"/>\n        </g>\n        <!-- elementary-transforms-test-markers -->\n      </g>\n      <g id="nested-transforms-test">\n        <g id="nested-transforms">\n          <!-- scale/translate in transform attribute -->\n          <g transform="scale(3, 2) translate(16.666667, 105)">\n            <rect x="0" y="0" width="20" height="1" fill="blue"/>\n            <rect x="0" y="0" width="0.67" height="20" fill="red"/>\n          </g>\n          <!-- scale/translate in successive elements -->\n          <g transform="translate(200, 0)">\n            <g transform="scale(3, 2)">\n              <g transform="translate(16.666667, 105)">\n                <rect x="0" y="0" width="20" height="1" fill="blue"/>\n                <rect x="0" y="0" width="0.67" height="20" fill="red"/>\n              </g>\n            </g>\n          </g>\n        </g>\n        <!-- nested-transforms -->\n        <g id="nested-transforms-test-markers">\n          <!-- scale and translate -->\n          <text x="40" y="200">scale(25, 95) and translate(2, 2)</text>\n          <rect x="48" y="208" width="5" height="5" fill="black"/>\n          <rect x="108" y="208" width="5" height="5" fill="blue"/>\n          <rect x="48" y="248" width="5" height="5" fill="red"/>\n          <!-- scale then translate -->\n          <text x="240" y="200">scale(25, 95) then translate(2, 2)</text>\n          <rect x="248" y="208" width="5" height="5" fill="black"/>\n          <rect x="308" y="208" width="5" height="5" fill="blue"/>\n          <rect x="248" y="248" width="5" height="5" fill="red"/>\n        </g>\n        <!-- nested-transforms-test-markers -->\n      </g>\n      <!-- nested-transforms test -->\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.6 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'coords-trans-02-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Vincent Hardy" status="accepted"\n    version="$Revision: 1.6 $" testname="$RCSfile: coords-trans-02-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/coords.html#EstablishingANewUserSpace">\n      <p>\n        This test verifies the implementation of transforms. It tests elementary transforms\n        and transform nesting.\n        Note that for layout purposes, this test uses nesting of translation with the elementary  transforms.\n      </p>\n      <p>\n        The test uses the rect element, the fill color (solid primary colors) and transforms.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The rendered picture should match the reference image exactly except for variations in the labeling text.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: coords-trans-02-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <g transform="translate(0, 30)" font-size="12">\n      <!-- ====================================================================== -->\n      <!-- First, draw a test grid ============================================== -->\n      <!-- ====================================================================== -->\n      <!--g id="test-grid" stroke="#cccccc" stroke-width="1" >\n         <line x1="10" y1="10.5" x2="470" y2="10.5"/>\n         <line x1="10" y1="20.5" x2="470" y2="20.5"/>\n         <line x1="10" y1="30.5" x2="470" y2="30.5"/>\n         <line x1="10" y1="40.5" x2="470" y2="40.5"/>\n         <line x1="10" y1="50.5" x2="470" y2="50.5"/>\n         <line x1="10" y1="60.5" x2="470" y2="60.5"/>\n         <line x1="10" y1="70.5" x2="470" y2="70.5"/>\n         <line x1="10" y1="80.5" x2="470" y2="80.5"/>\n         <line x1="10" y1="90.5" x2="470" y2="90.5"/>\n         <line x1="10" y1="100.5" x2="470" y2="100.5"/>\n         <line x1="10" y1="110.5" x2="470" y2="110.5"/>\n         <line x1="10" y1="120.5" x2="470" y2="120.5"/>\n         <line x1="10" y1="130.5" x2="470" y2="130.5"/>\n         <line x1="10" y1="140.5" x2="470" y2="140.5"/>\n         <line x1="10" y1="150.5" x2="470" y2="150.5"/>\n         <line x1="10" y1="160.5" x2="470" y2="160.5"/>\n         <line x1="10" y1="170.5" x2="470" y2="170.5"/>\n         <line x1="10" y1="180.5" x2="470" y2="180.5"/>\n         <line x1="10" y1="190.5" x2="470" y2="190.5"/>\n         <line x1="10" y1="200.5" x2="470" y2="200.5"/>\n         <line x1="10" y1="210.5" x2="470" y2="210.5"/>\n         <line x1="10" y1="220.5" x2="470" y2="220.5"/>\n         <line x1="10" y1="230.5" x2="470" y2="230.5"/>\n         <line x1="10" y1="240.5" x2="470" y2="240.5"/>\n         <line x1="10" y1="250.5" x2="470" y2="250.5"/>\n         <line x1="10" y1="260.5" x2="470" y2="260.5"/>\n         <line y1="10" x1="10.5" y2="260.5" x2="10.5"/>\n         <line y1="10" x1="20.5" y2="260.5" x2="20.5"/>\n         <line y1="10" x1="30.5" y2="260.5" x2="30.5"/>\n         <line y1="10" x1="40.5" y2="260.5" x2="40.5"/>\n         <line y1="10" x1="50.5" y2="260.5" x2="50.5"/>\n         <line y1="10" x1="60.5" y2="260.5" x2="60.5"/>\n         <line y1="10" x1="70.5" y2="260.5" x2="70.5"/>\n         <line y1="10" x1="80.5" y2="260.5" x2="80.5"/>\n         <line y1="10" x1="90.5" y2="260.5" x2="90.5"/>\n         <line y1="10" x1="100.5" y2="260.5" x2="100.5"/>\n         <line y1="10" x1="110.5" y2="260.5" x2="110.5"/>\n         <line y1="10" x1="120.5" y2="260.5" x2="120.5"/>\n         <line y1="10" x1="130.5" y2="260.5" x2="130.5"/>\n         <line y1="10" x1="140.5" y2="260.5" x2="140.5"/>\n         <line y1="10" x1="150.5" y2="260.5" x2="150.5"/>\n         <line y1="10" x1="160.5" y2="260.5" x2="160.5"/>\n         <line y1="10" x1="170.5" y2="260.5" x2="170.5"/>\n         <line y1="10" x1="180.5" y2="260.5" x2="180.5"/>\n         <line y1="10" x1="190.5" y2="260.5" x2="190.5"/>\n         <line y1="10" x1="200.5" y2="260.5" x2="200.5"/>\n         <line y1="10" x1="210.5" y2="260.5" x2="210.5"/>\n         <line y1="10" x1="220.5" y2="260.5" x2="220.5"/>\n         <line y1="10" x1="230.5" y2="260.5" x2="230.5"/>\n         <line y1="10" x1="240.5" y2="260.5" x2="240.5"/>\n         <line y1="10" x1="250.5" y2="260.5" x2="250.5"/>\n         <line y1="10" x1="260.5" y2="260.5" x2="260.5"/>\n         <line y1="10" x1="270.5" y2="260.5" x2="270.5"/>\n         <line y1="10" x1="280.5" y2="260.5" x2="280.5"/>\n         <line y1="10" x1="290.5" y2="260.5" x2="290.5"/>\n         <line y1="10" x1="300.5" y2="260.5" x2="300.5"/>\n         <line y1="10" x1="310.5" y2="260.5" x2="310.5"/>\n         <line y1="10" x1="320.5" y2="260.5" x2="320.5"/>\n         <line y1="10" x1="330.5" y2="260.5" x2="330.5"/>\n         <line y1="10" x1="340.5" y2="260.5" x2="340.5"/>\n         <line y1="10" x1="350.5" y2="260.5" x2="350.5"/>\n         <line y1="10" x1="360.5" y2="260.5" x2="360.5"/>\n         <line y1="10" x1="370.5" y2="260.5" x2="370.5"/>\n         <line y1="10" x1="380.5" y2="260.5" x2="380.5"/>\n         <line y1="10" x1="390.5" y2="260.5" x2="390.5"/>\n         <line y1="10" x1="400.5" y2="260.5" x2="400.5"/>\n         <line y1="10" x1="410.5" y2="260.5" x2="410.5"/>\n         <line y1="10" x1="420.5" y2="260.5" x2="420.5"/>\n         <line y1="10" x1="430.5" y2="260.5" x2="430.5"/>\n         <line y1="10" x1="440.5" y2="260.5" x2="440.5"/>\n         <line y1="10" x1="450.5" y2="260.5" x2="450.5"/>\n         <line y1="10" x1="460.5" y2="260.5" x2="460.5"/>\n         <line y1="10" x1="470.5" y2="260.5" x2="470.5"/>\n      </g-->\n      <!-- ====================================================================== -->\n      <!-- Now, test elementary transforms. For each transform, 3 markers are     -->\n      <!-- placed where the user space is expected after transformations for the  -->\n      <!-- origin (black) and the points in (20, 0) (blue) and (0, 20) (red).     -->\n      <!-- Then, a blue line going from (0, 0) to (20, 0) is drawn and a red line -->\n      <!-- going from (0, 0) to (0, 20), after applying the elementary            -->\n      <!-- transformation. If the test succeeds, the red line should join the     -->\n      <!-- black marker to the red marker and the blue line the black marker to   -->\n      <!-- the blue marker.                                                       -->\n      <!-- ====================================================================== -->\n      <g id="elementary-transforms-test" transform="translate(0, 10)">\n        <g id="elementary-transforms" transform="translate(-30, 0) scale(2.5, 2.5)">\n          <!-- Translate -->\n          <g transform="translate(50, 50)">\n            <rect x="0" y="0" width="20" height="2" fill="blue"/>\n            <rect x="0" y="0" width="2" height="20" fill="red"/>\n          </g>\n          <!-- Rotate -90 deg about (150, 70) -->\n          <g transform="translate(150, 70) rotate(-90)">\n            <rect x="0" y="0" width="20" height="2" fill="blue"/>\n            <rect x="0" y="0" width="2" height="20" fill="red"/>\n          </g>\n        </g>\n        <!-- elementary-transforms -->\n        <!-- Draw all the markers -->\n        <g id="elementary-transforms-test-markers" transform="translate(-30, 0) scale(2.5, 2.5)">\n          <!-- Translate -->\n          <text x="40" y="40">translate (50, 50)</text>\n          <rect x="48" y="48" width="5" height="5" fill="black"/>\n          <rect x="68" y="48" width="5" height="5" fill="blue"/>\n          <rect x="48" y="68" width="5" height="5" fill="red"/>\n          <!-- Rotate -90 deg about (150, 70) -->\n          <text x="140" y="40">rotate(-90)</text>\n          <rect x="148" y="68" width="5" height="5" fill="black"/>\n          <rect x="148" y="48" width="5" height="5" fill="blue"/>\n          <rect x="168" y="68" width="5" height="5" fill="red"/>\n        </g>\n        <!-- elementary-transforms-test-markers -->\n      </g>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.6 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'coords-trans-03-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Vincent Hardy" status="accepted"\n    version="$Revision: 1.6 $" testname="$RCSfile: coords-trans-03-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/coords.html#EstablishingANewUserSpace">\n      <p>\n        This test verifies the implementation of transforms. It tests elementary transforms\n        and transform nesting.\n        Note that for layout purposes, this test uses nesting of translation with the elementary  transforms.\n      </p>\n      <p>\n        The test uses the rect element, the fill color (solid primary colors) and transforms.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The rendered picture should match the reference image exactly except for variations in the labeling text.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: coords-trans-03-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <g transform="translate(0, 30)" font-size="12">\n      <!-- ====================================================================== -->\n      <!-- Now, test elementary transforms. For each transform, 3 markers are     -->\n      <!-- placed where the user space is expected after transformations for the  -->\n      <!-- origin (black) and the points in (20, 0) (blue) and (0, 20) (red).     -->\n      <!-- Then, a blue line going from (0, 0) to (20, 0) is drawn and a red line -->\n      <!-- going from (0, 0) to (0, 20), after applying the elementary            -->\n      <!-- transformation. If the test succeeds, the red line should join the     -->\n      <!-- black marker to the red marker and the blue line the black marker to   -->\n      <!-- the blue marker.                                                       -->\n      <!-- ====================================================================== -->\n      <g id="elementary-transforms-test" transform="translate(0, 10)">\n        <g id="elementary-transforms" transform="translate(-560, 0) scale(2.5, 2.5)">\n          <!-- Skew X -->\n          <g transform="translate(250, 50) skewX(45)">\n            <rect x="0" y="0" width="20" height="2" fill="blue"/>\n            <rect x="0" y="0" width="2" height="20" fill="red"/>\n          </g>\n          <!-- Skew Y -->\n          <g transform="translate(350, 50) skewY(45)">\n            <rect x="0" y="0" width="20" height="2" fill="blue"/>\n            <rect x="0" y="0" width="2" height="20" fill="red"/>\n          </g>\n        </g>\n        <!-- elementary-transforms -->\n        <!-- Draw all the markers -->\n        <g id="elementary-transforms-test-markers" transform="translate(-560, 0) scale(2.5, 2.5)">\n          <!-- Skew X -->\n          <text x="240" y="40">skew x (45)</text>\n          <rect x="248" y="48" width="5" height="5" fill="black"/>\n          <rect x="268" y="48" width="5" height="5" fill="blue"/>\n          <rect x="268" y="68" width="5" height="5" fill="red"/>\n          <!-- Skew Y -->\n          <text x="340" y="40">skew y (45)</text>\n          <rect x="348" y="48" width="5" height="5" fill="black"/>\n          <rect x="368" y="68" width="5" height="5" fill="blue"/>\n          <rect x="348" y="68" width="5" height="5" fill="red"/>\n        </g>\n        <!-- elementary-transforms-test-markers -->\n      </g>\n      <!-- nested-transforms test -->\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.6 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'coords-trans-04-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Vincent Hardy" status="accepted"\n    version="$Revision: 1.6 $" testname="$RCSfile: coords-trans-04-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/coords.html#EstablishingANewUserSpace">\n      <p>\n        This test verifies the implementation of transforms. It tests elementary transforms\n        and transform nesting.\n        Note that for layout purposes, this test uses nesting of translation with the elementary transforms.\n      </p>\n      <p>\n        The test uses the rect element, the fill color (solid primary colors) and transforms.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The rendered picture should match the reference image exactly except for variations in the labeling text.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: coords-trans-04-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <g transform="translate(0, 30)" font-size="12">\n      <!-- ====================================================================== -->\n      <!-- Now, test elementary transforms. For each transform, 3 markers are     -->\n      <!-- placed where the user space is expected after transformations for the  -->\n      <!-- origin (black) and the points in (20, 0) (blue) and (0, 20) (red).     -->\n      <!-- Then, a blue line going from (0, 0) to (20, 0) is drawn and a red line -->\n      <!-- going from (0, 0) to (0, 20), after applying the elementary            -->\n      <!-- transformation. If the test succeeds, the red line should join the     -->\n      <!-- black marker to the red marker and the blue line the black marker to   -->\n      <!-- the blue marker.                                                       -->\n      <!-- ====================================================================== -->\n      <g id="elementary-transforms-test">\n        <g id="elementary-transforms" transform="translate(60, 45) scale(2.5, 2.5)">\n          <!-- Scale 2 -->\n          <g transform="translate(40, 10) scale(2)">\n            <rect x="0" y="0" width="20" height="1" fill="blue"/>\n            <rect x="0" y="0" width="1" height="20" fill="red"/>\n          </g>\n        </g>\n        <!-- elementary-transforms -->\n        <!-- Draw all the markers -->\n        <g id="elementary-transforms-test-markers" transform="translate(-364, -230) scale(2.5, 2.5)">\n          <!-- Scale 2 -->\n          <text x="200" y="110">scale (2)</text>\n          <rect x="208" y="118" width="5" height="5" fill="black"/>\n          <rect x="248" y="118" width="5" height="5" fill="blue"/>\n          <rect x="208" y="158" width="5" height="5" fill="red"/>\n        </g>\n        <!-- elementary-transforms-test-markers -->\n      </g>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.6 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'coords-trans-05-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Vincent Hardy" status="accepted"\n    version="$Revision: 1.7 $" testname="$RCSfile: coords-trans-05-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/coords.html#EstablishingANewUserSpace">\n      <p>\n        This test verifies the implementation of transforms. It tests elementary transforms\n        and transform nesting.\n        Note that for layout purposes, this test uses nesting of translation with the elementary  transforms.\n      </p>\n      <p>\n        The test uses the rect element, the fill color (solid primary colors) and transforms.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The rendered picture should match the reference image exactly except for variations in the labeling text.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: coords-trans-05-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <g transform="translate(0, 30)" font-size="12">\n      <!-- ====================================================================== -->\n      <!-- Now, test elementary transforms. For each transform, 3 markers are     -->\n      <!-- placed where the user space is expected after transformations for the  -->\n      <!-- origin (black) and the points in (20, 0) (blue) and (0, 20) (red).     -->\n      <!-- Then, a blue line going from (0, 0) to (20, 0) is drawn and a red line -->\n      <!-- going from (0, 0) to (0, 20), after applying the elementary            -->\n      <!-- transformation. If the test succeeds, the red line should join the     -->\n      <!-- black marker to the red marker and the blue line the black marker to   -->\n      <!-- the blue marker.                                                       -->\n      <!-- ====================================================================== -->\n      <g id="nested-transforms-test">\n        <g id="nested-transforms" transform="translate(-90, -450)">\n          <!-- scale/translate in transform attribute -->\n          <g transform="scale(7.5, 5) translate(16.666667, 105)">\n            <rect x="0" y="0" width="20" height="1" fill="blue"/>\n            <rect x="0" y="0" width="0.67" height="20" fill="red"/>\n          </g>\n        </g>\n        <!-- nested-transforms -->\n        <g id="nested-transforms-test-markers" transform="translate(-90, -450) scale(2.5, 2.5)">\n          <!-- scale and translate -->\n          <text x="40" y="200">scale(25, 95) - translate(2, 2)</text>\n          <rect x="48" y="208" width="5" height="5" fill="black"/>\n          <rect x="108" y="208" width="5" height="5" fill="blue"/>\n          <rect x="48" y="248" width="5" height="5" fill="red"/>\n        </g>\n        <!-- nested-transforms-test-markers -->\n      </g>\n      <!-- nested-transforms test -->\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.7 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'coords-trans-06-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Vincent Hardy" status="accepted"\n    version="$Revision: 1.6 $" testname="$RCSfile: coords-trans-06-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/coords.html#EstablishingANewUserSpace">\n      <p>\n        This test verifies the implementation of transforms. It tests elementary transforms\n        and transform nesting.\n        Note that for layout purposes, this test uses nesting of translation with the elementary  transforms.\n      </p>\n      <p>\n        The test uses the rect element, the fill color (solid primary colors) and transforms.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The rendered picture should match the reference image exactly except for variations in the labeling text.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: coords-trans-06-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <g transform="translate(0, 30)" font-size="12">\n      <g id="nested-transforms-test">\n        <g id="nested-transforms">\n          <!-- scale/translate in successive elements -->\n          <g transform="translate(-102, -450)">\n            <g transform="scale(7.5, 5)">\n              <g transform="translate(16.666667, 105)">\n                <rect x="0" y="0" width="20" height="1" fill="blue"/>\n                <rect x="0" y="0" width="0.67" height="20" fill="red"/>\n              </g>\n            </g>\n          </g>\n        </g>\n        <!-- nested-transforms -->\n        <g id="nested-transforms-test-markers" transform="translate(-600, -450) scale(2.5, 2.5)">\n          <!-- scale then translate -->\n          <text x="248" y="200">scale(25, 95) then translate(2, 2)</text>\n          <rect x="248" y="208" width="5" height="5" fill="black"/>\n          <rect x="308" y="208" width="5" height="5" fill="blue"/>\n          <rect x="248" y="248" width="5" height="5" fill="red"/>\n        </g>\n        <!-- nested-transforms-test-markers -->\n      </g>\n      <!-- nested-transforms test -->\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.6 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'coords-trans-07-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="OA" author="CN" status="accepted"\n    version="$Revision: 1.6 $" testname="$RCSfile: coords-trans-07-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/coords.html#EstablishingANewUserSpace">\n      <p>\n        This test verifies the implementation of transforms. It tests elementary transforms\n        and transform nesting.\n        Note that for layout purposes, this test uses nesting of translation with the elementary  transforms.\n      </p>\n      <p>\n        The test uses the rect element, the fill color (solid primary colors) and transforms.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The rendered picture should match the reference image exactly except for variations in the labeling text - a long blue line at four o\'clock and a short red line at seven o\'clock below the text "translate+rotate", and, below and to the left of that, a long green line at four o\'clock and a short red line at seven o\'clock below the text "rotate+translate".\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: coords-trans-07-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <g id="elementary-transforms-test">\n      <g id="object_1" transform="rotate(30) translate(200, 100)">\n        <rect x="0" y="0" width="150" height="5" fill="green"/>\n        <rect x="0" y="0" width="5" height="50" fill="red"/>\n      </g>\n      <text x="65" y="185" font-size="20">rotate+translate</text>\n\n      <g id="object_2" transform="translate(200,100) rotate(30)">\n        <rect x="0" y="0" width="150" height="5" fill="blue"/>\n        <rect x="0" y="0" width="5" height="50" fill="red"/>\n      </g>\n      <text x="150" y="100" font-size="20">translate+rotate</text>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.6 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'coords-trans-08-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="OA" author="CN" status="accepted"\n    version="$Revision: 1.6 $" testname="$RCSfile: coords-trans-08-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/coords.html#EstablishingANewUserSpace">\n      <p>\n        This test verifies the implementation of transforms. It tests elementary transforms\n        and transform nesting.\n        Note that for layout purposes, this test uses nesting of translation with the elementary  transforms.\n      </p>\n      <p>\n        This test will check if the transfomations performed are carried out in the proper order. The result should differ depending on which transformation comes first.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The rendered picture should match the reference image exactly except for variations in the labeling text.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: coords-trans-08-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <g id="elementary-transforms-test">\n      <g id="object_1" transform="skewX(45) skewY(45)">\n        <rect x="0" y="0" width="150" height="5" fill="blue"/>\n        <rect x="0" y="0" width="5" height="50" fill="red"/>\n        <rect x="150" y="0" width="5" height="50" fill="black"/>\n        <rect x="0" y="50" width="150" height="5" fill="black"/>\n        <ellipse rx="40" ry="15" cx="75" cy="25" fill="purple"/>\n      </g>\n      <text x="30" y="16" font-size="12">skewX(45)+skewY(45)</text>\n\n      <g id="object_2" transform="translate(200,0) skewY(45) skewX(45)">\n        <rect x="0" y="0" width="150" height="5" fill="blue"/>\n        <rect x="0" y="0" width="5" height="50" fill="red"/>\n        <rect x="150" y="0" width="5" height="50" fill="black"/>\n        <rect x="0" y="50" width="150" height="5" fill="black"/>\n        <ellipse rx="40" ry="15" cx="75" cy="25" fill="purple"/>\n      </g>\n      <text x="230" y="16" font-size="12">skewY(45)+skewX(45)</text>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.6 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'coords-trans-09-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="OA" author="CN" status="accepted"\n    version="$Revision: 1.6 $" testname="$RCSfile: coords-trans-09-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/coords.html#EstablishingANewUserSpace">\n      <p>\n        This test verifies the implementation of transforms. It tests elementary transforms\n        and transform nesting.\n        Note that for layout purposes, this test uses nesting of translation with the elementary  transforms.\n      </p>\n      <p>\n        This test will check if the various matrix operations work\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The rendered picture should match the reference image exactly except for variations in the labeling text.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: coords-trans-09-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <g id="elementary-transforms-test">\n\n      <g transform="matrix(0 0 0 0 0 0)">\n        <rect x="0" y="0" width="150" height="5" fill="blue"/>\n        <rect x="0" y="0" width="5" height="50" fill="red"/>\n      </g>\n      <text x="6" y="20" font-size="20">matrix(0 0 0 0 0 0)</text>\n\n      <g transform="matrix(1 0 0 1 100 100)">\n        <rect x="0" y="0" width="150" height="5" fill="blue"/>\n        <rect x="0" y="0" width="5" height="50" fill="red"/>\n      </g>\n      <text x="100" y="100" font-size="20">matrix(1 0 0 1 100 100)</text>\n\n      <g transform="matrix(1.5 0 0 1.5 70 60)">\n        <rect x="0" y="0" width="150" height="5" fill="blue"/>\n        <rect x="0" y="0" width="5" height="50" fill="red"/>\n      </g>\n      <text x="70" y="60" font-size="20">matrix(1.5 0 0 1.5 70 60)</text>\n\n      <g transform="matrix(1 0 0.5 1 30 170)">\n        <rect x="0" y="0" width="150" height="5" fill="blue"/>\n        <rect x="0" y="0" width="5" height="50" fill="red"/>\n      </g>\n      <text x="30" y="170" font-size="20">matrix(1 0 0.5 1 30 170)</text>\n\n      <g transform="matrix(1 0.5 0 1 100 200)">\n        <rect x="0" y="0" width="150" height="5" fill="blue"/>\n        <rect x="0" y="0" width="5" height="50" fill="red"/>\n      </g>\n      <text x="100" y="200" font-size="20">matrix(1 0.5 0 1 100 200)</text>\n\n      <g transform="matrix(0 1 -1 0 450 0)">\n        <rect x="0" y="0" width="150" height="5" fill="blue"/>\n        <rect x="0" y="0" width="5" height="50" fill="red"/>\n      </g>\n      <text x="275" y="30" font-size="20">matrix(0 1 -1 0 450 0)</text>\n\n      <g transform="matrix(1 0.8 0.8 1 300 220)">\n        <rect x="0" y="0" width="150" height="5" fill="blue"/>\n        <rect x="0" y="0" width="5" height="50" fill="red"/>\n      </g>\n      <text x="230" y="220" font-size="20">matrix(1 0.8 0.8 1 300 220)</text>\n\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.6 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'coords-trans-10-f.svg', svg: '<svg id="svg-root" width="100%" height="100%"\n  viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg"\n  xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="CL" author="Microsoft" status="accepted"\n    version="$Revision: 1.9 $" testname="$RCSfile: coords-trans-10-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/coords.html#EstablishingANewUserSpace">\n      <p>\n        Translation is equivalent to the matrix [1 0 0 1 tx ty], where \'tx\'\n        and \'ty\' are the distances to translate coordinates in X and Y\n        respectively.  The test overlays a group of black graphics elements\n        with a \'translate\' transform specified on top of an identical group\n        of red elements with the equivalent \'matrix\' transform and vice\n        versa.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n         Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Test passes if there is no red visible on the page.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: coords-trans-10-f.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n\n    <g transform="translate(40 20)" fill="red">\n        <path d="M 20 20 L 70 20 L 45 60 z" /> \n        <ellipse cx="120" cy="35" rx="30" ry="10" />\n        <text x="160" y="40">Filler Text</text>\n        <rect x="250" y="20" width="30" height="50" />\n        <line x1="310" y1="20" x2="350" y2="70" stroke-width="5" />\n    </g>\n    <g transform="matrix(1 0 0 1 40 20)" fill="black" stroke="black">\n        <path d="M 20 20 L 70 20 L 45 60 z" /> \n        <ellipse cx="120" cy="35" rx="30" ry="10" />\n        <text x="160" y="40">Filler Text</text>\n        <rect x="250" y="20" width="30" height="50" />\n        <line x1="310" y1="20" x2="350" y2="70" stroke-width="5" />\n    </g>\n    <g transform="translate(0 100)">\n        <g transform="matrix(1 0 0 1 40 20)" fill="red">\n            <path d="M 20 20 L 70 20 L 45 60 z" /> \n            <ellipse cx="120" cy="35" rx="30" ry="10" />\n            <text x="160" y="40">Filler Text</text>\n            <rect x="250" y="20" width="30" height="50" />\n            <line x1="310" y1="20" x2="350" y2="70" stroke-width="5" />\n        </g>\n        <g transform="translate(40 20)" fill="black" stroke="black">\n            <path d="M 20 20 L 70 20 L 45 60 z" /> \n            <ellipse cx="120" cy="35" rx="30" ry="10" />\n            <text x="160" y="40">Filler Text</text>\n            <rect x="250" y="20" width="30" height="50" />\n            <line x1="310" y1="20" x2="350" y2="70" stroke-width="5" />\n        </g>\n    </g>\n\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.9 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'coords-trans-11-f.svg', svg: '<svg id="svg-root" width="100%" height="100%"\n  viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg"\n  xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="CL" author="Microsoft" status="accepted"\n    version="$Revision: 1.8 $" testname="$RCSfile: coords-trans-11-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/coords.html#EstablishingANewUserSpace">\n      <p>\n        Scaling is equivalent to the matrix [sx 0 0 xy 0 0], where one unit in the X and Y directions in the new coordinate system equals \'sx\' and \'sy\' units in the previous coordinate system respectively.The test  overlays a group of black graphics elements with a \'scale\' transform specified on top of an identical group of red elements\n        with the equivalent \'matrix\' transform and vice versa. \n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\nRun the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Test passes if there is no red visible on the page.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: coords-trans-11-f.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n\n    <g transform="scale(1.2 2.5)" fill="red">\n        <path d="M 20 20 L 70 20 L 45 60 z" /> \n        <ellipse cx="120" cy="35" rx="30" ry="10" />\n        <text x="160" y="40">Filler Text</text>\n        <rect x="250" y="20" width="30" height="50" />\n        <line x1="310" y1="20" x2="350" y2="70" stroke-width="5" />\n    </g>\n    <g transform="matrix(1.2 0 0 2.5 0 0)" fill="black" stroke="black">\n        <path d="M 20 20 L 70 20 L 45 60 z" /> \n        <ellipse cx="120" cy="35" rx="30" ry="10" />\n        <text x="160" y="40">Filler Text</text>\n        <rect x="250" y="20" width="30" height="50" />\n        <line x1="310" y1="20" x2="350" y2="70" stroke-width="5" />\n    </g>\n    <g transform="translate(0 150)">\n        <g transform="matrix(1.2 0 0 2.5 0 0)" fill="red">\n            <path d="M 20 20 L 70 20 L 45 60 z" /> \n            <ellipse cx="120" cy="35" rx="30" ry="10" />\n            <text x="160" y="40">Filler Text</text>\n            <rect x="250" y="20" width="30" height="50" />\n            <line x1="310" y1="20" x2="350" y2="70" stroke-width="5" />\n        </g>\n        <g transform="scale(1.2 2.5)" fill="black" stroke="black">\n            <path d="M 20 20 L 70 20 L 45 60 z" /> \n            <ellipse cx="120" cy="35" rx="30" ry="10" />\n            <text x="160" y="40">Filler Text</text>\n            <rect x="250" y="20" width="30" height="50" />\n            <line x1="310" y1="20" x2="350" y2="70" stroke-width="5" />\n        </g>\n    </g>\n\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.8 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'coords-trans-12-f.svg', svg: '<svg id="svg-root" width="100%" height="100%"\n  viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg"\n  xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="CL" author="Microsoft" status="accepted"\n    version="$Revision: 1.6 $" testname="$RCSfile: coords-trans-12-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/coords.html#EstablishingANewUserSpace">\n      <p>\n        Rotation about the origin is equivalent to the matrix [cos(a) sin(a) -sin(a) cos(a) 0 0], which has the effect of rotating the coordinate system axes by angle \'a\'. The test overlays a group of black graphics elements with a \'rotate\' transform specified on top of an identical group of red elements\n        with the equivalent \'matrix\' transform and vice versa.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n	Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Test passes if there is no red visible on the page.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: coords-trans-12-f.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n\n    <g transform="translate(200)">\n        <g transform="rotate(90)" fill="red">\n            <path d="M 20 20 L 70 20 L 45 60 z" /> \n            <ellipse cx="120" cy="35" rx="30" ry="10" />\n            <text x="160" y="40">Filler Text</text>\n            <rect x="250" y="20" width="30" height="50" />\n            <line x1="310" y1="20" x2="350" y2="70" stroke-width="5" />\n        </g>\n        <g transform="matrix(0 1 -1 0 0 0)" fill="black" stroke="black">\n            <path d="M 20 20 L 70 20 L 45 60 z" /> \n            <ellipse cx="120" cy="35" rx="30" ry="10" />\n            <text x="160" y="40">Filler Text</text>\n            <rect x="250" y="20" width="30" height="50" />\n            <line x1="310" y1="20" x2="350" y2="70" stroke-width="5" />\n        </g>\n    </g>\n    <g transform="translate(310)">\n        <g transform="matrix(0 1 -1 0 0 0)" fill="red">\n            <path d="M 20 20 L 70 20 L 45 60 z" /> \n            <ellipse cx="120" cy="35" rx="30" ry="10" />\n            <text x="160" y="40">Filler Text</text>\n            <rect x="250" y="20" width="30" height="50" />\n            <line x1="310" y1="20" x2="350" y2="70" stroke-width="5" />\n        </g>\n        <g transform="rotate(90)" fill="black" stroke="black">\n            <path d="M 20 20 L 70 20 L 45 60 z" /> \n            <ellipse cx="120" cy="35" rx="30" ry="10" />\n            <text x="160" y="40">Filler Text</text>\n            <rect x="250" y="20" width="30" height="50" />\n            <line x1="310" y1="20" x2="350" y2="70" stroke-width="5" />\n        </g>\n    </g>\n\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.6 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'coords-trans-13-f.svg', svg: '<svg id="svg-root" width="100%" height="100%"\n  viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg"\n  xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="CL" author="Microsoft" status="accepted"\n    version="$Revision: 1.6 $" testname="$RCSfile: coords-trans-13-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/coords.html#EstablishingANewUserSpace">\n      <p>\n        A skew transformation along the x-axis is equivalent to the matrix [1 0 tan(a) 1 0 0], which has the effect of skewing X coordinates by angle \'a\'.\nThe test overlays a group of black graphics elements with a \'skewX\' transform specified on top of an identical group of red elements\n        with the equivalent \'matrix\' transform and vice versa. \n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n	Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Test passes if there is no red visible on the page.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: coords-trans-13-f.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n\n    <g transform="skewX(45)" fill="red">\n        <path d="M 20 20 L 70 20 L 45 60 z" /> \n        <ellipse cx="120" cy="35" rx="30" ry="10" />\n        <text x="160" y="40">Filler Text</text>\n        <rect x="250" y="20" width="30" height="50" />\n        <line x1="310" y1="20" x2="350" y2="70" stroke-width="5" />\n    </g>\n    <g transform="matrix(1 0 1 1 0 0)" fill="black" stroke="black">\n        <path d="M 20 20 L 70 20 L 45 60 z" /> \n        <ellipse cx="120" cy="35" rx="30" ry="10" />\n        <text x="160" y="40">Filler Text</text>\n        <rect x="250" y="20" width="30" height="50" />\n        <line x1="310" y1="20" x2="350" y2="70" stroke-width="5" />\n    </g>\n    <g transform="translate(0 150)">\n        <g transform="matrix(1 0 1 1 0 0)" fill="red">\n            <path d="M 20 20 L 70 20 L 45 60 z" /> \n            <ellipse cx="120" cy="35" rx="30" ry="10" />\n            <text x="160" y="40">Filler Text</text>\n            <rect x="250" y="20" width="30" height="50" />\n            <line x1="310" y1="20" x2="350" y2="70" stroke-width="5" />\n        </g>\n        <g transform="skewX(45)" fill="black" stroke="black">\n            <path d="M 20 20 L 70 20 L 45 60 z" /> \n            <ellipse cx="120" cy="35" rx="30" ry="10" />\n            <text x="160" y="40">Filler Text</text>\n            <rect x="250" y="20" width="30" height="50" />\n            <line x1="310" y1="20" x2="350" y2="70" stroke-width="5" />\n        </g>\n    </g>\n\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.6 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'coords-trans-14-f.svg', svg: '<svg id="svg-root" width="100%" height="100%"\n  viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg"\n  xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="CL" author="Microsoft" status="accepted"\n    version="$Revision: 1.6 $" testname="$RCSfile: coords-trans-14-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/coords.html#EstablishingANewUserSpace">\n      <p>\n        A skew transformation along the y-axis is equivalent to the matrix [1 tan(a) 0 1 0 0], which has the effect of skewing Y coordinates by angle \'a\'.\nThe test overlays a group of black graphics elements with a \'skewY\' transform specified on top of an identical group of red elements\n        with the equivalent \'matrix\' transform and vice versa.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n	Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Test passes if there is no red visible on the page.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: coords-trans-14-f.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n\n    <g transform="scale(0.75) rotate(-20)">\n        <g transform="skewY(45)" fill="red">\n            <path d="M 20 20 L 70 20 L 45 60 z" /> \n            <ellipse cx="120" cy="35" rx="30" ry="10" />\n            <text x="160" y="40">Filler Text</text>\n            <rect x="250" y="20" width="30" height="50" />\n            <line x1="310" y1="20" x2="350" y2="70" stroke-width="5" />\n        </g>\n        <g transform="matrix(1 1 0 1 0 0)" fill="black" stroke="black">\n            <path d="M 20 20 L 70 20 L 45 60 z" /> \n            <ellipse cx="120" cy="35" rx="30" ry="10" />\n            <text x="160" y="40">Filler Text</text>\n            <rect x="250" y="20" width="30" height="50" />\n            <line x1="310" y1="20" x2="350" y2="70" stroke-width="5" />\n        </g>\n        <g transform="translate(0 150)">\n            <g transform="matrix(1 1 0 1 0 0)" fill="red">\n                <path d="M 20 20 L 70 20 L 45 60 z" /> \n                <ellipse cx="120" cy="35" rx="30" ry="10" />\n                <text x="160" y="40">Filler Text</text>\n                <rect x="250" y="20" width="30" height="50" />\n                <line x1="310" y1="20" x2="350" y2="70" stroke-width="5" />\n            </g>\n            <g transform="skewY(45)" fill="black" stroke="black">\n                <path d="M 20 20 L 70 20 L 45 60 z" /> \n                <ellipse cx="120" cy="35" rx="30" ry="10" />\n                <text x="160" y="40">Filler Text</text>\n                <rect x="250" y="20" width="30" height="50" />\n                <line x1="310" y1="20" x2="350" y2="70" stroke-width="5" />\n            </g>\n        </g>\n    </g>\n\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.6 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'coords-transformattr-01-f.svg', svg: '<svg id="svg-root" width="100%" height="100%"\n  viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg"\n  xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="CL" author="Microsoft" status="accepted"\n    version="$Revision: 1.6 $" testname="$RCSfile: coords-transformattr-01-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/coords.html#TransformAttribute">\n      <p>\n        Tests that separating transform definitions by whitespace and/or a comma is supported. The test draws a red \'rect\' element with a valid, non-delimited transform list. It overlays it with an identical black rectangle with\n        equivalent transform list delimted by commas and numerical Unicode references of space (U+0020), tab (U+0009), carriage\n        return (U+000D), line feed (U+000A), and combination of all five, \nso that no red is visible.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Test passes if there is no red visible on the page.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: coords-transformattr-01-f.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n\n    <g transform="translate(50 50)rotate(45)skewX(15)scale(0.8)">\n        <rect x="0" y="0" width="100" height="100" fill="red" />\n    </g>\n    <g transform="translate(50 50),rotate(45),skewX(15),scale(0.8)">\n        <rect x="0" y="0" width="100" height="100" stroke="black"/>\n    </g>\n    <g transform="translate(50 50)rotate(45)skewX(15)scale(0.8)">\n        <rect x="125" y="125" width="100" height="100" fill="red" />\n    </g>\n    <g transform="translate(50 50)&#x0020;rotate(45)&#x0020;&#x0020;skewX(15)&#x0020;&#x0020;&#x0020;&#x0020;&#x0020;scale(0.8)">\n        <rect x="125" y="125" width="100" height="100" stroke="black"/>\n    </g>\n    <g transform="translate(50 50)rotate(45)skewX(15)scale(0.8)">\n        <rect x="150" y="-75" width="100" height="100" fill="red" />\n    </g>\n    <g transform="translate(50 50)&#x0009;rotate(45)&#x0009;&#x0009;skewX(15)&#x0009;&#x0009;&#x0009;&#x0009;&#x0009;scale(0.8)">\n        <rect x="150" y="-75" width="100" height="100" stroke="black"/>\n    </g>\n    <g transform="translate(50 50)rotate(45)skewX(15)scale(0.8)">\n        <rect x="300" y="-150" width="100" height="100" fill="red" />\n    </g>\n    <g transform="translate(50 50)&#x000D;rotate(45)&#x000D;&#x000D;skewX(15)&#x000D;&#x000D;&#x000D;&#x000D;&#x000D;scale(0.8)">\n        <rect x="300" y="-150" width="100" height="100" stroke="black"/>\n    </g>\n    <g transform="translate(50 50)rotate(45)skewX(15)scale(0.8)">\n        <rect x="400" y="-325" width="100" height="100" fill="red" />\n    </g>\n    <g transform="translate(50 50)&#x000A;rotate(45)&#x000A;&#x000A;skewX(15)&#x000A;&#x000A;&#x000A;&#x000A;&#x000A;scale(0.8)">\n        <rect x="400" y="-325" width="100" height="100" stroke="black"/>\n    </g>\n    <g transform="translate(50 50)rotate(45)skewX(15)scale(0.8)">\n        <rect x="500" y="-200" width="100" height="100" fill="red" />\n    </g>\n    <g transform="translate(50 50),rotate(45)&#x0020;&#x0009;skewX(15)&#x000D;&#x000A;scale(0.8)">\n        <rect x="500" y="-200" width="100" height="100" stroke="black"/>\n    </g>\n\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.6 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'coords-transformattr-02-f.svg', svg: '<svg id="svg-root" width="100%" height="100%"\n  viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg"\n  xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="CL" author="Microsoft" status="accepted"\n    version="$Revision: 1.4 $" testname="$RCSfile: coords-transformattr-02-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/coords.html#TransformAttribute">\n      <p>\n        If a list of transforms is provided, then the net effect is as if each transform had been specified separately in the order provided.\n      </p>\n<p>        The test overlays a black \'rect\' with transform list on top of an equivalent red \'rect\' with equivalent nested transforms, and vice\n        versa, so that there is no red visible on the page.</p>p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Test passes if there is no red visible on the page.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: coords-transformattr-02-f.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n\n    <g transform="translate(150)">\n        <g transform="translate(-10,-20) scale(2) rotate(45) translate(5,10)">\n            <rect width="50" height="50" fill="red" />\n            <circle cx="50" cy="50" r="25" fill="red" />\n            <line x1="50" y1="50" x2="100" y2="100" stroke="red" stroke-width="10" />\n        </g>\n        <g transform="translate(-10,-20)">\n            <g transform="scale(2)">\n                <g transform="rotate(45)">\n                    <g transform="translate(5,10)">\n                        <rect width="50" height="50" />\n                        <circle cx="50" cy="50" r="25" />\n                        <line x1="50" y1="50" x2="100" y2="100" stroke="black" stroke-width="10" />\n                    </g>\n                </g>\n            </g>\n        </g>\n        <g transform="translate(200)">\n            <g transform="translate(-10,-20)">\n                <g transform="scale(2)">\n                    <g transform="rotate(45)">\n                        <g transform="translate(5,10)">\n                            <rect width="50" height="50" fill="red" />\n                            <circle cx="50" cy="50" r="25" fill="red" />\n                            <line x1="50" y1="50" x2="100" y2="100" stroke="red" stroke-width="10" />\n                        </g>\n                    </g>\n                </g>\n            </g>\n            <g transform="translate(-10,-20) scale(2) rotate(45) translate(5,10)">\n                <rect width="50" height="50" />\n                <circle cx="50" cy="50" r="25" />\n                <line x1="50" y1="50" x2="100" y2="100" stroke="black" stroke-width="10" />\n            </g>\n        </g>\n    </g>\n\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.4 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'coords-transformattr-03-f.svg', svg: '<svg id="svg-root" width="100%" height="100%" viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/" template-version="1.4" reviewer="CL" author="Microsoft" status="accepted" version="$Revision: 1.3 $" testname="$RCSfile: coords-transformattr-03-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://dev.w3.org/SVG/profiles/1.1F2/publish/coords.html#TransformAttribute">\n      <p>\n        If \'ty\' is not specified for a \'translate\' transform, it is assumed to be zero.\n      </p>\n      <p>\n        Specify a series of various red graphics elements. Specify an equivalent series of black graphics elements that are defined to have positions\n        that are shifted \'10\' user units to the right of the red graphics elements. Specify a \'transform\' value of \'translate\' with only the \'tx\' value\n        specified  (i.e., \'translate(10)\'). If the \'ty\' parameter takes the default value of \'0\' user units, there will be no red on the page.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n			<p>Run the test. No interaction required.</p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The test is passed if there is no red visible on the page.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: coords-transformattr-03-f.svg,v $</title>\n    <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <rect x="10" width="100" height="200" fill="red" />\n    <rect transform="translate(10)" width="100" height="200" />\n    <ellipse cx="170" cy="100" rx="50" ry="100" fill="red" />\n    <ellipse transform="translate(10)" cx="160" cy="100" rx="50" ry="100" />\n    <line x1="230" x2="330" y1="10" y2="200" stroke="red" stroke-width="10" />\n    <line transform="translate(10)" x1="220" x2="320" y1="10" y2="200" stroke="black" stroke-width="10" />\n    <path d="M 340 0 L 440 0 390 200 Z" fill="red" />\n    <path transform="translate(10)" d="M 330 0 L 430 0 380 200 Z" fill="black" />\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.3 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>'},
  {name: 'coords-transformattr-04-f.svg', svg: '<svg id="svg-root" width="100%" height="100%" viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/" template-version="1.4" reviewer="CL" author="Microsoft" status="accepted" version="$Revision: 1.3 $" testname="$RCSfile: coords-transformattr-04-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://dev.w3.org/SVG/profiles/1.1F2/publish/coords.html#TransformAttribute">\n      <p>\n        If \'sy\' is not specified for a \'scale\' transform, it is assumed to be equal to \'sx\'.\n      </p>\n      <p>\n        Specify a series of various red graphics elements. Specify an equivalent series of black graphics elements that are defined to have dimensions\n        that are half the size as the red elements. Specify a \'transform\' value of \'scale\' with only the \'sx\' value specified  (i.e., \'scale(2)\'). If the \'sy\'\n        parameter takes the same value as the \'sx\', there will be no red on the page. \n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n			<p>Run the test. No interaction required.</p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Test passes if there is no red visible on the page.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: coords-transformattr-04-f.svg,v $</title>\n    <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <rect width="100" height="200" fill="red" />\n    <rect transform="scale(2)" width="50" height="100" />\n    <ellipse cx="160" cy="100" rx="50" ry="100" fill="red" />\n    <ellipse transform="scale(2)" cx="80" cy="50" rx="25" ry="50" />\n    <line x1="220" x2="320" y1="10" y2="200" stroke="red" stroke-width="10" />\n    <line transform="scale(2)" x1="110" x2="160" y1="5" y2="100" stroke="black" stroke-width="5" />\n    <path d="M 330 0 L 430 0 380 200 Z" fill="red" />\n    <path transform="scale(2)" d="M 165 0 L 215 0 190 100 Z" fill="black" />\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.3 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>'},
  {name: 'coords-transformattr-05-f.svg', svg: '<svg id="svg-root" width="100%" height="100%" viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/" template-version="1.4" reviewer="CL" author="Microsoft" status="accepted" version="$Revision: 1.4 $" testname="$RCSfile: coords-transformattr-05-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://dev.w3.org/SVG/profiles/1.1F2/publish/coords.html#TransformAttribute">\n      <p>\n        If \'cx\' and \'cy\' are not specified for a \'rotate\' transform, the rotation is about the origin of the current user coordinate system and thus corresponds to the matrix [cos(a) sin(a) -sin(a) cos(a) 0 0].\n      </p>\n      <p>\n        Specify a series of various black graphics elements inside a \'g\' element with \'transform\' set to a \'rotate\' value with unspecified \'cx\'\n        and \'cy\' parameters (i.e., \'rotate(15)\'). Specify an equivalent series of red graphics elements inside a \'g\' element with \'transform\' set\n        to a \'matrix\' value which would rotate the elements 15 degrees about the point (0,0) of the current user coordinate system. If the \'g\' element containing the black elements correctly rotates its content by 15 degrees around the origin of the current user coordinate system, there will be no red on the page.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n	<p>Run the test. No interaction required.</p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Test passes if there is no red visible on the page.\n      </p>\n            \n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: coords-transformattr-05-f.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <g transform="translate(50 15)">\n        <g transform="matrix(0.96592582628906829 0.25881904510252076 -0.25881904510252076 0.96592582628906829 0 0)">\n            <rect x="10" width="100" height="200" fill="red" />\n            <ellipse cx="170" cy="100" rx="50" ry="100" fill="red" />\n            <line x1="230" x2="330" y1="10" y2="200" stroke="red" stroke-width="10" />\n            <path d="M 340 0 L 440 0 390 200 Z" fill="red" />\n        </g>\n        <g transform="rotate(15)">\n            <rect transform="translate(10)" width="100" height="200" />\n            <ellipse transform="translate(10)" cx="160" cy="100" rx="50" ry="100" />\n            <line transform="translate(10)" x1="220" x2="320" y1="10" y2="200" stroke="black" stroke-width="10" />\n            <path transform="translate(10)" d="M 330 0 L 430 0 380 200 Z" fill="black" />\n        </g>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.4 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>\n  -->\n</svg>'},
  {name: 'coords-units-01-b.svg', svg: '<svg version="1.1" baseProfile="basic" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Vincent Hardy" status="accepted"\n    version="$Revision: 1.7 $" testname="$RCSfile: coords-units-01-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/coords.html#Units">\n      <p>\n        Verify the conversion processing of percentage and fraction values relative to\n        object bounding boxes. This is used when defining linear and radial gradients\n        as well as patterns.\n      </p>\n      <p>\n        The test validates conversion for coordinates, width, height and length. The first\n        test defines three corresponding linear gradients, which specify coordinates\n        using percentages for one, fractions for the second and user coordinates for the\n        third. The second test defines three corresponding radial gradients, which specify\n        a length (radius) using percentages for the first, fractions for the second and\n        user space for the third. Finally, the third test defines three corresponding patterns,\n        which specify their width and height using percentages for the first, fractions for the\n        second and user space coordinates for the last one.\n      </p>\n      <p>\n        The test also assumes that linear and radial gradients,\n        as well as patterns are implemented.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The rendered image should match the reference image.  Also, the text may\n        show minor differences, per CSS2 rules for font selection and matching.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: coords-units-01-b.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <g font-size="14">\n      <!-- ==================================================================== -->\n      <!-- The following gradients will be used to fill a rectangle with the    -->\n      <!-- following geometry in User space: x=0, y=0, width=50 height=20       -->\n      <!-- The gradient vector, in linearBoundingBox, is defined as: (0%, 0%)   -->\n      <!-- to (100%, 0%).                                                       -->\n      <!-- The gradient vector, in linearBoundingBoxFraction, is defined as:    -->\n      <!-- (0, 0) to (1, 0), which is equivalent.                               -->\n      <!-- According to the spec, for our rectangle, this corresponds to the    -->\n      <!-- following user space coordinates:                                    -->\n      <!-- (0%, 0%) becomes (0, 0) and (100%, 0%) becomes (20, 0)               -->\n      <!-- These values are used to define the linearUserSpace gradient.        -->\n      <!-- If the test succeeds, all the gradient should fill the rectangles    -->\n      <!-- the same way                                                         -->\n      <!-- ==================================================================== -->\n      <linearGradient id="linearBoundingBoxPercentage" gradientUnits="objectBoundingBox" x1="0%" y1="0%" x2="100%" y2="0%">\n        <stop stop-color="fuchsia" offset="0"/>\n        <stop stop-color="blue" offset="1"/>\n      </linearGradient>\n      <linearGradient id="linearBoundingBoxFraction" gradientUnits="objectBoundingBox" x1="0" y1="0" x2="1" y2="0">\n        <stop stop-color="fuchsia" offset="0"/>\n        <stop stop-color="blue" offset="1"/>\n      </linearGradient>\n      <linearGradient id="linearUserSpace" gradientUnits="userSpaceOnUse" x1="0" y1="0" x2="50" y2="0">\n        <stop stop-color="fuchsia" offset="0"/>\n        <stop stop-color="blue" offset="1"/>\n      </linearGradient>\n      <!-- Draw Text Comment -->\n      <text x="30" y="30">Bounding box relative coordinates (percentage and fraction)</text>\n      <g transform="translate(30, 40)">\n        <rect x="0" y="0" width="50" height="20" fill="url(#linearBoundingBoxPercentage)"/>\n        <rect x="0" y="0" width="50" height="20" transform="translate(0, 20)" fill="url(#linearBoundingBoxFraction)"/>\n        <rect x="0" y="0" width="50" height="20" transform="translate(0, 40)" fill="url(#linearUserSpace)"/>\n        <line x1="0" y1="20" x2="50" y2="20" stroke="#cccccc" stroke-width="1"/>\n        <line x1="0" y1="40" x2="50" y2="40" stroke="#cccccc" stroke-width="1"/>\n        <text x="60" y="15">Percentage</text>\n        <text x="60" y="35">Fraction</text>\n        <text x="60" y="55">User Space</text>\n      </g>\n      <!-- ==================================================================== -->\n      <!-- The following gradients will be used to fill a rectangle with the    -->\n      <!-- following geometry in User space: x=0, y=0, width=60 height=60       -->\n      <!-- The radial gradient outmost circle, in radialBoundingBox, is defined -->\n      <!-- as: cx=25% cy=25% r=25%                                              -->\n      <!-- The radial gradient outmost circle, in radialBoundingBoxFraction, is -->\n      <!-- defined as: cx=0.25 cy=0.25 and r=0.25                               -->\n      <!-- These two definition, for our rectangle, should be identical to the  -->\n      <!-- following radial gradient outmost circle, in radialUserSpace:        -->\n      <!-- cx=15 cy=15 r=15                                                     -->\n      <!-- ==================================================================== -->\n      <radialGradient id="radialBoundingBoxPercentage" gradientUnits="objectBoundingBox" cx="25%" cy="25%" r="25%" fx="25%" fy="25%">\n        <stop stop-color="fuchsia" offset="0"/>\n        <stop stop-color="blue" offset="1"/>\n      </radialGradient>\n      <radialGradient id="radialBoundingBoxFraction" gradientUnits="objectBoundingBox" cx="0.25" cy="0.25" r="0.25" fx="0.25" fy="0.25">\n        <stop stop-color="fuchsia" offset="0"/>\n        <stop stop-color="blue" offset="1"/>\n      </radialGradient>\n      <radialGradient id="radialUserSpace" gradientUnits="userSpaceOnUse" cx="15" cy="15" r="15" fx="15" fy="15">\n        <stop stop-color="fuchsia" offset="0"/>\n        <stop stop-color="blue" offset="1"/>\n      </radialGradient>\n      <!-- Draw Text Comment -->\n      <text x="30" y="130">Bounding box relative length (percentage and fraction)</text>\n      <g transform="translate(30, 140)">\n        <rect x="0" y="0" width="60" height="60" fill="url(#radialBoundingBoxPercentage)"/>\n        <rect x="0" y="0" width="60" height="60" transform="translate(61, 0)" fill="url(#radialBoundingBoxFraction)"/>\n        <rect x="0" y="0" width="60" height="60" transform="translate(122, 0)" fill="url(#radialUserSpace)"/>\n        <text x="0" y="73">Percent.</text>\n        <text x="61" y="73">Fraction</text>\n        <text x="122" y="73">User Space</text>\n      </g>\n      <!-- ==================================================================== -->\n      <!-- The following patterns will be used to fill a rectangle, with the    -->\n      <!-- following geometry in User space: x=0, y=0, width=50 height=30       -->\n      <!-- The pattern tile, in patterBoundingBoxPercentage, is defined as:     -->\n      <!-- x=25% y=25% width=50% height=50%                                     -->\n      <!-- The pattern tile, in patternBoundingBoxFraction, is defined as:      -->\n      <!-- x=0.25 y=0.25 width=0.50 height=0.50                                 -->\n      <!-- For our test rectangle, both correspond to the following User space  -->\n      <!-- coordinates: x=12.5 y=7.5 width=25 height=15                         -->\n      <!-- These coordinates are use to define the patternUserSpace tile        -->\n      <!-- ==================================================================== -->\n      <pattern id="patternBoundingBoxPercentage" patternUnits="objectBoundingBox" patternContentUnits="objectBoundingBox" x="25%" y="25%" width="50%" height="50%">\n        <circle cx="0.50" cy="0.50" r="0.25" fill="fuchsia"/>\n        <rect x="0.4" y="0.4" width=".2" height=".2" fill="blue"/>\n      </pattern>\n      <pattern id="patternBoundingBoxFraction" patternUnits="objectBoundingBox" patternContentUnits="objectBoundingBox" x="0.25" y="0.25" width="0.50" height="0.50">\n        <circle cx="0.50" cy="0.50" r="0.25" fill="fuchsia"/>\n        <rect x="0.4" y="0.4" width=".2" height=".2" fill="blue"/>\n      </pattern>\n      <pattern id="patternUserSpace" patternUnits="userSpaceOnUse" patternContentUnits="userSpaceOnUse" x="12.5" y="7.5" width="25" height="15">\n        <circle id="patternContent" cx="25" cy="15" r="10" fill="fuchsia"/>\n        <rect x="20" y="12" width="10" height="6" fill="blue"/>\n      </pattern>\n      <!-- Draw Text Comment -->\n      <text x="30" y="240">Bounding box relative width/height (percentage and fraction)</text>\n      <g transform="translate(30, 250)">\n        <rect x="0" y="0" width="50" height="30" fill="url(#patternBoundingBoxPercentage)" stroke="black"/>\n        <rect x="0" y="0" width="50" height="30" transform="translate(150, 0)" fill="url(#patternBoundingBoxFraction)" stroke="black"/>\n        <rect x="0" y="0" width="50" height="30" transform="translate(300, 0)" fill="url(#patternUserSpace)" stroke="black"/>\n        <text x="60" y="20">Percentage</text>\n        <text x="210" y="20">Fraction</text>\n        <text x="360" y="20">User Space</text>\n      </g>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.7 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'coords-units-02-b.svg', svg: '<svg version="1.1" baseProfile="basic" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Vincent Hardy" status="accepted"\n    version="$Revision: 1.8 $" testname="$RCSfile: coords-units-02-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/coords.html#Units">\n      <p>\n        Verify the conversion processing of CSS units and percentage values for both\n        coordinates and length values. Note that the test uses the CSS px unit to be usable\n        in all pixel resolutions. Hence, the conversion from other CSS units to CSS px is\n        left out of the test.\n      </p>\n      <p>\n        There are six atomic tests in this test. For each, the approach is to draw two similar\n        elements (circles or rects) with coordinates specified in user space for one and in\n        CSS units or percentage for the other. Each test is such that these two values (or\n        value pairs) should match.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">      \n      <p>\n        In the first two tests, that validate coordinate processing, the circles\n        should have the same center. In the following two tests, the rectangles should have\n        the same height and width. And finally, in the last test, the 3 skewed circles should have the\n        same radius.\n      </p>\n      <p>\n        The rendered image should match the reference image except for the text which may\n        show minor differences, per CSS2 rules for font selection and matching.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: coords-units-02-b.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <g font-size="13pt">\n      <!-- ==================================================================== -->\n      <!-- First test, converting CSS coordinates to user space.                -->\n      <!-- If implemented properly, the pink marker should appear on top of     -->\n      <!-- the black marker.                                                    -->\n      <!-- ==================================================================== -->\n      <!-- Draw Text Comment -->\n      <text x="60" y="35">CSS pixel coordinate to user space conversion</text>\n      <g transform="translate(5, 0) scale(4)">\n        <!-- Draw marker using user space units -->\n        <circle cx="7.5" cy="7.5" r="2.5" fill="black"/>\n        <!-- Draw CSS marker using px units -->\n        <circle cx="7.5px" cy="7.5px" r="1.5px" fill="fuchsia"/>\n      </g>\n      <!-- ==================================================================== -->\n      <!-- Same test, using percentage values for the coordinates               -->\n      <!-- ==================================================================== -->\n      <!-- Draw Text Comment -->\n      <text x="60" y="85">Percentage coordinates to user space conversion</text>\n      <g transform="translate(5, 50) scale(4)">\n        <!-- Draw marker using user space units -->\n        <circle cx="7.5" cy="7.5" r="2.5" fill="black"/>\n        <!-- Draw marker using percentages: 7.5 = 1.563% of 480 (cx)      -->\n        <!-- Draw marker using percentages: 7.5 = 2.083% of 360 (cy)      -->\n        <circle cx="1.563%" cy="2.083%" r=".3535%" fill="fuchsia"/>\n      </g>\n      <!-- ==================================================================== -->\n      <!-- Second test, converting CSS width and height to user space.          -->\n      <!-- If implemented properly, the link marker should appear bellow the    -->\n      <!-- black one and have the same size                                     -->\n      <!-- ==================================================================== -->\n      <!-- Draw Text Comment -->\n      <text x="60" y="140">CSS width/height to user space conversion</text>\n      <g transform="translate(30, 115) scale(4)">\n        <!-- Draw marker using user space units -->\n        <rect x="-5" y="0" width="10" height="5" fill="black"/>\n        <!-- Draw CSS marker using px units -->\n        <rect x="-5" y="5" width="10px" height="5px" fill="fuchsia"/>\n      </g>\n      <!-- ==================================================================== -->\n      <!-- Same test, using percentage values for the length                    -->\n      <!-- ==================================================================== -->\n      <!-- Draw Text Comment -->\n      <text x="60" y="200">Percentage width/height to user space conversion</text>\n      <g transform="translate(30, 175) scale(4)">\n        <!-- Draw marker using user space units -->\n        <rect x="-5" y="0" width="10" height="5" fill="black"/>\n        <!-- Draw CSS marker using percentages: 5*2  = 10 = 2.083% of 480  -->\n        <!--                                  2.5*2  =  5 = 1.389% of 360  -->\n        <rect x="-5" y="5" width="2.083%" height="1.389%" fill="fuchsia"/>\n      </g>\n      <!-- ==================================================================== -->\n      <!-- Third test, converting CSS arbitrary length to user space .          -->\n      <!-- If implemented properly, the three circles which are side by side    -->\n      <!-- should have the same radius                                          -->\n      <!-- ==================================================================== -->\n      <!-- Draw Text Comment -->\n      <text x="140" y="265">CSS and percentage length conversion</text>\n      <g transform="translate(30, 260)  skewX(45) scale(4)">\n        <!-- Draw marker using user space units -->\n        <circle cx="0" cy="0" r="3.536" fill="black"/>\n        <!-- Draw CSS marker using px units.                                    -->\n        <circle cx="10" cy="0" r="3.536px" fill="fuchsia"/>\n        <!-- Draw marker using percentages. This should yield a value of 3.536  -->\n        <!-- in user space. 3.536 = .8334% of 424.268px                              -->\n        <circle cx="20" cy="0" r=".8334%" fill="green"/>\n        <!-- Draw control lines at the top and bottom of the circles            -->\n        <line x1="-3.536" y1="-3.536" x2="25" y2="-3.536" fill="none" stroke="#cccccc" stroke-width=".5"/>\n        <line x1="-3.536" y1="3.536" x2="25" y2="3.536" fill="none" stroke="#cccccc" stroke-width=".5"/>\n      </g>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.8 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'coords-units-03-b.svg', svg: '<svg version="1.1" baseProfile="basic" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Vincent Hardy" status="accepted"\n    version="$Revision: 1.7 $" testname="$RCSfile: coords-units-03-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/coords.html#Units">\n      <p>\n        This test verifies both the initial viewport size and the support for the various\n        unit specifiers.\n      </p>\n      <p>\n        The units in SVG can be: user coordinate and CSS units: em, ex, px, pt, pc, cm, mm,\n        in and percentages. The test does not check the absolute length accuracy as this\n        can only be truly validated with a ruler. However, it validates that the different\n        units are supported by drawing multiple elements who have the same length specified\n        in different units.\n      </p>\n      <p>\n        The viewport is the "finite rectangular region" where rendering occurs in SVG.\n        Hence, nothing should be rendered outside the viewport (paragraph 7.1). Furthermore,\n        when no positioning properties are set on the top svg element, the initial viewport\n        size should have the value of the top svg element\'s "width" and "height" attributes.\n        To check this behavior, the test does not define positioning properties on the top\n        svg element but defines its "width" and "height" properties. Then it fills a red\n        rectangle that is bigger than the viewport size. Then, a rectangle, the size of the\n        viewport is drawn in white. If rendering is limited to the viewport area, none of the\n        red should show.\n      </p>\n      <p>\n        The line showing the "ex" units will not necessarily appear with the same length\n        as shown in the reference image because the X-height of a font is not\n        necessarily half of the font size (which is assumed in the reference image where\n        1ex is considered to be .5em).\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>The test passes if the top three lines (user units, px, em) are the same length,\n      the fifth line (%) is the same length as the top three lines, and the bottom\n      five lines (in, cm, mm, pt, pc) are the same length.  The fourth line (ex) may have\n      any non-zero length, since the X-height of the font will depend on the exact font\n      chosen by the user agent (which may vary).</p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: coords-units-03-b.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <g id="viewport-initial-size-test">\n      <!-- ====================================================================== -->\n      <!-- First fill a rectangle that is bigger than the defined viewport ====== -->\n      <!-- ====================================================================== -->\n      <rect x="0px" y="0px" width="2000px" height="2000px" fill="red"/>\n      <!-- ====================================================================== -->\n      <!-- This second rectangle should cover the previous one, so none of the == -->\n      <!-- red should show if the initial viewport has the requested size      == -->\n      <!-- ====================================================================== -->\n      <rect x="0px" y="0px" width="480px" height="360px" fill="white"/>\n    </g>\n    <!-- viewport-initial-size-test -->\n    <!-- Title -->\n    <text x="125" y="20" fill="black" font-size="12" font-family="Arial">Initial viewport and CSS units test</text>\n    <g id="units-test" fill="black" font-size="10pt" transform="translate(0, 60)">\n      <!-- ====================================================================== -->\n      <!-- Now, draw rectangles using the various unit specifiers                 -->\n      <!-- ====================================================================== -->\n      <!-- User Space -->\n      <text x="20" y="18">200</text>\n      <text x="230" y="20">User space units (no specifier)</text>\n      <rect x="20" y="20" width="200" height="1"/>\n      <!-- ================== -->\n      <!-- Relative CSS Units -->\n      <!-- ================== -->\n      <!-- Pixels : Should correspond to User Space, because the initial user -->\n      <!-- coordinate is such that one user space unit equals one pixel in    -->\n      <!-- viewport.                                                          -->\n      <text x="20" y="38">200 px</text>\n      <text x="230" y="40">Pixels (px)</text>\n      <rect x="20" y="40" width="200px" height="1"/>\n      <!-- Font size (em). Should be equal to 200pt because current font\'s    -->\n      <!-- point size is 10pt                                                 -->\n      <text x="20" y="58">20 em = 200 px (font-size=10px)</text>\n      <text x="230" y="60">Relative to font size (em)</text>\n      <g font-size="10px">\n        <rect x="20" y="60" width="20em" height="1"/>\n      </g>\n      <!-- X-Height (ex). With a 10px font-size, x-height is about 5px, so  -->\n      <!-- ex units would be about 200px                                    -->\n      <text x="20" y="78">40 ex</text>\n      <text x="230" y="80">Relative to font x-height (ex)</text>\n      <g font-size="10px">\n        <rect x="20" y="80" width="40ex" height="1"/>\n      </g>\n      <!-- ========================= -->\n      <!-- Percentage                -->\n      <!-- ========================= -->\n      <!-- 1% = 4.8px because viewport is 480px -->\n      <text x="20" y="98">41.67% = 200 px</text>\n      <text x="230" y="100">Percentage (%)</text>\n      <rect x="20" y="100" width="41.67%" height="1"/>\n      <!-- ========================= -->\n      <!-- Absolute Length CSS Units -->\n      <!-- ========================= -->\n      <!-- Inches (should be the same length as following (cm) rect)          -->\n      <text x="20" y="118">1 in</text>\n      <text x="230" y="120">Inches (in)</text>\n      <rect x="20" y="120" width="1in" height="1"/>\n      <!-- Centimeters(should be the same length as previous (in) rect)       -->\n      <!-- 1in = 2.54cm -->\n      <text x="20" y="138">2.54 cm = 1 in</text>\n      <text x="230" y="140">Centimeters (cm)</text>\n      <rect x="20" y="140" width="2.54cm" height="1"/>\n      <!-- Millimeters (should be the same length as previous (cm) rect)      -->\n      <!-- 10mm = 1cm -->\n      <text x="20" y="158">25.4 mm = 1 in</text>\n      <text x="230" y="160">Millimeters (mm)</text>\n      <rect x="20" y="160" width="25.4mm" height="1"/>\n      <!-- Points (should be the same length as (in) rect                     -->\n      <!-- 1pt = 1/72 in -->\n      <text x="20" y="178">72pt = 1 in</text>\n      <text x="230" y="180">Points (pt)</text>\n      <rect x="20" y="180" width="72pt" height="1"/>\n      <!-- Picas (should be the same length as previous (pt) rect)            -->\n      <!-- 1pc = 12pt -->\n      <text x="20" y="198">6pc = 1 in</text>\n      <text x="230" y="200">Picas (pc)</text>\n      <rect x="20" y="200" width="6pc" height="1"/>\n    </g>\n    <!-- units-test -->\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.7 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'coords-viewattr-01-b.svg', svg: '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" baseProfile="basic" id="svg-root" width="100%" height="100%" viewBox="0 0 480 360">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/" template-version="1.4" reviewer="SVGWG" author="Vincent Hardy" status="accepted" version="$Revision: 1.8 $" testname="$RCSfile: coords-viewattr-01-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/coords.html#ViewBoxAttribute">\n      <p>\n        This test verifies the implementation of the viewBox and the\n        preserveAspectRatio attribute. This is a modified version of the sample\n        file included in the SVG specification. It exercises the various\n        preserveAspectRatio values and uses a general entity definition in order\n        to make reading of the SVG source easier.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Load the document in the user agent.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The rendered picture should match the reference image exactly except for\n        variations in the labeling text.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: coords-viewattr-01-b.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <g font-size="9" transform="translate(0, 30)">\n      <desc>Example PreserveAspectRatio - demonstrate available options</desc>\n      <text text-anchor="middle" x="240" font-size="16">Test available options of preserveAspectRatio</text>\n      <text x="35.5" y="30" text-anchor="middle">SVG to fit</text>\n      <g transform="translate(20,40)"><rect x=".5" y=".5" width="29" height="39" fill="black" stroke="orange" stroke-width="2"/><g transform="translate(0, 5)"><circle cx="15" cy="15" r="10" fill="yellow"/><circle cx="12" cy="12" r="1.5" fill="black"/><circle cx="17" cy="12" r="1.5" fill="black"/><path d="M 10 19 L 15 23 20 19" stroke="black" stroke-width="2"/>\n    </g>\n  </g>\n      <text x="35.5" y="110" text-anchor="middle">Viewport 1</text>\n      <g transform="translate(10,120)"><rect x=".5" y=".5" width="49" height="29" fill="none" stroke="blue"/></g>\n      <text x="35.5" y="180" text-anchor="middle">Viewport 2</text>\n      <g transform="translate(20,190)"><rect x=".5" y=".5" width="29" height="59" fill="none" stroke="blue"/></g>\n      <g id="meet-group-1" transform="translate(120, 50)">\n        <text x="0" y="-20">---------- meet --------------------</text>\n        <g>\n          <text y="-5">xMin*</text><rect x=".5" y=".5" width="49" height="29" fill="none" stroke="blue"/>\n          <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" preserveAspectRatio="xMinYMin meet" viewBox="0 0 30 40" width="50" height="30"><rect x=".5" y=".5" width="29" height="39" fill="black" stroke="orange" stroke-width="2"/><g transform="translate(0, 5)"><circle cx="15" cy="15" r="10" fill="yellow"/><circle cx="12" cy="12" r="1.5" fill="black"/><circle cx="17" cy="12" r="1.5" fill="black"/><path d="M 10 19 L 15 23 20 19" stroke="black" stroke-width="2"/>\n    </g>\n  </svg>\n        </g>\n        <g transform="translate(70,0)">\n          <text y="-5">xMid*</text><rect x=".5" y=".5" width="49" height="29" fill="none" stroke="blue"/>\n          <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" preserveAspectRatio="xMidYMid meet" viewBox="0 0 30 40" width="50" height="30"><rect x=".5" y=".5" width="29" height="39" fill="black" stroke="orange" stroke-width="2"/><g transform="translate(0, 5)"><circle cx="15" cy="15" r="10" fill="yellow"/><circle cx="12" cy="12" r="1.5" fill="black"/><circle cx="17" cy="12" r="1.5" fill="black"/><path d="M 10 19 L 15 23 20 19" stroke="black" stroke-width="2"/>\n    </g>\n  </svg>\n        </g>\n        <g transform="translate(0,50)">\n          <text y="-5">xMax*</text><rect x=".5" y=".5" width="49" height="29" fill="none" stroke="blue"/>\n          <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" preserveAspectRatio="xMaxYMax meet" viewBox="0 0 30 40" width="50" height="30"><rect x=".5" y=".5" width="29" height="39" fill="black" stroke="orange" stroke-width="2"/><g transform="translate(0, 5)"><circle cx="15" cy="15" r="10" fill="yellow"/><circle cx="12" cy="12" r="1.5" fill="black"/><circle cx="17" cy="12" r="1.5" fill="black"/><path d="M 10 19 L 15 23 20 19" stroke="black" stroke-width="2"/>\n    </g>\n  </svg>\n        </g>\n      </g>\n      <g id="meet-group-2" transform="translate(300, 50)">\n        <text x="0" y="-20">---------- meet ------------------------</text>\n        <g>\n          <text y="-5">*YMin</text><rect x=".5" y=".5" width="29" height="59" fill="none" stroke="blue"/>\n          <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" preserveAspectRatio="xMinYMin meet" viewBox="0 0 30 40" width="30" height="60"><rect x=".5" y=".5" width="29" height="39" fill="black" stroke="orange" stroke-width="2"/><g transform="translate(0, 5)"><circle cx="15" cy="15" r="10" fill="yellow"/><circle cx="12" cy="12" r="1.5" fill="black"/><circle cx="17" cy="12" r="1.5" fill="black"/><path d="M 10 19 L 15 23 20 19" stroke="black" stroke-width="2"/>\n    </g>\n  </svg>\n        </g>\n        <g transform="translate(50, 0)">\n          <text y="-5">*YMid</text><rect x=".5" y=".5" width="29" height="59" fill="none" stroke="blue"/>\n          <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" preserveAspectRatio="xMidYMid meet" viewBox="0 0 30 40" width="30" height="60"><rect x=".5" y=".5" width="29" height="39" fill="black" stroke="orange" stroke-width="2"/><g transform="translate(0, 5)"><circle cx="15" cy="15" r="10" fill="yellow"/><circle cx="12" cy="12" r="1.5" fill="black"/><circle cx="17" cy="12" r="1.5" fill="black"/><path d="M 10 19 L 15 23 20 19" stroke="black" stroke-width="2"/>\n    </g>\n  </svg>\n        </g>\n        <g transform="translate(100, 0)">\n          <text y="-5">*YMax</text><rect x=".5" y=".5" width="29" height="59" fill="none" stroke="blue"/>\n          <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" preserveAspectRatio="xMaxYMax meet" viewBox="0 0 30 40" width="30" height="60"><rect x=".5" y=".5" width="29" height="39" fill="black" stroke="orange" stroke-width="2"/><g transform="translate(0, 5)"><circle cx="15" cy="15" r="10" fill="yellow"/><circle cx="12" cy="12" r="1.5" fill="black"/><circle cx="17" cy="12" r="1.5" fill="black"/><path d="M 10 19 L 15 23 20 19" stroke="black" stroke-width="2"/>\n    </g>\n  </svg>\n        </g>\n      </g>\n      <g id="slice-group-1" transform="translate(120, 185)">\n        <text x="0" y="-20">---------- slice -------------------------</text>\n        <g>\n          <text y="-5">xMin*</text><rect x=".5" y=".5" width="29" height="59" fill="none" stroke="blue"/>\n          <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" preserveAspectRatio="xMinYMin slice" viewBox="0 0 30 40" width="30" height="60"><rect x=".5" y=".5" width="29" height="39" fill="black" stroke="orange" stroke-width="2"/><g transform="translate(0, 5)"><circle cx="15" cy="15" r="10" fill="yellow"/><circle cx="12" cy="12" r="1.5" fill="black"/><circle cx="17" cy="12" r="1.5" fill="black"/><path d="M 10 19 L 15 23 20 19" stroke="black" stroke-width="2"/>\n    </g>\n  </svg>\n        </g>\n        <g transform="translate(50,0)">\n          <text y="-5">xMid*</text><rect x=".5" y=".5" width="29" height="59" fill="none" stroke="blue"/>\n          <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" preserveAspectRatio="xMidYMid slice" viewBox="0 0 30 40" width="30" height="60"><rect x=".5" y=".5" width="29" height="39" fill="black" stroke="orange" stroke-width="2"/><g transform="translate(0, 5)"><circle cx="15" cy="15" r="10" fill="yellow"/><circle cx="12" cy="12" r="1.5" fill="black"/><circle cx="17" cy="12" r="1.5" fill="black"/><path d="M 10 19 L 15 23 20 19" stroke="black" stroke-width="2"/>\n    </g>\n  </svg>\n        </g>\n        <g transform="translate(100,0)">\n          <text y="-5">xMax*</text><rect x=".5" y=".5" width="29" height="59" fill="none" stroke="blue"/>\n          <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" preserveAspectRatio="xMaxYMax slice" viewBox="0 0 30 40" width="30" height="60"><rect x=".5" y=".5" width="29" height="39" fill="black" stroke="orange" stroke-width="2"/><g transform="translate(0, 5)"><circle cx="15" cy="15" r="10" fill="yellow"/><circle cx="12" cy="12" r="1.5" fill="black"/><circle cx="17" cy="12" r="1.5" fill="black"/><path d="M 10 19 L 15 23 20 19" stroke="black" stroke-width="2"/>\n    </g>\n  </svg>\n        </g>\n      </g>\n      <g id="slide-group-2" transform="translate(300, 155) translate(0, 30)">\n        <text x="0" y="-20">---------- slice ---------------------</text>\n        <g>\n          <text y="-5">*YMin</text><rect x=".5" y=".5" width="49" height="29" fill="none" stroke="blue"/>\n          <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" preserveAspectRatio="xMinYMin slice" viewBox="0 0 30 40" width="50" height="30"><rect x=".5" y=".5" width="29" height="39" fill="black" stroke="orange" stroke-width="2"/><g transform="translate(0, 5)"><circle cx="15" cy="15" r="10" fill="yellow"/><circle cx="12" cy="12" r="1.5" fill="black"/><circle cx="17" cy="12" r="1.5" fill="black"/><path d="M 10 19 L 15 23 20 19" stroke="black" stroke-width="2"/>\n    </g>\n  </svg>\n        </g>\n        <g transform="translate(70,0)">\n          <text y="-5">*YMid</text><rect x=".5" y=".5" width="49" height="29" fill="none" stroke="blue"/>\n          <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" preserveAspectRatio="xMidYMid slice" viewBox="0 0 30 40" width="50" height="30"><rect x=".5" y=".5" width="29" height="39" fill="black" stroke="orange" stroke-width="2"/><g transform="translate(0, 5)"><circle cx="15" cy="15" r="10" fill="yellow"/><circle cx="12" cy="12" r="1.5" fill="black"/><circle cx="17" cy="12" r="1.5" fill="black"/><path d="M 10 19 L 15 23 20 19" stroke="black" stroke-width="2"/>\n    </g>\n  </svg>\n        </g>\n        <g transform="translate(0,50)">\n          <text y="-5">*YMax</text><rect x=".5" y=".5" width="49" height="29" fill="none" stroke="blue"/>\n          <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" preserveAspectRatio="xMaxYMax slice" viewBox="0 0 30 40" width="50" height="30"><rect x=".5" y=".5" width="29" height="39" fill="black" stroke="orange" stroke-width="2"/><g transform="translate(0, 5)"><circle cx="15" cy="15" r="10" fill="yellow"/><circle cx="12" cy="12" r="1.5" fill="black"/><circle cx="17" cy="12" r="1.5" fill="black"/><path d="M 10 19 L 15 23 20 19" stroke="black" stroke-width="2"/>\n    </g>\n  </svg>\n        </g>\n      </g>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.8 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>'},
  {name: 'coords-viewattr-02-b.svg', svg: '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" baseProfile="basic" id="svg-root" width="100%" height="100%" viewBox="0 0 480 360">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/" template-version="1.4" reviewer="SVGWG" author="Vincent Hardy" status="accepted" version="$Revision: 1.9 $" testname="$RCSfile: coords-viewattr-02-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/coords.html#ViewBoxAttribute">\n      <p>\n        This test verifies the implementation of the preserveAspectRatio attribute on &lt;image&gt;\n        referencing raster content.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        This is a modified version of the sample file included in the SVG specification.\n        It exercises the various preserveAspectRatio values and uses a general entity definition\n        in order to make reading of the SVG source easier.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The rendered picture should match the reference image exactly except for variations in the labeling text.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: coords-viewattr-02-b.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <g font-size="9" transform="translate(0, 30)">\n      <desc>Example PreserveAspectRatio - demonstrate available options</desc>\n      <text text-anchor="middle" x="240" font-size="16">Test options of preserveAspectRatio on an image element</text>\n      <text x="40" y="30" text-anchor="middle">Raster to fit</text>\n      <g transform="translate(20,40)">\n        <image xlink:href="data:image/jpeg;base64,/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAHgAA/+4ADkFkb2JlAGTAAAAAAf/b AIQAEAsLCwwLEAwMEBcPDQ8XGxQQEBQbHxcXFxcXHx4XGhoaGhceHiMlJyUjHi8vMzMvL0BAQEBA QEBAQEBAQEBAQAERDw8RExEVEhIVFBEUERQaFBYWFBomGhocGhomMCMeHh4eIzArLicnJy4rNTUw MDU1QEA/QEBAQEBAQEBAQEBA/8AAEQgAZABkAwEiAAIRAQMRAf/EAT8AAAEFAQEBAQEBAAAAAAAA AAMAAQIEBQYHCAkKCwEAAQUBAQEBAQEAAAAAAAAAAQACAwQFBgcICQoLEAABBAEDAgQCBQcGCAUD DDMBAAIRAwQhEjEFQVFhEyJxgTIGFJGhsUIjJBVSwWIzNHKC0UMHJZJT8OHxY3M1FqKygyZEk1Rk RcKjdDYX0lXiZfKzhMPTdePzRieUpIW0lcTU5PSltcXV5fVWZnaGlqa2xtbm9jdHV2d3h5ent8fX 5/cRAAICAQIEBAMEBQYHBwYFNQEAAhEDITESBEFRYXEiEwUygZEUobFCI8FS0fAzJGLhcoKSQ1MV Y3M08SUGFqKygwcmNcLSRJNUoxdkRVU2dGXi8rOEw9N14/NGlKSFtJXE1OT0pbXF1eX1VmZ2hpam tsbW5vYnN0dXZ3eHl6e3x//aAAwDAQACEQMRAD8A8/SSR8LCyc/JZi4rDZdYYa0flPgAgSACSaA1 JKkLWuc4NaC5x0AGpJXT9J+onUcwC3Od9jpOoYRutI/q/m/P7l1X1f8Aqth9HYLXgX5xHuuI0b5V g8fHlbixOa+LSsw5fQf5w7/QMscfdxcL6n9BwwP1cXvH5953/wDR+j+C1qsbHoEU1MqHgxob+RES WVPNlyG5zlP+8bXgAbBRAIgiR4Knk9G6TlgjIw6Xz32AO/zhBVxJNjOUTcZGJ8DSnk+pf4v8C4F/ T7XY1nZj/fX/AOSH4rjOq9E6l0mzZmVFrSYZa33Vu+Dv4L19Qvx6Mmp1GRW22p4hzHCQQtDl/imf GQMh96Hj830P8VpgDto+KJLqPrR9UX9M3ZuCDZgzL2cupn8rfP71y63sObHmgJ4zYP2g9ixEEGip JJJSoXa1znBrQS5xgAckleo/Vb6vM6Phh9oBzrwDc790cisfDv5rlfqJ0kZnUXZ1rZpw4LJ4Nrvo /wCbz9y9GWH8W5o8X3eB0GuTz6Blxx6qSSVDrPWcTo2J9pyZcXHbVU36T3eA/iVkwhKchCAMpS0A C9vpLiKP8YxNwGRhbaCdSx8vA+BABXZ42TTl49eTjuD6bWhzHDuCpc/K5sFe7DhEtjdj8FCQOyRJ Vuo9Qxum4lmZlO21V+GpcTw1o8SuQP8AjHd62mCPQn/Se+P82EsHKZ8wMsUOIR62Br9UGQG73CSq 9M6li9Uw2ZmK6a36EHRzXDlrh4hWlDKJjIxkKMTRBXLOa17Sx4DmuBDmnUEHsV5j9bfq/wDsfMFt AP2LIJNX8h3ev+5enqj1rplfVem3Yb43PE1OP5tjdWlWuR5o8vlBJ9E9Jjw7/RbKNh8fSRPQu9f7 PtPrb/T2d987dv3pLqLHfx+jA+ofU/CGH0HHkQ+8G9/9v6P/AEYW0h41Qox6qRxUxrB/ZEIi4/NM 5Ms5n9ORl9rYAoAKXEf4xqLicLIAJoaHsJ7B5gj7wF26Hk42Pl0ux8mtttLxDmOEgqTlc/sZoZa4 hG7HgdFSFinxVeo/Uui+n6v44ukby97Gnsxxlv38p6PqX9X6b/WGOXwZax7i5g/snn5rcAAAAEAc BXfiHxDHnxxx44yri4iZfkFkIEGy8v8A4waL7Oj1WVgmum4OtA7Atc0OPzK85XttlbLWOrsaHseC HNcJBB7ELCP1K+rxv9b7O6Jn0t7tn3TP4o8h8Rx4MXt5Iy0JMTHx7qlAk2Gl/i8ovr6ZkWvBFVtv 6Ke+0Q5w/J8l1ajVVXTW2qpoZWwQ1jRAAHYBSWfzGb3s08tcPGbpeBQpSSSSiS8d+xGf8/PU2/od n22I03fQ/wDPmqS6z7Oz7V9pj3+n6c+W7ckrv36fc/7m9j+1bw/9K0oIIBHB4SVPo2SMvpOHkAzv pZP9YCHfiFcVOcTGUoneJI+xKkkkkEqSSSSUpJJJJSkkkklKSSSSUrySWX+0m/8AOT9mz/2l9T+3 v4/zUlL7E+3+T93/AAUX+dOP/i+6kLsC3p7z+kxnb2D/AIN+v4O/KusXkHROq2dJ6lVmMktadtrB +dW76Q/u8165j305NFeRQ4PqtaHMcO4KufFOXOPOcgHoza/4XUftWwNiuzMkASeFiYv1u6Nk59mC LdjmO212v0rtPfa74+PK2yARB1BXKdc+ouLmOdkdNcMa86uqP804+UfR/Iq3LR5eRlHPKUOIeiQ2 B8Uyvo9WkvNmZv1u+rf6O1rzjt0AsHq0/wBl44+RWjj/AOMd4AGTggnu6uyP+i5p/Kp5fDM/zYjD PDpKEh+1HGOuj3CS41/+MfFA9mFYXeBeAPwBWfk/XzrOWfSwMdlLnaDaDbZ8u34IR+Gc2d4CA7yk K/BXHF7nP6jhdOoORmWtqrHE8uPg0ckqt0Tr2F1ql9mNLH1uh9T43Afmu07FcbifVP6wdavGT1Wx 1LDy+47rI8G19vnC7bpPRsDpFHo4dcE/zlrtXvP8pyGfDy2HGYjJ72e94fJHwSDInag3kznNY0uc Ya0SSeAAnXLfXnrgw8L9m0O/WcofpI5ZV3/zuPvVfBhlmyxxx/SO/YdSkmhbyv7fd/zp/bEn0/W4 /wCB/m4/zEliJLqfu2L93/Jez/gdmCz+NqXUfVH60fsx4wc1x+w2H2POvouPf+qe/wB65dJHNhhm xnHMWD9oPcKBINh9ta5r2h7CHNcJa4agg9wnXmH1f+tuZ0iKLQcjC/0RPuZ/xZ/gvQemda6b1Wvf h3B7vzqj7bG/FpXN81yOXlySRxw6TG317M0ZAt7nQqnf0bpORrdhUvJ7mts/eBKuJKrGUom4kx8j SXNZ9W+gsMjApnzbP5VeoxcbHEY9LKR4VtDf+pCIknSy5JfNOUv7xJVQUkmc5rGlzyGtGpJMABcv 1z684WG11HTYysnj1P8ABMPx/O+X3p2HBlzS4ccTL8h5lRIG7qdf6/i9FxfUsIfkvB9CidXHxPg0 LyzMzMjOybMrJdvutO5zv4DyCWZmZOdkOycqw23P+k535B4BBXR8lyUeWj+9kl80v2DwYZSvyUkk kri1SSSSSlIlHr+q37Pv9afZ6c758tuqSSB2P7dlPc9E/wCfm1vqbPR0j7b9KP7H6T711mP9q2D7 V6e/v6e6P+kkkuZ575z/ALm3/wAh+1nj9fql+Cy+p/8AOTaf2b9l/wCub9/y/NSSVfB84/m/+q/K k/X6PA9f/wCdO4/tj1vTnT/Q/L0/YsNJJdTy381H+a/6j8n0YDv1+qkkklMhSSSSSn//2Q==" width="40" height="40" preserveAspectRatio="none"/>\n      </g>\n      <text x="35.5" y="110" text-anchor="middle">Viewport 1</text>\n      <g transform="translate(10,120)"><rect x=".5" y=".5" width="49" height="29" fill="none" stroke="blue"/></g>\n      <text x="35.5" y="180" text-anchor="middle">Viewport 2</text>\n      <g transform="translate(20,190)"><rect x=".5" y=".5" width="29" height="59" fill="none" stroke="blue"/></g>\n      <g id="meet-group-1" transform="translate(120, 50)">\n        <text x="0" y="-20">---------- meet --------------------</text>\n        <g>\n          <text y="-5">xMin*</text><rect x=".5" y=".5" width="49" height="29" fill="none" stroke="blue"/>\n          <image xlink:href="data:image/jpeg;base64,/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAHgAA/+4ADkFkb2JlAGTAAAAAAf/b AIQAEAsLCwwLEAwMEBcPDQ8XGxQQEBQbHxcXFxcXHx4XGhoaGhceHiMlJyUjHi8vMzMvL0BAQEBA QEBAQEBAQEBAQAERDw8RExEVEhIVFBEUERQaFBYWFBomGhocGhomMCMeHh4eIzArLicnJy4rNTUw MDU1QEA/QEBAQEBAQEBAQEBA/8AAEQgAZABkAwEiAAIRAQMRAf/EAT8AAAEFAQEBAQEBAAAAAAAA AAMAAQIEBQYHCAkKCwEAAQUBAQEBAQEAAAAAAAAAAQACAwQFBgcICQoLEAABBAEDAgQCBQcGCAUD DDMBAAIRAwQhEjEFQVFhEyJxgTIGFJGhsUIjJBVSwWIzNHKC0UMHJZJT8OHxY3M1FqKygyZEk1Rk RcKjdDYX0lXiZfKzhMPTdePzRieUpIW0lcTU5PSltcXV5fVWZnaGlqa2xtbm9jdHV2d3h5ent8fX 5/cRAAICAQIEBAMEBQYHBwYFNQEAAhEDITESBEFRYXEiEwUygZEUobFCI8FS0fAzJGLhcoKSQ1MV Y3M08SUGFqKygwcmNcLSRJNUoxdkRVU2dGXi8rOEw9N14/NGlKSFtJXE1OT0pbXF1eX1VmZ2hpam tsbW5vYnN0dXZ3eHl6e3x//aAAwDAQACEQMRAD8A8/SSR8LCyc/JZi4rDZdYYa0flPgAgSACSaA1 JKkLWuc4NaC5x0AGpJXT9J+onUcwC3Od9jpOoYRutI/q/m/P7l1X1f8Aqth9HYLXgX5xHuuI0b5V g8fHlbixOa+LSsw5fQf5w7/QMscfdxcL6n9BwwP1cXvH5953/wDR+j+C1qsbHoEU1MqHgxob+RES WVPNlyG5zlP+8bXgAbBRAIgiR4Knk9G6TlgjIw6Xz32AO/zhBVxJNjOUTcZGJ8DSnk+pf4v8C4F/ T7XY1nZj/fX/AOSH4rjOq9E6l0mzZmVFrSYZa33Vu+Dv4L19Qvx6Mmp1GRW22p4hzHCQQtDl/imf GQMh96Hj830P8VpgDto+KJLqPrR9UX9M3ZuCDZgzL2cupn8rfP71y63sObHmgJ4zYP2g9ixEEGip JJJSoXa1znBrQS5xgAckleo/Vb6vM6Phh9oBzrwDc790cisfDv5rlfqJ0kZnUXZ1rZpw4LJ4Nrvo /wCbz9y9GWH8W5o8X3eB0GuTz6Blxx6qSSVDrPWcTo2J9pyZcXHbVU36T3eA/iVkwhKchCAMpS0A C9vpLiKP8YxNwGRhbaCdSx8vA+BABXZ42TTl49eTjuD6bWhzHDuCpc/K5sFe7DhEtjdj8FCQOyRJ Vuo9Qxum4lmZlO21V+GpcTw1o8SuQP8AjHd62mCPQn/Se+P82EsHKZ8wMsUOIR62Br9UGQG73CSq 9M6li9Uw2ZmK6a36EHRzXDlrh4hWlDKJjIxkKMTRBXLOa17Sx4DmuBDmnUEHsV5j9bfq/wDsfMFt AP2LIJNX8h3ev+5enqj1rplfVem3Yb43PE1OP5tjdWlWuR5o8vlBJ9E9Jjw7/RbKNh8fSRPQu9f7 PtPrb/T2d987dv3pLqLHfx+jA+ofU/CGH0HHkQ+8G9/9v6P/AEYW0h41Qox6qRxUxrB/ZEIi4/NM 5Ms5n9ORl9rYAoAKXEf4xqLicLIAJoaHsJ7B5gj7wF26Hk42Pl0ux8mtttLxDmOEgqTlc/sZoZa4 hG7HgdFSFinxVeo/Uui+n6v44ukby97Gnsxxlv38p6PqX9X6b/WGOXwZax7i5g/snn5rcAAAAEAc BXfiHxDHnxxx44yri4iZfkFkIEGy8v8A4waL7Oj1WVgmum4OtA7Atc0OPzK85XttlbLWOrsaHseC HNcJBB7ELCP1K+rxv9b7O6Jn0t7tn3TP4o8h8Rx4MXt5Iy0JMTHx7qlAk2Gl/i8ovr6ZkWvBFVtv 6Ke+0Q5w/J8l1ajVVXTW2qpoZWwQ1jRAAHYBSWfzGb3s08tcPGbpeBQpSSSSiS8d+xGf8/PU2/od n22I03fQ/wDPmqS6z7Oz7V9pj3+n6c+W7ckrv36fc/7m9j+1bw/9K0oIIBHB4SVPo2SMvpOHkAzv pZP9YCHfiFcVOcTGUoneJI+xKkkkkEqSSSSUpJJJJSkkkklKSSSSUrySWX+0m/8AOT9mz/2l9T+3 v4/zUlL7E+3+T93/AAUX+dOP/i+6kLsC3p7z+kxnb2D/AIN+v4O/KusXkHROq2dJ6lVmMktadtrB +dW76Q/u8165j305NFeRQ4PqtaHMcO4KufFOXOPOcgHoza/4XUftWwNiuzMkASeFiYv1u6Nk59mC LdjmO212v0rtPfa74+PK2yARB1BXKdc+ouLmOdkdNcMa86uqP804+UfR/Iq3LR5eRlHPKUOIeiQ2 B8Uyvo9WkvNmZv1u+rf6O1rzjt0AsHq0/wBl44+RWjj/AOMd4AGTggnu6uyP+i5p/Kp5fDM/zYjD PDpKEh+1HGOuj3CS41/+MfFA9mFYXeBeAPwBWfk/XzrOWfSwMdlLnaDaDbZ8u34IR+Gc2d4CA7yk K/BXHF7nP6jhdOoORmWtqrHE8uPg0ckqt0Tr2F1ql9mNLH1uh9T43Afmu07FcbifVP6wdavGT1Wx 1LDy+47rI8G19vnC7bpPRsDpFHo4dcE/zlrtXvP8pyGfDy2HGYjJ72e94fJHwSDInag3kznNY0uc Ya0SSeAAnXLfXnrgw8L9m0O/WcofpI5ZV3/zuPvVfBhlmyxxx/SO/YdSkmhbyv7fd/zp/bEn0/W4 /wCB/m4/zEliJLqfu2L93/Jez/gdmCz+NqXUfVH60fsx4wc1x+w2H2POvouPf+qe/wB65dJHNhhm xnHMWD9oPcKBINh9ta5r2h7CHNcJa4agg9wnXmH1f+tuZ0iKLQcjC/0RPuZ/xZ/gvQemda6b1Wvf h3B7vzqj7bG/FpXN81yOXlySRxw6TG317M0ZAt7nQqnf0bpORrdhUvJ7mts/eBKuJKrGUom4kx8j SXNZ9W+gsMjApnzbP5VeoxcbHEY9LKR4VtDf+pCIknSy5JfNOUv7xJVQUkmc5rGlzyGtGpJMABcv 1z684WG11HTYysnj1P8ABMPx/O+X3p2HBlzS4ccTL8h5lRIG7qdf6/i9FxfUsIfkvB9CidXHxPg0 LyzMzMjOybMrJdvutO5zv4DyCWZmZOdkOycqw23P+k535B4BBXR8lyUeWj+9kl80v2DwYZSvyUkk kri1SSSSSlIlHr+q37Pv9afZ6c758tuqSSB2P7dlPc9E/wCfm1vqbPR0j7b9KP7H6T711mP9q2D7 V6e/v6e6P+kkkuZ575z/ALm3/wAh+1nj9fql+Cy+p/8AOTaf2b9l/wCub9/y/NSSVfB84/m/+q/K k/X6PA9f/wCdO4/tj1vTnT/Q/L0/YsNJJdTy381H+a/6j8n0YDv1+qkkklMhSSSSSn//2Q==" preserveAspectRatio="xMinYMin meet" width="50" height="30"/>\n        </g>\n        <g transform="translate(70,0)">\n          <text y="-5">xMid*</text><rect x=".5" y=".5" width="49" height="29" fill="none" stroke="blue"/>\n          <image xlink:href="data:image/jpeg;base64,/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAHgAA/+4ADkFkb2JlAGTAAAAAAf/b AIQAEAsLCwwLEAwMEBcPDQ8XGxQQEBQbHxcXFxcXHx4XGhoaGhceHiMlJyUjHi8vMzMvL0BAQEBA QEBAQEBAQEBAQAERDw8RExEVEhIVFBEUERQaFBYWFBomGhocGhomMCMeHh4eIzArLicnJy4rNTUw MDU1QEA/QEBAQEBAQEBAQEBA/8AAEQgAZABkAwEiAAIRAQMRAf/EAT8AAAEFAQEBAQEBAAAAAAAA AAMAAQIEBQYHCAkKCwEAAQUBAQEBAQEAAAAAAAAAAQACAwQFBgcICQoLEAABBAEDAgQCBQcGCAUD DDMBAAIRAwQhEjEFQVFhEyJxgTIGFJGhsUIjJBVSwWIzNHKC0UMHJZJT8OHxY3M1FqKygyZEk1Rk RcKjdDYX0lXiZfKzhMPTdePzRieUpIW0lcTU5PSltcXV5fVWZnaGlqa2xtbm9jdHV2d3h5ent8fX 5/cRAAICAQIEBAMEBQYHBwYFNQEAAhEDITESBEFRYXEiEwUygZEUobFCI8FS0fAzJGLhcoKSQ1MV Y3M08SUGFqKygwcmNcLSRJNUoxdkRVU2dGXi8rOEw9N14/NGlKSFtJXE1OT0pbXF1eX1VmZ2hpam tsbW5vYnN0dXZ3eHl6e3x//aAAwDAQACEQMRAD8A8/SSR8LCyc/JZi4rDZdYYa0flPgAgSACSaA1 JKkLWuc4NaC5x0AGpJXT9J+onUcwC3Od9jpOoYRutI/q/m/P7l1X1f8Aqth9HYLXgX5xHuuI0b5V g8fHlbixOa+LSsw5fQf5w7/QMscfdxcL6n9BwwP1cXvH5953/wDR+j+C1qsbHoEU1MqHgxob+RES WVPNlyG5zlP+8bXgAbBRAIgiR4Knk9G6TlgjIw6Xz32AO/zhBVxJNjOUTcZGJ8DSnk+pf4v8C4F/ T7XY1nZj/fX/AOSH4rjOq9E6l0mzZmVFrSYZa33Vu+Dv4L19Qvx6Mmp1GRW22p4hzHCQQtDl/imf GQMh96Hj830P8VpgDto+KJLqPrR9UX9M3ZuCDZgzL2cupn8rfP71y63sObHmgJ4zYP2g9ixEEGip JJJSoXa1znBrQS5xgAckleo/Vb6vM6Phh9oBzrwDc790cisfDv5rlfqJ0kZnUXZ1rZpw4LJ4Nrvo /wCbz9y9GWH8W5o8X3eB0GuTz6Blxx6qSSVDrPWcTo2J9pyZcXHbVU36T3eA/iVkwhKchCAMpS0A C9vpLiKP8YxNwGRhbaCdSx8vA+BABXZ42TTl49eTjuD6bWhzHDuCpc/K5sFe7DhEtjdj8FCQOyRJ Vuo9Qxum4lmZlO21V+GpcTw1o8SuQP8AjHd62mCPQn/Se+P82EsHKZ8wMsUOIR62Br9UGQG73CSq 9M6li9Uw2ZmK6a36EHRzXDlrh4hWlDKJjIxkKMTRBXLOa17Sx4DmuBDmnUEHsV5j9bfq/wDsfMFt AP2LIJNX8h3ev+5enqj1rplfVem3Yb43PE1OP5tjdWlWuR5o8vlBJ9E9Jjw7/RbKNh8fSRPQu9f7 PtPrb/T2d987dv3pLqLHfx+jA+ofU/CGH0HHkQ+8G9/9v6P/AEYW0h41Qox6qRxUxrB/ZEIi4/NM 5Ms5n9ORl9rYAoAKXEf4xqLicLIAJoaHsJ7B5gj7wF26Hk42Pl0ux8mtttLxDmOEgqTlc/sZoZa4 hG7HgdFSFinxVeo/Uui+n6v44ukby97Gnsxxlv38p6PqX9X6b/WGOXwZax7i5g/snn5rcAAAAEAc BXfiHxDHnxxx44yri4iZfkFkIEGy8v8A4waL7Oj1WVgmum4OtA7Atc0OPzK85XttlbLWOrsaHseC HNcJBB7ELCP1K+rxv9b7O6Jn0t7tn3TP4o8h8Rx4MXt5Iy0JMTHx7qlAk2Gl/i8ovr6ZkWvBFVtv 6Ke+0Q5w/J8l1ajVVXTW2qpoZWwQ1jRAAHYBSWfzGb3s08tcPGbpeBQpSSSSiS8d+xGf8/PU2/od n22I03fQ/wDPmqS6z7Oz7V9pj3+n6c+W7ckrv36fc/7m9j+1bw/9K0oIIBHB4SVPo2SMvpOHkAzv pZP9YCHfiFcVOcTGUoneJI+xKkkkkEqSSSSUpJJJJSkkkklKSSSSUrySWX+0m/8AOT9mz/2l9T+3 v4/zUlL7E+3+T93/AAUX+dOP/i+6kLsC3p7z+kxnb2D/AIN+v4O/KusXkHROq2dJ6lVmMktadtrB +dW76Q/u8165j305NFeRQ4PqtaHMcO4KufFOXOPOcgHoza/4XUftWwNiuzMkASeFiYv1u6Nk59mC LdjmO212v0rtPfa74+PK2yARB1BXKdc+ouLmOdkdNcMa86uqP804+UfR/Iq3LR5eRlHPKUOIeiQ2 B8Uyvo9WkvNmZv1u+rf6O1rzjt0AsHq0/wBl44+RWjj/AOMd4AGTggnu6uyP+i5p/Kp5fDM/zYjD PDpKEh+1HGOuj3CS41/+MfFA9mFYXeBeAPwBWfk/XzrOWfSwMdlLnaDaDbZ8u34IR+Gc2d4CA7yk K/BXHF7nP6jhdOoORmWtqrHE8uPg0ckqt0Tr2F1ql9mNLH1uh9T43Afmu07FcbifVP6wdavGT1Wx 1LDy+47rI8G19vnC7bpPRsDpFHo4dcE/zlrtXvP8pyGfDy2HGYjJ72e94fJHwSDInag3kznNY0uc Ya0SSeAAnXLfXnrgw8L9m0O/WcofpI5ZV3/zuPvVfBhlmyxxx/SO/YdSkmhbyv7fd/zp/bEn0/W4 /wCB/m4/zEliJLqfu2L93/Jez/gdmCz+NqXUfVH60fsx4wc1x+w2H2POvouPf+qe/wB65dJHNhhm xnHMWD9oPcKBINh9ta5r2h7CHNcJa4agg9wnXmH1f+tuZ0iKLQcjC/0RPuZ/xZ/gvQemda6b1Wvf h3B7vzqj7bG/FpXN81yOXlySRxw6TG317M0ZAt7nQqnf0bpORrdhUvJ7mts/eBKuJKrGUom4kx8j SXNZ9W+gsMjApnzbP5VeoxcbHEY9LKR4VtDf+pCIknSy5JfNOUv7xJVQUkmc5rGlzyGtGpJMABcv 1z684WG11HTYysnj1P8ABMPx/O+X3p2HBlzS4ccTL8h5lRIG7qdf6/i9FxfUsIfkvB9CidXHxPg0 LyzMzMjOybMrJdvutO5zv4DyCWZmZOdkOycqw23P+k535B4BBXR8lyUeWj+9kl80v2DwYZSvyUkk kri1SSSSSlIlHr+q37Pv9afZ6c758tuqSSB2P7dlPc9E/wCfm1vqbPR0j7b9KP7H6T711mP9q2D7 V6e/v6e6P+kkkuZ575z/ALm3/wAh+1nj9fql+Cy+p/8AOTaf2b9l/wCub9/y/NSSVfB84/m/+q/K k/X6PA9f/wCdO4/tj1vTnT/Q/L0/YsNJJdTy381H+a/6j8n0YDv1+qkkklMhSSSSSn//2Q==" preserveAspectRatio="xMidYMid meet" width="50" height="30"/>\n        </g>\n        <g transform="translate(0,50)">\n          <text y="-5">xMax*</text><rect x=".5" y=".5" width="49" height="29" fill="none" stroke="blue"/>\n          <image xlink:href="data:image/jpeg;base64,/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAHgAA/+4ADkFkb2JlAGTAAAAAAf/b AIQAEAsLCwwLEAwMEBcPDQ8XGxQQEBQbHxcXFxcXHx4XGhoaGhceHiMlJyUjHi8vMzMvL0BAQEBA QEBAQEBAQEBAQAERDw8RExEVEhIVFBEUERQaFBYWFBomGhocGhomMCMeHh4eIzArLicnJy4rNTUw MDU1QEA/QEBAQEBAQEBAQEBA/8AAEQgAZABkAwEiAAIRAQMRAf/EAT8AAAEFAQEBAQEBAAAAAAAA AAMAAQIEBQYHCAkKCwEAAQUBAQEBAQEAAAAAAAAAAQACAwQFBgcICQoLEAABBAEDAgQCBQcGCAUD DDMBAAIRAwQhEjEFQVFhEyJxgTIGFJGhsUIjJBVSwWIzNHKC0UMHJZJT8OHxY3M1FqKygyZEk1Rk RcKjdDYX0lXiZfKzhMPTdePzRieUpIW0lcTU5PSltcXV5fVWZnaGlqa2xtbm9jdHV2d3h5ent8fX 5/cRAAICAQIEBAMEBQYHBwYFNQEAAhEDITESBEFRYXEiEwUygZEUobFCI8FS0fAzJGLhcoKSQ1MV Y3M08SUGFqKygwcmNcLSRJNUoxdkRVU2dGXi8rOEw9N14/NGlKSFtJXE1OT0pbXF1eX1VmZ2hpam tsbW5vYnN0dXZ3eHl6e3x//aAAwDAQACEQMRAD8A8/SSR8LCyc/JZi4rDZdYYa0flPgAgSACSaA1 JKkLWuc4NaC5x0AGpJXT9J+onUcwC3Od9jpOoYRutI/q/m/P7l1X1f8Aqth9HYLXgX5xHuuI0b5V g8fHlbixOa+LSsw5fQf5w7/QMscfdxcL6n9BwwP1cXvH5953/wDR+j+C1qsbHoEU1MqHgxob+RES WVPNlyG5zlP+8bXgAbBRAIgiR4Knk9G6TlgjIw6Xz32AO/zhBVxJNjOUTcZGJ8DSnk+pf4v8C4F/ T7XY1nZj/fX/AOSH4rjOq9E6l0mzZmVFrSYZa33Vu+Dv4L19Qvx6Mmp1GRW22p4hzHCQQtDl/imf GQMh96Hj830P8VpgDto+KJLqPrR9UX9M3ZuCDZgzL2cupn8rfP71y63sObHmgJ4zYP2g9ixEEGip JJJSoXa1znBrQS5xgAckleo/Vb6vM6Phh9oBzrwDc790cisfDv5rlfqJ0kZnUXZ1rZpw4LJ4Nrvo /wCbz9y9GWH8W5o8X3eB0GuTz6Blxx6qSSVDrPWcTo2J9pyZcXHbVU36T3eA/iVkwhKchCAMpS0A C9vpLiKP8YxNwGRhbaCdSx8vA+BABXZ42TTl49eTjuD6bWhzHDuCpc/K5sFe7DhEtjdj8FCQOyRJ Vuo9Qxum4lmZlO21V+GpcTw1o8SuQP8AjHd62mCPQn/Se+P82EsHKZ8wMsUOIR62Br9UGQG73CSq 9M6li9Uw2ZmK6a36EHRzXDlrh4hWlDKJjIxkKMTRBXLOa17Sx4DmuBDmnUEHsV5j9bfq/wDsfMFt AP2LIJNX8h3ev+5enqj1rplfVem3Yb43PE1OP5tjdWlWuR5o8vlBJ9E9Jjw7/RbKNh8fSRPQu9f7 PtPrb/T2d987dv3pLqLHfx+jA+ofU/CGH0HHkQ+8G9/9v6P/AEYW0h41Qox6qRxUxrB/ZEIi4/NM 5Ms5n9ORl9rYAoAKXEf4xqLicLIAJoaHsJ7B5gj7wF26Hk42Pl0ux8mtttLxDmOEgqTlc/sZoZa4 hG7HgdFSFinxVeo/Uui+n6v44ukby97Gnsxxlv38p6PqX9X6b/WGOXwZax7i5g/snn5rcAAAAEAc BXfiHxDHnxxx44yri4iZfkFkIEGy8v8A4waL7Oj1WVgmum4OtA7Atc0OPzK85XttlbLWOrsaHseC HNcJBB7ELCP1K+rxv9b7O6Jn0t7tn3TP4o8h8Rx4MXt5Iy0JMTHx7qlAk2Gl/i8ovr6ZkWvBFVtv 6Ke+0Q5w/J8l1ajVVXTW2qpoZWwQ1jRAAHYBSWfzGb3s08tcPGbpeBQpSSSSiS8d+xGf8/PU2/od n22I03fQ/wDPmqS6z7Oz7V9pj3+n6c+W7ckrv36fc/7m9j+1bw/9K0oIIBHB4SVPo2SMvpOHkAzv pZP9YCHfiFcVOcTGUoneJI+xKkkkkEqSSSSUpJJJJSkkkklKSSSSUrySWX+0m/8AOT9mz/2l9T+3 v4/zUlL7E+3+T93/AAUX+dOP/i+6kLsC3p7z+kxnb2D/AIN+v4O/KusXkHROq2dJ6lVmMktadtrB +dW76Q/u8165j305NFeRQ4PqtaHMcO4KufFOXOPOcgHoza/4XUftWwNiuzMkASeFiYv1u6Nk59mC LdjmO212v0rtPfa74+PK2yARB1BXKdc+ouLmOdkdNcMa86uqP804+UfR/Iq3LR5eRlHPKUOIeiQ2 B8Uyvo9WkvNmZv1u+rf6O1rzjt0AsHq0/wBl44+RWjj/AOMd4AGTggnu6uyP+i5p/Kp5fDM/zYjD PDpKEh+1HGOuj3CS41/+MfFA9mFYXeBeAPwBWfk/XzrOWfSwMdlLnaDaDbZ8u34IR+Gc2d4CA7yk K/BXHF7nP6jhdOoORmWtqrHE8uPg0ckqt0Tr2F1ql9mNLH1uh9T43Afmu07FcbifVP6wdavGT1Wx 1LDy+47rI8G19vnC7bpPRsDpFHo4dcE/zlrtXvP8pyGfDy2HGYjJ72e94fJHwSDInag3kznNY0uc Ya0SSeAAnXLfXnrgw8L9m0O/WcofpI5ZV3/zuPvVfBhlmyxxx/SO/YdSkmhbyv7fd/zp/bEn0/W4 /wCB/m4/zEliJLqfu2L93/Jez/gdmCz+NqXUfVH60fsx4wc1x+w2H2POvouPf+qe/wB65dJHNhhm xnHMWD9oPcKBINh9ta5r2h7CHNcJa4agg9wnXmH1f+tuZ0iKLQcjC/0RPuZ/xZ/gvQemda6b1Wvf h3B7vzqj7bG/FpXN81yOXlySRxw6TG317M0ZAt7nQqnf0bpORrdhUvJ7mts/eBKuJKrGUom4kx8j SXNZ9W+gsMjApnzbP5VeoxcbHEY9LKR4VtDf+pCIknSy5JfNOUv7xJVQUkmc5rGlzyGtGpJMABcv 1z684WG11HTYysnj1P8ABMPx/O+X3p2HBlzS4ccTL8h5lRIG7qdf6/i9FxfUsIfkvB9CidXHxPg0 LyzMzMjOybMrJdvutO5zv4DyCWZmZOdkOycqw23P+k535B4BBXR8lyUeWj+9kl80v2DwYZSvyUkk kri1SSSSSlIlHr+q37Pv9afZ6c758tuqSSB2P7dlPc9E/wCfm1vqbPR0j7b9KP7H6T711mP9q2D7 V6e/v6e6P+kkkuZ575z/ALm3/wAh+1nj9fql+Cy+p/8AOTaf2b9l/wCub9/y/NSSVfB84/m/+q/K k/X6PA9f/wCdO4/tj1vTnT/Q/L0/YsNJJdTy381H+a/6j8n0YDv1+qkkklMhSSSSSn//2Q==" preserveAspectRatio="xMaxYMax meet" width="50" height="30"/>\n        </g>\n      </g>\n      <g id="meet-group-2" transform="translate(300, 50)">\n        <text x="0" y="-20">---------- meet ------------------------</text>\n        <g>\n          <text y="-5">*YMin</text><rect x=".5" y=".5" width="29" height="59" fill="none" stroke="blue"/>\n          <image xlink:href="data:image/jpeg;base64,/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAHgAA/+4ADkFkb2JlAGTAAAAAAf/b AIQAEAsLCwwLEAwMEBcPDQ8XGxQQEBQbHxcXFxcXHx4XGhoaGhceHiMlJyUjHi8vMzMvL0BAQEBA QEBAQEBAQEBAQAERDw8RExEVEhIVFBEUERQaFBYWFBomGhocGhomMCMeHh4eIzArLicnJy4rNTUw MDU1QEA/QEBAQEBAQEBAQEBA/8AAEQgAZABkAwEiAAIRAQMRAf/EAT8AAAEFAQEBAQEBAAAAAAAA AAMAAQIEBQYHCAkKCwEAAQUBAQEBAQEAAAAAAAAAAQACAwQFBgcICQoLEAABBAEDAgQCBQcGCAUD DDMBAAIRAwQhEjEFQVFhEyJxgTIGFJGhsUIjJBVSwWIzNHKC0UMHJZJT8OHxY3M1FqKygyZEk1Rk RcKjdDYX0lXiZfKzhMPTdePzRieUpIW0lcTU5PSltcXV5fVWZnaGlqa2xtbm9jdHV2d3h5ent8fX 5/cRAAICAQIEBAMEBQYHBwYFNQEAAhEDITESBEFRYXEiEwUygZEUobFCI8FS0fAzJGLhcoKSQ1MV Y3M08SUGFqKygwcmNcLSRJNUoxdkRVU2dGXi8rOEw9N14/NGlKSFtJXE1OT0pbXF1eX1VmZ2hpam tsbW5vYnN0dXZ3eHl6e3x//aAAwDAQACEQMRAD8A8/SSR8LCyc/JZi4rDZdYYa0flPgAgSACSaA1 JKkLWuc4NaC5x0AGpJXT9J+onUcwC3Od9jpOoYRutI/q/m/P7l1X1f8Aqth9HYLXgX5xHuuI0b5V g8fHlbixOa+LSsw5fQf5w7/QMscfdxcL6n9BwwP1cXvH5953/wDR+j+C1qsbHoEU1MqHgxob+RES WVPNlyG5zlP+8bXgAbBRAIgiR4Knk9G6TlgjIw6Xz32AO/zhBVxJNjOUTcZGJ8DSnk+pf4v8C4F/ T7XY1nZj/fX/AOSH4rjOq9E6l0mzZmVFrSYZa33Vu+Dv4L19Qvx6Mmp1GRW22p4hzHCQQtDl/imf GQMh96Hj830P8VpgDto+KJLqPrR9UX9M3ZuCDZgzL2cupn8rfP71y63sObHmgJ4zYP2g9ixEEGip JJJSoXa1znBrQS5xgAckleo/Vb6vM6Phh9oBzrwDc790cisfDv5rlfqJ0kZnUXZ1rZpw4LJ4Nrvo /wCbz9y9GWH8W5o8X3eB0GuTz6Blxx6qSSVDrPWcTo2J9pyZcXHbVU36T3eA/iVkwhKchCAMpS0A C9vpLiKP8YxNwGRhbaCdSx8vA+BABXZ42TTl49eTjuD6bWhzHDuCpc/K5sFe7DhEtjdj8FCQOyRJ Vuo9Qxum4lmZlO21V+GpcTw1o8SuQP8AjHd62mCPQn/Se+P82EsHKZ8wMsUOIR62Br9UGQG73CSq 9M6li9Uw2ZmK6a36EHRzXDlrh4hWlDKJjIxkKMTRBXLOa17Sx4DmuBDmnUEHsV5j9bfq/wDsfMFt AP2LIJNX8h3ev+5enqj1rplfVem3Yb43PE1OP5tjdWlWuR5o8vlBJ9E9Jjw7/RbKNh8fSRPQu9f7 PtPrb/T2d987dv3pLqLHfx+jA+ofU/CGH0HHkQ+8G9/9v6P/AEYW0h41Qox6qRxUxrB/ZEIi4/NM 5Ms5n9ORl9rYAoAKXEf4xqLicLIAJoaHsJ7B5gj7wF26Hk42Pl0ux8mtttLxDmOEgqTlc/sZoZa4 hG7HgdFSFinxVeo/Uui+n6v44ukby97Gnsxxlv38p6PqX9X6b/WGOXwZax7i5g/snn5rcAAAAEAc BXfiHxDHnxxx44yri4iZfkFkIEGy8v8A4waL7Oj1WVgmum4OtA7Atc0OPzK85XttlbLWOrsaHseC HNcJBB7ELCP1K+rxv9b7O6Jn0t7tn3TP4o8h8Rx4MXt5Iy0JMTHx7qlAk2Gl/i8ovr6ZkWvBFVtv 6Ke+0Q5w/J8l1ajVVXTW2qpoZWwQ1jRAAHYBSWfzGb3s08tcPGbpeBQpSSSSiS8d+xGf8/PU2/od n22I03fQ/wDPmqS6z7Oz7V9pj3+n6c+W7ckrv36fc/7m9j+1bw/9K0oIIBHB4SVPo2SMvpOHkAzv pZP9YCHfiFcVOcTGUoneJI+xKkkkkEqSSSSUpJJJJSkkkklKSSSSUrySWX+0m/8AOT9mz/2l9T+3 v4/zUlL7E+3+T93/AAUX+dOP/i+6kLsC3p7z+kxnb2D/AIN+v4O/KusXkHROq2dJ6lVmMktadtrB +dW76Q/u8165j305NFeRQ4PqtaHMcO4KufFOXOPOcgHoza/4XUftWwNiuzMkASeFiYv1u6Nk59mC LdjmO212v0rtPfa74+PK2yARB1BXKdc+ouLmOdkdNcMa86uqP804+UfR/Iq3LR5eRlHPKUOIeiQ2 B8Uyvo9WkvNmZv1u+rf6O1rzjt0AsHq0/wBl44+RWjj/AOMd4AGTggnu6uyP+i5p/Kp5fDM/zYjD PDpKEh+1HGOuj3CS41/+MfFA9mFYXeBeAPwBWfk/XzrOWfSwMdlLnaDaDbZ8u34IR+Gc2d4CA7yk K/BXHF7nP6jhdOoORmWtqrHE8uPg0ckqt0Tr2F1ql9mNLH1uh9T43Afmu07FcbifVP6wdavGT1Wx 1LDy+47rI8G19vnC7bpPRsDpFHo4dcE/zlrtXvP8pyGfDy2HGYjJ72e94fJHwSDInag3kznNY0uc Ya0SSeAAnXLfXnrgw8L9m0O/WcofpI5ZV3/zuPvVfBhlmyxxx/SO/YdSkmhbyv7fd/zp/bEn0/W4 /wCB/m4/zEliJLqfu2L93/Jez/gdmCz+NqXUfVH60fsx4wc1x+w2H2POvouPf+qe/wB65dJHNhhm xnHMWD9oPcKBINh9ta5r2h7CHNcJa4agg9wnXmH1f+tuZ0iKLQcjC/0RPuZ/xZ/gvQemda6b1Wvf h3B7vzqj7bG/FpXN81yOXlySRxw6TG317M0ZAt7nQqnf0bpORrdhUvJ7mts/eBKuJKrGUom4kx8j SXNZ9W+gsMjApnzbP5VeoxcbHEY9LKR4VtDf+pCIknSy5JfNOUv7xJVQUkmc5rGlzyGtGpJMABcv 1z684WG11HTYysnj1P8ABMPx/O+X3p2HBlzS4ccTL8h5lRIG7qdf6/i9FxfUsIfkvB9CidXHxPg0 LyzMzMjOybMrJdvutO5zv4DyCWZmZOdkOycqw23P+k535B4BBXR8lyUeWj+9kl80v2DwYZSvyUkk kri1SSSSSlIlHr+q37Pv9afZ6c758tuqSSB2P7dlPc9E/wCfm1vqbPR0j7b9KP7H6T711mP9q2D7 V6e/v6e6P+kkkuZ575z/ALm3/wAh+1nj9fql+Cy+p/8AOTaf2b9l/wCub9/y/NSSVfB84/m/+q/K k/X6PA9f/wCdO4/tj1vTnT/Q/L0/YsNJJdTy381H+a/6j8n0YDv1+qkkklMhSSSSSn//2Q==" preserveAspectRatio="xMinYMin meet" width="30" height="60"/>\n        </g>\n        <g transform="translate(50, 0)">\n          <text y="-5">*YMid</text><rect x=".5" y=".5" width="29" height="59" fill="none" stroke="blue"/>\n          <image xlink:href="data:image/jpeg;base64,/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAHgAA/+4ADkFkb2JlAGTAAAAAAf/b AIQAEAsLCwwLEAwMEBcPDQ8XGxQQEBQbHxcXFxcXHx4XGhoaGhceHiMlJyUjHi8vMzMvL0BAQEBA QEBAQEBAQEBAQAERDw8RExEVEhIVFBEUERQaFBYWFBomGhocGhomMCMeHh4eIzArLicnJy4rNTUw MDU1QEA/QEBAQEBAQEBAQEBA/8AAEQgAZABkAwEiAAIRAQMRAf/EAT8AAAEFAQEBAQEBAAAAAAAA AAMAAQIEBQYHCAkKCwEAAQUBAQEBAQEAAAAAAAAAAQACAwQFBgcICQoLEAABBAEDAgQCBQcGCAUD DDMBAAIRAwQhEjEFQVFhEyJxgTIGFJGhsUIjJBVSwWIzNHKC0UMHJZJT8OHxY3M1FqKygyZEk1Rk RcKjdDYX0lXiZfKzhMPTdePzRieUpIW0lcTU5PSltcXV5fVWZnaGlqa2xtbm9jdHV2d3h5ent8fX 5/cRAAICAQIEBAMEBQYHBwYFNQEAAhEDITESBEFRYXEiEwUygZEUobFCI8FS0fAzJGLhcoKSQ1MV Y3M08SUGFqKygwcmNcLSRJNUoxdkRVU2dGXi8rOEw9N14/NGlKSFtJXE1OT0pbXF1eX1VmZ2hpam tsbW5vYnN0dXZ3eHl6e3x//aAAwDAQACEQMRAD8A8/SSR8LCyc/JZi4rDZdYYa0flPgAgSACSaA1 JKkLWuc4NaC5x0AGpJXT9J+onUcwC3Od9jpOoYRutI/q/m/P7l1X1f8Aqth9HYLXgX5xHuuI0b5V g8fHlbixOa+LSsw5fQf5w7/QMscfdxcL6n9BwwP1cXvH5953/wDR+j+C1qsbHoEU1MqHgxob+RES WVPNlyG5zlP+8bXgAbBRAIgiR4Knk9G6TlgjIw6Xz32AO/zhBVxJNjOUTcZGJ8DSnk+pf4v8C4F/ T7XY1nZj/fX/AOSH4rjOq9E6l0mzZmVFrSYZa33Vu+Dv4L19Qvx6Mmp1GRW22p4hzHCQQtDl/imf GQMh96Hj830P8VpgDto+KJLqPrR9UX9M3ZuCDZgzL2cupn8rfP71y63sObHmgJ4zYP2g9ixEEGip JJJSoXa1znBrQS5xgAckleo/Vb6vM6Phh9oBzrwDc790cisfDv5rlfqJ0kZnUXZ1rZpw4LJ4Nrvo /wCbz9y9GWH8W5o8X3eB0GuTz6Blxx6qSSVDrPWcTo2J9pyZcXHbVU36T3eA/iVkwhKchCAMpS0A C9vpLiKP8YxNwGRhbaCdSx8vA+BABXZ42TTl49eTjuD6bWhzHDuCpc/K5sFe7DhEtjdj8FCQOyRJ Vuo9Qxum4lmZlO21V+GpcTw1o8SuQP8AjHd62mCPQn/Se+P82EsHKZ8wMsUOIR62Br9UGQG73CSq 9M6li9Uw2ZmK6a36EHRzXDlrh4hWlDKJjIxkKMTRBXLOa17Sx4DmuBDmnUEHsV5j9bfq/wDsfMFt AP2LIJNX8h3ev+5enqj1rplfVem3Yb43PE1OP5tjdWlWuR5o8vlBJ9E9Jjw7/RbKNh8fSRPQu9f7 PtPrb/T2d987dv3pLqLHfx+jA+ofU/CGH0HHkQ+8G9/9v6P/AEYW0h41Qox6qRxUxrB/ZEIi4/NM 5Ms5n9ORl9rYAoAKXEf4xqLicLIAJoaHsJ7B5gj7wF26Hk42Pl0ux8mtttLxDmOEgqTlc/sZoZa4 hG7HgdFSFinxVeo/Uui+n6v44ukby97Gnsxxlv38p6PqX9X6b/WGOXwZax7i5g/snn5rcAAAAEAc BXfiHxDHnxxx44yri4iZfkFkIEGy8v8A4waL7Oj1WVgmum4OtA7Atc0OPzK85XttlbLWOrsaHseC HNcJBB7ELCP1K+rxv9b7O6Jn0t7tn3TP4o8h8Rx4MXt5Iy0JMTHx7qlAk2Gl/i8ovr6ZkWvBFVtv 6Ke+0Q5w/J8l1ajVVXTW2qpoZWwQ1jRAAHYBSWfzGb3s08tcPGbpeBQpSSSSiS8d+xGf8/PU2/od n22I03fQ/wDPmqS6z7Oz7V9pj3+n6c+W7ckrv36fc/7m9j+1bw/9K0oIIBHB4SVPo2SMvpOHkAzv pZP9YCHfiFcVOcTGUoneJI+xKkkkkEqSSSSUpJJJJSkkkklKSSSSUrySWX+0m/8AOT9mz/2l9T+3 v4/zUlL7E+3+T93/AAUX+dOP/i+6kLsC3p7z+kxnb2D/AIN+v4O/KusXkHROq2dJ6lVmMktadtrB +dW76Q/u8165j305NFeRQ4PqtaHMcO4KufFOXOPOcgHoza/4XUftWwNiuzMkASeFiYv1u6Nk59mC LdjmO212v0rtPfa74+PK2yARB1BXKdc+ouLmOdkdNcMa86uqP804+UfR/Iq3LR5eRlHPKUOIeiQ2 B8Uyvo9WkvNmZv1u+rf6O1rzjt0AsHq0/wBl44+RWjj/AOMd4AGTggnu6uyP+i5p/Kp5fDM/zYjD PDpKEh+1HGOuj3CS41/+MfFA9mFYXeBeAPwBWfk/XzrOWfSwMdlLnaDaDbZ8u34IR+Gc2d4CA7yk K/BXHF7nP6jhdOoORmWtqrHE8uPg0ckqt0Tr2F1ql9mNLH1uh9T43Afmu07FcbifVP6wdavGT1Wx 1LDy+47rI8G19vnC7bpPRsDpFHo4dcE/zlrtXvP8pyGfDy2HGYjJ72e94fJHwSDInag3kznNY0uc Ya0SSeAAnXLfXnrgw8L9m0O/WcofpI5ZV3/zuPvVfBhlmyxxx/SO/YdSkmhbyv7fd/zp/bEn0/W4 /wCB/m4/zEliJLqfu2L93/Jez/gdmCz+NqXUfVH60fsx4wc1x+w2H2POvouPf+qe/wB65dJHNhhm xnHMWD9oPcKBINh9ta5r2h7CHNcJa4agg9wnXmH1f+tuZ0iKLQcjC/0RPuZ/xZ/gvQemda6b1Wvf h3B7vzqj7bG/FpXN81yOXlySRxw6TG317M0ZAt7nQqnf0bpORrdhUvJ7mts/eBKuJKrGUom4kx8j SXNZ9W+gsMjApnzbP5VeoxcbHEY9LKR4VtDf+pCIknSy5JfNOUv7xJVQUkmc5rGlzyGtGpJMABcv 1z684WG11HTYysnj1P8ABMPx/O+X3p2HBlzS4ccTL8h5lRIG7qdf6/i9FxfUsIfkvB9CidXHxPg0 LyzMzMjOybMrJdvutO5zv4DyCWZmZOdkOycqw23P+k535B4BBXR8lyUeWj+9kl80v2DwYZSvyUkk kri1SSSSSlIlHr+q37Pv9afZ6c758tuqSSB2P7dlPc9E/wCfm1vqbPR0j7b9KP7H6T711mP9q2D7 V6e/v6e6P+kkkuZ575z/ALm3/wAh+1nj9fql+Cy+p/8AOTaf2b9l/wCub9/y/NSSVfB84/m/+q/K k/X6PA9f/wCdO4/tj1vTnT/Q/L0/YsNJJdTy381H+a/6j8n0YDv1+qkkklMhSSSSSn//2Q==" preserveAspectRatio="xMidYMid meet" width="30" height="60"/>\n        </g>\n        <g transform="translate(100, 0)">\n          <text y="-5">*YMax</text><rect x=".5" y=".5" width="29" height="59" fill="none" stroke="blue"/>\n          <image xlink:href="data:image/jpeg;base64,/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAHgAA/+4ADkFkb2JlAGTAAAAAAf/b AIQAEAsLCwwLEAwMEBcPDQ8XGxQQEBQbHxcXFxcXHx4XGhoaGhceHiMlJyUjHi8vMzMvL0BAQEBA QEBAQEBAQEBAQAERDw8RExEVEhIVFBEUERQaFBYWFBomGhocGhomMCMeHh4eIzArLicnJy4rNTUw MDU1QEA/QEBAQEBAQEBAQEBA/8AAEQgAZABkAwEiAAIRAQMRAf/EAT8AAAEFAQEBAQEBAAAAAAAA AAMAAQIEBQYHCAkKCwEAAQUBAQEBAQEAAAAAAAAAAQACAwQFBgcICQoLEAABBAEDAgQCBQcGCAUD DDMBAAIRAwQhEjEFQVFhEyJxgTIGFJGhsUIjJBVSwWIzNHKC0UMHJZJT8OHxY3M1FqKygyZEk1Rk RcKjdDYX0lXiZfKzhMPTdePzRieUpIW0lcTU5PSltcXV5fVWZnaGlqa2xtbm9jdHV2d3h5ent8fX 5/cRAAICAQIEBAMEBQYHBwYFNQEAAhEDITESBEFRYXEiEwUygZEUobFCI8FS0fAzJGLhcoKSQ1MV Y3M08SUGFqKygwcmNcLSRJNUoxdkRVU2dGXi8rOEw9N14/NGlKSFtJXE1OT0pbXF1eX1VmZ2hpam tsbW5vYnN0dXZ3eHl6e3x//aAAwDAQACEQMRAD8A8/SSR8LCyc/JZi4rDZdYYa0flPgAgSACSaA1 JKkLWuc4NaC5x0AGpJXT9J+onUcwC3Od9jpOoYRutI/q/m/P7l1X1f8Aqth9HYLXgX5xHuuI0b5V g8fHlbixOa+LSsw5fQf5w7/QMscfdxcL6n9BwwP1cXvH5953/wDR+j+C1qsbHoEU1MqHgxob+RES WVPNlyG5zlP+8bXgAbBRAIgiR4Knk9G6TlgjIw6Xz32AO/zhBVxJNjOUTcZGJ8DSnk+pf4v8C4F/ T7XY1nZj/fX/AOSH4rjOq9E6l0mzZmVFrSYZa33Vu+Dv4L19Qvx6Mmp1GRW22p4hzHCQQtDl/imf GQMh96Hj830P8VpgDto+KJLqPrR9UX9M3ZuCDZgzL2cupn8rfP71y63sObHmgJ4zYP2g9ixEEGip JJJSoXa1znBrQS5xgAckleo/Vb6vM6Phh9oBzrwDc790cisfDv5rlfqJ0kZnUXZ1rZpw4LJ4Nrvo /wCbz9y9GWH8W5o8X3eB0GuTz6Blxx6qSSVDrPWcTo2J9pyZcXHbVU36T3eA/iVkwhKchCAMpS0A C9vpLiKP8YxNwGRhbaCdSx8vA+BABXZ42TTl49eTjuD6bWhzHDuCpc/K5sFe7DhEtjdj8FCQOyRJ Vuo9Qxum4lmZlO21V+GpcTw1o8SuQP8AjHd62mCPQn/Se+P82EsHKZ8wMsUOIR62Br9UGQG73CSq 9M6li9Uw2ZmK6a36EHRzXDlrh4hWlDKJjIxkKMTRBXLOa17Sx4DmuBDmnUEHsV5j9bfq/wDsfMFt AP2LIJNX8h3ev+5enqj1rplfVem3Yb43PE1OP5tjdWlWuR5o8vlBJ9E9Jjw7/RbKNh8fSRPQu9f7 PtPrb/T2d987dv3pLqLHfx+jA+ofU/CGH0HHkQ+8G9/9v6P/AEYW0h41Qox6qRxUxrB/ZEIi4/NM 5Ms5n9ORl9rYAoAKXEf4xqLicLIAJoaHsJ7B5gj7wF26Hk42Pl0ux8mtttLxDmOEgqTlc/sZoZa4 hG7HgdFSFinxVeo/Uui+n6v44ukby97Gnsxxlv38p6PqX9X6b/WGOXwZax7i5g/snn5rcAAAAEAc BXfiHxDHnxxx44yri4iZfkFkIEGy8v8A4waL7Oj1WVgmum4OtA7Atc0OPzK85XttlbLWOrsaHseC HNcJBB7ELCP1K+rxv9b7O6Jn0t7tn3TP4o8h8Rx4MXt5Iy0JMTHx7qlAk2Gl/i8ovr6ZkWvBFVtv 6Ke+0Q5w/J8l1ajVVXTW2qpoZWwQ1jRAAHYBSWfzGb3s08tcPGbpeBQpSSSSiS8d+xGf8/PU2/od n22I03fQ/wDPmqS6z7Oz7V9pj3+n6c+W7ckrv36fc/7m9j+1bw/9K0oIIBHB4SVPo2SMvpOHkAzv pZP9YCHfiFcVOcTGUoneJI+xKkkkkEqSSSSUpJJJJSkkkklKSSSSUrySWX+0m/8AOT9mz/2l9T+3 v4/zUlL7E+3+T93/AAUX+dOP/i+6kLsC3p7z+kxnb2D/AIN+v4O/KusXkHROq2dJ6lVmMktadtrB +dW76Q/u8165j305NFeRQ4PqtaHMcO4KufFOXOPOcgHoza/4XUftWwNiuzMkASeFiYv1u6Nk59mC LdjmO212v0rtPfa74+PK2yARB1BXKdc+ouLmOdkdNcMa86uqP804+UfR/Iq3LR5eRlHPKUOIeiQ2 B8Uyvo9WkvNmZv1u+rf6O1rzjt0AsHq0/wBl44+RWjj/AOMd4AGTggnu6uyP+i5p/Kp5fDM/zYjD PDpKEh+1HGOuj3CS41/+MfFA9mFYXeBeAPwBWfk/XzrOWfSwMdlLnaDaDbZ8u34IR+Gc2d4CA7yk K/BXHF7nP6jhdOoORmWtqrHE8uPg0ckqt0Tr2F1ql9mNLH1uh9T43Afmu07FcbifVP6wdavGT1Wx 1LDy+47rI8G19vnC7bpPRsDpFHo4dcE/zlrtXvP8pyGfDy2HGYjJ72e94fJHwSDInag3kznNY0uc Ya0SSeAAnXLfXnrgw8L9m0O/WcofpI5ZV3/zuPvVfBhlmyxxx/SO/YdSkmhbyv7fd/zp/bEn0/W4 /wCB/m4/zEliJLqfu2L93/Jez/gdmCz+NqXUfVH60fsx4wc1x+w2H2POvouPf+qe/wB65dJHNhhm xnHMWD9oPcKBINh9ta5r2h7CHNcJa4agg9wnXmH1f+tuZ0iKLQcjC/0RPuZ/xZ/gvQemda6b1Wvf h3B7vzqj7bG/FpXN81yOXlySRxw6TG317M0ZAt7nQqnf0bpORrdhUvJ7mts/eBKuJKrGUom4kx8j SXNZ9W+gsMjApnzbP5VeoxcbHEY9LKR4VtDf+pCIknSy5JfNOUv7xJVQUkmc5rGlzyGtGpJMABcv 1z684WG11HTYysnj1P8ABMPx/O+X3p2HBlzS4ccTL8h5lRIG7qdf6/i9FxfUsIfkvB9CidXHxPg0 LyzMzMjOybMrJdvutO5zv4DyCWZmZOdkOycqw23P+k535B4BBXR8lyUeWj+9kl80v2DwYZSvyUkk kri1SSSSSlIlHr+q37Pv9afZ6c758tuqSSB2P7dlPc9E/wCfm1vqbPR0j7b9KP7H6T711mP9q2D7 V6e/v6e6P+kkkuZ575z/ALm3/wAh+1nj9fql+Cy+p/8AOTaf2b9l/wCub9/y/NSSVfB84/m/+q/K k/X6PA9f/wCdO4/tj1vTnT/Q/L0/YsNJJdTy381H+a/6j8n0YDv1+qkkklMhSSSSSn//2Q==" preserveAspectRatio="xMaxYMax meet" width="30" height="60"/>\n        </g>\n      </g>\n      <g id="slice-group-1" transform="translate(120, 185)">\n        <text x="0" y="-20">---------- slice -------------------------</text>\n        <g>\n          <text y="-5">xMin*</text><rect x=".5" y=".5" width="29" height="59" fill="none" stroke="blue"/>\n          <image xlink:href="data:image/jpeg;base64,/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAHgAA/+4ADkFkb2JlAGTAAAAAAf/b AIQAEAsLCwwLEAwMEBcPDQ8XGxQQEBQbHxcXFxcXHx4XGhoaGhceHiMlJyUjHi8vMzMvL0BAQEBA QEBAQEBAQEBAQAERDw8RExEVEhIVFBEUERQaFBYWFBomGhocGhomMCMeHh4eIzArLicnJy4rNTUw MDU1QEA/QEBAQEBAQEBAQEBA/8AAEQgAZABkAwEiAAIRAQMRAf/EAT8AAAEFAQEBAQEBAAAAAAAA AAMAAQIEBQYHCAkKCwEAAQUBAQEBAQEAAAAAAAAAAQACAwQFBgcICQoLEAABBAEDAgQCBQcGCAUD DDMBAAIRAwQhEjEFQVFhEyJxgTIGFJGhsUIjJBVSwWIzNHKC0UMHJZJT8OHxY3M1FqKygyZEk1Rk RcKjdDYX0lXiZfKzhMPTdePzRieUpIW0lcTU5PSltcXV5fVWZnaGlqa2xtbm9jdHV2d3h5ent8fX 5/cRAAICAQIEBAMEBQYHBwYFNQEAAhEDITESBEFRYXEiEwUygZEUobFCI8FS0fAzJGLhcoKSQ1MV Y3M08SUGFqKygwcmNcLSRJNUoxdkRVU2dGXi8rOEw9N14/NGlKSFtJXE1OT0pbXF1eX1VmZ2hpam tsbW5vYnN0dXZ3eHl6e3x//aAAwDAQACEQMRAD8A8/SSR8LCyc/JZi4rDZdYYa0flPgAgSACSaA1 JKkLWuc4NaC5x0AGpJXT9J+onUcwC3Od9jpOoYRutI/q/m/P7l1X1f8Aqth9HYLXgX5xHuuI0b5V g8fHlbixOa+LSsw5fQf5w7/QMscfdxcL6n9BwwP1cXvH5953/wDR+j+C1qsbHoEU1MqHgxob+RES WVPNlyG5zlP+8bXgAbBRAIgiR4Knk9G6TlgjIw6Xz32AO/zhBVxJNjOUTcZGJ8DSnk+pf4v8C4F/ T7XY1nZj/fX/AOSH4rjOq9E6l0mzZmVFrSYZa33Vu+Dv4L19Qvx6Mmp1GRW22p4hzHCQQtDl/imf GQMh96Hj830P8VpgDto+KJLqPrR9UX9M3ZuCDZgzL2cupn8rfP71y63sObHmgJ4zYP2g9ixEEGip JJJSoXa1znBrQS5xgAckleo/Vb6vM6Phh9oBzrwDc790cisfDv5rlfqJ0kZnUXZ1rZpw4LJ4Nrvo /wCbz9y9GWH8W5o8X3eB0GuTz6Blxx6qSSVDrPWcTo2J9pyZcXHbVU36T3eA/iVkwhKchCAMpS0A C9vpLiKP8YxNwGRhbaCdSx8vA+BABXZ42TTl49eTjuD6bWhzHDuCpc/K5sFe7DhEtjdj8FCQOyRJ Vuo9Qxum4lmZlO21V+GpcTw1o8SuQP8AjHd62mCPQn/Se+P82EsHKZ8wMsUOIR62Br9UGQG73CSq 9M6li9Uw2ZmK6a36EHRzXDlrh4hWlDKJjIxkKMTRBXLOa17Sx4DmuBDmnUEHsV5j9bfq/wDsfMFt AP2LIJNX8h3ev+5enqj1rplfVem3Yb43PE1OP5tjdWlWuR5o8vlBJ9E9Jjw7/RbKNh8fSRPQu9f7 PtPrb/T2d987dv3pLqLHfx+jA+ofU/CGH0HHkQ+8G9/9v6P/AEYW0h41Qox6qRxUxrB/ZEIi4/NM 5Ms5n9ORl9rYAoAKXEf4xqLicLIAJoaHsJ7B5gj7wF26Hk42Pl0ux8mtttLxDmOEgqTlc/sZoZa4 hG7HgdFSFinxVeo/Uui+n6v44ukby97Gnsxxlv38p6PqX9X6b/WGOXwZax7i5g/snn5rcAAAAEAc BXfiHxDHnxxx44yri4iZfkFkIEGy8v8A4waL7Oj1WVgmum4OtA7Atc0OPzK85XttlbLWOrsaHseC HNcJBB7ELCP1K+rxv9b7O6Jn0t7tn3TP4o8h8Rx4MXt5Iy0JMTHx7qlAk2Gl/i8ovr6ZkWvBFVtv 6Ke+0Q5w/J8l1ajVVXTW2qpoZWwQ1jRAAHYBSWfzGb3s08tcPGbpeBQpSSSSiS8d+xGf8/PU2/od n22I03fQ/wDPmqS6z7Oz7V9pj3+n6c+W7ckrv36fc/7m9j+1bw/9K0oIIBHB4SVPo2SMvpOHkAzv pZP9YCHfiFcVOcTGUoneJI+xKkkkkEqSSSSUpJJJJSkkkklKSSSSUrySWX+0m/8AOT9mz/2l9T+3 v4/zUlL7E+3+T93/AAUX+dOP/i+6kLsC3p7z+kxnb2D/AIN+v4O/KusXkHROq2dJ6lVmMktadtrB +dW76Q/u8165j305NFeRQ4PqtaHMcO4KufFOXOPOcgHoza/4XUftWwNiuzMkASeFiYv1u6Nk59mC LdjmO212v0rtPfa74+PK2yARB1BXKdc+ouLmOdkdNcMa86uqP804+UfR/Iq3LR5eRlHPKUOIeiQ2 B8Uyvo9WkvNmZv1u+rf6O1rzjt0AsHq0/wBl44+RWjj/AOMd4AGTggnu6uyP+i5p/Kp5fDM/zYjD PDpKEh+1HGOuj3CS41/+MfFA9mFYXeBeAPwBWfk/XzrOWfSwMdlLnaDaDbZ8u34IR+Gc2d4CA7yk K/BXHF7nP6jhdOoORmWtqrHE8uPg0ckqt0Tr2F1ql9mNLH1uh9T43Afmu07FcbifVP6wdavGT1Wx 1LDy+47rI8G19vnC7bpPRsDpFHo4dcE/zlrtXvP8pyGfDy2HGYjJ72e94fJHwSDInag3kznNY0uc Ya0SSeAAnXLfXnrgw8L9m0O/WcofpI5ZV3/zuPvVfBhlmyxxx/SO/YdSkmhbyv7fd/zp/bEn0/W4 /wCB/m4/zEliJLqfu2L93/Jez/gdmCz+NqXUfVH60fsx4wc1x+w2H2POvouPf+qe/wB65dJHNhhm xnHMWD9oPcKBINh9ta5r2h7CHNcJa4agg9wnXmH1f+tuZ0iKLQcjC/0RPuZ/xZ/gvQemda6b1Wvf h3B7vzqj7bG/FpXN81yOXlySRxw6TG317M0ZAt7nQqnf0bpORrdhUvJ7mts/eBKuJKrGUom4kx8j SXNZ9W+gsMjApnzbP5VeoxcbHEY9LKR4VtDf+pCIknSy5JfNOUv7xJVQUkmc5rGlzyGtGpJMABcv 1z684WG11HTYysnj1P8ABMPx/O+X3p2HBlzS4ccTL8h5lRIG7qdf6/i9FxfUsIfkvB9CidXHxPg0 LyzMzMjOybMrJdvutO5zv4DyCWZmZOdkOycqw23P+k535B4BBXR8lyUeWj+9kl80v2DwYZSvyUkk kri1SSSSSlIlHr+q37Pv9afZ6c758tuqSSB2P7dlPc9E/wCfm1vqbPR0j7b9KP7H6T711mP9q2D7 V6e/v6e6P+kkkuZ575z/ALm3/wAh+1nj9fql+Cy+p/8AOTaf2b9l/wCub9/y/NSSVfB84/m/+q/K k/X6PA9f/wCdO4/tj1vTnT/Q/L0/YsNJJdTy381H+a/6j8n0YDv1+qkkklMhSSSSSn//2Q==" preserveAspectRatio="xMinYMin slice" width="30" height="60"/>\n        </g>\n        <g transform="translate(50,0)">\n          <text y="-5">xMid*</text><rect x=".5" y=".5" width="29" height="59" fill="none" stroke="blue"/>\n          <image xlink:href="data:image/jpeg;base64,/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAHgAA/+4ADkFkb2JlAGTAAAAAAf/b AIQAEAsLCwwLEAwMEBcPDQ8XGxQQEBQbHxcXFxcXHx4XGhoaGhceHiMlJyUjHi8vMzMvL0BAQEBA QEBAQEBAQEBAQAERDw8RExEVEhIVFBEUERQaFBYWFBomGhocGhomMCMeHh4eIzArLicnJy4rNTUw MDU1QEA/QEBAQEBAQEBAQEBA/8AAEQgAZABkAwEiAAIRAQMRAf/EAT8AAAEFAQEBAQEBAAAAAAAA AAMAAQIEBQYHCAkKCwEAAQUBAQEBAQEAAAAAAAAAAQACAwQFBgcICQoLEAABBAEDAgQCBQcGCAUD DDMBAAIRAwQhEjEFQVFhEyJxgTIGFJGhsUIjJBVSwWIzNHKC0UMHJZJT8OHxY3M1FqKygyZEk1Rk RcKjdDYX0lXiZfKzhMPTdePzRieUpIW0lcTU5PSltcXV5fVWZnaGlqa2xtbm9jdHV2d3h5ent8fX 5/cRAAICAQIEBAMEBQYHBwYFNQEAAhEDITESBEFRYXEiEwUygZEUobFCI8FS0fAzJGLhcoKSQ1MV Y3M08SUGFqKygwcmNcLSRJNUoxdkRVU2dGXi8rOEw9N14/NGlKSFtJXE1OT0pbXF1eX1VmZ2hpam tsbW5vYnN0dXZ3eHl6e3x//aAAwDAQACEQMRAD8A8/SSR8LCyc/JZi4rDZdYYa0flPgAgSACSaA1 JKkLWuc4NaC5x0AGpJXT9J+onUcwC3Od9jpOoYRutI/q/m/P7l1X1f8Aqth9HYLXgX5xHuuI0b5V g8fHlbixOa+LSsw5fQf5w7/QMscfdxcL6n9BwwP1cXvH5953/wDR+j+C1qsbHoEU1MqHgxob+RES WVPNlyG5zlP+8bXgAbBRAIgiR4Knk9G6TlgjIw6Xz32AO/zhBVxJNjOUTcZGJ8DSnk+pf4v8C4F/ T7XY1nZj/fX/AOSH4rjOq9E6l0mzZmVFrSYZa33Vu+Dv4L19Qvx6Mmp1GRW22p4hzHCQQtDl/imf GQMh96Hj830P8VpgDto+KJLqPrR9UX9M3ZuCDZgzL2cupn8rfP71y63sObHmgJ4zYP2g9ixEEGip JJJSoXa1znBrQS5xgAckleo/Vb6vM6Phh9oBzrwDc790cisfDv5rlfqJ0kZnUXZ1rZpw4LJ4Nrvo /wCbz9y9GWH8W5o8X3eB0GuTz6Blxx6qSSVDrPWcTo2J9pyZcXHbVU36T3eA/iVkwhKchCAMpS0A C9vpLiKP8YxNwGRhbaCdSx8vA+BABXZ42TTl49eTjuD6bWhzHDuCpc/K5sFe7DhEtjdj8FCQOyRJ Vuo9Qxum4lmZlO21V+GpcTw1o8SuQP8AjHd62mCPQn/Se+P82EsHKZ8wMsUOIR62Br9UGQG73CSq 9M6li9Uw2ZmK6a36EHRzXDlrh4hWlDKJjIxkKMTRBXLOa17Sx4DmuBDmnUEHsV5j9bfq/wDsfMFt AP2LIJNX8h3ev+5enqj1rplfVem3Yb43PE1OP5tjdWlWuR5o8vlBJ9E9Jjw7/RbKNh8fSRPQu9f7 PtPrb/T2d987dv3pLqLHfx+jA+ofU/CGH0HHkQ+8G9/9v6P/AEYW0h41Qox6qRxUxrB/ZEIi4/NM 5Ms5n9ORl9rYAoAKXEf4xqLicLIAJoaHsJ7B5gj7wF26Hk42Pl0ux8mtttLxDmOEgqTlc/sZoZa4 hG7HgdFSFinxVeo/Uui+n6v44ukby97Gnsxxlv38p6PqX9X6b/WGOXwZax7i5g/snn5rcAAAAEAc BXfiHxDHnxxx44yri4iZfkFkIEGy8v8A4waL7Oj1WVgmum4OtA7Atc0OPzK85XttlbLWOrsaHseC HNcJBB7ELCP1K+rxv9b7O6Jn0t7tn3TP4o8h8Rx4MXt5Iy0JMTHx7qlAk2Gl/i8ovr6ZkWvBFVtv 6Ke+0Q5w/J8l1ajVVXTW2qpoZWwQ1jRAAHYBSWfzGb3s08tcPGbpeBQpSSSSiS8d+xGf8/PU2/od n22I03fQ/wDPmqS6z7Oz7V9pj3+n6c+W7ckrv36fc/7m9j+1bw/9K0oIIBHB4SVPo2SMvpOHkAzv pZP9YCHfiFcVOcTGUoneJI+xKkkkkEqSSSSUpJJJJSkkkklKSSSSUrySWX+0m/8AOT9mz/2l9T+3 v4/zUlL7E+3+T93/AAUX+dOP/i+6kLsC3p7z+kxnb2D/AIN+v4O/KusXkHROq2dJ6lVmMktadtrB +dW76Q/u8165j305NFeRQ4PqtaHMcO4KufFOXOPOcgHoza/4XUftWwNiuzMkASeFiYv1u6Nk59mC LdjmO212v0rtPfa74+PK2yARB1BXKdc+ouLmOdkdNcMa86uqP804+UfR/Iq3LR5eRlHPKUOIeiQ2 B8Uyvo9WkvNmZv1u+rf6O1rzjt0AsHq0/wBl44+RWjj/AOMd4AGTggnu6uyP+i5p/Kp5fDM/zYjD PDpKEh+1HGOuj3CS41/+MfFA9mFYXeBeAPwBWfk/XzrOWfSwMdlLnaDaDbZ8u34IR+Gc2d4CA7yk K/BXHF7nP6jhdOoORmWtqrHE8uPg0ckqt0Tr2F1ql9mNLH1uh9T43Afmu07FcbifVP6wdavGT1Wx 1LDy+47rI8G19vnC7bpPRsDpFHo4dcE/zlrtXvP8pyGfDy2HGYjJ72e94fJHwSDInag3kznNY0uc Ya0SSeAAnXLfXnrgw8L9m0O/WcofpI5ZV3/zuPvVfBhlmyxxx/SO/YdSkmhbyv7fd/zp/bEn0/W4 /wCB/m4/zEliJLqfu2L93/Jez/gdmCz+NqXUfVH60fsx4wc1x+w2H2POvouPf+qe/wB65dJHNhhm xnHMWD9oPcKBINh9ta5r2h7CHNcJa4agg9wnXmH1f+tuZ0iKLQcjC/0RPuZ/xZ/gvQemda6b1Wvf h3B7vzqj7bG/FpXN81yOXlySRxw6TG317M0ZAt7nQqnf0bpORrdhUvJ7mts/eBKuJKrGUom4kx8j SXNZ9W+gsMjApnzbP5VeoxcbHEY9LKR4VtDf+pCIknSy5JfNOUv7xJVQUkmc5rGlzyGtGpJMABcv 1z684WG11HTYysnj1P8ABMPx/O+X3p2HBlzS4ccTL8h5lRIG7qdf6/i9FxfUsIfkvB9CidXHxPg0 LyzMzMjOybMrJdvutO5zv4DyCWZmZOdkOycqw23P+k535B4BBXR8lyUeWj+9kl80v2DwYZSvyUkk kri1SSSSSlIlHr+q37Pv9afZ6c758tuqSSB2P7dlPc9E/wCfm1vqbPR0j7b9KP7H6T711mP9q2D7 V6e/v6e6P+kkkuZ575z/ALm3/wAh+1nj9fql+Cy+p/8AOTaf2b9l/wCub9/y/NSSVfB84/m/+q/K k/X6PA9f/wCdO4/tj1vTnT/Q/L0/YsNJJdTy381H+a/6j8n0YDv1+qkkklMhSSSSSn//2Q==" preserveAspectRatio="xMidYMid slice" width="30" height="60"/>\n        </g>\n        <g transform="translate(100,0)">\n          <text y="-5">xMax*</text><rect x=".5" y=".5" width="29" height="59" fill="none" stroke="blue"/>\n          <image xlink:href="data:image/jpeg;base64,/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAHgAA/+4ADkFkb2JlAGTAAAAAAf/b AIQAEAsLCwwLEAwMEBcPDQ8XGxQQEBQbHxcXFxcXHx4XGhoaGhceHiMlJyUjHi8vMzMvL0BAQEBA QEBAQEBAQEBAQAERDw8RExEVEhIVFBEUERQaFBYWFBomGhocGhomMCMeHh4eIzArLicnJy4rNTUw MDU1QEA/QEBAQEBAQEBAQEBA/8AAEQgAZABkAwEiAAIRAQMRAf/EAT8AAAEFAQEBAQEBAAAAAAAA AAMAAQIEBQYHCAkKCwEAAQUBAQEBAQEAAAAAAAAAAQACAwQFBgcICQoLEAABBAEDAgQCBQcGCAUD DDMBAAIRAwQhEjEFQVFhEyJxgTIGFJGhsUIjJBVSwWIzNHKC0UMHJZJT8OHxY3M1FqKygyZEk1Rk RcKjdDYX0lXiZfKzhMPTdePzRieUpIW0lcTU5PSltcXV5fVWZnaGlqa2xtbm9jdHV2d3h5ent8fX 5/cRAAICAQIEBAMEBQYHBwYFNQEAAhEDITESBEFRYXEiEwUygZEUobFCI8FS0fAzJGLhcoKSQ1MV Y3M08SUGFqKygwcmNcLSRJNUoxdkRVU2dGXi8rOEw9N14/NGlKSFtJXE1OT0pbXF1eX1VmZ2hpam tsbW5vYnN0dXZ3eHl6e3x//aAAwDAQACEQMRAD8A8/SSR8LCyc/JZi4rDZdYYa0flPgAgSACSaA1 JKkLWuc4NaC5x0AGpJXT9J+onUcwC3Od9jpOoYRutI/q/m/P7l1X1f8Aqth9HYLXgX5xHuuI0b5V g8fHlbixOa+LSsw5fQf5w7/QMscfdxcL6n9BwwP1cXvH5953/wDR+j+C1qsbHoEU1MqHgxob+RES WVPNlyG5zlP+8bXgAbBRAIgiR4Knk9G6TlgjIw6Xz32AO/zhBVxJNjOUTcZGJ8DSnk+pf4v8C4F/ T7XY1nZj/fX/AOSH4rjOq9E6l0mzZmVFrSYZa33Vu+Dv4L19Qvx6Mmp1GRW22p4hzHCQQtDl/imf GQMh96Hj830P8VpgDto+KJLqPrR9UX9M3ZuCDZgzL2cupn8rfP71y63sObHmgJ4zYP2g9ixEEGip JJJSoXa1znBrQS5xgAckleo/Vb6vM6Phh9oBzrwDc790cisfDv5rlfqJ0kZnUXZ1rZpw4LJ4Nrvo /wCbz9y9GWH8W5o8X3eB0GuTz6Blxx6qSSVDrPWcTo2J9pyZcXHbVU36T3eA/iVkwhKchCAMpS0A C9vpLiKP8YxNwGRhbaCdSx8vA+BABXZ42TTl49eTjuD6bWhzHDuCpc/K5sFe7DhEtjdj8FCQOyRJ Vuo9Qxum4lmZlO21V+GpcTw1o8SuQP8AjHd62mCPQn/Se+P82EsHKZ8wMsUOIR62Br9UGQG73CSq 9M6li9Uw2ZmK6a36EHRzXDlrh4hWlDKJjIxkKMTRBXLOa17Sx4DmuBDmnUEHsV5j9bfq/wDsfMFt AP2LIJNX8h3ev+5enqj1rplfVem3Yb43PE1OP5tjdWlWuR5o8vlBJ9E9Jjw7/RbKNh8fSRPQu9f7 PtPrb/T2d987dv3pLqLHfx+jA+ofU/CGH0HHkQ+8G9/9v6P/AEYW0h41Qox6qRxUxrB/ZEIi4/NM 5Ms5n9ORl9rYAoAKXEf4xqLicLIAJoaHsJ7B5gj7wF26Hk42Pl0ux8mtttLxDmOEgqTlc/sZoZa4 hG7HgdFSFinxVeo/Uui+n6v44ukby97Gnsxxlv38p6PqX9X6b/WGOXwZax7i5g/snn5rcAAAAEAc BXfiHxDHnxxx44yri4iZfkFkIEGy8v8A4waL7Oj1WVgmum4OtA7Atc0OPzK85XttlbLWOrsaHseC HNcJBB7ELCP1K+rxv9b7O6Jn0t7tn3TP4o8h8Rx4MXt5Iy0JMTHx7qlAk2Gl/i8ovr6ZkWvBFVtv 6Ke+0Q5w/J8l1ajVVXTW2qpoZWwQ1jRAAHYBSWfzGb3s08tcPGbpeBQpSSSSiS8d+xGf8/PU2/od n22I03fQ/wDPmqS6z7Oz7V9pj3+n6c+W7ckrv36fc/7m9j+1bw/9K0oIIBHB4SVPo2SMvpOHkAzv pZP9YCHfiFcVOcTGUoneJI+xKkkkkEqSSSSUpJJJJSkkkklKSSSSUrySWX+0m/8AOT9mz/2l9T+3 v4/zUlL7E+3+T93/AAUX+dOP/i+6kLsC3p7z+kxnb2D/AIN+v4O/KusXkHROq2dJ6lVmMktadtrB +dW76Q/u8165j305NFeRQ4PqtaHMcO4KufFOXOPOcgHoza/4XUftWwNiuzMkASeFiYv1u6Nk59mC LdjmO212v0rtPfa74+PK2yARB1BXKdc+ouLmOdkdNcMa86uqP804+UfR/Iq3LR5eRlHPKUOIeiQ2 B8Uyvo9WkvNmZv1u+rf6O1rzjt0AsHq0/wBl44+RWjj/AOMd4AGTggnu6uyP+i5p/Kp5fDM/zYjD PDpKEh+1HGOuj3CS41/+MfFA9mFYXeBeAPwBWfk/XzrOWfSwMdlLnaDaDbZ8u34IR+Gc2d4CA7yk K/BXHF7nP6jhdOoORmWtqrHE8uPg0ckqt0Tr2F1ql9mNLH1uh9T43Afmu07FcbifVP6wdavGT1Wx 1LDy+47rI8G19vnC7bpPRsDpFHo4dcE/zlrtXvP8pyGfDy2HGYjJ72e94fJHwSDInag3kznNY0uc Ya0SSeAAnXLfXnrgw8L9m0O/WcofpI5ZV3/zuPvVfBhlmyxxx/SO/YdSkmhbyv7fd/zp/bEn0/W4 /wCB/m4/zEliJLqfu2L93/Jez/gdmCz+NqXUfVH60fsx4wc1x+w2H2POvouPf+qe/wB65dJHNhhm xnHMWD9oPcKBINh9ta5r2h7CHNcJa4agg9wnXmH1f+tuZ0iKLQcjC/0RPuZ/xZ/gvQemda6b1Wvf h3B7vzqj7bG/FpXN81yOXlySRxw6TG317M0ZAt7nQqnf0bpORrdhUvJ7mts/eBKuJKrGUom4kx8j SXNZ9W+gsMjApnzbP5VeoxcbHEY9LKR4VtDf+pCIknSy5JfNOUv7xJVQUkmc5rGlzyGtGpJMABcv 1z684WG11HTYysnj1P8ABMPx/O+X3p2HBlzS4ccTL8h5lRIG7qdf6/i9FxfUsIfkvB9CidXHxPg0 LyzMzMjOybMrJdvutO5zv4DyCWZmZOdkOycqw23P+k535B4BBXR8lyUeWj+9kl80v2DwYZSvyUkk kri1SSSSSlIlHr+q37Pv9afZ6c758tuqSSB2P7dlPc9E/wCfm1vqbPR0j7b9KP7H6T711mP9q2D7 V6e/v6e6P+kkkuZ575z/ALm3/wAh+1nj9fql+Cy+p/8AOTaf2b9l/wCub9/y/NSSVfB84/m/+q/K k/X6PA9f/wCdO4/tj1vTnT/Q/L0/YsNJJdTy381H+a/6j8n0YDv1+qkkklMhSSSSSn//2Q==" preserveAspectRatio="xMaxYMax slice" width="30" height="60"/>\n        </g>\n      </g>\n      <g id="slide-group-2" transform="translate(300, 155) translate(0, 30)">\n        <text x="0" y="-20">---------- slice ---------------------</text>\n        <g>\n          <text y="-5">*YMin</text><rect x=".5" y=".5" width="49" height="29" fill="none" stroke="blue"/>\n          <image xlink:href="data:image/jpeg;base64,/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAHgAA/+4ADkFkb2JlAGTAAAAAAf/b AIQAEAsLCwwLEAwMEBcPDQ8XGxQQEBQbHxcXFxcXHx4XGhoaGhceHiMlJyUjHi8vMzMvL0BAQEBA QEBAQEBAQEBAQAERDw8RExEVEhIVFBEUERQaFBYWFBomGhocGhomMCMeHh4eIzArLicnJy4rNTUw MDU1QEA/QEBAQEBAQEBAQEBA/8AAEQgAZABkAwEiAAIRAQMRAf/EAT8AAAEFAQEBAQEBAAAAAAAA AAMAAQIEBQYHCAkKCwEAAQUBAQEBAQEAAAAAAAAAAQACAwQFBgcICQoLEAABBAEDAgQCBQcGCAUD DDMBAAIRAwQhEjEFQVFhEyJxgTIGFJGhsUIjJBVSwWIzNHKC0UMHJZJT8OHxY3M1FqKygyZEk1Rk RcKjdDYX0lXiZfKzhMPTdePzRieUpIW0lcTU5PSltcXV5fVWZnaGlqa2xtbm9jdHV2d3h5ent8fX 5/cRAAICAQIEBAMEBQYHBwYFNQEAAhEDITESBEFRYXEiEwUygZEUobFCI8FS0fAzJGLhcoKSQ1MV Y3M08SUGFqKygwcmNcLSRJNUoxdkRVU2dGXi8rOEw9N14/NGlKSFtJXE1OT0pbXF1eX1VmZ2hpam tsbW5vYnN0dXZ3eHl6e3x//aAAwDAQACEQMRAD8A8/SSR8LCyc/JZi4rDZdYYa0flPgAgSACSaA1 JKkLWuc4NaC5x0AGpJXT9J+onUcwC3Od9jpOoYRutI/q/m/P7l1X1f8Aqth9HYLXgX5xHuuI0b5V g8fHlbixOa+LSsw5fQf5w7/QMscfdxcL6n9BwwP1cXvH5953/wDR+j+C1qsbHoEU1MqHgxob+RES WVPNlyG5zlP+8bXgAbBRAIgiR4Knk9G6TlgjIw6Xz32AO/zhBVxJNjOUTcZGJ8DSnk+pf4v8C4F/ T7XY1nZj/fX/AOSH4rjOq9E6l0mzZmVFrSYZa33Vu+Dv4L19Qvx6Mmp1GRW22p4hzHCQQtDl/imf GQMh96Hj830P8VpgDto+KJLqPrR9UX9M3ZuCDZgzL2cupn8rfP71y63sObHmgJ4zYP2g9ixEEGip JJJSoXa1znBrQS5xgAckleo/Vb6vM6Phh9oBzrwDc790cisfDv5rlfqJ0kZnUXZ1rZpw4LJ4Nrvo /wCbz9y9GWH8W5o8X3eB0GuTz6Blxx6qSSVDrPWcTo2J9pyZcXHbVU36T3eA/iVkwhKchCAMpS0A C9vpLiKP8YxNwGRhbaCdSx8vA+BABXZ42TTl49eTjuD6bWhzHDuCpc/K5sFe7DhEtjdj8FCQOyRJ Vuo9Qxum4lmZlO21V+GpcTw1o8SuQP8AjHd62mCPQn/Se+P82EsHKZ8wMsUOIR62Br9UGQG73CSq 9M6li9Uw2ZmK6a36EHRzXDlrh4hWlDKJjIxkKMTRBXLOa17Sx4DmuBDmnUEHsV5j9bfq/wDsfMFt AP2LIJNX8h3ev+5enqj1rplfVem3Yb43PE1OP5tjdWlWuR5o8vlBJ9E9Jjw7/RbKNh8fSRPQu9f7 PtPrb/T2d987dv3pLqLHfx+jA+ofU/CGH0HHkQ+8G9/9v6P/AEYW0h41Qox6qRxUxrB/ZEIi4/NM 5Ms5n9ORl9rYAoAKXEf4xqLicLIAJoaHsJ7B5gj7wF26Hk42Pl0ux8mtttLxDmOEgqTlc/sZoZa4 hG7HgdFSFinxVeo/Uui+n6v44ukby97Gnsxxlv38p6PqX9X6b/WGOXwZax7i5g/snn5rcAAAAEAc BXfiHxDHnxxx44yri4iZfkFkIEGy8v8A4waL7Oj1WVgmum4OtA7Atc0OPzK85XttlbLWOrsaHseC HNcJBB7ELCP1K+rxv9b7O6Jn0t7tn3TP4o8h8Rx4MXt5Iy0JMTHx7qlAk2Gl/i8ovr6ZkWvBFVtv 6Ke+0Q5w/J8l1ajVVXTW2qpoZWwQ1jRAAHYBSWfzGb3s08tcPGbpeBQpSSSSiS8d+xGf8/PU2/od n22I03fQ/wDPmqS6z7Oz7V9pj3+n6c+W7ckrv36fc/7m9j+1bw/9K0oIIBHB4SVPo2SMvpOHkAzv pZP9YCHfiFcVOcTGUoneJI+xKkkkkEqSSSSUpJJJJSkkkklKSSSSUrySWX+0m/8AOT9mz/2l9T+3 v4/zUlL7E+3+T93/AAUX+dOP/i+6kLsC3p7z+kxnb2D/AIN+v4O/KusXkHROq2dJ6lVmMktadtrB +dW76Q/u8165j305NFeRQ4PqtaHMcO4KufFOXOPOcgHoza/4XUftWwNiuzMkASeFiYv1u6Nk59mC LdjmO212v0rtPfa74+PK2yARB1BXKdc+ouLmOdkdNcMa86uqP804+UfR/Iq3LR5eRlHPKUOIeiQ2 B8Uyvo9WkvNmZv1u+rf6O1rzjt0AsHq0/wBl44+RWjj/AOMd4AGTggnu6uyP+i5p/Kp5fDM/zYjD PDpKEh+1HGOuj3CS41/+MfFA9mFYXeBeAPwBWfk/XzrOWfSwMdlLnaDaDbZ8u34IR+Gc2d4CA7yk K/BXHF7nP6jhdOoORmWtqrHE8uPg0ckqt0Tr2F1ql9mNLH1uh9T43Afmu07FcbifVP6wdavGT1Wx 1LDy+47rI8G19vnC7bpPRsDpFHo4dcE/zlrtXvP8pyGfDy2HGYjJ72e94fJHwSDInag3kznNY0uc Ya0SSeAAnXLfXnrgw8L9m0O/WcofpI5ZV3/zuPvVfBhlmyxxx/SO/YdSkmhbyv7fd/zp/bEn0/W4 /wCB/m4/zEliJLqfu2L93/Jez/gdmCz+NqXUfVH60fsx4wc1x+w2H2POvouPf+qe/wB65dJHNhhm xnHMWD9oPcKBINh9ta5r2h7CHNcJa4agg9wnXmH1f+tuZ0iKLQcjC/0RPuZ/xZ/gvQemda6b1Wvf h3B7vzqj7bG/FpXN81yOXlySRxw6TG317M0ZAt7nQqnf0bpORrdhUvJ7mts/eBKuJKrGUom4kx8j SXNZ9W+gsMjApnzbP5VeoxcbHEY9LKR4VtDf+pCIknSy5JfNOUv7xJVQUkmc5rGlzyGtGpJMABcv 1z684WG11HTYysnj1P8ABMPx/O+X3p2HBlzS4ccTL8h5lRIG7qdf6/i9FxfUsIfkvB9CidXHxPg0 LyzMzMjOybMrJdvutO5zv4DyCWZmZOdkOycqw23P+k535B4BBXR8lyUeWj+9kl80v2DwYZSvyUkk kri1SSSSSlIlHr+q37Pv9afZ6c758tuqSSB2P7dlPc9E/wCfm1vqbPR0j7b9KP7H6T711mP9q2D7 V6e/v6e6P+kkkuZ575z/ALm3/wAh+1nj9fql+Cy+p/8AOTaf2b9l/wCub9/y/NSSVfB84/m/+q/K k/X6PA9f/wCdO4/tj1vTnT/Q/L0/YsNJJdTy381H+a/6j8n0YDv1+qkkklMhSSSSSn//2Q==" preserveAspectRatio="xMinYMin slice" width="50" height="30"/>\n        </g>\n        <g transform="translate(70,0)">\n          <text y="-5">*YMid</text><rect x=".5" y=".5" width="49" height="29" fill="none" stroke="blue"/>\n          <image xlink:href="data:image/jpeg;base64,/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAHgAA/+4ADkFkb2JlAGTAAAAAAf/b AIQAEAsLCwwLEAwMEBcPDQ8XGxQQEBQbHxcXFxcXHx4XGhoaGhceHiMlJyUjHi8vMzMvL0BAQEBA QEBAQEBAQEBAQAERDw8RExEVEhIVFBEUERQaFBYWFBomGhocGhomMCMeHh4eIzArLicnJy4rNTUw MDU1QEA/QEBAQEBAQEBAQEBA/8AAEQgAZABkAwEiAAIRAQMRAf/EAT8AAAEFAQEBAQEBAAAAAAAA AAMAAQIEBQYHCAkKCwEAAQUBAQEBAQEAAAAAAAAAAQACAwQFBgcICQoLEAABBAEDAgQCBQcGCAUD DDMBAAIRAwQhEjEFQVFhEyJxgTIGFJGhsUIjJBVSwWIzNHKC0UMHJZJT8OHxY3M1FqKygyZEk1Rk RcKjdDYX0lXiZfKzhMPTdePzRieUpIW0lcTU5PSltcXV5fVWZnaGlqa2xtbm9jdHV2d3h5ent8fX 5/cRAAICAQIEBAMEBQYHBwYFNQEAAhEDITESBEFRYXEiEwUygZEUobFCI8FS0fAzJGLhcoKSQ1MV Y3M08SUGFqKygwcmNcLSRJNUoxdkRVU2dGXi8rOEw9N14/NGlKSFtJXE1OT0pbXF1eX1VmZ2hpam tsbW5vYnN0dXZ3eHl6e3x//aAAwDAQACEQMRAD8A8/SSR8LCyc/JZi4rDZdYYa0flPgAgSACSaA1 JKkLWuc4NaC5x0AGpJXT9J+onUcwC3Od9jpOoYRutI/q/m/P7l1X1f8Aqth9HYLXgX5xHuuI0b5V g8fHlbixOa+LSsw5fQf5w7/QMscfdxcL6n9BwwP1cXvH5953/wDR+j+C1qsbHoEU1MqHgxob+RES WVPNlyG5zlP+8bXgAbBRAIgiR4Knk9G6TlgjIw6Xz32AO/zhBVxJNjOUTcZGJ8DSnk+pf4v8C4F/ T7XY1nZj/fX/AOSH4rjOq9E6l0mzZmVFrSYZa33Vu+Dv4L19Qvx6Mmp1GRW22p4hzHCQQtDl/imf GQMh96Hj830P8VpgDto+KJLqPrR9UX9M3ZuCDZgzL2cupn8rfP71y63sObHmgJ4zYP2g9ixEEGip JJJSoXa1znBrQS5xgAckleo/Vb6vM6Phh9oBzrwDc790cisfDv5rlfqJ0kZnUXZ1rZpw4LJ4Nrvo /wCbz9y9GWH8W5o8X3eB0GuTz6Blxx6qSSVDrPWcTo2J9pyZcXHbVU36T3eA/iVkwhKchCAMpS0A C9vpLiKP8YxNwGRhbaCdSx8vA+BABXZ42TTl49eTjuD6bWhzHDuCpc/K5sFe7DhEtjdj8FCQOyRJ Vuo9Qxum4lmZlO21V+GpcTw1o8SuQP8AjHd62mCPQn/Se+P82EsHKZ8wMsUOIR62Br9UGQG73CSq 9M6li9Uw2ZmK6a36EHRzXDlrh4hWlDKJjIxkKMTRBXLOa17Sx4DmuBDmnUEHsV5j9bfq/wDsfMFt AP2LIJNX8h3ev+5enqj1rplfVem3Yb43PE1OP5tjdWlWuR5o8vlBJ9E9Jjw7/RbKNh8fSRPQu9f7 PtPrb/T2d987dv3pLqLHfx+jA+ofU/CGH0HHkQ+8G9/9v6P/AEYW0h41Qox6qRxUxrB/ZEIi4/NM 5Ms5n9ORl9rYAoAKXEf4xqLicLIAJoaHsJ7B5gj7wF26Hk42Pl0ux8mtttLxDmOEgqTlc/sZoZa4 hG7HgdFSFinxVeo/Uui+n6v44ukby97Gnsxxlv38p6PqX9X6b/WGOXwZax7i5g/snn5rcAAAAEAc BXfiHxDHnxxx44yri4iZfkFkIEGy8v8A4waL7Oj1WVgmum4OtA7Atc0OPzK85XttlbLWOrsaHseC HNcJBB7ELCP1K+rxv9b7O6Jn0t7tn3TP4o8h8Rx4MXt5Iy0JMTHx7qlAk2Gl/i8ovr6ZkWvBFVtv 6Ke+0Q5w/J8l1ajVVXTW2qpoZWwQ1jRAAHYBSWfzGb3s08tcPGbpeBQpSSSSiS8d+xGf8/PU2/od n22I03fQ/wDPmqS6z7Oz7V9pj3+n6c+W7ckrv36fc/7m9j+1bw/9K0oIIBHB4SVPo2SMvpOHkAzv pZP9YCHfiFcVOcTGUoneJI+xKkkkkEqSSSSUpJJJJSkkkklKSSSSUrySWX+0m/8AOT9mz/2l9T+3 v4/zUlL7E+3+T93/AAUX+dOP/i+6kLsC3p7z+kxnb2D/AIN+v4O/KusXkHROq2dJ6lVmMktadtrB +dW76Q/u8165j305NFeRQ4PqtaHMcO4KufFOXOPOcgHoza/4XUftWwNiuzMkASeFiYv1u6Nk59mC LdjmO212v0rtPfa74+PK2yARB1BXKdc+ouLmOdkdNcMa86uqP804+UfR/Iq3LR5eRlHPKUOIeiQ2 B8Uyvo9WkvNmZv1u+rf6O1rzjt0AsHq0/wBl44+RWjj/AOMd4AGTggnu6uyP+i5p/Kp5fDM/zYjD PDpKEh+1HGOuj3CS41/+MfFA9mFYXeBeAPwBWfk/XzrOWfSwMdlLnaDaDbZ8u34IR+Gc2d4CA7yk K/BXHF7nP6jhdOoORmWtqrHE8uPg0ckqt0Tr2F1ql9mNLH1uh9T43Afmu07FcbifVP6wdavGT1Wx 1LDy+47rI8G19vnC7bpPRsDpFHo4dcE/zlrtXvP8pyGfDy2HGYjJ72e94fJHwSDInag3kznNY0uc Ya0SSeAAnXLfXnrgw8L9m0O/WcofpI5ZV3/zuPvVfBhlmyxxx/SO/YdSkmhbyv7fd/zp/bEn0/W4 /wCB/m4/zEliJLqfu2L93/Jez/gdmCz+NqXUfVH60fsx4wc1x+w2H2POvouPf+qe/wB65dJHNhhm xnHMWD9oPcKBINh9ta5r2h7CHNcJa4agg9wnXmH1f+tuZ0iKLQcjC/0RPuZ/xZ/gvQemda6b1Wvf h3B7vzqj7bG/FpXN81yOXlySRxw6TG317M0ZAt7nQqnf0bpORrdhUvJ7mts/eBKuJKrGUom4kx8j SXNZ9W+gsMjApnzbP5VeoxcbHEY9LKR4VtDf+pCIknSy5JfNOUv7xJVQUkmc5rGlzyGtGpJMABcv 1z684WG11HTYysnj1P8ABMPx/O+X3p2HBlzS4ccTL8h5lRIG7qdf6/i9FxfUsIfkvB9CidXHxPg0 LyzMzMjOybMrJdvutO5zv4DyCWZmZOdkOycqw23P+k535B4BBXR8lyUeWj+9kl80v2DwYZSvyUkk kri1SSSSSlIlHr+q37Pv9afZ6c758tuqSSB2P7dlPc9E/wCfm1vqbPR0j7b9KP7H6T711mP9q2D7 V6e/v6e6P+kkkuZ575z/ALm3/wAh+1nj9fql+Cy+p/8AOTaf2b9l/wCub9/y/NSSVfB84/m/+q/K k/X6PA9f/wCdO4/tj1vTnT/Q/L0/YsNJJdTy381H+a/6j8n0YDv1+qkkklMhSSSSSn//2Q==" preserveAspectRatio="xMidYMid slice" width="50" height="30"/>\n        </g>\n        <g transform="translate(0,50)">\n          <text y="-5">*YMax</text><rect x=".5" y=".5" width="49" height="29" fill="none" stroke="blue"/>\n          <image xlink:href="data:image/jpeg;base64,/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAHgAA/+4ADkFkb2JlAGTAAAAAAf/b AIQAEAsLCwwLEAwMEBcPDQ8XGxQQEBQbHxcXFxcXHx4XGhoaGhceHiMlJyUjHi8vMzMvL0BAQEBA QEBAQEBAQEBAQAERDw8RExEVEhIVFBEUERQaFBYWFBomGhocGhomMCMeHh4eIzArLicnJy4rNTUw MDU1QEA/QEBAQEBAQEBAQEBA/8AAEQgAZABkAwEiAAIRAQMRAf/EAT8AAAEFAQEBAQEBAAAAAAAA AAMAAQIEBQYHCAkKCwEAAQUBAQEBAQEAAAAAAAAAAQACAwQFBgcICQoLEAABBAEDAgQCBQcGCAUD DDMBAAIRAwQhEjEFQVFhEyJxgTIGFJGhsUIjJBVSwWIzNHKC0UMHJZJT8OHxY3M1FqKygyZEk1Rk RcKjdDYX0lXiZfKzhMPTdePzRieUpIW0lcTU5PSltcXV5fVWZnaGlqa2xtbm9jdHV2d3h5ent8fX 5/cRAAICAQIEBAMEBQYHBwYFNQEAAhEDITESBEFRYXEiEwUygZEUobFCI8FS0fAzJGLhcoKSQ1MV Y3M08SUGFqKygwcmNcLSRJNUoxdkRVU2dGXi8rOEw9N14/NGlKSFtJXE1OT0pbXF1eX1VmZ2hpam tsbW5vYnN0dXZ3eHl6e3x//aAAwDAQACEQMRAD8A8/SSR8LCyc/JZi4rDZdYYa0flPgAgSACSaA1 JKkLWuc4NaC5x0AGpJXT9J+onUcwC3Od9jpOoYRutI/q/m/P7l1X1f8Aqth9HYLXgX5xHuuI0b5V g8fHlbixOa+LSsw5fQf5w7/QMscfdxcL6n9BwwP1cXvH5953/wDR+j+C1qsbHoEU1MqHgxob+RES WVPNlyG5zlP+8bXgAbBRAIgiR4Knk9G6TlgjIw6Xz32AO/zhBVxJNjOUTcZGJ8DSnk+pf4v8C4F/ T7XY1nZj/fX/AOSH4rjOq9E6l0mzZmVFrSYZa33Vu+Dv4L19Qvx6Mmp1GRW22p4hzHCQQtDl/imf GQMh96Hj830P8VpgDto+KJLqPrR9UX9M3ZuCDZgzL2cupn8rfP71y63sObHmgJ4zYP2g9ixEEGip JJJSoXa1znBrQS5xgAckleo/Vb6vM6Phh9oBzrwDc790cisfDv5rlfqJ0kZnUXZ1rZpw4LJ4Nrvo /wCbz9y9GWH8W5o8X3eB0GuTz6Blxx6qSSVDrPWcTo2J9pyZcXHbVU36T3eA/iVkwhKchCAMpS0A C9vpLiKP8YxNwGRhbaCdSx8vA+BABXZ42TTl49eTjuD6bWhzHDuCpc/K5sFe7DhEtjdj8FCQOyRJ Vuo9Qxum4lmZlO21V+GpcTw1o8SuQP8AjHd62mCPQn/Se+P82EsHKZ8wMsUOIR62Br9UGQG73CSq 9M6li9Uw2ZmK6a36EHRzXDlrh4hWlDKJjIxkKMTRBXLOa17Sx4DmuBDmnUEHsV5j9bfq/wDsfMFt AP2LIJNX8h3ev+5enqj1rplfVem3Yb43PE1OP5tjdWlWuR5o8vlBJ9E9Jjw7/RbKNh8fSRPQu9f7 PtPrb/T2d987dv3pLqLHfx+jA+ofU/CGH0HHkQ+8G9/9v6P/AEYW0h41Qox6qRxUxrB/ZEIi4/NM 5Ms5n9ORl9rYAoAKXEf4xqLicLIAJoaHsJ7B5gj7wF26Hk42Pl0ux8mtttLxDmOEgqTlc/sZoZa4 hG7HgdFSFinxVeo/Uui+n6v44ukby97Gnsxxlv38p6PqX9X6b/WGOXwZax7i5g/snn5rcAAAAEAc BXfiHxDHnxxx44yri4iZfkFkIEGy8v8A4waL7Oj1WVgmum4OtA7Atc0OPzK85XttlbLWOrsaHseC HNcJBB7ELCP1K+rxv9b7O6Jn0t7tn3TP4o8h8Rx4MXt5Iy0JMTHx7qlAk2Gl/i8ovr6ZkWvBFVtv 6Ke+0Q5w/J8l1ajVVXTW2qpoZWwQ1jRAAHYBSWfzGb3s08tcPGbpeBQpSSSSiS8d+xGf8/PU2/od n22I03fQ/wDPmqS6z7Oz7V9pj3+n6c+W7ckrv36fc/7m9j+1bw/9K0oIIBHB4SVPo2SMvpOHkAzv pZP9YCHfiFcVOcTGUoneJI+xKkkkkEqSSSSUpJJJJSkkkklKSSSSUrySWX+0m/8AOT9mz/2l9T+3 v4/zUlL7E+3+T93/AAUX+dOP/i+6kLsC3p7z+kxnb2D/AIN+v4O/KusXkHROq2dJ6lVmMktadtrB +dW76Q/u8165j305NFeRQ4PqtaHMcO4KufFOXOPOcgHoza/4XUftWwNiuzMkASeFiYv1u6Nk59mC LdjmO212v0rtPfa74+PK2yARB1BXKdc+ouLmOdkdNcMa86uqP804+UfR/Iq3LR5eRlHPKUOIeiQ2 B8Uyvo9WkvNmZv1u+rf6O1rzjt0AsHq0/wBl44+RWjj/AOMd4AGTggnu6uyP+i5p/Kp5fDM/zYjD PDpKEh+1HGOuj3CS41/+MfFA9mFYXeBeAPwBWfk/XzrOWfSwMdlLnaDaDbZ8u34IR+Gc2d4CA7yk K/BXHF7nP6jhdOoORmWtqrHE8uPg0ckqt0Tr2F1ql9mNLH1uh9T43Afmu07FcbifVP6wdavGT1Wx 1LDy+47rI8G19vnC7bpPRsDpFHo4dcE/zlrtXvP8pyGfDy2HGYjJ72e94fJHwSDInag3kznNY0uc Ya0SSeAAnXLfXnrgw8L9m0O/WcofpI5ZV3/zuPvVfBhlmyxxx/SO/YdSkmhbyv7fd/zp/bEn0/W4 /wCB/m4/zEliJLqfu2L93/Jez/gdmCz+NqXUfVH60fsx4wc1x+w2H2POvouPf+qe/wB65dJHNhhm xnHMWD9oPcKBINh9ta5r2h7CHNcJa4agg9wnXmH1f+tuZ0iKLQcjC/0RPuZ/xZ/gvQemda6b1Wvf h3B7vzqj7bG/FpXN81yOXlySRxw6TG317M0ZAt7nQqnf0bpORrdhUvJ7mts/eBKuJKrGUom4kx8j SXNZ9W+gsMjApnzbP5VeoxcbHEY9LKR4VtDf+pCIknSy5JfNOUv7xJVQUkmc5rGlzyGtGpJMABcv 1z684WG11HTYysnj1P8ABMPx/O+X3p2HBlzS4ccTL8h5lRIG7qdf6/i9FxfUsIfkvB9CidXHxPg0 LyzMzMjOybMrJdvutO5zv4DyCWZmZOdkOycqw23P+k535B4BBXR8lyUeWj+9kl80v2DwYZSvyUkk kri1SSSSSlIlHr+q37Pv9afZ6c758tuqSSB2P7dlPc9E/wCfm1vqbPR0j7b9KP7H6T711mP9q2D7 V6e/v6e6P+kkkuZ575z/ALm3/wAh+1nj9fql+Cy+p/8AOTaf2b9l/wCub9/y/NSSVfB84/m/+q/K k/X6PA9f/wCdO4/tj1vTnT/Q/L0/YsNJJdTy381H+a/6j8n0YDv1+qkkklMhSSSSSn//2Q==" preserveAspectRatio="xMaxYMax slice" width="50" height="30"/>\n        </g>\n      </g>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.9 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>'},
  {name: 'coords-viewattr-03-b.svg', svg: '<svg version="1.1" baseProfile="basic" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="CL" author="BB" status="accepted"\n    version="$Revision: 1.6 $" testname="$RCSfile: coords-viewattr-03-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/coords.html#ViewBoxAttribute">\n      <p>\n        This file tests the allowed syntax of the viewBox attribute.  The viewBox attribute is a list of\n        four numbers min-x, min-y, width and height, separated by whitespace and/or a comma.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>      \n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        In the rendered result, you should see 6 identical light blue shapes.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: coords-viewattr-03-b.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <text font-size="20" x="240" y="28" text-anchor="middle">&lt;svg&gt; \'viewBox\' attribute</text>\n\n    <g fill="lightblue" stroke="black">\n\n      <svg x="35" y="50" width="100" height="100" viewBox="0 0 200 200" overflow="visible">\n        <path fill-rule="evenodd" d="M20,20 Q180,20 180,180 Q20,180 20,20 Z M20,180 Q20,20 180,20 Q180,180 20,180 Z M100,40 L160,100 100,160 40,100 Z"/>\n      </svg>\n      <text font-size="13.5" x="85" y="155" text-anchor="middle" fill="black" stroke="none">viewBox="0 0 200 200"</text>\n      <text font-size="13.5" x="85" y="170" text-anchor="middle" fill="black" stroke="none">overflow="visible" </text>\n\n      <svg x="35" y="180" width="100" height="100" viewBox="0 0 200 200" overflow="hidden">\n        <path fill-rule="evenodd" d="M20,20 Q180,20 180,180 Q20,180 20,20 Z M20,180 Q20,20 180,20 Q180,180 20,180 Z M100,40 L160,100 100,160 40,100 Z"/>\n      </svg>\n      <text font-size="13.5" x="85" y="285" text-anchor="middle" fill="black" stroke="none">viewBox="0 0 200 200"</text>\n      <text font-size="13.5" x="85" y="300" text-anchor="middle" fill="black" stroke="none">overflow="hidden" </text>\n\n      <svg x="190" y="50" width="100" height="100" viewBox="0,0,200,200" overflow="visible">\n        <path fill-rule="evenodd" d="M20,20 Q180,20 180,180 Q20,180 20,20 Z M20,180 Q20,20 180,20 Q180,180 20,180 Z M100,40 L160,100 100,160 40,100 Z"/>\n      </svg>\n      <text font-size="13.5" x="240" y="155" text-anchor="middle" fill="black" stroke="none">viewBox="0,0,200,200"</text>\n      <text font-size="13.5" x="240" y="170" text-anchor="middle" fill="black" stroke="none">overflow="visible" </text>\n\n      <svg x="190" y="180" width="100" height="100" viewBox="0,0,200,200" overflow="hidden">\n        <path fill-rule="evenodd" d="M20,20 Q180,20 180,180 Q20,180 20,20 Z M20,180 Q20,20 180,20 Q180,180 20,180 Z M100,40 L160,100 100,160 40,100 Z"/>\n      </svg>\n      <text font-size="13.5" x="240" y="285" text-anchor="middle" fill="black" stroke="none">viewBox="0,0,200,200"</text>\n      <text font-size="13.5" x="240" y="300" text-anchor="middle" fill="black" stroke="none">overflow="hidden" </text>\n\n      <svg x="345" y="50" width="100" height="100" viewBox="0,0,   200, 200" overflow="visible">\n        <path fill-rule="evenodd" d="M20,20 Q180,20 180,180 Q20,180 20,20 Z M20,180 Q20,20 180,20 Q180,180 20,180 Z M100,40 L160,100 100,160 40,100 Z"/>\n      </svg>\n      <text font-size="13.5" x="395" y="155" text-anchor="middle" fill="black" stroke="none">viewBox="0,0,   200, 200"</text>\n      <text font-size="13.5" x="395" y="170" text-anchor="middle" fill="black" stroke="none">overflow="visible" </text>\n\n      <svg x="345" y="180" width="100" height="100" viewBox="0,0,   200, 200" overflow="hidden">\n        <path fill-rule="evenodd" d="M20,20 Q180,20 180,180 Q20,180 20,20 Z M20,180 Q20,20 180,20 Q180,180 20,180 Z M100,40 L160,100 100,160 40,100 Z"/>\n      </svg>\n      <text font-size="13.5" x="395" y="285" text-anchor="middle" fill="black" stroke="none">viewBox="0,0,   200, 200"</text>\n      <text font-size="13.5" x="395" y="300" text-anchor="middle" fill="black" stroke="none">overflow="hidden" </text>\n\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.6 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'imp-path-01-f.svg', svg: '<svg id="svg-root" width="100%" height="100%" viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/" template-version="1.4" reviewer="CL" author="Microsoft" status="reviewed" version="$Revision: 1.5 $" testname="$RCSfile: imp-path-01-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/implnote.html#PathElementImplementationNotes">\n			<p>\n        Tests that markers are drawn on zero-length \'path\' and \'line\' segments.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n			<p>Run the test. No interaction required.</p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Test passes if there are two blue boxes, positioned as in the reference image.\n      </p>  \n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: imp-path-01-f.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <defs>\n        <marker id="testMarker">\n            <rect width="96" height="96" fill="blue" />\n        </marker>\n    </defs>\n    <path d="m 0 0 L 0 0" stroke-width="25" marker-end="url(#testMarker)" />\n    <line x1="0" x2="0" y1="100" y2="100" stroke-width="25" marker-end="url(#testMarker)" />\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.5 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>\n</svg>\n'},
  {name: 'masking-filter-01-f.svg', svg: '<svg version="1.1" baseProfile="full" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="AG" author="CM" status="accepted"\n    version="$Revision: 1.7 $" testname="$RCSfile: masking-filter-01-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/masking.html#Introduction">\n      <p>\n        This tests that the \'filter\' property does not apply to \'mask\'.\n      </p>\n      <p>\n        The mask \'m\' covers a rectangular area (200 x 200) except for a window\n        (100 x 100) in the top left hand corner. Initially the mask window is\n        set on top of the green square. Hence, the green square is shown and\n        the red square is covered. If filters are supported the window within\n        the mask will be shifted by an offset of 100,100 placing it on top of\n        the red square.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The test passes if a green square is shown.  If any\n        red shows, the test has failed.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: masking-filter-01-f.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <g shape-rendering="geometricPrecision">\n      <text font-size="18" x="10" y="35">Testing \'filter\' applied to \'mask\'</text>\n\n      <defs>\n        <filter id="f" x="0" y="0" width="200" height="200"\n                filterUnits="userSpaceOnUse" filterPrimitiveUnits="userSpaceOnUse">\n          <feOffset dx="100" dy="100"/>\n        </filter>\n        <mask id="m" x="0" y="0" width="200" height="200"\n              maskUnits="userSpaceOnUse" maskContentUnits="userSpaceOnUse"\n              filter="url(#f)">\n          <rect width="100" height="100" fill="white"/>\n        </mask>\n      </defs>\n\n      <g mask="url(#m)" transform="translate(10,50)">\n        <rect width="100" height="100" fill="green"/>\n        <rect x="101" y="101" width="99" height="99" fill="red"/>\n      </g>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.7 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'masking-intro-01-f.svg', svg: '<svg version="1.1" baseProfile="full" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="CL" author="BB" status="accepted"\n    version="$Revision: 1.6 $" testname="$RCSfile: masking-intro-01-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/masking.html#Introduction">\n      <p>\n        The rules are different regarding the geometry of a shape when clipping and masking.\n        For example, a clip-path does not take into account the stroke of the shape used for clipping.\n        It is however, used when masking.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The test is passed if there are two identical darkblue circles at the top of the illustration, and\n        below those two circles, two more circles should appear. They are of lighter appearance,\n        the one on the left has a darker and thick stroke.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: masking-intro-01-f.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <g shape-rendering="geometricPrecision">\n      <title id="test-title">masking-mask-04-f.svg</title>\n      <desc id="test-desc">Tests the impact of strokes within clipPath and mask</desc>\n      <text font-size="18" x="240" y="35" text-anchor="middle">Testing stroke inclusion for \'clip-path\' and \'mask\'</text>\n\n      <defs>\n        <clipPath id="one" clipPathUnits="objectBoundingBox">\n          <circle cx="0.3" cy="0.5" r="0.2" stroke-width="0.15" fill="none" stroke="red"/>\n          <circle cx="0.7" cy="0.5" r="0.2" stroke-width="0.15" fill="none" stroke="none"/>\n        </clipPath>\n      </defs>\n\n      <rect x="150" y="0" width="200" height="200" fill="darkblue" clip-path="url(#one)"/>\n      <text x="50" y="110">With a \'clip-path\':</text>\n\n      <defs>\n        <mask id="two" maskUnits="objectBoundingBox" maskContentUnits="objectBoundingBox" color-interpolation="linearRGB">\n          <circle cx="0.3" cy="0.5" r="0.2" stroke-width="0.15" fill="blue" stroke="red"/>\n          <circle cx="0.7" cy="0.5" r="0.2" stroke-width="0.15" fill="blue" stroke="none"/>\n        </mask>\n      </defs>\n\n      <rect x="150" y="150" width="200" height="200" fill="darkblue" mask="url(#two)"/>\n      <text x="50" y="260">With a \'mask\':</text>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.6 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'masking-mask-01-b.svg', svg: '<svg version="1.1" baseProfile="basic" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Haroon Sheikh" status="accepted"\n    version="$Revision: 1.8 $" testname="$RCSfile: masking-mask-01-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/masking.html#Masking">\n      <p>\n        Test to see if the masking features using the mask element and mask\n        property are available.\n      </p>\n      <p>\n        A red rectangle is displayed in the background to help view the result\n        of transparency and masking.\n      </p>\n      <p>\n        From top to bottom, the tests are as follows.\n      </p>\n      <p>\n        In the top test, a linear gradient is used inside the mask to change the opacity\n        of the rectangle from 1.0 (at the top) to 0.5 (at the bottom).\n      </p>\n      <p>\n        In the second test, a simple 50% opaque rectangle is used as a mask.\n      </p>\n      <p>\n        In the third test, no mask is used, but a rectangle is shown with 50% opacity.\n        The second and third test should look the same.\n      </p>\n      <p>\n        Lastly, a string of text has a mask applied to it. The mask only covers a partial\n        area of the text, so the text should only be half visible. Also the mask consists\n        of 4 rectangles with various levels of opacity.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The rendered picture should match the reference image, except\n        variations are possible in the labelling text (per CSS2 rules).\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: masking-mask-01-b.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n  <style type="text/css">\n  @font-face {\n     font-family: larabie-anglepoise;\n     src: url(woffs/anglepoi.woff) format("woff");\n     }\n  </style>\n    <defs>\n      <font horiz-adv-x="313">\n        <!-- Converted from Larabie Anglepoise by Batik ttf2svg -->\n        <font-face font-family="larabie-anglepoise" units-per-em="1000" panose-1="0 0 4 0 0 0 0 0 0 0" ascent="703" descent="-300" alphabetic="0"/>\n        <missing-glyph horiz-adv-x="500" d="M63 0V700H438V0H63ZM125 63H375V638H125V63Z"/>\n        <glyph unicode="S" glyph-name="S" horiz-adv-x="385" d="M371 1H29V144H264Q264 151 264 166Q265 180 265 188Q265 212 249 212H132Q83 212 55 247Q29 279 29 329V566H335V422H136V375Q136 360 144 356Q148 355 168 355H279Q327 355 352 309Q371 273 371 221V1Z"/>\n        <glyph unicode="V" glyph-name="V" horiz-adv-x="351" d="M365 563L183 -33L0 563H101L183 296L270 563H365Z"/>\n        <glyph unicode="G" glyph-name="G" horiz-adv-x="367" d="M355 1H18V564H355V420H125V144H248V211H156V355H355V1Z"/>\n        <hkern g1="V" g2="G" k="-40"/>\n      </font>\n    </defs>\n    <g font-family="SVGFreeSansASCII,sans-serif">\n    <text font-size="14" x="10" y="20">Test for mask support</text>\n    <!-- Draw a red rectangle in the background -->\n    <rect x="10" y="30" width="100" height="260" fill="red"/>\n    <!-- Apply a gradient ramp based opacity -->\n    <mask id="mask1" maskUnits="userSpaceOnUse" x="60" y="50" width="100" height="60" color-interpolation="linearRGB">\n      <defs>\n        <linearGradient gradientUnits="userSpaceOnUse" id="Grad1" x1="60" y1="50" x2="60" y2="120">\n          <stop stop-color="white" stop-opacity="1" offset="0"/>\n          <stop stop-color="white" stop-opacity="0.5" offset="1"/>\n        </linearGradient>\n      </defs>\n      <rect x="60" y="50" width="100" height="60" fill="url(#Grad1)"/>\n    </mask>\n    <rect x="60" y="50" width="100" height="60" fill="lime" mask="url(#mask1)"/>\n    <text font-size="12" x="200" y="65">Mask with linear gradient from</text>\n    <text font-size="12" x="200" y="80">opacity=1 to opactity=0.5</text>\n    <!-- Simulate a uniform opacity using a mask -->\n    <mask id="mask2" maskUnits="userSpaceOnUse" x="60" y="120" width="100" height="30" color-interpolation="linearRGB">\n      <rect x="60" y="120" width="100" height="30" fill-opacity="0.5" fill="white"/>\n    </mask>\n    <rect x="60" y="120" width="100" height="30" fill="lime" mask="url(#mask2)"/>\n    <text font-size="12" x="200" y="135">Mask with uniform opacity of 0.5</text>\n    <!-- Apply a uniform opacity -->\n    <rect x="60" y="160" width="100" height="30" fill="lime" fill-opacity="0.5"/>\n    <text font-size="12" x="200" y="175">Rectangle with uniform opacity of 0.5</text>\n    <!-- Apply a mask to text -->\n    <mask id="mask3" maskUnits="userSpaceOnUse" x="60" y="200" width="200" height="100" color-interpolation="linearRGB">\n      <rect x="60" y="200" width="200" height="25" fill="white" fill-opacity="0.5"/>\n      <rect x="60" y="225" width="200" height="25" fill="white" fill-opacity="0.2"/>\n      <rect x="60" y="250" width="200" height="25" fill="white" fill-opacity="1"/>\n      <rect x="60" y="275" width="200" height="25" fill="white" fill-opacity="0.7"/>\n    </mask>\n    <text x="60" y="280" font-family="larabie-anglepoise" font-size="110" fill="lime" mask="url(#mask3)">SVG</text>\n    <text  font-size="12" x="200" y="225">Text with mask containing rectangles</text>\n    <text  font-size="12" x="200" y="240">of various opacities</text>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.8 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'masking-mask-02-f.svg', svg: '<svg id="svg-root" width="100%" height="100%" viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/" template-version="1.4" reviewer="CL" author="Microsoft" status="accepted" version="$Revision: 1.3 $" testname="$RCSfile: masking-mask-02-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://dev.w3.org/SVG/profiles/1.1F2/publish/masking.html#Masking">\n      <p>\n        If the \'mask\' property references a \'mask\' element containing no children, the element referencing it is not rendered.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n			<p>Run the test. No interaction required.</p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Test passes if there is a single green rectangle, with no red visible on the page.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: masking-mask-02-f.svg,v $</title>\n    <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <mask id="testMask" />\n    <rect x="100" y="100" width="250" height="150" fill="green" />\n    <rect x="100" y="100" width="250" height="150" fill="red" mask="url(#testMask)" />\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.3 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>'},
  {name: 'masking-opacity-01-b.svg', svg: '<svg version="1.1" baseProfile="basic" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Haroon Sheikh" status="accepted"\n    version="$Revision: 1.6 $" testname="$RCSfile: masking-opacity-01-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/masking.html#ObjectAndGroupOpacityProperties">\n      <p>\n        Test to see the effect of applying an opacity property to a group.\n      </p>\n      <p>\n        A blue rectangle with a green rectangle on top are contained in a\n        group. This opacity of the group and the opacity of the rectangles are\n        changed in this test. A red rectangle is provided in the background so\n        that opacity changes are obvious visually.\n      </p>\n      <p>\n        From top to bottom, the tests are as follows.\n      </p>\n      <p>\n        In the top test, the opacities of the group and the individual rectangles are\n        all set to 1. \n      </p>\n      <p>\n        In the second test, the group is given an opacity of 0.5. \n      </p>\n      <p>\n        In the third test, the group maintains a group opacity of 1 whereas each individual\n        rectangle is given an opacity of 0.5 in the group. \n      </p>\n      <p>\n        Lastly, the group and individual rectangles are all given an opacity of 0.5.\n      </p>\n\n\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        In the top test, the green rectangle should appear on top of the blue\n        rectangle.\n      </p>\n      <p>\n        In the second test, the blue\n        rectangle should not show through in the region where the green and blue overlap.\n      </p>\n      <p>\n        In the third test, the blue rectangle\n        should show through in the overlap region.\n      </p>\n      <p>\n        Lastly, the\n        result should be similar to the previous test only fainter (because the opacity) is\n        resulting in less contribution.\n      </p>\n      <p>\n        The rendered picture should match the reference image exactly, except for possible\n        variations in the labelling text (per CSS2 rules).\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: masking-opacity-01-b.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <text font-size="24" x="50" y="27">Test for opacity property on a group.</text>\n    <rect x="10" y="30" width="100" height="260" fill="red"/>\n    <g opacity="1">\n      <rect x="60" y="50" width="80" height="40" fill="blue"/>\n      <rect x="70" y="60" width="80" height="40" fill="lime"/>\n    </g>\n    <text font-size="20" x="200" y="62">Group opacity: 1</text>\n    <text font-size="20" x="200" y="80">Blue rectangle opacity: 1</text>\n    <text font-size="20" x="200" y="98">Green rectangle opacity: 1</text>\n    <g opacity="0.5">\n      <rect x="60" y="110" width="80" height="40" fill="blue"/>\n      <rect x="70" y="120" width="80" height="40" fill="lime"/>\n    </g>\n    <text font-size="20" x="200" y="122">Group opacity: 0.5</text>\n    <text font-size="20" x="200" y="140">Blue rectangle opacity: 1</text>\n    <text font-size="20" x="200" y="158">Green rectangle opacity: 1</text>\n    <g opacity="1">\n      <rect x="60" y="170" width="80" height="40" fill="blue" opacity=".5"/>\n      <rect x="70" y="180" width="80" height="40" fill="lime" opacity=".5"/>\n    </g>\n    <text font-size="20" x="200" y="182">Group opacity: 1</text>\n    <text font-size="20" x="200" y="200">Blue rectangle opacity: 0.5</text>\n    <text font-size="20" x="200" y="218">Green rectangle opacity: 0.5</text>\n    <g opacity="0.5">\n      <rect x="60" y="230" width="80" height="40" fill="blue" opacity=".5"/>\n      <rect x="70" y="240" width="80" height="40" fill="lime" opacity=".5"/>\n    </g>\n    <text font-size="20" x="200" y="242">Group opacity: 0.5</text>\n    <text font-size="20" x="200" y="260">Blue rectangle opacity: 0.5</text>\n    <text font-size="20" x="200" y="278">Green rectangle opacity: 0.5</text>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.6 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'masking-path-01-b.svg', svg: '<svg version="1.1" baseProfile="basic" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="CL" author="LH" status="accepted"\n    version="$Revision: 1.7 $" testname="$RCSfile: masking-path-01-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/masking.html#ClippingPaths">\n      <p>\n        Test to see if the basic clipping works using the clipPath element\n        and the clip-path property.\n      </p>\n      <p>\n        This test uses the following elements : &lt;clipPath&gt; and the following\n        properties : clip-path.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The test at the top shows an orange rectangle (with black stroke) being clipped by another rectangle.\n        So only the middle portion of the orange rectangle should be visible. Also the black stroke should\n        only be visible along the top and bottom edge of the rectangle.\n      </p>\n      <p>\n        The example at the bottom has a group containing a text string and two rectangles. The group\n        has a clipping path defined using two  overlapping rectangles. Of concern is the overlapping area\n        shared by the two rectangles. There should not be holes in this overlapping area, the\n        clip region is the union of the two rectangles. For clarity,\n        guide rectangles in grey show the position of the clipping rectangles.\n      </p>\n      <p>\n        The rendered picture should match the reference image exactly, except for possible\n        variations in the labelling text (per CSS2 rules).\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: masking-path-01-b.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <g shape-rendering="geometricPrecision">\n      <!--text font-size="14"  x="10" y="20">Test for clipping using clipPath element</text-->\n      <defs>\n        <clipPath id="clip1">\n          <rect x="200" y="10" width="60" height="100"/>\n        </clipPath>\n        <clipPath id="clip2">\n          <rect x="90" y="150" width="175" height="100"/>\n          <rect x="225" y="160" width="95" height="75"/>\n        </clipPath>\n      </defs>\n      <rect x="20" y="20" width="440" height="60" fill="orange" stroke="black" stroke-width="5" clip-path="url(#clip1)"/>\n      <text font-size="30" x="20" y="130">Rectangle being clipped</text>\n      <g clip-path="url(#clip2)">\n        <rect x="115" y="190" width="225" height="40" fill="aqua" stroke="blue" stroke-width="5"/>\n        <rect x="115" y="240" width="225" height="40" fill="lime" stroke="green" stroke-width="5"/>\n        <text font-size="30" x="115" y="180">Line of text to be clipped</text>\n      </g>\n      <text font-size="30" x="20" y="280">Group being clipped</text>\n      <!--  show the two rects and the overlap area -->\n      <g fill="none" stroke="#999" stroke-width="2">\n        <rect x="90" y="150" width="175" height="100"/>\n        <rect x="225" y="160" width="95" height="75"/>\n      </g>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.7 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'masking-path-02-b.svg', svg: '<svg version="1.1" baseProfile="basic" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Haroon Sheikh" status="accepted"\n    version="$Revision: 1.8 $" testname="$RCSfile: masking-path-02-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/masking.html#ClippingPaths">\n      <p>\n        Test to see if clipPathUnits attribute is handled properly on a\n        clipPath element. Only tests the userSpaceOnUse and\n        objectBoundingBox items of the clipPathUnits. userSpace has been\n        tested by the previous test as it is the default.\n      </p>\n      <p>\n        The test at the top shows a pink rectangle that has been clipped by a\n        rectangular clipping path. The clipping path is defined using clipPathUnits=objectBoundingBox.\n        \n      </p>\n      <p>\n        The example at the bottom a rotated blue rectangle that has been clipped by a\n        rectangular clipping path. The clipping path is defined using clipPathUnits=userSpaceOnUse.\n        \n      </p>\n      <p>\n        The rendered picture should match the reference image exactly, except for possible\n        variations in the labelling text (per CSS2 rules).\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The test passes if the pink rectangle and blue diamond do not have any\n        color painted outside of their black borders.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: masking-path-02-b.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <g shape-rendering="geometricPrecision">\n      <clipPath id="clip1" clipPathUnits="objectBoundingBox">\n        <rect x=".25" y=".5" width=".6" height="1"/>\n      </clipPath>\n      <rect x="10" y="10" width="430" height="80" fill="#F08" clip-path="url(#clip1)"/>\n      <rect x="117" y="50" width="258" height="40" fill="none" stroke="black" stroke-width="4"/>\n      <text font-size="30" x="20" y="130">clipPathUnits=objectBoundingBox</text>\n      <clipPath id="clip2" clipPathUnits="userSpaceOnUse">\n        <rect x="60" y="60" width="80" height="80"/>\n      </clipPath>\n      <rect transform="translate(100 200) rotate(-45)" x="0" y="0" width="120" height="120" fill="blue" clip-path="url(#clip2)"/>\n      <rect transform="translate(100 200) rotate(-45)" x="60" y="60" width="60" height="60" fill="none" stroke="black" stroke-width="4"/>\n      <text font-size="30" x="20" y="280">clipPathUnits=userSpaceOnUse</text>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.8 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'masking-path-03-b.svg', svg: '<svg version="1.1" baseProfile="basic" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Jon Ferraiolo" status="accepted"\n    version="$Revision: 1.7 $" testname="$RCSfile: masking-path-03-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/masking.html#ClippingPaths">\n      <p>\n        Test \'overflow\'/\'clip\' on outermost and inner \'svg\' elements.\n      </p>\n      <p>\n        There are two parts to the test. The first part tests viewport clipping\n        on outermost \'svg\' elements. The second part tests viewport clipping\n        on inner \'svg\' elements.\n      </p>\n      <p>\n        The test case also tests the initial value of the \'overflow\' property\n        to ensure that it is set to \'hidden\' for all \'svg\' elements.\n        Tester should zoom out and/or pan to check this.\n      </p>\n      <p>\n        To test clipping to the outermost \'svg\' element,\n        a rectangle with a light blue interior, a light red border and a black\n        string that says "Clip to outer \'svg\'" is painted four times such that\n        it will overflow each of the top, left, right and bottom\n        sides of the bounds of the outermost \'svg\' element, respectively.\n      </p>\n      <p>\n        To test clipping to inner \'svg\' elements, a rectangle with a light red\n        interior, a light blue border and a black string that says "Clip to\n        inner \'svg\'" is painted four times such that it will overflow each of\n        the top, left, right and bottom sides of the bounds of an inner \'svg\'\n        element, respectively.  \n      </p>\n      <p>\n        Note that minor text layout differences, as are permissible under CSS2\n        rules, can lead to slightly different visual results regarding where\n        the text strings get clipped.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>The test passes if:</p>\n      <ul>\n        <li>The four "Outer Clip" boxed strings must not render outside the\n        outermost \'svg\' element (the 480x360 rectangular viewport) and\n        must continue to be clipped to this viewport if the image is zoomed in or out,\n        or panned.</li>\n        <li>The four "Inner Clip" boxed strings must not render outside the\n        bounds of the green rectangle.</li>\n      </ul>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: masking-path-03-b.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <g shape-rendering="geometricPrecision">\n      <!--text font-size="18" text-anchor="middle" x="240" y="70">Test \'overflow\'/\'clip\' on outermost and inner \'svg\' elements</text-->\n      <text font-size="18" x="10" y="70">Test \'overflow\'/\'clip\' on outermost and inner \'svg\' elements</text>\n      <!-- Test initial value for \'overflow\' property (i.e., hidden)\n       on outermost \'svg\' -->\n      <g font-size="48" stroke-width="2">\n        <g transform="translate(115,-20)">\n          <rect width="250" height="60" fill="#ccccff" stroke="#ff8888"/>\n          <text x="15" y="45">Outer Clip</text>\n        </g>\n        <g transform="translate(-175,150)">\n          <rect width="250" height="60" fill="#ccccff" stroke="#ff8888"/>\n          <text x="15" y="45">Outer Clip</text>\n        </g>\n        <g transform="translate(405,150)">\n          <rect width="250" height="60" fill="#ccccff" stroke="#ff8888"/>\n          <text x="15" y="45">Outer Clip</text>\n        </g>\n        <g transform="translate(115,330)">\n          <rect width="250" height="60" fill="#ccccff" stroke="#ff8888"/>\n          <text x="15" y="45">Outer Clip</text>\n        </g>\n      </g>\n      <!-- Test initial value for \'overflow\' property (i.e., hidden)\n       on inner \'svg\' -->\n      <rect x="115" y="100" width="250" height="160" fill="none" stroke="#006600" stroke-width="5"/>\n      <svg xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="115" y="100" width="250" height="160">\n        <g font-size="32" stroke-width="2">\n          <g transform="translate(50,-15)">\n            <rect width="150" height="35" fill="#ffaaaa" stroke="#6666ff"/>\n            <text x="6" y="26">Inner Clip</text>\n          </g>\n          <g transform="translate(-50,62.5)">\n            <rect width="150" height="35" fill="#ffaaaa" stroke="#6666ff"/>\n            <text x="6" y="26">Inner Clip</text>\n          </g>\n          <g transform="translate(150,62.5)">\n            <rect width="150" height="35" fill="#ffaaaa" stroke="#6666ff"/>\n            <text x="6" y="26">Inner Clip</text>\n          </g>\n          <g transform="translate(50,140)">\n            <rect width="150" height="35" fill="#ffaaaa" stroke="#6666ff"/>\n            <text x="6" y="26">Inner Clip</text>\n          </g>\n        </g>\n      </svg>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.7 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'masking-path-04-b.svg', svg: '<svg version="1.1" baseProfile="basic" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Chris Lilley" status="accepted"\n    version="$Revision: 1.5 $" testname="$RCSfile: masking-path-04-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/masking.html#ClippingPaths">\n      <p>\n        This test exercises basic user-specified clip paths, using a text\n        string (i.e., content of a \'text\' element) as the clip path.\n      </p>\n      <p>\n        There is a rectangular image of a swirly blue pattern with large\n        yellow text, "Clip Test" superimposed. The image is a PNG file,\n        imported into the picture via the \'image\' element.\n      </p>\n      <p>\n        The test uses the \'rect\' element, as well as basic fill (solid primary\n        colors), stroke (black 1-pixel lines), font-family (Arial and\n        Impact) and font-size properties.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The rendered picture should match the reference image, except for\n        possible variations in the labelling text (per CSS2 rules).\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: masking-path-04-b.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <g shape-rendering="geometricPrecision">\n      <defs>\n        <clipPath id="sample" clipPathUnits="userSpaceOnUse">\n          <text x="45" y="270" font-size="100" font-family="Impact">Clip Test</text>\n        </clipPath>\n      </defs>\n\n      <g>\n        <image xlink:href="' + Images['bluesquidj.png'] + '" preserveAspectRatio="none" x="30" y="20" width="410" height="140"/>\n        <text x="55" y="130" font-size="100" font-family="Impact" fill="yellow">Clip Test</text>\n      </g>\n      <g>\n        <image xlink:href="' + Images['bluesquidj.png'] + '" preserveAspectRatio="none" x="20" y="170" width="410" height="160" clip-path="url(#sample)"/>\n      </g>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.5 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'masking-path-05-f.svg', svg: '<svg version="1.1" baseProfile="basic" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Haroon Sheikh" status="accepted"\n    version="$Revision: 1.6 $" testname="$RCSfile: masking-path-05-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/masking.html#ClippingPaths">\n      <p>\n        Test to see if clip-rule property has been implemented properly.\n      </p>\n      <p>\n        The test at the top shows a red rectangle that has been clipped by a\n        clipping path that overlaps itself.\n      </p>\n      <p>\n        The test at the bottom shows a blue rectangle that has been clipped by a\n        clipping path that overlaps itself.\n      </p>\n      <p>\n        The rendered picture should match the reference image exactly, except for possible\n        variations in the labelling text (per CSS2 rules).\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        In the first rectangle, the clip-rule is defined to be evenodd so the overlap should have a hole in it.\n        The clip-rule is defined to be nonzero so the overlap should be filled.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: masking-path-05-f.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <g shape-rendering="geometricPrecision">\n      <text font-size="14" x="150" y="20">Test for clip-rule property.</text>\n      <clipPath id="clip1">\n        <path clip-rule="evenodd" d="M200,40l20,0 0,60 20,0 0,-20 -60,0 0,-20 80,0 0,60 -60,0 0,-80z"/>\n      </clipPath>\n      <rect x="50" y="30" width="350" height="100" fill="red" clip-path="url(#clip1)"/>\n      <text font-size="12" x="100" y="140">clip-rule=evenodd</text>\n      <clipPath id="clip2">\n        <path clip-rule="nonzero" d="M200,170l20,0 0,60 20,0 0,-20 -60,0 0,-20 80,0 0,60 -60,0 0,-80z"/>\n      </clipPath>\n      <rect x="50" y="160" width="350" height="100" fill="blue" clip-path="url(#clip2)"/>\n      <text font-size="12" x="100" y="270">cliprule=nonzero</text>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.6 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'masking-path-07-b.svg', svg: '<svg version="1.1" baseProfile="basic" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.3" reviewer="CM" author="ED" status="accepted"\n    version="$Revision: 1.11 $" testname="$RCSfile: masking-path-07-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/masking.html#ClippingPaths">\n        <p>\n          This tests that \'clipPath\' elements can be used together and how the clipping paths are intersected.\n        </p>\n      <p>\n        There is a gray-white pattern as a background for the two subtest rectangles. This is to show that the holes that are cut out using clip-paths are transparent.\n        The first subtest verifies that when you use the \'clip-path\' property on a child element inside a \'clipPath\' element the child element is clipped correctly.\n        The second subtest verifies that when a \'clipPath\' element has a \'clip-path\' property the result is the intersection of the two clip paths.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The test has passed if the following conditions are met:\n			</p>\n			<ul>\n				<li>There is no red visible.</li>\n				<li>No shapes extend outside of the rects that have a thick black border.</li>\n				<li>For the left subtest:\n					<ul>\n						<li>There must be a large blue rect with a transparent smaller rect in it, and the intersection of two circles.</li>\n						<li>The borders of the clipregions are shown with black stroke.</li>\n						<li>The blue shapes must be visible only inside of these stroked regions.</li>\n				 	</ul>\n				</li>\n				<li>For the right subtest:\n					<ul>\n						<li>The test on the right must show part of the large blue rect shape with a transparent rect in it, and part of a circle.</li>\n						<li>The blue shapes must only be visible inside of the circle that has black stroke.</li>\n					</ul>\n				</li>\n			</ul>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: masking-path-07-b.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n\n    <defs>\n      <clipPath id="clipCircle1">\n        <circle id="c1" cx="100" cy="100" r="50"/>\n      </clipPath>\n\n      <clipPath id="clipCircle2">\n        <circle id="c2" cx="150" cy="150" r="50"/>\n      </clipPath>\n\n      <clipPath id="clipPath1">\n        <path id="p1" d="M10 10l100 0 0 100 -100 0ZM50 50l40 0 0 40 -40 0Z" clip-rule="evenodd"/>\n      </clipPath>\n\n      <!-- "If a valid \'clip-path\' reference is placed on one of the children of a \'clipPath\' element, \n		      then the given child element is clipped by the referenced clipping path before OR\'ing the \n			  silhouette of the child element with the silhouettes of the other child elements." -->\n      <clipPath id="clipRects1">\n        <rect x="50" y="30" width="25" height="100"/>\n        <rect x="25" y="50" width="10" height="10" clip-path="url(#clipTwoCircles)"/>\n      </clipPath>\n\n      <!-- Test use in a clipPath -->\n      <clipPath id="clipTwoCircles">\n        <use xlink:href="#c1"/>\n        <use xlink:href="#c2"/>\n      </clipPath>\n\n      <clipPath id="clipInClip1">\n        <use xlink:href="#c2" clip-path="url(#clipCircle1)"/>\n        <use xlink:href="#p1"/>\n      </clipPath>\n\n      <clipPath id="clipOnClip1" clip-path="url(#clipCircle1)">\n        <use xlink:href="#c2"/>\n        <use xlink:href="#p1"/>\n      </clipPath>\n\n      <pattern patternUnits="userSpaceOnUse" id="pattern" x="0" y="0" width="20" height="20">\n        <rect x="0" y="0" width="10" height="10" fill="gray"/>\n        <rect x="10" y="10" width="10" height="10" fill="gray"/>\n      </pattern>\n    </defs>\n\n    <rect x="20" y="70" width="210" height="210" fill="url(#pattern)" stroke="black" stroke-width="4"/>\n		<rect x="250" y="70" width="210" height="210" fill="url(#pattern)" stroke="black" stroke-width="4"/>\n\n    <text x="240" y="2em" text-anchor="middle">Test clip unions and intersections</text>\n\n    <g transform="translate(20, 70)">\n      <g id="subtest1">\n        <use xlink:href="#p1" fill="red" fill-rule="evenodd"/>\n        <use xlink:href="#c2" fill="red" clip-path="url(#clipCircle1)"/>\n        <use xlink:href="#c1" fill="red" clip-path="url(#clipCircle2)"/>\n\n        <rect width="200" height="200" fill="blue" clip-path="url(#clipInClip1)"/>\n\n        <use xlink:href="#c2" fill="none" clip-path="url(#clipCircle1)" stroke="black"/>\n        <use xlink:href="#c1" fill="none" clip-path="url(#clipCircle2)" stroke="black"/>\n        <use xlink:href="#p1" fill="none" stroke="black"/>\n      </g>\n\n      <g id="subtest2" transform="translate(230,0)">\n        <g clip-path="url(#clipCircle1)">\n          <use xlink:href="#c2" fill="red"/>\n          <use xlink:href="#p1" fill="red" fill-rule="evenodd"/>\n        </g>\n\n        <rect width="300" height="300" fill="blue" clip-path="url(#clipOnClip1)"/>\n\n        <use xlink:href="#c1" fill="none" stroke="black"/>\n      </g>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.11 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved --><!--\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'masking-path-08-b.svg', svg: '<svg id="svg-root" width="100%" height="100%"\n  viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg"\n  xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.3" reviewer="CM" author="ED" status="accepted"\n    version="$Revision: 1.7 $" testname="$RCSfile: masking-path-08-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/masking.html#EstablishingANewClippingPath">\n        <p>\n          This tests a few \'clip-path\' cases to see that clipping paths are applied and constructed properly.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        There are nine subtests in this test. There should be a big stroked rectangle with nine smaller rectangles inside. If all of the smaller rectangles are green the test has passed.\n      </p>\n      <p>\n        The test has passed if:\n      </p>\n			<ul>\n				<li>There is no red visible.</li>\n				<li>Each of the nine small rectangles are green.</li>\n			</ul>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: masking-path-08-b.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n	\n		<defs>\n			<clipPath id="emptyclip">\n			</clipPath>\n			<clipPath id="hiddenclip">\n				<rect width="100" height="100" visibility="hidden"/>\n			</clipPath>\n			<clipPath id="displayclip">\n				<rect width="100" height="100" display="none"/>\n			</clipPath>\n			<clipPath id="opacityclip">\n				<rect width="100" height="100" opacity="0"/>\n			</clipPath>\n			<clipPath id="strokefillclip">\n				<rect width="100" height="100" stroke="none" fill="none"/>\n			</clipPath>\n			<clipPath id="strokewidthclip">\n				<rect x="40" y="40" width="20" height="20" stroke="black" stroke-width="80"/>\n			</clipPath>\n			<clipPath id="strokeopacityclip">\n				<rect x="40" y="40" width="20" height="20" stroke="black" stroke-opacity="0" stroke-width="80"/>\n			</clipPath>\n			<clipPath id="fillopacityclip">\n				<rect width="100" height="100" fill-opacity="0"/>\n			</clipPath>\n		</defs>\n		\n		<text x="240" y="50" text-anchor="middle">Establishing a new clipping path</text>\n		\n		<g transform="scale(0.5) translate(320 200)">\n			<rect width="100" height="100" fill="lime"/>\n			<rect width="100" height="100" fill="red" clip-path="url(#emptyclip)"/>\n\n			<g transform="translate(110 0)">\n				<rect width="100" height="100" fill="lime"/>\n				<rect width="100" height="100" fill="red" clip-path="url(#hiddenclip)"/>\n			</g>\n			\n			<g transform="translate(220 0)">\n				<rect width="100" height="100" fill="lime"/>\n				<rect width="100" height="100" fill="red" clip-path="url(#displayclip)"/>\n			</g>\n\n			<!-- This has an intentionally broken clip-path url -->\n			<g transform="translate(0 110)">\n				<rect x="0.5" y="0.5" width="99" height="99" fill="red"/>\n				<rect width="100" height="100" fill="lime" clip-path="url(#unknown)"/>\n			</g>\n			\n			<g transform="translate(110 110)">\n				<rect x="0.5" y="0.5" width="99" height="99" fill="red"/>\n				<rect width="100" height="100" fill="lime" clip-path="url(#opacityclip)"/>\n			</g>\n			\n			<g transform="translate(220 110)">\n				<rect x="0.5" y="0.5" width="99" height="99" fill="red"/>\n				<rect width="100" height="100" fill="lime" clip-path="url(#strokefillclip)"/>\n			</g>\n			\n			<g transform="translate(0 220)">\n				<rect width="100" height="100" fill="lime"/>\n				<rect width="100" height="100" fill="red" clip-path="url(#strokewidthclip)"/>\n				<rect x="39" y="39" width="22" height="22" fill="lime"/>\n			</g>\n			\n			<g transform="translate(110 220)">\n				<rect width="100" height="100" fill="lime"/>\n				<rect width="100" height="100" fill="red" clip-path="url(#strokeopacityclip)"/>\n				<rect x="39" y="39" width="22" height="22" fill="lime"/>\n			</g>\n			\n			<g transform="translate(220 220)">\n				<rect x="0.5" y="0.5" width="99" height="99" fill="red"/>\n				<rect width="100" height="100" fill="lime" clip-path="url(#fillopacityclip)"/>\n			</g>\n			\n			<rect width="320" height="320" fill="none" stroke="black"/>\n		</g>\n		\n		\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.7 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved --><!--\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'masking-path-10-b.svg', svg: '<svg id="svg-root" width="100%" height="100%"\n  viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg"\n  xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.3" reviewer="SVGWG" author="ED" status="accepted"\n    version="$Revision: 1.4 $" testname="$RCSfile: masking-path-10-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/masking.html#Masking">\n        <p>\n          This tests a few \'mask\' cases to see that masks are applied and constructed properly.\n        </p>\n      <p>\n          There are nine subtests in this test. There should be a big stroked rectangle with nine smaller rectangles inside. If all of the smaller rectangles are green the test has passed.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The test has passed if:\n      </p>\n			<ul>\n				<li>There is no red visible.</li>\n				<li>Each of the nine small rectangles are green.</li>\n			</ul>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: masking-path-10-b.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n	\n		<defs>\n			<mask id="emptymask"/>\n			<mask id="hiddenmask">\n				<rect width="100" height="100" visibility="hidden"/>\n			</mask>\n			<mask id="displaymask">\n				<rect width="100" height="100" display="none"/>\n			</mask>\n			<mask id="opacitymask">\n				<rect width="100" height="100" opacity="0"/>\n			</mask>\n			<mask id="strokefillmask">\n				<rect width="100" height="100" stroke="none" fill="none"/>\n			</mask>\n			<mask id="strokewidthmask">\n				<rect x="40" y="40" width="20" height="20" stroke="white" stroke-width="20"/>\n			</mask>\n			<mask id="strokeopacitymask">\n				<rect x="40" y="40" width="20" height="20" stroke="white" stroke-opacity="0" stroke-width="20"/>\n			</mask>\n			<mask id="fillopacitymask">\n				<rect width="100" height="100" fill-opacity="0"/>\n			</mask>\n		</defs>\n		\n		<text x="240" y="50" text-anchor="middle">Establishing a new masking path</text>\n		\n		<g transform="scale(0.5) translate(320 200)">\n			<rect width="100" height="100" fill="lime"/>\n			<rect width="100" height="100" fill="red" mask="url(#emptymask)"/>\n\n			<g transform="translate(110 0)">\n				<rect width="100" height="100" fill="lime"/>\n				<rect width="100" height="100" fill="red" mask="url(#hiddenmask)"/>\n			</g>\n			\n			<g transform="translate(220 0)">\n				<rect width="100" height="100" fill="lime"/>\n				<rect width="100" height="100" fill="red" mask="url(#displaymask)"/>\n			</g>\n\n			<!-- This has an intentionally broken mask url -->\n			<g transform="translate(0 110)">\n				<rect x="0.5" y="0.5" width="99" height="99" fill="red"/>\n				<rect width="100" height="100" fill="lime" mask="url(#unknown)"/>\n			</g>\n			\n			<g transform="translate(110 110)">\n				<rect x="0.5" y="0.5" width="99" height="99" fill="lime"/>\n				<rect width="100" height="100" fill="red" mask="url(#opacitymask)"/>\n			</g>\n			\n			<g transform="translate(220 110)">\n				<rect x="0.5" y="0.5" width="99" height="99" fill="lime"/>\n				<rect width="100" height="100" fill="red" mask="url(#strokefillmask)"/>\n			</g>\n			\n			<g transform="translate(0 220)">\n				<rect width="100" height="100" fill="lime"/>\n				<rect width="100" height="100" fill="red" mask="url(#strokewidthmask)"/>\n				<rect x="29" y="29" width="42" height="42" fill="lime"/>\n			</g>\n			\n			<g transform="translate(110 220)">\n				<rect width="100" height="100" fill="lime"/>\n				<rect width="100" height="100" fill="red" mask="url(#strokeopacitymask)"/>\n			</g>\n			\n			<g transform="translate(220 220)">\n				<rect x="0.5" y="0.5" width="99" height="99" fill="lime"/>\n				<rect width="100" height="100" fill="red" mask="url(#fillopacitymask)"/>\n			</g>\n			\n			<rect width="320" height="320" fill="none" stroke="black"/>\n		</g>\n		\n		\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.4 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'masking-path-11-b.svg', svg: '<svg id="svg-root" width="100%" height="100%"\n  viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg"\n  xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="CL" author="ED" status="accepted"\n    version="$Revision: 1.4 $" testname="$RCSfile: masking-path-11-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/masking.html#Masking">\n      <p>\n        Test the mask element with child elements with white and black fills,\n        to create a mask that clips out some text in the middle.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The test is passed if the letters \'ABC\' are visible inside a blue\n        circle, and the letters are transparent, showing the checkered\n        background image.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: masking-path-11-b.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n\n    <defs>\n      <mask id="maskedtext">\n        <circle cx="50%" cy="50%" r="50" fill="white"/>\n        <text x="50%" y="55%" text-anchor="middle" font-size="48">ABC</text>\n      </mask>\n    </defs>\n    \n    <image xlink:href="' + Images['DisplaceChecker.png'] + '" x="140" y="80" width="200" height="200"/>\n    <rect width="100" height="100" x="190" y="130" fill="blue" mask="url(#maskedtext)"/>\n\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.4 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'masking-path-13-f.svg', svg: '<svg id="svg-root" width="100%" height="100%" viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/" template-version="1.4" reviewer="CL" author="Microsoft" status="accepted" version="$Revision: 1.2 $" testname="$RCSfile: masking-path-13-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://dev.w3.org/SVG/profiles/1.1F2/publish/masking.html#clipPath-geometry">\n      <p>\n        Test that the children of the \'clipPath\' element are not rendered directly.\n      </p>\n    </d:testDescription>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Test passes if there is a green rectangle, and no red visible on the page.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: masking-path-13-f.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n  <rect x="100" y="100" width="200" height="100" fill="green" />\n    <clipPath id="testClip">\n        <rect x="100" y="100" width="200" height="100" fill="red" />\n    </clipPath>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.2 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>\n  -->\n</svg>'},
  {name: 'masking-path-14-f.svg', svg: '<svg id="svg-root" width="100%" height="100%" viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/" template-version="1.4" reviewer="CL" author="Microsoft" status="accepted" version="$Revision: 1.2 $" testname="$RCSfile: masking-path-14-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://dev.w3.org/SVG/profiles/1.1F2/publish/masking.html#EstablishingANewClippingPath">\n      <p>\n        The \'clipPath\' element itself and its children elements do not inherit clipping paths from ancestors of the \'clipPath\' element.\n      </p>\n             <p>\n        Overlay a red \'rect\' with a black \'rect\' of a larger size. Define a \'clipPath\' with a \'rect\' of the same size as the red \'rect\', but different \'x\' and \'y\' offsets. Reference that \'clipPath\' from a \'g\' element containing another \'clipPath\' element. In this latter \'clipPath\', specify a \'rect\' of the same size and same \'x\' and \'y\' offsets as the red \'rect\', and reference it from the black \'rect\' element. Reference the same \'clipPath\' elements, but this time with a black \'rect\' which overlays a red \'rect\' of a larger size. If there is no red on the page, the first \'clipPath\' was not inherited by the second \'clipPath\'.\n      </p>\n    </d:testDescription>\n        <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Test passes if there are two black rectangles, and there is no red visible on the page.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: masking-path-14-f.svg,v $</title>\n    <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n        <clipPath id="testClipPathAncestor">\n        <rect x="50" y="50" width="50" height="50" />\n    </clipPath>\n    <g clip-path="url(#testClipPathAncestor)">\n        <clipPath id="testClipPath">\n            <rect x="0" y="0" width="50" height="50" />\n        </clipPath>\n    </g>\n    <svg x="0" y="0" width="200" height="200">\n        <rect x="0" y="0" width="50" height="50" fill="red" />\n        <rect x="0" y="0" width="200" height="200" fill="black" clip-path="url(#testClipPath)" />\n    </svg>\n    <svg x="200" y="0" width="200" height="200">\n        <rect x="0" y="0" width="200" height="200" fill="red" clip-path="url(#testClipPath)" />\n        <rect x="0" y="0" width="50" height="50" fill="black" />\n    </svg>\n  </g>\n   <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.2 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>\n  -->\n</svg>'},
  {name: 'metadata-example-01-t.svg', svg: '<svg version="1.1" baseProfile="basic" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Chris Lilley" status="accepted"\n    version="$Revision: 1.6 $" testname="$RCSfile: metadata-example-01-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/metadata.html#Example">\n        <p>\n          Check that metadata in a variety of namespaces, inside a metadata\n          element, does not affect rendering in any way. The file is not valid to \n          the SVG 1.1 DTD, but is well formed.\n        </p>\n        <p>The diagram on the table is, by the way, a visualization of the \n        RDF metadata in the graphic.</p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The rendered result should match the reference image and there should be\n        no error messages or warnings\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: metadata-example-01-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n  <metadata>\n    <rdf:RDF \n      xmlns:prism="http://prismstandard.org/namespaces/1.0/basic/"\n      xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"\n      xmlns:dc="http://purl.org/dc/elements/1.1/"\n      xmlns:rdfs="http://www.w3.org/2000/01/rdf-schema#">\n      <!-- The empty value for the rdf:about attribute means it is describing  \n            the file this is contained in. -->\n         <rdf:Description rdf:about="">\n           <dc:description>Line drawing of woman in antique attire, \n             which looks legal or perhaps mystical.</dc:description>\n           <dc:format>image/svg+xml</dc:format>\n           <dc:subject>Sibyll Trelawney</dc:subject>\n           <dc:type rdf:resource="http://prismstandard.org/vocabularies/1.0/resourcetype.xml#birdsEye"/>\n           <dc:type rdf:resource="http://prismstandard.org/vocabularies/1.0/resourcetype.xml#illustration"/>\n         </rdf:Description>\n       </rdf:RDF>\n    </metadata>\n    <g transform="scale(1.2)">\n      <g id="Sibyll" fill="#FFF" stroke="#000" stroke-miterlimit="4">\n        <g stroke="none">\n          <path fill="#000" d="M132.386,113.177c0.394-2.645,0.978-6.189,1.681-10.262c-7.597-5.655-19.264-14.488-26.764-25.988l-1.667-0.667c5.333,15.167,25,32.833,26.75,36.917l15.583,15.25c0,0,10,10.667,12.167,13.833c2.167,3.167,3.5,7.167,1.333,9.833     c-1.667-1-4.833-5.333-8-9.167c0,0-7-1.5-13.833-1.333c0,0,2.667,5.5,3.833,8c0.563,1.207,0.465,2.141,0.064,3.047c6.241,4.828,12.252,13.801,16.102,18.453c4,4.833,5.548,8.822,12.167,10.167c10.667,2.167,16.667,7.5,19.667,10s3,4,1.833,4.833     c0,0-4.167,1.5-11,2c-6.833,0.5-12.333-3.333-15.167-3.333c-4.333-0.167-6.333-3-7.833-6.333c-1.5-3.333-4.5-4.833-9.167-7.667c-4.293-2.606-14.858-7.894-19.053-14.174c-4.791,3.163-10.643,5.756-17.447,8.34l-1.333-1.333c-1.933,0.773-4.538,1.52-7.574,1.925     c2.113,6.17,7.926,15.123,10.157,16.908c2.5,2,4.25,4.25,4.25,6.5s-0.75,5.5-3.75,9.5c-0.5,13-6,19.75-12.5,22.25c-4.5-15-0.5-25.25,1.5-31.25c0,0-7.472-6.813-12.938-12.608c0.73,3.979,1.468,7.703,2.188,10.942c0,0-1.232,1.575-3.5,0.833     c-8.667-2.833-22.167-10.333-27.333-16.333c-2.667-7.833-6.5-33.667-7.667-44.333c0,0-5.167-1.333-10.167-2.667c0,0-0.667-0.333-1.5-3.5c0,0-5.667-1.667-11.833-3c-6.167-1.333-5.667-2.667-6.667-6.167s0.667-28.5,2.5-36.667c1.833-8.167,10.5-22.167,15.833-28     c0,0-1.006-0.135-1.833-2.5c-5.833-16.667-7.833-27.333-0.667-37.667c7.167-10.333,20.167-6,26.667-2.833c6.5,3.167,6.667,8.333,8.167,10.833s0.333,4.833,2,7.167c17.667,7,26.833,16.667,38.833,27.167c7.5,3.667,13.667,9.667,18.667,13.833     c1.124,0.937,2.323,2.151,3.556,3.525c1.444-7.663,2.858-14.936,3.944-20.275c3-14.75,9.5-47,10.25-49.25l3,0.25c29.25,0.25,69.75-1,69.75-1c0.25,20.25,0.25,62.5,0.25,74.25s0,39,0.25,42.25c0,0-3.75,2-8.333,2.75c1,0.167,1.667,2.5-0.167,3.333     c-3,0.167-25.333,0.167-33-1c-1.245-0.189-2.923-0.326-4.879-0.422c2.441,2.484,8.906,8.839,19.629,17.838l-0.25,8.25l-9,0.25l-31.952-26.426c-4.665,0.081-8.525,0.176-10.215,0.176l-15.583-15.25z"/>\n          <path fill="#000" d="M60.654,1.358c-0.844,0.915-1.808,2.263-2.857,3.938c-1.195-1.07-3.74-3.216-6.342-4.566l-1.904,2.413l6.058,5.882c-0.131,0.236-0.264,0.477-0.397,0.721C46.57,3.133,43.441,0.554,43.441,0.554l-2.39,2.766     c3.972,4.632,9.453,8.916,11.891,10.729c-0.211,0.413-0.423,0.831-0.636,1.255C39.417,5.651,34.449,0.917,34.449,0.917l-2.717,2.945c7.647,7.33,15.917,14.754,18.024,16.638c-0.204,0.425-0.408,0.854-0.613,1.284C36.8,12.691,27.994,4.367,25.422,0.449     l-2.39,2.765c8.104,8.539,20.319,19.211,24.227,22.583c-0.206,0.443-0.411,0.888-0.617,1.333c-9.527-6.31-14.627-11.31-18.931-15.432C23.201,7.377,17.976,1.917,15.896,0L13.02,3.119c7.717,8.503,25.108,24.004,31.619,28.399     c-0.243,0.537-0.485,1.073-0.726,1.607C30.32,22.46,10.721,5.175,6.985,2.362L4.901,4.448c8.872,9.074,31.669,29.336,36.615,34.038c-0.3,0.677-0.597,1.346-0.89,2.006C25.883,27.823,2.664,6.874,2.664,6.874L1.12,9.939c10.493,10.57,33.952,32.544,37.258,35.638     c-0.259,0.585-0.512,1.158-0.758,1.715C22.515,33.526,7.848,20.476,3.401,16.852l-2.237,2.426c11.139,10.986,30.478,28.518,34.581,32.227c-0.323,0.72-0.628,1.394-0.913,2.015C21.063,40.369,5.95,27.057,2.685,23.887l-2.383,2.932     c8.691,8.46,29.709,27.74,32.738,30.515c-0.304,0.651-0.648,1.404-1.029,2.247C18.259,46.584,5.606,34.76,2.869,32.553l-2.25,2.092c9.949,10.825,26.338,25.906,29.82,28.451c-0.32,0.724-0.656,1.485-1.006,2.28C16.333,52.826,2.679,40.233,2.679,40.233     l-2.224,2.759c9.067,9.678,23.141,23.04,27.343,26.12c-0.297,0.683-0.602,1.383-0.912,2.098C15.543,60.602,2.703,49.073,2.703,49.073C1.238,49.966,0,52.352,0,52.352C11.334,63.218,22.136,73.12,24.95,75.689c-0.261,0.606-0.525,1.22-0.792,1.841     C8.771,63.626,2.36,57.093,2.36,57.093l-1.884,2.912c8.419,8.851,18.809,19.06,21.778,21.963c-0.157,0.366-0.313,0.733-0.472,1.102C10.825,74.056,2.944,67.412,2.944,67.412l-1.737,2.405c8.374,8.123,16.46,14.983,18.948,17.065     c-0.242,0.567-0.484,1.137-0.728,1.709C10.261,82.019,3.115,75.745,3.115,75.745l-1.85,3.745c8.161,7.937,14.37,12.905,16.005,14.183c-0.244,0.576-0.488,1.152-0.732,1.729C7.159,87.785,4.131,84.377,4.131,84.377l-2.363,3.432     c5.442,5.678,11.379,9.753,13.319,11.023c-0.25,0.592-0.5,1.183-0.748,1.773l-10.71-8.035l-1.884,2.912l10.717,9.579c-0.152,0.362-0.303,0.723-0.455,1.083l-8.603-6.725l-1.724,2.738l8.792,7.647c-0.276,0.659-0.549,1.313-0.821,1.962l-6.45-5l-1.737,2.405     l6.509,6.618c-0.19,0.457-0.379,0.911-0.566,1.36l-5.095-3.509l-1.384,2.892l4.96,4.278c-0.144,0.347-0.286,0.69-0.427,1.031l-2.546-1.553l-1.211,3.051l2.199,2.281c-1.341,3.262-2.508,6.131-3.433,8.444l2.725,1.391c1.204-3.218,31.228-73.322,36-83.189     S60.577,7.7,62.173,1.797l-1.519-0.439z"/>\n          <path d="M142.803,106.261c-1,0.5-3,1-5-0.5c0,0-3.667,12.333-2.667,17.667c3.667,1.833,42.833,2.5,52.667,2.5c16.833,0,26.167,1,30,0.5c4.583-0.75,8.333-2.75,8.333-2.75c-0.25-3.25-0.25-30.5-0.25-42.25s1.333-54.354-0.25-74.25c0,0-40.5,1.25-69.75,1     c0.5,5.75-2.395,17.829-4,24.25c-1.5,6-5,25.25-9.929,48.894c3.256,4.04,6.499,8.469,9.012,11.273c0,0,0.089,1.697-0.189,3.521c3.856,1.062,6.481,3.062,7.981,5.312s2.25,5.625,1.375,7.875c0.625,3.125,0.5,5.375-0.875,5.75s-2.5,1-4.5,0.25     c-0.875,3.25-1.25,3.5-1.25,3.5c-1.75,0-2.375-0.125-2.375-0.125c-3-4.125-8.667-7.833-8.333-12.417z"/>\n          <path fill="#000" d="M207.303,18.594c0,0-19,6.167-39.167,13.333c0,0,0.716,6.012,1.617,11.404c-4.629,2.158-9.096,4.243-12.617,5.93c0,0,5,18,10.333,30.333c2.833-2.167,23-11.833,37.167-19.667c0,0-0.888-2.858-2.156-6.833     c1.809-0.587,7.883-2.55,9.156-2.833c1.5-0.333,1.5-2.833,1.5-2.833s-4.333-21.667-5.833-28.833z"/>\n          <path d="M133.469,159.427c-6.038,5.712-26.618,15.097-44.84,10.635c-1.833-11.777-3.345-23.232-3.993-29.635c-1.333-13.167-1.5-27.167-1.5-27.167c7,0.833,11.333-0.333,11.333-0.333c-0.333-4,0.5-9.5,0.5-9.5c2.5,3.167,7,5,8.333,1.833     c1.333-3.167,2.5-8.667,2.5-8.667c3.5,2.167,10,9.667,15.833,19c5.833,9.333,11.833,18.833,15.333,26.5c3.5,7.667,2.667,11.5-3.5,17.333z"/>\n          <path d="M150.303,98.094c-0.573,1.604-3.428,4.624-5.483,6.519c0.691,4.564,3.566,8.189,4.941,9.189s2.75,2,2.75,2c0.625-2.125-0.25-4.25-3.125-5.625c-0.375-1,0.75-3,1.75-2s2,0.375,2,0.375c1.875,2.75,2.125,4.125,2.125,4.125l2,0.5     c0-3.125-0.625-4.5,0.375-6.25c-1-3.75-2.292-7.042-7.333-8.833z"/>\n          <path d="M115.386,197.677c-1.5,7.25-3.25,13.25-4.5,16.25s-0.75,5.25-4.75,5c-3.25-1.5-3.5-3.75-2.25-8.5s3.5-9,3.5-12.25c-6.583-7.147-13.873-14.577-17.08-17.819c-0.354-2.073-0.703-4.181-1.043-6.295c4.057,1.386,8.024,1.841,11.607,1.757     c3.328,8.71,11.053,18.163,14.516,21.857z"/>\n          <path d="M141.636,155.761c0.054-0.094,0.108-0.187,0.164-0.277c7.517,8.107,12.258,14.859,14.67,17.111c2.5,2.333,6.5,8.667,10,9.833c3.5,1.167,11.833,4.167,14.333,5.333s2.667,1.833,2.167,3.667c-0.5,1.833-1.333,2.833-7,2.167     c-5.667-0.667-11.833-1.5-12.167-3.833c-0.333-2.333-7.333-9.5-11.833-11.5c-4.067-1.808-15.622-8.652-18.299-13.521c3.277-2.538,5.95-5.452,7.965-8.979z"/>\n          <path d="M193.136,150.927l-3,0.25c-13.131-11.256-23.025-19.555-27.146-22.997c1.969-0.023,3.993-0.039,5.991-0.041c9.588,10.269,24.155,22.788,24.155,22.788z"/>\n          <path d="M169.303,74.427c-4.667-11.833-7.833-23.667-7.833-23.667c13.333-6.333,32-15.167,32-15.167c2.5,9.167,7.333,23.333,7.333,23.333c-15.833,7.5-31.5,15.5-31.5,15.5z"/>\n          <path d="M201.697,50.65c-2.207-6.863-5.115-15.666-6.728-19.556c-2.217,1.478-12.056,6.098-21.979,10.728c-0.355-1.502-1.255-5.506-1.521-8.561c2.5-0.5,22.333-6.667,33.5-10.167c0.333,2.833,2.333,12.833,4.667,25.167c-1.124,0.75-5.709,1.873-7.938,2.389z"/>\n          <path d="M121.636,69.302l-0.333-2.333c5.333,3.333,20.667,18,26.167,25.667c0,2-1.833,1.333-2.833,0.333s-3.667-5.167-9-10.5c-5.333-5.333-12-13.333-14-13.167z"/>\n          <path d="M119.136,74.136c-0.667-6.833-3.333-11.333-12-18.5c-8.667-7.167-19.833-16.667-26.667-18.5c1.167,1.167,1.5,2.333,1.5,2.333c9.167,4.667,25.667,18.833,29.5,24.333s6.333,10,7.667,10.333z"/>\n          <path d="M68.441,165.532c-0.229-1.13-0.446-2.215-0.649-3.251c-1.987-0.381-3.908-1.266-5.172-1.943c0.2,1.172,0.399,2.327,0.595,3.453c1.945,0.734,3.919,1.353,5.227,1.741z"/>\n          <path d="M69.66,171.421c-2.355-0.877-4.315-1.616-5.454-2.046c0.217,1.205,0.426,2.347,0.622,3.412c2.266,0.833,4.26,1.692,5.618,2.308c-0.274-1.266-0.536-2.491-0.786-3.674z"/>\n          <path d="M61.589,154.129c2.229,0.848,3.901,1.444,4.997,1.822c-0.184-0.999-0.351-1.93-0.504-2.797c-1.253-0.34-2.919-0.923-4.952-1.916c0.151,0.962,0.304,1.927,0.46,2.891z"/>\n          <path d="M65.795,177.971c0.369,1.946,0.59,3.082,0.59,3.082s3.25,3.75,6.5,5c-0.317-1.384-0.622-2.732-0.916-4.042c-2.397-1.074-4.802-2.904-6.174-4.04z"/>\n          <path d="M64.884,145.852c-0.178-1.214-0.249-1.8-0.249-1.8l-4.75-1.25c0.093,0.678,0.189,1.366,0.288,2.06c1.966,0.497,3.552,0.803,4.711,0.99z"/>\n          <path d="M41.469,94.136c0.5,5.5,2.833,15.333,2.833,15.333l7.333,0.833l1.5,1.5c1-3.667,3.5-5.333,6.5-5.167s13.167,0,13.167,0c0.167-4.5,0.833-11,0.833-11c-2,4-3.5,4.833-6.333,4.167c-2.833-0.667-22.167-5.5-25.833-5.667z"/>\n          <path d="M44.303,90.636l2.167-2.833c11.667,1.5,25.333,5.667,25.333,5.667s-1,2.833-2.667,3.667c-12.333-2.667-24.833-6.5-24.833-6.5z"/>\n          <path d="M49.636,114.969c-0.5,2.167-0.5,8.5-0.5,8.5c3.333,0,4.833,0.5,4.667,1.833c1.5,0.167,2.833,1.5,2.833,1.5c2.833-0.333,5.167,1.333,9.167,1.5c4,0.167,5.5,2,8.5-0.667c-3.5,0.167-9.167-0.167-9.5-2.333c4.333-0.333,9.167,0.333,10.333-0.5     c0.833-1,0-1.667,0-1.667c-5.167,0-11.167-0.333-11-2c0.167-1.667,4.333-0.333,6.5-0.167c2.167,0.167,6,0.333,6.167-1.5c0.167-1.833-2.833-0.833-4.833-0.833s-7.5,0.167-7.333-1.5c0.167-1.667,2-1,5.5-0.833c3.5,0.167,6,0,6.167-1.333     c-3-0.5-7.5-1.333-9.833-1.667c-2.333-0.333-5.5-0.167-5.5-0.167c-0.5-1.667,1.333-2.833,4-2.167c2.667,0.667,5,0.667,5,0.667s3.5-0.667,2.5-1.667s-7.333-0.333-10.5-1c-3.167-0.667-6.167-0.333-6.833,2.167c-0.667,2.5-0.833,4.333-5.5,3.833z"/>\n          <path d="M52.969,128.302c-0.167,3-1.333,4.5-1.333,4.5c7,1.167,13.667,2,15.833,2.667c2.5-1.667,2.5-4,2.5-4c-6-0.167-11-1.167-17-3.167z"/>\n          <path d="M48.303,83.802c0.32-0.641,0.712-1.385,1.158-2.195c-3.615-2.958-6.491-4.972-6.491-4.972c0.531-1.044,1.041-2.015,1.535-2.927c2.657,2.698,5.046,4.441,6.417,5.345c0.384-0.646,0.789-1.311,1.211-1.984c-2.489-1.858-5.061-4.094-6.501-5.381     c0.501-0.871,0.986-1.675,1.458-2.414c2.28,2.454,5.479,4.286,6.863,5.014c0.36-0.527,0.728-1.049,1.1-1.563c-2.814-2.162-4.917-4.646-6.071-6.168c0.626-0.813,1.238-1.517,1.844-2.126c2.739,2.539,5.216,4.473,6.461,5.41c0.314-0.374,0.627-0.733,0.94-1.077     c-2.576-2.421-4.665-4.903-5.513-5.949c0.684-0.484,1.375-0.871,2.09-1.181c1.745,2.559,3.975,4.467,5.164,5.387c0.454-0.404,0.901-0.759,1.336-1.054l-3.5-4.167c0,0-4.5-1.167-11.167-2.333c-2.833,2.5-10.167,14-13.667,20.5s-5,22.5-5.167,28.167     c-0.167,5.667-0.833,12,0.5,15.333c0,0,0.506-0.025,1.369-0.083c0.068-3.272-0.202-6.251-0.202-6.251s0.64-0.07,1.667-0.163v6.307c0.644-0.051,1.375-0.113,2.167-0.188v-6.298c0.526-0.04,1.087-0.079,1.668-0.115l1.005,6.131c0.435-0.051,0.878-0.105,1.327-0.163     v-6.086c0.758-0.03,1.52-0.049,2.261-0.055l0.32,5.773c0.916-0.145,1.831-0.305,2.723-0.482l-0.111-5.215c0.679,0.048,1.292,0.12,1.806,0.223l0.974,4.384c0.064-0.017,0.129-0.034,0.192-0.051c0.167-2.667,0.333-6.333,1.667-8c0,0-4.333-0.833-7.833-1.667     c-3.5-0.833-7.167,1.333-7.167,1.333l-1-3.167c0,0,2.333-0.167,5.833-3.167c0,0,1.333-2.833,2.333-7c0,0,0.5-2.667-0.5-5c-1-2.333,0.167-4,1.667-4c0,0,1.667-1,2.833-4c-0.833-1-0.333-2.833-2.167-4.333l1-3.5c0,0,2.333,2.833,6.167,5.167z"/>\n          <path d="M72.469,87.636c-3-10-4.333-21.333-4.333-21.333c1.833,0.167,3-1.667,2.833-3.333c-0.167-1.667,0.167-3.833,0.167-3.833c2.5,0,6.833,2.667,6.5-2.167l1.833-0.5l-0.667,1.333c5.667,2.5,10.167,8,13,11c-0.167,3.167-1.333,4.833-1.333,4.833     c-7.5-8.5-10.667-11.667-17.5-13.5c-0.833-0.167-1.167,0.833-1.167,0.833c3.667,11.5,7.667,18.5,6.5,24.833c-1.167,1.833-5.833,1.833-5.833,1.833z"/>\n          <path d="M71.803,57.136c1.333-0.5,3.5-0.167,3.5-0.167v1c0,0-1.833,0.833-3.5-0.833z"/>\n          <path d="M69.303,59.469c-0.5,2-0.833,4.833-0.833,4.833c-2.833-0.5-7-2.167-8.333-5c-0.167-1.833-0.5-3.333-0.5-3.333c4.167,2.333,7.833,3.833,9.667,3.5z"/>\n          <path d="M61.041,22.638c1.264-0.02,4.413-0.208,7.262-1.502c-1.5-6.333-16.5-5.667-19-5.167s-6,3.833-7.333,6.667c0.407,0.078,0.821,0.147,1.241,0.209c0.353-0.971,0.765-1.43,0.967-1.61c0.539-0.141,1.064-0.269,1.579-0.386l-0.121,2.274     c0.448,0.038,0.897,0.069,1.347,0.094c0.278-0.639,0.836-1.885,1.368-2.879c0.916-0.149,1.796-0.258,2.648-0.325l-0.633,3.291c0.734-0.001,1.454-0.015,2.151-0.036l1.019-3.336c1.12,0.02,2.201,0.116,3.266,0.287v2.805c0.273-0.022,0.535-0.045,0.784-0.068     l1.205-2.329c0.706,0.176,1.409,0.385,2.118,0.627l0.132,1.386z"/>\n          <path d="M80.719,45.948c-1.216,1.93-3.617,3.119-4.833,3.229c0,0,1.265-2.633,3.503-5c0.58-0.479,0.58-1.229-0.12-1.646c-0.467,0.238-1.198,0.661-1.884,1.27c-1.125,1-2.75-0.25-3.25-1.5c0.781-1.45,3.351-1.408,4.961-1.827c0.622-0.527-0.128-1.34-0.128-1.34     c-2.833-3-7.167-4.333-7.167-6.833c0-1.414,0.373-2.507,0.697-3.191c-0.643,0.122-1.472-0.365-1.614-0.934c-0.201-0.805-0.323-1.369-1.407-2.732c-0.147,0.09-0.295,0.181-0.444,0.273c0.392,1.027,0.987,2.527,1.727,4.209c1.375,3.125-2.125,2.625-2.25,1.125     c-0.093-1.118-0.742-2.652-1.688-3.931c-0.119,0.078-0.237,0.157-0.356,0.236c0.75,1.878,1.31,4.497,1.793,6.819c0.625,3-2.375,2.25-2.625,1c-0.205-1.023-0.83-3.555-2.079-5.744c-0.127,0.098-0.253,0.196-0.379,0.296c0.56,2.288,0.947,5.64,1.333,7.573     c0.5,2.5-2.375,2.5-2.625,0.5c-0.212-1.696-0.245-2.944-1.242-5.878c-0.208,0.2-0.414,0.402-0.616,0.608c0.012,3.123-0.009,8.49-0.268,10.646c-0.375,3.125-2.875,2.375-2.75,1c0.109-1.197-0.161-3.154-0.068-7.767c-0.046,0.076-0.095,0.15-0.14,0.226     c-0.833,5.333-1.167,12.833,4.833,15.5s14.292,3.313,18,0.5c4.208-2.563,1.083-4.313,1.083-6.688z"/>\n          <g fill="#000">\n            <path d="M108.89,146.162c-0.826-0.792-1.639-1.586-2.431-2.375c-3.331,1.829-7.613,3.162-9.51,3.705c0.6,0.995,1.222,2.013,1.855,3.04c5.627-1.592,8.655-3.34,10.085-4.369z"/>\n            <path d="M101.191,138.181c-2.182,1.709-5.985,3.141-7.535,3.682c0.5,0.895,1.054,1.857,1.647,2.868c4.203-1.098,7.043-2.515,8.666-3.492c-0.993-1.046-1.926-2.07-2.778-3.058z"/>\n            <path d="M102.346,156.194c5.876-1.628,9.702-4.044,11.53-5.404c-0.834-0.752-1.673-1.518-2.508-2.293c-2.729,2.457-8.69,4.159-10.893,4.725c0.627,1.002,1.253,1.998,1.871,2.973z"/>\n            <path d="M123.275,158.893c-3.958,2.792-11.935,5.487-15.034,6.474c1.168,1.793,1.895,2.894,1.895,2.894s12.5-3.333,16.5-6.667c-0.892-0.694-2.039-1.613-3.361-2.701z"/>\n            <path d="M117.5,154c-3.033,2.28-10.208,4.545-13.112,5.402c0.657,1.026,1.285,2.002,1.869,2.907c6.353-1.963,11.13-4.771,13.516-6.351c-0.735-0.626-1.496-1.281-2.273-1.958z"/>\n            <path d="M99.333,135.915c-0.582-0.755-1.097-1.476-1.531-2.154c-2.333,1.5-6.667,3-6.667,3c0.173,0.519,0.483,1.221,0.902,2.066c2.759-0.008,4.985-0.774,7.296-2.913z"/>\n            <path d="M66.386,44.677c2.125-1.75,5.375-4.25,5.125-7.25l-1.25-0.625l-0.125-0.75c-5.125,3.25-7.75,4.375-8.5,5c0.875,1.875,2.5,1.375,2.5,1.375c2.125-1.125,4-2.375,4-2.375c-1.875,2.125-2.5,3.125-2.5,3.125s-0.125,0.875,0.75,1.5z"/>\n          </g>\n        </g>\n      </g>\n      <g id="vis" transform="translate(153,58) rotate(-27) scale(0.05)" stroke="rgb(66,105,66)" font-family="dialog, sans-serif" font-size="10">\n        <g fill="rgb(115,191,115)">\n          <ellipse cx="195" cy="210" rx="27" ry="18"/>\n          <ellipse cx="645" cy="102" rx="225" ry="18"/>\n          <ellipse cx="645" cy="156" rx="230" ry="18"/>\n        </g>\n        <g fill="rgb(255,223,123)" stroke="rgb(132,117,66)">\n          <rect height="36" width="100" x="595" y="192"/>\n          <rect height="36" width="276" x="507" y="246"/>\n          <rect height="36" width="106" x="592" y="300"/>\n        </g>\n        <g fill="none" stroke="rgb(90,89,206)">\n          <path d="M201 193C212 170 215 158 240 143 279 122 377 112 428 107"/>\n          <path d="M216 200C224 196 232 193 240 191 311 174 390 165 423 161"/>\n          <path d="M221 210C295 210 497 210 595 210"/>\n          <path d="M221 210C295 210 497 210 595 210"/>\n          <path d="M216 220C224 224 232 227 240 229 334 252 444 261 506 264"/>\n          <path d="M201 227C212 253 215 265 240 280 352 344 508 337 592 325"/>\n        </g>\n        <g fill="rgb(90,89,206)" stroke="none">\n          <polygon points="433,107 425,111 425,103"/>\n          <polygon points="428,160 421,165 420,157"/>\n          <polygon points="600,210 592,214 592,206"/>\n          <polygon points="511,264 503,268 503,260"/>\n          <polygon points="597,324 590,329 588,321"/>\n        </g>\n        <g fill="rgb(66,105,66)">\n          <text x="458" y="105">http://prismstandard.org/vocabularies/1.0/resourcetype.xml#birdsEye</text>\n          <text x="453" y="159">http://prismstandard.org/vocabularies/1.0/resourcetype.xml#illustration</text>\n          <text x="604" y="213">image/svg+xml</text>\n          <text x="530" y="267">Line drawing of woman in antique attire, ...</text>\n          <text x="177" y="213">online:</text>\n          <text x="601" y="321">Sibyll Trelawney</text>\n        </g>\n        <g stroke="rgb(90,89,206)" fill="rgb(90,89,206)">\n          <text x="256" y="158">http://purl.org/dc/elements/1.1/type</text>\n          <text x="250" y="206">http://purl.org/dc/elements/1.1/format</text>\n          <text x="250" y="276">http://purl.org/dc/elements/1.1/subject</text>\n          <text x="256" y="105">http://purl.org/dc/elements/1.1/type</text>\n          <text x="240" y="225">http://purl.org/dc/elements/1.1/description</text>\n        </g>\n      </g>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.6 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'painting-control-01-f.svg', svg: '<svg id="svg-root" width="100%" height="100%"\n  viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg"\n  xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="CL" author="Microsoft" status="accepted"\n    version="$Revision: 1.4 $" testname="$RCSfile: painting-control-01-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/painting.html#VisibilityControl">\n      <p>\n        Elements are rendered when the \'display\' attribute is set to any valid value other than \'none\'.\n      </p>\n      <p>\n        For each valid \'display\' value (except none), the test creates a \'rect\' element with that \'display\' value assigned. Under that \n        element, a red \'rect\' is placed at the exact same \'x\', \'y\' position with the same height and width. Test passes if the \'rect\' \n        with \'display\' covers the red \'rect\'.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n	<p>\n	Run the test. No interaction required.\n	</p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Test passes if 16 black rectangles are shown and there is no red visible on the page.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: painting-control-01-f.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n\n    <rect width="48px" height="48px" fill="red" />\n    <rect width="48px" height="48px" display="inline" />\n\n    <rect x="50px" width="48px" height="48px" fill="red" />\n    <rect x="50px" width="48px" height="48px" display="block" />\n\n    <rect x="100px" width="48px" height="48px" fill="red" />\n    <rect x="100px" width="48px" height="48px" display="list-item" />\n\n    <rect x="150px" width="48px" height="48px" fill="red" />\n    <rect x="150px" width="48px" height="48px" display="run-in" />\n\n    <rect y="50px" width="48px" height="48px" fill="red" />\n    <rect y="50px" width="48px" height="48px" display="compact" />\n\n    <rect x="50px" y="50px" width="48px" height="48px" fill="red" />\n    <rect x="50px" y="50px" width="48px" height="48px" display="marker" />\n\n    <rect x="100px" y="50px" width="48px" height="48px" fill="red" />\n    <rect x="100px" y="50px" width="48px" height="48px" display="table" />\n\n    <rect x="150px" y="50px" width="48px" height="48px" fill="red" />\n    <rect x="150px" y="50px" width="48px" height="48px" display="inline-table" />\n\n    <rect y="100px" width="48px" height="48px" fill="red" />\n    <rect y="100px" width="48px" height="48px" display="table-row-group" />\n\n    <rect x="50px" y="100px" width="48px" height="48px" fill="red" />\n    <rect x="50px" y="100px" width="48px" height="48px" display="table-header-group" />\n\n    <rect x="100px" y="100px" width="48px" height="48px" fill="red" />\n    <rect x="100px" y="100px" width="48px" height="48px" display="table-footer-group" />\n\n    <rect x="150px" y="100px" width="48px" height="48px" fill="red" />\n    <rect x="150px" y="100px" width="48px" height="48px" display="table-row" />\n\n    <rect y="150px" width="48px" height="48px" fill="red" />\n    <rect y="150px" width="48px" height="48px" display="table-column-group" />\n\n    <rect x="50px" y="150px" width="48px" height="48px" fill="red" />\n    <rect x="50px" y="150px" width="48px" height="48px" display="table-column" />\n\n    <rect x="100px" y="150px" width="48px" height="48px" fill="red" />\n    <rect x="100px" y="150px" width="48px" height="48px" display="table-cell" />\n\n    <rect x="150px" y="150px" width="48px" height="48px" fill="red" />\n    <rect x="150px" y="150px" width="48px" height="48px" display="table-caption" />\n\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.4 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'painting-control-02-f.svg', svg: '<svg id="svg-root" width="100%" height="100%"\n  viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg"\n  xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="CL" author="Microsoft" status="accepted"\n    version="$Revision: 1.3 $" testname="$RCSfile: painting-control-02-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/painting.html#StrokeProperties">\n      <p>\n        \'Stroke\' attributes affected by directionality start at the point at which the graphics element starts.\n      </p>\n      <p>\n        The test creates two \'path\' elements that have the same \'stroke-dasharray\' assignment. The paths will create the same visual shape,\n        but the start and end points will be opposite. Test passes if the \'stroke-dasharray\' of each path is drawn differently.\n        Second subtest is the same but with stroke-dashoffset.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n	<p>\n	Run the test. No interaction required.\n	</p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Test passes if there are two lines, each composed of alternating black and orange boxes.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: painting-control-02-f.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n\n    <path d="M 100 100 L 100 190" fill="none" stroke="orange" stroke-width="20" stroke-dasharray="10px 20px 20px" />\n    <path d="M 100 190 L 100 100" fill="none" stroke="black" stroke-width="20" stroke-dasharray="10px 20px 20px" />\n\n    <path d="M 200 100 L 200 190" fill="none" stroke="orange" stroke-width="20" stroke-dashoffset="5px" stroke-dasharray="10px 10px 10px" />\n    <path d="M 200 190 L 200 100" fill="none" stroke="black" stroke-width="20" stroke-dashoffset="5px" stroke-dasharray="10px 10px 10px" />\n\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.3 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'painting-control-03-f.svg', svg: '<svg id="svg-root" width="100%" height="100%"\n  viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg"\n  xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="CL" author="Microsoft" status="accepted"\n    version="$Revision: 1.5 $" testname="$RCSfile: painting-control-03-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/painting.html#FillProperties">\n      <p>\n        Open polyline and path elements are filled as if they were closed with the last point linked to the first point.\n      </p>\n      <p>\n        The test specifies two polylines and two paths on the page with five points each. One polyline/path closes the shape with the fifth\n        point linking to the first. One polyline/path is open (no link from fifth point to first). Both polylines/paths are filled.\n        The open subpath is placed over the closed one. Test passes if the open subpath fills over the closed path.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Test passes if two black shapes are shown and no red visible on the page.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: painting-control-03-f.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n\n    <path d="M 20 100 L 50 150 L 100 200 L 175 175 L 150 150 z" fill="red" />\n    <path d="M 20 100 L 50 150 L 100 200 L 175 175 L 150 150" fill="black" stroke="black" />\n\n    <polyline points="200 100 250 150 300 200 375 175 350 150 " fill="red" />\n    <polyline points="200 100 250 150 300 200 375 175 350 150 200 100" fill="black" stroke="black" />\n\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.5 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'painting-control-04-f.svg', svg: '<svg id="svg-root" width="100%" height="100%"\n  viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg"\n  xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="CL" author="Microsoft" status="accepted"\n    version="$Revision: 1.4 $" testname="$RCSfile: painting-control-04-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/painting.html#StrokeProperties">\n      <p>\n        A zero length subpath with \'stroke-linecap\' set to \'square\' or \'round\' is stroked, but not stroked when \'stroke-linecap\' is set to \'butt\'.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript> \n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Test passes if there is a blue circle, a blue square, and no red on the page.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: painting-control-04-f.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n\n    <path d="M 96 96 L 96 96" stroke="red" stroke-width="96" stroke-linecap="butt" />\n    <path d="M 196 96 L 196 96" stroke="blue" stroke-width="96" stroke-linecap="round" />\n    <path d="M 296 96 L 296 96" stroke="blue" stroke-width="96" stroke-linecap="square" />\n\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.4 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'painting-control-05-f.svg', svg: '<svg id="svg-root" width="100%" height="100%" viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/" template-version="1.4" reviewer="ED" author="Microsoft" status="accepted" version="$Revision: 1.3 $" testname="$RCSfile: painting-control-05-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/painting.html#VisibilityControl">\n      <p>\n        This tests setting the \'display\' property to \'none\' on an element that is a child of a \'mask\' or \'clipPath\' element, which should cause the element to not be\n        included in the \'mask\' or \'clip\' region.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The test is passed if there are 8 green rectangles visible, and no red.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: painting-control-05-f.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <defs>\n        <rect id="displaynone_rect" width="100%" height="100%" display="none" />\n        <rect id="rect" width="100%" height="100%" />\n        <use id="displaynone_use_rect" xlink:href="#displaynone_rect"/>\n        \n        <!-- an empty mask where the basic shape element has display=none -->\n        <mask id="testMask1">\n            <rect width="100%" height="100%" display="none" fill="white" />\n        </mask>\n        <!-- an empty mask where display=none is inherited down to the basic shape -->\n        <mask id="testMask2">\n            <g display="none">\n              <rect width="100%" height="100%" fill="white" />\n            </g>\n        </mask>\n        <!-- an empty mask where the referenced element has display=none -->\n        <mask id="testMask3">\n            <use xlink:href="#displaynone_rect" fill="white"/>\n        </mask>\n        <!-- an empty mask by two levels of indirection -->\n        <mask id="testMask4">\n            <use xlink:href="#displaynone_use_rect" fill="white"/>\n        </mask>\n\n        <!-- an empty clip-path where the basic shape element has display=none -->\n        <clipPath id="testClip1">\n            <rect width="100%" height="100%" display="none" />\n        </clipPath>\n        <!-- an empty clip-path where the referenced element has display=none -->\n        <clipPath id="testClip2">\n            <use xlink:href="#displaynone_rect"/>\n        </clipPath>\n        <!-- an empty clip-path where the referencing element has display=none -->\n        <clipPath id="testClip3">\n            <use xlink:href="#rect" display="none"/>\n        </clipPath>\n        <!-- an empty clip-path by having both a display=none element and a non-rendered rect that\'s visible -->\n        <clipPath id="testClip4">\n            <rect width="100%" height="100%" display="none" />\n            <rect width="0" height="0"/>\n        </clipPath>\n    </defs>\n    \n    <g id="reference" fill="lime" stroke="black">\n      <rect x="50" y="50" width="100" height="100"/>\n      <rect x="150" y="50" width="100" height="100"/>\n      <rect x="250" y="50" width="100" height="100"/>\n      <rect x="350" y="50" width="100" height="100"/>\n      <rect x="50" y="200" width="100" height="100"/>\n      <rect x="150" y="200" width="100" height="100"/>\n      <rect x="250" y="200" width="100" height="100"/>\n      <rect x="350" y="200" width="100" height="100"/>\n    </g>\n    \n    <rect x="50" y="50" width="100" height="100" fill="red" mask="url(#testMask1)"/>\n    <rect x="150" y="50" width="100" height="100" fill="red" mask="url(#testMask2)"/>\n    <rect x="250" y="50" width="100" height="100" fill="red" mask="url(#testMask3)"/>\n    <rect x="350" y="50" width="100" height="100" fill="red" mask="url(#testMask4)"/>\n    \n    <rect x="50" y="200" width="100" height="100" fill="red" clip-path="url(#testClip1)"/>\n    <rect x="150" y="200" width="100" height="100" fill="red" clip-path="url(#testClip2)"/>\n    <rect x="250" y="200" width="100" height="100" fill="red" clip-path="url(#testClip3)"/>\n    <rect x="350" y="200" width="100" height="100" fill="red" clip-path="url(#testClip4)"/>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.3 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'painting-control-06-f.svg', svg: '<svg id="svg-root" width="100%" height="100%" viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/" template-version="1.4" \n    reviewer="ED" author="Microsoft" status="accepted" version="$Revision: 1.4 $" testname="$RCSfile: painting-control-06-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/painting.html#VisibilityControl">\n      <p>\n        Setting the \'visibility\' property to \'hidden\' on a \'g\' tag will affect its children, unless the children of the \'g\' tag override the parent setting.\n      </p>\n      <p>\n        Have a \'g\' tag with an red filled shape as a child. Set \'visibility: hidden\' on the \'g\' tag.  Verify no red is on the page.\n        Also, have a \'g\' tag with a green filled shape as a child. Set \'visibility: hidden\' on the \'g\' tag. Set \'visibility: visible\' on\n        the child tag. Verify that the green \'rect\' renders on the page.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The test is passed if there are two green squares visible on the page, and no red.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: painting-control-06-f.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <rect x="96" y="96" width="96" height="96" fill="lime" />\n    <g visibility="hidden">\n        <rect x="96" y="96" width="96" height="96" fill="red" />\n    </g>\n    <rect x="196.5" y="196.5" width="95" height="95" fill="red"/>\n    <g visibility="hidden">\n        <rect x="196" y="196" width="96" height="96" fill="lime" visibility="visible" />\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.4 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'painting-fill-01-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Kevin McCluskey" status="accepted"\n    version="$Revision: 1.7 $" testname="$RCSfile: painting-fill-01-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/painting.html#FillProperties">\n        <p>\n          Verify the basic capability to handle the fill properties fill:none,\n          and fill with a color			(fill:green)\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        There should be two rectangles, the rectangle on the left hollow (fill:none) and the rectangle on the right filled with green.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: painting-fill-01-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <text font-size="36" x="40" y="42">Basic paint: fill properties.</text>\n\n    <!-- ============================================================================= -->\n    <!-- Draw two simple rectangles. One without fill other with fill:green              -->\n    <!-- ============================================================================= -->\n\n    <rect id="fill-01" fill="none" stroke="#000000" x="75" y="70" width="100" height="160"/>\n\n    <rect id="fill-02" fill="green" stroke="#000000" x="275" y="70" width="100" height="160"/>\n\n    <text font-size="36" x="75" y="280">fill="none"</text>\n    <text font-size="36" x="275" y="280">fill="green"</text>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.7 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'painting-fill-02-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Kevin McCluskey" status="accepted"\n    version="$Revision: 1.5 $" testname="$RCSfile: painting-fill-02-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/painting.html#FillProperties">\n        <p>\n          The test uses the "currentColor" value for the "fill" attribute.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The rectangle on the left should be green filled, the rectangle on the right should be blue.\n        The text above the rectangles should be black.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: painting-fill-02-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <g color="green">\n\n      <text font-family="Arial" font-size="36" x="30" y="42">Basic paint: fill properties.</text>\n      <text font-family="Arial" font-size="36" x="100" y="80">fill="currentColor"</text>\n\n      <!-- ====================================================================== -->\n      <!-- Second set of rectangles with fill:currentColor                        -->\n      <!-- ====================================================================== -->\n\n      <rect id="fill-03" fill="currentColor" stroke="#000000" x="75" y="110" width="100" height="140"/>\n      <rect id="fill-04" color="blue" fill="currentColor" stroke="#000000" x="275" y="110" width="100" height="140"/>\n\n      <text font-family="Arial" font-size="36" x="80" y="280">green</text>\n      <text font-family="Arial" font-size="36" x="290" y="280">blue</text>\n\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.5 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'painting-fill-03-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Kevin McCluskey" status="accepted"\n    version="$Revision: 1.7 $" testname="$RCSfile: painting-fill-03-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/painting.html#FillProperties">\n        <p>\n          Verify the basic capability to handle the fill rule properties evenodd and nonzero\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        There should be two green filled stars, the leftmost star should be unfilled in the very center.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: painting-fill-03-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <text font-size="36" x="30" y="42">Basic paint: fill properties.</text>\n\n    <!-- ====================================================================== -->\n    <!-- Third test fill-rule:evenodd and fill-rule:nonzero                     -->\n    <!-- ====================================================================== -->\n\n    <path fill="lime" fill-rule="evenodd" d="M 110 75 l 50 160 l -130 -100 l 160 0 l -130 100 z"/>\n    <path fill="lime" fill-rule="nonzero" d="M 365 75 l 50 160 l -130 -100 l 160 0 l -130 100 z"/>\n    <text font-size="24" x="10" y="282">fill-rule="evenodd"</text>\n    <text font-size="24" x="260" y="282">fill-rule="nonzero"</text>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.7 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'painting-fill-04-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Tim Thompson" status="accepted"\n    version="$Revision: 1.6 $" testname="$RCSfile: painting-fill-04-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/painting.html#FillProperties">\n        <p>\n          This tests inheritance of three properties: "fill", "stroke" and "stroke-width". There is a "g" element (id="G1") which\n          sets fill="blue", stroke="purple", and stroke-width="5". The first two rectangles on top should inherit all those\n          properties. The middle left rectangle has fill="yellow" and stroke-width="2", it should inherit the stroke="purple"\n          from the parent container. The middle rectangle on the right has stroke="yellow", it should inherit fill and\n          stroke-width from the parent "g". The bottom two rectangles are in another "g" element (id="G2") which is a child\n          of "G1". "G2" sets fill="yellow". It should inherit the stroke and stroke width from the parent "G1". The two\n          bottom rectangles set no fill or stroke properties, they should inherit through the parents, stroke="purple"\n          and stroke-width="5".\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The rendered picture should match the reference image, except for possible\n        variations in the labeling text (per CSS2 rules).\n      </p>\n      <p>\n        The test uses the "rect" element, as well as basic fill (solid primary colors),\n        stroke (black 1-pixel lines), font-family (Arial) and font-size properties.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: painting-fill-04-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <g id="G1" fill="blue" stroke="purple" stroke-width="5" transform="translate(120,30)">\n      <rect x="0" y="0" width="90" height="70"/>\n      <rect x="100" y="0" width="90" height="70"/>\n      <rect x="0" y="80" width="90" height="70" fill="yellow" stroke-width="2"/>\n      <rect x="100" y="80" width="90" height="70" stroke="yellow"/>\n      <g id="G2" fill="yellow">\n        <rect x="0" y="160" width="90" height="70"/>\n        <rect x="100" y="160" width="90" height="70"/>\n      </g>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.6 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'painting-fill-05-b.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="DJ" author="CN" status="accepted"\n    version="$Revision: 1.5 $" testname="$RCSfile: painting-fill-05-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/painting.html#FillProperties">\n        <p>\n          Test using "fill-opacity" values for "rect" element.\n          This test verifies that opacity is clamped to the\n          specified range.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The six rect elements on the left have varying \'fill-opacity\' values\n        within the valid range of 0 to 1.  The six elements on the right have\n        \'fill-opacity\' values outside the 0 to 1 range, and must be clamped.\n        The top three rect elements on the right must have their \'fill-opacity\'\n        clamped to 0, while the bottom three rect elements on the right must\n        be clamped to 1.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: painting-fill-05-b.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n\n    <!-- Use multiple values for opacity -->\n    <rect x="20" y="20" width="60" height="60" fill-opacity="0.0" fill="#0000FF" stroke="black"/>\n    <rect x="50" y="50" width="60" height="60" fill-opacity="0.2" fill="#0000FF" stroke="black"/>\n    <rect x="80" y="80" width="60" height="60" fill-opacity="0.4" fill="#0000FF" stroke="black"/>\n    <rect x="110" y="110" width="60" height="60" fill-opacity="0.6" fill="#0000FF" stroke="black"/>\n    <rect x="140" y="140" width="60" height="60" fill-opacity="0.8" fill="#0000FF" stroke="black"/>\n    <rect x="170" y="170" width="60" height="60" fill-opacity="1.0" fill="#0000FF" stroke="black"/>\n    <!-- Values outside the range 0.0 - 1.0 should be clamped to this range -->\n    <rect x="200" y="20" width="60" height="60" fill-opacity="-100.0" fill="#0000FF" stroke="black"/>\n    <rect x="230" y="50" width="60" height="60" fill-opacity="-10.0" fill="#0000FF" stroke="black"/>\n    <rect x="260" y="80" width="60" height="60" fill-opacity="-0.1" fill="#0000FF" stroke="black"/>\n    <rect x="290" y="110" width="60" height="60" fill-opacity="1.1" fill="#0000FF" stroke="black"/>\n    <rect x="320" y="140" width="60" height="60" fill-opacity="10.0" fill="#0000FF" stroke="black"/>\n    <rect x="350" y="170" width="60" height="60" fill-opacity="100.0" fill="#0000FF" stroke="black"/>\n\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.5 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'painting-marker-01-f.svg', svg: '<svg version="1.1" baseProfile="full" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Dean Jackson" status="accepted"\n    version="$Revision: 1.7 $" testname="$RCSfile: painting-marker-01-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/painting.html#Markers">\n        <p>\n          Tests the basic support for markers. \n        </p>\n        <p>\n          The top test examines the basic support for the marker element and style. The markers are purple rectangles.\n        </p>\n        <p>\n          The middle test examines the support for the different styles of marker properties. The\n          "marker-start" property defines the marker to use at the first vertex of the marked path,\n          in this case a purple rectangle. The "marker-end" property defines the marker to use at the\n          last vertex of the marked path, in this case a blue triangle. The "marker-mid" property\n          defines the marker to use at all vertices, other than the first and last, of the marked path,\n          in this case a green circle.\n        </p>\n        <p>\n          The bottom test examines the support for marker orientation along the\n          path direction. The second vertex, the top right corner of the path, has a marker that\n          is rotated 45 degrees, since that is the average of the horizontal and vertical segments\n          each side. The last vertex, the bottom right corner of the path, has a marker rotated 90\n          degrees since that is the direction of the last path segment.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        For the three tests, there should be two identical paths with markers drawn. \n        The path on the left is rendered using the marker elements. The path on the \n        right is rendered using the equivalent SVG, showing what the marked path should \n        look like.\n      </p>\n      <p>\n        The rendered picture should match the reference image, except for possible\n        variations in the labelling text (per CSS2 rules).\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: painting-marker-01-f.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <defs>\n      <!-- ===================================================================== -->\n      <!-- Define a few simple marker elements                                   -->\n      <!-- ===================================================================== -->\n      <marker id="marker1" viewBox="0 0 10 10" markerWidth="2" markerHeight="2" refX="5" refY="5" markerUnits="strokeWidth">\n        <rect width="10" height="10" fill="purple" stroke="none"/>\n      </marker>\n      <marker id="marker2" viewBox="0 0 10 10" markerWidth="2" markerHeight="2" refX="5" refY="5" markerUnits="strokeWidth" orient="auto">\n        <path d="M 5 0 L 10 10 L 0 10 Z" fill="blue" stroke="none"/>\n      </marker>\n      <marker id="markerStart" viewBox="0 0 10 10" markerWidth="2" markerHeight="2" refX="5" refY="5" markerUnits="strokeWidth">\n        <rect width="10" height="10" fill="purple" stroke="none"/>\n      </marker>\n      <marker id="markerMiddle" viewBox="0 0 10 10" markerWidth="2" markerHeight="2" refX="5" refY="5" markerUnits="strokeWidth">\n        <circle cx="5" cy="5" r="5" fill="green" stroke="none"/>\n      </marker>\n      <marker id="markerEnd" viewBox="0 0 10 10" markerWidth="2" markerHeight="2" refX="5" refY="5" markerUnits="strokeWidth">\n        <path d="M 5 0 L 10 10 L 0 10 Z" fill="blue" stroke="none"/>\n      </marker>\n    </defs>\n    <!-- ===================================================================== -->\n    <!-- Basic Marker Test                                                     -->\n    <!-- ===================================================================== -->\n    <text x="170" y="30" font-size="14">Basic Markers</text>\n    <path fill="none" stroke="black" stroke-width="8" marker-start="url(#marker1)" marker-mid="url(#marker1)" marker-end="url(#marker1)" d="M 130 40 L 180 40 L 180 90"/>\n    <!-- ===================================================================== -->\n    <!-- Generate the equivalent SVG                                           -->\n    <!-- ===================================================================== -->\n    <g transform="translate(120,0)">\n      <path fill="none" stroke="black" stroke-width="8" d="M 130 40 L 180 40 L 180 90"/>\n      <g transform="translate(130,40) scale(8) scale(0.2, 0.2) translate(-5, -5)" fill="none" stroke="black" stroke-width="8">\n        <rect width="10" height="10" fill="purple" stroke="none"/>\n      </g>\n      <g transform="translate(180,40) scale(8) scale(0.2, 0.2) translate(-5, -5)" fill="none" stroke="black" stroke-width="8">\n        <rect width="10" height="10" fill="purple" stroke="none"/>\n      </g>\n      <g transform="translate(180,90) scale(8) scale(0.2, 0.2) translate(-5, -5)" fill="none" stroke="black" stroke-width="8">\n        <rect width="10" height="10" fill="purple" stroke="none"/>\n      </g>\n    </g>\n    <!-- ===================================================================== -->\n    <!-- Start, Middle and End Marker Test                                     -->\n    <!-- ===================================================================== -->\n    <text x="145" y="125" font-size="14">Start, Middle and End</text>\n    <path fill="none" stroke="black" stroke-width="8" marker-start="url(#markerStart)" marker-mid="url(#markerMiddle)" marker-end="url(#markerEnd)" d="M 130 135 L 180 135 L 180 185"/>\n    <!-- ===================================================================== -->\n    <!-- Generate the equivalent SVG                                           -->\n    <!-- ===================================================================== -->\n    <g transform="translate(120,0)">\n      <path fill="none" stroke="black" stroke-width="8" d="M 130 135 L 180 135 L 180 185"/>\n      <g transform="translate(130,135) scale(8) scale(0.2, 0.2) translate(-5, -5)" fill="none" stroke="black" stroke-width="8">\n        <rect width="10" height="10" fill="purple" stroke="none"/>\n      </g>\n      <g transform="translate(180,135) scale(8) scale(0.2, 0.2) translate(-5, -5)" fill="none" stroke="black" stroke-width="8">\n        <circle cx="5" cy="5" r="5" fill="green" stroke="none"/>\n      </g>\n      <g transform="translate(180,185) scale(8) scale(0.2, 0.2) translate(-5, -5)" fill="none" stroke="black" stroke-width="8">\n        <path d="M 5 0 L 10 10 L 0 10 Z" fill="blue" stroke="none"/>\n      </g>\n    </g>\n    <!-- ===================================================================== -->\n    <!-- Auto Orientation Marker Test                                          -->\n    <!-- ===================================================================== -->\n    <text x="145" y="220" font-size="14">Automatic Orientation</text>\n    <path fill="none" stroke="black" stroke-width="8" marker-start="url(#marker2)" marker-mid="url(#marker2)" marker-end="url(#marker2)" d="M 130 230 L 180 230 L 180 280"/>\n    <!-- ===================================================================== -->\n    <!-- Generate the equivalent SVG                                           -->\n    <!-- ===================================================================== -->\n    <g transform="translate(120,0)">\n      <path fill="none" stroke="black" stroke-width="8" d="M 130 230 L 180 230 L 180 280"/>\n      <g transform="translate(130,230) rotate(0) scale(8) scale(0.2, 0.2) translate(-5, -5)" fill="none" stroke="black" stroke-width="8">\n        <path d="M 5 0 L 10 10 L 0 10 Z" fill="blue" stroke="none"/>\n      </g>\n      <g transform="translate(180,230) rotate(45) scale(8) scale(0.2, 0.2) translate(-5, -5)" fill="none" stroke="black" stroke-width="8">\n        <path d="M 5 0 L 10 10 L 0 10 Z" fill="blue" stroke="none"/>\n      </g>\n      <g transform="translate(180,280) rotate(90) scale(8) scale(0.2, 0.2) translate(-5, -5)" fill="none" stroke="black" stroke-width="8">\n        <path d="M 5 0 L 10 10 L 0 10 Z" fill="blue" stroke="none"/>\n      </g>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.7 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'painting-marker-02-f.svg', svg: '<svg version="1.1" baseProfile="full" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Dean Jackson" status="accepted"\n    version="$Revision: 1.7 $" testname="$RCSfile: painting-marker-02-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/painting.html#Markers">\n        <p>\n          Tests the rendering of markers, specifically property inheritance. For the four tests, there should\n          be two identical paths with markers drawn. \n        </p>\n        <p>\n          The top two tests examine the rendering of markers when the marker and the path\n          referencing it share the same parent and all painting properties are specfied on\n          that parent. The first test show inheritance of the \'fill\' property and the\n          second the inheritance of the \'paint\' property. In both tests, the marker\n          is painting using the same properties as the referencing object. Because of\n          scaling transformations on the marker, the stroke on the second test is thinner\n          than on the referencing object.\n        </p>\n        <p>\n          The third and fourth tests examine the rendering of markers in a situation where the\n          marker and referencing path do NOT share the same parent and painting\n          properties are specified both on the parent of the marked path and on the contents\n          of the marker itself. In both cases, the marker\'s parent specifies\n          fill="green" stroke="blue" stroke-width="8". For the third test, the marker contents\n          override with stroke="black". For the fourth test, the marker contents\n          override with fill="black". In neither case should you see\n          fill="orange" or stroke="blue" or "stroke="purple" on the markers as these properties\n          are specified on the ancestor of the referencing object or the referencing object itself\n          and thus shouldn\'t affect the marker.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The path on the left is rendered using the marker elements. \n        The path on the right is rendered using the equivalent SVG, \n        showing what the marked path should look like.  These should be \n        identical and match the image to the right.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: painting-marker-02-f.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <defs>\n      <clipPath id="overflowHiddenClip1" clipPathUnits="userSpaceOnUse">\n        <rect x="0" y="0" width="2" height="2"/>\n      </clipPath>\n      <clipPath id="overflowHiddenClip" clipPathUnits="userSpaceOnUse">\n        <rect x="0" y="0" width="4" height="4"/>\n      </clipPath>\n    </defs>\n    <g fill="green">\n      <text x="125" y="30" font-size="14" fill="black">Marker Rendering Properties</text>\n      <!-- ===================================================================== -->\n      <!-- Fill property                                                         -->\n      <!-- ===================================================================== -->\n      <g fill="black" stroke="none" stroke-width="8">\n        <marker id="marker1" viewBox="0 0 10 10" markerWidth="2" markerHeight="2" refX="5" refY="5" markerUnits="strokeWidth">\n          <rect width="10" height="10"/>\n        </marker>\n        <text x="100" y="140" font-size="10" fill="black" stroke="none">Fill Property</text>\n        <path marker-start="url(#marker1)" marker-mid="url(#marker1)" marker-end="url(#marker1)" d="M 30 60 L 80 60 L 80 110 Z"/>\n        <!-- ===================================================================== -->\n        <!-- Generate the equivalent SVG                                           -->\n        <!-- ===================================================================== -->\n        <g transform="translate(120,0)">\n          <path d="M 30 60 L 80 60 L 80 110 Z"/>\n          <g transform="translate(30,60) scale(8) translate(-1, -1)">\n            <g clip-path="url(#overflowHiddenClip1)">\n              <g transform="scale(0.2, 0.2)">\n                <rect width="10" height="10"/>\n              </g>\n            </g>\n          </g>\n          <g transform="translate(80,60) scale(8) translate(-1, -1)">\n            <g clip-path="url(#overflowHiddenClip1)">\n              <g transform="scale(0.2, 0.2)">\n                <rect width="10" height="10"/>\n              </g>\n            </g>\n          </g>\n          <g transform="translate(80,110) scale(8) translate(-1, -1)">\n            <g clip-path="url(#overflowHiddenClip1)">\n              <g transform="scale(0.2, 0.2)">\n                <rect width="10" height="10"/>\n              </g>\n            </g>\n          </g>\n        </g>\n      </g>\n      <!-- ===================================================================== -->\n      <!-- Stroke property                                                       -->\n      <!-- ===================================================================== -->\n      <g fill="none" stroke="black" stroke-width="4">\n        <marker id="marker2" viewBox="0 0 20 20" markerWidth="4" markerHeight="4" refX="10" refY="10" markerUnits="strokeWidth">\n          <rect width="20" height="20"/>\n        </marker>\n        <text x="340" y="140" font-size="10" fill="black" stroke="none">Stroke Property</text>\n        <path marker-start="url(#marker2)" marker-mid="url(#marker2)" marker-end="url(#marker2)" d="M 270 60 L 320 60 L 320 110 Z"/>\n        <!-- ===================================================================== -->\n        <!-- Generate the equivalent SVG                                           -->\n        <!-- ===================================================================== -->\n        <g transform="translate(120,0)">\n          <path d="M 270 60 L 320 60 L 320 110 Z"/>\n          <!-- ===================================================================== -->\n          <!-- Generate the equivalent SVG                                           -->\n          <!-- ===================================================================== -->\n          <g transform="translate(270,60) scale(4) translate(-2, -2)">\n            <g clip-path="url(#overflowHiddenClip)">\n              <g transform="scale(0.2, 0.2)">\n                <rect width="20" height="20"/>\n              </g>\n            </g>\n          </g>\n          <g transform="translate(320,60) scale(4) translate(-2, -2)">\n            <g clip-path="url(#overflowHiddenClip)">\n              <g transform="scale(0.2, 0.2)">\n                <rect width="20" height="20"/>\n              </g>\n            </g>\n          </g>\n          <g transform="translate(320, 110) scale(4) translate(-2, -2)">\n            <g clip-path="url(#overflowHiddenClip)">\n              <g transform="scale(0.2, 0.2)">\n                <rect width="20" height="20"/>\n              </g>\n            </g>\n          </g>\n        </g>\n      </g>\n      <!-- ===================================================================== -->\n      <!-- Define marker element with parents setting painting properties        -->\n      <!-- ===================================================================== -->\n      <g fill="green" stroke="blue" stroke-width="8">\n        <marker id="marker3" viewBox="0 0 20 20" markerWidth="4" markerHeight="4" refX="10" refY="10" markerUnits="strokeWidth">\n          <rect width="20" height="20" stroke="black"/>\n        </marker>\n        <marker id="marker4" viewBox="0 0 10 10" markerWidth="4" markerHeight="4" refX="5" refY="5" markerUnits="strokeWidth">\n          <rect width="10" height="10" fill="black" stroke-width="4"/>\n        </marker>\n      </g>\n      <!-- ===================================================================== -->\n      <!-- Parent and specified properties                                       -->\n      <!-- ===================================================================== -->\n      <g fill="orange" stroke="blue">\n        <text x="90" y="270" font-size="10" fill="black" stroke="none">Mixed Properties</text>\n        <path stroke="purple" stroke-width="4" marker-start="url(#marker3)" marker-mid="url(#marker3)" marker-end="url(#marker3)" d="M 30 190 L 80 190 L 80 240 Z"/>\n        <!-- ===================================================================== -->\n        <!-- Generate the equivalent SVG                                           -->\n        <!-- ===================================================================== -->\n        <g transform="translate(120,0)">\n          <path stroke="purple" stroke-width="4" d="M 30 190 L 80 190 L 80 240 Z"/>\n          <g fill="green" stroke="black" stroke-width="8">\n            <g transform="translate(30,190) scale(4) translate(-2, -2)">\n              <g clip-path="url(#overflowHiddenClip)">\n                <g transform="scale(.2, .2)">\n                  <rect width="20" height="20"/>\n                </g>\n              </g>\n            </g>\n            <g transform="translate(80,190) scale(4) translate(-2, -2)">\n              <g clip-path="url(#overflowHiddenClip)">\n                <g transform="scale(0.2, 0.2)">\n                  <rect width="20" height="20"/>\n                </g>\n              </g>\n            </g>\n            <g transform="translate(80,240) scale(4) translate(-2, -2)">\n              <g clip-path="url(#overflowHiddenClip)">\n                <g transform="scale(0.2, 0.2)">\n                  <rect width="20" height="20"/>\n                </g>\n              </g>\n            </g>\n          </g>\n        </g>\n      </g>\n      <g fill="orange" stroke="green">\n        <text x="340" y="270" font-size="10" fill="black" stroke="none">Mixed Properties</text>\n        <path stroke="purple" stroke-width="4" marker-start="url(#marker4)" marker-mid="url(#marker4)" marker-end="url(#marker4)" d="M 270 190 L 320 190 L 320 240 Z"/>\n        <!-- ===================================================================== -->\n        <!-- Generate the equivalent SVG                                           -->\n        <!-- ===================================================================== -->\n        <g transform="translate(120,0)">\n          <path stroke="purple" stroke-width="4" d="M 270 190 L 320 190 L 320 240 Z"/>\n          <g fill="black" stroke="blue" stroke-width="4">\n            <g transform="translate(270,190) scale(4) translate(-2, -2)">\n              <g clip-path="url(#overflowHiddenClip)">\n                <g transform="scale(0.4, 0.4)">\n                  <rect width="10" height="10"/>\n                </g>\n              </g>\n            </g>\n            <g transform="translate(320,190) scale(4) translate(-2, -2)">\n              <g clip-path="url(#overflowHiddenClip)">\n                <g transform="scale(0.4, 0.4)">\n                  <rect width="10" height="10"/>\n                </g>\n              </g>\n            </g>\n            <g transform="translate(320,240) scale(4) translate(-2, -2)">\n              <g clip-path="url(#overflowHiddenClip)">\n                <g transform="scale(0.4, 0.4)">\n                  <rect width="10" height="10"/>\n                </g>\n              </g>\n            </g>\n          </g>\n        </g>\n      </g>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.7 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'painting-marker-04-f.svg', svg: '<svg version="1.1" baseProfile="full" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="CL" author="BB" status="accepted"\n    version="$Revision: 1.7 $" testname="$RCSfile: painting-marker-04-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/painting.html#Markers">\n        <p>\n          The SVG specification defines three properties to reference markers: marker-start, marker-mid,\n          marker-end. It also provides a shorthand property,marker.  Using the marker property from a style sheet\n          is equivalent to using all three (start, mid, end). However, shorthand properties cannot be used as presentation attributes.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The test passes if the shapes in the top row have no markers,\n        while the shapes in the bottom rom have small blue markers\n        (26 in total).\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: painting-marker-04-f.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <defs>\n      <marker id="marker1" markerUnits="strokeWidth" refX="50" refY="50" markerWidth="5" markerHeight="5" viewBox="0 0 100 100">\n        <rect width="100" height="100" fill="royalblue" stroke="none"/>\n      </marker>\n      <marker id="marker2" markerUnits="strokeWidth" refX="100" refY="100" markerWidth="15" markerHeight="15" viewBox="0 0 200 200">\n        <rect width="200" height="200" fill="red" stroke="none"/>\n      </marker>\n    </defs>\n\n    <text font-size="20" x="240" y="28" text-anchor="middle">\'marker\' attribute test</text>\n\n    <text font-size="20" x="240" y="70" text-anchor="middle" fill="forestgreen">\'marker\' attribute</text>\n    <g marker="url(#marker2)" fill="gold" stroke="black" fill-rule="evenodd" transform="translate(50,20)" id="markme">\n      <path d="M10,60 Q90,60 90,140 Q10,140 10,60 Z M10,140 Q10,60 90,60 Q90,140 10,140 Z M50,70 L80,100 50,130 20,100 Z"/>\n      <polygon points="100,60 120,140 140,60 160,140 180,60 180,100 100,100"/>\n      <polyline points="190,60 210,140 230,60 250,140 270,60 270,100 190,100"/>\n      <line x1="280" x2="370" y1="60" y2="140"/>\n      <line x1="370" x2="280" y1="60" y2="140"/>\n    </g>\n\n    <text font-size="20" x="240" y="200" text-anchor="middle" fill="forestgreen">\'marker-start\', \'marker-mid\' &amp; \'marker-end\' attributes</text>\n    <g marker-mid="url(#marker1)" marker-end="url(#marker1)" marker-start="url(#marker1)" fill="gold" stroke="black" fill-rule="evenodd" transform="translate(50,150)">\n      <path d="M10,60 Q90,60 90,140 Q10,140 10,60 Z M10,140 Q10,60 90,60 Q90,140 10,140 Z M50,70 L80,100 50,130 20,100 Z"/>\n      <polygon points="100,60 120,140 140,60 160,140 180,60 180,100 100,100"/>\n      <polyline points="190,60 210,140 230,60 250,140 270,60 270,100 190,100"/>\n      <line x1="280" x2="370" y1="60" y2="140"/>\n      <line x1="370" x2="280" y1="60" y2="140"/>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.7 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'painting-marker-06-f.svg', svg: '<svg id="svg-root" width="100%" height="100%" \n  viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg" \n  xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="AG" author="ED" status="accepted"\n    version="$Revision: 1.9 $" testname="$RCSfile: painting-marker-06-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/painting.html#MarkerElement">\n        <p>\n          Tests the basic support for markers. For the three tests, there\n          should be two identical paths with markers drawn. The path on the left is\n          rendered using the marker elements. The path on the right is rendered using\n          the equivalent SVG, showing what the marked path should look like.\n        </p>\n        <p>\n          This test is similar to the painting-marker-01-f.svg test, but has some viewBox attributes\n          that have a non-zero offset.\n        </p>\n        <p>\n          The top test examines the basic support for the marker element and style. The markers are purple rectangles.\n        </p>\n        <p>\n          The middle test examines the support for the different styles of marker properties. The\n          "marker-start" property defines the marker to use at the first vertex of the marked path,\n          in this case a purple rectangle. The "marker-end" property defines the marker to use at the\n          last vertex of the marked path, in this case a blue triangle. The "marker-mid" property\n          defines the marker to use at all vertices, other than the first and last, of the marked path,\n          in this case a green circle.\n        </p>\n        <p>\n          The bottom test examines the support for marker orientation along the\n          path direction. The second vertex, the top right corner of the path, has a marker that\n          is rotated 45 degrees, since that is the average of the horizontal and vertical segments\n          each side. The last vertex, the bottom right corner of the path, has a marker rotated 90\n          degrees since that is the direction of the last path segment.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The rendered picture should match the reference image, except for possible\n        variations in the labelling text (per CSS2 rules).\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: painting-marker-06-f.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <defs>\n		<!-- ===================================================================== -->\n		<!-- Define a few simple marker elements                                   -->\n		<!-- ===================================================================== -->\n    <marker id="marker1" viewBox="20 20 10 10" markerWidth="2" markerHeight="2" refX="25" refY="25" markerUnits="strokeWidth">\n      <rect x="20" y="20" width="10" height="10" fill="purple" stroke="none"/>\n    </marker>\n    <marker id="marker2" viewBox="-5 -5 10 10" markerWidth="2" markerHeight="2" markerUnits="strokeWidth" orient="auto">\n      <path d="M 0 -5 L 5 5 L -5 5 Z" fill="blue" stroke="none"/>\n    </marker>\n  	<marker id="markerStart" viewBox="0 0 10 10" markerWidth="2" markerHeight="2" refX="5" refY="5" markerUnits="strokeWidth">\n			<rect width="10" height="10" fill="purple" stroke="none"/>\n		</marker>\n		<marker id="markerMiddle" viewBox="0 0 10 10" markerWidth="2" markerHeight="2" refX="5" refY="5" markerUnits="strokeWidth">\n			<circle cx="5" cy="5" r="5" fill="green" stroke="none"/>\n		</marker>\n		<marker id="markerEnd" viewBox="0 0 10 10" markerWidth="2" markerHeight="2" refX="5" refY="5" markerUnits="strokeWidth">\n			<path d="M 5 0 L 10 10 L 0 10 Z" fill="blue" stroke="none"/>\n		</marker>\n	</defs>\n		<!-- ===================================================================== -->\n		<!-- Basic Marker Test                                                     -->\n		<!-- ===================================================================== -->\n		<text x="170" y="30" font-size="14">Basic Markers</text>\n		<path fill="none" stroke="black" stroke-width="8" marker-start="url(#marker1)" marker-mid="url(#marker1)" marker-end="url(#marker1)" d="M 130 40 L 180 40 L 180 90"/>\n		<!-- ===================================================================== -->\n		<!-- Generate the equivalent SVG                                           -->\n		<!-- ===================================================================== -->\n		<g transform="translate(120,0)">\n			<path fill="none" stroke="black" stroke-width="8" d="M 130 40 L 180 40 L 180 90"/>\n			<g transform="translate(130,40) scale(8) scale(0.2, 0.2) translate(-5, -5)" fill="none" stroke="black" stroke-width="8">\n				<rect width="10" height="10" fill="purple" stroke="none"/>\n			</g>\n			<g transform="translate(180,40) scale(8) scale(0.2, 0.2) translate(-5, -5)" fill="none" stroke="black" stroke-width="8">\n				<rect width="10" height="10" fill="purple" stroke="none"/>\n			</g>\n			<g transform="translate(180,90) scale(8) scale(0.2, 0.2) translate(-5, -5)" fill="none" stroke="black" stroke-width="8">\n				<rect width="10" height="10" fill="purple" stroke="none"/>\n			</g>\n		</g>\n		<!-- ===================================================================== -->\n		<!-- Start, Middle and End Marker Test                                     -->\n		<!-- ===================================================================== -->\n		<text x="145" y="125" font-size="14">Start, Middle and End</text>\n		<path fill="none" stroke="black" stroke-width="8" marker-start="url(#markerStart)" marker-mid="url(#markerMiddle)" marker-end="url(#markerEnd)" d="M 130 135 L 180 135 L 180 185"/>\n		<!-- ===================================================================== -->\n		<!-- Generate the equivalent SVG                                           -->\n		<!-- ===================================================================== -->\n		<g transform="translate(120,0)">\n			<path fill="none" stroke="black" stroke-width="8" d="M 130 135 L 180 135 L 180 185"/>\n			<g transform="translate(130,135) scale(8) scale(0.2, 0.2) translate(-5, -5)" fill="none" stroke="black" stroke-width="8">\n				<rect width="10" height="10" fill="purple" stroke="none"/>\n			</g>\n			<g transform="translate(180,135) scale(8) scale(0.2, 0.2) translate(-5, -5)" fill="none" stroke="black" stroke-width="8">\n				<circle cx="5" cy="5" r="5" fill="green" stroke="none"/>\n			</g>\n			<g transform="translate(180,185) scale(8) scale(0.2, 0.2) translate(-5, -5)" fill="none" stroke="black" stroke-width="8">\n				<path d="M 5 0 L 10 10 L 0 10 Z" fill="blue" stroke="none"/>\n			</g>\n		</g>\n		<!-- ===================================================================== -->\n		<!-- Auto Orientation Marker Test                                          -->\n		<!-- ===================================================================== -->\n		<text x="145" y="220" font-size="14">Automatic Orientation</text>\n		<path fill="none" stroke="black" stroke-width="8" marker-start="url(#marker2)" marker-mid="url(#marker2)" marker-end="url(#marker2)" d="M 130 230 L 180 230 L 180 280"/>\n		<!-- ===================================================================== -->\n		<!-- Generate the equivalent SVG                                           -->\n		<!-- ===================================================================== -->\n		<g transform="translate(120,0)">\n			<path fill="none" stroke="black" stroke-width="8" d="M 130 230 L 180 230 L 180 280"/>\n			<g transform="translate(130,230) rotate(0) scale(8) scale(0.2, 0.2) translate(-5, -5)" fill="none" stroke="black" stroke-width="8">\n				<path d="M 5 0 L 10 10 L 0 10 Z" fill="blue" stroke="none"/>\n			</g>\n			<g transform="translate(180,230) rotate(45) scale(8) scale(0.2, 0.2) translate(-5, -5)" fill="none" stroke="black" stroke-width="8">\n				<path d="M 5 0 L 10 10 L 0 10 Z" fill="blue" stroke="none"/>\n			</g>\n			<g transform="translate(180,280) rotate(90) scale(8) scale(0.2, 0.2) translate(-5, -5)" fill="none" stroke="black" stroke-width="8">\n				<path d="M 5 0 L 10 10 L 0 10 Z" fill="blue" stroke="none"/>\n			</g>\n		</g>    \n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n  <text id="revision" x="10" y="340" stroke="none" \n    fill="black">$Revision: 1.9 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240" \n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'painting-marker-07-f.svg', svg: '<svg id="svg-root" width="100%" height="100%" viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/" template-version="1.4" reviewer="CL" author="Microsoft" status="accepted" version="$Revision: 1.3 $" testname="$RCSfile: painting-marker-07-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/painting.html#Markers">\n      <p>\n        A \'marker\' element with \'display\' set to \'none\' on that\n        element or any ancestor is rendered when referenced by another element.\n      </p>\n    </d:testDescription>\n        <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Test passes if there are two green triangles visible on the page.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: painting-marker-07-f.svg,v $</title>\n    <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <defs>\n        <marker id="testMarker" markerWidth="100" markerHeight="100" display="none">\n            <path d="M 0 0 L 200 200 L 0 150 z" fill="green" />\n        </marker>\n        <g display="none">\n          <marker id="testMarker2" markerWidth="100" markerHeight="100">\n            <path d="M 0 0 L 200 200 L 0 150 z" fill="green" />\n          </marker>\n        </g>\n    </defs>\n    <path d="M 0 0 L 25 25" marker-end="url(#testMarker)" />\n    <path d="M 100 0 L 125 25" marker-end="url(#testMarker2)" />\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.3 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>\n  -->\n</svg>'},
  {name: 'painting-stroke-01-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Kevin McCluskey" status="accepted"\n    version="$Revision: 1.8 $" testname="$RCSfile: painting-stroke-01-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/painting.html#StrokeProperties">\n      <p>\n        Verify the basic capability to handle the stroke properties ("stroke")\n        in combination with the "rect" element .\n        The pair should be rendered as two blue rectangles,\n        the upper one without a stroke and the lower with a green stroke.\n      </p>\n      <p>\n        The test uses the "rect" element, as well as basic "fill" (solid primary colors),\n        "stroke", stroke="green", "font-family" and "font-size" attributes.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The rendered picture should match the reference image, except for possible\n        variations in the labeling text (per CSS2 rules).\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: painting-stroke-01-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <!-- ============================================================================= -->\n    <!-- Draw two simple rectangles. One without stroke other with stroke:green          -->\n    <!-- ============================================================================= -->\n    <text font-size="36" x="10" y="40">Basic paint: stroke properties.</text>\n    <rect id="stroke-01" fill="blue" stroke="none" x="90" y="70" width="300" height="50"/>\n    <rect id="stroke-02" fill="blue" stroke-width="20" stroke="green" x="90" y="190" width="300" height="50"/>\n    <text font-size="30" x="140" y="150">stroke="none"</text>\n    <text font-size="30" x="148" y="280">stroke="green"</text>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.8 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'painting-stroke-02-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Kevin McCluskey" status="accepted"\n    version="$Revision: 1.7 $" testname="$RCSfile: painting-stroke-02-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/painting.html#StrokeProperties">\n      <p>\n        Verify the basic capability to handle the stroke properties ("stroke", "stroke-width",\n        "stroke-linejoin") in combination with the "rect" element.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The pair should be rendered as two blue rectangles without an interior fill.\n        The upper rectangle should have a thick stroke and sharp corners.\n        The lower rectangle should have a thick stroke and round corners.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: painting-stroke-02-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <!-- ====================================================================== -->\n    <!-- Set of rectangles with stroke-width:10 and stroke-linejoin:round-->\n    <!-- ====================================================================== -->\n    <text font-size="36" x="10" y="40">Basic paint: stroke properties.</text>\n    <rect id="stroke-01" fill="none" stroke="blue" stroke-width="20" x="90" y="70" width="300" height="50"/>\n    <rect id="stroke-02" fill="none" stroke="blue" stroke-width="20" stroke-linejoin="round" x="90" y="190" width="300" height="50"/>\n    <text font-size="40" x="120" y="160">stroke-width="20"</text>\n    <text font-size="40" x="58" y="290">stroke-linejoin="round"</text>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.7 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'painting-stroke-03-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Kevin McCluskey" status="accepted"\n    version="$Revision: 1.6 $" testname="$RCSfile: painting-stroke-03-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/painting.html#StrokeProperties">\n      <p>\n        This test checks the basic capability of handling the stroke properties ("stroke", "stroke-width"\n        "stroke-linejoin", "stroke-linecap", "stroke-miterlimit")\n        with straight-line path commands.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The two paths should be rendered as two blue line segments.\n        The upper segment should have round end caps. The lower segment\n        should be chopped off where the two line segments meet.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: painting-stroke-03-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <!-- ====================================================================== -->\n    <!-- Test stroke-linecap:round and stroke-miterlimit:1                -->\n    <!-- ====================================================================== -->\n    <text font-size="36" x="10" y="40">Basic paint: stroke properties.</text>\n    <path fill="none" stroke="blue" stroke-width="30" stroke-linecap="round" d="M 160 70 l 200 20 l -200 20 "/>\n    <path fill="none" stroke="blue" stroke-width="30" stroke-linejoin="miter" stroke-miterlimit="1" d="M 160 190 l 200 20 l -200 20"/>\n    <text font-size="40" x="60" y="160">stroke-linecap="round"</text>\n    <text font-size="40" x="130" y="280">stroke-miterlimit="1"</text>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.6 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'painting-stroke-04-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Kevin McCluskey" status="accepted"\n    version="$Revision: 1.6 $" testname="$RCSfile: painting-stroke-04-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/painting.html#StrokeProperties">\n        <p>\n          This test checks the "stroke-dasharray" and "stroke-dashoffset" properties. Two lines are drawn, one blue\n        and one black. Both have a "stroke-dasharray" of "10,10" giving a dashed appearance\n        where the size of the gaps and the size of the dash is equal.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      Run the test. No interaction required.\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The black line is lower than but parallel to the blue line. The "stroke-dashoffset" on each line should make the dashes of each line line up with the gaps in the other line.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: painting-stroke-04-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <!-- ====================================================================== -->\n    <!-- Test stroke-dasharray and stroke-dashoffset                            -->\n    <!-- ====================================================================== -->\n    <text font-size="36" x="10" y="60">Basic paint: stroke properties.</text>\n    <path id="stroke-7b" fill="none" stroke="blue" stroke-width="25" stroke-dashoffset="0" stroke-dasharray="10,10" d="M 50 120 L 430 120"/>\n    <path id="stroke-7c" fill="none" stroke="black" stroke-width="25" stroke-dashoffset="10" stroke-dasharray="10,10" d="M 50 140 L 430 140"/>\n    <text font-size="30" x="65" y="210">stroke-dasharray="10, 10"</text>\n    <text font-size="30" x="75" y="260">stroke-dashoffset="10"</text>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.6 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'painting-stroke-05-t.svg', svg: '<svg version="1.1" baseProfile="tiny" shape-rendering="geometricPrecision" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="CL" author="BB" status="accepted"\n    version="$Revision: 1.6 $" testname="$RCSfile: painting-stroke-05-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/painting.html#StrokeProperties">\n      <p>\n        User agents may render graphical primitives with different levels of accuracy.\n        This test is aimed at determining how a UA renders thin strokes.\n      </p>\n      <p>\n        The test file contains a number of vertical and horizontal lines.\n        The stroke width of the vertical lines increase from left to right.\n        The stroke width of the horizontal lines increase from top to bottom.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      Run the test. No interaction required.\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The test is passed if user is able to see a smooth stroke width\n        increment for the vertical and horizontal lines. The top left hand\n        corner should contain strokes that are very thin in width and the bottom\n        right hand corner should contain thick strokes.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: painting-stroke-05-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <text font-size="20" x="240" y="30" text-anchor="middle">Rendering thin strokes</text>\n\n    <polyline points="030,50 030,300" stroke="black" stroke-width="0.001"/>\n    <polyline points="50,50 50,300" stroke="black" stroke-width="0.1"/>\n    <polyline points="70,50 70,300" stroke="black" stroke-width="0.2"/>\n    <polyline points="90,50 90,300" stroke="black" stroke-width="0.3"/>\n    <polyline points="110,50 110,300" stroke="black" stroke-width="0.4"/>\n    <polyline points="130,50 130,300" stroke="black" stroke-width="0.5"/>\n    <polyline points="150,50 150,300" stroke="black" stroke-width="0.6"/>\n    <polyline points="170,50 170,300" stroke="black" stroke-width="0.7"/>\n    <polyline points="190,50 190,300" stroke="black" stroke-width="0.8"/>\n    <polyline points="210,50 210,300" stroke="black" stroke-width="0.9"/>\n    <polyline points="230,50 230,300" stroke="black" stroke-width="1.0"/>\n    <polyline points="250,50 250,300" stroke="black" stroke-width="1.1"/>\n    <polyline points="270,50 270,300" stroke="black" stroke-width="1.2"/>\n    <polyline points="290,50 290,300" stroke="black" stroke-width="1.3"/>\n    <polyline points="310,50 310,300" stroke="black" stroke-width="1.4"/>\n    <polyline points="330,50 330,300" stroke="black" stroke-width="1.5"/>\n    <polyline points="350,50 350,300" stroke="black" stroke-width="1.6"/>\n    <polyline points="370,50 370,300" stroke="black" stroke-width="1.7"/>\n    <polyline points="390,50 390,300" stroke="black" stroke-width="1.8"/>\n    <polyline points="410,50 410,300" stroke="black" stroke-width="1.9"/>\n    <polyline points="430,50 430,300" stroke="black" stroke-width="2.0"/>\n    <polyline points="450,50 450,300" stroke="black" stroke-width="2.1"/>\n\n    <line x1="10" x2="470" y1="100" y2="100" stroke="darkblue" stroke-width="0.1"/>\n    <line x1="10" x2="470" y1="150" y2="150" stroke="darkblue" stroke-width="0.5"/>\n    <line x1="10" x2="470" y1="200" y2="200" stroke="darkblue" stroke-width="1"/>\n    <line x1="10" x2="470" y1="250" y2="250" stroke="darkblue" stroke-width="2"/>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.6 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'painting-stroke-06-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="CL" author="CN" status="accepted"\n    version="$Revision: 1.7 $" testname="$RCSfile: painting-stroke-06-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/painting.html#StrokeProperties">\n        <p>\n          Test default effects of stroke-dasharray.\n        </p>\n        <p>\n          This specifically tests the values of none and 0.\n          This also tests an odd number of values in a dash-array attribute\n          and in combination with an offset.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      Run the test. No interaction required.\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The top two lines must be solid black. The next line shows a thick\n        black line with a thinner blue line on top; both must have the same\n        dash pattern. The bottom two lines, one black and one blue, must render\n        so that the gaps of one correspond to the dashes of the other.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: painting-stroke-06-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <g transform="scale(1.8)">\n\n      <!-- No dasharray -->\n      <path stroke="black" stroke-width="10" fill="none" stroke-dasharray="none" d="   M  20 20   L  200 20"/>\n\n      <path stroke="black" stroke-width="10" fill="none" stroke-dasharray="0" d="   M  20 40   L  200 40"/>\n\n      <!-- Odd number, should repeat to make an even number -->\n      <path stroke="black" stroke-width="20" fill="none" stroke-dasharray="5,2,5,5,2,5" d="   M  20 60   L  200 60"/>\n      <path stroke="blue" stroke-width="10" fill="none" stroke-dasharray="5,2,5" d="   M  20 60   L  200 60"/>\n\n      <!-- Odd number, with a dashoffset test -->\n      <path stroke="black" stroke-width="10" fill="none" stroke-dasharray="2" d="   M  20 80   L  200 80"/>\n\n      <path stroke="blue" stroke-width="10" fill="none" stroke-dasharray="2" stroke-dashoffset="2" d="         M  20 90   L  200 90"/>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.7 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'painting-stroke-07-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="CL" author="CN" status="accepted"\n    version="$Revision: 1.7 $" testname="$RCSfile: painting-stroke-07-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/painting.html#StrokeProperties">\n        <p>\n          Test effect of different stroke-miterlimits. For this particular combination of\n          stroke width and angle, the cut off value of stroke-miterlimit is 18.028.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The first and second subtests should not truncate the stroke, and all the rest must truncate it.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: painting-stroke-07-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <g transform="scale(1.2) translate(60, 30)">\n      <!-- test different miterlimits -->\n      <path stroke="black" stroke-width="10" stroke-linejoin="miter" stroke-miterlimit="20" fill="none" d="M  20 20   L  200 30  L  20 40"/>\n      <path stroke="black" stroke-width="10" stroke-linejoin="miter" stroke-miterlimit="18.1" fill="none" d="M  20 50   L  200 60  L  20 70"/>\n      <path stroke="black" stroke-width="10" stroke-linejoin="miter" stroke-miterlimit="17.9" fill="none" d="M  20 80   L  200 90  L  20 100"/>\n      <path stroke="black" stroke-width="10" stroke-linejoin="miter" stroke-miterlimit="17" fill="none" d="M  20 110   L  200 120  L  20 130"/>\n      <path stroke="black" stroke-width="10" stroke-linejoin="miter" stroke-miterlimit="4" fill="none" d="M  20 140   L  200 150  L  20 160"/>\n      <path stroke="black" stroke-width="10" stroke-linejoin="miter" stroke-miterlimit="1" fill="none" d="M  20 170   L  200 180  L  20 190"/>\n\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.7 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'painting-stroke-08-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="CL" author="CN" status="accepted"\n    version="$Revision: 1.6 $" testname="$RCSfile: painting-stroke-08-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/painting.html#StrokeProperties">\n        <p>\n          Test effects of stroke-opacity range. Values\n          outside the range 0-1.0 must be clamped.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      Run the test. No interaction required.\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        There must be no blue bars visible beside the three pink dots.\n        Four semitransparent blue bars, increasingly more opaque,\n        must line up with the yellow dots. Three fully opaque\n        blue bars must line up with the green dots.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: painting-stroke-08-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <g transform="translate(50, 0) scale(1.7)">\n      <circle r="5" fill="#f66" cx="200" cy="20"/>\n      <circle r="5" fill="#f66" cx="200" cy="40"/>\n      <circle r="5" fill="#f66" cx="200" cy="60"/>\n      <circle r="5" fill="#f66" cx="200" cy="80"/>\n      <circle r="5" fill="#ff0" cx="200" cy="80"/>\n      <circle r="5" fill="#ff0" cx="200" cy="100"/>\n      <circle r="5" fill="#ff0" cx="200" cy="120"/>\n      <circle r="5" fill="#ff0" cx="200" cy="140"/>\n      <circle r="5" fill="#6f3" cx="200" cy="160"/>\n      <circle r="5" fill="#6f3" cx="200" cy="180"/>\n      <circle r="5" fill="#6f3" cx="200" cy="200"/>\n      <!-- Test range and values outside range (should be clamped to valid range) -->\n      <path stroke="blue" stroke-width="10" fill="none" stroke-opacity="-1.0" d="   M  20 20   L  200 20"/>\n      <path stroke="blue" stroke-width="10" fill="none" stroke-opacity="-0.1" d="   M  20 40   L  200 40"/>\n      <path stroke="blue" stroke-width="10" fill="none" stroke-opacity="0.0" d="   M  20 60   L  200 60"/>\n      <path stroke="blue" stroke-width="10" fill="none" stroke-opacity="0.2" d="   M  20 80   L  200 80"/>\n      <path stroke="blue" stroke-width="10" fill="none" stroke-opacity="0.4" d="   M  20 100   L  200 100"/>\n      <path stroke="blue" stroke-width="10" fill="none" stroke-opacity="0.6" d="   M  20 120   L  200 120"/>\n      <path stroke="blue" stroke-width="10" fill="none" stroke-opacity="0.8" d="   M  20 140   L  200 140"/>\n      <path stroke="blue" stroke-width="10" fill="none" stroke-opacity="1.0" d="   M  20 160   L  200 160"/>\n      <path stroke="blue" stroke-width="10" fill="none" stroke-opacity="1.1" d="   M  20 180   L  200 180"/>\n      <path stroke="blue" stroke-width="10" fill="none" stroke-opacity="2.0" d="   M  20 200  L  200 200"/>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.6 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved \n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'painting-stroke-09-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.3" reviewer="CL" author="CM" status="accepted"\n    version="$Revision: 1.7 $" testname="$RCSfile: painting-stroke-09-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/painting.html#StrokeDasharrayProperty">\n      <p>\n        This tests that the "stroke-dasharray" property accepts values\n        that are separated by white space.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The test is passed if it matches the reference rendering\n        by showing a thick stroke with alternating long and short\n        stroke dashes.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: painting-stroke-09-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <!-- ====================================================================== -->\n    <!-- Test stroke-dasharray and stroke-dashoffset                            -->\n    <!-- ====================================================================== -->\n    <path fill="none" stroke="black" stroke-width="25" stroke-dasharray="25  5 , 5 5" d="M50,120 h385"/>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.7 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved --><!--\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'painting-stroke-10-t.svg', svg: '<svg id="svg-root" width="100%" height="100%"\n  viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg"\n  xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="CL" author="CM" status="accepted"\n    version="$Revision: 1.5 $" testname="$RCSfile: painting-stroke-10-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/painting.html#StrokeProperties">\n      <p>\n        This tests that stroking of zero length subpaths will result in\n        some rendering if the \'stroke-linecap\' property is set to\n        \'square\' or \'round\', but not if it is set to \'butt\'.\n      </p>\n      <p>\n        Simply load the test.  Two rows of shapes should be presented,\n        with a text label describing the row.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Simply load the test.  Two rows of shapes should be presented,\n        with a text label describing the row.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: painting-stroke-10-t.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n\n    <text x=\'10\' y=\'40\'>Test stroking of zero length subpaths</text>\n\n    <g stroke-width=\'50\' stroke=\'blue\' fill=\'none\'>\n      <path d=\'M190,170 L190,170\' stroke-linecap=\'round\'/>\n      <path d=\'M290,170 L290,170\' stroke-linecap=\'square\'/>\n      <path d=\'M390,170 L390,170\' stroke-linecap=\'butt\' stroke=\'red\'/>\n\n      <path d=\'M190,240 c0,0 0,0 0,0\' stroke-linecap=\'round\'/>\n      <path d=\'M290,240 c0,0 0,0 0,0\' stroke-linecap=\'square\'/>\n      <path d=\'M390,240 c0,0 0,0 0,0\' stroke-linecap=\'butt\' stroke=\'red\'/>\n    </g>\n\n    <g font-size=\'12\'>\n      <text x=\'10\' y=\'175\'>Using an \'L\' command:</text>\n      <text x=\'10\' y=\'245\'>Using a \'c\' command:</text>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.5 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--\n<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'paths-data-01-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Lofton Henderson" status="accepted"\n    version="$Revision: 1.7 $" testname="$RCSfile: paths-data-01-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/paths.html#PathData">\n        <p>\n          Test that the viewer has the basic capability to handle the \'path\'\n          element and its data (d) attribute in combination with the cubic\n          Bezier curveto commands, C, c, S, s (plus Mm and Zz).\n        </p>\n        <p>\n          There are 8 subtests, each composed from the cubic Bezier path commands per\n          the label by the subtest.  On-curve control points (i.e., the curve position)\n          are marked by small blue squares.  Subtests are filled, or stroked, or\n          both, using simple style properties and colors.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n      Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The rendered picture should match the reference image exactly\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: paths-data-01-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <!-- ====================================================================== -->\n    <!-- First Curve "X" that has subpath utilizing M, C, S, m, c, & s ======== -->\n    <!-- ====================================================================== -->\n    <text font-size="12" x="100" y="14">Cubic bezier curves drawn with commands:</text>\n    <path id="X_curve_MCSmcs" fill="#00FF00" stroke="#00C000" d="   M  210 130      C  145 130     110  80     110  80       S  75  25      10  25          m    0 105      c   65   0      100 -50     100 -50       s   35 -55     100 -55   "/>\n    <!-- ====================================================================== -->\n    <!-- Markers for path control points  ===================================== -->\n    <!-- ====================================================================== -->\n    <rect x="208" y="128" width="4" height="4" fill="#4A83FF" stroke="none"/>\n    <rect x="108" y="78" width="4" height="4" fill="#4A83FF" stroke="none"/>\n    <rect x="8" y="23" width="4" height="4" fill="#4A83FF" stroke="none"/>\n    <rect x="8" y="128" width="4" height="4" fill="#4A83FF" stroke="none"/>\n    <rect x="108" y="78" width="4" height="4" fill="#4A83FF" stroke="none"/>\n    <rect x="208" y="23" width="4" height="4" fill="#4A83FF" stroke="none"/>\n    <text font-size="12" x="5" y="82">M, C, S, m, c, s</text>\n    <!-- ====================================================================== -->\n    <!-- Infinity using M, c, c, c, C & z ===================================== -->\n    <!-- ====================================================================== -->\n    <path id="Infinity_McccCz" fill="none" stroke="#000000" d="   M 240  90      c 0  30    7  50    50  0       c 43  -50    50  -30    50  0       c 0  83    -68  -34    -90  -30       C 240  60    240  90    240  90   z  "/>\n    <!-- ====================================================================== -->\n    <!-- Markers for path control points ====================================== -->\n    <!-- ====================================================================== -->\n    <rect x="238" y="88" width="4" height="4" fill="#4A83FF" stroke="none"/>\n    <rect x="288" y="88" width="4" height="4" fill="#4A83FF" stroke="none"/>\n    <rect x="338" y="88" width="4" height="4" fill="#4A83FF" stroke="none"/>\n    <rect x="248" y="58" width="4" height="4" fill="#4A83FF" stroke="none"/>\n    <text font-size="12" x="253" y="50">M, c, c, c, C, z</text>\n    <!-- ====================================================================== -->\n    <!-- Horizontal line utilizing M, C & Z =================================== -->\n    <!-- ====================================================================== -->\n    <path id="Line_MCZ" fill="none" stroke="#000000" d="M80 170   C100 170 160 170 180 170Z"/>\n    <!-- ====================================================================== -->\n    <!-- Markers for path control points ====================================== -->\n    <!-- ====================================================================== -->\n    <rect x="78" y="168" width="4" height="4" fill="#4A83FF" stroke="none"/>\n    <rect x="178" y="168" width="4" height="4" fill="#4A83FF" stroke="none"/>\n    <text font-size="12" x="110" y="190">M, C, Z</text>\n    <!-- ====================================================================== -->\n    <!-- Inverted V using M, C, c & Z ========================================= -->\n    <!-- ====================================================================== -->\n    <path id="Inv_V_MCcZ" fill="#00C000" stroke="none" d="M5 260 C40 260 60 175  55 160 c  -5  15 15 100 50 100Z"/>\n    <!-- ====================================================================== -->\n    <!-- Markers for path control points ====================================== -->\n    <!-- ====================================================================== -->\n    <rect x="3" y="258" width="4" height="4" fill="#4A83FF" stroke="none"/>\n    <rect x="53" y="158" width="4" height="4" fill="#4A83FF" stroke="none"/>\n    <rect x="103" y="258" width="4" height="4" fill="#4A83FF" stroke="none"/>\n    <text font-size="12" x="85" y="220">M, C, c, Z</text>\n    <!-- ====================================================================== -->\n    <!-- Remembrance Ribbon using m, c & s ==================================== -->\n    <!-- ====================================================================== -->\n    <path id="Rem_Rib_mcs" fill="none" stroke="#000000" d="m 200 260      c  50 -40     50 -100     25 -100       s -25  60     25  100  "/>\n    <!-- ====================================================================== -->\n    <!-- Markers for path control points ====================================== -->\n    <!-- ====================================================================== -->\n    <rect x="198" y="258" width="4" height="4" fill="#4A83FF" stroke="none"/>\n    <rect x="223" y="158" width="4" height="4" fill="#4A83FF" stroke="none"/>\n    <rect x="248" y="258" width="4" height="4" fill="#4A83FF" stroke="none"/>\n    <text font-size="12" x="165" y="210">m, c, s</text>\n    <!-- ====================================================================== -->\n    <!-- 90 degree arc using M & C ============================================ -->\n    <!-- ====================================================================== -->\n    <path id="Arc_MC" fill="#0000FF" stroke="#000000" d="   M 360 100   C 420 90 460 140 450 190"/>\n    <!-- ====================================================================== -->\n    <!-- Markers for path control points ====================================== -->\n    <!-- ====================================================================== -->\n    <rect x="358" y="98" width="4" height="4" fill="#4A83FF" stroke="none"/>\n    <rect x="448" y="188" width="4" height="4" fill="#4A83FF" stroke="none"/>\n    <text font-size="12" x="360" y="150">M, C</text>\n    <!-- ====================================================================== -->\n    <!-- Circle using M, c, s, s, s & z ======================================= -->\n    <!-- ====================================================================== -->\n    <path id="Circle_Mcssz" fill="#FFFF00" stroke="#000000" d="M360 210      c   0  20    -16  36    -36  36       s -36 -16    -36 -36       s  16 -36     36 -36    s  36  16     36  36   z  "/>\n    <!-- ====================================================================== -->\n    <!-- Markers for path control points ====================================== -->\n    <!-- ====================================================================== -->\n    <rect x="358" y="208" width="4" height="4" fill="#4A83FF" stroke="none"/>\n    <rect x="322" y="244" width="4" height="4" fill="#4A83FF" stroke="none"/>\n    <rect x="286" y="208" width="4" height="4" fill="#4A83FF" stroke="none"/>\n    <rect x="322" y="172" width="4" height="4" fill="#4A83FF" stroke="none"/>\n    <text font-size="12" x="290" y="265">M, c, s, s, s, z</text>\n    <!-- ====================================================================== -->\n    <!-- Inverted horseshoe using m, c & z ==================================== -->\n    <!-- ====================================================================== -->\n    <path id="Horseshoe_Mcs" fill="#F0F0F0" stroke="#00AA00" d="m 360  325  c -40  -60     95 -100     80    0      z  "/>\n    <!-- ====================================================================== -->\n    <!-- Markers for path control points ====================================== -->\n    <!-- ====================================================================== -->\n    <rect x="358" y="323" width="4" height="4" fill="#4A83FF" stroke="none"/>\n    <rect x="438" y="323" width="4" height="4" fill="#4A83FF" stroke="none"/>\n    <text font-size="12" x="380" y="340">m, c, z</text>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.7 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'paths-data-02-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Lofton Henderson" status="accepted"\n    version="$Revision: 1.7 $" testname="$RCSfile: paths-data-02-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/paths.html#PathData">\n        <p>\n          Test that the viewer has the basic capability to handle the \'path\'\n          element and its data (d) attribute in combination with the quadratic\n          Bezier curveto commands, Q, q, T, t (plus Mm and Zz).\n        </p>\n        <p>\n          There are 7 subtests, each composed from the quadric Bezier path commands per\n          the label by the subtest.  On-curve control points (i.e., the curve position)\n          are marked by small colored squares.  Subtests are filled, or stroked, or\n          both, using simple style properties and colors.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">      \n      <p>\n      Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The rendered picture should match the reference image exactly\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: paths-data-02-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <text font-size="12" x="120" y="14">Quadric bezier curves drawn with commands:</text>\n    <!-- ====================================================================== -->\n    <!-- Quad Bezier with sub-path using M, Q, M, q, & z ====================== -->\n    <!-- ====================================================================== -->\n    <path id="Bez_MQMqz" fill="none" stroke="#0000FF" stroke-width="3" d="M  15   20      Q  30  120    130   30      M 180   80      q  -75 -100    -163  -60z"/>\n    <text font-size="12" x="80" y="86">M, Q, M, q, z</text>\n    <rect x="13" y="18" width="4" height="4" fill="#00C000" stroke="none"/>\n    <rect x="128" y="28" width="4" height="4" fill="#00C000" stroke="none"/>\n    <rect x="178" y="78" width="4" height="4" fill="#00C000" stroke="none"/>\n    <rect x="15" y="18" width="4" height="4" fill="#00C000" stroke="none"/>\n    <!-- ====================================================================== -->\n    <!-- Quad Bezier with sub-path using m, q, z, m, q, & z =================== -->\n    <!-- ====================================================================== -->\n    <path id="Bez_fill_MQzmqz" fill="#FFFF00" stroke="#0000CF" d="M372 130Q272 50 422 10zm70 0q50-150-80-90z"/>\n    <text font-size="12" x="352" y="150">m, q, z, m, q, z</text>\n    <rect x="370" y="128" width="4" height="4" fill="#0000FF" stroke="none"/>\n    <rect x="420" y="8" width="4" height="4" fill="#0000FF" stroke="none"/>\n    <rect x="440" y="128" width="4" height="4" fill="#0000FF" stroke="none"/>\n    <rect x="360" y="38" width="4" height="4" fill="#0000FF" stroke="none"/>\n    <!-- ====================================================================== -->\n    <!-- Simple Bezier using M, Q, & Z ======================================== -->\n    <!-- ====================================================================== -->\n    <path id="Bez_stroke_MQz" fill="none" stroke="#00FFFF" d="M224 103Q234 -12 304 33Z"/>\n    <text font-size="12" x="192" y="36">M, Q, Z</text>\n    <rect x="222" y="101" width="4" height="4" fill="#0000FF" stroke="none"/>\n    <rect x="302" y="31" width="4" height="4" fill="#0000FF" stroke="none"/>\n    <!-- ====================================================================== -->\n    <!-- Tri Bezier using M, Q, T, Q, & z ===================================== -->\n    <!-- ====================================================================== -->\n    <path id="Tri_MQTQz" fill="#00C000" stroke="#000000" d="M208 168Q258 268 308 168T258 118Q128 88 208 168z"/>\n    <text font-size="12" x="308" y="188">M, Q, T, Q, z</text>\n    <rect x="206" y="166" width="4" height="4" fill="#0000FF" stroke="none"/>\n    <rect x="306" y="166" width="4" height="4" fill="#0000FF" stroke="none"/>\n    <rect x="256" y="116" width="4" height="4" fill="#0000FF" stroke="none"/>\n    <rect x="206" y="206" width="4" height="4" fill="#0000FF" stroke="none"/>\n    <!-- ====================================================================== -->\n    <!-- Double Bezier using M, Q, Q, & z ===================================== -->\n    <!-- ====================================================================== -->\n    <path id="Inv_V_MCcZ" fill="#00CF00" stroke="none" d="   M   60 100      Q  -40 150      60 200      Q  160 150      60 100       z  "/>\n    <text font-size="12" x="80" y="200">M, Q, Q, z</text>\n    <rect x="58" y="98" width="4" height="4" fill="#0000FF" stroke="none"/>\n    <rect x="58" y="198" width="4" height="4" fill="#0000FF" stroke="none"/>\n    <rect x="58" y="98" width="4" height="4" fill="#0000FF" stroke="none"/>\n    <!-- ====================================================================== -->\n    <!-- Sin Wave using M, q, t, t, t, t, & z ================================ -->\n    <!-- ====================================================================== -->\n    <path id="Sin_Mqttttz" fill="none" stroke="#40DD20" d="M240 296q25-100 47 0t47 0t47 0t47 0t47 0z"/>\n    <text font-size="12" x="380" y="236">M, q, t, t, t, t, z</text>\n    <rect x="238" y="294" width="4" height="4" fill="#0000FF" stroke="none"/>\n    <rect x="285" y="294" width="4" height="4" fill="#0000FF" stroke="none"/>\n    <rect x="332" y="294" width="4" height="4" fill="#0000FF" stroke="none"/>\n    <rect x="379" y="294" width="4" height="4" fill="#0000FF" stroke="none"/>\n    <rect x="426" y="294" width="4" height="4" fill="#0000FF" stroke="none"/>\n    <rect x="473" y="294" width="4" height="4" fill="#0000FF" stroke="none"/>\n    <!-- ====================================================================== -->\n    <!-- Double Spade using M, q, Q, q, Q, & z ================================ -->\n    <!-- ====================================================================== -->\n    <path id="Dbl_spd_MCcZ" fill="#0000C0" stroke="#00CF00" stroke-width="2" d="M172 193q-100 50 0 50Q72 243 172 293q100 -50 0 -50Q272 243 172 193z"/>\n    <text font-size="12" x="48" y="280">M, q, Q, q, Q, z</text>\n    <rect x="170" y="191" width="4" height="4" fill="#40DD20" stroke="none"/>\n    <rect x="170" y="241" width="4" height="4" fill="#40DD20" stroke="none"/>\n    <rect x="170" y="291" width="4" height="4" fill="#40DD20" stroke="none"/>\n    <rect x="170" y="241" width="4" height="4" fill="#40DD20" stroke="none"/>\n    <rect x="170" y="191" width="4" height="4" fill="#40DD20" stroke="none"/>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.7 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'paths-data-03-f.svg', svg: '<svg version="1.1" baseProfile="full" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Lofton Henderson" status="accepted"\n    version="$Revision: 1.7 $" testname="$RCSfile: paths-data-03-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/paths.html#PathData">\n        <p>\n          Test that the viewer has the basic capability to handle the \'path\'\n          element and its data (d) attribute in combination with the elliptical\n          arc curveto commands, A, a (plus Mm and Zz).\n        </p>\n        <p>\n          There are 6 subtests, each composed from the elliptical arc path commands per\n          the label by the subtest.  The curve positions\n          are marked by small colored squares.  Subtests are filled, or stroked, or\n          both, using simple style properties and colors.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">      \n      <p>\n      Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The rendered picture should match the reference image exactly\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: paths-data-03-f.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <text font-size="12" x="120" y="14">Elliptical arc curves drawn with commands:</text>\n    <!-- ====================================================================== -->\n    <!-- Simple circle using MAZ  ============================ -->\n    <!-- ====================================================================== -->\n    <path id="Arc_MAZ" fill="none" stroke="#03DD20" stroke-width="10" d="   M  25   70      A  40   40      0         1      0     25   69   Z    "/>\n    <text font-size="12" x="48" y="70">M, A, Z</text>\n    <rect x="23" y="68" width="4" height="4" fill="#00C000" stroke="none"/>\n    <rect x="23" y="67" width="4" height="4" fill="#00C000" stroke="none"/>\n    <!-- ====================================================================== -->\n    <!-- filled arc using m, a, & z =================== -->\n    <!-- ====================================================================== -->\n    <path id="Arc_fill_maz" fill="#00FF00" stroke="#0000FF" d="   m  150   100      a  50    40       0          1       0      25   -70   z  "/>\n    <text font-size="12" x="124" y="45">m, a, z</text>\n    <rect x="148" y="98" width="4" height="4" fill="#CF0000" stroke="none"/>\n    <rect x="173" y="28" width="4" height="4" fill="#CF0000" stroke="none"/>\n    <!-- ====================================================================== -->\n    <!-- Unterminated arc using M & a ======================================== -->\n    <!-- ====================================================================== -->\n    <path id="Arc_Ma" fill="none" stroke="#000000" d="   M  350    245      a   40    40       0          1       0      80    60       "/>\n    <text font-size="12" x="390" y="300">M, a</text>\n    <rect x="348" y="243" width="4" height="4" fill="#0000FF" stroke="none"/>\n    <rect x="428" y="303" width="4" height="4" fill="#0000FF" stroke="none"/>\n    <!-- ====================================================================== -->\n    <!-- Triple Arc using M, A, a, a, & z ===================================== -->\n    <!-- ====================================================================== -->\n    <path id="Tri_MAaaz" fill="#0067C0" stroke="none" fill-rule="evenodd" d="   M   270   30      A   50    50       0          1       0     345   30         a   50    50       0          1       0      50    0         a   50    50       0          1       0      25    0    z  "/>\n    <text font-size="12" x="280" y="135">M, A, a, a, z</text>\n    <rect x="268" y="28" width="4" height="4" fill="#0000FF" stroke="none"/>\n    <rect x="343" y="28" width="4" height="4" fill="#0000FF" stroke="none"/>\n    <rect x="393" y="28" width="4" height="4" fill="#0000FF" stroke="none"/>\n    <rect x="418" y="28" width="4" height="4" fill="#0000FF" stroke="none"/>\n    <!-- ====================================================================== -->\n    <!-- Tripple arc using M, a, Z, m, A, Z, m, a & z ===================================== -->\n    <!-- ====================================================================== -->\n    <path id="Arc_MaZmAzmaz" fill="#609040" stroke="#000000" stroke-width="3" d="   M  30   150      a   40    40       0          0       1      65    50          Z                    m   30       30                         A   20       20              0              0              0             125   230        Z             m   40       24                         a   20       20              0              0              1              65    50        z "/>\n    <text font-size="12" x="25" y="270">M, a, Z, m, A, Z, m, a, z</text>\n    <rect x="28" y="148" width="4" height="4" fill="#0000FF" stroke="none"/>\n    <rect x="93" y="198" width="4" height="4" fill="#0000FF" stroke="none"/>\n    <rect x="58" y="178" width="4" height="4" fill="#0000FF" stroke="none"/>\n    <rect x="123" y="228" width="4" height="4" fill="#0000FF" stroke="none"/>\n    <rect x="98" y="202" width="4" height="4" fill="#0000FF" stroke="none"/>\n    <rect x="163" y="252" width="4" height="4" fill="#0000FF" stroke="none"/>\n    <!-- ====================================================================== -->\n    <!-- Sin Wave using M, q, t, t, t, t, & z ================================ -->\n    <!-- ====================================================================== -->\n    <path id="Sin_MAAAAA" fill="none" stroke="#40DD20" d="   M   215    190      A   40    200      10          0       0      265    190    A   40    200      20          0       1     315    190        A   40    200      30          0       0     365    190    A   40    200      40          0       1     415    190        A   40    200      50          0       0     465    190                     "/>\n    <text font-size="12" x="215" y="246">M, A, A, A, A</text>\n    <rect x="213" y="188" width="4" height="4" fill="#0000FF" stroke="none"/>\n    <rect x="263" y="188" width="4" height="4" fill="#0000FF" stroke="none"/>\n    <rect x="313" y="188" width="4" height="4" fill="#0000FF" stroke="none"/>\n    <rect x="363" y="188" width="4" height="4" fill="#0000FF" stroke="none"/>\n    <rect x="413" y="188" width="4" height="4" fill="#0000FF" stroke="none"/>\n    <rect x="463" y="188" width="4" height="4" fill="#0000FF" stroke="none"/>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.7 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'paths-data-04-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Lofton Henderson" status="accepted"\n    version="$Revision: 1.7 $" testname="$RCSfile: paths-data-04-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/paths.html#PathData">\n        <p>\n          Verify the basic capability to handle the \'path\' element, and its data attribute (d)\n          in combination with the straight-line path commands.\n          Two pairs of concentric equilateral triangles are drawn using respectively\n          M,L,Z and m,l,z.  The shapes are identical, with one stroked and\n          one filled.  The fill-mode default of "even-odd" means that\n          the inner triangle is hollow.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">      \n      <p>\n      Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The rendered picture should match the reference image exactly\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: paths-data-04-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <!-- ====================================================================== -->\n    <!-- First Group of Triangles using M, L & Z commands ===================== -->\n    <!-- ====================================================================== -->\n    <g transform="scale(1.8)">\n      <!--		<text font-size="12"  x="160" y="14">Lines drawn with commands:</text> -->\n      <text font-size="12" x="88" y="30">M, L, L, L, Z,</text>\n      <text font-size="12" x="98" y="46">subpath</text>\n      <text font-size="12" x="88" y="61">M, L, L, L, Z</text>\n      <path id="Triangle_stroke_MLZ" fill="none" stroke="#000000" d="   M   62.00000   56.00000    L  113.96152  146.00000   L   10.03848  146.00000    L   62.00000   56.00000   Z    M   62.00000  71.00000   L  100.97114  138.50000   L   23.02886  138.50000   L   62.00000  71.00000   Z  "/>\n      <rect x="60.00000" y="54.00000" width="4" height="4" fill="#00C000" stroke="none"/>\n      <rect x="111.96152" y="144.00000" width="4" height="4" fill="#00C000" stroke="none"/>\n      <rect x="8.03848" y="144.00000" width="4" height="4" fill="#00C000" stroke="none"/>\n      <rect x="60.00000" y="69.00000" width="4" height="4" fill="#00C000" stroke="none"/>\n      <rect x="98.97114" y="136.50000" width="4" height="4" fill="#00C000" stroke="none"/>\n      <rect x="21.02886" y="136.50000" width="4" height="4" fill="#00C000" stroke="none"/>\n      <text font-size="12" x="42" y="162">stroked</text>\n      <path id="Triangle_fill_MLZ" fill="#7FA" stroke="none" fill-rule="evenodd" d="   M  177.00000   56.00000    L  228.96152  146.00000   L  125.03848  146.00000    L  177.00000   56.00000   Z    M  177.00000  71.00000   L  215.97114  138.50000   L  138.02886  138.50000   L  177.00000  71.00000   Z  "/>\n      <rect x="175.00000" y="54.00000" width="4" height="4" fill="#00C000" stroke="none"/>\n      <rect x="226.96152" y="144.00000" width="4" height="4" fill="#00C000" stroke="none"/>\n      <rect x="123.03848" y="144.00000" width="4" height="4" fill="#00C000" stroke="none"/>\n      <rect x="175.00000" y="69.00000" width="4" height="4" fill="#00C000" stroke="none"/>\n      <rect x="213.97114" y="136.50000" width="4" height="4" fill="#00C000" stroke="none"/>\n      <rect x="136.02886" y="136.50000" width="4" height="4" fill="#00C000" stroke="none"/>\n      <text font-size="12" x="162" y="162">filled</text>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.7 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'paths-data-05-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Lofton Henderson" status="accepted"\n    version="$Revision: 1.7 $" testname="$RCSfile: paths-data-05-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/paths.html#PathData">\n        <p>\n          Verify the basic capability to handle the \'path\' element, and its data attribute (d)\n          in combination with the straight-line path commands.\n          Two pairs of concentric equilateral triangles are drawn using respectively\n          M,L,Z and m,l,z. The shapes in each pair are identical, with one stroked and\n          one filled.   The fill-mode default of "even-odd" means that\n          the inner triangle is hollow.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">      \n      <p>\n      Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The rendered picture should match the reference image exactly\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: paths-data-05-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <!-- ====================================================================== -->\n    <!-- Second Group of Triangles using m, l & z commands===================== -->\n    <!-- ====================================================================== -->\n    <g transform="scale(1.8) translate(0, -150)">\n      <text font-size="12" x="96" y="180">m, l, l, l, z,</text>\n      <text font-size="12" x="100" y="194">subpath</text>\n      <text font-size="12" x="97" y="208">m, l, l, l, z</text>\n      <path id="Triangle_stroke_mlz" fill="none" stroke="#000000" d="   m   62.00000  190.00000    l   51.96152   90.00000   l -103.92304    0.00000    l   51.96152  -90.00000   z    m    0.00000   15.00000   l   38.97114   67.50000   l  -77.91228    0.00000   l   38.97114  -67.50000   z  "/>\n      <rect x="60.00000" y="188.00000" width="4" height="4" fill="#40DD20" stroke="none"/>\n      <rect x="111.96152" y="278.00000" width="4" height="4" fill="#40DD20" stroke="none"/>\n      <rect x="8.03848" y="278.00000" width="4" height="4" fill="#40DD20" stroke="none"/>\n      <rect x="60.00000" y="203.00000" width="4" height="4" fill="#40DD20" stroke="none"/>\n      <rect x="98.97114" y="270.50000" width="4" height="4" fill="#40DD20" stroke="none"/>\n      <rect x="21.02886" y="270.50000" width="4" height="4" fill="#40DD20" stroke="none"/>\n      <path id="Triangle_fill_mlz" fill="#006000" stroke="none" fill-rule="evenodd" d="   m  177.00000  190.00000    l   51.96152   90.00000   l -103.92304    0.00000    l   51.96152  -90.00000   z    m    0.00000   15.00000   l   38.97114   67.50000   l  -77.91228    0.00000   l   38.97114  -67.50000   z  "/>\n      <rect x="175.00000" y="188.00000" width="4" height="4" fill="#40DD20" stroke="none"/>\n      <rect x="226.96152" y="278.00000" width="4" height="4" fill="#40DD20" stroke="none"/>\n      <rect x="123.03848" y="278.00000" width="4" height="4" fill="#40DD20" stroke="none"/>\n      <rect x="175.00000" y="203.00000" width="4" height="4" fill="#40DD20" stroke="none"/>\n      <rect x="213.97114" y="270.50000" width="4" height="4" fill="#40DD20" stroke="none"/>\n      <rect x="136.02886" y="270.50000" width="4" height="4" fill="#40DD20" stroke="none"/>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.7 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'paths-data-06-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Lofton Henderson" status="accepted"\n    version="$Revision: 1.7 $" testname="$RCSfile: paths-data-06-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/paths.html#PathData">\n        <p>\n          Verify the basic capability to handle the \'path\' element, and its data attribute (d)\n          in combination with the straight-line path commands.\n          Two pairs of staircase figures are drawn using\n          respectively M,H,V,Z and m,h,v,z. The shapes in each pair are identical, with one stroked and\n          one filled.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">      \n      <p>\n      Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The rendered picture should match the reference image exactly\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: paths-data-06-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <g transform="scale(1.8) translate(-200, 0)">\n      <!-- ====================================================================== -->\n      <!-- First Group of Stairs using M, H, V & Z commands====================== -->\n      <!-- ====================================================================== -->\n      <text font-size="12" x="288" y="30">M, H, V, H,</text>\n      <text font-size="12" x="288" y="46">V. H, V, H,</text>\n      <text font-size="12" x="304" y="62">V, Z</text>\n      <path id="Stairs_stroke_MHVZ" fill="none" stroke="#000000" d="   M  240.00000  56.00000    H  270.00000   V  86.00000    H  300.00000   V  116.00000    H  330.00000   V  146.00000    H  240.00000   V  56.00000    Z  "/>\n      <rect x="238.00000" y="54.00000" width="4" height="4" fill="#FFFF00" stroke="none"/>\n      <rect x="268.00000" y="54.00000" width="4" height="4" fill="#FFFF00" stroke="none"/>\n      <rect x="268.00000" y="84.00000" width="4" height="4" fill="#FFFF00" stroke="none"/>\n      <rect x="298.00000" y="84.00000" width="4" height="4" fill="#FFFF00" stroke="none"/>\n      <rect x="298.00000" y="114.00000" width="4" height="4" fill="#FFFF00" stroke="none"/>\n      <rect x="328.00000" y="114.00000" width="4" height="4" fill="#FFFF00" stroke="none"/>\n      <rect x="328.00000" y="144.00000" width="4" height="4" fill="#FFFF00" stroke="none"/>\n      <rect x="238.00000" y="144.00000" width="4" height="4" fill="#FFFF00" stroke="none"/>\n      <path id="Stairs_fill_MHVZ" fill="#0000FF" stroke="none" d="   M  350.00000  56.00000   H  380.00000   V  86.00000    H  410.00000   V  116.00000    H  440.00000   V  146.00000    H  350.00000   V  56.00000    Z  "/>\n      <rect x="348.00000" y="54.00000" width="4" height="4" fill="#FFFF00" stroke="none"/>\n      <rect x="378.00000" y="54.00000" width="4" height="4" fill="#FFFF00" stroke="none"/>\n      <rect x="378.00000" y="84.00000" width="4" height="4" fill="#FFFF00" stroke="none"/>\n      <rect x="408.00000" y="84.00000" width="4" height="4" fill="#FFFF00" stroke="none"/>\n      <rect x="408.00000" y="114.00000" width="4" height="4" fill="#FFFF00" stroke="none"/>\n      <rect x="438.00000" y="114.00000" width="4" height="4" fill="#FFFF00" stroke="none"/>\n      <rect x="438.00000" y="144.00000" width="4" height="4" fill="#FFFF00" stroke="none"/>\n      <rect x="348.00000" y="144.00000" width="4" height="4" fill="#FFFF00" stroke="none"/>\n      <!-- ====================================================================== -->\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.7 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'paths-data-07-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Lofton Henderson" status="accepted"\n    version="$Revision: 1.7 $" testname="$RCSfile: paths-data-07-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/paths.html#PathData">\n        <p>\n          Verify the basic capability to handle the \'path\' element, and its data attribute (d)\n          in combination with the straight-line path commands.\n          Two pairs of staircase figures are drawn using\n          respectively M,H,V,Z and m,h,v,z. The shapes in each pair are identical, with one stroked and\n          one filled.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n      Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The rendered picture should match the reference image exactly\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: paths-data-07-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <g transform="scale(1.8) translate(-200, -150)">\n      <!-- ====================================================================== -->\n      <!-- Second Group of Stairs using m, h, v & z commands====================== -->\n      <!-- ====================================================================== -->\n      <text font-size="12" x="288" y="180">m, h, v, h</text>\n      <text font-size="12" x="288" y="194">v, h, v, h</text>\n      <text font-size="12" x="304" y="208">v, z</text>\n      <path id="Stairs_stroke_mhvz" fill="none" stroke="#000000" d="   m  240.00000  190.00000    h   30.00000   v   30.00000    h   30.00000   v   30.00000    h   30.00000   v   30.00000    h  -90.00000   v  -90.00000    z  "/>\n      <rect x="238.00000" y="188.00000" width="4" height="4" fill="#0000FF" stroke="none"/>\n      <rect x="268.00000" y="188.00000" width="4" height="4" fill="#0000FF" stroke="none"/>\n      <rect x="268.00000" y="218.00000" width="4" height="4" fill="#0000FF" stroke="none"/>\n      <rect x="298.00000" y="218.00000" width="4" height="4" fill="#0000FF" stroke="none"/>\n      <rect x="298.00000" y="248.00000" width="4" height="4" fill="#0000FF" stroke="none"/>\n      <rect x="328.00000" y="248.00000" width="4" height="4" fill="#0000FF" stroke="none"/>\n      <rect x="328.00000" y="278.00000" width="4" height="4" fill="#0000FF" stroke="none"/>\n      <rect x="238.00000" y="278.00000" width="4" height="4" fill="#0000FF" stroke="none"/>\n      <path id="Stairs_fill_mhvz" fill="#FFFF00" stroke="none" d="   m  350.00000  190.00000    h   30.00000   v   30.00000    h   30.00000   v   30.00000    h   30.00000   v   30.00000    h  -90.00000   v  -90.00000    z  "/>\n      <rect x="348.00000" y="188.00000" width="4" height="4" fill="#0000FF" stroke="none"/>\n      <rect x="378.00000" y="188.00000" width="4" height="4" fill="#0000FF" stroke="none"/>\n      <rect x="378.00000" y="218.00000" width="4" height="4" fill="#0000FF" stroke="none"/>\n      <rect x="408.00000" y="218.00000" width="4" height="4" fill="#0000FF" stroke="none"/>\n      <rect x="408.00000" y="248.00000" width="4" height="4" fill="#0000FF" stroke="none"/>\n      <rect x="438.00000" y="248.00000" width="4" height="4" fill="#0000FF" stroke="none"/>\n      <rect x="438.00000" y="278.00000" width="4" height="4" fill="#0000FF" stroke="none"/>\n      <rect x="348.00000" y="278.00000" width="4" height="4" fill="#0000FF" stroke="none"/>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.7 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'paths-data-08-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="CN" author="SH" status="accepted"\n    version="$Revision: 1.6 $" testname="$RCSfile: paths-data-08-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/paths.html#PathData">\n        <p>\n          Verify the basic capability to handle the \'path\' element, and its data attribute (d)\n          in combination with the straight-line path commands.\n          Two pairs of concentric equilateral triangles are drawn using\n          M and Z.  No L commands are used in this test as they are implied after\n          an M or Z command.  The shapes are identical, with one stroked and\n          one filled.  The fill-mode default of "even-odd" means that\n          the inner triangle is hollow.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">      \n      <p>\n      Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The rendered picture should match the reference image exactly\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: paths-data-08-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <!-- ====================================================================== -->\n    <!-- First Group of Triangles using M & Z commands ======================== -->\n    <!-- ====================================================================== -->\n    <text font-size="24" x="75" y="34">Lines drawn with commands:</text>\n    <text font-size="24" x="180" y="64">M and Z</text>\n\n    <g transform="scale(1.8)">\n      <path id="Triangle_stroke_MZ" fill="none" stroke="#000000" d="   M   62.00000   56.00000    113.96152  146.00000   10.03848  146.00000    62.00000   56.00000   Z    M   62.00000  71.00000   100.97114  138.50000   23.02886  138.50000   62.00000  71.00000   Z  "/>\n      <rect x="60.00000" y="54.00000" width="4" height="4" fill="#00C000" stroke="none"/>\n      <rect x="111.96152" y="144.00000" width="4" height="4" fill="#00C000" stroke="none"/>\n      <rect x="8.03848" y="144.00000" width="4" height="4" fill="#00C000" stroke="none"/>\n      <rect x="60.00000" y="69.00000" width="4" height="4" fill="#00C000" stroke="none"/>\n      <rect x="98.97114" y="136.50000" width="4" height="4" fill="#00C000" stroke="none"/>\n      <rect x="21.02886" y="136.50000" width="4" height="4" fill="#00C000" stroke="none"/>\n      <text font-size="12" x="42" y="162">stroked</text>\n      <path id="Triangle_fill_MZ" fill="#05D" stroke="none" fill-rule="evenodd" d="   M  177.00000   56.00000    228.96152  146.00000   125.03848  146.00000    177.00000   56.00000   Z    M  177.00000  71.00000   215.97114  138.50000   138.02886  138.50000   177.00000  71.00000   Z  "/>\n      <rect x="175.00000" y="54.00000" width="4" height="4" fill="#00C000" stroke="none"/>\n      <rect x="226.96152" y="144.00000" width="4" height="4" fill="#00C000" stroke="none"/>\n      <rect x="123.03848" y="144.00000" width="4" height="4" fill="#00C000" stroke="none"/>\n      <rect x="175.00000" y="69.00000" width="4" height="4" fill="#00C000" stroke="none"/>\n      <rect x="213.97114" y="136.50000" width="4" height="4" fill="#00C000" stroke="none"/>\n      <rect x="136.02886" y="136.50000" width="4" height="4" fill="#00C000" stroke="none"/>\n      <text font-size="12" x="162" y="162">filled</text>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.6 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'paths-data-09-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="CN" author="SH" status="accepted"\n    version="$Revision: 1.6 $" testname="$RCSfile: paths-data-09-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/paths.html#PathData">\n        <p>\n          Verify the basic capability to handle the \'path\' element, and its data attribute (d)\n          in combination with the straight-line path commands.\n          Two pairs of concentric equilateral triangles are drawn using\n          m and z.  No l commands are used in this test as they are implied after\n          an m or z command.  The shapes are identical, with one stroked and\n          one filled.  The fill-mode default of "even-odd" means that\n          the inner triangle is hollow.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">      \n      <p>\n      Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The rendered picture should match the reference image exactly\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: paths-data-09-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <!-- ====================================================================== -->\n    <!-- Second Group of Triangles using m & z commands   ===================== -->\n    <!-- ====================================================================== -->\n    <text font-size="24" x="75" y="34">Lines drawn with commands:</text>\n    <text font-size="24" x="180" y="64">m and z</text>\n    <g transform="scale(1.8) translate(0, -150)">\n      <path id="Triangle_stroke_mz" fill="none" stroke="#000000" d="   m   62.00000  190.00000    51.96152   90.00000   -103.92304    0.00000    51.96152  -90.00000   z    m    0.00000   15.00000   38.97114   67.50000   -77.91228    0.00000   38.97114  -67.50000   z  "/>\n      <rect x="60.00000" y="188.00000" width="4" height="4" fill="#40DD20" stroke="none"/>\n      <rect x="111.96152" y="278.00000" width="4" height="4" fill="#40DD20" stroke="none"/>\n      <rect x="8.03848" y="278.00000" width="4" height="4" fill="#40DD20" stroke="none"/>\n      <rect x="60.00000" y="203.00000" width="4" height="4" fill="#40DD20" stroke="none"/>\n      <rect x="98.97114" y="270.50000" width="4" height="4" fill="#40DD20" stroke="none"/>\n      <rect x="21.02886" y="270.50000" width="4" height="4" fill="#40DD20" stroke="none"/>\n      <path id="Triangle_fill_mz" fill="#006000" stroke="none" fill-rule="evenodd" d="   m  177.00000  190.00000    51.96152   90.00000   -103.92304    0.00000    51.96152  -90.00000   z    m    0.00000   15.00000   38.97114   67.50000   -77.91228    0.00000   38.97114  -67.50000   z  "/>\n      <rect x="175.00000" y="188.00000" width="4" height="4" fill="#40DD20" stroke="none"/>\n      <rect x="226.96152" y="278.00000" width="4" height="4" fill="#40DD20" stroke="none"/>\n      <rect x="123.03848" y="278.00000" width="4" height="4" fill="#40DD20" stroke="none"/>\n      <rect x="175.00000" y="203.00000" width="4" height="4" fill="#40DD20" stroke="none"/>\n      <rect x="213.97114" y="270.50000" width="4" height="4" fill="#40DD20" stroke="none"/>\n      <rect x="136.02886" y="270.50000" width="4" height="4" fill="#40DD20" stroke="none"/>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.6 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'paths-data-10-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="CN" author="SH" status="accepted"\n    version="$Revision: 1.6 $" testname="$RCSfile: paths-data-10-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/paths.html#PathData">\n        <p>\n          Verify that the viewer renders the line caps and line joins for\n          open and closed paths properly.\n          Verify that the open triangular paths are stroked differently at\n          ends of the path than they are at their intermediate corners.\n          In contrast, the corners of a closed path should all appear the\n          same.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">      \n      <p>\n      Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The rendered picture should match the reference image exactly\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: paths-data-10-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <g transform="translate(10,10)">\n      <text font-size="18" x="10" y="20">open</text>\n      <text font-size="18" x="10" y="38">join=round</text>\n      <text font-size="18" x="10" y="56">cap=butt</text>\n      <text font-size="18" x="10" y="74">M, L</text>\n      <g transform="translate(115,0)">\n        <path id="triangle-01" fill="green" stroke="#39D" stroke-width="15" stroke-linecap="butt" stroke-linejoin="round" d="M 100 0 L 100 80 0 40 100 0"/>\n      </g>\n    </g>\n    <g transform="translate(10,115)">\n      <text font-size="18" x="10" y="20">open</text>\n      <text font-size="18" x="10" y="38">join=bevel</text>\n      <text font-size="18" x="10" y="56">cap=round</text>\n      <text font-size="18" x="10" y="74">m, l</text>\n      <g transform="translate(115,0)">\n        <path id="triangle-02" fill="green" stroke="#39D" stroke-width="15" stroke-linecap="round" stroke-linejoin="bevel" d="m 100 0 l 0 80 -100 -40 100 -40"/>\n      </g>\n    </g>\n    <g transform="translate(10,220)">\n      <text font-size="18" x="10" y="20">open</text>\n      <text font-size="18" x="10" y="38">join=miter</text>\n      <text font-size="18" x="10" y="56">cap=square</text>\n      <text font-size="18" x="10" y="74">M, L</text>\n      <g transform="translate(115,0)">\n        <path id="triangle-03" fill="green" stroke="#39D" stroke-width="15" stroke-linecap="square" stroke-linejoin="miter" d="M 100 0 L 100 80 0 40 100 0"/>\n      </g>\n    </g>\n    <g transform="translate(250,10)">\n      <text font-size="18" x="125" y="20">closed</text>\n      <text font-size="18" x="125" y="38">join=round</text>\n      <text font-size="18" x="125" y="56">cap=butt</text>\n      <text font-size="18" x="125" y="74">M, L, Z</text>\n      <g transform="translate(0,0)">\n        <path id="triangle-04" fill="green" stroke="#39D" stroke-width="15" stroke-linecap="butt" stroke-linejoin="round" d="M 0 0 L 100 40 0 80 Z"/>\n      </g>\n    </g>\n    <g transform="translate(250,115)">\n      <text font-size="18" x="125" y="20">closed</text>\n      <text font-size="18" x="125" y="38">join=bevel</text>\n      <text font-size="18" x="125" y="56">cap=round</text>\n      <text font-size="18" x="125" y="74">m, l, z</text>\n      <g transform="translate(0,0)">\n        <path id="triangle-05" fill="green" stroke="#39D" stroke-width="15" stroke-linecap="round" stroke-linejoin="bevel" d="m 0 0 l 100 40 -100 40 z"/>\n      </g>\n    </g>\n    <g transform="translate(250,220)">\n      <text font-size="18" x="125" y="20">closed</text>\n      <text font-size="18" x="125" y="38">join=miter</text>\n      <text font-size="18" x="125" y="56">cap=square</text>\n      <text font-size="18" x="125" y="74">M, L, Z</text>\n      <g transform="translate(0,0)">\n        <path id="triangle-06" fill="green" stroke="#39D" stroke-width="15" stroke-linecap="square" stroke-linejoin="miter" d="M 0 0 L 100 40 0 80 Z"/>\n      </g>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.6 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'paths-data-12-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="ED" author="CN" status="accepted"\n    version="$Revision: 1.5 $" testname="$RCSfile: paths-data-12-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/paths.html#PathData">\n        <p>\n          Test using multiple coord sets to build a polybeizer, and implicit values for initial S.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The rendered picture should match the reference image exactly, except for possible variations in the labelling text (per CSS2 rules).\n      </p>\n\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The rendered picture should match the reference image.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: paths-data-12-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <!-- Use multiple coord sets to build a polybeizer-->\n    <path fill="none" stroke="black" stroke-width="3" d="M  100 100    C  100 20   200 20   200 100   S   300 180   300 100"/>\n    <rect x="100" y="100" width="4" height="4" fill="blue" stroke="none"/>\n    <rect x="200" y="100" width="4" height="4" fill="blue" stroke="none"/>\n    <rect x="300" y="100" width="4" height="4" fill="blue" stroke="none"/>\n    <!-- Test if S not preceeded by either C or S ,  first control point is coincident with the current point.-->\n    <path fill="none" stroke="black" stroke-width="3" d="M  100 250    S  200 200   200 250     300 300   300 250"/>\n    <rect x="100" y="250" width="4" height="4" fill="blue" stroke="none"/>\n    <rect x="200" y="200" width="4" height="4" fill="blue" stroke="none"/>\n    <rect x="200" y="250" width="4" height="4" fill="blue" stroke="none"/>\n    <rect x="200" y="300" width="4" height="4" fill="blue" stroke="none"/>\n    <rect x="300" y="300" width="4" height="4" fill="blue" stroke="none"/>\n    <rect x="300" y="250" width="4" height="4" fill="blue" stroke="none"/>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.5 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'paths-data-13-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="ED" author="CN" status="accepted"\n    version="$Revision: 1.5 $" testname="$RCSfile: paths-data-13-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/paths.html#PathData">\n        <p>\n          Test multiple coordinates for V and H. \n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">      \n      <p>\n      Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>The test is passed if there is one horizontal green line and one vertical blue line.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: paths-data-13-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <!-- Use multiple coords to H, should get a straight horizontal line -->\n    <path stroke="green" stroke-width="5" d="   M  240.00000  56.00000    H  270.00000         300.00000 320.00000 400.00000   "/>\n\n    <!-- Use multiple coords to V, should get a straight vertical line -->\n    <path stroke="blue" stroke-width="5" d="   M  240.00000  156.00000    V  180.00000         200.00000 260.00000 300.00000   "/>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.5 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'paths-data-14-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="ED" author="CN" status="accepted"\n    version="$Revision: 1.6 $" testname="$RCSfile: paths-data-14-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/paths.html#PathData">\n        <p>\n          Test implicit values for moveto. If the first command is \'m\' it should be taken as an absolute moveto, plus implicit lineto.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>Run the test. No interaction required.</p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>The test is passed if the three triangles are shown: two concentric, unfilled\n      triangles with black strokes on the left, and one unfilled triangle with\n      a thick blue stroke on the right.</p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: paths-data-14-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <g transform="scale(1.8)">\n      <!-- If the first command is \'m\' it should be taken as an absolute moveto, plus implicit lineto. -->\n      <path fill="none" stroke="#000000" d="   m   62.00000  56.00000    51.96152   90.00000   -103.92304         0.00000    51.96152  -90.00000   z    m    0.00000   15.00000   38.97114   67.50000   -77.91228         0.00000   38.97114  -67.50000   z  "/>\n      <!-- Test implicit lineto. -->\n      <path fill="#0000FF" stroke="none" fill-rule="evenodd" d="   M  177.00000   56.00000    228.96152         146.00000   125.03848  146.00000    177.00000   56.00000   Z    M  177.00000  71.00000   215.97114         138.50000   138.02886  138.50000   177.00000  71.00000   Z  "/>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.6 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'paths-data-15-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="ED" author="CN" status="accepted"\n    version="$Revision: 1.6 $" testname="$RCSfile: paths-data-15-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/paths.html#PathData">\n        <p>\n          Test using multiple coord sets to build a polybezier, then T with no preceding Q or T.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>Run the test. No interaction required.</p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>The test passes if the rendering matches the reference image, apart from any allowable font selection differences due to CSS2.</p>\n      <p>A purple wavy line above a short, blue horizontal line must be shown.\n      Small black triangles pointing to the start, middle and end of the blue\n      line must also be shown.</p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: paths-data-15-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <g transform="scale(1.8) translate(20 50)">\n      <!-- Use multiple coord sets to build a polybezier-->\n      <path fill="none" stroke="purple" stroke-width="3" d="M  20 20    Q  50 10   80 20   110 30   140 20         170 10   200 20"/>\n      <!-- Test if T not preceded by either Q or T , control point should be coincident with the current point.-->\n      <path fill="none" stroke="blue" stroke-width="3" d="M  20 50    T  50 50   80 50"/>\n      <path d="M 20,52 l-2,4 h4 z"/>\n      <path d="M 50,52 l-2,4 h4 z"/>\n      <path d="M 80,52 l-2,4 h4 z"/>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.6 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'paths-data-16-t.svg', svg: '<svg id="svg-root" width="100%" height="100%"\n  viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg"\n  xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="ED" author="CM" status="accepted"\n    version="$Revision: 1.4 $" testname="$RCSfile: paths-data-16-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/paths.html#PathData">\n      <p>\n        This tests that any implicit lineto commands that result from an\n        \'M\' or \'m\' command with more than one pair of coordinates are absolute\n        if the moveto was specified with \'M\' and relative if the moveto was\n        specified with \'m\'.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        After loading the test, the test is passed if two yellow\n        triangles with black borders are shown.  Otherwise, the\n        test has failed.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: paths-data-16-t.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n\n    <text x=\'10\' y=\'40\' font-size=\'13\'>Test relative-ness of implicit lineto path commands</text>\n\n    <g fill=\'red\' stroke=\'red\' stroke-width=\'16\' stroke-linejoin=\'round\'>\n      <path d=\'M100,120 L160,220 L40,220 z\'/>\n      <path d=\'M350,120 L410,220 L290,220 z\'/>\n    </g>\n    <g fill=\'gold\' stroke=\'black\' stroke-width=\'16\' stroke-linejoin=\'round\'>\n      <path d=\'M100,120 160,220 40,220 z\'/>\n      <path d=\'m350,120 60,100 -120,0 z\'/>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.4 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'paths-data-17-f.svg', svg: '<svg id="svg-root" width="100%" height="100%"\n  viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg"\n  xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="ED" author="Microsoft" status="accepted"\n    version="$Revision: 1.4 $" testname="$RCSfile: paths-data-17-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/paths.html#PathDataClosePathCommand">\n      <p>\n        Test that the \'z\' and \'Z\' command have the same effect.\n      </p>\n      <p>\n        Specify four \'path\' elements that each use three \'L\' commands to draw three sides of a square. The fourth line of each\n        square is drawn via a \'closepath\' command. A red square closed via \'z\' is covered with a black square closed via \'Z\' and\n        vice versa.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The test is passed if two black-stroked, unfilled squares are visible and\n	there is no red visible on the page.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: paths-data-17-f.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n\n    <path d="M 50 50 L 50 150 L 150 150 L 150 50 z" stroke-width="5" stroke="red" fill="none" />\n    <path d="M 50 50 L 50 150 L 150 150 L 150 50 Z" stroke-width="6" stroke="black" fill="none" />\n    <path d="M 250 50 L 250 150 L 350 150 L 350 50 Z" stroke-width="5" stroke="red" fill="none" />\n    <path d="M 250 50 L 250 150 L 350 150 L 350 50 z" stroke-width="6" stroke="black" fill="none" />\n\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.4 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved \n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'paths-data-18-f.svg', svg: '<svg id="svg-root" width="100%" height="100%"\n  viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg"\n  xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="CL" author="Microsoft" status="accepted"\n    version="$Revision: 1.6 $" testname="$RCSfile: paths-data-18-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/paths.html#PathDataGeneralInformation">\n      <p>\n        The \'path\' element\'s \'d\' attribute ignores additional whitespace, newline characters, and commas, and BNF processing consumes as much content as possible, stopping as soon as a character that doesn\'t satisfy the production is encountered.\n      </p>\n      <p>\n        Various black path segments are rendered that each demonstrate one of the parsing rules. Each path segment is placed on top\n        of a similar path segment that lacks the particular parsing rule that is being tested. Test passes if no red is visible.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The test passes if seven thick black horizontal lines are shown with corresponding\n        gold horizontal lines just above them, and the black and gold lines are all of the\n        same length and horizontal position.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: paths-data-18-f.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n\n    <g fill="gold">\n      <rect x="220" y="40" width="160" height="8"/>\n      <rect x="220" y="80" width="160" height="8"/>\n      <rect x="220" y="120" width="160" height="8"/>\n      <rect x="220" y="160" width="160" height="8"/>\n      <rect x="64.6" y="200" width="319.5" height="8"/>\n      <rect x="140" y="240" width="160" height="8"/>\n      <rect x="220" y="280" width="160" height="8"/>\n    </g>\n\n    <g transform="translate(60,-30) scale(8,2)">\n      <path d="M 20 40 H 40" stroke-width="2" stroke="red" />\n      <path d="M 20 40\n                 H 40" stroke-width="4" stroke="black" />\n  \n      <path d="M 20 60 H 40" stroke-width="2" stroke="red" />\n      <path d="\n                  M\n                  20\n                  60\n                  H\n                  40\n                  " stroke-width="4" stroke="black" />\n  \n      <path d="M 20 80 H40" stroke-width="2" stroke="red" />\n      <path d="M       20,80          H    40" stroke-width="4" stroke="black" />\n  \n      <path d="M 20 100 H 40#90" stroke-width="2" stroke="red" />\n      <path d="M 20 100 H 40" stroke-width="4" stroke="black" />\n  \n      <path d="M 20 120 H 40.5 0.6" stroke-width="2" stroke="red" />\n      <path d="M 20 120 H 40.5.6" stroke-width="4" stroke="black" />\n  \n      <path d="M 20 140 h 10 -20" stroke-width="2" stroke="red" />\n      <path d="M 20 140 h 10-20" stroke-width="4" stroke="black" />\n  \n      <path d="M 20 160 H 40" stroke-width="2" stroke="red" />\n      <path d="M 20 160 H 40#90" stroke-width="4" stroke="black" />\n    </g>\n\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.6 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved \n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g> -->\n</svg>\n'},
  {name: 'paths-data-19-f.svg', svg: '<svg id="svg-root" width="100%" height="100%"\n  viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg"\n  xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="ED" author="Microsoft" status="accepted"\n    version="$Revision: 1.3 $" testname="$RCSfile: paths-data-19-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/paths.html#PathDataGeneralInformation">\n      <p>\n        Test that additional parameters to pathdata commands are treated as additional calls to the most recent command.\n      </p>\n      <p>\n        Each of the applicable \'pathdata\' commands are used in separate \'path\' elements. Each command is repeated in red and\n        overlayed with another \'path\' element with identical coordinates specified but without the repeated command in black.\n        Commands that do not render or do not take parameters are omitted.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The test is passed if there is no red visible on the page.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: paths-data-19-f.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n\n    <path d="M20 20 H40 H60" stroke-width="3" stroke="red" fill="none" />\n    <path d="M20 20 H40 60" stroke-width="3" stroke="black" fill="none" />\n\n    <path d="M20 40 h20 h20" stroke-width="3" stroke="red" fill="none" />\n    <path d="M20 40 h20 20" stroke-width="3" stroke="black" fill="none" />\n\n    <path d="M120 20 V40 V60" stroke-width="3" stroke="red" fill="none" />\n    <path d="M120 20 V40 60" stroke-width="3" stroke="black" fill="none" />\n\n    <path d="M140 20 v20 v20" stroke-width="3" stroke="red" fill="none" />\n    <path d="M140 20 v20 20" stroke-width="3" stroke="black" fill="none" />\n\n    <path d="M220 20 L 240 20 L260 20" stroke-width="3" stroke="red" fill="none" />\n    <path d="M220 20 L 240 20 260 20 " stroke-width="3" stroke="black" fill="none" />\n\n    <path d="M220 40 l 20 0 l 20 0" stroke-width="3" stroke="red" fill="none" />\n    <path d="M220 40 l 20 0 20 0" stroke-width="3" stroke="black" fill="none" />\n\n    <path d="M50 150 C50 50 200 50 200 150 C200 50 350 50 350 150" stroke-width="3" stroke="red" fill="none" />\n    <path d="M50 150 C50 50 200 50 200 150 200 50 350 50 350 150" stroke-width="3" stroke="black" fill="none" />\n\n    <path d="M50, 200 c0,-100 150,-100 150,0 c0,-100 150,-100 150,0" stroke-width="3" stroke="red" fill="none" />\n    <path d="M50, 200 c0,-100 150,-100 150,0 0,-100 150,-100 150,0" stroke-width="3" stroke="black" fill="none" />\n\n    <path d="M50 250 S125 200 200 250 S275, 200 350 250" stroke-width="3" stroke="red" fill="none" />\n    <path d="M50 250 S125 200 200 250 275, 200 350 250" stroke-width="3" stroke="black" fill="none" />\n\n    <path d="M50 275 s75 -50 150 0 s75, -50 150 0" stroke-width="3" stroke="red" fill="none" />\n    <path d="M50 275 s75 -50 150 0 75, -50 150 0" stroke-width="3" stroke="black" fill="none" />\n\n    <path d="M50 300 Q 125 275 200 300 Q 275 325 350 300" stroke-width="3" stroke="red" fill="none" />\n    <path d="M50 300 Q 125 275 200 300 275 325 350 300" stroke-width="3" stroke="black" fill="none" />\n\n    <path d="M50 325 q 75 -25 150 0 q 75 25 150 0" stroke-width="3" stroke="red" fill="none" />\n    <path d="M50 325 q 75 -25 150 0 75 25 150 0" stroke-width="3" stroke="black" fill="none" />\n\n    <path d="M425 25 T 425 75 T 425 125" stroke-width="3" stroke="red" fill="none" />\n    <path d="M425 25 T 425 75 425 125" stroke-width="3" stroke="black" fill="none" />\n\n    <path d="M450 25 t 0 50 t 0 50" stroke-width="3" stroke="red" fill="none" />\n    <path d="M450 25 t 0 50 0 50" stroke-width="3" stroke="black" fill="none" />\n\n    <path d="M400,200 A25 25 0 0 0 425 150 A25 25 0 0 0 400 200" stroke-width="3" stroke="red" fill="none" />\n    <path d="M400,200 A25 25 0 0 0 425 150 25 25 0 0 0 400 200" stroke-width="3" stroke="black" fill="none" />\n\n    <path d="M400,300 a25 25 0 0 0 25 -50 a25 25 0 0 0 -25 50" stroke-width="3" stroke="red" fill="none" />\n    <path d="M400,300 a25 25 0 0 0 25 -50 25 25 0 0 0 -25 50" stroke-width="3" stroke="black" fill="none" />\n\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.3 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved \n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g> -->\n</svg>\n'},
  {name: 'paths-data-20-f.svg', svg: '<svg id="svg-root" width="100%" height="100%"\n  viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg"\n  xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="CL" author="ED" status="accepted"\n    version="$Revision: 1.3 $" testname="$RCSfile: paths-data-20-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/paths.html#PathDataEllipticalArcCommands">\n      <p>\n        Tests parsing of the elliptical arc path syntax.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The test has passed if the image looks as if there are eight green circles that have\n        two white rectangles overlapping them, like in the reference image. If any red is visible\n        the test has failed.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: paths-data-20-f.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n\n    <!-- no commawsp between arc flags --> \n    <path d="M120,120 h25 a25,25 0 1,0 -25,25 z" fill="red" stroke="lime"/>\n    <path d="M120,120 h25 a25,25 0 10 -25,25z" fill="lime"/>\n\n    <!-- no commawsp between arc flags and no commawsp after arc flags -->\n    <path d="M200,120 h-25 a25,25 0 1,1 25,25 z" fill="red" stroke="lime"/>\n    <path d="M200,120 h-25 a25,25 0 1125,25 z" fill="lime"/>\n  \n    <!-- out of range large-arc-flag value -->\n    <path d="M280,120 h25 a25,25 0 1,0 -25,25 z" fill="lime" stroke="lime"/>\n    <path d="M280,120 h25 a25,25 0 6 0 -25,25 z" fill="red"/>\n  \n    <!-- negative sweep-flag value -->\n    <path d="M360,120 h-25 a25,25 0 1,1 25,25 z" fill="lime" stroke="lime"/>\n    <path d="M360,120 h-25 a25,25 0 1 -1 25,25 z" fill="red"/>\n   \n    <!-- no commawsp between sweep-flag and following coordinate-pair -->\n    <path d="M120,200 h25 a25,25 0 1,1 -25,-25 z" fill="red" stroke="lime"/>\n    <path d="M120,200 h25 a25,25 0 1 1-25,-25 z" fill="lime"/>\n  \n    <!-- no commawsp before arc flags -->\n    <path d="M200,200 h-25 a25,25 0 1,0 25,-25 z" fill="lime" stroke="lime"/>\n    <path d="M200,200 h-25 a25,2501 025,-25 z" fill="red"/>\n\n    <!-- out of range sweep-flag value -->\n    <path d="M280,200 h25 a25,25 0 1,1 -25,-25 z" fill="lime" stroke="lime"/>\n    <path d="M280,200 h25 a25 25 0 1 7 -25 -25 z" fill="red"/>\n\n    <!-- negative large-arc-flag value -->\n    <path d="M360,200 h-25 a25,25 0 1,0 25,-25 z" fill="lime" stroke="lime"/>\n    <path d="M360,200 h-25 a25,25 0 -1 0 25,-25 z" fill="red"/>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.3 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g> -->\n</svg>\n'},
  {name: 'pservers-grad-01-b.svg', svg: '<svg version="1.1" baseProfile="basic" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Haroon Sheikh" status="accepted"\n    version="$Revision: 1.7 $" testname="$RCSfile: pservers-grad-01-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/pservers.html#Gradients">\n        <p>\n          Test that the viewer can handle the xlink:href attribute on\n          linear gradients. The top rectangle has a simple\n        blue (left) to lime (right) linear gradient. The lower one\n        has a different gradient definition, but\n        should look the same as the one above, because the gradient makes a\n        reference to the first gradient, without modifying any attribute.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">            \n      <p>\nRun the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The test is passed if there are two rectangles, both with a blue to lime gradient. \n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: pservers-grad-01-b.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <!-- ====================================================================== -->\n    <!-- Linear Gradient using a xlink:href to another linear gradient          -->\n    <!-- ====================================================================== -->\n    <linearGradient id="Grad1a" gradientUnits="objectBoundingBox" x1="0" y1="0" x2="1" y2="0">\n      <stop stop-color="blue" offset="0"/>\n      <stop stop-color="lime" offset="1"/>\n    </linearGradient>\n    <linearGradient id="Grad1b" xlink:href="#Grad1a"/>\n    <rect x="20" y="20" width="440" height="80" fill="url(#Grad1a)"/>\n    <text font-size="30" x="20" y="130">Linear gradient.</text>\n    <rect x="20" y="150" width="440" height="80" fill="url(#Grad1b)"/>\n    <text font-size="30" x="20" y="260">Referencing gradient below.</text>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.7 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'pservers-grad-02-b.svg', svg: '<svg version="1.1" baseProfile="basic" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Haroon Sheikh" status="accepted"\n    version="$Revision: 1.8 $" testname="$RCSfile: pservers-grad-02-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/pservers.html#Gradients">\n      <p>\n        Test that the viewer can handle the xlink:href attribute on\n        radial gradients.\n      </p>\n      <p>\n        There are two rectangles. The top one has\n        a radial gradient (black to orange) that should appear elliptical\n        to fit the aspect ratio of the rectangle. The units are\n        specified in objectBoundingBox space. The gradient\n        on the lower one\n        references the gradient of the top rectangle, but modifies\n        the units to use userSpace instead. So it is only using the\n        stops from the gradient to the left, with a different geometry. The radial gradient appears circular.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">            \n      <p>Run the test. No interaction required.</p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>The test passes if the rendering matches the reference image, except\n      for any differences in text due to CSS2 rules.  Specifically:</p>\n      <ul>\n        <li>The top rectangle is filled with an elliptical radial gradient,\n        with black in the center and orange at the outside edges of the rectangle.</li>\n        <li>The bottom rectangle is filled with a circular radial gradient,\n        with black in the center and orange at the top and bottom edges of the rectangle.\n        Outside the circular area, the rectangle is filled with plain orange.</li>\n      </ul>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: pservers-grad-02-b.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <!-- ====================================================================== -->\n    <!-- Radial Gradient using a xlink:href to another radial gradient          -->\n    <!-- ====================================================================== -->\n    <radialGradient id="Grad2a" gradientUnits="objectBoundingBox" cx=".5" cy=".5" fx=".5" fy=".5" r=".5">\n      <stop stop-color="black" offset="0"/>\n      <stop stop-color="rgb(255,165,0)" offset="1"/>\n    </radialGradient>\n    <radialGradient id="Grad2b" xlink:href="#Grad2a" gradientUnits="userSpaceOnUse" cx="240" cy="190" fx="240" fy="190" r="40"/>\n    <rect x="20" y="20" width="440" height="80" fill="url(#Grad2a)"/>\n    <text font-size="30" x="20" y="130">Radial gradient.</text>\n    <rect x="20" y="150" width="440" height="80" fill="url(#Grad2b)"/>\n    <text font-size="30" x="20" y="260">Referencing gradient below.</text>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.8 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'pservers-grad-03-b.svg', svg: '<svg version="1.1" baseProfile="basic" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Haroon Sheikh" status="accepted"\n    version="$Revision: 1.8 $" testname="$RCSfile: pservers-grad-03-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/pservers.html#Gradients">\n      <p>\n        Test that the viewer can handle the xlink:href attribute on\n        patterns.\n      </p>\n      <p>\n        There are two rectangles with a pattern fill made\n        up of 4 rectangles. The pattern definition of the lower one references the pattern definition\n        of the upper one, using the xlink:href attribute. Because\n        the particular way that the patterns and rectangles are\n        defined in this test case, the two fills will appear the\n        same - the rectangles are positioned on pattern-size\n        boundaries, so that the offsets into the pattern at the left\n        edges of the respective rectangles is identical.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">            \n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>The test passes if the rendering matches the reference image, except\n      for any differences in text due to CSS2 rules.  Note that the top rectangle must\n      look identical to the bottom rectangle.</p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: pservers-grad-03-b.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <!-- ====================================================================== -->\n    <!-- Pattern filled rectangles using a xlink:href to another pattern fill   -->\n    <!-- ====================================================================== -->\n    <pattern id="Pat3a" x="0" y="0" width="20" height="20" patternUnits="userSpaceOnUse">\n      <rect x="0" y="0" width="10" height="10" fill="#93D"/>\n      <rect x="10" y="0" width="10" height="10" fill="green"/>\n      <rect x="0" y="10" width="10" height="10" fill="blue"/>\n      <rect x="10" y="10" width="10" height="10" fill="yellow"/>\n    </pattern>\n    <pattern id="Pat3b" xlink:href="#Pat3a" width="20" height="20"/>\n    <rect x="20" y="20" width="440" height="80" fill="url(#Pat3a)"/>\n    <text font-size="30" x="20" y="130">Pattern fill.</text>\n    <rect x="20" y="160" width="440" height="80" fill="url(#Pat3b)"/>\n    <text font-size="30" x="20" y="270">Referencing pattern fill below.</text>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.8 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'pservers-grad-04-b.svg', svg: '<svg version="1.1" baseProfile="basic" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Haroon Sheikh" status="accepted"\n    version="$Revision: 1.8 $" testname="$RCSfile: pservers-grad-04-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/pservers.html#Gradients">\n      <p>\n        Test that checks the capability of the stop element in linear and radial\n        gradients.\n      </p>\n      <p>\n        The first rectangle has a linear gradient fill with a vector starting at top left\n        and going to bottom right. The stop colors are at 20% spacing apart and are in the\n        following order : violet, blue, lime, yellow, orange, green.\n        Because the gradient vector vector goes from (0,0) to (1,1) in object bounding box space\n        and because the object bounding box has a larger width than height, the gradient vector\n        is skewed off of a pure 45 degree angle. The gradient stripes are also skewed\n        so that they are no longer perpendicular to the gradient vector.\n      </p>\n      <p>\n        The next rectangle has a radial gradient fill with a multi-color stops from innermost\n        to outermost in the following order: black, yellow, orange, blue, white, green.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">           \n      <p>\n				Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>The test passes if the rendering matches the reference image, except for\n      any differences in text due to CSS2 rules.</p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: pservers-grad-04-b.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <linearGradient id="Grad1" gradientUnits="objectBoundingBox" x1="0" y1="0" x2="1" y2="1">\n      <stop stop-color="rgb(238,130,238)" offset="0"/>\n      <stop stop-color="blue" offset="0.2"/>\n      <stop stop-color="lime" offset="0.4"/>\n      <stop stop-color="yellow" offset="0.6"/>\n      <stop stop-color="rgb(255,165,0)" offset="0.8"/>\n      <stop stop-color="green" offset="1"/>\n    </linearGradient>\n    <rect x="20" y="20" width="440" height="80" fill="url(#Grad1)"/>\n    <text font-size="30" x="20" y="130">Multi-color linear gradient.</text>\n    <!-- ====================================================================== -->\n    <!-- Radial gradient on the stroke of a rectangle                  ======== -->\n    <!-- ====================================================================== -->\n    <radialGradient id="Grad2" gradientUnits="userSpaceOnUse" cx="240" cy="210" r="220" fx="240" fy="210">\n      <stop stop-color="black" offset="0"/>\n      <stop stop-color="yellow" offset="0.2"/>\n      <stop stop-color="orange" offset="0.4"/>\n      <stop stop-color="blue" offset="0.6"/>\n      <stop stop-color="white" offset="0.8"/>\n      <stop stop-color="green" offset="1"/>\n    </radialGradient>\n    <rect x="20" y="150" width="440" height="80" fill="url(#Grad2)" stroke-width="40"/>\n    <text font-size="30" x="20" y="260">Multi-color radial gradient.</text>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.8 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'pservers-grad-05-b.svg', svg: '<svg version="1.1" baseProfile="basic" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Haroon Sheikh" status="accepted"\n    version="$Revision: 1.9 $" testname="$RCSfile: pservers-grad-05-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/pservers.html#Gradients">\n      <p>\n        Test that checks the capability of the stop opacity in linear and radial\n        gradients.\n      </p>\n      <p>\n        There are two tests which contain rectangles with gradients using stop-opacity properties.\n        A cyan color text string "Background" is put behind both of the rectangles to help\n        demonstrate the opacity concept.\n      </p>\n      <p>\n        From top-down the appearance of objects is as follows.\n      </p>\n      <p>\n        The first rectangle has a linear gradient fill with a vector starting at top left\n        and going to bottom right. The stop colors are at 20% spacing apart and are in the\n        following order : violet, blue, lime, yellow, orange, black.\n        Also a stop opacity is given to the colors in the following order: 1, 0.2, 0.5, 0, 0.8, 1\n        Because the gradient vector vector goes from (0,0) to (1,1) in object bounding box space\n        and because the object bounding box has a larger width than height, the gradient vector\n        is skewed off of a pure 45 degree angle. The gradient stripes are also skewed\n        so that they are no longer perpendicular to the gradient vector.\n      </p>\n      <p>\n        The next rectangle has a radial gradient fill with a multi-color stops from innermost\n        to outermost in the following order: black, yellow, red, blue, white, green.\n        Also a stop opacity is given to the colors in the following order: 1, 0.2, 0.5, 0, 0.8, 1\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">            \n      <p>Run the test. No interaction required.</p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>The test passes if the rendering matches the reference image, except for\n      any differences in text due to CSS2 rules.</p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: pservers-grad-05-b.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <text font-size="60" fill="aqua" x="70" y="80">Background</text>\n    <linearGradient id="Grad1" gradientUnits="objectBoundingBox" x1="0" y1="0" x2="1" y2="1">\n      <stop stop-color="rgb(238,130,238)" stop-opacity="1" offset="0"/>\n      <stop stop-color="blue" stop-opacity="0" offset="0.2"/>\n      <stop stop-color="lime" stop-opacity="0.5" offset="0.4"/>\n      <stop stop-color="yellow" stop-opacity="0.2" offset="0.6"/>\n      <stop stop-color="rgb(255,165,0)" stop-opacity="0.8" offset="0.8"/>\n      <stop stop-color="black" stop-opacity="1" offset="1"/>\n    </linearGradient>\n    <rect x="20" y="20" width="440" height="80" fill="url(#Grad1)"/>\n\n    <text font-size="60" fill="aqua" x="70" y="210">Background</text>\n    <radialGradient id="Grad2" gradientUnits="userSpaceOnUse" cx="240" cy="210" r="220" fx="240" fy="210">\n      <stop stop-color="black" stop-opacity="1" offset="0"/>\n      <stop stop-color="yellow" stop-opacity="0" offset="0.2"/>\n      <stop stop-color="red" stop-opacity="0.5" offset="0.4"/>\n      <stop stop-color="blue" stop-opacity="0.2" offset="0.6"/>\n      <stop stop-color="white" stop-opacity="0.8" offset="0.8"/>\n      <stop stop-color="green" stop-opacity="1" offset="1"/>\n    </radialGradient>\n    <rect x="20" y="150" width="440" height="80" fill="url(#Grad2)" stroke-width="40"/>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.9 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'pservers-grad-06-b.svg', svg: '<svg version="1.1" baseProfile="basic" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Haroon Sheikh" status="accepted"\n    version="$Revision: 1.9 $" testname="$RCSfile: pservers-grad-06-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/pservers.html#Gradients">\n      <p>\n        Test that the viewer can handle the gradientTransform and the patternTransform\n        attribute on gradients and patterns respectively.\n      </p>\n      <p>\n        From top-down the appearance of objects is as follows.\n      </p>\n      <p>\n        The top rectangle has a linear gradient whose coordinate system has been scaled down by\n        a half. So the gradient travelling from left to right (from blue to green to lime) should\n        only occuply the left half the rectangle.\n      </p>\n      <p>\n        The next rectangle has radial gradient that has been translated to the center and skewed\n        in the positive X direction by 45 degrees. Therefore the gradient should appear\n        ellipltical and rotated around the center.\n      </p>\n      <p>\n        The last row contains a rectangle with pattern on the fill. The transformation on the\n        pattern moves the coordinate system to the top left of the rectangle and then scales it\n        by a factor of 2 and then skew\'s it in the X direction by 45 degrees. The pattern\n        consists of a 2 by 2 array of colored rectangles.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">            \n      <p>Run the test. No interaction required.</p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>The test passes if the rendering matches the reference image, apart\n      from any differences in font choice due to CSS2 rules.  Specifically:</p>\n      <ul>\n        <li>The top rectangle is filled with a linear gradient from blue on the left,\n        to lime in the middle.  The right half of the rectangle is filled with plain lime.</li>\n        <li>The middle rectangle is filled with an elliptical radial gradient with\n        black on the inside and orange on the outside.  The center point of the gradient\n        is near the center-bottom of the rectangle.  The gradient is skewed, so that it appears\n        as a rotated elliptical gradient.</li>\n        <li>The bottom rectangle is filled with a repeating pattern of tiled\n        red, green, yellow and blue parallelograms.</li>\n      </ul>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: pservers-grad-06-b.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <!-- ====================================================================== -->\n    <!-- Linear Gradient with gradientTransforms                                -->\n    <!-- ====================================================================== -->\n    <linearGradient id="Grad1" gradientUnits="userSpaceOnUse" x1="0" y1="0" x2="430" y2="0" gradientTransform="translate(25 35) scale(0.5)">\n      <stop stop-color="blue" offset="0"/>\n      <stop stop-color="green" offset="0.5"/>\n      <stop stop-color="lime" offset="1"/>\n    </linearGradient>\n    <rect x="20" y="20" width="440" height="50" fill="url(#Grad1)"/>\n    <text font-size="30" x="20" y="100">scale(0.5) on gradient</text>\n    <!-- ====================================================================== -->\n    <!-- Radial Gradiant with a gradientTransform                               -->\n    <!-- ====================================================================== -->\n    <radialGradient id="Grad2" gradientUnits="userSpaceOnUse" cx="0" cy="0" fx="0" fy="0" r="60" gradientTransform="translate(240,155) skewX(45)">\n      <stop stop-color="black" offset="0"/>\n      <stop stop-color="rgb(255,165,0)" offset="1"/>\n    </radialGradient>\n    <rect x="20" y="110" width="440" height="50" fill="url(#Grad2)"/>\n    <text font-size="30" x="20" y="190">skewX(45) on gradient</text>\n    <!-- ====================================================================== -->\n    <!-- Pattern filled rectangles with a patternTransform.                     -->\n    <!-- ====================================================================== -->\n    <pattern patternUnits="userSpaceOnUse" id="Pat3" x="0" y="0" width="20" height="20" patternTransform="translate(25 215) scale(2) skewX(45)">\n      <rect x="0" y="0" width="10" height="10" fill="maroon"/>\n      <rect x="10" y="0" width="10" height="10" fill="green"/>\n      <rect x="0" y="10" width="10" height="10" fill="blue"/>\n      <rect x="10" y="10" width="10" height="10" fill="yellow"/>\n    </pattern>\n    <rect x="20" y="210" width="440" height="50" fill="url(#Pat3)"/>\n    <text font-size="30" x="20" y="290">scale(2), skewX(45) on pattern</text>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.9 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'pservers-grad-07-b.svg', svg: '<svg version="1.1" baseProfile="basic" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Haroon Sheikh" status="accepted"\n    version="$Revision: 1.8 $" testname="$RCSfile: pservers-grad-07-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/pservers.html#Gradients">\n      <p>\n        Test that the viewer has basic capability to handle linear gradients\n        on fills and stroke of objects and text.\n      </p>\n      <p>\n        This test uses the following elements : &lt;linearGradient&gt;, &lt;stop&gt;\n        and the following properties : stop-color, fill:url(#  ), stroke(url# )\n      </p>\n      <p>\n        Both elements in this test use the same simple gradient. It is a linear gradient from\n        blue (left) to lime (right). From top-down the appearance of objects is as follows.\n      </p>\n      <p>\n        The top rectangle should be filled with the gradient.\n      </p>\n      <p>\n        The next rectangle has no fill, but has a thick stroke on which the gradient is\n        applied.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">            \n      <p>Run the test. No interaction required.</p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>The test passes if the rendering matches the reference image, apart\n      from any differences in font choice due to CSS2 rules.  Specifically:</p>\n      <ul>\n        <li>The top rectangle is filled with a gradient from blue on the left to lime on the right.</li>\n        <li>The bottom rectangle is unfilled and stroked with a thick stroke using a gradient from blue on the left to lime on the right.</li>\n      </ul>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: pservers-grad-07-b.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <g transform="scale(1, 1.5)">\n      <!-- ====================================================================== -->\n      <!-- Very simple blue to red linear gradient from left to right  ========== -->\n      <!-- ====================================================================== -->\n      <linearGradient id="Gradient" gradientUnits="userSpaceOnUse" x1="10" y1="10" x2="440" y2="10">\n        <stop stop-color="blue" offset="0"/>\n        <stop stop-color="lime" offset="1"/>\n      </linearGradient>\n      <!-- ====================================================================== -->\n      <!-- Linear gradient on the fill of a rectangle                    ======== -->\n      <!-- ====================================================================== -->\n      <rect x="10" y="10" width="430" height="60" fill="url(#Gradient)"/>\n      <text font-size="24" x="10" y="90">Linear gradient filled rectangle</text>\n      <!-- ====================================================================== -->\n      <!-- Linear gradient on the stroke of a rectangle                  ======== -->\n      <!-- ====================================================================== -->\n      <rect x="25" y="110" width="400" height="30" fill="none" stroke="url(#Gradient)" stroke-width="20"/>\n      <text font-size="24" x="10" y="170">Linear gradient on stroke of rectangle</text>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.8 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'pservers-grad-08-b.svg', svg: '<svg version="1.1" baseProfile="basic" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Haroon Sheikh" status="accepted"\n    version="$Revision: 1.13 $" testname="$RCSfile: pservers-grad-08-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/pservers.html#Gradients">\n      <p>\n        Test that the viewer has basic capability to handle linear gradients\n        on fills and stroke of text.\n      </p>\n      <p>\n        Both elements in this test use the same simple gradient. It is a linear gradient from blue (left) to lime (right). From top-down the appearance of objects is as follows.\n      </p>\n      <p>\n        The first item is a text string "Gradient on fill" with the gradient on the fill of the text.\n      </p>\n      <p>\n        The second item is a text string that is not filled. It has a 2 user unit stroke on which the gradient is applied.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>Run the test. No interaction required.</p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>The test passes if the rendering matches the reference image, apart\n      from any differences in font choice due to CSS2 rules.  Specifically:</p>\n      <ul>\n        <li>The text string "Gradient on fill" must be filled with a gradient\n        from blue on the left to lime on the right.</li>\n        <li>The text string "Gradient on stroke" must be unfilled and stroked with\n        a gradient from blue on the left to lime on the right.</li>\n      </ul>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: pservers-grad-08-b.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n  <style type="text/css">\n    @font-face {\n      font-family: Blocky;\n      src: url(woffs/Blocky.woff) format("woff");\n  </style>\n  <defs>\n      <font-face font-family="Blocky" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/Blocky.svg#Blocky"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n    <g transform="scale(1, 1.5)">\n      <!-- ====================================================================== -->\n      <!-- Very simple blue to red linear gradient from left to right  ========== -->\n      <!-- ====================================================================== -->\n      <linearGradient id="Gradient" gradientUnits="userSpaceOnUse" x1="10" y1="10" x2="440" y2="10">\n        <stop stop-color="blue" offset="0"/>\n        <stop stop-color="lime" offset="1"/>\n      </linearGradient>\n      <!-- ====================================================================== -->\n      <!-- Gradient on fill of text                                      ======== -->\n      <!-- ====================================================================== -->\n      <text font-family="Blocky" font-size="68" fill="url(#Gradient)" x="20" y="70">Gradient on fill</text>\n      <!-- ====================================================================== -->\n      <!-- Gradient on stroke of text                                    ======== -->\n      <!-- ====================================================================== -->\n      <text font-family="Blocky" x="20" y="160" font-size="55" fill="none" stroke="url(#Gradient)" stroke-width="3">Gradient on stroke</text>\n\n    </g>\n      <g font-family="SVGFreeSansASCII,sans-serif" font-size="28">\n        <text  x="40" y="145">Linear gradient on filled text</text>\n        <text  x="30" y="280">Linear gradient on stroke of text</text>\n      </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.13 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'pservers-grad-09-b.svg', svg: '<svg version="1.1" baseProfile="basic" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Haroon Sheikh" status="accepted"\n    version="$Revision: 1.9 $" testname="$RCSfile: pservers-grad-09-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/pservers.html#Gradients">\n      <p>\n        Test that the viewer can handle the gradientUnits attribute on linear gradients.\n        It tests the following values of gradientUnits: default (userSpace), objectBoundingBox,\n        and userSpaceOnUse.\n      </p>\n      <p>\n        From top-down the appearance of objects is as follows.\n      </p>\n      <p>\n        The first rectangle uses the default attributes on the linearGradient element.\n        Therefore the linear gradient should default to objectBoundingBox. It should appear\n        from the left edge of the rectangle (blue) to the right edge of the rectangle (lime).\n        The rectangle is smaller than the viewport, because a previous version of the SVG spec had the default value be \'viewport\'.\n        The test fails if only a portion of the gradient is shown.\n      </p>\n      <p>\n        The next rectangle uses gradientUnits=objectBoundingBox. The linear gradient should\n        travel from blue (top) to lime (bottom).\n      </p>\n      <p>\n        The last rectangle uses gradientUnits=userSpaceOnUse. The rectangle element is given it\'s\n        own transformation and the gradient is assumed to be in this user space.\n        The gradient should appear as a linear gradient from lime (left) to blue (right).\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>Run the test. No interaction required.</p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>The test passes if the rendering matches the reference image, apart\n      from any differences in font choice due to CSS2 rules.  Specifically:</p>\n      <ul>\n        <li>The top rectangle is filled with a linear gradient from lime on the left to blue on the right.</li>\n        <li>The middle rectangle is filled with a linear gradient from blue on the top to lime on the bottom.</li>\n        <li>The bottom rectangle is filled with a linear gradient from lime on the left to blue on the right.</li>\n      </ul>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: pservers-grad-09-b.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <text font-size="15" x="10" y="25">Testing gradientUnits attribute</text>\n    <!-- ====================================================================== -->\n    <!-- Linear gradient with default attributes on <linear gradient> element.  -->\n    <!-- ====================================================================== -->\n    <linearGradient id="Grad1">\n      <stop stop-color="lime" offset="0"/>\n      <stop stop-color="blue" offset="1"/>\n    </linearGradient>\n    <rect x="125" y="35" width="200" height="50" fill="url(#Grad1)"/>\n    <!--<text font-size="12" x="10" y="100">Linear gradient with default attributes (thus, same as objectBoundingBox)</text>-->\n    <!--text font-size="12"  x="10" y="125">Gradient is from the viewport left edge (lime) to viewport right edge (blue)</text-->\n    <!--<text font-size="12" x="10" y="115">Gradient is from the object left edge (lime) to object right edge (blue)</text>-->\n    <!-- ====================================================================== -->\n    <!-- Linear gradient with gradientUnits=objectBoundingBox          ======== -->\n    <!-- ====================================================================== -->\n    <linearGradient id="Grad2" gradientUnits="objectBoundingBox" x1="0" y1="0" x2="0" y2="1">\n      <stop stop-color="blue" offset="0"/>\n      <stop stop-color="lime" offset="1"/>\n    </linearGradient>\n    <rect x="10" y="125" width="430" height="50" fill="url(#Grad2)"/>\n    <!--<text font-size="12" x="10" y="190">gradientUnits=objectBoundingBox</text>-->\n    <!--<text font-size="12" x="10" y="205">Gradient is from the object top edge (blue) to object bottom edge (lime)</text>-->\n    <!-- ====================================================================== -->\n    <!-- Gradient using gradientUnits="userSpaceOnUse"                          -->\n    <!-- ====================================================================== -->\n    <linearGradient id="Grad3" x1="0" y1="0" x2="0" y2="430" gradientUnits="userSpaceOnUse">\n      <stop stop-color="lime" offset="0"/>\n      <stop stop-color="blue" offset="1"/>\n    </linearGradient>\n    <rect transform="translate(10, 260) rotate(-90)" x="0" y="0" width="50" height="430" fill="url(#Grad3)"/>\n    <!--<text font-size="12" x="10" y="275">gradientUnits=userSpaceOnUse</text>-->\n    <!--<text font-size="12" x="10" y="290">Gradient is from the object left edge (lime) to object right edge (blue)</text>-->\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.9 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'pservers-grad-10-b.svg', svg: '<svg version="1.1" baseProfile="basic" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Haroon Sheikh" status="accepted"\n    version="$Revision: 1.8 $" testname="$RCSfile: pservers-grad-10-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/pservers.html#Gradients">\n      <p>\n        Test that the viewer can handle the spreadMethod attribute on linear gradients.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">            \n      <p>\n				Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>The test passes if the rendering matches the reference image, apart\n      from any differences in font choice due to CSS2 rules.  Each of the\n      three rectangles is filled with a linear gradient from blue on the left\n      to lime on the right.  The width of the gradient is only a fifth of\n      the width of the rectangle, so:</p>\n      <ul>\n        <li>The top rectangle is filled with plain blue in the left two-fifths\n        and with plain lime in the right two-fifths.</li>\n        <li>The middle rectangle is filled with alternating copies of the blue-to-lime\n        gradient.  Thus, from left to right, the rectangle is filled with\n        a gradient that goes from blue to lime to blue to lime to blue to lime.</li>\n        <li>The bottom rectangle is filled with five copies of the blue-to-lime\n        gradient.  Thus, from left to right, the rectangle is filled with\n        a gradient that goes from blue to lime, abruptly changing back to blue\n        then smoothly changing to lime, etc.</li>\n      </ul>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: pservers-grad-10-b.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <text font-size="15" x="10" y="25">Testing spreadMethod attribute</text>\n    <!-- ====================================================================== -->\n    <!-- Linear Gradient with spreadMethod=pad                                  -->\n    <!-- ====================================================================== -->\n    <linearGradient id="Grad1" gradientUnits="objectBoundingBox" x1=".4" y1="0" x2=".6" y2="0" spreadMethod="pad">\n      <stop stop-color="blue" offset="0"/>\n      <stop stop-color="lime" offset="1"/>\n    </linearGradient>\n    <rect x="10" y="35" width="460" height="55" fill="url(#Grad1)"/>\n    <text font-size="12" x="10" y="105">spreadMethod=pad</text>\n    <!-- ====================================================================== -->\n    <!-- Linear Gradient with spreadMethod=reflect                              -->\n    <!-- ====================================================================== -->\n    <linearGradient id="Grad2" gradientUnits="objectBoundingBox" x1=".4" y1="0" x2=".6" y2="0" spreadMethod="reflect">\n      <stop stop-color="blue" offset="0"/>\n      <stop stop-color="lime" offset="1"/>\n    </linearGradient>\n    <rect x="10" y="120" width="460" height="55" fill="url(#Grad2)"/>\n    <text font-size="12" x="10" y="190">spreadMethod=reflect</text>\n    <!-- ====================================================================== -->\n    <!-- Linear Gradient with spreadMethod=repeat                               -->\n    <!-- ====================================================================== -->\n    <linearGradient id="Grad3" gradientUnits="objectBoundingBox" x1=".4" y1="0" x2=".6" y2="0" spreadMethod="repeat">\n      <stop stop-color="blue" offset="0"/>\n      <stop stop-color="lime" offset="1"/>\n    </linearGradient>\n    <rect x="10" y="205" width="460" height="55" fill="url(#Grad3)"/>\n    <text font-size="12" x="10" y="275">spreadMethod=repeat</text>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.8 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="lime" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'pservers-grad-11-b.svg', svg: '<svg version="1.1" baseProfile="basic" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Haroon Sheikh" status="accepted"\n    version="$Revision: 1.8 $" testname="$RCSfile: pservers-grad-11-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/pservers.html#Gradients">\n      <p>\n        Test that the viewer has basic capability to handle radial gradients\n        on fills and stroke of objects and text.\n      </p>\n      <p>\n        This test uses the following elements : &lt;radialGradient&gt;, &lt;stop&gt;\n        and the following properties : stop-color, fill:url(#  ), stroke(url# )\n      </p>\n      <p>\n        From top-down (left to right) the appearance of objects is as follows.\n      </p>\n      <p>\n        The top left rectangle  should be a radial gradient from dark blue (in) to lime (outside).\n        The gradient is applied to the fill of the rectangle.\n      </p>\n      <p>\n        The next rectangle has no fill, but has a thick stroke on which the gradient is\n        applied. The gradient goes from dark orange(in) to pale yellow (out).\n      </p>\n      <p>\n        The next item is a text with a radial gradient on the fill. The gradient goes\n        from green (in) to yellow (out).\n      </p>\n      <p>\n        The last item is a text with a 2 user unit stroke on which a black (in) to magenta\n        (out) linear gradient is applied.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">            \n      <p>Run the test. No interaction required.</p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>The test passes if the rendering matches the reference image, apart\n      from any differences in font choice due to CSS2 rules.  Specifically:</p>\n      <ul>\n        <li>The top-left rectangle must be filled with a circular radial gradient\n        with dark blue inside and lime outside.  The center point of the gradient\n        is in the lower-left quadrant of the rectangle.</li>\n        <li>The top-right rectangle has no fill, but a thick stroke which is painted\n        with a radial gradient with dark orange inside and yellow outside.  The\n        center point of this gradient is in the lower-left quadrant of the\n        rectangle.</li>\n        <li>The "Gradient on text fill" text must be filled with a circular radial\n        gradient with green inside and yellow outside.  The center point of the\n        gradient is the center of the text.</li>\n        <li>The "Gradient on text stroke" has no fill, but a stroke which is painted with\n        a circular radial gradient with black inside and pink outside.  The center point of the\n        gradient is the center of the text.</li>\n      </ul>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: pservers-grad-11-b.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <!-- ====================================================================== -->\n    <!-- Very simple black to red radial gradient                      ======== -->\n    <!-- ====================================================================== -->\n    <radialGradient gradientUnits="userSpaceOnUse" id="Grad1" cx="75" cy="100" r="130" fx="75" fy="100">\n      <stop stop-color="#009" offset="0"/>\n      <stop stop-color="#2e2" offset="1"/>\n    </radialGradient>\n    <rect x="10" y="10" width="210" height="140" fill="url(#Grad1)"/>\n    <text font-family="Arial" font-size="12" x="10" y="165">Radial gradient on fill of rectangle</text>\n    <!-- ====================================================================== -->\n    <!-- Radial gradient on the stroke of a rectangle                  ======== -->\n    <!-- ====================================================================== -->\n    <radialGradient id="Grad2" gradientUnits="userSpaceOnUse" cx="295" cy="100" r="150" fx="295" fy="100">\n      <stop stop-color="#e22" offset="0"/>\n      <stop stop-color="#ff6" offset="1"/>\n    </radialGradient>\n    <rect x="250" y="30" width="170" height="100" fill="none" stroke="url(#Grad2)" stroke-width="40"/>\n    <text font-family="Arial" font-size="12" x="230" y="165">Radial gradient on stroke of rectangle</text>\n    <!-- ====================================================================== -->\n    <!-- Gradient on fill of text                                      ======== -->\n    <!-- ====================================================================== -->\n    <radialGradient id="Grad3" gradientUnits="userSpaceOnUse" cx="225" cy="180" r="90" fx="225" fy="180">\n      <stop stop-color="#060" offset="0"/>\n      <stop stop-color="yellow" offset="1"/>\n    </radialGradient>\n    <text font-family="Arial" font-size="50" fill="url(#Grad3)" x="10" y="210">Gradient on text fill</text>\n    <text font-family="Arial" font-size="12" x="10" y="225">Radial gradient on text, black to yellow</text>\n    <!-- ====================================================================== -->\n    <!-- Gradient on stroke of text                                    ======== -->\n    <!-- ====================================================================== -->\n    <radialGradient id="Grad4" gradientUnits="userSpaceOnUse" cx="225" cy="245" r="90" fx="225" fy="245">\n      <stop stop-color="black" offset="0"/>\n      <stop stop-color="#D6D" offset="1"/>\n    </radialGradient>\n    <text font-family="Arial" font-size="45" fill="none" stroke="url(#Grad4)" stroke-width="2" x="10" y="270">Gradient on text stroke</text>\n    <text font-family="Arial" font-size="12" x="10" y="285">Radial gradient on stroke of text, black to red</text>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.8 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'pservers-grad-12-b.svg', svg: '<svg version="1.1" baseProfile="basic" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Haroon Sheikh" status="accepted"\n    version="$Revision: 1.9 $" testname="$RCSfile: pservers-grad-12-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/pservers.html#Gradients">\n      <p>\n        Test that the viewer can handle the gradientUnits attribute on radial gradients.\n        It tests the following values of gradientUnits: default (objectBoundingBox), objectBoundingBox,\n        and userSpaceOnUse.\n      </p>\n      <p>\n        From top-down the appearance of objects is as follows.\n      </p>\n      <p>\n        The first rectangle uses the default attributes on the radialGradient element.\n        Therefore the radial gradient should be relative to the object bounding box. It should appear\n        from the center of the viewport (blue) to the edges of the viewport (lime).\n        The rectangle is wider than tall so it the gradient should be elliptical, not circular.\n      </p>\n      <p>\n        The next rectangle uses gradientUnits=objectBoundingBox. The radial gradient should\n        travel from a center of 20%, 20% of the rectangle with a radius of 50%.\n      </p>\n      <p>\n        The last rectangle uses gradientUnits=userSpaceOnUse. The rectangle element is given it\'s\n        own transformation and the gradient is assumed to be in this user space.\n        The gradient should appear in the center of the rectangle as a radial gradient from yellow (center) to blue (edge).\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">      \n      <p>Run the test. No interaction required.</p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>The test passes if the rendering of the three rectangles matches those\n      in the reference image.  Specifically:</p>\n      <ul>\n        <li>The upper rectangle is filled with an elliptical radial gradient\n        with blue at the center and lime at its edges.</li>\n        <li>The middle rectangle is also filled with an elliptical radial\n        gradient with blue inside and lime outside, but with the center\n        point of the gradient in the top-left quadrant of the rectangle.</li>\n        <li>The bottom rectangle is filled with a circular radial gradient\n        with yellow at the center and blue at its edges.  Since it is circular,\n        most of the rectangle is filled with plain blue.</li>\n      </ul>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: pservers-grad-12-b.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <text font-size="15" x="10" y="25">Testing gradientUnits attribute</text>\n    <!-- ====================================================================== -->\n    <!-- Radial gradient with default attributes on <radial gradient> element.  -->\n    <!-- ====================================================================== -->\n    <radialGradient id="Grad1">\n      <stop stop-color="#009" offset="0"/>\n      <stop stop-color="lime" offset="1"/>\n    </radialGradient>\n    <rect x="10" y="35" width="460" height="50" fill="url(#Grad1)"/>\n    <text font-size="12" x="10" y="100">Radial gradient with default attributes (from blue to yellow)</text>\n    <text font-size="12" x="10" y="115">Gradient is blue at the object center and lime at the object edges</text>\n    <!-- ====================================================================== -->\n    <!-- Radial gradient with gradientUnits=objectBoundingBox          ======== -->\n    <!-- ====================================================================== -->\n    <radialGradient id="Grad2" gradientUnits="objectBoundingBox" cx=".2" cy=".2" fx=".2" fy=".2" r=".5">\n      <stop stop-color="#009" offset="0"/>\n      <stop stop-color="lime" offset="1"/>\n    </radialGradient>\n    <rect x="10" y="125" width="460" height="50" fill="url(#Grad2)"/>\n    <text font-size="12" x="10" y="190">gradientUnits=objectBoundingBox</text>\n    <text font-size="12" x="10" y="205">cx=.2, cy=.2, r=.5, fx=.2 fy=.2</text>\n    <!-- ====================================================================== -->\n    <!-- Gradient using gradientUnits="userSpaceOnUse"                          -->\n    <!-- ====================================================================== -->\n    <radialGradient id="Grad3" cx="25" cy="215" r="25" fx="25" fy="215" gradientUnits="userSpaceOnUse">\n      <stop stop-color="yellow" offset="0"/>\n      <stop stop-color="blue" offset="1"/>\n    </radialGradient>\n    <rect transform="translate(10, 260) rotate(-90)" x="0" y="0" width="50" height="460" fill="url(#Grad3)"/>\n    <text font-size="12" x="10" y="275">gradientUnits=userSpaceOnUse</text>\n    <text font-size="12" x="10" y="290">Gradient is yellow to blue radial gradient from center to horizontal bounds</text>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.9 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'pservers-grad-13-b.svg', svg: '<svg version="1.1" baseProfile="basic" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="CL" author="BB" status="accepted"\n    version="$Revision: 1.5 $" testname="$RCSfile: pservers-grad-13-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/pservers.html#Gradients">\n        <p>\n          The purpose of this file is to test several values for focal points of radial gradients.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>Run the test. No interaction required.</p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>The test passes if the rendered image matches the reference image, except\n      for any differences in font choice due to CSS2.</p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: pservers-grad-13-b.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <text x="240" y="30" font-size="20" text-anchor="middle">Radial gradient focal point</text>\n    <defs>\n      <g id="alpha">\n        <rect x="00" y="0" width="100" height="60" fill="yellow"/>\n        <rect x="00" y="0" width="10" height="60" fill="gold"/>\n        <rect x="15" y="0" width="10" height="60" fill="orange"/>\n        <rect x="30" y="0" width="10" height="60" fill="sienna"/>\n        <rect x="45" y="0" width="10" height="60" fill="gold"/>\n        <rect x="60" y="0" width="10" height="60" fill="sienna"/>\n        <rect x="75" y="0" width="10" height="60" fill="orange"/>\n        <rect x="90" y="0" width="10" height="60" fill="gold"/>\n        <rect x="00" y="0" width="100" height="60"/>\n        <!-- inherits a radial gradient -->\n      </g>\n    </defs>\n    <defs>\n      <radialGradient id="grad1a" gradientUnits="objectBoundingBox" cx="10%" cy="10%" r="75%" fx="00.00%" fy="00%">\n        <stop offset="0" stop-opacity="0"/>\n        <stop offset=".5" stop-color="darkblue"/>\n        <stop offset="1" stop-opacity="0"/>\n      </radialGradient>\n      <radialGradient id="grad2a" gradientUnits="objectBoundingBox" cx="10%" cy="10%" r="75%" fx="16.66%" fy="00%">\n        <stop offset="0" stop-opacity="0"/>\n        <stop offset=".5" stop-color="darkblue"/>\n        <stop offset="1" stop-opacity="0"/>\n      </radialGradient>\n      <radialGradient id="grad4a" gradientUnits="objectBoundingBox" cx="10%" cy="10%" r="75%" fx="50.00%" fy="00%">\n        <stop offset="0" stop-opacity="0"/>\n        <stop offset=".5" stop-color="darkblue"/>\n        <stop offset="1" stop-opacity="0"/>\n      </radialGradient>\n      <radialGradient id="grad6a" gradientUnits="objectBoundingBox" cx="10%" cy="10%" r="75%" fx="83.33%" fy="00%">\n        <stop offset="0" stop-opacity="0"/>\n        <stop offset=".5" stop-color="darkblue"/>\n        <stop offset="1" stop-opacity="0"/>\n      </radialGradient>\n\n      <radialGradient id="grad1b" gradientUnits="objectBoundingBox" cx="10%" cy="10%" r="75%" fx="00.00%" fy="25%">\n        <stop offset="0" stop-opacity="0"/>\n        <stop offset=".5" stop-color="darkblue"/>\n        <stop offset="1" stop-opacity="0"/>\n      </radialGradient>\n      <radialGradient id="grad2b" gradientUnits="objectBoundingBox" cx="10%" cy="10%" r="75%" fx="16.66%" fy="25%">\n        <stop offset="0" stop-opacity="0"/>\n        <stop offset=".5" stop-color="darkblue"/>\n        <stop offset="1" stop-opacity="0"/>\n      </radialGradient>\n      <radialGradient id="grad4b" gradientUnits="objectBoundingBox" cx="10%" cy="10%" r="75%" fx="50.00%" fy="25%">\n        <stop offset="0" stop-opacity="0"/>\n        <stop offset=".5" stop-color="darkblue"/>\n        <stop offset="1" stop-opacity="0"/>\n      </radialGradient>\n      <radialGradient id="grad6b" gradientUnits="objectBoundingBox" cx="10%" cy="10%" r="75%" fx="83.33%" fy="25%">\n        <stop offset="0" stop-opacity="0"/>\n        <stop offset=".5" stop-color="darkblue"/>\n        <stop offset="1" stop-opacity="0"/>\n      </radialGradient>\n\n      <radialGradient id="grad1c" gradientUnits="objectBoundingBox" cx="10%" cy="10%" r="75%" fx="00.00%" fy="50%">\n        <stop offset="0" stop-opacity="0"/>\n        <stop offset=".5" stop-color="darkblue"/>\n        <stop offset="1" stop-opacity="0"/>\n      </radialGradient>\n      <radialGradient id="grad2c" gradientUnits="objectBoundingBox" cx="10%" cy="10%" r="75%" fx="16.66%" fy="50%">\n        <stop offset="0" stop-opacity="0"/>\n        <stop offset=".5" stop-color="darkblue"/>\n        <stop offset="1" stop-opacity="0"/>\n      </radialGradient>\n      <radialGradient id="grad4c" gradientUnits="objectBoundingBox" cx="10%" cy="10%" r="75%" fx="50.00%" fy="50%">\n        <stop offset="0" stop-opacity="0"/>\n        <stop offset=".5" stop-color="darkblue"/>\n        <stop offset="1" stop-opacity="0"/>\n      </radialGradient>\n      <radialGradient id="grad6c" gradientUnits="objectBoundingBox" cx="10%" cy="10%" r="75%" fx="83.33%" fy="50%">\n        <stop offset="0" stop-opacity="0"/>\n        <stop offset=".5" stop-color="darkblue"/>\n        <stop offset="1" stop-opacity="0"/>\n      </radialGradient>\n\n      <radialGradient id="grad1d" gradientUnits="objectBoundingBox" cx="10%" cy="10%" r="75%" fx="00.00%" fy="75%">\n        <stop offset="0" stop-opacity="0"/>\n        <stop offset=".5" stop-color="darkblue"/>\n        <stop offset="1" stop-opacity="0"/>\n      </radialGradient>\n      <radialGradient id="grad2d" gradientUnits="objectBoundingBox" cx="10%" cy="10%" r="75%" fx="16.66%" fy="75%">\n        <stop offset="0" stop-opacity="0"/>\n        <stop offset=".5" stop-color="darkblue"/>\n        <stop offset="1" stop-opacity="0"/>\n      </radialGradient>\n      <radialGradient id="grad4d" gradientUnits="objectBoundingBox" cx="10%" cy="10%" r="75%" fx="50.00%" fy="75%">\n        <stop offset="0" stop-opacity="0"/>\n        <stop offset=".5" stop-color="darkblue"/>\n        <stop offset="1" stop-opacity="0"/>\n      </radialGradient>\n      <radialGradient id="grad6d" gradientUnits="objectBoundingBox" cx="10%" cy="10%" r="75%" fx="83.33%" fy="75%">\n        <stop offset="0" stop-opacity="0"/>\n        <stop offset=".5" stop-color="darkblue"/>\n        <stop offset="1" stop-opacity="0"/>\n      </radialGradient>\n    </defs>\n\n    <g id="group1" stroke="black" stroke-width="0.5">\n      <use xlink:href="#alpha" x="017.5" y="045" fill="url(#grad1a)"/>\n      <use xlink:href="#alpha" x="130" y="045" fill="url(#grad2a)"/>\n      <use xlink:href="#alpha" x="242.5" y="045" fill="url(#grad4a)"/>\n      <use xlink:href="#alpha" x="355" y="045" fill="url(#grad6a)"/>\n\n      <use xlink:href="#alpha" x="017.5" y="110" fill="url(#grad1b)"/>\n      <use xlink:href="#alpha" x="130" y="110" fill="url(#grad2b)"/>\n      <use xlink:href="#alpha" x="242.5" y="110" fill="url(#grad4b)"/>\n      <use xlink:href="#alpha" x="355" y="110" fill="url(#grad6b)"/>\n\n      <use xlink:href="#alpha" x="017.5" y="175" fill="url(#grad1c)"/>\n      <use xlink:href="#alpha" x="130" y="175" fill="url(#grad2c)"/>\n      <use xlink:href="#alpha" x="242.5" y="175" fill="url(#grad4c)"/>\n      <use xlink:href="#alpha" x="355" y="175" fill="url(#grad6c)"/>\n\n      <use xlink:href="#alpha" x="017.5" y="240" fill="url(#grad1d)"/>\n      <use xlink:href="#alpha" x="130" y="240" fill="url(#grad2d)"/>\n      <use xlink:href="#alpha" x="242.5" y="240" fill="url(#grad4d)"/>\n      <use xlink:href="#alpha" x="355" y="240" fill="url(#grad6d)"/>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.5 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'pservers-grad-14-b.svg', svg: '<svg version="1.1" baseProfile="basic" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="CL" author="BB" status="accepted"\n    version="$Revision: 1.5 $" testname="$RCSfile: pservers-grad-14-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/pservers.html#Gradients">\n      <p>\n        The intent of this file is to test the 4 allowed spread methods for linear and radial gradients.\n        The 4 values (pad, reflect, repeat and default) are available for both types of gradients.\n        On the left side are the linear gradient results, and on the right, the radial results.\n        The UA should render a result equivalent to the reference image.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>Run the test. No interaction required.</p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>The test passes if the rendered image matches the reference image, except\n      for any differences in font choice due to CSS2.</p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: pservers-grad-14-b.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <defs>\n      <linearGradient id="lgSpreadPad" gradientUnits="userSpaceOnUse" y1="0" x1="50" y2="0" x2="100" spreadMethod="pad">\n        <stop offset="000%" stop-color="black"/>\n        <stop offset="100%" stop-color="gold"/>\n      </linearGradient>\n\n      <linearGradient id="lgSpreadReflect" gradientUnits="userSpaceOnUse" y1="0" x1="50" y2="0" x2="100" spreadMethod="reflect">\n        <stop offset="000%" stop-color="black"/>\n        <stop offset="100%" stop-color="gold"/>\n      </linearGradient>\n\n      <linearGradient id="lgSpreadRepeat" gradientUnits="userSpaceOnUse" y1="0" x1="50" y2="0" x2="100" spreadMethod="repeat">\n        <stop offset="000%" stop-color="black"/>\n        <stop offset="100%" stop-color="gold"/>\n      </linearGradient>\n\n      <linearGradient id="lgSpreadDefault" gradientUnits="userSpaceOnUse" y1="0" x1="50" y2="0" x2="100">\n        <stop offset="000%" stop-color="black"/>\n        <stop offset="100%" stop-color="gold"/>\n      </linearGradient>\n\n      <radialGradient id="rgSpreadPad" gradientUnits="objectBoundingBox" cx="0.5" cy="0.5" r="0.2" spreadMethod="pad">\n        <stop offset="000%" stop-color="black"/>\n        <stop offset="100%" stop-color="gold"/>\n      </radialGradient>\n\n      <radialGradient id="rgSpreadReflect" gradientUnits="objectBoundingBox" cx="0.5" cy="0.5" r="0.2" spreadMethod="reflect">\n        <stop offset="000%" stop-color="black"/>\n        <stop offset="100%" stop-color="gold"/>\n      </radialGradient>\n\n      <radialGradient id="rgSpreadRepeat" gradientUnits="objectBoundingBox" cx="0.5" cy="0.5" r="0.2" spreadMethod="repeat">\n        <stop offset="000%" stop-color="black"/>\n        <stop offset="100%" stop-color="gold"/>\n      </radialGradient>\n\n      <radialGradient id="rgSpreadDefault" gradientUnits="objectBoundingBox" cx="0.5" cy="0.5" r="0.2">\n        <stop offset="000%" stop-color="black"/>\n        <stop offset="100%" stop-color="gold"/>\n      </radialGradient>\n    </defs>\n\n    <text font-size="20" x="240" y="30" text-anchor="middle">Gradient \'spreadMethod\' values</text>\n\n    <rect x="10" y="060" width="225" height="40" fill="url(#lgSpreadPad)" stroke="none"/>\n    <text font-size="16" x="10" y="55">spreadMethod="pad"</text>\n\n    <rect x="10" y="130" width="225" height="40" fill="url(#lgSpreadReflect)" stroke="none"/>\n    <text font-size="16" x="10" y="125">spreadMethod="reflect"</text>\n\n    <rect x="10" y="200" width="225" height="40" fill="url(#lgSpreadRepeat)" stroke="none"/>\n    <text font-size="16" x="10" y="195">spreadMethod="repeat"</text>\n\n    <rect x="10" y="270" width="225" height="40" fill="url(#lgSpreadDefault)" stroke="none"/>\n    <text font-size="16" x="10" y="265">spreadMethod="default"</text>\n\n\n    <rect x="245" y="060" width="225" height="40" fill="url(#rgSpreadPad)" stroke="none"/>\n    <text font-size="16" x="245" y="55">spreadMethod="pad"</text>\n\n    <rect x="245" y="130" width="225" height="40" fill="url(#rgSpreadReflect)" stroke="none"/>\n    <text font-size="16" x="245" y="125">spreadMethod="reflect"</text>\n\n    <rect x="245" y="200" width="225" height="40" fill="url(#rgSpreadRepeat)" stroke="none"/>\n    <text font-size="16" x="245" y="195">spreadMethod="repeat"</text>\n\n    <rect x="245" y="270" width="225" height="40" fill="url(#rgSpreadDefault)" stroke="none"/>\n    <text font-size="16" x="245" y="265">spreadMethod="default"</text>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.5 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'pservers-grad-15-b.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="CL" author="CN" status="accepted"\n    version="$Revision: 1.6 $" testname="$RCSfile: pservers-grad-15-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/pservers.html#Gradients">\n        <p>\n          Test linear and radial gradient defaults. Includes\n          testing defaults for linear grad x1,y1,y2 = 0%, x2 = 100%.\n          and testing defaults for radial grad cx,cy,r = 50%, fx,fy = cx,cy.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">      \n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The top rectangle must be blue at the lefthand side and fuchsia at the right\n        hand side, fading smoothly accross. The lower rectangle must be fuchsia at\n        the edges with a black centre to the radial gradient at the centre of the\n        rectangle, and the gradient occupying the whole rectangle.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: pservers-grad-15-b.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <!-- Test defaults for linear grad x1,y1,y2 = 0%, x2 = 100%. -->\n    <linearGradient id="defs1" gradientUnits="objectBoundingBox">\n      <stop stop-color="blue" offset="0"/>\n      <stop stop-color="fuchsia" offset="1"/>\n    </linearGradient>\n    <!-- Test defaults for radial grad cx,cy,r = 50%, fx,fy = cx,cy. -->\n    <radialGradient id="defs2" gradientUnits="objectBoundingBox">\n      <stop stop-color="black" offset="0"/>\n      <stop stop-color="fuchsia" offset="1"/>\n    </radialGradient>\n\n    <rect x="20" y="20" width="440" height="80" fill="url(#defs1)"/>\n    <rect x="20" y="150" width="440" height="80" fill="url(#defs2)"/>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.6 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'pservers-grad-16-b.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="CL" author="CN" status="accepted"\n    version="$Revision: 1.5 $" testname="$RCSfile: pservers-grad-16-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/pservers.html#Gradients">\n        <p>\n          Test gradient stop rules. Including:\n          No stops, like fill = none.\n          One stop, like fill = black.\n          If a stop less than all previous stops, it is set equal to the largest stop.\n          If two stops are equal the last stop controls the color at the overlap point.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        [[\n        Describe how to use the here. The instructions should specify any\n        steps requied to run the test or any manual operation that need\n        to be performed to run the test.\n        ]]\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The top rectangle must have a pink outline and no fill. The middle rectangle must have a\n        solid black fill. The lower rectangle must have a yellow to pink to green\n        linear gradient on the left-hand half and a solid blue fill for the right hand half.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: pservers-grad-16-b.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <!-- No stops, like fill = none -->\n    <linearGradient id="defs1" gradientUnits="objectBoundingBox" x1="0" y1="0" x2="1" y2="0">\n    </linearGradient>\n    <!-- One stop, like fill = black -->\n    <linearGradient id="defs2" gradientUnits="objectBoundingBox" x1="0" y1="0" x2="1" y2="0">\n      <stop stop-color="black" offset="1"/>\n    </linearGradient>\n    <!-- If a stop less than all previous stops, it is set equal to the largest stop-->\n    <!-- This also tests if two stops are equal the last stop controls the color at the overlap point-->\n    <linearGradient id="defs3" gradientUnits="objectBoundingBox" x1="0" y1="0" x2="1" y2="0">\n      <stop stop-color="yellow" offset="0"/>\n      <stop stop-color="#f48" offset=".25"/>\n      <stop stop-color="green" offset=".5"/>\n      <stop stop-color="blue" offset=".1"/>\n    </linearGradient>\n\n    <rect x="20" y="10" width="440" height="80" fill="url(#defs1)" stroke="#f48"/>\n    <rect x="20" y="110" width="440" height="80" fill="url(#defs2)"/>\n    <rect x="20" y="210" width="440" height="80" fill="url(#defs3)"/>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.5 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'pservers-grad-17-b.svg', svg: '<svg version="1.1" baseProfile="basic" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="AE" author="ED" status="accepted"\n    version="$Revision: 1.4 $" testname="$RCSfile: pservers-grad-17-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/pservers.html#Gradients">\n        <p>\n          This test has a gradient with gradientUnits=\'objectBoundingBox\' which is a fade from black to white.\n          The gradient is used for the stroke of a line. Vertical and horizontal lines don\'t have a boundingbox,\n          since they are one-dimensional, even though the\n          stroke-width makes it look like they should have a boundingbox with non-zero width and height.\n          See the coordinate chapter, last paragraph of 7.11.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        [[\n        Describe how to use the here. The instructions should specify any\n        steps requied to run the test or any manual operation that need\n        to be performed to run the test.\n        ]]\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The left rectangle has four \'line\' elements rotated in different ways. The stroke for the lines have a green solid stroke fallback which\n        should be used if the gradient should be ignored. For this sub-test to pass there must be three lines with solid green stroke, and one line\n        (from bottom left to top right) with a gradient stroke, visible in the rectangle.\n      </p>\n      <p>\n        The right rectangle is the same as the left rectangle except that the stroke paintservers don\'t have a fallback specified.\n        For this sub-test to pass only the line from bottom left to top right must be visible in the rectangle, and it must have a gradient stroke.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: pservers-grad-17-b.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <defs>\n      <linearGradient id="grad">\n        <stop offset="0" stop-color="black"/>\n        <stop offset="1" stop-color="white"/>\n      </linearGradient>\n    </defs>\n\n    <!-- sub-test 1: stroke with solid color fallback -->\n    <g transform="translate(50, 100) scale(0.3)">\n      <line x1="0" y1="180" x2="480" y2="180" stroke="url(#grad) #0f0" stroke-width="20"/>\n      <line x1="0" y1="180" x2="480" y2="180" stroke="url(#grad) #0f0" stroke-width="20" transform="rotate(45 240 180)"/>\n      <line x1="0" y1="180" x2="480" y2="180" stroke="url(#grad) #0f0" stroke-width="20" transform="rotate(90 240 180)"/>\n      <line x1="410" y1="10" x2="70" y2="350" stroke="url(#grad) #0f0" stroke-width="20"/>\n      <rect x="0" y="-60" width="480" height="480" fill="none" stroke="black"/>\n    </g>\n    <text x="120" y="250" text-anchor="middle">With fallback</text>\n\n    <!-- sub-test 2: stroke without a fallback -->\n    <g transform="translate(280,100) scale(0.3)">\n      <line x1="0" y1="180" x2="480" y2="180" stroke="url(#grad)" stroke-width="20"/>\n      <line x1="0" y1="180" x2="480" y2="180" stroke="url(#grad)" stroke-width="20" transform="rotate(45 240 180)"/>\n      <line x1="0" y1="180" x2="480" y2="180" stroke="url(#grad)" stroke-width="20" transform="rotate(90 240 180)"/>\n      <line x1="410" y1="10" x2="70" y2="350" stroke="url(#grad)" stroke-width="20"/>\n      <rect x="0" y="-60" width="480" height="480" fill="none" stroke="black"/>\n    </g>\n    <text x="350" y="250" text-anchor="middle">Without fallback</text>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.4 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'pservers-grad-18-b.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="ED" author="CC" status="accepted"\n    version="$Revision: 1.5 $" testname="$RCSfile: pservers-grad-18-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/pservers.html#Gradients">\n        <p>\n          This test shows rectangles filled with gradient.\n          Several gradients are defined, with two stops:\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">      \n      <p>\n        For the top-left rectangle\'s gradient:\n        The first stop defines a fully-opaque green color.\n        The second stop explicitly inherits (i.e. using the \'inherit\' keyword) its stop-color.        \n      </p>\n      <p>\n        For the top-right rectangle\'s gradient:\n        The first stop defines a fully-opaque green color.\n        The second stop defines a green stop-color but explicitly inherits (i.e. using the \'inherit\' keyword) the stop-opacity.        \n      </p>\n      <p>\n        For the bottom-left rectangle\'s gradient:\n        The first stop defines a fully-opaque green color.\n        The second stop does not specify the stop-color and the stop-opacity.\n        Since both properties are not inherited, the initial value should be used.        \n      </p>\n      <p>\n        For the bottom-right rectangle\'s gradient:\n        The first stop defines a fully-opaque green color.\n        The second stop specifies the stop-color using the \'currentColor\' keyword.        \n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The result should be:\n      </p>\n      <p>\n        The top-left rectangle is filled with a gradient from green to pink since\n        the stop-color is inherited from the location of the gradient definition.\n      </p>\n      <p>\n        The top-right rectangle filled in green with a gradient opacity.\n      </p>\n      <p>\n        The lower-left rectangle filled with a gradient going from fully-opaque green to fully-opaque black.\n      </p>\n      <p>\n        The lower-right rectangle filled with a gradient going from fully-opaque green to fully-opaque yellow.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: pservers-grad-18-b.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <g id="g0" stop-color="#f48" stop-opacity="0.5" color="yellow">\n      <linearGradient id="MyGradient1" stop-color="inherit">\n        <stop offset="0" stop-color="green" stop-opacity="1"/>\n        <stop offset="1" stop-color="inherit" stop-opacity="1"/>\n      </linearGradient>\n      <linearGradient id="MyGradient2" stop-opacity="inherit">\n        <stop offset="0" stop-color="green" stop-opacity="1"/>\n        <stop offset="1" stop-color="green" stop-opacity="inherit"/>\n      </linearGradient>\n      <linearGradient id="MyGradient3">\n        <stop offset="0" stop-color="green" stop-opacity="1"/>\n        <stop offset="1"/>\n      </linearGradient>\n      <linearGradient id="MyGradient4">\n        <stop offset="0" stop-color="green" stop-opacity="1"/>\n        <stop offset="1" stop-color="currentColor" stop-opacity="1"/>\n      </linearGradient>\n    </g>\n    <g id="g1" stop-color="blue">\n      <rect id="r1" fill="url(#MyGradient1)" width="100" height="100" x="50" y="50"/>\n    </g>\n    <g id="g2" stop-opacity="1">\n      <rect id="r2" fill="url(#MyGradient2)" width="100" height="100" x="200" y="50"/>\n    </g>\n    <g id="g3" stop-opacity="1" stop-color="blue">\n      <rect id="r3" fill="url(#MyGradient3)" width="100" height="100" x="50" y="200"/>\n    </g>\n    <g id="g4" color="blue">\n      <rect id="r4" fill="url(#MyGradient4)" width="100" height="100" x="200" y="200"/>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.5 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'pservers-grad-20-b.svg', svg: '<svg id="svg-root" width="100%" height="100%" \n  viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg" \n  xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="AG" author="ED" status="accepted"\n    version="$Revision: 1.7 $" testname="$RCSfile: pservers-grad-20-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/animate.html#InterfaceSVGAnimationElement">\n        <p>\n          This test has a gradient with gradientUnits=\'objectBoundingBox\' which is a fade from black to white.\n          The gradient is used for the stroke of a line. Vertical and horizontal lines don\'t have a boundingbox, since they are one-dimensional, even though the\n          stroke-width makes it look like they should have a boundingbox with non-zero width and height.\n          See the coordinate chapter, last paragraph of 7.11.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The left rectangle has four \'line\' elements rotated in different ways. The stroke for the lines have a green solid stroke fallback which\n        should be used if the gradient should be ignored.\n\n        The right rectangle is the same as the left rectangle except that the stroke paintservers don\'t have a fallback specified.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The test is passed if\n      </p>\n      <ul>\n        <li>\n          there are three lines with solid green stroke, and one line\n          (from bottom left to top right) with a gradient stroke, visible in the left rectangle.\n        </li>\n        <li>there is a line from bottom left to top right with a gradient stroke, visible in the right rectangle.</li>\n      </ul>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: pservers-grad-20-b.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <defs>\n      <linearGradient id="grad">\n        <stop offset="0" stop-color="black" />\n        <stop offset="1" stop-color="white" />\n      </linearGradient>\n    </defs>\n    \n    <!-- sub-test 1: stroke with solid color fallback -->\n    <g transform="translate(50, 100) scale(0.3)">\n      <path d="M0 180L480 180" stroke="url(#grad) #0f0" stroke-width="20"/>\n      <path d="M0 180L480 180" stroke="url(#grad) #0f0" stroke-width="20" transform="rotate(45 240 180)"/>\n      <path d="M0 180L480 180" stroke="url(#grad) #0f0" stroke-width="20" transform="rotate(90 240 180)"/>\n      <path d="M410 10L70 350" stroke="url(#grad) #0f0" stroke-width="20"/>\n      <rect x="0" y="-60" width="480" height="480" fill="none" stroke="black"/>\n    </g>\n    <text x="120" y="250" text-anchor="middle">With fallback</text>\n    \n    <!-- sub-test 2: stroke without a fallback -->\n    <g transform="translate(280,100) scale(0.3)">\n      <path d="M0 180L480 180"	stroke="url(#grad)" stroke-width="20"/>\n      <path d="M0 180L480 180" stroke="url(#grad)" stroke-width="20" transform="rotate(45 240 180)"/>\n      <path d="M0 180L480 180" stroke="url(#grad)" stroke-width="20" transform="rotate(90 240 180)"/>\n      <path d="M410 10L70 350" stroke="url(#grad)" stroke-width="20"/>\n      <rect x="0" y="-60" width="480" height="480" fill="none" stroke="black"/>\n    </g>\n    <text x="350" y="250" text-anchor="middle">Without fallback</text>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n  <text id="revision" x="10" y="340" stroke="none" \n    fill="black">$Revision: 1.7 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240" \n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'pservers-grad-21-b.svg', svg: '<svg id="svg-root" width="100%" height="100%" \n  viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg" \n  xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="AG" author="ED" status="accepted"\n    version="$Revision: 1.4 $" testname="$RCSfile: pservers-grad-21-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/pservers.html#Gradients">\n      <p>\n        Test the inheritance of radial gradient attributes. The test has six ellipses with blue stroke, each filled\n        with two gradients. \n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The test has passed if:\n      </p>\n      <ul>\n        <li>the gradient fills don\'t extend outside the blue ellipses</li>\n        <li>the gradient fills in the left column exactly match the corresponding reference gradient fills in the right column</li>\n      </ul>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: pservers-grad-21-b.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <defs>\n      <radialGradient id="grad1" cx="100%" r="20%">\n        <stop offset="0" stop-color="black" />\n        <stop offset="1" stop-opacity="0"/>\n      </radialGradient>\n      <radialGradient id="grad2" xlink:href="#grad1" cx="0%"/>\n      <radialGradient id="grad3" cx="100%" r="20%" fx="0%">\n        <stop offset="0" stop-color="black" />\n        <stop offset="1" stop-opacity="0"/>\n      </radialGradient>\n      <radialGradient id="grad4" xlink:href="#grad3" cx="0%"/>\n      <radialGradient id="grad5" cx="100%" r="20%" fx="25%">\n        <stop offset="0" stop-color="black" />\n        <stop offset="1" stop-opacity="0"/>\n      </radialGradient>\n      <radialGradient id="grad6" xlink:href="#grad5" cx="0%"/>\n      \n      <radialGradient id="grad1-ref" cx="100%" r="20%">\n        <stop offset="0" stop-color="black" />\n        <stop offset="1" stop-opacity="0"/>\n      </radialGradient>\n      <radialGradient id="grad2-ref" cx="0%" r="20%">\n        <stop offset="0" stop-color="black" />\n        <stop offset="1" stop-opacity="0"/>\n      </radialGradient>\n      <radialGradient id="grad3-ref" cx="100%" r="20%" fx="0%">\n        <stop offset="0" stop-color="black" />\n        <stop offset="1" stop-opacity="0"/>\n      </radialGradient>\n      <radialGradient id="grad4-ref" cx="0%" r="20%" fx="0%">\n        <stop offset="0" stop-color="black" />\n        <stop offset="1" stop-opacity="0"/>\n      </radialGradient>\n      <radialGradient id="grad5-ref" cx="100%" r="20%" fx="25%">\n        <stop offset="0" stop-color="black" />\n        <stop offset="1" stop-opacity="0"/>\n      </radialGradient>\n      <radialGradient id="grad6-ref" cx="0%" r="20%" fx="25%">\n        <stop offset="0" stop-color="black" />\n        <stop offset="1" stop-opacity="0"/>\n      </radialGradient>\n    </defs>\n    \n    <g transform="translate(100 60)">\n      <!-- first line of tests -->\n      <rect fill="url(#grad1)" x="-60" width="120" height="90"/>\n      <rect fill="url(#grad2)" x="60" width="120" height="90"/>\n      <ellipse cx="60" cy="45" rx="24" ry="18" fill="none" stroke="blue"/>\n\n      <!-- reference for first line -->\n      <g transform="translate(100 0)">\n        <rect fill="url(#grad1-ref)" x="-60" width="120" height="90"/>\n        <rect fill="url(#grad2-ref)" x="60" width="120" height="90"/>\n        <ellipse cx="60" cy="45" rx="24" ry="18" fill="none" stroke="blue"/>\n      </g>\n\n      <!-- second line of tests -->\n      <g transform="translate(0 50)">\n        <rect fill="url(#grad3)" x="-60" width="120" height="90"/>\n        <rect fill="url(#grad4)" x="60" width="120" height="90"/>\n        <ellipse cx="60" cy="45" rx="24" ry="18" fill="none" stroke="blue"/>\n      </g>\n      \n      <!-- reference for second line -->\n      <g transform="translate(100 50)">\n        <rect fill="url(#grad3-ref)" x="-60" width="120" height="90"/>\n        <rect fill="url(#grad4-ref)" x="60" width="120" height="90"/>\n        <ellipse cx="60" cy="45" rx="24" ry="18" fill="none" stroke="blue"/>\n      </g>\n\n      <!-- third line of tests -->\n      <g transform="translate(0 100)">\n        <rect fill="url(#grad5)" x="-60" width="120" height="90"/>\n        <rect fill="url(#grad6)" x="60" width="120" height="90"/>\n        <ellipse cx="60" cy="45" rx="24" ry="18" fill="none" stroke="blue"/>\n      </g>\n      \n      <!-- reference for third line -->\n      <g transform="translate(100 100)">\n        <rect fill="url(#grad5-ref)" x="-60" width="120" height="90"/>\n        <rect fill="url(#grad6-ref)" x="60" width="120" height="90"/>\n        <ellipse cx="60" cy="45" rx="24" ry="18" fill="none" stroke="blue"/>\n      </g>\n      \n      <rect x="120" y="20" width="80" height="200" fill="none" stroke="green"/>\n      <text y="200" x="160" text-anchor="middle" font-size="12">Reference</text> \n    </g>\n    \n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n  <text id="revision" x="10" y="340" stroke="none" \n    fill="black">$Revision: 1.4 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240" \n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'pservers-grad-22-b.svg', svg: '<svg id="svg-root" width="100%" height="100%"\n  viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg"\n  xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="ED" author="AG" status="accepted"\n    version="$Revision: 1.4 $" testname="$RCSfile: pservers-grad-22-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://dev.w3.org/SVG/profiles/1.1F2/master/pservers.html#Gradients">\n      <p>\n        Tests that transforms affect the rendering of a gradient.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n   </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The test passes if each of the two gradient-filled rectangles\n        towards the top of the test slide is identical to the one below it.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: pservers-grad-22-b.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <defs>\n      <linearGradient id="g1" x1="0" y1="0" x2="400" y2="50" gradientUnits="userSpaceOnUse" >\n        <stop offset="0" stop-color="blue"/>\n        <stop offset="0.5" stop-color="yellow"/>\n        <stop offset="1.0" stop-color="blue"/>\n      </linearGradient>\n\n      <linearGradient id="g2" x1="0" y1="0" x2="200" y2="12.5" gradientUnits="userSpaceOnUse">\n        <stop offset="0" stop-color="blue"/>\n        <stop offset="0.5" stop-color="yellow"/>\n        <stop offset="1.0" stop-color="blue"/>\n      </linearGradient>\n\n      <linearGradient id="g3" x1="0" y1="0" x2="400" y2="50" gradientUnits="userSpaceOnUse" gradientTransform="rotate(-37) scale(0.89 1)">\n        <stop offset="0" stop-color="blue"/>\n        <stop offset="0.5" stop-color="yellow"/>\n        <stop offset="1.0" stop-color="blue"/>\n      </linearGradient>\n\n      <linearGradient id="g4" x1="0" y1="0" x2="200" y2="12.5" gradientUnits="userSpaceOnUse" gradientTransform="rotate(-20)">\n        <stop offset="0" stop-color="blue"/>\n        <stop offset="0.5" stop-color="yellow"/>\n        <stop offset="1.0" stop-color="blue"/>\n      </linearGradient>\n    </defs>\n\n    <g transform="translate(20,50)">\n      <g transform="scale(0.5,1)">\n        <rect width="400" height="50" fill="url(#g1)" />\n      </g>\n    </g>\n\n    <g transform="translate(20,120)">\n      <rect width="200" height="50" fill="url(#g2)" />\n    </g>\n\n    <g transform="translate(250,80)">\n      <rect width="400" height="50" fill="url(#g3)" transform="scale(0.5,1)"/>\n    </g>\n\n    <g transform="translate(250,150)">\n      <rect width="200" height="50" fill="url(#g4)" />\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.4 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'pservers-grad-23-f.svg', svg: '<svg id="svg-root" width="100%" height="100%" viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/" template-version="1.4" reviewer="[reviewer]" author="Microsoft" status="created" version="$Revision: 1.3 $" testname="$RCSfile: pservers-grad-23-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://dev.w3.org/SVG/profiles/1.1F2/publish/pservers.html#Gradients">\n      <p>\n        <!--[[\n        Properties do not inherit from elements referencing \'linearGradient\' or \'radialGradient\' elements.\n        ]]-->\n      </p>\n      <p>\n        <!--[[\n        Specify a \'stop-color\' attribute equal to \'red\' on a \'g\' element ancestor of a \'rect\' element. Specify a \'linearGradient\' with a single \n        \'stop\' that has a \'stop-color\' of \'inherit\'. Reference the \'linearGradient\' from the \'rect\' element and verify that the \'rect\' is not red. \n        Repeat the same process with a sibling \'rect\' element referencing a \'radialGradient\' element.\n        ]]-->\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required\n      </p>\n      <p>\n        <!--[[\n        \n        ]]-->\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        <!--[[\n        Test passes if there is no red visible on the page.\n        ]]-->\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: pservers-grad-23-f.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-size="18">\n    <defs>\n        <linearGradient id="testLinear" stop-color="inherit">\n            <stop offset="100%" stop-color="inherit" />\n        </linearGradient>\n        <radialGradient id="testRadial" stop-color="inherit">\n            <stop offset="100%" stop-color="inherit" />\n        </radialGradient>\n    </defs>\n    <g stop-color="red">\n        <rect x="30" y="30" width="100" height="100" fill="url(#testLinear)" stop-color="inherit" />\n        <rect x="150" y="30" width="100" height="100" fill="url(#testRadial)" stop-color="inherit" />\n    </g>\n    \n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.3 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>\n</svg>'},
  {name: 'pservers-grad-24-f.svg', svg: '<svg id="svg-root" width="100%" height="100%" viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/" template-version="1.4" reviewer="CM" author="Microsoft" status="reviewed" version="$Revision: 1.3 $" testname="$RCSfile: pservers-grad-24-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://dev.w3.org/SVG/profiles/1.1F2/publish/pservers.html#Gradients">\n      <p>\n        Test that the \'linearGradient\' and \'radialGradient\' elements are neither rendered directly nor via the \'use\' element.\n      </p>\n      <p>\n        The test defines \'linearGradient\' and \'radialGradient\' elements with a red \'stop\' and references them from a \'use\' element. \'linearGradient\'\n        and \'radialGradient\' elements with a red \'stop\' are also specified outside of a \'defs\' tag as if they were regular graphical elements.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>Run the test. No interaction required.</p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Test passes if there is no red visible on the page.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: pservers-grad-24-f.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <defs>\n        <linearGradient id="testLinear">\n            <stop offset="100%" stop-color="red" />\n        </linearGradient>\n        <radialGradient id="testRadial">\n            <stop offset="100%" stop-color="red" />\n        </radialGradient>\n    </defs>\n    <text x="10" y="50">There should be no red.</text>\n    <use x="0" y="0" xlink:href="url(#testLinear)" />\n    <use x="0" y="150" xlink:href="url(#testRadial)" />\n    <linearGradient x1="0" x2="100" y1="150" y2="250">\n        <stop offset="100%" stop-color="red" />\n    </linearGradient>\n    <radialGradient cx="200" cy="300" r="50" fx="200" fy="300">\n        <stop offset="100%" stop-color="red" />\n    </radialGradient>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.3 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>\n</svg>\n'},
  {name: 'pservers-grad-stops-01-f.svg', svg: '<svg id="svg-root" width="100%" height="100%" viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/" template-version="1.4" reviewer="CM" author="Microsoft" status="reviewed" version="$Revision: 1.3 $" testname="$RCSfile: pservers-grad-stops-01-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG/pservers.html#GradientStops">\n      <p>\n        Test that gradient offset values less than zero are rounded up to zero and values more than one are rounded down to one.\n      </p>\n      <p>\n        The test defines four gradients, each with a single stop where the \'stop-color\' is set to \'blue\'.\n        The four gradients have \'offset\' set to \'-1\', \'-1%\', \'101%\' and \'2\'.  Four rectangles reference\n        the gradients.  All of these should render as if they have plain blue fills.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>Run the test. No interaction required.</p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The test passed if there are four blue boxes on the page.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: pservers-grad-stops-01-f.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <defs>\n        <linearGradient id="gradient1">\n            <stop offset="-1" stop-color="blue" />\n        </linearGradient>\n        <linearGradient id="gradient2">\n            <stop offset="-1%" stop-color="blue" />\n        </linearGradient>\n        <linearGradient id="gradient3">\n            <stop offset="2" stop-color="blue" />\n        </linearGradient>\n        <linearGradient id="gradient4">\n            <stop offset="101%" stop-color="blue" />\n        </linearGradient>\n    </defs>\n    <rect fill="url(#gradient1)" stroke="black" stroke-width="5" x="10" y="10" width="100" height="100" />\n    <rect fill="url(#gradient2)" stroke="black" stroke-width="5" x="120" y="10" width="100" height="100" />\n    <rect fill="url(#gradient3)" stroke="black" stroke-width="5" x="10" y="120" width="100" height="100" />\n    <rect fill="url(#gradient4)" stroke="black" stroke-width="5" x="120" y="120" width="100" height="100" />\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.3 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>\n</svg>\n'},
  {name: 'pservers-pattern-01-b.svg', svg: '<svg version="1.1" baseProfile="basic" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Haroon Sheikh" status="accepted"\n    version="$Revision: 1.6 $" testname="$RCSfile: pservers-pattern-01-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/pservers.html#Patterns">\n        <p>\n          Test that the viewer has basic capability to handle patterns\n          on fills and stroke of objects and text.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\nRun the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        From top-down the appearance of objects is as follows.\n      </p>\n      <p>\n        The top rectangle should be filled with a pattern composed of a green\n        rectangle on top of yellow rectangle. A default stroke has been applied to the original\n        rectangle to see the boundary of the rectangle.\n      </p>\n      <p>\n        The next rectangle has no fill, but has a thick stroke on which the pattern is\n        applied. The pattern consists of 4 colored rectangles.\n      </p>\n      <p>\n        The next item is a text with a pattern on the fill. The pattern appears as\n        alternating rows of orange and green.\n      </p>\n      <p>\n        The last item is a text with a 2 user unit stroke on which a pattern is applied.\n        The pattern appears as alternating columns of maroon and blue.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: pservers-pattern-01-b.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <!-- ====================================================================== -->\n    <!-- Rectangle with a pattern fill                                 ======== -->\n    <!-- ====================================================================== -->\n    <pattern patternUnits="userSpaceOnUse" id="pat1" x="10" y="10" width="20" height="20">\n      <rect x="5" y="5" width="10" height="10" fill="yellow"/>\n      <rect x="10" y="10" width="10" height="10" fill="green"/>\n    </pattern>\n    <rect x="25" y="10" width="430" height="60" stroke="black" fill="url(#pat1)"/>\n    <text font-family="Arial" font-size="12" x="25" y="85">Pattern created using yellow and green rectangles applied to fill of rectangle</text>\n    <!-- ====================================================================== -->\n    <!-- Rectangle with a pattern on the stroke                        ======== -->\n    <!-- ====================================================================== -->\n    <pattern patternUnits="userSpaceOnUse" id="pat2" x="0" y="0" width="20" height="20">\n      <rect x="0" y="0" width="10" height="10" fill="maroon"/>\n      <rect x="10" y="0" width="10" height="10" fill="green"/>\n      <rect x="0" y="10" width="10" height="10" fill="blue"/>\n      <rect x="10" y="10" width="10" height="10" fill="yellow"/>\n    </pattern>\n    <rect x="35" y="110" width="410" height="40" fill="none" stroke="url(#pat2)" stroke-width="20"/>\n    <text font-family="Arial" font-size="12" x="25" y="175">Pattern of 4 rectangles applied to a stroke of a rectangle.</text>\n    <!-- ====================================================================== -->\n    <!-- Pattern filled text                                           ======== -->\n    <!-- ====================================================================== -->\n    <pattern patternUnits="userSpaceOnUse" id="pat3" x="0" y="0" width="10" height="20">\n      <rect x="0" y="0" width="10" height="10" fill="orange"/>\n      <rect x="0" y="10" width="10" height="10" fill="green"/>\n    </pattern>\n    <text font-family="Arial" font-size="50" fill="url(#pat3)" x="25" y="220">Pattern on fill</text>\n    <text font-family="Arial" font-size="12" x="25" y="235">Pattern consists of orange and green rows</text>\n    <!-- ====================================================================== -->\n    <!-- Pattern on stroke of text                                     ======== -->\n    <!-- ====================================================================== -->\n    <pattern patternUnits="userSpaceOnUse" id="pat4" x="0" y="0" width="20" height="10">\n      <rect x="0" y="0" width="10" height="10" fill="maroon"/>\n      <rect x="10" y="0" width="10" height="10" fill="blue"/>\n    </pattern>\n    <text font-family="Arial" font-size="40" fill="none" stroke="url(#pat4)" stroke-width="2" x="25" y="275">Pattern on stroke</text>\n    <text font-family="Arial" font-size="12" x="25" y="290">Pattern consists of maroon and blue columns</text>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.6 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'pservers-pattern-02-f.svg', svg: '<svg id="svg-root" width="100%" height="100%"\n  viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg"\n  xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="CM" author="ED" status="accepted"\n    version="$Revision: 1.3 $" testname="$RCSfile: pservers-pattern-02-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/pservers.html#PatternElement">\n      <p>\n        Test that the \'patternTransform\' attribute has an effect on the \'pattern\' element.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The test is passed if the testframe is filled with a blue and white\n        diamond pattern.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: pservers-pattern-02-f.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <defs>\n      <pattern id="pattern" viewBox="0 0 100 100" patternTransform="rotate(45)" height="0.1" width="0.1">\n        <rect y="50" width="50" height="50" fill="blue"/>\n        <rect x="50" width="50" height="50" fill="blue"/>\n      </pattern>\n    </defs>\n    <rect fill="url(#pattern)" width="480" height="480"/>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.3 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'pservers-pattern-03-f.svg', svg: '<svg id="svg-root" width="100%" height="100%"\n  viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg"\n  xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="[reviewer]" author="ED" status="created"\n    version="$Revision: 1.1 $" testname="$RCSfile: pservers-pattern-03-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/pservers.html#Patterns">\n      <p>\n        Test that empty patterns are not rendered, and that the fallback color is used instead.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The test is passed if there are 8 green rectangles visible, and no red.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: pservers-pattern-03-f.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n\n    <defs>\n      <pattern id="invisible1">\n        <rect width="100%" height="100%" fill="red"/>\n      </pattern>\n      <pattern id="invisible2" patternUnits="objectBoundingBox" patternContentUnits="objectBoundingBox">\n        <rect width="100%" height="100%" fill="red"/>\n      </pattern>\n      <pattern id="invisible3" width="0" height="0" patternUnits="objectBoundingBox" patternContentUnits="objectBoundingBox">\n        <rect width="1" height="1" fill="red"/>\n      </pattern>\n      <pattern id="invisible4" width="0" patternUnits="objectBoundingBox" patternContentUnits="objectBoundingBox">\n        <rect width="1" height="1" fill="red"/>\n      </pattern>\n      <pattern id="invisible5" width="0" height="0" patternUnits="userSpaceOnUse" patternContentUnits="objectBoundingBox">\n        <rect width="1" height="1" fill="red"/>\n      </pattern>\n      <pattern id="invisible6" height="0" patternUnits="userSpaceOnUse" patternContentUnits="objectBoundingBox">\n        <rect width="1" height="1" fill="red"/>\n      </pattern>\n      <pattern id="invisible7" height="0" patternUnits="userSpaceOnUse" patternContentUnits="userSpaceOnUse">\n        <rect width="100%" height="100%" fill="red"/>\n      </pattern>\n    </defs>\n\n    <g transform="translate(40 60)" stroke="black">\n      <rect width="100" height="100" fill="url(#invisible1) lime"/>\n      <rect x="100" width="100" height="100" fill="url(#invisible2) lime"/>\n      <rect x="200" width="100" height="100" fill="url(#invisible3) lime"/>\n      <rect x="300" width="100" height="100" fill="url(#invisible4) lime"/>\n\n      <rect y="100" width="100" height="100" fill="url(#invisible5) lime"/>\n      <rect x="100" y="100" width="100" height="100" fill="url(#invisible6) lime"/>\n      <rect x="200" y="100" width="100" height="100" fill="url(#invisible7) lime"/>\n      \n      <!-- note that this is on purpose testing a broken uri -->\n      <rect x="300" y="100" width="100" height="100" fill="url(#invisible8) lime"/>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.1 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>\n</svg>\n'},
  {name: 'pservers-pattern-04-f.svg', svg: '<svg id="svg-root" width="100%" height="100%"\n  viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg"\n  xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="ED" author="Microsoft" status="accepted"\n    version="$Revision: 1.3 $" testname="$RCSfile: pservers-pattern-04-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/pservers.html#Patterns">\n      <p>\n        Inherited attributes from a referenced \'pattern\' are not applied if they are already defined on the referencing \'pattern\' element.\n      </p>\n      <p>\n        Define a pattern \'pattern1\' with circles that have red fill. Inherit \'pattern1\' into \'pattern2\' and add circles at different \'y\'\n        attribute and with \'fill\' set to \'lime\' on \'pattern2\'. Reference \'pattern1\' from a square using \'fill\' attribute. Reference \'pattern2\'\n        from a different square using \'fill\' attribute. Position the second square directly over the first square.  Verify that there is green visible.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The test is passed if there are four green circles visible on the page, and no red.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: pservers-pattern-04-f.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <defs>\n        <pattern id="pattern1" patternUnits="userSpaceOnUse" x="0" y="0" width="100" height="100" viewBox="0 0 10 10" >\n            <circle cx="5" cy="5" r="1.9" fill="red" />\n        </pattern>\n        <pattern id="pattern2" xlink:href="#pattern1" y="30">\n            <circle cx="5" cy="2" r="2" fill="lime" />\n        </pattern>\n    </defs>\n    <rect fill="url(#pattern1)" stroke="none" x="1" y="1" width="200" height="200" />\n    <rect fill="url(#pattern2)" stroke="none" x="1" y="1" width="200" height="200" />\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.3 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>\n  -->\n</svg>\n'},
  {name: 'pservers-pattern-05-f.svg', svg: '<svg id="svg-root" width="100%" height="100%" viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/" template-version="1.4" reviewer="CM" author="Microsoft" status="reviewed" version="$Revision: 1.3 $" testname="$RCSfile: pservers-pattern-05-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG/pservers.html#Patterns">\n      <p>\n        Test that a \'pattern\' element can inherit attributes through multiple levels of\n        \'xlink:href\' referencing.\n      </p>\n      <p>\n        The test defines a pattern \'pattern1\' with some attributes that scale the contents. The attributes on\n        \'pattern1\' are inherited into \'pattern2\' and then inherited from \'pattern2\'\n        into \'pattern3\'.  \'pattern3\' has a green circle as its graphical content.\n        A \'rect\' uses \'pattern3\' as its fill, if the attributes are correctly inherited into\n        \'pattern3\', then the green circle will occlude a red circle in the same position.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>Run the test. No interaction required.</p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The test passed if there is no red visible on the page.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: pservers-pattern-05-f.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <defs>\n        <pattern id="Pattern1" patternUnits="userSpaceOnUse" width="100" height="100" viewBox="0 0 10 10" />\n        <pattern id="Pattern2" xlink:href="#Pattern1" />\n        <pattern id="Pattern3" xlink:href="#Pattern2">\n            <circle cx="5" cy="5" r="2" fill="green"/>\n        </pattern>\n    </defs>\n    <circle cx="50" cy="50" r="20" fill="red" />\n    <rect fill="url(#Pattern3)" width="100" height="100" />\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.3 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>\n</svg>\n'},
  {name: 'pservers-pattern-06-f.svg', svg: '<svg id="svg-root" width="100%" height="100%" viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/" template-version="1.4" reviewer="[reviewer]" author="Microsoft" status="created" version="$Revision: 1.2 $" testname="$RCSfile: pservers-pattern-06-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG/pservers.html#Patterns">\n      <p>\n        <!--[[\n        The \'pattern\' element is neither rendered directly nor via the \'use\' element.\n        ]]-->\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        <!--[[\n        Define a \'pattern\' element with a red \'rect\' and reference it from a \'use\' element. Also specify one \'pattern\' elements with a red \'rect\'\n        outside of a \'defs\' tag. Verify there is no red on the page.\n        ]]-->\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        <!--[[\n        Test passes if there is no red visible on the page.\n        ]]-->\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: pservers-pattern-06-f.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <defs>\n        <pattern id="testPattern" patternUnits="userSpaceOnUse" x="0" y="0" width="100" height="100" viewBox="0 0 10 10" >\n            <rect x="5" y="5" width="10" height="10" fill="red" />\n        </pattern>\n    </defs>\n    <use x="100" y="100" xlink:href="url(#testPattern)" />\n    <pattern patternUnits="userSpaceOnUse" x="10" y="10" width="20" height="20">\n        <rect x="5" y="5" width="10" height="10" fill="red" />\n    </pattern>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.2 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>\n</svg>\n'},
  {name: 'pservers-pattern-07-f.svg', svg: '<svg id="svg-root" width="100%" height="100%"\n  viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg"\n  xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="CM" author="ED" status="reviewed"\n    version="$Revision: 1.2 $" testname="$RCSfile: pservers-pattern-07-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/pservers.html#Patterns">\n      <p>\n        Test that an invalid xlink:href on a \'pattern\' element has no effect on the pattern.\n        The pattern dimensions and coordinate-system are defined completely on the pattern that has the invalid xlink:href,\n        to test that they\'re not overridden by the non-existant pattern that is referenced.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The test is passed if there are four green circles visible on the page.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: pservers-pattern-07-f.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <defs>\n        <pattern id="pattern1" patternUnits="userSpaceOnUse" x="0" y="0" width="100" height="100" viewBox="0 0 10 10">\n            <circle cx="5" cy="5" r="1.7" fill="red" />\n        </pattern>\n        <pattern id="pattern2" xlink:href="#invalidlink" patternUnits="userSpaceOnUse" x="0" y="0" width="100" height="100" viewBox="0 0 10 10">\n            <circle cx="5" cy="5" r="2" fill="lime" />\n        </pattern>\n    </defs>\n    <rect fill="url(#pattern1)" stroke="none" x="1" y="1" width="200" height="200" />\n    <rect fill="url(#pattern2)" stroke="none" x="1" y="1" width="200" height="200" />\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.2 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>\n</svg>\n'},
  {name: 'pservers-pattern-08-f.svg', svg: '<svg id="svg-root" width="100%" height="100%"\n  viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg"\n  xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="CM" author="ED" status="reviewed"\n    version="$Revision: 1.2 $" testname="$RCSfile: pservers-pattern-08-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/pservers.html#Patterns">\n      <p>\n        Test that an invalid xlink:href on a \'pattern\' element has no effect on the pattern.\n        This test specifies only \'width\' and \'height\' on the pattern that is tested in order to catch \n        incorrectly overridden values from a non-existant pattern. The result is tested\n        with a reference pattern using slightly different syntax.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The test is passed if there are four green circles visible on the page, and no red.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: pservers-pattern-08-f.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <defs>\n        <pattern id="pattern1" patternUnits="userSpaceOnUse" x="0" y="0" width="100" height="100" viewBox="0 0 10 10">\n            <circle cx="5" cy="5" r="1.7" fill="red" />\n        </pattern>\n        <pattern id="pattern2" xlink:href="#invalidlink" width="0.5" height="0.5">\n            <circle cx="50" cy="50" r="20" fill="lime" />\n        </pattern>\n    </defs>\n    <rect fill="url(#pattern1)" stroke="none" x="1" y="1" width="200" height="200" />\n    <rect fill="url(#pattern2)" stroke="none" x="1" y="1" width="200" height="200" />\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.2 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>\n</svg>\n'},
  {name: 'pservers-pattern-09-f.svg', svg: '<svg id="svg-root" width="100%" height="100%"\n  viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg"\n  xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="[reviewer]" author="ED" status="created"\n    version="$Revision: 1.1 $" testname="$RCSfile: pservers-pattern-09-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/pservers.html#Patterns">\n      <p>\n        Test that an invalid xlink:href on a \'pattern\' element has no effect on the pattern, and that the\n        pattern isn\'t rendered since the default \'width\' and \'height\' is 0.\n        A subtest that explicitly specifies \'width\' and \'height\' as 0 is added as a reference. \n        Both of these cases should result in the fallback color being used.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The test is passed if there is a green rectangle visible on the page, and no red.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: pservers-pattern-09-f.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <defs>\n        <pattern id="pattern1" patternUnits="userSpaceOnUse" x="0" y="0" width="100" height="100" viewBox="0 0 10 10">\n            <circle cx="5" cy="5" r="1.7" fill="red" />\n        </pattern>\n        <pattern id="pattern2" xlink:href="#invalidlink">\n            <circle cx="50" cy="50" r="20" fill="red" />\n        </pattern>\n        <pattern id="pattern3" patternUnits="userSpaceOnUse" x="0" y="0" width="0" height="0" viewBox="0 0 10 10">\n            <circle cx="5" cy="5" r="1.7" fill="red" />\n        </pattern>\n    </defs>\n    <rect fill="url(#pattern1)" stroke="none" x="1" y="1" width="200" height="200" />\n    <rect fill="url(#pattern2) lime" stroke="none" x="1" y="1" width="200" height="200" />\n    <rect fill="url(#pattern3) lime" stroke="none" x="201" y="1" width="200" height="200" />\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.1 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>\n</svg>\n'},
  {name: 'render-elems-01-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Vincent Hardy" status="accepted"\n    version="$Revision: 1.6 $" testname="$RCSfile: render-elems-01-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/render.html#Elements">\n        <p>\n          Verifies that shapes can be filled.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">            \n      <p>\nRun the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        There is one pair of octagons.  These are filled.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: render-elems-01-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <!-- ====================================================================== -->\n    <!-- First, fill shape with two different colors                            -->\n    <!-- ====================================================================== -->\n    <g transform="translate(30, 80)">\n      <g fill="green">\n        <path d="M60,0 l60,0 l60,60 l0,60 l-60,60 l-60,0 l-60,-60 l0,-60 z"/>\n      </g>\n      <g fill="black" transform="translate(200, 0)">\n        <path d="M60,0 l60,0 l60,60 l0,60 l-60,60 l-60,0 l-60,-60 l0,-60 z"/>\n      </g>\n      <text x="130" y="-30" font-size="28">Shape fill</text>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.6 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'render-elems-02-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Vincent Hardy" status="accepted"\n    version="$Revision: 1.6 $" testname="$RCSfile: render-elems-02-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/render.html#Elements">\n        <p>\n          Verifies that shapes can be stroked.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">            \n      <p>\nRun the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        There is one pair of octagons.  These are stroked.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: render-elems-02-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <!-- ====================================================================== -->\n    <!-- Now, stroke shape with two different stroke width and color            -->\n    <!-- ====================================================================== -->\n    <g transform="translate(30, 80)">\n      <g fill="none" stroke="green" stroke-width="3">\n        <path d="M60,0 l60,0 l60,60 l0,60 l-60,60 l-60,0 l-60,-60 l0,-60 z"/>\n      </g>\n      <g fill="none" stroke="black" stroke-width="9" transform="translate(200, 0)">\n        <path d="M60,0 l60,0 l60,60 l0,60 l-60,60 l-60,0 l-60,-60 l0,-60 z"/>\n      </g>\n      <text x="110" y="-30" font-size="28">Shape stroke</text>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.6 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'render-elems-03-t.svg', svg: '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" baseProfile="tiny" id="svg-root" width="100%" height="100%" viewBox="0 0 480 360">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/" template-version="1.4" reviewer="SVGWG" author="Vincent Hardy" status="accepted" version="$Revision: 1.7 $" testname="$RCSfile: render-elems-03-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/render.html#Elements">\n        <p>\n          Verifies that shapes can be filled, stroked and the order of filling and stroking.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">      \n      <p>\nRun the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        There is one pair of octagons. These are filled plus stroked.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: render-elems-03-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <!-- ====================================================================== -->\n    <!-- Now, fill and stroke. The fill should happen first                     -->\n    <!-- ====================================================================== -->\n    <g transform="translate(30, 80)">\n      <g fill="yellow" stroke="green" stroke-width="8"><path d="M60,0 l60,0 l60,60 l0,60 l-60,60 l-60,0 l-60,-60 l0,-60 z"/></g>\n      <g stroke="black" fill="blue" stroke-width="8" transform="translate(200, 0)"><path d="M60,0 l60,0 l60,60 l0,60 l-60,60 l-60,0 l-60,-60 l0,-60 z"/></g>\n      <text x="70" y="-30" font-size="28">Shape fill and stroke</text>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.7 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>'},
  {name: 'render-elems-06-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Vincent Hardy" status="accepted"\n    version="$Revision: 1.9 $" testname="$RCSfile: render-elems-06-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/render.html#Elements">\n        <p>\n          Verifies that text can be filled. \n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">      \n      <p>\nRun the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\nThe\n          test shows two \'G\' characters that are filled \n          (green to the left, and with navy to the right) and not stroked.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: render-elems-06-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <defs >\n      <font-face font-family="Blocky" unicode-range="U+0-7F">\n        <font-face-src>\n          <font-face-uri xlink:href="../resources/Blocky.svg#Blocky"/>\n        </font-face-src>\n      </font-face>\n       <style type="text/css">\n          @font-face {\n             font-family: BlockyWoff;\n             src: url(woffs/Blocky.woff) format("woff");\n        </style>\n    </defs>\n    <!-- ====================================================================== -->\n    <!-- First, fill text with two different colors                             -->\n    <!-- ====================================================================== -->\n    <text x="180" y="40" font-size="30">Text fill</text>\n    <g font-size="300" font-family="Blocky, BlockyWoff">\n      <text x="60" y="280" fill="green">G</text>\n      <text x="260" y="280" fill="navy">G</text>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.9 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'render-elems-07-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Vincent Hardy" status="accepted"\n    version="$Revision: 1.9 $" testname="$RCSfile: render-elems-07-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/render.html#Elements">\n        <p>\n          Verifies that text can be stroked. The\n          \n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">      \n      <p>\nRun the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n   The test shows two characters that are stroked and not filled.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: render-elems-07-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n        <defs>\n      <font-face font-family="Blocky" unicode-range="U+0-7F">\n        <font-face-src>\n          <font-face-uri xlink:href="../resources/Blocky.svg#Blocky"/>\n        </font-face-src>\n      </font-face>\n       <style type="text/css">\n          @font-face {\n             font-family: BlockyWoff;\n             src: url(woffs/Blocky.woff) format("woff");\n        </style>\n    </defs>\n    <!-- ====================================================================== -->\n    <!-- Now, stroke text with two different stroke width and color             -->\n    <!-- ====================================================================== -->\n    <text x="180" y="40" font-size="30">Text stroke</text>\n    <g font-size="300" font-family="Blocky, BlockyWoff">\n      <text x="60" y="280" fill="none" stroke="green" stroke-width="12">G</text>\n      <text x="260" y="280" fill="none" stroke="navy" stroke-width="12">G</text>\n    </g>\n    <text id="revision" x="10" y="340" font-size="40" stroke="none" fill="black">$Revision: 1.9 $</text>\n    <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  </g>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'render-elems-08-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Vincent Hardy" status="accepted"\n    version="$Revision: 1.10 $" testname="$RCSfile: render-elems-08-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/render.html#Elements">\n        <p>\n          Verifies that text can be stroked.\n          \n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">      \n      <p>\nRun the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n       The test shows two \'G\' characters that are both stroked and filled.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: render-elems-08-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <defs>\n      <font-face font-family="Blocky" unicode-range="U+0-7F">\n        <font-face-src>\n          <font-face-uri xlink:href="../resources/Blocky.svg#Blocky"/>\n        </font-face-src>\n      </font-face>\n       <style type="text/css">\n          @font-face {\n             font-family: BlockyWoff;\n             src: url(woffs/Blocky.woff) format("woff");\n        </style>\n    </defs>\n    <!-- ====================================================================== -->\n    <!-- Now, fill and stroke. The fill should happen first                     -->\n    <!-- ====================================================================== -->\n    <text x="120" y="40" font-size="30">Text fill and stroke</text>\n    <g font-size="300" font-family="Blocky, BlockyWoff">\n      <text x="60" y="280" fill="#2f8" stroke="green" stroke-width="12">G</text>\n      <text x="260" y="280" fill="#e9a" stroke="navy" stroke-width="12">G</text>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.10 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'render-groups-01-b.svg', svg: '<svg version="1.1" baseProfile="basic" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Vincent Hardy" status="accepted"\n    version="$Revision: 1.9 $" testname="$RCSfile: render-groups-01-b.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/render.html#Grouping">\n        <p>\n          Verifies implicit rendering order (paragraph 3.3) and grouping mechanism (paragraphs 3.4).\n          It also validates basic Shape, Image and text rendering.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">            \n      <p>\nRun the test. No interaction required.\n      </p>\n      <p>\n        The rendered image should match the reference image exactly.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        This test renders 3  elements: a text string "SVG", then\n        a shape, then an image. Because of their definition order and coordinates, the image\n        should be on top of the rectangle and the rectangle on top of the text. The\n        test validates that groups are conceptually rendered offscreen before being\n        rendered on the canvas. This is done by grouping the same overlapping objects and\n        rendering the group at half opacity. The background pattern (vertical stripes) should\n        show through all the group elements. However, none of the "SVG" text string should show through the\n        rectangle and none of the rectangle should show through the image.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: render-groups-01-b.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <defs>\n      <font horiz-adv-x="313">\n        <!-- Converted from Larabie Anglepoise by Batik ttf2svg -->\n        <font-face font-family="s-larabie-anglepoise" units-per-em="1000" panose-1="0 0 4 0 0 0 0 0 0 0" ascent="703" descent="-300" alphabetic="0"/>\n        <missing-glyph horiz-adv-x="500" d="M63 0V700H438V0H63ZM125 63H375V638H125V63Z"/>\n        <glyph unicode="S" glyph-name="S" horiz-adv-x="385" d="M371 1H29V144H264Q264 151 264 166Q265 180 265 188Q265 212 249 212H132Q83 212 55 247Q29 279 29 329V566H335V422H136V375Q136 360 144 356Q148 355 168 355H279Q327 355 352 309Q371 273 371 221V1Z"/>\n        <glyph unicode="V" glyph-name="V" horiz-adv-x="351" d="M365 563L183 -33L0 563H101L183 296L270 563H365Z"/>\n        <glyph unicode="G" glyph-name="G" horiz-adv-x="367" d="M355 1H18V564H355V420H125V144H248V211H156V355H355V1Z"/>\n        <hkern g1="V" g2="G" k="-40"/>\n      </font>\n      <style type="text/css">\n        @font-face {\n          font-family: anglepoise;\n          src: url(woffs/anglepoi.woff) format("woff");\n        }\n      </style>\n    </defs>\n    <!-- ====================================================================== -->\n    <!--  3 overlapping elements in a group with opacity    -->\n    <!-- ====================================================================== -->\n    <g transform="scale(1.8, 1.8)">\n      <!-- Background pattern -->\n      <rect x="20" y="10" width="230" height="155" fill="rgb(192, 192, 192)"/>\n      <line x1="40" y1="10" x2="40" y2="175" stroke="white" stroke-width="15"/>\n      <line x1="70" y1="10" x2="70" y2="175" stroke="white" stroke-width="15"/>\n      <line x1="100" y1="10" x2="100" y2="175" stroke="white" stroke-width="15"/>\n      <line x1="130" y1="10" x2="130" y2="175" stroke="white" stroke-width="15"/>\n      <line x1="160" y1="10" x2="160" y2="175" stroke="white" stroke-width="15"/>\n      <line x1="190" y1="10" x2="190" y2="175" stroke="white" stroke-width="15"/>\n      <line x1="220" y1="10" x2="220" y2="175" stroke="white" stroke-width="15"/>\n      <line x1="250" y1="10" x2="250" y2="175" stroke="white" stroke-width="15"/>\n      <rect x="20" y="10" width="230" height="155" fill="none" stroke="black"/>\n      <!-- The following group, as a whole, should be rendered with a .5 opacity -->\n      <!-- Conceptually, this means that the object is contains are first        -->\n      <!-- rendered offscreen. Then, the offscreen is painted on the canvas with -->\n      <!-- half opacity.                                                         -->\n      <g opacity="0.5">\n        <!-- The following text, rectangle and image are drawn, fully opaque, in -->\n        <!-- the order they are defined. Therefore, none of the \'A\' under the    -->\n        <!-- rectangle should show. Neither should any of the rectangle under    -->\n        <!-- the image.                                                          -->\n        <text font-family="s-larabie-anglepoise, anglepoise" font-size="120" x="30" y="90">SVG</text>\n        <rect x="70" y="55" width="130" height="70" fill="rgb(130, 0, 50)"/>\n        <image x="162" y="75" width="80" height="80" xlink:href="' + Images['sign.png'] + '"/>\n      </g>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.9 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'render-groups-03-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Vincent Hardy" status="accepted"\n    version="$Revision: 1.9 $" testname="$RCSfile: render-groups-03-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/render.html#Grouping">\n        <p>\n          Verifies implicit rendering order (paragraph 3.3) and grouping mechanism (paragraphs 3.4).\n          It also validates basic Shape, Image and text rendering.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">            \n      <p>\nRun the test. No interaction required.\n      </p>\n      <p>\n        The rendered image should match the reference image exactly.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        This test renders 3  elements: a text string "SVG", then\n        a shape, then an image. Because of their definition order and coordinates, the image\n        should be on top of the rectangle and the rectangle on top of the text. None\n        of the "SVG" text string should show through the\n        rectangle and none of the rectangle should show through the image.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: render-groups-03-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <defs>\n      <font horiz-adv-x="313">\n        <!-- Converted from Larabie Anglepoise by Batik ttf2svg -->\n        <font-face font-family="s-larabie-anglepoise" units-per-em="1000" panose-1="0 0 4 0 0 0 0 0 0 0" ascent="703" descent="-300" alphabetic="0"/>\n        <missing-glyph horiz-adv-x="500" d="M63 0V700H438V0H63ZM125 63H375V638H125V63Z"/>\n        <glyph unicode="S" glyph-name="S" horiz-adv-x="385" d="M371 1H29V144H264Q264 151 264 166Q265 180 265 188Q265 212 249 212H132Q83 212 55 247Q29 279 29 329V566H335V422H136V375Q136 360 144 356Q148 355 168 355H279Q327 355 352 309Q371 273 371 221V1Z"/>\n        <glyph unicode="V" glyph-name="V" horiz-adv-x="351" d="M365 563L183 -33L0 563H101L183 296L270 563H365Z"/>\n        <glyph unicode="G" glyph-name="G" horiz-adv-x="367" d="M355 1H18V564H355V420H125V144H248V211H156V355H355V1Z"/>\n        <hkern g1="V" g2="G" k="-40"/>\n      </font>\n      <style type="text/css">\n        @font-face {\n          font-family: anglepoise;\n          src: url(woffs/anglepoi.woff) format("woff");\n        }\n      </style>\n    </defs>\n    <!-- ====================================================================== -->\n    <!--  3 overlapping elements in a group with opacity    -->\n    <!-- ====================================================================== -->\n    <g transform="scale(1.8, 1.8)">\n      <!-- Background pattern -->\n      <rect x="20" y="10" width="230" height="155" fill="rgb(192, 192, 192)"/>\n      <line x1="40" y1="10" x2="40" y2="175" stroke="white" stroke-width="15"/>\n      <line x1="70" y1="10" x2="70" y2="175" stroke="white" stroke-width="15"/>\n      <line x1="100" y1="10" x2="100" y2="175" stroke="white" stroke-width="15"/>\n      <line x1="130" y1="10" x2="130" y2="175" stroke="white" stroke-width="15"/>\n      <line x1="160" y1="10" x2="160" y2="175" stroke="white" stroke-width="15"/>\n      <line x1="190" y1="10" x2="190" y2="175" stroke="white" stroke-width="15"/>\n      <line x1="220" y1="10" x2="220" y2="175" stroke="white" stroke-width="15"/>\n      <line x1="250" y1="10" x2="250" y2="175" stroke="white" stroke-width="15"/>\n      <rect x="20" y="10" width="230" height="155" fill="none" stroke="black"/>\n      <!-- The following text, rectangle and image are drawn, fully opaque, in -->\n      <!-- the order they are defined. Therefore, none of the \'A\' under the    -->\n      <!-- rectangle should show. Neither should any of the rectangle under    -->\n      <!-- the image.                                                          -->\n      <text font-family="s-larabie-anglepoise, anglepoise" font-size="120" x="30" y="90">SVG</text>\n      <rect x="70" y="55" width="130" height="70" fill="rgb(130, 0, 50)"/>\n      <image x="162" y="75" width="80" height="80" xlink:href="' + Images['sign.png'] + '"/>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.9 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'shapes-circle-01-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Lofton Henderson" status="accepted"\n    version="$Revision: 1.7 $" testname="$RCSfile: shapes-circle-01-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/shapes.html#CircleElement">\n        <p>\nTests the circle element\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\nRun the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Six circles are displayed, with position, size, fill and stroke matching the reference image\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: shapes-circle-01-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <circle cx="100" cy="100" r="50" fill="none" stroke="black"/>\n    <circle cx="220" cy="100" r="35" fill="green" stroke="black"/>\n    <circle cx="340" cy="100" r="20" fill="black" stroke="lime" stroke-width="4"/>\n    <circle cx="100" cy="260" r="20" stroke="lime" fill="yellow" stroke-width="4"/>\n    <circle cx="220" cy="260" r="35" stroke="none" fill="blue"/>\n    <circle cx="340" cy="260" r="50" stroke="green" fill="none" stroke-width="10"/>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.7 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'shapes-circle-02-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="DJ" author="CN" status="accepted"\n    version="$Revision: 1.5 $" testname="$RCSfile: shapes-circle-02-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/shapes.html#CircleElement">\n        <p>\n          Default attributes test with circle.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The test is passed if a group of four circles is displayed, arranged as shown in the reference image.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: shapes-circle-02-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <g fill="green" stroke="#000000">\n      <!-- Set cx and cy coordinate to default.-->\n      <circle r="50"/>\n\n      <!-- Set cx coordinate to default.-->\n      <circle cy="100" r="50"/>\n\n      <!-- Set cy coordinate to default.-->\n      <circle cx="100" r="50"/>\n\n      <!-- Set r attribute to 0 (should not display a circle).-->\n      <circle cx="100" cy="100" r="0"/>\n\n      <!-- Set all values to draw a circle -->\n      <circle cx="100" cy="100" r="50"/>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.5 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'shapes-ellipse-01-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Kelvin R" status="accepted"\n    version="$Revision: 1.7 $" testname="$RCSfile: shapes-ellipse-01-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/shapes.html#EllipseElement">\n        <p>\n          Test the ellipse element.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\nRun the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n          Seven ellipses are displayed, with position, size, fill and stroke matching the reference image\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: shapes-ellipse-01-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <!-- ====================================================================== -->\n    <!-- First pair of ellipses.                                                -->\n    <!-- ====================================================================== -->\n    <ellipse id="ellipse-01" fill="none" stroke="#000000" cx="50" cy="75" rx="30" ry="50"/>\n    <ellipse id="ellipse-02" fill="green" cx="160" cy="75" rx="30" ry="50"/>\n    <!-- ====================================================================== -->\n    <!-- Second pair of ellipses, should actually draw circles.                 -->\n    <!-- ====================================================================== -->\n    <ellipse id="ellipse-03" fill="none" stroke="#000000" cx="270" cy="80" rx="35" ry="35"/>\n    <ellipse id="ellipse-04" fill="green" cx="370" cy="80" rx="35" ry="35"/>\n    <!-- ====================================================================== -->\n    <!-- Third pair of ellipses.                                                -->\n    <!-- ====================================================================== -->\n    <ellipse id="ellipse-05" fill="none" stroke="#0000FF" stroke-width="8" cx="50" cy="220" rx="30" ry="50"/>\n    <ellipse id="ellipse-06" fill="#00FF00" stroke="#0000FF" stroke-width="8" cx="160" cy="220" rx="30" ry="50"/>\n    <!-- ====================================================================== -->\n    <!-- Fourth pair of ellipses.                                               -->\n    <!-- ====================================================================== -->\n    <ellipse id="ellipse-07" fill="#00FF00" stroke="#0000FF" stroke-width="8" cx="330" cy="220" rx="70" ry="40"/>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.7 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'shapes-ellipse-02-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="DJ" author="CN" status="accepted"\n    version="$Revision: 1.6 $" testname="$RCSfile: shapes-ellipse-02-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/shapes.html#EllipseElement">\n      <p>\n        Defaults test with ellipse.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>Run the test. No interaction required.</p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>The test passes if one blue ellipse is shown completely within the test slide,\n      and a quarter ellipse is shown in the top-left corner of the test slide.</p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: shapes-ellipse-02-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <g fill="blue" stroke="#000000">\n      <!-- Set cx and cy coordinate to default.-->\n      <ellipse rx="100" ry="50"/>\n\n      <!-- Set rx attribute to 0.-->\n      <ellipse cx="100" cy="150" rx="0" ry="50"/>\n\n      <!-- Set ry attribute to 0.-->\n      <ellipse cx="200" cy="50" rx="100" ry="0"/>\n\n      <!-- Set all values attribute to drawn an ellipse.-->\n      <ellipse cx="250" cy="250" rx="100" ry="50"/>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.6 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'shapes-ellipse-03-f.svg', svg: '<svg id="svg-root" width="100%" height="100%"\n  viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg"\n  xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="ED" author="Microsoft" status="accepted"\n    version="$Revision: 1.5 $" testname="$RCSfile: shapes-ellipse-03-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/shapes.html#EllipseElement">\n      <p>\n        The \'ellipse\' element defines an ellipse which is axis-aligned with the current user coordinate system when it is not the initial user coordinate system.\n      </p>\n      <p>\n        The test shows an \'ellipse\' element originating at (0,0) of the current user coordinate system, which has been altered via \'transform\' from\n        the initial user coordinate system. Two perpendicular lines which also originate at (0,0) and advance along the x and y axes of \n        the current user coordinate system are shown. These lines overlap the top and left edges of the ellipse and verifies that the ellipse is \n        thus axis-aligned with its current user coordinate system.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The test is passed if both ellipses are divided into four equal parts by two sets of crossing lines, and the rightmost ellipse and crossing lines are rotated together. \n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: shapes-ellipse-03-f.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n\n    <g transform="translate(150,150)">\n        <line x1="0" y1="-100" x2="0" y2="100" stroke="black" />\n        <line x1="-100" y1="0" x2="100" y2="0" stroke="black" />\n        <ellipse  cx="0" cy="0" rx="80" ry="50" fill="none" stroke="black" />\n    </g>\n\n    <g transform="translate(350,150) rotate(-30)">\n        <line x1="0" y1="-100" x2="0" y2="100" stroke="black" />\n        <line x1="-100" y1="0" x2="100" y2="0" stroke="black" />\n        <ellipse  cx="0" cy="0" rx="80" ry="50" fill="none" stroke="black" />\n    </g>\n\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.5 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved \n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g> -->\n</svg>\n'},
  {name: 'shapes-grammar-01-f.svg', svg: '<svg id="svg-root" width="100%" height="100%"\n  viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg"\n  xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="ED" author="CL" status="accepted"\n    version="$Revision: 1.2 $" testname="$RCSfile: shapes-grammar-01-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/shapes.html#PointsBNF">\n      <p>\nCheck that negative second coordinate in a coordinate pair does not need separating wsp-comma.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\nThe test is passed if each shape seems to have a double stroke, dark green and light green.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: shapes-grammar-01-f.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n\n    <g transform="translate(0,400)">\n        <g stroke="#070" stroke-width="8">  \n            <polyline fill="#396" \n                points="270,-225 300,-245 320,-225 340,-245 280,-280                   \n                390,-280 420,-240 280,-185"/>\n            <polygon fill="#5F9"    \n                points="179,-185,218,-203,228,-245,202,-279,159,-280,131,-247,139,-205"/>\n        </g>\n        <g stroke="#3C6" stroke-width="3" fill="none">\n           <polyline \n                points="270-225 300-245 320-225 340-245 280-280                   \n                390-280 420-240 280-185"/>\n            <polygon     \n                points="179-185,218-203,228-245,202-279,159-280,131-247,139-205"/>\n        </g>\n    </g>\n\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.2 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'shapes-intro-01-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="CN" author="SH" status="accepted"\n    version="$Revision: 1.5 $" testname="$RCSfile: shapes-intro-01-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/shapes.html#Introduction">\n        <p>\n          Tests the degenerate cases of the basic shapes.  The shapes are positioned\n          within the black rectangles.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>Run the test. No interaction required.</p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>The test passes if the 11 rectangles are empty.</p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: shapes-intro-01-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <!-- ====================================================================== -->\n    <!-- Draw the boxes to contain the shapes and the text labels for the boxes -->\n    <!-- ====================================================================== -->\n    <g fill="none" stroke="#000000">\n      <!-- rects -->\n      <rect x="50" y="50" width="35" height="60"/>\n      <rect x="50" y="155" width="35" height="60"/>\n      <rect x="130" y="50" width="35" height="60"/>\n      <rect x="130" y="155" width="35" height="60"/>\n\n      <!-- circles -->\n      <rect x="210" y="50" width="60" height="60"/>\n      <rect x="210" y="155" width="60" height="60"/>\n\n      <!-- ellipses -->\n      <rect x="315" y="50" width="35" height="60"/>\n      <rect x="315" y="155" width="35" height="60"/>\n      <rect x="394" y="50" width="35" height="60"/>\n      <rect x="394" y="155" width="35" height="60"/>\n\n      <!-- line -->\n      <rect x="235" y="260" width="10" height="10"/>\n    </g>\n\n    <g font-family="Arial" font-size="8">\n      <text x="5" y="90">Stroked</text>\n      <text x="5" y="195">Unstroked</text>\n      <text x="50" y="135">Zero width rect</text>\n      <text x="130" y="135">Zero height rect</text>\n      <text x="210" y="135">Zero radius circle</text>\n      <text x="315" y="135">Zero x radius ellipse</text>\n      <text x="394" y="135">Zero y radius ellipse</text>\n      <text x="235" y="290">Zero length line</text>\n    </g>\n    <!-- ====================================================================== -->\n    <!-- Draw 4 rectangles, two with zero width, two with zero height           -->\n    <!-- (stroked and unstroked)                                                -->\n    <!-- ====================================================================== -->\n    <rect id="Zero-width-stroked-rect" fill="none" stroke="#000000" x="55" y="55" width="0" height="50"/>\n    <rect id="Zero-width-unstroked-rect" fill="#FF0000" stroke="none" x="55" y="160" width="0" height="50"/>\n    <rect id="Zero-height-stroked-rect" fill="#00FF00" stroke="#0000FF" x="135" y="55" width="25" height="0"/>\n    <rect id="Zero-height-rect" fill="#00FF00" stroke="none" x="135" y="160" width="25" height="0"/>\n    <!-- ====================================================================== -->\n    <!-- Draw two zero radius circles (stroked and unstroked)                   -->\n    <!-- ====================================================================== -->\n    <circle id="Zero-radius-stroked-circle" fill="none" stroke="#000000" cx="240" cy="80" r="0"/>\n    <circle id="Zero-radius-unstroked-circle" fill="#FF0000" stroke="none" cx="240" cy="185" r="0"/>\n    <!-- ====================================================================== -->\n    <!-- Draw 4 ellipses, two with a zero x radius, two with a zero y radius    -->\n    <!-- (stroked and unstroked)                                                -->\n    <!-- ====================================================================== -->\n    <ellipse id="Zero-x-radius-stroked-ellipse" fill="#00FF00" stroke="#0000FF" cx="332" cy="80" rx="0" ry="25"/>\n    <ellipse id="Zero-x-radius-unstroked-ellipse" fill="#00FF00" stroke="none" cx="332" cy="185" rx="0" ry="25"/>\n    <ellipse id="Zero-y-radius-stroked-ellipse" fill="none" stroke="#000000" cx="411" cy="80" rx="12" ry="0"/>\n    <ellipse id="Zero-y-radius-unstroked-ellipse" fill="#FF0000" stroke="none" cx="411" cy="185" rx="12" ry="0"/>\n    <!-- ====================================================================== -->\n    <!-- Draw a zero-length line                                                -->\n    <!-- ====================================================================== -->\n    <line id="Zero-length-line" stroke="#0000FF" x1="240" y1="265" x2="240" y2="265"/>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.5 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'shapes-intro-02-f.svg', svg: '<svg id="svg-root" width="100%" height="100%"\n  viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg"\n  xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="ED" author="Microsoft" status="accepted"\n    version="$Revision: 1.3 $" testname="$RCSfile: shapes-intro-02-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/shapes.html#Introduction">\n      <p>\n        Test that basic shape elements are equivalent to a \'path\' element that constructs the same shape.\n      </p>\n      <p>\n        For each basic shape, a \'path\' reference element that is red is created.\n        A basic shape is then placed on top of the \'path\' element. \n        For each basic shape there\'s also a reverse test that uses the shape as a reference for the \'path\' element.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The test is passed if there is no red visible on the page.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: shapes-intro-02-f.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n\n    <path d="M35 25 L115 25 A 10 20 0 0 1 125 45 L 125 105 A 10 20 0 0 1 115 125 L 35 125 A 10 20 0 0 1 25 105 L 25 45 A 10 20 0 0 1 35 25" fill="red" />\n    <rect x="25" y="25" rx="10" ry="20" width="100" height="100" fill="black" />\n    <rect x="130" y="25" rx="10" ry="20" width="100" height="100" fill="red" />\n    <path d="M140 25 L220 25 A 10 20 0 0 1 230 45 L 230 105 A 10 20 0 0 1 220 125 L 140 125 A 10 20 0 0 1 130 105 L 130 45 A 10 20 0 0 1 140 25" fill="black" />\n\n    <path d="M300 125 A50 50 0 1 0 299.9999 125" fill="red" />\n    <circle cx="300" cy="75" r="50" fill="black" />\n    <circle cx="401" cy="75" r="50" fill="red" />\n    <path d="M401 125 A50 50 0 1 0 400.9999 125" fill="black" />\n\n    <path d="M60 305 A50 80 0 1 0 59.9999 305 Z" fill="red" />\n    <ellipse cx="60" cy="225" rx="50" ry="80" fill="black" />\n    <ellipse cx="161" cy="225" rx="50" ry="80" fill="red" />\n    <path d="M161 305 A50 80 0 1 0 160.9999 305 Z" fill="black" />\n\n    <path d="M220 150 L270 200 L220 250 Z" fill="red" />\n    <polygon points="220,150 270,200 220,250" fill="black" />\n    <polygon points="270,150 320,200 270,250" fill="red" />\n    <path d="M270 150 L320 200 L270 250 Z" fill="black" />\n\n    <path d="M350 250 L350 350 L400 350 L400 250 L450 250 L450 350" fill="none" stroke="red" stroke-width="10" />\n    <polyline fill="none" stroke="black" stroke-width="10" points="350,250 350,350 400,350 400,250 450,250 450,350" />\n    <polyline fill="none" stroke="red" stroke-width="10" points="350,135 350,235 400,235 400,135 450,135 450,235" />\n    <path d="M350 135 L350 235 L400 235 L400 135 L450 135 L450 235" fill="none" stroke="black" stroke-width="10" />\n\n    <path d="M225 275 L325 275" stroke-width="10" stroke="red" />\n    <line x1="225" y1="275" x2="325" y2="275" stroke-width="10" stroke="black" />\n    <line x1="225" y1="325" x2="325" y2="325" stroke-width="10" stroke="red" />\n    <path d="M225 325 L325 325" stroke-width="10" stroke="black" />\n\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.3 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved \n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g> -->\n</svg>\n'},
  {name: 'shapes-line-01-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="CL" author="Lofton Henderson" status="accepted"\n    version="$Revision: 1.5 $" testname="$RCSfile: shapes-line-01-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/shapes.html#LineElement">\n        <p>\nTests the line element.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\nRun the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\nThe test is passed if five diagonal lines are displayed on the top row. On the bottom row, a square wave pattern is displayed. The position, size, fill and stroke of the lines matches the reference image.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: shapes-line-01-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <g id="diagonal-line-set">\n      <line x1="37.5" y1="137" x2="112.5" y2="50" fill="none" stroke="black" stroke-width="1"/>\n      <line x1="112.5" y1="137" x2="187.5" y2="50" fill="none" stroke="yellow" stroke-width="5"/>\n      <line x1="187.5" y1="137" x2="262.5" y2="50" fill="none" stroke="green" stroke-width="7.5"/>\n      <line x1="262.5" y1="137" x2="337.5" y2="50" fill="none" stroke="blue" stroke-width="10"/>\n      <line x1="337.5" y1="137" x2="412.5" y2="50" fill="none" stroke="fuchsia" stroke-width="12.5"/>\n    </g>\n    <g id="middle-figure" stroke="black" stroke-width="1">\n      <line x1="170" y1="200" x2="220" y2="200"/>\n      <line x1="220" y1="200" x2="220" y2="250"/>\n      <line x1="220" y1="250" x2="270" y2="250"/>\n      <line x1="270" y1="250" x2="270" y2="200"/>\n      <line x1="270" y1="200" x2="320" y2="200"/>\n    </g>\n    <g id="lower-left-figure" stroke="blue" stroke-width="10">\n      <line x1="25" y1="200" x2="75" y2="200"/>\n      <line x1="75" y1="200" x2="75" y2="250"/>\n      <line x1="75" y1="250" x2="125" y2="250"/>\n      <line x1="125" y1="250" x2="125" y2="200"/>\n      <line x1="125" y1="200" x2="175" y2="200"/>\n    </g>\n    <g id="lower-right-figure" stroke-width="10">\n      <line x1="370" y1="250" x2="420" y2="250" stroke="black"/>\n      <line x1="420" y1="200" x2="470" y2="200" stroke="fuchsia"/>\n      <line x1="320" y1="200" x2="370" y2="200" stroke="blue"/>\n      <line x1="370" y1="200" x2="370" y2="250" stroke="green"/>\n      <line x1="420" y1="250" x2="420" y2="200" stroke="orange"/>\n    </g>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.5 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'shapes-line-02-f.svg', svg: '<svg id="svg-root" width="100%" height="100%"\n  viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg"\n  xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="CL" author="Microsoft" status="accepted"\n    version="$Revision: 1.3 $" testname="$RCSfile: shapes-line-02-f.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/shapes.html#LineElement">\n      <p>\n        The \'fill\' attribute has no effect on the \'line\' element.\n      </p>\n    </d:testDescription>    \n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Test passes if there is no red visible on the page.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: shapes-line-02-f.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n\n    <line x1="100" y1="100" x2="300" y2="100" stroke-width="10" stroke="black" fill="red" />\n    <line x1="100" y1="100" x2="300" y2="100" stroke-width="10" stroke="black" fill="red" transform="rotate(15)"/>\n\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.3 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>'},
  {name: 'shapes-polygon-01-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author="Kelvin R" status="accepted"\n    version="$Revision: 1.7 $" testname="$RCSfile: shapes-polygon-01-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/shapes.html#PolygonElement">\n      <p>\n        This test draws six different polygons excercising portions of the path attribute.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The six polygons drawn should match the reference image.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: shapes-polygon-01-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <!-- Test case label. -->\n    <!-- ====================================================================== -->\n    <!-- First two polygons, convex and "regular".                              -->\n    <!-- ====================================================================== -->\n    <!-- Open, convex, "regular". -->\n    <polygon id="polygon-01" fill="none" stroke="#000000" points="59,45,95,63,108,105,82,139,39,140,11,107,19,65"/>\n    <!-- Closed, convex, "regular". -->\n    <polygon id="polygon-02" fill="blue" points="179,45,218,63,228,105,202,139,159,140,131,107,139,65,179,45"/>\n    <!-- ====================================================================== -->\n    <!-- Third polygon, concave and irregular.                                  -->\n    <!-- ====================================================================== -->\n    <!-- Closed, convex, "irregular". -->\n    <polygon id="polygon-03" fill="blue" stroke="black" stroke-width="6" points="350,45 375,80 410,95 375,110 350,145 325,120 290,95 325,70,350,45"/>\n    <!-- ====================================================================== -->\n    <!-- Fourth and fifth polygons.                                             -->\n    <!-- ====================================================================== -->\n    <!-- Closed, convex, "regular". -->\n    <polygon id="polygon-05" fill="none" stroke="#0000FF" stroke-width="8" points="59,185,98,203,108,245,82,279,39,280,11,247,19,205,59,185"/>\n    <!-- Open, convex, "regular". -->\n    <polygon id="polygon-06" fill="#00FF00" stroke="#0000FF" stroke-width="8" points="179,185,218,203,228,245,202,279,159,280,131,247,139,205"/>\n    <!-- ====================================================================== -->\n    <!-- Sixth polygons, irregular with both concave and convex angles.         -->\n    <!-- ====================================================================== -->\n    <polygon id="polygon-07" fill="none" stroke="#00FF00" stroke-width="8" points="270,225 300,245 320,225 340,245 280,280                   390,280 420,240 280,185"/>\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.7 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'shapes-polygon-02-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="AG" author="CL" status="accepted"\n    version="$Revision: 1.2 $" testname="$RCSfile: shapes-polygon-02-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/shapes.html#PolygonElement">\n        <p>\nChecks that polygons and the equivalent paths are indeed equivalent.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\nThe test is passed if each shape seems to have a double stroke, dark green and light green.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: shapes-polygon-02-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n \n    <g stroke="#070" stroke-width="8">    \n    <polygon id="polygon-01" fill="none"\n        points="59,45,95,63,108,105,82,139,39,140,11,107,19,65"/>\n    <polygon id="polygon-02" fill="#592" \n        points="179,45,218,63,228,105,202,139,159,140,131,107,139,65,179,45"/>\n    <polygon id="polygon-03" fill="#3D8" \n        points="350,45 375,80 410,95 375,110 350,145 325,120 290,95 325,70,350,45"/>\n    <polygon id="polygon-05" fill="none"  \n        points="59,185,98,203,108,245,82,279,39,280,11,247,19,205,59,185"/>\n    <polygon id="polygon-06" fill="#5F9"    \n        points="179,185,218,203,228,245,202,279,159,280,131,247,139,205"/>\n    <polygon id="polygon-07" fill="none" \n       points="270,225 300,245 320,225 340,245 280,280                   \n       390,280 420,240 280,185"/>\n    </g>\n    <!-- now the equivalent paths-->\n    <g stroke="#3C6" stroke-width="3" fill="none">\n        <path d="M59,45 L95,63,108,105,82,139,39,140,11,107,19,65z"/>\n        <path d="M179,45 L218,63,228,105,202,139,159,140,131,107,139,65,179,45z"/>\n        <path d="M350,45 L375,80 410,95 375,110 350,145 325,120 290,95 325,70,350,45z"/>\n        <path d="M59,185 L98,203,108,245,82,279,39,280,11,247,19,205,59,185z"/>\n        <path d="M179,185 L218,203,228,245,202,279,159,280,131,247,139,205z"/>\n        <path d="M270,225 L300,245 320,225 340,245 280,280                   \n       390,280 420,240 280,185z"/>\n    </g>\n\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.2 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n<!--\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>\n-->\n</svg>\n'},
  {name: 'shapes-polygon-03-t.svg', svg: '<svg id="svg-root" width="100%" height="100%" viewBox="0 0 480 360" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  Copyright 2008 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/" template-version="1.4" reviewer="ED" author="Microsoft" status="accepted" version="$Revision: 1.1 $" testname="$RCSfile: shapes-polygon-03-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/shapes.html#PolygonElement">\n      <p>\n        Test that \'polyline\' and \'polygon\' elements with an odd number of coordinates render up to the invalid coordinate.\n      </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        Run the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The test is passed if four green triangles are visible on the page, and no red.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: shapes-polygon-03-t.svg,v $</title>\n  <defs>\n    <font-face\n      font-family="SVGFreeSansASCII"\n      unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <polyline fill="red" points="80,200 80,300 150,250 80,200 250" />\n    <polyline fill="lime" points="80,200 80,300 150,250 80,200" />\n    <polyline fill="red" points="180,200 180,300 250,250 180,200" />\n    <polyline fill="lime" points="180,200 180,300 250,250 180,200 250" />\n    <polygon fill="red" points="80,60 80,160 150,110 80" />\n    <polygon fill="lime" points="80,60 80,160 150,110" />\n    <polygon fill="red" points="180,60 180,160 250,110" />\n    <polygon fill="lime" points="180,60 180,160 250,110 180" />\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none"\n      fill="black">$Revision: 1.1 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--\n  <g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'shapes-polyline-01-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="SVGWG" author=" Lofton" status="accepted"\n    version="$Revision: 1.5 $" testname="$RCSfile: shapes-polyline-01-t.svg,v $">\n    <d:testDescription xmlns="http://www.w3.org/1999/xhtml" href="http://www.w3.org/TR/SVG11/shapes.html#PolylineElement">\n        <p>\nTests the polyline element.\n        </p>\n    </d:testDescription>\n    <d:operatorScript xmlns="http://www.w3.org/1999/xhtml">\n      <p>\nRun the test. No interaction required.\n      </p>\n    </d:operatorScript>\n    <d:passCriteria xmlns="http://www.w3.org/1999/xhtml">\n      <p>\n        The test is passed if polylines are displayed whose position, size, fill and stroke  matches the reference image.\n      </p>\n    </d:passCriteria>\n  </d:SVGTestCase>\n  <title id="test-title">$RCSfile: shapes-polyline-01-t.svg,v $</title>\n  <defs>\n    <font-face font-family="SVGFreeSansASCII" unicode-range="U+0-7F">\n      <font-face-src>\n        <font-face-uri xlink:href="../resources/SVGFreeSans.svg#ascii"/>\n      </font-face-src>\n    </font-face>\n  </defs>\n  <g id="test-body-content" font-family="SVGFreeSansASCII,sans-serif" font-size="18">\n    <!-- Test case label. -->\n    <!-- ====================================================================== -->\n    <!-- First two polylines.                                                   -->\n    <!-- ====================================================================== -->\n    <!-- Open sawtooth line. -->\n    <polyline id="polyline-01" fill="none" stroke="#000000" points="10,50,35,150,60,50,85,150,110,50,135,150"/>\n    <!-- text font-family="Arial" font-size="12"  x="52" y="40">stroked</text-->\n    <!-- Closed pentagon shaped polyline (5 segments). -->\n    <polyline id="polyline-02" fill="none" stroke="blue" stroke-width="8" points="220,50,267,84,249,140,190,140,172,84,220,50"/>\n    <!--text font-family="Arial" font-size="12"  x="202" y="40">stroked</text-->\n    <!-- ====================================================================== -->\n    <!-- Third polyline.                                                        -->\n    <!-- ====================================================================== -->\n    <!-- The sawtooth again, polylines can be filled. -->\n    <polyline id="polyline-03" fill="blue" stroke="#00FF00" stroke-width="4" points="310,50,335,150,360,50,385,150,410,50,435,150"/>\n    <!--text font-family="Arial" font-size="12"  x="340" y="40">filled &amp; stroked</text-->\n    <!-- ====================================================================== -->\n    <!-- Fourth and fifth polylines.                                             -->\n    <!-- ====================================================================== -->\n    <!-- An unclosed "septagon" shaped polyline (7th segment omitted). -->\n    <polyline id="polyline-04" fill="none" stroke="green" stroke-width="8" points="59,185,98,203,108,245,82,279,39,280,11,247,19,205"/>\n    <!--text font-family="Arial" font-size="12"  x="36" y="175">stroked</text-->\n    <!-- Same shape, filled, shows difference with \'polygon\'. -->\n    <polyline id="polyline-05" fill="#00FF00" stroke="#0000FF" stroke-width="8" points="189,185,228,203,238,245,212,279,169,280,141,247,149,205"/>\n    <!--text font-family="Arial" font-size="12"  x="148" y="175">filled &amp; stroked</text-->\n    <!-- ====================================================================== -->\n    <!-- Sixth polylines, irregular with both concave and convex angles.         -->\n    <!-- ====================================================================== -->\n    <polyline id="polyline-06" fill="#FF00FF" stroke="none" stroke-width="8" points="270,225 300,245 320,225 340,245 280,280                   390,280 420,240 280,185"/>\n    <!--text font-family="Arial" font-size="12"  x="330" y="175">filled</text-->\n  </g>\n  <g font-family="SVGFreeSansASCII,sans-serif" font-size="32">\n    <text id="revision" x="10" y="340" stroke="none" fill="black">$Revision: 1.5 $</text>\n  </g>\n  <rect id="test-frame" x="1" y="1" width="478" height="358" fill="none" stroke="#000000"/>\n  <!-- comment out this watermark once the test is approved -->\n  <!--<g id="draft-watermark">\n    <rect x="1" y="1" width="478" height="20" fill="red" stroke="black" stroke-width="1"/>\n    <text font-family="SVGFreeSansASCII,sans-serif" font-weight="bold" font-size="20" x="240"\n      text-anchor="middle" y="18" stroke-width="0.5" stroke="black" fill="white">DRAFT</text>\n  </g>-->\n</svg>\n'},
  {name: 'shapes-polyline-02-t.svg', svg: '<svg version="1.1" baseProfile="tiny" id="svg-root"\n  width="100%" height="100%" viewBox="0 0 480 360"\n  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">\n  <!--======================================================================-->\n  <!--=  SVG 1.1 2nd Edition Test Case                                     =-->\n  <!--======================================================================-->\n  <!--=  Copyright 2009 World Wide Web Consortium, (Massachusetts          =-->\n  <!--=  Institute of Technology, European Research Consortium for         =-->\n  <!--=  Informatics and Mathematics (ERCIM), Keio University).            =-->\n  <!--=  All Rights Reserved.                                              =-->\n  <!--=  See http://www.w3.org/Consortium/Legal/.                          =-->\n  <!--======================================================================-->\n  <d:SVGTestCase xmlns:d="http://www.w3.org/2000/02/svg/testsuite/description/"\n    template-version="1.4" reviewer="AG" author=" CL" status="accepted"\n    version="$Revis