import { Injectable, NgModule, InjectionToken } from '@angular/core';
import { finalize } from 'rxjs/operators';
import { BlockUIService, BLOCKUI_DEFAULT, BlockUIModule } from 'ng-block-ui';
import { HTTP_INTERCEPTORS } from '@angular/common/http';

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
var BlockUIHttpSettings = /** @class */ (function () {
    function BlockUIHttpSettings() {
        this.settings = {};
    }
    BlockUIHttpSettings.decorators = [
        { type: Injectable },
    ];
    return BlockUIHttpSettings;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
var BlockUIInterceptor = /** @class */ (function () {
    function BlockUIInterceptor(blockUIService, blockUIHttpSettings) {
        this.blockUIService = blockUIService;
        this.blockUIHttpSettings = blockUIHttpSettings;
        this.activeHttpRequests = 0;
    }
    /**
     * @param {?} request
     * @param {?} next
     * @return {?}
     */
    BlockUIInterceptor.prototype.intercept = /**
     * @param {?} request
     * @param {?} next
     * @return {?}
     */
    function (request, next) {
        var _this = this;
        var /** @type {?} */ active = false;
        if (this.shouldBlock(request)) {
            active = true;
            this.activeHttpRequests++;
            this.blockUIService.start(BLOCKUI_DEFAULT);
        }
        return next.handle(request)
            .pipe(finalize(function () {
            if (_this.shouldBlock(request)) {
                _this.activeHttpRequests--;
                var /** @type {?} */ stopBlockUI = false;
                if (!!_this.blockUIHttpSettings.settings.blockAllRequestsInProgress && _this.activeHttpRequests <= 0) {
                    _this.activeHttpRequests = 0;
                    stopBlockUI = true;
                }
                else if (active) {
                    stopBlockUI = true;
                }
                if (stopBlockUI) {
                    _this.blockUIService.stop(BLOCKUI_DEFAULT);
                }
            }
        }));
    };
    /**
     * @param {?} request
     * @return {?}
     */
    BlockUIInterceptor.prototype.shouldBlock = /**
     * @param {?} request
     * @return {?}
     */
    function (request) {
        var method = request.method, urlWithParams = request.urlWithParams;
        var /** @type {?} */ settings = this.blockUIHttpSettings.settings;
        var /** @type {?} */ requestFilters = settings.requestFilters || [];
        return !requestFilters.some(function (f) {
            if (f && f.method && f.url) {
                return f.method.toUpperCase() === method && f.url.test(urlWithParams);
            }
            else if (typeof f === 'function') {
                return f(request);
            }
            return f.test(urlWithParams);
        });
    };
    BlockUIInterceptor.decorators = [
        { type: Injectable },
    ];
    /** @nocollapse */
    BlockUIInterceptor.ctorParameters = function () { return [
        { type: BlockUIService },
        { type: BlockUIHttpSettings }
    ]; };
    return BlockUIInterceptor;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
// Needed for AOT compiling
var /** @type {?} */ BlockUIHttpModuleSettings = new InjectionToken('BlockUIHttpModuleSettings');
/**
 * @param {?} settings
 * @return {?}
 */
function provideSettingsInstance(settings) {
    return { settings: settings };
}
var BlockUIHttpModule = /** @class */ (function () {
    function BlockUIHttpModule() {
    }
    /**
     * @param {?=} settings
     * @return {?}
     */
    BlockUIHttpModule.forRoot = /**
     * @param {?=} settings
     * @return {?}
     */
    function (settings) {
        if (settings === void 0) { settings = {}; }
        return {
            ngModule: BlockUIHttpModule,
            providers: [
                {
                    provide: BlockUIHttpModuleSettings,
                    useValue: settings
                },
                {
                    provide: BlockUIHttpSettings,
                    useFactory: provideSettingsInstance,
                    deps: [BlockUIHttpModuleSettings]
                },
                {
                    provide: HTTP_INTERCEPTORS,
                    useClass: BlockUIInterceptor,
                    multi: true
                }
            ]
        };
    };
    BlockUIHttpModule.decorators = [
        { type: NgModule, args: [{
                    imports: [BlockUIModule]
                },] },
    ];
    return BlockUIHttpModule;
}());

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */

/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */

export { BlockUIHttpModule, BlockUIHttpSettings as ɵc, BlockUIInterceptor as ɵd, BlockUIHttpModuleSettings as ɵa, provideSettingsInstance as ɵb };

//# sourceMappingURL=data:application/json;charset=utf-8;base64,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