"use strict";
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@angular-devkit/core");
const normalize_asset_patterns_1 = require("./normalize-asset-patterns");
const normalize_file_replacements_1 = require("./normalize-file-replacements");
const normalize_optimization_1 = require("./normalize-optimization");
const normalize_source_maps_1 = require("./normalize-source-maps");
function normalizeBuilderSchema(host, root, builderConfig) {
    const { options } = builderConfig;
    const projectRoot = core_1.resolve(root, builderConfig.root);
    const syncHost = new core_1.virtualFs.SyncDelegateHost(host);
    // todo: this should be unknown
    // tslint:disable-next-line:no-any
    const isKarmaBuilderSchema = (options) => !options.hasOwnProperty('optimization');
    // todo: this should be unknown
    // tslint:disable-next-line:no-any
    const isBuildWebpackServerSchema = (options) => !options.hasOwnProperty('assets');
    const assets = isBuildWebpackServerSchema(options)
        ? {}
        : {
            assets: normalize_asset_patterns_1.normalizeAssetPatterns(options.assets, syncHost, root, projectRoot, builderConfig.sourceRoot),
        };
    const normalizedSourceMapOptions = normalize_source_maps_1.normalizeSourceMaps(options.sourceMap);
    // todo: remove when removing the deprecations
    normalizedSourceMapOptions.vendor
        = normalizedSourceMapOptions.vendor || !!options.vendorSourceMap;
    const optimization = isKarmaBuilderSchema(options)
        ? {}
        : options.optimization || {};
    return Object.assign({}, options, assets, { fileReplacements: normalize_file_replacements_1.normalizeFileReplacements(options.fileReplacements, syncHost, root), optimization: normalize_optimization_1.normalizeOptimization(optimization), sourceMap: normalizedSourceMapOptions });
}
exports.normalizeBuilderSchema = normalizeBuilderSchema;
//# sourceMappingURL=data:application/json;base64,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