/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.users;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.authentication.AuthenticationMethodType;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiDynamicActionImplementor;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiResponseList;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.authentication.ExtensionAuthentication;
import org.zaproxy.zap.extension.users.ExtensionUserManagement;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.utils.ApiUtils;

public class UsersAPI
extends ApiImplementor {
    private static final Logger log = Logger.getLogger(UsersAPI.class);
    private static final String PREFIX = "users";
    private static final String VIEW_USERS_LIST = "usersList";
    private static final String VIEW_GET_USER_BY_ID = "getUserById";
    private static final String VIEW_GET_AUTH_CREDENTIALS = "getAuthenticationCredentials";
    private static final String VIEW_GET_AUTH_CREDENTIALS_CONFIG_PARAMETERS = "getAuthenticationCredentialsConfigParams";
    private static final String ACTION_NEW_USER = "newUser";
    private static final String ACTION_REMOVE_USER = "removeUser";
    private static final String ACTION_SET_ENABLED = "setUserEnabled";
    private static final String ACTION_SET_NAME = "setUserName";
    private static final String ACTION_SET_AUTH_CREDENTIALS = "setAuthenticationCredentials";
    public static final String PARAM_CONTEXT_ID = "contextId";
    public static final String PARAM_USER_ID = "userId";
    private static final String PARAM_USER_NAME = "name";
    private static final String PARAM_ENABLED = "enabled";
    private static final String PARAM_CREDENTIALS_CONFIG_PARAMS = "authCredentialsConfigParams";
    private ExtensionUserManagement extension;
    private Map<Integer, ApiDynamicActionImplementor> loadedAuthenticationMethodActions;

    public UsersAPI(ExtensionUserManagement extension) {
        this.extension = extension;
        this.addApiView(new ApiView(VIEW_USERS_LIST, null, new String[]{PARAM_CONTEXT_ID}));
        this.addApiView(new ApiView(VIEW_GET_USER_BY_ID, new String[]{PARAM_CONTEXT_ID, PARAM_USER_ID}));
        this.addApiView(new ApiView(VIEW_GET_AUTH_CREDENTIALS_CONFIG_PARAMETERS, new String[]{PARAM_CONTEXT_ID}));
        this.addApiView(new ApiView(VIEW_GET_AUTH_CREDENTIALS, new String[]{PARAM_CONTEXT_ID, PARAM_USER_ID}));
        this.addApiAction(new ApiAction(ACTION_NEW_USER, new String[]{PARAM_CONTEXT_ID, PARAM_USER_NAME}));
        this.addApiAction(new ApiAction(ACTION_REMOVE_USER, new String[]{PARAM_CONTEXT_ID, PARAM_USER_ID}));
        this.addApiAction(new ApiAction(ACTION_SET_ENABLED, new String[]{PARAM_CONTEXT_ID, PARAM_USER_ID, PARAM_ENABLED}));
        this.addApiAction(new ApiAction(ACTION_SET_NAME, new String[]{PARAM_CONTEXT_ID, PARAM_USER_ID, PARAM_USER_NAME}));
        this.addApiAction(new ApiAction(ACTION_SET_AUTH_CREDENTIALS, new String[]{PARAM_CONTEXT_ID, PARAM_USER_ID}, new String[]{PARAM_CREDENTIALS_CONFIG_PARAMS}));
        if (Control.getSingleton() != null) {
            ExtensionAuthentication authenticationExtension = Control.getSingleton().getExtensionLoader().getExtension(ExtensionAuthentication.class);
            this.loadedAuthenticationMethodActions = new HashMap<Integer, ApiDynamicActionImplementor>();
            if (authenticationExtension != null) {
                for (AuthenticationMethodType t : authenticationExtension.getAuthenticationMethodTypes()) {
                    ApiDynamicActionImplementor i = t.getSetCredentialsForUserApiAction();
                    if (i == null) continue;
                    this.loadedAuthenticationMethodActions.put(t.getUniqueIdentifier(), i);
                }
            }
        }
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public ApiResponse handleApiView(String name, JSONObject params) throws ApiException {
        log.debug((Object)("handleApiView " + name + " " + params.toString()));
        switch (name) {
            case "usersList": {
                List<Object> users;
                ApiResponseList usersListResponse = new ApiResponseList(name);
                if (this.hasContextId(params)) {
                    users = this.extension.getContextUserAuthManager(this.getContextId(params)).getUsers();
                } else {
                    users = new ArrayList();
                    for (Context context : Model.getSingleton().getSession().getContexts()) {
                        users.addAll(this.extension.getContextUserAuthManager(context.getIndex()).getUsers());
                    }
                }
                for (User user : users) {
                    usersListResponse.addItem(this.buildResponseFromUser(user));
                }
                return usersListResponse;
            }
            case "getUserById": {
                return this.buildResponseFromUser(this.getUser(params));
            }
            case "getAuthenticationCredentials": {
                return this.getUser(params).getAuthenticationCredentials().getApiResponseRepresentation();
            }
            case "getAuthenticationCredentialsConfigParams": {
                AuthenticationMethodType type = ApiUtils.getContextByParamId(params, PARAM_CONTEXT_ID).getAuthenticationMethod().getType();
                ApiDynamicActionImplementor apiDynamicActionImplementor = this.loadedAuthenticationMethodActions.get(type.getUniqueIdentifier());
                return apiDynamicActionImplementor.buildParamsDescription();
            }
        }
        throw new ApiException(ApiException.Type.BAD_VIEW);
    }

    @Override
    public ApiResponse handleApiAction(String name, JSONObject params) throws ApiException {
        log.debug((Object)("handleApiAction " + name + " " + params.toString()));
        switch (name) {
            case "newUser": {
                Context context = ApiUtils.getContextByParamId(params, PARAM_CONTEXT_ID);
                String userName = ApiUtils.getNonEmptyStringParam(params, PARAM_USER_NAME);
                User user = new User(context.getIndex(), userName);
                user.setAuthenticationCredentials(context.getAuthenticationMethod().createAuthenticationCredentials());
                this.extension.getContextUserAuthManager(context.getIndex()).addUser(user);
                context.save();
                return new ApiResponseElement(PARAM_USER_ID, String.valueOf(user.getId()));
            }
            case "removeUser": {
                Context context = ApiUtils.getContextByParamId(params, PARAM_CONTEXT_ID);
                int userId = ApiUtils.getIntParam(params, PARAM_USER_ID);
                boolean deleted = this.extension.getContextUserAuthManager(context.getIndex()).removeUserById(userId);
                if (deleted) {
                    context.save();
                    return ApiResponseElement.OK;
                }
                return ApiResponseElement.FAIL;
            }
            case "setUserEnabled": {
                boolean enabled = false;
                try {
                    enabled = params.getBoolean(PARAM_ENABLED);
                }
                catch (JSONException e) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "enabled - should be boolean");
                }
                User user = this.getUser(params);
                user.setEnabled(enabled);
                user.getContext().save();
                return ApiResponseElement.OK;
            }
            case "setUserName": {
                String nameSN = params.getString(PARAM_USER_NAME);
                if (nameSN == null || nameSN.isEmpty()) {
                    throw new ApiException(ApiException.Type.MISSING_PARAMETER, PARAM_USER_NAME);
                }
                User user = this.getUser(params);
                user.setName(nameSN);
                user.getContext().save();
                return ApiResponseElement.OK;
            }
            case "setAuthenticationCredentials": {
                JSONObject actionParams = params.has(PARAM_CREDENTIALS_CONFIG_PARAMS) ? API.getParams(params.getString(PARAM_CREDENTIALS_CONFIG_PARAMS)) : new JSONObject();
                Context context = ApiUtils.getContextByParamId(params, PARAM_CONTEXT_ID);
                actionParams.put((Object)PARAM_CONTEXT_ID, (Object)context.getIndex());
                actionParams.put((Object)PARAM_USER_ID, (Object)this.getUserId(params));
                ApiDynamicActionImplementor a = this.loadedAuthenticationMethodActions.get(context.getAuthenticationMethod().getType().getUniqueIdentifier());
                a.handleAction(actionParams);
                context.save();
                return ApiResponseElement.OK;
            }
        }
        throw new ApiException(ApiException.Type.BAD_ACTION);
    }

    private ApiResponse buildResponseFromUser(User u) {
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put(PARAM_USER_NAME, u.getName());
        fields.put("id", Integer.toString(u.getId()));
        fields.put(PARAM_CONTEXT_ID, Integer.toString(u.getContextId()));
        fields.put(PARAM_ENABLED, Boolean.toString(u.isEnabled()));
        fields.put("credentials", u.getAuthenticationCredentials().getApiResponseRepresentation().toJSON().toString());
        return new ApiResponseSet("user", fields);
    }

    private int getUserId(JSONObject params) throws ApiException {
        return ApiUtils.getIntParam(params, PARAM_USER_ID);
    }

    private User getUser(JSONObject params) throws ApiException {
        int contextId = this.getContextId(params);
        int userId = this.getUserId(params);
        User user = this.extension.getContextUserAuthManager(contextId).getUserById(userId);
        if (user == null) {
            throw new ApiException(ApiException.Type.USER_NOT_FOUND, PARAM_USER_ID);
        }
        return user;
    }

    private int getContextId(JSONObject params) throws ApiException {
        return ApiUtils.getIntParam(params, PARAM_CONTEXT_ID);
    }

    private boolean hasContextId(JSONObject params) {
        try {
            params.getInt(PARAM_CONTEXT_ID);
        }
        catch (JSONException ex) {
            return false;
        }
        return true;
    }
}

