/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.manualrequest;

import java.awt.EventQueue;
import java.util.HashMap;
import java.util.Map;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ExtensionLoader;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.extension.ViewDelegate;
import org.parosproxy.paros.extension.manualrequest.ManualRequestEditorDialog;
import org.parosproxy.paros.extension.manualrequest.http.impl.ManualHttpRequestEditorDialog;
import org.parosproxy.paros.model.Session;
import org.zaproxy.zap.extension.httppanel.Message;

public class ExtensionManualRequestEditor
extends ExtensionAdaptor
implements SessionChangedListener {
    private Map<Class<? extends Message>, ManualRequestEditorDialog> dialogues = new HashMap<Class<? extends Message>, ManualRequestEditorDialog>();
    private ManualHttpRequestEditorDialog httpSendEditorDialog;
    public static final String NAME = "ExtensionManualRequest";

    public ExtensionManualRequestEditor() {
        super(NAME);
        this.setOrder(36);
    }

    @Override
    public String getUIName() {
        return Constant.messages.getString("manReq.name");
    }

    @Override
    public void initView(ViewDelegate view) {
        super.initView(view);
        this.httpSendEditorDialog = new ManualHttpRequestEditorDialog(true, "manual", "ui.dialogs.manreq");
        this.httpSendEditorDialog.setTitle(Constant.messages.getString("manReq.dialog.title"));
        this.addManualSendEditor(this.httpSendEditorDialog);
    }

    public void addManualSendEditor(ManualRequestEditorDialog dialogue) {
        this.dialogues.put(dialogue.getMessageType(), dialogue);
    }

    public void removeManualSendEditor(Class<? extends Message> messageType) {
        ManualRequestEditorDialog dialogue = this.dialogues.remove(messageType);
        if (dialogue != null) {
            dialogue.clear();
            dialogue.dispose();
            if (this.getView() != null) {
                ExtensionLoader extLoader = Control.getSingleton().getExtensionLoader();
                extLoader.removeToolsMenuItem(dialogue.getMenuItem());
            }
        }
    }

    public ManualRequestEditorDialog getManualSendEditor(Class<? extends Message> type) {
        return this.dialogues.get(type);
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        if (this.getView() != null) {
            for (Map.Entry<Class<? extends Message>, ManualRequestEditorDialog> dialogue : this.dialogues.entrySet()) {
                extensionHook.getHookMenu().addToolsMenuItem(dialogue.getValue().getMenuItem());
            }
            extensionHook.addSessionListener(this);
            extensionHook.addOptionsChangedListener(this.httpSendEditorDialog);
        }
    }

    @Override
    public String getAuthor() {
        return "Chinotec Technologies";
    }

    @Override
    public void sessionChanged(Session session) {
        if (EventQueue.isDispatchThread()) {
            for (Map.Entry<Class<? extends Message>, ManualRequestEditorDialog> dialogue : this.dialogues.entrySet()) {
                dialogue.getValue().clear();
                dialogue.getValue().setDefaultMessage();
            }
            return;
        }
        EventQueue.invokeLater(() -> this.sessionChanged(session));
    }

    @Override
    public void sessionAboutToChange(Session session) {
    }

    @Override
    public void sessionScopeChanged(Session session) {
    }

    @Override
    public void sessionModeChanged(Control.Mode mode) {
        Boolean isEnabled = null;
        switch (mode) {
            case safe: {
                isEnabled = false;
                break;
            }
            case protect: 
            case standard: 
            case attack: {
                isEnabled = true;
            }
        }
        if (isEnabled != null) {
            for (Map.Entry<Class<? extends Message>, ManualRequestEditorDialog> dialog : this.dialogues.entrySet()) {
                dialog.getValue().setEnabled(isEnabled);
            }
        }
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }
}

