
/*
 * Copyright (C) 2010-2016 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * UartType.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_6_1;

import org.virtualbox_6_1.jaxws.*;
import javax.xml.ws.*;

/**
The UART type represents the emulated UART chip for the serial port device.
Interface ID: <tt>{C8899D39-0B90-4265-9D02-1E38BD4D1B39}</tt>
*/
public enum UartType
{

/**
The most basic emulated UART which doesn't support FIFO operation.
*/
    U16450(0),

/**
The successor of the 16450 UART introducing a 16 byte FIFO to reduce
operational overhead.
*/
    U16550A(1),

/**
This UART developed by Texas Instruments introduced a 64 byte FIFO
and hardware flow control.
*/
    U16750(2);

    private final int value;

    UartType(int v)
    {
        value = v;
    }

    public int value()
    {
        return value;
    }

    public static UartType fromValue(long v)
    {
        for (UartType c: UartType.values())
        {
            if (c.value == (int)v)
            {
                return c;
            }
        }
        throw new IllegalArgumentException(Long.toString(v));
    }

    public static UartType fromValue(String v)
    {
        return valueOf(UartType.class, v);
    }
}

