
/*
 * Copyright (C) 2010-2016 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * TouchContactState.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_6_1;

import org.virtualbox_6_1.jaxws.*;
import javax.xml.ws.*;

/**
Touch event contact state.
Interface ID: <tt>{3F942686-2506-421C-927C-90D4B45F4A38}</tt>
*/
public enum TouchContactState
{

/**
The touch has finished.
*/
    None(0x00),

/**
Whether the touch is really touching the device.
*/
    InContact(0x01),

/**
Whether the touch is close enough to the device to be detected.
*/
    InRange(0x02),
    ContactStateMask(0x03);

    private final int value;

    TouchContactState(int v)
    {
        value = v;
    }

    public int value()
    {
        return value;
    }

    public static TouchContactState fromValue(long v)
    {
        for (TouchContactState c: TouchContactState.values())
        {
            if (c.value == (int)v)
            {
                return c;
            }
        }
        throw new IllegalArgumentException(Long.toString(v));
    }

    public static TouchContactState fromValue(String v)
    {
        return valueOf(TouchContactState.class, v);
    }
}

