
/*
 * Copyright (C) 2010-2016 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * IUSBController.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_6_1;

import org.virtualbox_6_1.jaxws.*;
import javax.xml.ws.*;
import java.util.List;

public class IUSBController extends IUnknown
{

    public IUSBController(String wrapped, ObjectRefManager objMgr, VboxPortType port)
    {
        super(wrapped, objMgr, port);
    }

/**
The USB Controller name.
@return String
*/
    public String getName()
    {
        try
        {
            String retVal = port.iusbControllerGetName(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
The USB Controller name.
@param value String

*/
    public void setName(String value)
    {
        try
        {
        port.iusbControllerSetName(obj, value);
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
The USB Controller type.
@return org.virtualbox_6_1.USBControllerType
*/
    public org.virtualbox_6_1.USBControllerType getType()
    {
        try
        {
            org.virtualbox_6_1.jaxws.USBControllerType retVal = port.iusbControllerGetType(obj);
            return org.virtualbox_6_1.USBControllerType.fromValue(retVal.value());
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
The USB Controller type.
@param value org.virtualbox_6_1.USBControllerType

*/
    public void setType(org.virtualbox_6_1.USBControllerType value)
    {
        try
        {
        port.iusbControllerSetType(obj, org.virtualbox_6_1.jaxws.USBControllerType.fromValue(value.name()));
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
USB standard version which the controller implements.
This is a BCD which means that the major version is in the
high byte and minor version is in the low byte.
@return Integer
*/
    public Integer getUSBStandard()
    {
        try
        {
            Integer retVal = port.iusbControllerGetUSBStandard(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }
    public static IUSBController queryInterface(IUnknown obj)
    {
        return obj == null ?  null : new IUSBController(obj.getWrapped(), obj.getObjMgr(), obj.getRemoteWSPort());
    }
}
