/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateInDirectoryActionBase;
import com.intellij.ide.actions.ElementCreator;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.WriteActionAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateElementActionBase
extends CreateInDirectoryActionBase
implements WriteActionAware {
    protected CreateElementActionBase() {
    }

    protected CreateElementActionBase(@Nls(capitalization=Nls.Capitalization.Title) String text, @Nls(capitalization=Nls.Capitalization.Sentence) String description, Icon icon) {
        super(text, description, icon);
    }

    @NotNull
    protected abstract PsiElement[] invokeDialog(Project var1, PsiDirectory var2);

    @NotNull
    protected abstract PsiElement[] create(@NotNull String var1, PsiDirectory var2) throws Exception;

    protected abstract String getErrorTitle();

    protected abstract String getCommandName();

    protected abstract String getActionName(PsiDirectory var1, String var2);

    @Override
    public final void actionPerformed(@NotNull AnActionEvent e) {
        PsiElement[] createdElements;
        IdeView view;
        if (e == null) {
            CreateElementActionBase.$$$reportNull$$$0(0);
        }
        if ((view = this.getIdeView(e)) == null) {
            return;
        }
        Project project = e.getProject();
        PsiDirectory dir = view.getOrChooseDirectory();
        if (dir == null) {
            return;
        }
        for (PsiElement createdElement : createdElements = this.invokeDialog(project, dir)) {
            view.selectElement(createdElement);
        }
    }

    @Nullable
    protected IdeView getIdeView(@NotNull AnActionEvent e) {
        if (e == null) {
            CreateElementActionBase.$$$reportNull$$$0(1);
        }
        return e.getData(LangDataKeys.IDE_VIEW);
    }

    public static String filterMessage(String message) {
        if (message == null) {
            return null;
        }
        String ioExceptionPrefix = "java.io.IOException:";
        message = StringUtil.trimStart((String)message, (String)"java.io.IOException:");
        return message;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/ide/actions/CreateElementActionBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getIdeView";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected class MyInputValidator
    extends ElementCreator
    implements InputValidator {
        private final PsiDirectory myDirectory;
        private PsiElement[] myCreatedElements;

        public MyInputValidator(Project project, PsiDirectory directory) {
            super(project, CreateElementActionBase.this.getErrorTitle());
            this.myCreatedElements = PsiElement.EMPTY_ARRAY;
            this.myDirectory = directory;
        }

        public PsiDirectory getDirectory() {
            return this.myDirectory;
        }

        @Override
        public boolean checkInput(String inputString) {
            return true;
        }

        @Override
        public PsiElement[] create(@NotNull String newName) throws Exception {
            if (newName == null) {
                MyInputValidator.$$$reportNull$$$0(0);
            }
            return CreateElementActionBase.this.create(newName, this.myDirectory);
        }

        @Override
        public boolean startInWriteAction() {
            return CreateElementActionBase.this.startInWriteAction();
        }

        @Override
        public String getActionName(String newName) {
            return CreateElementActionBase.this.getActionName(this.myDirectory, newName);
        }

        @Override
        public boolean canClose(String inputString) {
            this.myCreatedElements = this.tryCreate(inputString);
            return this.myCreatedElements.length > 0;
        }

        public final PsiElement[] getCreatedElements() {
            return this.myCreatedElements;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/ide/actions/CreateElementActionBase$MyInputValidator", "create"));
        }
    }
}

