/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.branch;

import com.intellij.configurationStore.StoreUtil;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.BranchActionGroupPopup;
import com.intellij.dvcs.ui.BranchActionUtil;
import com.intellij.dvcs.ui.LightActionGroup;
import com.intellij.dvcs.ui.NewBranchAction;
import com.intellij.dvcs.ui.PopupElementWithAdditionalInfo;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.CommitChangeListDialog;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import icons.DvcsImplIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.action.HgCommandResultNotifier;
import org.zmlx.hg4idea.branch.HgBranchAbstractAction;
import org.zmlx.hg4idea.branch.HgBranchType;
import org.zmlx.hg4idea.branch.HgCommonBranchActions;
import org.zmlx.hg4idea.command.HgBookmarkCommand;
import org.zmlx.hg4idea.command.HgBranchCreateCommand;
import org.zmlx.hg4idea.execution.HgCommandException;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.provider.commit.HgCloseBranchExecutor;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.repo.HgRepositoryManager;
import org.zmlx.hg4idea.ui.HgBookmarkDialog;
import org.zmlx.hg4idea.util.HgErrorUtil;
import org.zmlx.hg4idea.util.HgUtil;

public class HgBranchPopupActions {
    @NotNull
    private final Project myProject;
    @NotNull
    private final HgRepository myRepository;

    HgBranchPopupActions(@NotNull Project project, @NotNull HgRepository repository) {
        if (project == null) {
            HgBranchPopupActions.$$$reportNull$$$0(0);
        }
        if (repository == null) {
            HgBranchPopupActions.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myRepository = repository;
    }

    ActionGroup createActions() {
        return this.createActions(null, "", false);
    }

    ActionGroup createActions(@Nullable LightActionGroup toInsert, @NotNull String repoInfo, boolean firstLevelGroup) {
        if (repoInfo == null) {
            HgBranchPopupActions.$$$reportNull$$$0(2);
        }
        LightActionGroup popupGroup = new LightActionGroup(false);
        popupGroup.addAction((AnAction)new HgNewBranchAction(this.myProject, Collections.singletonList(this.myRepository), this.myRepository));
        popupGroup.addAction((AnAction)new HgNewBookmarkAction(Collections.singletonList(this.myRepository), this.myRepository));
        popupGroup.addAction((AnAction)new HgCloseBranchAction(Collections.singletonList(this.myRepository), this.myRepository));
        popupGroup.addAction((AnAction)new HgShowUnnamedHeadsForCurrentBranchAction(this.myRepository));
        if (toInsert != null) {
            popupGroup.addAll((ActionGroup)toInsert);
        }
        popupGroup.addSeparator("Bookmarks" + repoInfo);
        String currentBookmark = this.myRepository.getCurrentBookmark();
        List bookmarkActions = ((StreamEx)((StreamEx)StreamEx.of(HgUtil.getSortedNamesWithoutHashes(this.myRepository.getBookmarks())).filter(bm -> !bm.equals(currentBookmark))).map(bm -> new BookmarkActions(this.myProject, Collections.singletonList(this.myRepository), (String)bm)).sorted(BranchActionUtil.FAVORITE_BRANCH_COMPARATOR)).toList();
        int topShownBookmarks = BranchActionUtil.getNumOfTopShownBranches((List)bookmarkActions);
        if (currentBookmark != null) {
            bookmarkActions.add(0, new CurrentActiveBookmark(this.myProject, Collections.singletonList(this.myRepository), currentBookmark));
            ++topShownBookmarks;
        }
        BranchActionGroupPopup.wrapWithMoreActionIfNeeded((Project)this.myProject, (LightActionGroup)popupGroup, (List)bookmarkActions, (int)topShownBookmarks, (String)(firstLevelGroup ? "Hg.Branch.Popup.ShowAllBookmarks" : null), (boolean)firstLevelGroup);
        popupGroup.addSeparator("Branches" + repoInfo);
        List branchActions = ((StreamEx)((StreamEx)((StreamEx)StreamEx.of(this.myRepository.getOpenedBranches()).sorted(StringUtil::naturalCompare)).filter(b -> !b.equals(this.myRepository.getCurrentBranch()))).map(b -> new BranchActions(this.myProject, Collections.singletonList(this.myRepository), (String)b)).sorted(BranchActionUtil.FAVORITE_BRANCH_COMPARATOR)).toList();
        branchActions.add(0, new CurrentBranch(this.myProject, Collections.singletonList(this.myRepository), this.myRepository.getCurrentBranch()));
        BranchActionGroupPopup.wrapWithMoreActionIfNeeded((Project)this.myProject, (LightActionGroup)popupGroup, (List)branchActions, (int)(BranchActionUtil.getNumOfTopShownBranches((List)branchActions) + 1), (String)(firstLevelGroup ? "Hg.Branch.Popup.ShowAllBranches" : null), (boolean)firstLevelGroup);
        return popupGroup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repoInfo";
                break;
            }
        }
        objectArray2[1] = "org/zmlx/hg4idea/branch/HgBranchPopupActions";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createActions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class CurrentActiveBookmark
    extends BookmarkActions
    implements PopupElementWithAdditionalInfo {
        public CurrentActiveBookmark(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName) {
            if (project == null) {
                CurrentActiveBookmark.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                CurrentActiveBookmark.$$$reportNull$$$0(1);
            }
            if (branchName == null) {
                CurrentActiveBookmark.$$$reportNull$$$0(2);
            }
            super(project, repositories, branchName);
            this.setIcons(DvcsImplIcons.CurrentBranchFavoriteLabel, DvcsImplIcons.CurrentBranchLabel, AllIcons.Nodes.Favorite, AllIcons.Nodes.NotFavoriteOnHover);
        }

        @Override
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = new AnAction[]{new BookmarkActions.DeleteBookmarkAction(this.myProject, this.myRepositories, this.myBranchName)};
            if (anActionArray == null) {
                CurrentActiveBookmark.$$$reportNull$$$0(3);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/zmlx/hg4idea/branch/HgBranchPopupActions$CurrentActiveBookmark";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/zmlx/hg4idea/branch/HgBranchPopupActions$CurrentActiveBookmark";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class BookmarkActions
    extends HgCommonBranchActions {
        BookmarkActions(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName) {
            if (project == null) {
                BookmarkActions.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                BookmarkActions.$$$reportNull$$$0(1);
            }
            if (branchName == null) {
                BookmarkActions.$$$reportNull$$$0(2);
            }
            super(project, repositories, branchName, HgBranchType.BOOKMARK);
        }

        @Override
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            AnAction[] anActionArray = (AnAction[])ArrayUtil.append((Object[])super.getChildren(e), (Object)((Object)new DeleteBookmarkAction(this.myProject, this.myRepositories, this.myBranchName)));
            if (anActionArray == null) {
                BookmarkActions.$$$reportNull$$$0(3);
            }
            return anActionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/zmlx/hg4idea/branch/HgBranchPopupActions$BookmarkActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/zmlx/hg4idea/branch/HgBranchPopupActions$BookmarkActions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class DeleteBookmarkAction
        extends HgBranchAbstractAction {
            DeleteBookmarkAction(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName) {
                if (project == null) {
                    DeleteBookmarkAction.$$$reportNull$$$0(0);
                }
                if (repositories == null) {
                    DeleteBookmarkAction.$$$reportNull$$$0(1);
                }
                if (branchName == null) {
                    DeleteBookmarkAction.$$$reportNull$$$0(2);
                }
                super(project, "Delete", repositories, branchName);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    DeleteBookmarkAction.$$$reportNull$$$0(3);
                }
                BackgroundTaskUtil.executeOnPooledThread((Disposable)this.myProject, () -> {
                    for (HgRepository repository : this.myRepositories) {
                        HgBookmarkCommand.deleteBookmarkSynchronously(this.myProject, repository.getRoot(), this.myBranchName);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "repositories";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "branchName";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                objectArray2[1] = "org/zmlx/hg4idea/branch/HgBranchPopupActions$BookmarkActions$DeleteBookmarkAction";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    public static class CurrentBranch
    extends BranchActions
    implements PopupElementWithAdditionalInfo {
        public CurrentBranch(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName) {
            if (project == null) {
                CurrentBranch.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                CurrentBranch.$$$reportNull$$$0(1);
            }
            if (branchName == null) {
                CurrentBranch.$$$reportNull$$$0(2);
            }
            super(project, repositories, branchName);
            this.setIcons(DvcsImplIcons.CurrentBranchFavoriteLabel, DvcsImplIcons.CurrentBranchLabel, AllIcons.Nodes.Favorite, AllIcons.Nodes.NotFavoriteOnHover);
        }

        @Override
        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            if (AnAction.EMPTY_ARRAY == null) {
                CurrentBranch.$$$reportNull$$$0(3);
            }
            return AnAction.EMPTY_ARRAY;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branchName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/zmlx/hg4idea/branch/HgBranchPopupActions$CurrentBranch";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/zmlx/hg4idea/branch/HgBranchPopupActions$CurrentBranch";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class BranchActions
    extends HgCommonBranchActions {
        BranchActions(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull String branchName) {
            if (project == null) {
                BranchActions.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                BranchActions.$$$reportNull$$$0(1);
            }
            if (branchName == null) {
                BranchActions.$$$reportNull$$$0(2);
            }
            super(project, repositories, branchName, HgBranchType.BRANCH);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "branchName";
                    break;
                }
            }
            objectArray[1] = "org/zmlx/hg4idea/branch/HgBranchPopupActions$BranchActions";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class HgShowUnnamedHeadsForCurrentBranchAction
    extends ActionGroup
    implements DumbAware {
        @NotNull
        final HgRepository myRepository;
        @NotNull
        final String myCurrentBranchName;
        @NotNull
        Collection<Hash> myHeads;

        public HgShowUnnamedHeadsForCurrentBranchAction(@NotNull HgRepository repository) {
            if (repository == null) {
                HgShowUnnamedHeadsForCurrentBranchAction.$$$reportNull$$$0(0);
            }
            super(null, true);
            this.myRepository = repository;
            this.myCurrentBranchName = repository.getCurrentBranch();
            this.getTemplatePresentation().setText(String.format("Unnamed heads for %s", this.myCurrentBranchName));
            this.myHeads = this.filterUnnamedHeads();
        }

        @NotNull
        private Collection<Hash> filterUnnamedHeads() {
            Collection branchWithHashes = this.myRepository.getBranches().get(this.myCurrentBranchName);
            String currentHead = this.myRepository.getCurrentRevision();
            if (branchWithHashes == null || currentHead == null || this.myRepository.getState() != Repository.State.NORMAL) {
                Set<Hash> set = Collections.emptySet();
                if (set == null) {
                    HgShowUnnamedHeadsForCurrentBranchAction.$$$reportNull$$$0(1);
                }
                return set;
            }
            List bookmarkHashes = ContainerUtil.map(this.myRepository.getBookmarks(), info -> info.getHash());
            branchWithHashes.removeAll(bookmarkHashes);
            branchWithHashes.remove(HashImpl.build((String)currentHead));
            Collection collection = branchWithHashes;
            if (collection == null) {
                HgShowUnnamedHeadsForCurrentBranchAction.$$$reportNull$$$0(2);
            }
            return collection;
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            ArrayList<HgCommonBranchActions> branchHeadActions = new ArrayList<HgCommonBranchActions>();
            for (Hash hash : this.myHeads) {
                branchHeadActions.add(new HgCommonBranchActions(this.myRepository.getProject(), Collections.singletonList(this.myRepository), hash.toShortString()));
            }
            AnAction[] anActionArray = branchHeadActions.toArray(AnAction.EMPTY_ARRAY);
            if (anActionArray == null) {
                HgShowUnnamedHeadsForCurrentBranchAction.$$$reportNull$$$0(3);
            }
            return anActionArray;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                HgShowUnnamedHeadsForCurrentBranchAction.$$$reportNull$$$0(4);
            }
            if (this.myRepository.isFresh() || this.myHeads.isEmpty()) {
                e.getPresentation().setEnabledAndVisible(false);
            } else if (this.myRepository.getState() != Repository.State.NORMAL) {
                e.getPresentation().setEnabled(false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repository";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgShowUnnamedHeadsForCurrentBranchAction";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgShowUnnamedHeadsForCurrentBranchAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filterUnnamedHeads";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class HgNewBookmarkAction
    extends DumbAwareAction {
        @NotNull
        protected final List<HgRepository> myRepositories;
        @NotNull
        final HgRepository myPreselectedRepo;

        HgNewBookmarkAction(@NotNull List<HgRepository> repositories, @NotNull HgRepository preselectedRepo) {
            if (repositories == null) {
                HgNewBookmarkAction.$$$reportNull$$$0(0);
            }
            if (preselectedRepo == null) {
                HgNewBookmarkAction.$$$reportNull$$$0(1);
            }
            super("New Bookmark", "Create new bookmark", AllIcons.General.Add);
            this.myRepositories = repositories;
            this.myPreselectedRepo = preselectedRepo;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                HgNewBookmarkAction.$$$reportNull$$$0(2);
            }
            if (DvcsUtil.anyRepositoryIsFresh(this.myRepositories)) {
                e.getPresentation().setEnabled(false);
                e.getPresentation().setDescription("Bookmark creation is not possible before the first commit.");
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            String name;
            HgBookmarkDialog bookmarkDialog;
            if (e == null) {
                HgNewBookmarkAction.$$$reportNull$$$0(3);
            }
            if ((bookmarkDialog = new HgBookmarkDialog(this.myPreselectedRepo)).showAndGet() && !StringUtil.isEmptyOrSpaces((String)(name = bookmarkDialog.getName()))) {
                HgBookmarkCommand.createBookmarkAsynchronously(this.myRepositories, name, bookmarkDialog.isActive());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "preselectedRepo";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgNewBookmarkAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class HgCloseBranchAction
    extends DumbAwareAction {
        @NotNull
        private final List<HgRepository> myRepositories;
        @NotNull
        final HgRepository myPreselectedRepo;

        HgCloseBranchAction(@NotNull List<HgRepository> repositories, @NotNull HgRepository preselectedRepo) {
            if (repositories == null) {
                HgCloseBranchAction.$$$reportNull$$$0(0);
            }
            if (preselectedRepo == null) {
                HgCloseBranchAction.$$$reportNull$$$0(1);
            }
            super("Close " + StringUtil.pluralize((String)"branch", (int)repositories.size()), "Close current " + StringUtil.pluralize((String)"branch", (int)repositories.size()), AllIcons.Actions.Delete);
            this.myRepositories = repositories;
            this.myPreselectedRepo = preselectedRepo;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                HgCloseBranchAction.$$$reportNull$$$0(2);
            }
            Project project = this.myPreselectedRepo.getProject();
            StoreUtil.saveDocumentsAndProjectSettings((Project)project);
            ChangeListManager.getInstance((Project)project).invokeAfterUpdate(() -> this.commitAndCloseBranch(project), InvokeAfterUpdateMode.SYNCHRONOUS_CANCELLABLE, VcsBundle.message((String)"waiting.changelists.update.for.show.commit.dialog.message", (Object[])new Object[0]), ModalityState.current());
        }

        private void commitAndCloseBranch(@NotNull Project project) {
            if (project == null) {
                HgCloseBranchAction.$$$reportNull$$$0(3);
            }
            LocalChangeList activeChangeList = ChangeListManager.getInstance((Project)project).getDefaultChangeList();
            HgVcs vcs = HgVcs.getInstance(project);
            assert (vcs != null);
            HgRepositoryManager repositoryManager = HgUtil.getRepositoryManager(project);
            List changesForRepositories = ContainerUtil.filter((Collection)activeChangeList.getChanges(), change -> this.myRepositories.contains(repositoryManager.getRepositoryForFile(ChangesUtil.getFilePath((Change)change))));
            HgCloseBranchExecutor closeBranchExecutor = vcs.getCloseBranchExecutor();
            closeBranchExecutor.setRepositories(this.myRepositories);
            CommitChangeListDialog.commitChanges((Project)project, (List)changesForRepositories, (Collection)changesForRepositories, (LocalChangeList)activeChangeList, Collections.singletonList(closeBranchExecutor), (boolean)false, (AbstractVcs)vcs, (String)"Close Branch", null, (boolean)false);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                HgCloseBranchAction.$$$reportNull$$$0(4);
            }
            e.getPresentation().setEnabledAndVisible(ContainerUtil.and(this.myRepositories, repository -> repository.getOpenedBranches().contains(repository.getCurrentBranch())));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "preselectedRepo";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgCloseBranchAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "commitAndCloseBranch";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class HgNewBranchAction
    extends NewBranchAction<HgRepository> {
        @NotNull
        final HgRepository myPreselectedRepo;

        public HgNewBranchAction(@NotNull Project project, @NotNull List<HgRepository> repositories, @NotNull HgRepository preselectedRepo) {
            if (project == null) {
                HgNewBranchAction.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                HgNewBranchAction.$$$reportNull$$$0(1);
            }
            if (preselectedRepo == null) {
                HgNewBranchAction.$$$reportNull$$$0(2);
            }
            super(project, repositories);
            this.myPreselectedRepo = preselectedRepo;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            String name;
            if (e == null) {
                HgNewBranchAction.$$$reportNull$$$0(3);
            }
            if ((name = HgUtil.getNewBranchNameFromUser(this.myPreselectedRepo, "Create New Branch")) == null) {
                return;
            }
            new Task.Backgroundable(this.myProject, "Creating " + StringUtil.pluralize((String)"Branch", (int)this.myRepositories.size()) + "..."){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.createNewBranchInCurrentThread(name);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgNewBranchAction$1", "run"));
                }
            }.queue();
        }

        public void createNewBranchInCurrentThread(@NotNull String name) {
            if (name == null) {
                HgNewBranchAction.$$$reportNull$$$0(4);
            }
            for (HgRepository repository : this.myRepositories) {
                try {
                    HgCommandResult result = new HgBranchCreateCommand(this.myProject, repository.getRoot(), name).executeInCurrentThread();
                    repository.update();
                    if (!HgErrorUtil.hasErrorsInCommandExecution(result)) continue;
                    new HgCommandResultNotifier(this.myProject).notifyError(result, "Creation failed", "Branch creation [" + name + "] failed");
                }
                catch (HgCommandException exception) {
                    HgErrorUtil.handleException(this.myProject, "Can't create new branch: ", exception);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "preselectedRepo";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "org/zmlx/hg4idea/branch/HgBranchPopupActions$HgNewBranchAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createNewBranchInCurrentThread";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

