/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jar;

import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsBundle;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.impl.ZipHandler;
import com.intellij.openapi.vfs.impl.jar.JarFileSystemImpl;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.FlushingDaemon;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.FileAccessorCache;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentHashMapValueStorage;
import gnu.trove.THashSet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileTime;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JarHandler
extends ZipHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vfs.impl.jar.JarHandler");
    private static final String JARS_FOLDER = "jars";
    private static final int FS_TIME_RESOLUTION = 2000;
    private final JarFileSystemImpl myFileSystem;
    private volatile File myFileWithMirrorResolved;
    private static final NotNullLazyValue<NotificationGroup> ERROR_COPY_NOTIFICATION = new NotNullLazyValue<NotificationGroup>(){

        @NotNull
        protected NotificationGroup compute() {
            NotificationGroup notificationGroup = NotificationGroup.balloonGroup((String)VfsBundle.message((String)"jar.copy.error.title", (Object[])new Object[0]));
            if (notificationGroup == null) {
                1.$$$reportNull$$$0(0);
            }
            return notificationGroup;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/jar/JarHandler$1", "compute"));
        }
    };

    public JarHandler(@NotNull String path) {
        if (path == null) {
            JarHandler.$$$reportNull$$$0(0);
        }
        super(path);
        this.myFileSystem = (JarFileSystemImpl)JarFileSystem.getInstance();
    }

    @Override
    @NotNull
    protected File getFileToUse() {
        File fileWithMirrorResolved = this.myFileWithMirrorResolved;
        if (fileWithMirrorResolved == null) {
            File file2 = this.getFile();
            if (FileUtil.compareFiles((File)file2, (File)(fileWithMirrorResolved = this.getMirrorFile(file2))) == 0) {
                fileWithMirrorResolved = file2;
            }
            this.myFileWithMirrorResolved = fileWithMirrorResolved;
        }
        File file3 = fileWithMirrorResolved;
        if (file3 == null) {
            JarHandler.$$$reportNull$$$0(1);
        }
        return file3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected Map<String, ArchiveHandler.EntryInfo> createEntriesMap() throws IOException {
        FileAccessorCache.Handle<ZipFile> existingZipRef = this.getCachedZipFileHandle(!this.myFileSystem.isMakeCopyOfJar(this.getFile()) || this.myFileWithMirrorResolved != null);
        if (existingZipRef == null) {
            Map<String, ArchiveHandler.EntryInfo> map2;
            File file2 = this.getFile();
            try (ZipFile zipFile = new ZipFile(file2);){
                JarHandler.setFileAttributes(this, file2.getPath());
                Map<String, ArchiveHandler.EntryInfo> map3 = this.buildEntryMapForZipFile(zipFile);
                map2 = map3;
            }
            if (map2 == null) {
                JarHandler.$$$reportNull$$$0(2);
            }
            return map2;
        }
        Map<String, ArchiveHandler.EntryInfo> map4 = this.buildEntryMapForZipFile((ZipFile)existingZipRef.get());
        Map<String, ArchiveHandler.EntryInfo> map5 = map4;
        if (map5 == null) {
            JarHandler.$$$reportNull$$$0(3);
        }
        return map5;
        finally {
            existingZipRef.release();
        }
    }

    private File getMirrorFile(@NotNull File originalFile) {
        if (originalFile == null) {
            JarHandler.$$$reportNull$$$0(4);
        }
        if (!this.myFileSystem.isMakeCopyOfJar(originalFile)) {
            return originalFile;
        }
        FileAttributes originalAttributes = FileSystemUtil.getAttributes((File)originalFile);
        if (originalAttributes == null) {
            return originalFile;
        }
        String folderPath = JarHandler.getJarsDir();
        if (!new File(folderPath).exists() && !new File(folderPath).mkdirs()) {
            return originalFile;
        }
        if (FSRecords.WE_HAVE_CONTENT_HASHES) {
            return this.getMirrorWithContentHash(originalFile, originalAttributes);
        }
        String mirrorName = originalFile.getName() + "." + Integer.toHexString(originalFile.getPath().hashCode());
        File mirrorFile = new File(folderPath, mirrorName);
        FileAttributes mirrorAttributes = FileSystemUtil.getAttributes((File)mirrorFile);
        return JarHandler.mirrorDiffers(originalAttributes, mirrorAttributes, false) ? this.copyToMirror(originalFile, mirrorFile) : mirrorFile;
    }

    private File getMirrorWithContentHash(File originalFile, FileAttributes originalAttributes) {
        File mirrorFile = null;
        String jarDir = JarHandler.getJarsDir();
        try {
            MessageDigest sha1;
            String path = originalFile.getPath();
            CacheLibraryInfo info = (CacheLibraryInfo)CacheLibraryInfo.ourCachedLibraryInfo.get((Object)path);
            if (info != null && originalAttributes.length == info.myFileLength && Math.abs(originalAttributes.lastModified - info.myModificationTime) <= 2000L && !JarHandler.mirrorDiffers(originalAttributes, FileSystemUtil.getAttributes((File)(mirrorFile = new File(jarDir, info.mySnapshotPath))), true)) {
                return mirrorFile;
            }
            File tempJarFile = null;
            try {
                tempJarFile = FileUtil.createTempFile((File)new File(jarDir), (String)originalFile.getName(), (String)"", (boolean)true, (boolean)false);
                try (DataOutputStream os = new DataOutputStream(new FileOutputStream(tempJarFile));
                     FileInputStream is = new FileInputStream(originalFile);){
                    int read2;
                    sha1 = DigestUtil.sha1();
                    sha1.update(String.valueOf(originalAttributes.length).getBytes(Charset.defaultCharset()));
                    sha1.update((byte)0);
                    byte[] buffer = new byte[8192];
                    long totalBytes = 0L;
                    do {
                        if ((read2 = is.read(buffer)) < 0) {
                            break;
                        }
                        sha1.update(buffer, 0, read2);
                        os.write(buffer, 0, read2);
                    } while ((totalBytes += (long)read2) != originalAttributes.length);
                }
            }
            catch (IOException ex) {
                File target2 = mirrorFile != null ? mirrorFile : (tempJarFile != null ? tempJarFile : new File(jarDir));
                this.reportIOErrorWithJars(originalFile, target2, ex);
                return originalFile;
            }
            String mirrorName = JarHandler.getSnapshotName(originalFile.getName(), sha1.digest());
            mirrorFile = new File(jarDir, mirrorName);
            FileAttributes mirrorFileAttributes = FileSystemUtil.getAttributes((File)mirrorFile);
            if (mirrorFileAttributes == null) {
                try {
                    FileUtil.rename((File)tempJarFile, (File)mirrorFile);
                    Files.setLastModifiedTime(mirrorFile.toPath(), FileTime.fromMillis(originalAttributes.lastModified));
                }
                catch (IOException ex) {
                    this.reportIOErrorWithJars(originalFile, mirrorFile, ex);
                    return originalFile;
                }
            } else {
                FileUtil.delete((File)tempJarFile);
            }
            info = new CacheLibraryInfo(mirrorFile.getName(), originalAttributes.lastModified, originalAttributes.length);
            CacheLibraryInfo.ourCachedLibraryInfo.put((Object)path, (Object)info);
            return mirrorFile;
        }
        catch (IOException ex) {
            CacheLibraryInfo.ourCachedLibraryInfo.markCorrupted();
            this.reportIOErrorWithJars(originalFile, mirrorFile != null ? mirrorFile : new File(jarDir, originalFile.getName()), ex);
            return originalFile;
        }
    }

    private static boolean mirrorDiffers(FileAttributes original, @Nullable FileAttributes mirror, boolean permitOlderMirror) {
        if (mirror == null || mirror.length != original.length) {
            return true;
        }
        long timeDiff = mirror.lastModified - original.lastModified;
        if (!permitOlderMirror) {
            timeDiff = Math.abs(timeDiff);
        }
        return timeDiff > 2000L;
    }

    private static String getSnapshotName(String name, byte[] digest) {
        StringBuilder builder2 = new StringBuilder(name.length() + 1 + 2 * digest.length);
        builder2.append(name).append('.');
        for (byte b : digest) {
            builder2.append(Character.forDigit((b & 0xF0) >> 4, 16));
            builder2.append(Character.forDigit(b & 0xF, 16));
        }
        return builder2.toString();
    }

    @NotNull
    private static String getJarsDir() {
        String dir = System.getProperty("jars_dir");
        String string = dir == null ? PathManager.getSystemPath() + File.separatorChar + JARS_FOLDER : dir;
        if (string == null) {
            JarHandler.$$$reportNull$$$0(5);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private File copyToMirror(@NotNull File original, @NotNull File mirror) {
        ProgressIndicator progress;
        if (original == null) {
            JarHandler.$$$reportNull$$$0(6);
        }
        if (mirror == null) {
            JarHandler.$$$reportNull$$$0(7);
        }
        if ((progress = ProgressManager.getInstance().getProgressIndicator()) != null) {
            progress.pushState();
            progress.setText(VfsBundle.message((String)"jar.copy.progress", (Object[])new Object[]{original.getPath()}));
            progress.setFraction(0.0);
        }
        try {
            FileUtil.copy((File)original, (File)mirror);
        }
        catch (IOException e) {
            this.reportIOErrorWithJars(original, mirror, e);
            File file2 = original;
            File file3 = file2;
            if (file3 == null) {
                JarHandler.$$$reportNull$$$0(8);
            }
            return file3;
        }
        finally {
            if (progress != null) {
                progress.popState();
            }
        }
        File file4 = mirror;
        if (file4 == null) {
            JarHandler.$$$reportNull$$$0(9);
        }
        return file4;
    }

    private void reportIOErrorWithJars(File original, File target2, IOException e) {
        LOG.warn((Throwable)e);
        String path = original.getPath();
        this.myFileSystem.setNoCopyJarForPath(path);
        String message = VfsBundle.message((String)"jar.copy.error.message", (Object[])new Object[]{path, target2.getPath(), e.getMessage()});
        ((NotificationGroup)ERROR_COPY_NOTIFICATION.getValue()).createNotification(message, NotificationType.ERROR).notify(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/jar/JarHandler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mirror";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/jar/JarHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileToUse";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEntriesMap";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getJarsDir";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "copyToMirror";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMirrorFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copyToMirror";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CacheLibraryInfo {
        private final String mySnapshotPath;
        private final long myModificationTime;
        private final long myFileLength;
        private static final PersistentHashMap<String, CacheLibraryInfo> ourCachedLibraryInfo;
        private static final int VERSION;

        @NotNull
        private static File getVersionFile(File file2) {
            File file3 = new File(file2.getParentFile(), file2.getName() + ".version");
            if (file3 == null) {
                CacheLibraryInfo.$$$reportNull$$$0(0);
            }
            return file3;
        }

        private static void removeStaleJarFilesIfNeeded(File snapshotInfoFile, PersistentHashMap<String, CacheLibraryInfo> info) throws IOException {
            File versionFile = CacheLibraryInfo.getVersionFile(snapshotInfoFile);
            long lastModified = versionFile.lastModified();
            if (System.currentTimeMillis() - lastModified < 2592000000L) {
                return;
            }
            THashSet availableLibrarySnapshots = ContainerUtil.newTroveSet((Object[])((Object[])ObjectUtils.assertNotNull((Object)snapshotInfoFile.getParentFile().list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    int lastDotPosition = name.lastIndexOf(46);
                    if (lastDotPosition == -1) {
                        return false;
                    }
                    String extension = name.substring(lastDotPosition + 1);
                    return extension.length() == 40 && this.consistsOfHexLetters(extension);
                }

                private boolean consistsOfHexLetters(String extension) {
                    for (int i = 0; i < extension.length(); ++i) {
                        if (Character.digit(extension.charAt(i), 16) != -1) continue;
                        return false;
                    }
                    return true;
                }
            }))));
            ArrayList<String> invalidLibraryFilePaths = new ArrayList<String>();
            ArrayList allLibraryFilePaths = new ArrayList();
            MultiMap jarSnapshotFileToLibraryFilePaths = new MultiMap();
            THashSet validLibraryFilePathToJarSnapshotFilePaths = new THashSet();
            info.processKeys((Processor)new CommonProcessors.CollectProcessor(allLibraryFilePaths));
            for (String filePath : allLibraryFilePaths) {
                CacheLibraryInfo libraryInfo = (CacheLibraryInfo)info.get((Object)filePath);
                if (libraryInfo == null) continue;
                jarSnapshotFileToLibraryFilePaths.putValue((Object)libraryInfo.mySnapshotPath, (Object)filePath);
                if (new File(filePath).exists()) {
                    validLibraryFilePathToJarSnapshotFilePaths.add(filePath);
                    continue;
                }
                invalidLibraryFilePaths.add(filePath);
            }
            for (String invalidLibraryFilePath : invalidLibraryFilePaths) {
                LOG.info("removing stale library reference:" + invalidLibraryFilePath);
                info.remove((Object)invalidLibraryFilePath);
            }
            block2: for (Map.Entry e : jarSnapshotFileToLibraryFilePaths.entrySet()) {
                for (String libraryFilePath : (Collection)e.getValue()) {
                    if (!validLibraryFilePathToJarSnapshotFilePaths.contains(libraryFilePath)) continue;
                    availableLibrarySnapshots.remove(e.getKey());
                    continue block2;
                }
            }
            for (String availableLibrarySnapshot : availableLibrarySnapshots) {
                File librarySnapshotFileToDelete = new File(snapshotInfoFile.getParentFile(), availableLibrarySnapshot);
                LOG.info("removing stale library snapshot:" + librarySnapshotFileToDelete);
                FileUtil.delete((File)librarySnapshotFileToDelete);
            }
            CacheLibraryInfo.saveVersion(versionFile);
        }

        private static void saveVersion(File versionFile) {
            try (DataOutputStream versionOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(versionFile)));){
                DataInputOutputUtil.writeINT((DataOutput)versionOutputStream, (int)VERSION);
                DataInputOutputUtil.writeTIME((DataOutput)versionOutputStream, (long)FSRecords.getCreationTimestamp());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private static void flushCachedLibraryInfos() {
            if (ourCachedLibraryInfo.isDirty()) {
                ourCachedLibraryInfo.force();
            }
        }

        /*
         * WARNING - void declaration
         */
        private CacheLibraryInfo(@NotNull String path, long time, long l) {
            void length;
            if (path == null) {
                CacheLibraryInfo.$$$reportNull$$$0(1);
            }
            this.mySnapshotPath = path;
            this.myModificationTime = time;
            this.myFileLength = length;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheLibraryInfo info = (CacheLibraryInfo)o;
            if (this.myFileLength != info.myFileLength) {
                return false;
            }
            if (this.myModificationTime != info.myModificationTime) {
                return false;
            }
            return this.mySnapshotPath.equals(info.mySnapshotPath);
        }

        public int hashCode() {
            int result2 = this.mySnapshotPath.hashCode();
            result2 = 31 * result2 + (int)(this.myModificationTime ^ this.myModificationTime >>> 32);
            result2 = 31 * result2 + (int)(this.myFileLength ^ this.myFileLength >>> 32);
            return result2;
        }

        static {
            VERSION = 1 + (PersistentHashMapValueStorage.COMPRESSION_ENABLED ? 15 : 0);
            File jarsDir = new File(JarHandler.getJarsDir());
            File snapshotInfoFile = new File(jarsDir, "snapshots_info");
            int currentVersion = -1;
            long currentVfsVersion = -1L;
            File versionFile = CacheLibraryInfo.getVersionFile(snapshotInfoFile);
            if (versionFile.exists()) {
                try (DataInputStream versionStream2 = new DataInputStream(new BufferedInputStream(new FileInputStream(versionFile)));){
                    currentVersion = DataInputOutputUtil.readINT((DataInput)versionStream2);
                    currentVfsVersion = DataInputOutputUtil.readTIME((DataInput)versionStream2);
                }
                catch (IOException versionStream2) {
                    // empty catch block
                }
            }
            if (currentVfsVersion != FSRecords.getCreationTimestamp()) {
                FileUtil.deleteWithRenaming((File)jarsDir);
                FileUtil.createDirectory((File)jarsDir);
                CacheLibraryInfo.saveVersion(versionFile);
            } else if (currentVersion != VERSION) {
                PersistentHashMap.deleteFilesStartingWith((File)snapshotInfoFile);
                CacheLibraryInfo.saveVersion(versionFile);
            }
            PersistentHashMap info = null;
            for (int i = 0; i < 2; ++i) {
                try {
                    info = new PersistentHashMap(snapshotInfoFile, (KeyDescriptor)EnumeratorStringDescriptor.INSTANCE, (DataExternalizer)new DataExternalizer<CacheLibraryInfo>(){

                        public void save(@NotNull DataOutput out, CacheLibraryInfo value) throws IOException {
                            if (out == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            IOUtil.writeUTF((DataOutput)out, (String)value.mySnapshotPath);
                            DataInputOutputUtil.writeTIME((DataOutput)out, (long)value.myModificationTime);
                            DataInputOutputUtil.writeLONG((DataOutput)out, (long)value.myFileLength);
                        }

                        public CacheLibraryInfo read(@NotNull DataInput in) throws IOException {
                            if (in == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            return new CacheLibraryInfo(IOUtil.readUTF((DataInput)in), DataInputOutputUtil.readTIME((DataInput)in), DataInputOutputUtil.readLONG((DataInput)in));
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "out";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "in";
                                    break;
                                }
                            }
                            objectArray2[1] = "com/intellij/openapi/vfs/impl/jar/JarHandler$CacheLibraryInfo$1";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "save";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "read";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    });
                    if (i != 0) break;
                    CacheLibraryInfo.removeStaleJarFilesIfNeeded(snapshotInfoFile, (PersistentHashMap<String, CacheLibraryInfo>)info);
                    break;
                }
                catch (IOException ex) {
                    if (info != null) {
                        try {
                            info.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    PersistentHashMap.deleteFilesStartingWith((File)snapshotInfoFile);
                    CacheLibraryInfo.saveVersion(versionFile);
                    continue;
                }
            }
            assert (info != null);
            ourCachedLibraryInfo = info;
            FlushingDaemon.everyFiveSeconds(CacheLibraryInfo::flushCachedLibraryInfos);
            ShutDownTracker.getInstance().registerShutdownTask(CacheLibraryInfo::flushCachedLibraryInfos);
            Disposer.register((Disposable)ApplicationManager.getApplication(), () -> {
                try {
                    ourCachedLibraryInfo.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vfs/impl/jar/JarHandler$CacheLibraryInfo";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVersionFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vfs/impl/jar/JarHandler$CacheLibraryInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

