/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CheckedActionGroup;
import com.intellij.openapi.actionSystem.CompactActionGroup;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.actionSystem.impl.ActionMenuItem;
import com.intellij.openapi.actionSystem.impl.ActionUpdater;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class Utils {
    private static final Logger LOG = Logger.getInstance(Utils.class);
    @NonNls
    public static final String NOTHING_HERE = "Nothing here";
    public static final AnAction EMPTY_MENU_FILLER = new AnAction("Nothing here"){
        {
            this.getTemplatePresentation().setEnabled(false);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                1.$$$reportNull$$$0(0);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                1.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/actionSystem/impl/Utils$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    public static List<AnAction> expandActionGroup(boolean isInModalContext, @NotNull ActionGroup group, PresentationFactory presentationFactory, @NotNull DataContext context, String place) {
        if (group == null) {
            Utils.$$$reportNull$$$0(0);
        }
        if (context == null) {
            Utils.$$$reportNull$$$0(1);
        }
        return new ActionUpdater(isInModalContext, presentationFactory, context, place, false, false, false).expandActionGroup(group, group instanceof CompactActionGroup);
    }

    static void fillMenu(@NotNull ActionGroup group, final JComponent component, boolean enableMnemonics, PresentationFactory presentationFactory, @NotNull DataContext context, String place, boolean isWindowMenu, boolean isInModalContext, boolean useDarkIcons) {
        if (group == null) {
            Utils.$$$reportNull$$$0(2);
        }
        if (context == null) {
            Utils.$$$reportNull$$$0(3);
        }
        boolean checked = group instanceof CheckedActionGroup;
        ActionUpdater updater = new ActionUpdater(isInModalContext, presentationFactory, context, place, true, false, false);
        List<AnAction> list2 = updater.expandActionGroupWithTimeout(group, group instanceof CompactActionGroup);
        boolean fixMacScreenMenu = SystemInfo.isMacSystemMenu && isWindowMenu && Registry.is((String)"actionSystem.mac.screenMenuNotUpdatedFix");
        ArrayList<Object> children2 = new ArrayList<Object>();
        int size = list2.size();
        for (int i = 0; i < size; ++i) {
            AnAction action2 = list2.get(i);
            Presentation presentation = presentationFactory.getPresentation(action2);
            if (!(action2 instanceof Separator) && presentation.isVisible() && StringUtil.isEmpty((String)presentation.getText())) {
                String message = "Skipping empty menu item for action " + action2 + " of " + action2.getClass();
                if (action2.getTemplatePresentation().getText() == null) {
                    message = message + ". Please specify some default action text in plugin.xml or action constructor";
                }
                LOG.warn(message);
                continue;
            }
            if (action2 instanceof Separator) {
                final String text2 = ((Separator)action2).getText();
                if (StringUtil.isEmpty((String)text2) && (i <= 0 || i >= size - 1)) continue;
                component.add(new JPopupMenu.Separator(){
                    private final JMenuItem myMenu;
                    {
                        this.myMenu = !StringUtil.isEmpty((String)text2) ? new JMenuItem(text2) : null;
                    }

                    @Override
                    public void doLayout() {
                        super.doLayout();
                        if (this.myMenu != null) {
                            this.myMenu.setBounds(this.getBounds());
                        }
                    }

                    @Override
                    protected void paintComponent(Graphics g) {
                        if (UIUtil.isUnderDarcula() || UIUtil.isUnderWin10LookAndFeel()) {
                            g.setColor(component.getBackground());
                            g.fillRect(0, 0, this.getWidth(), this.getHeight());
                        }
                        if (this.myMenu != null) {
                            this.myMenu.paint(g);
                        } else {
                            super.paintComponent(g);
                        }
                    }

                    @Override
                    public Dimension getPreferredSize() {
                        return this.myMenu != null ? this.myMenu.getPreferredSize() : super.getPreferredSize();
                    }
                });
                continue;
            }
            if (action2 instanceof ActionGroup && (!updater.canBePerformedCached((ActionGroup)action2) || updater.hasVisibleChildren((ActionGroup)action2))) {
                ActionMenu menu2 = new ActionMenu(context, place, (ActionGroup)action2, presentationFactory, enableMnemonics, useDarkIcons);
                component.add((Component)((Object)menu2));
                children2.add((Object)menu2);
                continue;
            }
            ActionMenuItem each = new ActionMenuItem(action2, presentation, place, context, enableMnemonics, !fixMacScreenMenu, checked, useDarkIcons);
            component.add((Component)((Object)each));
            children2.add((Object)each);
        }
        if (list2.isEmpty()) {
            ActionMenuItem each = new ActionMenuItem(EMPTY_MENU_FILLER, presentationFactory.getPresentation(EMPTY_MENU_FILLER), place, context, enableMnemonics, !fixMacScreenMenu, checked, useDarkIcons);
            component.add((Component)((Object)each));
            children2.add((Object)each);
        }
        if (fixMacScreenMenu) {
            SwingUtilities.invokeLater(() -> {
                for (Component each : children2) {
                    if (each.getParent() == null || !(each instanceof ActionMenuItem)) continue;
                    ((ActionMenuItem)((Object)((Object)each))).prepare();
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/actionSystem/impl/Utils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "expandActionGroup";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fillMenu";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

