/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class Locations {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.gdpr.Locations");
    private static final File ourDataDir;

    public static File getDataRoot() {
        return ourDataDir;
    }

    @NotNull
    private static String getRelativeResourcePath() {
        String string;
        try {
            ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
            String path = appInfo.getShortCompanyName();
            string = appInfo.isVendorJetBrains() ? "JetBrains" : (path == null ? "unknown_vendor" : path.trim().replace(' ', '_'));
        }
        catch (Throwable e) {
            LOG.info("Problems initializing location path", e);
            if ("JetBrains" == null) {
                Locations.$$$reportNull$$$0(1);
            }
            return "JetBrains";
        }
        if (string == null) {
            Locations.$$$reportNull$$$0(0);
        }
        return string;
    }

    static {
        String relativeResourcePath = Locations.getRelativeResourcePath();
        File dataDir = null;
        if (SystemInfo.isWindows) {
            String appdata = System.getenv("APPDATA");
            if (appdata != null) {
                dataDir = new File(appdata, relativeResourcePath);
            }
        } else {
            String userHome = System.getProperty("user.home");
            if (userHome != null) {
                if (SystemInfo.isMac) {
                    File dataRoot = new File(userHome, "/Library/Application Support");
                    if (dataRoot.exists()) {
                        dataDir = new File(dataRoot, relativeResourcePath);
                    }
                } else if (SystemInfo.isUnix) {
                    File dataRoot;
                    String dataHome = System.getenv("XDG_DATA_HOME");
                    File file2 = dataRoot = dataHome == null ? new File(userHome, ".local/share") : new File(dataHome);
                    if (dataRoot.exists()) {
                        dataDir = new File(dataRoot, relativeResourcePath);
                    }
                }
            }
        }
        if (dataDir == null) {
            dataDir = new File(PathManager.getSystemPath());
        }
        dataDir.mkdirs();
        ourDataDir = dataDir;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/gdpr/Locations", "getRelativeResourcePath"));
    }
}

