/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.BaseContentCloseListener;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentWithExecutorListener;
import com.intellij.execution.ui.layout.impl.DockableGridContainerFactory;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.docking.DockContainerFactory;
import com.intellij.ui.docking.DockManager;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunContentManagerImpl
implements RunContentManager,
Disposable {
    public static final Key<Boolean> ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY = Key.create((String)"ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY");
    private static final Logger LOG = Logger.getInstance(RunContentManagerImpl.class);
    private static final Key<Executor> EXECUTOR_KEY = Key.create((String)"Executor");
    private static final Key<ContentManagerListener> CLOSE_LISTENER_KEY = Key.create((String)"CloseListener");
    private final Project myProject;
    private final Map<String, ContentManager> myToolwindowIdToContentManagerMap;
    private final Map<String, Icon> myToolwindowIdToBaseIconMap;
    private final ConcurrentLinkedDeque<String> myToolwindowIdZBuffer;

    public RunContentManagerImpl(@NotNull Project project, @NotNull DockManager dockManager) {
        if (project == null) {
            RunContentManagerImpl.$$$reportNull$$$0(0);
        }
        if (dockManager == null) {
            RunContentManagerImpl.$$$reportNull$$$0(1);
        }
        this.myToolwindowIdToContentManagerMap = new THashMap();
        this.myToolwindowIdToBaseIconMap = new THashMap();
        this.myToolwindowIdZBuffer = new ConcurrentLinkedDeque();
        this.myProject = project;
        DockableGridContainerFactory containerFactory = new DockableGridContainerFactory();
        dockManager.register("runner-grid", (DockContainerFactory)containerFactory);
        Disposer.register((Disposable)this.myProject, (Disposable)containerFactory);
        AppUIUtil.invokeOnEdt(() -> this.init(), this.myProject.getDisposed());
    }

    private void init() {
        ToolWindowManagerEx toolWindowManager = ToolWindowManagerEx.getInstanceEx(this.myProject);
        if (toolWindowManager == null) {
            return;
        }
        for (Executor executor : ExecutorRegistry.getInstance().getRegisteredExecutors()) {
            this.registerToolWindow(executor, toolWindowManager);
        }
        RunDashboardManager dashboardManager = RunDashboardManager.getInstance((Project)this.myProject);
        dashboardManager.updateDashboard(true);
        this.initToolWindow(null, dashboardManager.getToolWindowId(), dashboardManager.getToolWindowIcon(), dashboardManager.getDashboardContentManager());
        this.myProject.getMessageBus().connect().subscribe(ToolWindowManagerListener.TOPIC, (Object)new ToolWindowManagerListener(){

            @Override
            public void stateChanged() {
                if (RunContentManagerImpl.this.myProject.isDisposed()) {
                    return;
                }
                ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)RunContentManagerImpl.this.myProject);
                THashSet currentWindows = new THashSet();
                ContainerUtil.addAll((Collection)currentWindows, (Object[])toolWindowManager.getToolWindowIds());
                RunContentManagerImpl.this.myToolwindowIdZBuffer.retainAll((Collection<?>)currentWindows);
                String activeToolWindowId = toolWindowManager.getActiveToolWindowId();
                if (activeToolWindowId != null && RunContentManagerImpl.this.myToolwindowIdZBuffer.remove(activeToolWindowId)) {
                    RunContentManagerImpl.this.myToolwindowIdZBuffer.addFirst(activeToolWindowId);
                }
            }
        });
    }

    public void dispose() {
    }

    private void registerToolWindow(final @NotNull Executor executor, @NotNull ToolWindowManagerEx toolWindowManager) {
        String toolWindowId;
        if (executor == null) {
            RunContentManagerImpl.$$$reportNull$$$0(2);
        }
        if (toolWindowManager == null) {
            RunContentManagerImpl.$$$reportNull$$$0(3);
        }
        if (toolWindowManager.getToolWindow(toolWindowId = executor.getToolWindowId()) != null) {
            return;
        }
        ToolWindow toolWindow = toolWindowManager.registerToolWindow(toolWindowId, true, ToolWindowAnchor.BOTTOM, this, true);
        final ContentManager contentManager = toolWindow.getContentManager();
        contentManager.addDataProvider(new DataProvider(){
            private int myInsideGetData = 0;

            public Object getData(@NotNull String dataId) {
                if (dataId == null) {
                    2.$$$reportNull$$$0(0);
                }
                ++this.myInsideGetData;
                try {
                    if (PlatformDataKeys.HELP_ID.is(dataId)) {
                        String string = executor.getHelpId();
                        return string;
                    }
                    Object object = this.myInsideGetData == 1 ? DataManager.getInstance().getDataContext((Component)contentManager.getComponent()).getData(dataId) : null;
                    return object;
                }
                finally {
                    --this.myInsideGetData;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/execution/ui/RunContentManagerImpl$2", "getData"));
            }
        });
        toolWindow.setIcon(executor.getToolWindowIcon());
        new ContentManagerWatcher(toolWindow, contentManager);
        this.initToolWindow(executor, toolWindowId, executor.getToolWindowIcon(), contentManager);
    }

    private void initToolWindow(final @Nullable Executor executor, final String toolWindowId, Icon toolWindowIcon, ContentManager contentManager) {
        this.myToolwindowIdToBaseIconMap.put(toolWindowId, toolWindowIcon);
        contentManager.addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

            public void selectionChanged(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (event.getOperation() == ContentManagerEvent.ContentOperation.add) {
                    Content content2 = event.getContent();
                    Executor contentExecutor = executor;
                    if (contentExecutor == null) {
                        contentExecutor = RunContentManagerImpl.getExecutorByContent(content2);
                        LOG.assertTrue(contentExecutor != null);
                    }
                    RunContentManagerImpl.this.getSyncPublisher().contentSelected(RunContentManagerImpl.getRunContentDescriptorByContent(content2), contentExecutor);
                    content2.setHelpId(contentExecutor.getHelpId());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/ui/RunContentManagerImpl$3", "selectionChanged"));
            }
        });
        this.myToolwindowIdToContentManagerMap.put(toolWindowId, contentManager);
        Disposer.register((Disposable)contentManager, (Disposable)new Disposable(){

            public void dispose() {
                ((ContentManager)RunContentManagerImpl.this.myToolwindowIdToContentManagerMap.remove(toolWindowId)).removeAllContents(true);
                RunContentManagerImpl.this.myToolwindowIdZBuffer.remove(toolWindowId);
                RunContentManagerImpl.this.myToolwindowIdToBaseIconMap.remove(toolWindowId);
            }
        });
        this.myToolwindowIdZBuffer.addLast(toolWindowId);
    }

    private RunContentWithExecutorListener getSyncPublisher() {
        return (RunContentWithExecutorListener)this.myProject.getMessageBus().syncPublisher(TOPIC);
    }

    public void toFrontRunContent(@NotNull Executor requestor, @NotNull ProcessHandler handler2) {
        RunContentDescriptor descriptor2;
        if (requestor == null) {
            RunContentManagerImpl.$$$reportNull$$$0(4);
        }
        if (handler2 == null) {
            RunContentManagerImpl.$$$reportNull$$$0(5);
        }
        if ((descriptor2 = this.getDescriptorBy(handler2, requestor)) == null) {
            return;
        }
        this.toFrontRunContent(requestor, descriptor2);
    }

    public void toFrontRunContent(@NotNull Executor requestor, @NotNull RunContentDescriptor descriptor2) {
        if (requestor == null) {
            RunContentManagerImpl.$$$reportNull$$$0(6);
        }
        if (descriptor2 == null) {
            RunContentManagerImpl.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            ContentManager contentManager = this.getContentManagerForRunner(requestor, descriptor2);
            Content content2 = RunContentManagerImpl.getRunContentByDescriptor(contentManager, descriptor2);
            if (content2 != null) {
                contentManager.setSelectedContent(content2);
                ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(RunContentManagerImpl.getToolWindowIdForRunner(requestor, descriptor2)).show(null);
            }
        }, this.myProject.getDisposed());
    }

    public void hideRunContent(@NotNull Executor executor, RunContentDescriptor descriptor2) {
        if (executor == null) {
            RunContentManagerImpl.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(RunContentManagerImpl.getToolWindowIdForRunner(executor, descriptor2));
            if (toolWindow != null) {
                toolWindow.hide(null);
            }
        }, this.myProject.getDisposed());
    }

    @Nullable
    public RunContentDescriptor getSelectedContent(Executor executor) {
        Content selectedContent = this.getContentManagerForRunner(executor, null).getSelectedContent();
        return selectedContent != null ? RunContentManagerImpl.getRunContentDescriptorByContent(selectedContent) : null;
    }

    @Nullable
    public RunContentDescriptor getSelectedContent() {
        for (String activeWindow : this.myToolwindowIdZBuffer) {
            ContentManager contentManager = this.myToolwindowIdToContentManagerMap.get(activeWindow);
            if (contentManager == null) continue;
            Content selectedContent = contentManager.getSelectedContent();
            if (selectedContent == null) {
                if (contentManager.getContentCount() != 0) break;
                continue;
            }
            return RunContentManagerImpl.getRunContentDescriptorByContent(selectedContent);
        }
        return null;
    }

    public boolean removeRunContent(@NotNull Executor executor, @NotNull RunContentDescriptor descriptor2) {
        ContentManager contentManager;
        Content content2;
        if (executor == null) {
            RunContentManagerImpl.$$$reportNull$$$0(9);
        }
        if (descriptor2 == null) {
            RunContentManagerImpl.$$$reportNull$$$0(10);
        }
        return (content2 = RunContentManagerImpl.getRunContentByDescriptor(contentManager = this.getContentManagerForRunner(executor, descriptor2), descriptor2)) != null && contentManager.removeContent(content2, true);
    }

    public void showRunContent(@NotNull Executor executor, @NotNull RunContentDescriptor descriptor2) {
        if (executor == null) {
            RunContentManagerImpl.$$$reportNull$$$0(11);
        }
        if (descriptor2 == null) {
            RunContentManagerImpl.$$$reportNull$$$0(12);
        }
        this.showRunContent(executor, descriptor2, descriptor2.getExecutionId());
    }

    private void showRunContent(final @NotNull Executor executor, final @NotNull RunContentDescriptor descriptor2, long executionId) {
        Content content2;
        if (executor == null) {
            RunContentManagerImpl.$$$reportNull$$$0(13);
        }
        if (descriptor2 == null) {
            RunContentManagerImpl.$$$reportNull$$$0(14);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ContentManager contentManager = this.getContentManagerForRunner(executor, descriptor2);
        final String toolWindowId = RunContentManagerImpl.getToolWindowIdForRunner(executor, descriptor2);
        RunDashboardManager runDashboardManager = RunDashboardManager.getInstance((Project)this.myProject);
        Condition reuseCondition = runDashboardManager.getToolWindowId().equals(toolWindowId) ? runDashboardManager.getReuseCondition() : null;
        RunContentDescriptor oldDescriptor = RunContentManagerImpl.chooseReuseContentForDescriptor(contentManager, descriptor2, executionId, descriptor2.getDisplayName(), (Condition<? super Content>)reuseCondition);
        if (oldDescriptor == null) {
            content2 = RunContentManagerImpl.createNewContent(descriptor2, executor);
        } else {
            content2 = oldDescriptor.getAttachedContent();
            LOG.assertTrue(content2 != null);
            this.getSyncPublisher().contentRemoved(oldDescriptor, executor);
            Disposer.dispose((Disposable)oldDescriptor);
        }
        content2.setExecutionId(executionId);
        content2.setComponent(descriptor2.getComponent());
        content2.setPreferredFocusedComponent(descriptor2.getPreferredFocusComputable());
        content2.putUserData(RunContentDescriptor.DESCRIPTOR_KEY, (Object)descriptor2);
        content2.putUserData(EXECUTOR_KEY, (Object)executor);
        content2.setDisplayName(descriptor2.getDisplayName());
        descriptor2.setAttachedContent(content2);
        final ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(toolWindowId);
        final ProcessHandler processHandler2 = descriptor2.getProcessHandler();
        if (processHandler2 != null) {
            final ProcessAdapter processAdapter = new ProcessAdapter(){

                public void startNotified(@NotNull ProcessEvent event) {
                    if (event == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    UIUtil.invokeLaterIfNeeded(() -> {
                        content2.setIcon(ExecutionUtil.getLiveIndicator((Icon)descriptor2.getIcon()));
                        toolWindow.setIcon(ExecutionUtil.getLiveIndicator((Icon)((Icon)RunContentManagerImpl.this.myToolwindowIdToBaseIconMap.get(toolWindowId))));
                    });
                }

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        5.$$$reportNull$$$0(1);
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        ContentManager manager = (ContentManager)RunContentManagerImpl.this.myToolwindowIdToContentManagerMap.get(toolWindowId);
                        if (manager == null) {
                            return;
                        }
                        boolean alive = RunContentManagerImpl.isAlive(manager);
                        Icon base = (Icon)RunContentManagerImpl.this.myToolwindowIdToBaseIconMap.get(toolWindowId);
                        toolWindow.setIcon(alive ? ExecutionUtil.getLiveIndicator((Icon)base) : base);
                        Icon icon = descriptor2.getIcon();
                        content2.setIcon(icon == null ? executor.getDisabledIcon() : IconLoader.getTransparentIcon((Icon)icon));
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "event";
                    objectArray2[1] = "com/intellij/execution/ui/RunContentManagerImpl$5";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "startNotified";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processTerminated";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            processHandler2.addProcessListener((ProcessListener)processAdapter);
            Disposable disposer = content2.getDisposer();
            if (disposer != null) {
                Disposer.register((Disposable)disposer, (Disposable)new Disposable(){

                    public void dispose() {
                        processHandler2.removeProcessListener((ProcessListener)processAdapter);
                    }
                });
            }
        }
        if (oldDescriptor == null) {
            contentManager.addContent(content2);
            CloseListener listener2 = new CloseListener(content2, executor);
            content2.putUserData(CLOSE_LISTENER_KEY, (Object)listener2);
        }
        if (descriptor2.isSelectContentWhenAdded() || oldDescriptor != null && contentManager.isSelected(content2)) {
            content2.getManager().setSelectedContent(content2);
        }
        if (!descriptor2.isActivateToolWindowWhenAdded()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            ToolWindow window = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(toolWindowId);
            window.activate(descriptor2.getActivationCallback(), descriptor2.isAutoFocusContent(), descriptor2.isAutoFocusContent());
        }, this.myProject.getDisposed());
    }

    @Nullable
    public RunContentDescriptor getReuseContent(@NotNull ExecutionEnvironment executionEnvironment) {
        if (executionEnvironment == null) {
            RunContentManagerImpl.$$$reportNull$$$0(15);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        RunContentDescriptor contentToReuse = executionEnvironment.getContentToReuse();
        if (contentToReuse != null) {
            return contentToReuse;
        }
        String toolWindowId = this.getContentDescriptorToolWindowId(executionEnvironment);
        ContentManager contentManager = toolWindowId == null ? this.getContentManagerForRunner(executionEnvironment.getExecutor(), null) : this.myToolwindowIdToContentManagerMap.get(toolWindowId);
        RunDashboardManager runDashboardManager = RunDashboardManager.getInstance((Project)this.myProject);
        Condition reuseCondition = runDashboardManager.getToolWindowId().equals(toolWindowId) ? runDashboardManager.getReuseCondition() : null;
        return RunContentManagerImpl.chooseReuseContentForDescriptor(contentManager, null, executionEnvironment.getExecutionId(), executionEnvironment.toString(), (Condition<? super Content>)reuseCondition);
    }

    public RunContentDescriptor findContentDescriptor(Executor requestor, ProcessHandler handler2) {
        return this.getDescriptorBy(handler2, requestor);
    }

    public void showRunContent(@NotNull Executor info, @NotNull RunContentDescriptor descriptor2, @Nullable RunContentDescriptor contentToReuse) {
        if (info == null) {
            RunContentManagerImpl.$$$reportNull$$$0(16);
        }
        if (descriptor2 == null) {
            RunContentManagerImpl.$$$reportNull$$$0(17);
        }
        RunContentManagerImpl.copyContentAndBehavior(descriptor2, contentToReuse);
        this.showRunContent(info, descriptor2, descriptor2.getExecutionId());
    }

    public static void copyContentAndBehavior(@NotNull RunContentDescriptor descriptor2, @Nullable RunContentDescriptor contentToReuse) {
        if (descriptor2 == null) {
            RunContentManagerImpl.$$$reportNull$$$0(18);
        }
        if (contentToReuse != null) {
            Content attachedContent = contentToReuse.getAttachedContent();
            if (attachedContent != null && attachedContent.isValid()) {
                descriptor2.setAttachedContent(attachedContent);
            }
            if (contentToReuse.isReuseToolWindowActivation()) {
                descriptor2.setActivateToolWindowWhenAdded(contentToReuse.isActivateToolWindowWhenAdded());
            }
            descriptor2.setContentToolWindowId(contentToReuse.getContentToolWindowId());
            descriptor2.setSelectContentWhenAdded(contentToReuse.isSelectContentWhenAdded());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static RunContentDescriptor chooseReuseContentForDescriptor(@NotNull ContentManager contentManager, @Nullable RunContentDescriptor descriptor2, long executionId, @Nullable String preferredName, @Nullable Condition<? super Content> condition) {
        if (contentManager == null) {
            RunContentManagerImpl.$$$reportNull$$$0(19);
        }
        Content content2 = null;
        if (descriptor2 != null) {
            if (descriptor2.isContentReuseProhibited()) {
                return null;
            }
            Content attachedContent = descriptor2.getAttachedContent();
            if (attachedContent != null && attachedContent.isValid() && contentManager.getIndexOfContent(attachedContent) != -1 && (Comparing.equal((String)descriptor2.getDisplayName(), (String)attachedContent.getDisplayName()) || !attachedContent.isPinned())) {
                content2 = attachedContent;
            }
        }
        if (content2 == null) {
            void reuseCondition;
            content2 = RunContentManagerImpl.getContentFromManager(contentManager, preferredName, executionId, (Condition<? super Content>)reuseCondition);
        }
        if (content2 == null || !RunContentManagerImpl.isTerminated(content2) || content2.getExecutionId() == executionId && executionId != 0L) {
            return null;
        }
        RunContentDescriptor oldDescriptor = RunContentManagerImpl.getRunContentDescriptorByContent(content2);
        if (oldDescriptor != null) {
            if (oldDescriptor.isContentReuseProhibited()) {
                return null;
            }
            if (descriptor2 == null || oldDescriptor.getReusePolicy().canBeReusedBy(descriptor2)) {
                return oldDescriptor;
            }
        }
        return null;
    }

    @Nullable
    private static Content getContentFromManager(ContentManager contentManager, @Nullable String preferredName, long executionId, @Nullable Condition<? super Content> reuseCondition) {
        ArrayList<Content> contents = new ArrayList<Content>(Arrays.asList(contentManager.getContents()));
        Content first = contentManager.getSelectedContent();
        if (first != null && contents.remove(first)) {
            contents.add(0, first);
        }
        if (preferredName != null) {
            for (Content c2 : contents) {
                if (!RunContentManagerImpl.canReuseContent(c2, executionId) || !preferredName.equals(c2.getDisplayName())) continue;
                return c2;
            }
        }
        for (Content c2 : contents) {
            if (!RunContentManagerImpl.canReuseContent(c2, executionId) || reuseCondition != null && !reuseCondition.value((Object)c2)) continue;
            return c2;
        }
        return null;
    }

    private static boolean canReuseContent(Content c2, long executionId) {
        return c2 != null && !c2.isPinned() && RunContentManagerImpl.isTerminated(c2) && (c2.getExecutionId() != executionId || executionId == 0L);
    }

    @NotNull
    private ContentManager getContentManagerForRunner(Executor executor, RunContentDescriptor descriptor2) {
        ContentManager contentManager = this.myToolwindowIdToContentManagerMap.get(RunContentManagerImpl.getToolWindowIdForRunner(executor, descriptor2));
        if (contentManager == null) {
            LOG.error("Runner " + executor.getId() + " is not registered");
        }
        ContentManager contentManager2 = contentManager;
        if (contentManager2 == null) {
            RunContentManagerImpl.$$$reportNull$$$0(20);
        }
        return contentManager2;
    }

    private static String getToolWindowIdForRunner(Executor executor, RunContentDescriptor descriptor2) {
        if (descriptor2 != null && descriptor2.getContentToolWindowId() != null) {
            return descriptor2.getContentToolWindowId();
        }
        return executor.getToolWindowId();
    }

    private static Content createNewContent(RunContentDescriptor descriptor2, Executor executor) {
        String processDisplayName = descriptor2.getDisplayName();
        Content content2 = ContentFactory.SERVICE.getInstance().createContent(descriptor2.getComponent(), processDisplayName, true);
        content2.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
        Icon icon = descriptor2.getIcon();
        content2.setIcon(icon == null ? executor.getToolWindowIcon() : icon);
        return content2;
    }

    public static boolean isTerminated(@NotNull Content content2) {
        RunContentDescriptor descriptor2;
        if (content2 == null) {
            RunContentManagerImpl.$$$reportNull$$$0(21);
        }
        ProcessHandler processHandler2 = (descriptor2 = RunContentManagerImpl.getRunContentDescriptorByContent(content2)) == null ? null : descriptor2.getProcessHandler();
        return processHandler2 == null || processHandler2.isProcessTerminated();
    }

    @Nullable
    public static RunContentDescriptor getRunContentDescriptorByContent(@NotNull Content content2) {
        if (content2 == null) {
            RunContentManagerImpl.$$$reportNull$$$0(22);
        }
        return (RunContentDescriptor)content2.getUserData(RunContentDescriptor.DESCRIPTOR_KEY);
    }

    @Nullable
    public static Executor getExecutorByContent(@NotNull Content content2) {
        if (content2 == null) {
            RunContentManagerImpl.$$$reportNull$$$0(23);
        }
        return (Executor)content2.getUserData(EXECUTOR_KEY);
    }

    @Nullable
    public ToolWindow getToolWindowByDescriptor(@NotNull RunContentDescriptor descriptor2) {
        if (descriptor2 == null) {
            RunContentManagerImpl.$$$reportNull$$$0(24);
        }
        for (Map.Entry<String, ContentManager> entry : this.myToolwindowIdToContentManagerMap.entrySet()) {
            if (RunContentManagerImpl.getRunContentByDescriptor(entry.getValue(), descriptor2) == null) continue;
            return ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(entry.getKey());
        }
        return null;
    }

    @Nullable
    private static Content getRunContentByDescriptor(@NotNull ContentManager contentManager, @NotNull RunContentDescriptor descriptor2) {
        if (contentManager == null) {
            RunContentManagerImpl.$$$reportNull$$$0(25);
        }
        if (descriptor2 == null) {
            RunContentManagerImpl.$$$reportNull$$$0(26);
        }
        for (Content content2 : contentManager.getContents()) {
            if (!descriptor2.equals(RunContentManagerImpl.getRunContentDescriptorByContent(content2))) continue;
            return content2;
        }
        return null;
    }

    @NotNull
    public List<RunContentDescriptor> getAllDescriptors() {
        if (this.myToolwindowIdToContentManagerMap.isEmpty()) {
            List<RunContentDescriptor> list2 = Collections.emptyList();
            if (list2 == null) {
                RunContentManagerImpl.$$$reportNull$$$0(27);
            }
            return list2;
        }
        SmartList descriptors = new SmartList();
        for (String id : this.myToolwindowIdToContentManagerMap.keySet()) {
            for (Content content2 : this.myToolwindowIdToContentManagerMap.get(id).getContents()) {
                RunContentDescriptor descriptor2 = RunContentManagerImpl.getRunContentDescriptorByContent(content2);
                if (descriptor2 == null) continue;
                descriptors.add(descriptor2);
            }
        }
        SmartList smartList = descriptors;
        if (smartList == null) {
            RunContentManagerImpl.$$$reportNull$$$0(28);
        }
        return smartList;
    }

    public void selectRunContent(@NotNull RunContentDescriptor descriptor2) {
        if (descriptor2 == null) {
            RunContentManagerImpl.$$$reportNull$$$0(29);
        }
        for (Map.Entry<String, ContentManager> entry : this.myToolwindowIdToContentManagerMap.entrySet()) {
            Content content2 = RunContentManagerImpl.getRunContentByDescriptor(entry.getValue(), descriptor2);
            if (content2 == null) continue;
            entry.getValue().setSelectedContent(content2);
        }
    }

    @Nullable
    public String getContentDescriptorToolWindowId(@Nullable RunConfiguration configuration) {
        RunDashboardManager runDashboardManager;
        if (configuration != null && (runDashboardManager = RunDashboardManager.getInstance((Project)this.myProject)).isShowInDashboard(configuration)) {
            return runDashboardManager.getToolWindowId();
        }
        return null;
    }

    @NotNull
    public String getToolWindowIdByEnvironment(@NotNull ExecutionEnvironment executionEnvironment) {
        String toolWindowId;
        if (executionEnvironment == null) {
            RunContentManagerImpl.$$$reportNull$$$0(30);
        }
        String string = (toolWindowId = this.getContentDescriptorToolWindowId(executionEnvironment)) != null ? toolWindowId : executionEnvironment.getExecutor().getToolWindowId();
        if (string == null) {
            RunContentManagerImpl.$$$reportNull$$$0(31);
        }
        return string;
    }

    @Nullable
    private RunContentDescriptor getDescriptorBy(ProcessHandler handler2, Executor runnerInfo) {
        ArrayList contents = new ArrayList();
        ContainerUtil.addAll(contents, (Object[])this.getContentManagerForRunner(runnerInfo, null).getContents());
        ContainerUtil.addAll(contents, (Object[])this.myToolwindowIdToContentManagerMap.get(RunDashboardManager.getInstance((Project)this.myProject).getToolWindowId()).getContents());
        for (Content content2 : contents) {
            RunContentDescriptor runContentDescriptor = RunContentManagerImpl.getRunContentDescriptorByContent(content2);
            assert (runContentDescriptor != null);
            if (runContentDescriptor.getProcessHandler() != handler2) continue;
            return runContentDescriptor;
        }
        return null;
    }

    public void moveContent(@NotNull Executor executor, @NotNull RunContentDescriptor descriptor2) {
        Content content2;
        if (executor == null) {
            RunContentManagerImpl.$$$reportNull$$$0(32);
        }
        if (descriptor2 == null) {
            RunContentManagerImpl.$$$reportNull$$$0(33);
        }
        if ((content2 = descriptor2.getAttachedContent()) == null) {
            return;
        }
        ContentManager oldContentManager = content2.getManager();
        ContentManager newContentManager = this.getContentManagerForRunner(executor, descriptor2);
        if (oldContentManager == null || oldContentManager == newContentManager) {
            return;
        }
        ContentManagerListener listener2 = (ContentManagerListener)content2.getUserData(CLOSE_LISTENER_KEY);
        if (listener2 != null) {
            oldContentManager.removeContentManagerListener(listener2);
        }
        oldContentManager.removeContent(content2, false);
        if (RunContentManagerImpl.isAlive(descriptor2)) {
            if (!RunContentManagerImpl.isAlive(oldContentManager)) {
                this.updateToolWindowIcon(oldContentManager, false);
            }
            if (!RunContentManagerImpl.isAlive(newContentManager)) {
                this.updateToolWindowIcon(newContentManager, true);
            }
        }
        newContentManager.addContent(content2);
        if (listener2 != null) {
            newContentManager.addContentManagerListener(listener2);
        }
    }

    private void updateToolWindowIcon(@NotNull ContentManager contentManager, boolean alive) {
        if (contentManager == null) {
            RunContentManagerImpl.$$$reportNull$$$0(34);
        }
        for (Map.Entry<String, ContentManager> entry : this.myToolwindowIdToContentManagerMap.entrySet()) {
            if (!entry.getValue().equals(contentManager)) continue;
            String toolWindowId = entry.getKey();
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(toolWindowId);
            if (toolWindow != null) {
                Icon base = this.myToolwindowIdToBaseIconMap.get(toolWindowId);
                toolWindow.setIcon(alive ? ExecutionUtil.getLiveIndicator((Icon)base) : base);
            }
            return;
        }
    }

    private static boolean isAlive(@NotNull ContentManager contentManager) {
        if (contentManager == null) {
            RunContentManagerImpl.$$$reportNull$$$0(35);
        }
        for (Content content2 : contentManager.getContents()) {
            RunContentDescriptor descriptor2 = RunContentManagerImpl.getRunContentDescriptorByContent(content2);
            if (descriptor2 == null || !RunContentManagerImpl.isAlive(descriptor2)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAlive(@NotNull RunContentDescriptor descriptor2) {
        ProcessHandler handler2;
        if (descriptor2 == null) {
            RunContentManagerImpl.$$$reportNull$$$0(36);
        }
        return (handler2 = descriptor2.getProcessHandler()) != null && !handler2.isProcessTerminated();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 20: 
            case 27: 
            case 28: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 20: 
            case 27: 
            case 28: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dockManager";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowManager";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 18: 
            case 24: 
            case 26: 
            case 29: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 15: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionEnvironment";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 19: 
            case 25: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentManager";
                break;
            }
            case 20: 
            case 27: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ui/RunContentManagerImpl";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ui/RunContentManagerImpl";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentManagerForRunner";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDescriptors";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindowIdByEnvironment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerToolWindow";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "toFrontRunContent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hideRunContent";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeRunContent";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "showRunContent";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getReuseContent";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "copyContentAndBehavior";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "chooseReuseContentForDescriptor";
                break;
            }
            case 20: 
            case 27: 
            case 28: 
            case 31: {
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isTerminated";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getRunContentDescriptorByContent";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getExecutorByContent";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getToolWindowByDescriptor";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getRunContentByDescriptor";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "selectRunContent";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getToolWindowIdByEnvironment";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "moveContent";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "updateToolWindowIcon";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isAlive";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 20: 
            case 27: 
            case 28: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CloseListener
    extends BaseContentCloseListener {
        private final Executor myExecutor;

        private CloseListener(@NotNull Content content2, Executor executor) {
            if (content2 == null) {
                CloseListener.$$$reportNull$$$0(0);
            }
            if (executor == null) {
                CloseListener.$$$reportNull$$$0(1);
            }
            super(content2, RunContentManagerImpl.this.myProject);
            this.myExecutor = executor;
        }

        @Override
        protected void disposeContent(@NotNull Content content2) {
            if (content2 == null) {
                CloseListener.$$$reportNull$$$0(2);
            }
            try {
                RunContentDescriptor descriptor2 = RunContentManagerImpl.getRunContentDescriptorByContent(content2);
                RunContentManagerImpl.this.getSyncPublisher().contentRemoved(descriptor2, this.myExecutor);
                if (descriptor2 != null) {
                    Disposer.dispose((Disposable)descriptor2);
                }
            }
            finally {
                content2.release();
            }
        }

        @Override
        protected boolean closeQuery(@NotNull Content content2, final boolean modal) {
            RunContentDescriptor descriptor2;
            if (content2 == null) {
                CloseListener.$$$reportNull$$$0(3);
            }
            if ((descriptor2 = RunContentManagerImpl.getRunContentDescriptorByContent(content2)) == null) {
                return true;
            }
            final ProcessHandler processHandler2 = descriptor2.getProcessHandler();
            if (processHandler2 == null || processHandler2.isProcessTerminated() || processHandler2.isProcessTerminating()) {
                return true;
            }
            String sessionName = descriptor2.getDisplayName();
            BaseContentCloseListener.WaitForProcessTask task2 = new BaseContentCloseListener.WaitForProcessTask(processHandler2, sessionName, modal, RunContentManagerImpl.this.myProject){
                final boolean killable;
                {
                    super(processHandler22, processName, modal2, project);
                    boolean bl2 = this.killable = !modal && processHandler2 instanceof KillableProcess && ((KillableProcess)processHandler2).canKillProcess();
                    if (this.killable) {
                        String cancelText = ExecutionBundle.message((String)"terminating.process.progress.kill", (Object[])new Object[0]);
                        this.setCancelText(cancelText);
                        this.setCancelTooltipText(cancelText);
                    }
                }

                @Override
                public void onCancel() {
                    if (this.killable && !processHandler2.isProcessTerminated()) {
                        ((KillableProcess)processHandler2).killProcess();
                    }
                }
            };
            return this.askUserAndWait(processHandler2, sessionName, task2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/ui/RunContentManagerImpl$CloseListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "disposeContent";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "closeQuery";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

