/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.ui.selection.multiple;

import java.util.Collection;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.pdfsam.support.RequireUtils;
import org.pdfsam.ui.selection.multiple.move.MoveType;

final class SelectionChangedEvent {
    private int top = Integer.MAX_VALUE;
    private int bottom = -1;
    private int totalRows = 0;

    private SelectionChangedEvent(Collection<? extends Integer> selected) {
        RequireUtils.requireNotNull(selected, (String)"Input selection cannot be null");
        selected.forEach(i -> {
            this.bottom = Math.max(i, this.bottom);
            this.top = Math.min(i, this.top);
        });
    }

    private SelectionChangedEvent() {
    }

    public boolean isClearSelection() {
        return this.top == Integer.MAX_VALUE && this.bottom == -1;
    }

    public boolean isSingleSelection() {
        return !this.isClearSelection() && this.top == this.bottom;
    }

    public int getSingleSelection() {
        RequireUtils.requireState((boolean)this.isSingleSelection(), (String)"Single selection expected");
        return this.top;
    }

    public boolean canMove(MoveType type) {
        if (this.isClearSelection()) {
            return false;
        }
        switch (type) {
            case BOTTOM: {
                return this.isSingleSelection() && this.bottom < this.totalRows - 1;
            }
            case DOWN: {
                return this.bottom < this.totalRows - 1;
            }
            case TOP: {
                return this.isSingleSelection() && this.top > 0;
            }
        }
        return this.top > 0;
    }

    public int getTotalRows() {
        return this.totalRows;
    }

    public static SelectionChangedEvent clearSelectionEvent() {
        return new SelectionChangedEvent();
    }

    public static SelectionChangedEvent select(Collection<? extends Integer> index) {
        return new SelectionChangedEvent(index);
    }

    public SelectionChangedEvent ofTotalRows(int totalNumberOfRows) {
        RequireUtils.require((totalNumberOfRows >= 0 ? 1 : 0) != 0, (String)"Cannot select rows if no row is available");
        this.totalRows = totalNumberOfRows;
        return this;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }
}

