/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.morfologik.suggestions_ordering;

import biz.k11i.xgboost.Predictor;
import biz.k11i.xgboost.util.FVec;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.languagetool.AnalyzedSentence;
import org.languagetool.Language;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.languagemodel.MockLanguageModel;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.rules.ngrams.GoogleTokenUtil;
import org.languagetool.rules.spelling.morfologik.suggestions_ordering.SuggestionsOrdererConfig;
import org.languagetool.rules.spelling.suggestions.SuggestionsOrderer;

@Deprecated
public class SuggestionsOrdererGSoC
implements SuggestionsOrderer {
    private static final String SPC_NGRAM_BASED_MODEL_FILENAME = "spc_ngram.model";
    private static final String NO_NGRAM_BASED_MODEL_FILENAME = "spc_naive.model";
    private static final String XGBOOST_MODEL_BASE_PATH = "org/languagetool/resource/speller_rule/models/";
    private static final String COMMON_DEFAULT_MODEL_PATH = "org/languagetool/resource/speller_rule/models/spc_naive.model";
    private static final Integer DEFAULT_CONTEXT_LENGTH = 2;
    private boolean mlAvailable = true;
    private NGramUtil nGramUtil = null;
    private Predictor predictor;

    @Override
    public boolean isMlAvailable() {
        return this.mlAvailable && SuggestionsOrdererConfig.isMLSuggestionsOrderingEnabled();
    }

    public SuggestionsOrdererGSoC(Language language, LanguageModel languageModel, String ruleId) {
        try {
            this.nGramUtil = new NGramUtil(language, languageModel);
            String ngramBasedModelFilename = XGBOOST_MODEL_BASE_PATH + ruleId + "/" + SPC_NGRAM_BASED_MODEL_FILENAME;
            String nonNgramModelFilename = XGBOOST_MODEL_BASE_PATH + ruleId + "/" + NO_NGRAM_BASED_MODEL_FILENAME;
            String languageModelFileName = this.nGramUtil.isMockLanguageModel() ? nonNgramModelFilename : ngramBasedModelFilename;
            try (InputStream modelsPath = this.getClass().getClassLoader().getResourceAsStream(languageModelFileName);){
                this.predictor = new Predictor(modelsPath);
            }
            catch (IOException | NullPointerException e) {
                try (InputStream modelsPath2 = this.getClass().getClassLoader().getResourceAsStream(COMMON_DEFAULT_MODEL_PATH);){
                    this.predictor = new Predictor(modelsPath2);
                }
                catch (IOException | NullPointerException e1) {
                    this.mlAvailable = false;
                }
            }
        }
        catch (RuntimeException e) {
            if (e.getMessage().equalsIgnoreCase("NGram file not found")) {
                this.mlAvailable = false;
            }
            throw new RuntimeException(e);
        }
    }

    private float processRow(String sentence, String correctedSentence, String covered, String replacement, Integer contextLength) {
        int errorStartIdx;
        Pair context = Pair.of((Object)"", (Object)"");
        int sentencesDifferenceCharIdx = ContextUtils.firstDifferencePosition(sentence, correctedSentence);
        if (sentencesDifferenceCharIdx != -1 && (errorStartIdx = ContextUtils.startOfErrorString(sentence, covered, sentencesDifferenceCharIdx)) != -1) {
            context = ContextUtils.extractContext(sentence, covered, errorStartIdx, contextLength);
        }
        String leftContextCovered = (String)context.getKey();
        String rightContextCovered = (String)context.getValue();
        String leftContextCorrection = leftContextCovered.isEmpty() ? "" : leftContextCovered.substring(0, leftContextCovered.length() - covered.length()) + replacement;
        String rightContextCorrection = rightContextCovered.isEmpty() ? "" : replacement + rightContextCovered.substring(covered.length());
        boolean firstLetterMatches = ContextUtils.longestCommonPrefix(new String[]{replacement, covered}).length() != 0;
        Integer editDistance = ContextUtils.editDistance(covered, replacement);
        List leftContextCoveredTokenized = this.nGramUtil.tokenizeString(leftContextCovered.isEmpty() ? covered : leftContextCovered);
        double leftContextCoveredProba = this.nGramUtil.stringProbability(leftContextCoveredTokenized, 3);
        List rightContextCoveredTokenized = this.nGramUtil.tokenizeString(rightContextCovered.isEmpty() ? covered : rightContextCovered);
        double rightContextCoveredProba = this.nGramUtil.stringProbability(rightContextCoveredTokenized, 3);
        List leftContextCorrectionTokenized = this.nGramUtil.tokenizeString(leftContextCorrection.isEmpty() ? replacement : leftContextCorrection);
        double leftContextCorrectionProba = this.nGramUtil.stringProbability(leftContextCorrectionTokenized, 3);
        List rightContextCorrectionTokenized = this.nGramUtil.tokenizeString(rightContextCorrection.isEmpty() ? replacement : rightContextCorrection);
        double rightContextCorrectionProba = this.nGramUtil.stringProbability(rightContextCorrectionTokenized, 3);
        float left_context_covered_length = leftContextCoveredTokenized.size();
        float left_context_covered_proba = (float)leftContextCoveredProba;
        float right_context_covered_length = rightContextCoveredTokenized.size();
        float right_context_covered_proba = (float)rightContextCoveredProba;
        float left_context_correction_length = leftContextCorrectionTokenized.size();
        float left_context_correction_proba = (float)leftContextCorrectionProba;
        float right_context_correction_length = rightContextCorrectionTokenized.size();
        float right_context_correction_proba = (float)rightContextCorrectionProba;
        float first_letter_matches = firstLetterMatches ? 1.0f : 0.0f;
        float edit_distance = editDistance.intValue();
        float[] data = new float[]{left_context_covered_length, left_context_covered_proba, right_context_covered_length, right_context_covered_proba, left_context_correction_length, left_context_correction_proba, right_context_correction_length, right_context_correction_proba, first_letter_matches, edit_distance};
        FVec featuresVector = FVec.Transformer.fromArray((float[])data, (boolean)false);
        double[] predictions = this.predictor.predict(featuresVector);
        double predictedScore = predictions.length == 0 ? 0.0 : predictions[0];
        return (float)predictedScore;
    }

    @Override
    public List<SuggestedReplacement> orderSuggestions(List<String> suggestions, String word, AnalyzedSentence sentence, int startPos) {
        if (!this.isMlAvailable()) {
            return suggestions.stream().map(SuggestedReplacement::new).collect(Collectors.toList());
        }
        LinkedList<Pair> suggestionsScores = new LinkedList<Pair>();
        for (String suggestion : suggestions) {
            String text = sentence.getText();
            String correctedSentence = text.substring(0, startPos) + suggestion + sentence.getText().substring(startPos + word.length());
            float score = this.processRow(text, correctedSentence, word, suggestion, DEFAULT_CONTEXT_LENGTH);
            suggestionsScores.add(Pair.of((Object)suggestion, (Object)Float.valueOf(score)));
        }
        Comparator<Pair> comparing = Comparator.comparing(Pair::getValue);
        suggestionsScores.sort(comparing.reversed());
        return suggestionsScores.stream().map(p -> {
            SuggestedReplacement s = new SuggestedReplacement((String)p.getKey());
            s.setConfidence((Float)p.getRight());
            return s;
        }).collect(Collectors.toList());
    }

    private static class ContextUtils {
        private ContextUtils() {
        }

        private static String leftContext(String originalSentence, int errorStartIdx, String errorString, int contextLength) {
            String regex = ContextUtils.repeat(contextLength, "\\w+\\W+") + Pattern.quote(errorString) + "$";
            String stringToSearch = originalSentence.substring(0, errorStartIdx + errorString.length());
            return ContextUtils.findFirstRegexMatch(regex, stringToSearch);
        }

        private static String rightContext(String originalSentence, int errorStartIdx, String errorString, int contextLength) {
            String regex = "^" + Pattern.quote(errorString) + ContextUtils.repeat(contextLength, "\\W+\\w+");
            String stringToSearch = originalSentence.substring(errorStartIdx);
            return ContextUtils.findFirstRegexMatch(regex, stringToSearch);
        }

        private static int firstDifferencePosition(String sentence1, String sentence2) {
            int result = -1;
            for (int i = 0; i < sentence1.length(); ++i) {
                if (i < sentence2.length() && sentence1.charAt(i) == sentence2.charAt(i)) continue;
                result = i;
                break;
            }
            return result;
        }

        private static int startOfErrorString(String sentence, String errorString, int sentencesDifferenceCharIdx) {
            int result = -1;
            List<Integer> possibleIntersections = ContextUtils.allIndexesOf(sentence.charAt(sentencesDifferenceCharIdx), errorString);
            for (int i : possibleIntersections) {
                String possibleErrorString;
                if (sentencesDifferenceCharIdx - i < 0 || sentencesDifferenceCharIdx - i + errorString.length() > sentence.length() || !(possibleErrorString = sentence.substring(sentencesDifferenceCharIdx - i, sentencesDifferenceCharIdx - i + errorString.length())).equals(errorString)) continue;
                result = sentencesDifferenceCharIdx - i;
                break;
            }
            return result;
        }

        private static String getMaximalPossibleRightContext(String sentence, int errorStartIdx, String errorString, int startingContextLength) {
            String rightContext = "";
            for (int contextLength = startingContextLength; contextLength > 0 && (rightContext = ContextUtils.rightContext(sentence, errorStartIdx, errorString, contextLength)).isEmpty(); --contextLength) {
            }
            return rightContext;
        }

        private static String getMaximalPossibleLeftContext(String sentence, int errorStartIdx, String errorString, int startingContextLength) {
            String leftContext = "";
            for (int contextLength = startingContextLength; contextLength > 0 && (leftContext = ContextUtils.leftContext(sentence, errorStartIdx, errorString, contextLength)).isEmpty(); --contextLength) {
            }
            return leftContext;
        }

        private static Pair<String, String> extractContext(String sentence, String covered, int errorStartIdx, int contextLength) {
            int errorEndIdx = errorStartIdx + covered.length();
            String errorString = sentence.substring(errorStartIdx, errorEndIdx);
            String leftContext = ContextUtils.getMaximalPossibleLeftContext(sentence, errorStartIdx, errorString, contextLength);
            String rightContext = ContextUtils.getMaximalPossibleRightContext(sentence, errorStartIdx, errorString, contextLength);
            return Pair.of((Object)leftContext, (Object)rightContext);
        }

        private static String longestCommonPrefix(String[] strs) {
            if (strs == null || strs.length == 0) {
                return "";
            }
            if (strs.length == 1) {
                return strs[0];
            }
            int minLen = strs.length + 1;
            for (String str : strs) {
                if (minLen <= str.length()) continue;
                minLen = str.length();
            }
            for (int i = 0; i < minLen; ++i) {
                for (int j = 0; j < strs.length - 1; ++j) {
                    String s1 = strs[j];
                    String s2 = strs[j + 1];
                    if (s1.charAt(i) == s2.charAt(i)) continue;
                    return s1.substring(0, i);
                }
            }
            return strs[0].substring(0, minLen);
        }

        private static int editDistance(String x, String y) {
            int[][] dp = new int[x.length() + 1][y.length() + 1];
            for (int i = 0; i <= x.length(); ++i) {
                for (int j = 0; j <= y.length(); ++j) {
                    dp[i][j] = i == 0 ? j : (j == 0 ? i : ContextUtils.min(dp[i - 1][j - 1] + ContextUtils.costOfSubstitution(x.charAt(i - 1), y.charAt(j - 1)), dp[i - 1][j] + 1, dp[i][j - 1] + 1));
                }
            }
            return dp[x.length()][y.length()];
        }

        private static int costOfSubstitution(char a, char b) {
            return a == b ? 0 : 1;
        }

        private static int min(int ... numbers) {
            return Arrays.stream(numbers).min().orElse(Integer.MAX_VALUE);
        }

        private static String findFirstRegexMatch(String regex, String stringToSearch) {
            String result = "";
            Pattern pattern = Pattern.compile(regex);
            Matcher stringToSearchMatcher = pattern.matcher(stringToSearch);
            if (stringToSearchMatcher.find()) {
                result = stringToSearch.substring(stringToSearchMatcher.start(), stringToSearchMatcher.end());
            }
            return result;
        }

        private static String repeat(int count, String with) {
            return new String(new char[count]).replace("\u0000", with);
        }

        private static List<Integer> allIndexesOf(char character, String string) {
            ArrayList<Integer> indexes = new ArrayList<Integer>();
            int index = string.indexOf(character);
            while (index >= 0) {
                indexes.add(index);
                index = string.indexOf(character, index + 1);
            }
            return indexes;
        }
    }

    private static class NGramUtil {
        private final Language language;
        private LanguageModel languageModel;
        private boolean mockLanguageModel = false;

        private NGramUtil(Language language, LanguageModel languageModel) {
            this.language = language;
            if (languageModel != null) {
                this.languageModel = languageModel;
            } else {
                this.languageModel = new MockLanguageModel();
                this.mockLanguageModel = true;
            }
        }

        private NGramUtil(Language language) {
            this.language = language;
            try {
                String ngramPath = SuggestionsOrdererConfig.getNgramsPath();
                this.languageModel = ngramPath != null ? language.getLanguageModel(Paths.get(ngramPath, new String[0]).toFile()) : null;
                if (this.languageModel == null) {
                    this.mockLanguageModel = true;
                    this.languageModel = new MockLanguageModel();
                }
            }
            catch (IOException | RuntimeException e) {
                this.languageModel = new MockLanguageModel();
            }
        }

        private List<String> tokenizeString(String s) {
            return GoogleTokenUtil.getGoogleTokensForString(s, false, this.language);
        }

        private Double stringProbability(List<String> sTokenized, int length) {
            if (sTokenized.size() > length) {
                sTokenized = sTokenized.subList(sTokenized.size() - length, sTokenized.size());
            }
            return sTokenized.isEmpty() ? null : Double.valueOf(this.languageModel.getPseudoProbability(sTokenized).getProb());
        }

        private boolean isMockLanguageModel() {
            return this.mockLanguageModel;
        }
    }
}

