/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.send.gssapi;

import com.sun.jna.platform.win32.Sspi;
import java.io.IOException;
import java.sql.SQLException;
import org.mariadb.jdbc.internal.com.read.Buffer;
import org.mariadb.jdbc.internal.com.send.gssapi.GssapiAuth;
import org.mariadb.jdbc.internal.io.input.PacketInputStream;
import org.mariadb.jdbc.internal.io.output.PacketOutputStream;
import waffle.windows.auth.IWindowsSecurityContext;
import waffle.windows.auth.impl.WindowsSecurityContextImpl;

public class WindowsNativeSspiAuthentication
extends GssapiAuth {
    public WindowsNativeSspiAuthentication(PacketInputStream reader, int packSeq) {
        super(reader, packSeq);
    }

    @Override
    public void authenticate(PacketOutputStream writer, String serverPrincipalName, String mechanisms) throws SQLException, IOException {
        IWindowsSecurityContext clientContext = WindowsSecurityContextImpl.getCurrent((String)mechanisms, (String)serverPrincipalName);
        do {
            byte[] tokenForTheServerOnTheClient = clientContext.getToken();
            writer.startPacket(this.packSeq);
            writer.write(tokenForTheServerOnTheClient);
            writer.flush();
            if (!clientContext.isContinue()) continue;
            Buffer buffer = this.reader.getPacket(true);
            this.packSeq = this.reader.getLastPacketSeq() + 1;
            byte[] tokenForTheClientOnTheServer = buffer.readRawBytes(buffer.remaining());
            Sspi.SecBufferDesc continueToken = new Sspi.SecBufferDesc(2, tokenForTheClientOnTheServer);
            clientContext.initialize(clientContext.getHandle(), continueToken, serverPrincipalName);
        } while (clientContext.isContinue());
        clientContext.dispose();
    }
}

