"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createTruncateFormat = createTruncateFormat;

var _lodash = require("lodash");

var _common = require("../../../../../../plugins/data/common/");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const omission = '...';

function createTruncateFormat() {
  class TruncateFormat extends _common.FieldFormat {
    constructor(...args) {
      super(...args);

      _defineProperty(this, "textConvert", val => {
        const length = this.param('fieldLength');

        if (length > 0) {
          return (0, _lodash.trunc)(val, {
            length: length + omission.length,
            omission
          });
        }

        return val;
      });
    }

  }

  _defineProperty(TruncateFormat, "id", 'truncate');

  _defineProperty(TruncateFormat, "title", 'Truncated String');

  _defineProperty(TruncateFormat, "fieldType", _common.KBN_FIELD_TYPES.STRING);

  return TruncateFormat;
}