"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createStringFormat = createStringFormat;

var _i18n = require("@kbn/i18n");

var _field_formats = require("../../../../../../plugins/data/common/field_formats");

var _common = require("../../../../../../plugins/data/common/");

var _shorten_dotted_string = require("../../utils/shorten_dotted_string");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const TRANSFORM_OPTIONS = [{
  kind: false,
  text: _i18n.i18n.translate('kbn.common.fieldFormats.string.transformOptions.none', {
    defaultMessage: '- None -'
  })
}, {
  kind: 'lower',
  text: _i18n.i18n.translate('kbn.common.fieldFormats.string.transformOptions.lower', {
    defaultMessage: 'Lower Case'
  })
}, {
  kind: 'upper',
  text: _i18n.i18n.translate('kbn.common.fieldFormats.string.transformOptions.upper', {
    defaultMessage: 'Upper Case'
  })
}, {
  kind: 'title',
  text: _i18n.i18n.translate('kbn.common.fieldFormats.string.transformOptions.title', {
    defaultMessage: 'Title Case'
  })
}, {
  kind: 'short',
  text: _i18n.i18n.translate('kbn.common.fieldFormats.string.transformOptions.short', {
    defaultMessage: 'Short Dots'
  })
}, {
  kind: 'base64',
  text: _i18n.i18n.translate('kbn.common.fieldFormats.string.transformOptions.base64', {
    defaultMessage: 'Base64 Decode'
  })
}, {
  kind: 'urlparam',
  text: _i18n.i18n.translate('kbn.common.fieldFormats.string.transformOptions.url', {
    defaultMessage: 'URL Param Decode'
  })
}];
const DEFAULT_TRANSFORM_OPTION = false;

function createStringFormat() {
  class StringFormat extends _common.FieldFormat {
    constructor(...args) {
      super(...args);

      _defineProperty(this, "textConvert", val => {
        switch (this.param('transform')) {
          case 'lower':
            return String(val).toLowerCase();

          case 'upper':
            return String(val).toUpperCase();

          case 'title':
            return this.toTitleCase(val);

          case 'short':
            return (0, _shorten_dotted_string.shortenDottedString)(val);

          case 'base64':
            return this.base64Decode(val);

          case 'urlparam':
            return decodeURIComponent(val);

          default:
            return (0, _field_formats.asPrettyString)(val);
        }
      });
    }

    getParamDefaults() {
      return {
        transform: DEFAULT_TRANSFORM_OPTION
      };
    }

    base64Decode(val) {
      try {
        return Buffer.from(val, 'base64').toString('utf8');
      } catch (e) {
        return (0, _field_formats.asPrettyString)(val);
      }
    }

    toTitleCase(val) {
      return val.replace(/\w\S*/g, txt => {
        return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase();
      });
    }

  }

  _defineProperty(StringFormat, "id", 'string');

  _defineProperty(StringFormat, "title", 'String');

  _defineProperty(StringFormat, "fieldType", [_common.KBN_FIELD_TYPES.NUMBER, _common.KBN_FIELD_TYPES.BOOLEAN, _common.KBN_FIELD_TYPES.DATE, _common.KBN_FIELD_TYPES.IP, _common.KBN_FIELD_TYPES.ATTACHMENT, _common.KBN_FIELD_TYPES.GEO_POINT, _common.KBN_FIELD_TYPES.GEO_SHAPE, _common.KBN_FIELD_TYPES.STRING, _common.KBN_FIELD_TYPES.MURMUR3, _common.KBN_FIELD_TYPES.UNKNOWN, _common.KBN_FIELD_TYPES.CONFLICT]);

  _defineProperty(StringFormat, "transformOptions", TRANSFORM_OPTIONS);

  return StringFormat;
}