"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createRelativeDateFormat = createRelativeDateFormat;

var _moment = _interopRequireDefault(require("moment"));

var _common = require("../../../../../../plugins/data/common/");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function createRelativeDateFormat() {
  class RelativeDateFormat extends _common.FieldFormat {
    constructor(params) {
      super(params);

      _defineProperty(this, "textConvert", val => {
        if (val === null || val === undefined) {
          return '-';
        }

        const date = (0, _moment.default)(val);

        if (date.isValid()) {
          return date.fromNow();
        } else {
          return val;
        }
      });
    }

  }

  _defineProperty(RelativeDateFormat, "id", 'relative_date');

  _defineProperty(RelativeDateFormat, "title", 'Relative Date');

  _defineProperty(RelativeDateFormat, "fieldType", _common.KBN_FIELD_TYPES.DATE);

  return RelativeDateFormat;
}