"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.kibanaContext = void 0;

var _chrome = _interopRequireDefault(require("ui/chrome"));

var _i18n = require("@kbn/i18n");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

var kibanaContext = function kibanaContext() {
  return {
    name: 'kibana_context',
    type: 'kibana_context',
    context: {
      types: ['kibana_context', 'null']
    },
    help: _i18n.i18n.translate('interpreter.functions.kibana_context.help', {
      defaultMessage: 'Updates kibana global context'
    }),
    args: {
      q: {
        types: ['string', 'null'],
        aliases: ['query', '_'],
        default: null,
        help: _i18n.i18n.translate('interpreter.functions.kibana_context.q.help', {
          defaultMessage: 'Specify Kibana free form text query'
        })
      },
      filters: {
        types: ['string', 'null'],
        default: '"[]"',
        help: _i18n.i18n.translate('interpreter.functions.kibana_context.filters.help', {
          defaultMessage: 'Specify Kibana generic filters'
        })
      },
      timeRange: {
        types: ['string', 'null'],
        default: null,
        help: _i18n.i18n.translate('interpreter.functions.kibana_context.timeRange.help', {
          defaultMessage: 'Specify Kibana time range filter'
        })
      },
      savedSearchId: {
        types: ['string', 'null'],
        default: null,
        help: _i18n.i18n.translate('interpreter.functions.kibana_context.savedSearchId.help', {
          defaultMessage: 'Specify saved search ID to be used for queries and filters'
        })
      }
    },
    fn: function () {
      var _fn = _asyncToGenerator(
      /*#__PURE__*/
      regeneratorRuntime.mark(function _callee(context, args, handlers) {
        var $injector, savedSearches, queryArg, queries, filters, savedSearch, searchQuery, searchFilters, timeRange;
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _context.next = 2;
                return _chrome.default.dangerouslyGetActiveInjector();

              case 2:
                $injector = _context.sent;
                savedSearches = $injector.get('savedSearches');
                queryArg = args.q ? JSON.parse(args.q) : [];
                queries = Array.isArray(queryArg) ? queryArg : [queryArg];
                filters = args.filters ? JSON.parse(args.filters) : [];

                if (!args.savedSearchId) {
                  _context.next = 15;
                  break;
                }

                _context.next = 10;
                return savedSearches.get(args.savedSearchId);

              case 10:
                savedSearch = _context.sent;
                searchQuery = savedSearch.searchSource.getField('query');
                searchFilters = savedSearch.searchSource.getField('filter');
                queries = queries.concat(searchQuery);
                filters = filters.concat(searchFilters);

              case 15:
                if (context && context.query) {
                  queries = queries.concat(context.query);
                }

                if (context && context.filters) {
                  filters = filters.concat(context.filters).filter(function (f) {
                    return !f.meta.disabled;
                  });
                }

                timeRange = args.timeRange ? JSON.parse(args.timeRange) : context ? context.timeRange : undefined;
                return _context.abrupt("return", {
                  type: 'kibana_context',
                  query: queries,
                  filters: filters,
                  timeRange: timeRange
                });

              case 19:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));

      function fn(_x, _x2, _x3) {
        return _fn.apply(this, arguments);
      }

      return fn;
    }()
  };
};

exports.kibanaContext = kibanaContext;