"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setRenderersRegistry = exports.getRenderersRegistry = exports.setInterpreter = exports.getInterpreter = exports.setInspector = exports.getInspector = void 0;

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var createGetterSetter = function createGetterSetter(name) {
  var value;

  var get = function get() {
    if (!value) throw new Error("".concat(name, " was not set"));
    return value;
  };

  var set = function set(newValue) {
    value = newValue;
  };

  return [get, set];
};

var _createGetterSetter = createGetterSetter('Inspector'),
    _createGetterSetter2 = _slicedToArray(_createGetterSetter, 2),
    getInspector = _createGetterSetter2[0],
    setInspector = _createGetterSetter2[1];

exports.setInspector = setInspector;
exports.getInspector = getInspector;

var _createGetterSetter3 = createGetterSetter('Interpreter'),
    _createGetterSetter4 = _slicedToArray(_createGetterSetter3, 2),
    getInterpreter = _createGetterSetter4[0],
    setInterpreter = _createGetterSetter4[1];

exports.setInterpreter = setInterpreter;
exports.getInterpreter = getInterpreter;

var _createGetterSetter5 = createGetterSetter('Renderers registry'),
    _createGetterSetter6 = _slicedToArray(_createGetterSetter5, 2),
    getRenderersRegistry = _createGetterSetter6[0],
    setRenderersRegistry = _createGetterSetter6[1];

exports.setRenderersRegistry = setRenderersRegistry;
exports.getRenderersRegistry = getRenderersRegistry;