"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findIndexPatternByTitle = findIndexPatternByTitle;
exports.getIndexPatternTitle = getIndexPatternTitle;
exports.validateIndexPattern = validateIndexPattern;
exports.isFilterable = isFilterable;
exports.getFromSavedObject = getFromSavedObject;
exports.getRoutes = getRoutes;
exports.mockIndexPattern = exports.mockFields = exports.INDEX_PATTERN_ILLEGAL_CHARACTERS = exports.INDEX_PATTERN_ILLEGAL_CHARACTERS_VISIBLE = exports.CONTAINS_SPACES = exports.ILLEGAL_CHARACTERS = void 0;

var _lodash = require("lodash");

var _public = require("../../../../../plugins/data/public");

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

var ILLEGAL_CHARACTERS = 'ILLEGAL_CHARACTERS';
exports.ILLEGAL_CHARACTERS = ILLEGAL_CHARACTERS;
var CONTAINS_SPACES = 'CONTAINS_SPACES';
exports.CONTAINS_SPACES = CONTAINS_SPACES;
var INDEX_PATTERN_ILLEGAL_CHARACTERS_VISIBLE = ['\\', '/', '?', '"', '<', '>', '|'];
exports.INDEX_PATTERN_ILLEGAL_CHARACTERS_VISIBLE = INDEX_PATTERN_ILLEGAL_CHARACTERS_VISIBLE;
var INDEX_PATTERN_ILLEGAL_CHARACTERS = INDEX_PATTERN_ILLEGAL_CHARACTERS_VISIBLE.concat(' ');
exports.INDEX_PATTERN_ILLEGAL_CHARACTERS = INDEX_PATTERN_ILLEGAL_CHARACTERS;

function findIllegalCharacters(indexPattern) {
  var illegalCharacters = INDEX_PATTERN_ILLEGAL_CHARACTERS_VISIBLE.reduce(function (chars, char) {
    if (indexPattern.includes(char)) {
      chars.push(char);
    }

    return chars;
  }, []);
  return illegalCharacters;
}
/**
 * Returns an object matching a given title
 *
 * @param client {SavedObjectsClientContract}
 * @param title {string}
 * @returns {Promise<SimpleSavedObject|undefined>}
 */


function findIndexPatternByTitle(_x, _x2) {
  return _findIndexPatternByTitle.apply(this, arguments);
}

function _findIndexPatternByTitle() {
  _findIndexPatternByTitle = _asyncToGenerator(
  /*#__PURE__*/
  regeneratorRuntime.mark(function _callee(client, title) {
    var _ref, savedObjects;

    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            if (title) {
              _context.next = 2;
              break;
            }

            return _context.abrupt("return", Promise.resolve());

          case 2:
            _context.next = 4;
            return client.find({
              type: 'index-pattern',
              perPage: 10,
              search: "\"".concat(title, "\""),
              searchFields: ['title'],
              fields: ['title']
            });

          case 4:
            _ref = _context.sent;
            savedObjects = _ref.savedObjects;
            return _context.abrupt("return", (0, _lodash.find)(savedObjects, function (obj) {
              return obj.get('title').toLowerCase() === title.toLowerCase();
            }));

          case 7:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _findIndexPatternByTitle.apply(this, arguments);
}

function getIndexPatternTitle(_x3, _x4) {
  return _getIndexPatternTitle.apply(this, arguments);
}

function _getIndexPatternTitle() {
  _getIndexPatternTitle = _asyncToGenerator(
  /*#__PURE__*/
  regeneratorRuntime.mark(function _callee2(client, indexPatternId) {
    var savedObject;
    return regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) {
        switch (_context2.prev = _context2.next) {
          case 0:
            _context2.next = 2;
            return client.get('index-pattern', indexPatternId);

          case 2:
            savedObject = _context2.sent;

            if (!savedObject.error) {
              _context2.next = 5;
              break;
            }

            throw new Error("Unable to get index-pattern title: ".concat(savedObject.error.message));

          case 5:
            return _context2.abrupt("return", savedObject.attributes.title);

          case 6:
          case "end":
            return _context2.stop();
        }
      }
    }, _callee2);
  }));
  return _getIndexPatternTitle.apply(this, arguments);
}

function indexPatternContainsSpaces(indexPattern) {
  return indexPattern.includes(' ');
}

function validateIndexPattern(indexPattern) {
  var errors = {};
  var illegalCharacters = findIllegalCharacters(indexPattern);

  if (illegalCharacters.length) {
    errors[ILLEGAL_CHARACTERS] = illegalCharacters;
  }

  if (indexPatternContainsSpaces(indexPattern)) {
    errors[CONTAINS_SPACES] = true;
  }

  return errors;
}

var filterableTypes = (0, _public.getFilterableKbnTypeNames)();

function isFilterable(field) {
  return field.name === '_id' || field.scripted || Boolean(field.searchable && filterableTypes.includes(field.type));
}

function getFromSavedObject(savedObject) {
  if ((0, _lodash.get)(savedObject, 'attributes.fields') === undefined) {
    return;
  }

  return {
    id: savedObject.id,
    fields: JSON.parse(savedObject.attributes.fields),
    title: savedObject.attributes.title
  };
}

function getRoutes() {
  return {
    edit: '/management/kibana/index_patterns/{{id}}',
    addField: '/management/kibana/index_patterns/{{id}}/create-field',
    indexedFields: '/management/kibana/index_patterns/{{id}}?_a=(tab:indexedFields)',
    scriptedFields: '/management/kibana/index_patterns/{{id}}?_a=(tab:scriptedFields)',
    sourceFilters: '/management/kibana/index_patterns/{{id}}?_a=(tab:sourceFilters)'
  };
}

var mockFields = [{
  name: 'machine.os',
  esTypes: ['text'],
  type: 'string',
  aggregatable: false,
  searchable: false,
  filterable: true
}, {
  name: 'machine.os.raw',
  type: 'string',
  esTypes: ['keyword'],
  aggregatable: true,
  searchable: true,
  filterable: true
}, {
  name: 'not.filterable',
  type: 'string',
  esTypes: ['text'],
  aggregatable: true,
  searchable: false,
  filterable: false
}, {
  name: 'bytes',
  type: 'number',
  esTypes: ['long'],
  aggregatable: true,
  searchable: true,
  filterable: true
}, {
  name: '@timestamp',
  type: 'date',
  esTypes: ['date'],
  aggregatable: true,
  searchable: true,
  filterable: true
}, {
  name: 'clientip',
  type: 'ip',
  esTypes: ['ip'],
  aggregatable: true,
  searchable: true,
  filterable: true
}, {
  name: 'bool.field',
  type: 'boolean',
  esTypes: ['boolean'],
  aggregatable: true,
  searchable: true,
  filterable: true
}];
exports.mockFields = mockFields;
var mockIndexPattern = {
  id: 'logstash-*',
  fields: mockFields,
  title: 'logstash-*',
  timeFieldName: '@timestamp'
};
exports.mockIndexPattern = mockIndexPattern;