"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Poller = void 0;

var _rxjs = require("rxjs");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/**
 * Create an Observable BehaviorSubject to invoke a function on an interval
 * which returns the next value for the observable.
 * @public
 */
class Poller {
  /**
   * The observable to observe for changes to the poller value.
   */
  constructor(frequency, initialValue, handler) {
    this.frequency = frequency;
    this.initialValue = initialValue;
    this.handler = handler;

    _defineProperty(this, "subject$", new _rxjs.BehaviorSubject(this.initialValue));

    _defineProperty(this, "poller$", (0, _rxjs.timer)(0, this.frequency));

    _defineProperty(this, "subscription", this.poller$.subscribe(async iteration => {
      const next = await this.handler(iteration);

      if (next !== undefined) {
        this.subject$.next(next);
      }

      return iteration;
    }));
  }
  /**
   * Permanently end the polling operation.
   */


  unsubscribe() {
    return this.subscription.unsubscribe();
  }

}

exports.Poller = Poller;