/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.postoffice.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.api.core.ActiveMQAddressFullException;
import org.apache.activemq.artemis.api.core.ActiveMQDuplicateIdException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQNonExistentQueueException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.RefCountMessageListener;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.api.core.management.NotificationType;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.AddressManager;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.BindingType;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.BindingsFactory;
import org.apache.activemq.artemis.core.postoffice.DuplicateIDCache;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.postoffice.QueueInfo;
import org.apache.activemq.artemis.core.postoffice.RoutingStatus;
import org.apache.activemq.artemis.core.postoffice.impl.BindingsImpl;
import org.apache.activemq.artemis.core.postoffice.impl.DuplicateIDCacheImpl;
import org.apache.activemq.artemis.core.postoffice.impl.SimpleAddressManager;
import org.apache.activemq.artemis.core.postoffice.impl.WildcardAddressManager;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQScheduledComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueFactory;
import org.apache.activemq.artemis.core.server.RouteContextList;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.group.GroupingHandler;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.QueueManagerImpl;
import org.apache.activemq.artemis.core.server.impl.RoutingContextImpl;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.server.management.NotificationListener;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperation;
import org.apache.activemq.artemis.core.transaction.TransactionOperationAbstract;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.jboss.logging.Logger;

public class PostOfficeImpl
implements PostOffice,
NotificationListener,
BindingsFactory {
    private static final Logger logger = Logger.getLogger(PostOfficeImpl.class);
    public static final SimpleString HDR_RESET_QUEUE_DATA = new SimpleString("_AMQ_RESET_QUEUE_DATA");
    public static final SimpleString HDR_RESET_QUEUE_DATA_COMPLETE = new SimpleString("_AMQ_RESET_QUEUE_DATA_COMPLETE");
    public static final SimpleString BRIDGE_CACHE_STR = new SimpleString("BRIDGE.");
    private final AddressManager addressManager;
    private final QueueFactory queueFactory;
    private final StorageManager storageManager;
    private final PagingManager pagingManager;
    private volatile boolean started;
    private final ManagementService managementService;
    private ExpiryReaper expiryReaperRunnable;
    private final long expiryReaperPeriod;
    private AddressQueueReaper addressQueueReaperRunnable;
    private final long addressQueueReaperPeriod;
    private final ConcurrentMap<SimpleString, DuplicateIDCache> duplicateIDCaches = new ConcurrentHashMap<SimpleString, DuplicateIDCache>();
    private final int idCacheSize;
    private final boolean persistIDCache;
    private final Map<SimpleString, QueueInfo> queueInfos = new HashMap<SimpleString, QueueInfo>();
    private final Object notificationLock = new Object();
    private final HierarchicalRepository<AddressSettings> addressSettingsRepository;
    private final ActiveMQServer server;

    public PostOfficeImpl(ActiveMQServer server, StorageManager storageManager, PagingManager pagingManager, QueueFactory bindableFactory, ManagementService managementService, long expiryReaperPeriod, long addressQueueReaperPeriod, WildcardConfiguration wildcardConfiguration, int idCacheSize, boolean persistIDCache, HierarchicalRepository<AddressSettings> addressSettingsRepository) {
        this.storageManager = storageManager;
        this.queueFactory = bindableFactory;
        this.managementService = managementService;
        this.pagingManager = pagingManager;
        this.expiryReaperPeriod = expiryReaperPeriod;
        this.addressQueueReaperPeriod = addressQueueReaperPeriod;
        this.addressManager = wildcardConfiguration.isRoutingEnabled() ? new WildcardAddressManager(this, wildcardConfiguration, storageManager, server.getMetricsManager()) : new SimpleAddressManager(this, wildcardConfiguration, storageManager, server.getMetricsManager());
        this.idCacheSize = idCacheSize;
        this.persistIDCache = persistIDCache;
        this.addressSettingsRepository = addressSettingsRepository;
        this.server = server;
    }

    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        this.managementService.addNotificationListener(this);
        this.queueFactory.setPostOffice(this);
        this.started = true;
    }

    public synchronized void stop() throws Exception {
        this.started = false;
        this.managementService.removeNotificationListener(this);
        if (this.expiryReaperRunnable != null) {
            this.expiryReaperRunnable.stop();
        }
        if (this.addressQueueReaperRunnable != null) {
            this.addressQueueReaperRunnable.stop();
        }
        this.addressManager.clear();
        this.queueInfos.clear();
    }

    public boolean isStarted() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNotification(Notification notification) {
        if (!(notification.getType() instanceof CoreNotificationType)) {
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Receiving notification : " + notification + " on server " + this.server));
        }
        Object object = this.notificationLock;
        synchronized (object) {
            CoreNotificationType type = (CoreNotificationType)notification.getType();
            switch (type) {
                case BINDING_ADDED: {
                    TypedProperties props = notification.getProperties();
                    if (!props.containsProperty(ManagementHelper.HDR_BINDING_TYPE)) {
                        throw ActiveMQMessageBundle.BUNDLE.bindingTypeNotSpecified();
                    }
                    Integer bindingType = props.getIntProperty(ManagementHelper.HDR_BINDING_TYPE);
                    if (bindingType == 2) {
                        return;
                    }
                    SimpleString routingName = props.getSimpleStringProperty(ManagementHelper.HDR_ROUTING_NAME);
                    SimpleString clusterName = props.getSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME);
                    SimpleString address = props.getSimpleStringProperty(ManagementHelper.HDR_ADDRESS);
                    if (!props.containsProperty(ManagementHelper.HDR_BINDING_ID)) {
                        throw ActiveMQMessageBundle.BUNDLE.bindingIdNotSpecified();
                    }
                    long id = props.getLongProperty(ManagementHelper.HDR_BINDING_ID);
                    SimpleString filterString = props.getSimpleStringProperty(ManagementHelper.HDR_FILTERSTRING);
                    if (!props.containsProperty(ManagementHelper.HDR_DISTANCE)) {
                        logger.debug((Object)"PostOffice notification / BINDING_ADDED: HDR_DISANCE not specified, giving up propagation on notifications");
                        return;
                    }
                    int distance = props.getIntProperty(ManagementHelper.HDR_DISTANCE);
                    QueueInfo info = new QueueInfo(routingName, clusterName, address, filterString, id, distance);
                    this.queueInfos.put(clusterName, info);
                    break;
                }
                case BINDING_REMOVED: {
                    TypedProperties props = notification.getProperties();
                    if (!props.containsProperty(ManagementHelper.HDR_CLUSTER_NAME)) {
                        logger.debug((Object)"PostOffice notification / BINDING_REMOVED: HDR_CLUSTER_NAME not specified, giving up propagation on notifications");
                        return;
                    }
                    SimpleString clusterName = props.getSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME);
                    QueueInfo info = this.queueInfos.remove(clusterName);
                    if (info != null) break;
                    logger.debug((Object)"PostOffice notification / BINDING_REMOVED: Cannot find queue info for queue \" + clusterName");
                    return;
                }
                case CONSUMER_CREATED: {
                    TypedProperties props = notification.getProperties();
                    if (!props.containsProperty(ManagementHelper.HDR_CLUSTER_NAME)) {
                        logger.debug((Object)"PostOffice notification / CONSUMER_CREATED: No clusterName defined");
                        return;
                    }
                    SimpleString clusterName = props.getSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME);
                    SimpleString filterString = props.getSimpleStringProperty(ManagementHelper.HDR_FILTERSTRING);
                    QueueInfo info = this.queueInfos.get(clusterName);
                    if (info == null) {
                        logger.debug((Object)("PostOffice notification / CONSUMER_CREATED: Could not find queue created on clusterName = " + clusterName));
                        return;
                    }
                    info.incrementConsumers();
                    if (filterString != null) {
                        List<SimpleString> filterStrings = info.getFilterStrings();
                        if (filterStrings == null) {
                            filterStrings = new ArrayList<SimpleString>();
                            info.setFilterStrings(filterStrings);
                        }
                        filterStrings.add(filterString);
                    }
                    if (!props.containsProperty(ManagementHelper.HDR_DISTANCE)) {
                        logger.debug((Object)"PostOffice notification / CONSUMER_CREATED: No distance specified");
                        return;
                    }
                    int distance = props.getIntProperty(ManagementHelper.HDR_DISTANCE);
                    if (distance <= 0) break;
                    SimpleString queueName = props.getSimpleStringProperty(ManagementHelper.HDR_ROUTING_NAME);
                    if (queueName == null) {
                        logger.debug((Object)"PostOffice notification / CONSUMER_CREATED: No queue defined");
                        return;
                    }
                    Binding binding = this.getBinding(queueName);
                    if (binding == null) break;
                    Queue queue = (Queue)binding.getBindable();
                    AddressSettings addressSettings = this.addressSettingsRepository.getMatch(binding.getAddress().toString());
                    long redistributionDelay = addressSettings.getRedistributionDelay();
                    if (redistributionDelay == -1L) break;
                    queue.addRedistributor(redistributionDelay);
                    break;
                }
                case CONSUMER_CLOSED: {
                    TypedProperties props = notification.getProperties();
                    SimpleString clusterName = props.getSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME);
                    if (clusterName == null) {
                        logger.debug((Object)"PostOffice notification / CONSUMER_CLOSED: No cluster name");
                        return;
                    }
                    SimpleString filterString = props.getSimpleStringProperty(ManagementHelper.HDR_FILTERSTRING);
                    QueueInfo info = this.queueInfos.get(clusterName);
                    if (info == null) {
                        return;
                    }
                    info.decrementConsumers();
                    if (filterString != null) {
                        List<SimpleString> filterStrings = info.getFilterStrings();
                        filterStrings.remove(filterString);
                    }
                    if (info.getNumberOfConsumers() > 0) break;
                    if (!props.containsProperty(ManagementHelper.HDR_DISTANCE)) {
                        logger.debug((Object)"PostOffice notification / CONSUMER_CLOSED: HDR_DISTANCE not defined");
                        return;
                    }
                    int distance = props.getIntProperty(ManagementHelper.HDR_DISTANCE);
                    if (distance != 0) break;
                    SimpleString queueName = props.getSimpleStringProperty(ManagementHelper.HDR_ROUTING_NAME);
                    if (queueName == null) {
                        logger.debug((Object)"PostOffice notification / CONSUMER_CLOSED: No queue name");
                        return;
                    }
                    Binding binding = this.getBinding(queueName);
                    if (binding == null) {
                        logger.debug((Object)("PostOffice notification / CONSUMER_CLOSED: Could not find queue " + queueName));
                        return;
                    }
                    Queue queue = (Queue)binding.getBindable();
                    AddressSettings addressSettings = this.addressSettingsRepository.getMatch(binding.getAddress().toString());
                    long redistributionDelay = addressSettings.getRedistributionDelay();
                    if (redistributionDelay == -1L) break;
                    queue.addRedistributor(redistributionDelay);
                    break;
                }
            }
        }
    }

    @Override
    public void reloadAddressInfo(AddressInfo addressInfo) throws Exception {
        this.internalAddressInfo(addressInfo, true);
    }

    @Override
    public boolean addAddressInfo(AddressInfo addressInfo) throws Exception {
        return this.internalAddressInfo(addressInfo, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean internalAddressInfo(AddressInfo addressInfo, boolean reload) throws Exception {
        PostOfficeImpl postOfficeImpl = this;
        synchronized (postOfficeImpl) {
            boolean result;
            if (this.server.hasBrokerAddressPlugins()) {
                this.server.callBrokerAddressPlugins(plugin -> plugin.beforeAddAddress(addressInfo, reload));
            }
            if (result = reload ? this.addressManager.reloadAddressInfo(addressInfo) : this.addressManager.addAddressInfo(addressInfo)) {
                try {
                    if (!addressInfo.isInternal()) {
                        this.managementService.registerAddress(addressInfo);
                    }
                    if (this.server.hasBrokerAddressPlugins()) {
                        this.server.callBrokerAddressPlugins(plugin -> plugin.afterAddAddress(addressInfo, reload));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return result;
        }
    }

    @Override
    public QueueBinding updateQueue(SimpleString name, RoutingType routingType, Filter filter, Integer maxConsumers, Boolean purgeOnNoConsumers, Boolean exclusive, Boolean groupRebalance, Integer groupBuckets, SimpleString groupFirstKey, Boolean nonDestructive, Integer consumersBeforeDispatch, Long delayBeforeDispatch, SimpleString user, Boolean configurationManaged) throws Exception {
        return this.updateQueue(name, routingType, filter, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, groupFirstKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, user, configurationManaged, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueueBinding updateQueue(SimpleString name, RoutingType routingType, Filter filter, Integer maxConsumers, Boolean purgeOnNoConsumers, Boolean exclusive, Boolean groupRebalance, Integer groupBuckets, SimpleString groupFirstKey, Boolean nonDestructive, Integer consumersBeforeDispatch, Long delayBeforeDispatch, SimpleString user, Boolean configurationManaged, Long ringSize) throws Exception {
        PostOfficeImpl postOfficeImpl = this;
        synchronized (postOfficeImpl) {
            QueueBinding queueBinding;
            block27: {
                queueBinding = (QueueBinding)this.addressManager.getBinding(name);
                if (queueBinding == null) {
                    return null;
                }
                Bindings bindingsOnQueue = this.addressManager.getBindingsForRoutingAddress(queueBinding.getAddress());
                try {
                    SimpleString address;
                    AddressInfo addressInfo;
                    EnumSet<RoutingType> addressRoutingTypes;
                    int consumerCount;
                    Queue queue = queueBinding.getQueue();
                    boolean changed = false;
                    if (maxConsumers != null && maxConsumers != -1 && (consumerCount = queue.getConsumerCount()) > maxConsumers) {
                        throw ActiveMQMessageBundle.BUNDLE.invalidMaxConsumersUpdate(name.toString(), maxConsumers, consumerCount);
                    }
                    if (routingType != null && !(addressRoutingTypes = (addressInfo = this.addressManager.getAddressInfo(address = queue.getAddress())).getRoutingTypes()).contains(routingType)) {
                        throw ActiveMQMessageBundle.BUNDLE.invalidRoutingTypeUpdate(name.toString(), routingType, address.toString(), addressRoutingTypes);
                    }
                    if (maxConsumers != null && queue.getMaxConsumers() != maxConsumers.intValue()) {
                        changed = true;
                        queue.setMaxConsumer(maxConsumers);
                    }
                    if (routingType != null && queue.getRoutingType() != routingType) {
                        changed = true;
                        queue.setRoutingType(routingType);
                    }
                    if (purgeOnNoConsumers != null && queue.isPurgeOnNoConsumers() != purgeOnNoConsumers.booleanValue()) {
                        changed = true;
                        queue.setPurgeOnNoConsumers(purgeOnNoConsumers);
                    }
                    if (exclusive != null && queue.isExclusive() != exclusive.booleanValue()) {
                        changed = true;
                        queue.setExclusive(exclusive);
                    }
                    if (groupRebalance != null && queue.isGroupRebalance() != groupRebalance.booleanValue()) {
                        changed = true;
                        queue.setGroupRebalance(groupRebalance);
                    }
                    if (groupBuckets != null && queue.getGroupBuckets() != groupBuckets.intValue()) {
                        changed = true;
                        queue.setGroupBuckets(groupBuckets);
                    }
                    if (groupFirstKey != null && !groupFirstKey.equals((Object)queue.getGroupFirstKey())) {
                        changed = true;
                        queue.setGroupFirstKey(groupFirstKey);
                    }
                    if (nonDestructive != null && queue.isNonDestructive() != nonDestructive.booleanValue()) {
                        changed = true;
                        queue.setNonDestructive(nonDestructive);
                    }
                    if (consumersBeforeDispatch != null && !consumersBeforeDispatch.equals(queue.getConsumersBeforeDispatch())) {
                        changed = true;
                        queue.setConsumersBeforeDispatch(consumersBeforeDispatch);
                    }
                    if (delayBeforeDispatch != null && !delayBeforeDispatch.equals(queue.getDelayBeforeDispatch())) {
                        changed = true;
                        queue.setDelayBeforeDispatch(delayBeforeDispatch);
                    }
                    if (filter != null && !filter.equals(queue.getFilter())) {
                        changed = true;
                        queue.setFilter(filter);
                    }
                    if (configurationManaged != null && !configurationManaged.equals(queue.isConfigurationManaged())) {
                        changed = true;
                        queue.setConfigurationManaged(configurationManaged);
                    }
                    if (logger.isDebugEnabled() && user == null && queue.getUser() != null) {
                        logger.debug((Object)"Ignoring updating Queue to a NULL user");
                    }
                    if (user != null && !user.equals((Object)queue.getUser())) {
                        changed = true;
                        queue.setUser(user);
                    }
                    if (ringSize != null && !ringSize.equals(queue.getRingSize())) {
                        changed = true;
                        queue.setRingSize(ringSize);
                    }
                    if (!changed) break block27;
                    long txID = this.storageManager.generateID();
                    try {
                        this.storageManager.updateQueueBinding(txID, queueBinding);
                        this.storageManager.commitBindings(txID);
                    }
                    catch (Throwable throwable) {
                        this.storageManager.rollback(txID);
                        logger.warn((Object)throwable.getMessage(), throwable);
                        throw throwable;
                    }
                }
                finally {
                    if (bindingsOnQueue != null) {
                        bindingsOnQueue.updated(queueBinding);
                    }
                }
            }
            return queueBinding;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddressInfo updateAddressInfo(SimpleString addressName, EnumSet<RoutingType> routingTypes) throws Exception {
        PostOfficeImpl postOfficeImpl = this;
        synchronized (postOfficeImpl) {
            if (this.server.hasBrokerAddressPlugins()) {
                this.server.callBrokerAddressPlugins(plugin -> plugin.beforeUpdateAddress(addressName, routingTypes));
            }
            AddressInfo address = this.addressManager.updateAddressInfo(addressName, routingTypes);
            if (this.server.hasBrokerAddressPlugins()) {
                this.server.callBrokerAddressPlugins(plugin -> plugin.afterUpdateAddress(address));
            }
            return address;
        }
    }

    @Override
    public AddressInfo removeAddressInfo(SimpleString address) throws Exception {
        return this.removeAddressInfo(address, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddressInfo removeAddressInfo(SimpleString address, boolean force) throws Exception {
        PostOfficeImpl postOfficeImpl = this;
        synchronized (postOfficeImpl) {
            if (this.server.hasBrokerAddressPlugins()) {
                this.server.callBrokerAddressPlugins(plugin -> plugin.beforeRemoveAddress(address));
            }
            Bindings bindingsForAddress = this.getDirectBindings(address);
            if (force) {
                for (Binding binding : bindingsForAddress.getBindings()) {
                    if (!(binding instanceof QueueBinding)) continue;
                    ((QueueBinding)binding).getQueue().deleteQueue(true);
                }
            } else if (bindingsForAddress.getBindings().size() > 0) {
                throw ActiveMQMessageBundle.BUNDLE.addressHasBindings(address);
            }
            this.managementService.unregisterAddress(address);
            AddressInfo addressInfo = this.addressManager.removeAddressInfo(address);
            if (this.server.hasBrokerAddressPlugins()) {
                this.server.callBrokerAddressPlugins(plugin -> plugin.afterRemoveAddress(address, addressInfo));
            }
            return addressInfo;
        }
    }

    @Override
    public AddressInfo getAddressInfo(SimpleString addressName) {
        return this.addressManager.getAddressInfo(addressName);
    }

    @Override
    public List<Queue> listQueuesForAddress(SimpleString address) throws Exception {
        Bindings bindingsForAddress = this.lookupBindingsForAddress(address);
        ArrayList<Queue> queues = new ArrayList<Queue>();
        if (bindingsForAddress != null) {
            for (Binding b : bindingsForAddress.getBindings()) {
                if (!(b instanceof QueueBinding)) continue;
                Queue q = ((QueueBinding)b).getQueue();
                queues.add(q);
            }
        }
        return queues;
    }

    @Override
    public synchronized void addBinding(Binding binding) throws Exception {
        if (this.server.hasBrokerBindingPlugins()) {
            this.server.callBrokerBindingPlugins(plugin -> plugin.beforeAddBinding(binding));
        }
        this.addressManager.addBinding(binding);
        TypedProperties props = new TypedProperties();
        props.putIntProperty(ManagementHelper.HDR_BINDING_TYPE, binding.getType().toInt());
        props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, binding.getAddress());
        props.putSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME, binding.getClusterName());
        props.putSimpleStringProperty(ManagementHelper.HDR_ROUTING_NAME, binding.getRoutingName());
        props.putLongProperty(ManagementHelper.HDR_BINDING_ID, binding.getID());
        props.putIntProperty(ManagementHelper.HDR_DISTANCE, binding.getDistance());
        Filter filter = binding.getFilter();
        if (filter != null) {
            props.putSimpleStringProperty(ManagementHelper.HDR_FILTERSTRING, filter.getFilterString());
        }
        String uid = UUIDGenerator.getInstance().generateStringUUID();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ClusterCommunication::Sending notification for addBinding " + binding + " from server " + this.server));
        }
        this.managementService.sendNotification(new Notification(uid, (NotificationType)CoreNotificationType.BINDING_ADDED, props));
        if (this.server.hasBrokerBindingPlugins()) {
            this.server.callBrokerBindingPlugins(plugin -> plugin.afterAddBinding(binding));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Binding removeBinding(SimpleString uniqueName, Transaction tx, boolean deleteData) throws Exception {
        if (this.server.hasBrokerBindingPlugins()) {
            this.server.callBrokerBindingPlugins(plugin -> plugin.beforeRemoveBinding(uniqueName, tx, deleteData));
        }
        try {
            Binding binding = this.addressManager.removeBinding(uniqueName, tx);
            if (binding == null) {
                throw new ActiveMQNonExistentQueueException();
            }
            if (deleteData && this.addressManager.getBindingsForRoutingAddress(binding.getAddress()) == null) {
                this.pagingManager.deletePageStore(binding.getAddress());
                this.deleteDuplicateCache(binding.getAddress());
            }
            if (binding.getType() == BindingType.LOCAL_QUEUE) {
                Queue queue = (Queue)binding.getBindable();
                this.managementService.unregisterQueue(uniqueName, binding.getAddress(), queue.getRoutingType());
            } else if (binding.getType() == BindingType.DIVERT) {
                this.managementService.unregisterDivert(uniqueName, binding.getAddress());
            }
            AddressInfo addressInfo = this.getAddressInfo(binding.getAddress());
            if (addressInfo != null) {
                addressInfo.setBindingRemovedTimestamp(System.currentTimeMillis());
            }
            if (binding.getType() != BindingType.DIVERT) {
                TypedProperties props = new TypedProperties();
                props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, binding.getAddress());
                props.putSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME, binding.getClusterName());
                props.putSimpleStringProperty(ManagementHelper.HDR_ROUTING_NAME, binding.getRoutingName());
                props.putIntProperty(ManagementHelper.HDR_DISTANCE, binding.getDistance());
                props.putLongProperty(ManagementHelper.HDR_BINDING_ID, binding.getID());
                if (binding.getFilter() == null) {
                    props.putSimpleStringProperty(ManagementHelper.HDR_FILTERSTRING, null);
                } else {
                    props.putSimpleStringProperty(ManagementHelper.HDR_FILTERSTRING, binding.getFilter().getFilterString());
                }
                this.managementService.sendNotification(new Notification(null, (NotificationType)CoreNotificationType.BINDING_REMOVED, props));
            }
            binding.close();
            if (this.server.hasBrokerBindingPlugins()) {
                this.server.callBrokerBindingPlugins(plugin -> plugin.afterRemoveBinding(binding, tx, deleteData));
            }
            Binding binding2 = binding;
            return binding2;
        }
        finally {
            this.server.clearAddressCache();
        }
    }

    private void deleteDuplicateCache(SimpleString address) throws Exception {
        DuplicateIDCache cache = (DuplicateIDCache)this.duplicateIDCaches.remove(address);
        if (cache != null) {
            cache.clear();
        }
        if ((cache = (DuplicateIDCache)this.duplicateIDCaches.remove(BRIDGE_CACHE_STR.concat(address))) != null) {
            cache.clear();
        }
    }

    @Override
    public boolean isAddressBound(SimpleString address) throws Exception {
        Bindings bindings = this.lookupBindingsForAddress(address);
        return bindings != null && !bindings.getBindings().isEmpty();
    }

    @Override
    public Bindings getBindingsForAddress(SimpleString address) throws Exception {
        Bindings bindings = this.addressManager.getBindingsForRoutingAddress(address);
        if (bindings == null) {
            bindings = this.createBindings(address);
        }
        return bindings;
    }

    @Override
    public Bindings lookupBindingsForAddress(SimpleString address) throws Exception {
        return this.addressManager.getBindingsForRoutingAddress(address);
    }

    @Override
    public Binding getBinding(SimpleString name) {
        return this.addressManager.getBinding(name);
    }

    @Override
    public Bindings getMatchingBindings(SimpleString address) throws Exception {
        return this.addressManager.getMatchingBindings(address);
    }

    @Override
    public Bindings getDirectBindings(SimpleString address) throws Exception {
        return this.addressManager.getDirectBindings(address);
    }

    @Override
    public Map<SimpleString, Binding> getAllBindings() {
        return this.addressManager.getBindings();
    }

    @Override
    public RoutingStatus route(Message message, boolean direct) throws Exception {
        return this.route(message, (Transaction)null, direct);
    }

    @Override
    public RoutingStatus route(Message message, Transaction tx, boolean direct) throws Exception {
        return this.route(message, new RoutingContextImpl(tx), direct);
    }

    @Override
    public RoutingStatus route(Message message, Transaction tx, boolean direct, boolean rejectDuplicates) throws Exception {
        return this.route(message, new RoutingContextImpl(tx), direct, rejectDuplicates, null);
    }

    @Override
    public RoutingStatus route(Message message, Transaction tx, boolean direct, boolean rejectDuplicates, Binding binding) throws Exception {
        return this.route(message, new RoutingContextImpl(tx), direct, rejectDuplicates, binding);
    }

    @Override
    public RoutingStatus route(Message message, RoutingContext context, boolean direct) throws Exception {
        return this.route(message, context, direct, true, null);
    }

    @Override
    public RoutingStatus route(Message message, RoutingContext context, boolean direct, boolean rejectDuplicates, Binding bindingMove) throws Exception {
        RoutingStatus result;
        if (message.getRefCount() > 0) {
            throw new IllegalStateException("Message cannot be routed more than once");
        }
        SimpleString address = context.getAddress(message);
        this.setPagingStore(address, message);
        AtomicBoolean startedTX = new AtomicBoolean(false);
        this.applyExpiryDelay(message, address);
        if (!this.checkDuplicateID(message, context, rejectDuplicates, startedTX)) {
            return RoutingStatus.DUPLICATED_ID;
        }
        message.clearInternalProperties();
        Bindings bindings = this.addressManager.getBindingsForRoutingAddress(address);
        AddressInfo addressInfo = this.addressManager.getAddressInfo(address);
        if (bindingMove != null) {
            context.clear();
            context.setReusable(false);
            bindingMove.route(message, context);
            if (addressInfo != null) {
                addressInfo.incrementRoutedMessageCount();
            }
        } else if (bindings != null) {
            bindings.route(message, context);
            if (addressInfo != null) {
                addressInfo.incrementRoutedMessageCount();
            }
        } else {
            context.setReusable(false);
            if (addressInfo != null) {
                addressInfo.incrementUnRoutedMessageCount();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Couldn't find any bindings for address=" + address + " on message=" + message));
            }
        }
        if (this.server.hasBrokerMessagePlugins()) {
            this.server.callBrokerMessagePlugins(plugin -> plugin.beforeMessageRoute(message, context, direct, rejectDuplicates));
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Message after routed=" + message + "\n" + context.toString()));
        }
        try {
            if (context.getQueueCount() == 0) {
                AddressSettings addressSettings = this.addressSettingsRepository.getMatch(address.toString());
                boolean sendToDLA = addressSettings.isSendToDLAOnNoRoute();
                if (sendToDLA) {
                    SimpleString dlaAddress = addressSettings.getDeadLetterAddress();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("sending message to dla address = " + dlaAddress + ", message=" + message));
                    }
                    if (dlaAddress == null) {
                        result = RoutingStatus.NO_BINDINGS;
                        ActiveMQServerLogger.LOGGER.noDLA(address);
                    } else {
                        message.referenceOriginalMessage(message, null);
                        message.setAddress(dlaAddress);
                        message.reencode();
                        this.route(message, context.getTransaction(), false);
                        result = RoutingStatus.NO_BINDINGS_DLA;
                    }
                } else {
                    result = RoutingStatus.NO_BINDINGS;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Message " + message + " is not going anywhere as it didn't have a binding on address:" + address));
                    }
                    if (message.isLargeMessage()) {
                        ((LargeServerMessage)message).deleteFile();
                    }
                }
            } else {
                result = RoutingStatus.OK;
                try {
                    this.processRoute(message, context, direct);
                }
                catch (ActiveMQAddressFullException e) {
                    if (startedTX.get()) {
                        context.getTransaction().rollback();
                    } else if (context.getTransaction() != null) {
                        context.getTransaction().markAsRollbackOnly((ActiveMQException)((Object)e));
                    }
                    throw e;
                }
            }
            if (startedTX.get()) {
                context.getTransaction().commit();
            }
        }
        catch (Exception e) {
            if (this.server.hasBrokerMessagePlugins()) {
                this.server.callBrokerMessagePlugins(plugin -> plugin.onMessageRouteException(message, context, direct, rejectDuplicates, e));
            }
            throw e;
        }
        if (this.server.hasBrokerMessagePlugins()) {
            this.server.callBrokerMessagePlugins(plugin -> plugin.afterMessageRoute(message, context, direct, rejectDuplicates, result));
        }
        return result;
    }

    private void applyExpiryDelay(Message message, SimpleString address) {
        long expirationOverride = this.addressSettingsRepository.getMatch(address.toString()).getExpiryDelay();
        if (expirationOverride >= 0L && message.getExpiration() == 0L) {
            message.setExpiration(System.currentTimeMillis() + expirationOverride);
        }
    }

    @Override
    public MessageReference reroute(Message message, Queue queue, Transaction tx) throws Exception {
        this.setPagingStore(queue.getAddress(), message);
        MessageReference reference = MessageReference.Factory.createReference(message, queue);
        Long scheduledDeliveryTime = message.getScheduledDeliveryTime();
        if (scheduledDeliveryTime != null) {
            reference.setScheduledDeliveryTime(scheduledDeliveryTime);
        }
        message.incrementDurableRefCount();
        message.incrementRefCount();
        if (tx == null) {
            queue.reload(reference);
        } else {
            ArrayList<MessageReference> refs = new ArrayList<MessageReference>(1);
            refs.add(reference);
            tx.addOperation(new AddOperation(refs));
        }
        return reference;
    }

    @Override
    public Pair<RoutingContext, Message> redistribute(Message message, Queue originatingQueue, Transaction tx) throws Exception {
        Bindings bindings = this.addressManager.getBindingsForRoutingAddress(originatingQueue.getAddress());
        if (bindings != null && bindings.allowRedistribute()) {
            RoutingContextImpl context;
            boolean routed;
            final Message copyRedistribute = message.copy(this.storageManager.generateID());
            copyRedistribute.setAddress(originatingQueue.getAddress());
            if (tx != null) {
                tx.addOperation(new TransactionOperationAbstract(){

                    @Override
                    public void afterRollback(Transaction tx) {
                        try {
                            copyRedistribute.decrementRefCount();
                        }
                        catch (Exception e) {
                            logger.warn((Object)("Failed to clean up message: " + copyRedistribute));
                        }
                    }
                });
            }
            if (routed = bindings.redistribute(copyRedistribute, originatingQueue, context = new RoutingContextImpl(tx))) {
                return new Pair((Object)context, (Object)copyRedistribute);
            }
        }
        return null;
    }

    @Override
    public DuplicateIDCache getDuplicateIDCache(SimpleString address) {
        DuplicateIDCache oldCache;
        DuplicateIDCache cache = (DuplicateIDCache)this.duplicateIDCaches.get(address);
        if (cache == null && (oldCache = this.duplicateIDCaches.putIfAbsent(address, cache = new DuplicateIDCacheImpl(address, this.idCacheSize, this.storageManager, this.persistIDCache))) != null) {
            cache = oldCache;
        }
        return cache;
    }

    public ConcurrentMap<SimpleString, DuplicateIDCache> getDuplicateIDCaches() {
        return this.duplicateIDCaches;
    }

    @Override
    public Object getNotificationLock() {
        return this.notificationLock;
    }

    @Override
    public Set<SimpleString> getAddresses() {
        return this.addressManager.getAddresses();
    }

    @Override
    public void updateMessageLoadBalancingTypeForAddress(SimpleString address, MessageLoadBalancingType messageLoadBalancingType) throws Exception {
        this.addressManager.updateMessageLoadBalancingTypeForAddress(address, messageLoadBalancingType);
    }

    @Override
    public SimpleString getMatchingQueue(SimpleString address, RoutingType routingType) throws Exception {
        return this.addressManager.getMatchingQueue(address, routingType);
    }

    @Override
    public SimpleString getMatchingQueue(SimpleString address, SimpleString queueName, RoutingType routingType) throws Exception {
        return this.addressManager.getMatchingQueue(address, queueName, routingType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendQueueInfoToQueue(SimpleString queueName, SimpleString address) throws Exception {
        Binding binding = this.addressManager.getBinding(queueName);
        if (binding == null) {
            throw new IllegalStateException("Cannot find queue " + queueName);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PostOffice.sendQueueInfoToQueue on server=" + this.server + ", queueName=" + queueName + " and address=" + address));
        }
        Queue queue = (Queue)binding.getBindable();
        Object object = this.notificationLock;
        synchronized (object) {
            CoreMessage message = new CoreMessage(this.storageManager.generateID(), 50);
            message.setAddress(queueName);
            message.putBooleanProperty(HDR_RESET_QUEUE_DATA, true);
            this.routeQueueInfo((Message)message, queue, false);
            for (QueueInfo info : this.queueInfos.values()) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("QueueInfo on sendQueueInfoToQueue = " + info));
                }
                if (!info.matchesAddress(address)) continue;
                message = this.createQueueInfoMessage((NotificationType)CoreNotificationType.BINDING_ADDED, queueName);
                message.putStringProperty(ManagementHelper.HDR_ADDRESS, info.getAddress());
                message.putStringProperty(ManagementHelper.HDR_CLUSTER_NAME, info.getClusterName());
                message.putStringProperty(ManagementHelper.HDR_ROUTING_NAME, info.getRoutingName());
                message.putLongProperty(ManagementHelper.HDR_BINDING_ID, info.getID());
                message.putStringProperty(ManagementHelper.HDR_FILTERSTRING, info.getFilterString());
                message.putIntProperty(ManagementHelper.HDR_DISTANCE, info.getDistance());
                this.routeQueueInfo((Message)message, queue, true);
                int consumersWithFilters = info.getFilterStrings() != null ? info.getFilterStrings().size() : 0;
                for (int i = 0; i < info.getNumberOfConsumers() - consumersWithFilters; ++i) {
                    message = this.createQueueInfoMessage((NotificationType)CoreNotificationType.CONSUMER_CREATED, queueName);
                    message.putStringProperty(ManagementHelper.HDR_ADDRESS, info.getAddress());
                    message.putStringProperty(ManagementHelper.HDR_CLUSTER_NAME, info.getClusterName());
                    message.putStringProperty(ManagementHelper.HDR_ROUTING_NAME, info.getRoutingName());
                    message.putIntProperty(ManagementHelper.HDR_DISTANCE, info.getDistance());
                    this.routeQueueInfo((Message)message, queue, true);
                }
                if (info.getFilterStrings() == null) continue;
                for (SimpleString filterString : info.getFilterStrings()) {
                    message = this.createQueueInfoMessage((NotificationType)CoreNotificationType.CONSUMER_CREATED, queueName);
                    message.putStringProperty(ManagementHelper.HDR_ADDRESS, info.getAddress());
                    message.putStringProperty(ManagementHelper.HDR_CLUSTER_NAME, info.getClusterName());
                    message.putStringProperty(ManagementHelper.HDR_ROUTING_NAME, info.getRoutingName());
                    message.putStringProperty(ManagementHelper.HDR_FILTERSTRING, filterString);
                    message.putIntProperty(ManagementHelper.HDR_DISTANCE, info.getDistance());
                    this.routeQueueInfo((Message)message, queue, true);
                }
            }
            CoreMessage completeMessage = new CoreMessage(this.storageManager.generateID(), 50);
            completeMessage.setAddress(queueName);
            completeMessage.putBooleanProperty(HDR_RESET_QUEUE_DATA_COMPLETE, true);
            this.routeQueueInfo((Message)completeMessage, queue, false);
        }
    }

    public String toString() {
        return "PostOfficeImpl [server=" + this.server + "]";
    }

    private void setPagingStore(SimpleString address, Message message) throws Exception {
        PagingStore store = this.pagingManager.getPageStore(CompositeAddress.extractAddressName((SimpleString)address));
        message.setContext((RefCountMessageListener)store);
    }

    private void routeQueueInfo(Message message, Queue queue, boolean applyFilters) throws Exception {
        if (!applyFilters || queue.getFilter() == null || queue.getFilter().match(message)) {
            RoutingContextImpl context = new RoutingContextImpl(null);
            queue.route(message, context);
            this.processRoute(message, context, false);
        }
    }

    @Override
    public void processRoute(Message message, final RoutingContext context, final boolean direct) throws Exception {
        final ArrayList<MessageReference> refs = new ArrayList<MessageReference>();
        Transaction tx = context.getTransaction();
        Long deliveryTime = message.getScheduledDeliveryTime();
        for (Map.Entry<SimpleString, RouteContextList> entry : context.getContexListing().entrySet()) {
            MessageReference reference;
            PagingStore store = this.pagingManager.getPageStore(entry.getKey());
            if (store != null && this.storageManager.addToPage(store, message, context.getTransaction(), entry.getValue())) {
                if (message.isLargeMessage()) {
                    this.confirmLargeMessageSend(tx, message);
                }
                this.schedulePageDelivery(tx, entry);
                continue;
            }
            for (Queue queue : entry.getValue().getNonDurableQueues()) {
                reference = MessageReference.Factory.createReference(message, queue);
                if (deliveryTime != null) {
                    reference.setScheduledDeliveryTime(deliveryTime);
                }
                refs.add(reference);
                message.incrementRefCount();
            }
            Iterator<Queue> iter = entry.getValue().getDurableQueues().iterator();
            while (iter.hasNext()) {
                Queue queue;
                queue = iter.next();
                reference = MessageReference.Factory.createReference(message, queue);
                if (context.isAlreadyAcked(context.getAddress(message), queue)) {
                    reference.setAlreadyAcked();
                    if (tx != null) {
                        queue.acknowledge(tx, reference);
                    }
                }
                if (deliveryTime != null) {
                    reference.setScheduledDeliveryTime(deliveryTime);
                }
                refs.add(reference);
                if (message.isDurable()) {
                    int durableRefCount = message.incrementDurableRefCount();
                    if (durableRefCount == 1) {
                        if (tx != null) {
                            this.storageManager.storeMessageTransactional(tx.getID(), message);
                        } else {
                            this.storageManager.storeMessage(message);
                        }
                        if (message.isLargeMessage()) {
                            this.confirmLargeMessageSend(tx, message);
                        }
                    }
                    if (tx != null) {
                        this.storageManager.storeReferenceTransactional(tx.getID(), queue.getID(), message.getMessageID());
                        tx.setContainsPersistent();
                    } else {
                        this.storageManager.storeReference(queue.getID(), message.getMessageID(), !iter.hasNext());
                    }
                    if (deliveryTime != null && deliveryTime > 0L) {
                        if (tx != null) {
                            this.storageManager.updateScheduledDeliveryTimeTransactional(tx.getID(), reference);
                        } else {
                            this.storageManager.updateScheduledDeliveryTime(reference);
                        }
                    }
                }
                message.incrementRefCount();
            }
        }
        if (tx != null) {
            tx.addOperation(new AddOperation(refs));
        } else {
            this.storageManager.afterCompleteOperations(new IOCallback(){

                public void onError(int errorCode, String errorMessage) {
                    ActiveMQServerLogger.LOGGER.ioErrorAddingReferences(errorCode, errorMessage);
                }

                public void done() {
                    context.processReferences(refs, direct);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void confirmLargeMessageSend(Transaction tx, Message message) throws Exception {
        LargeServerMessage largeServerMessage;
        LargeServerMessage largeServerMessage2 = largeServerMessage = (LargeServerMessage)message;
        synchronized (largeServerMessage2) {
            if (largeServerMessage.getPendingRecordID() >= 0L) {
                if (tx == null) {
                    this.storageManager.confirmPendingLargeMessage(largeServerMessage.getPendingRecordID());
                } else {
                    this.storageManager.confirmPendingLargeMessageTX(tx, largeServerMessage.getMessageID(), largeServerMessage.getPendingRecordID());
                }
                largeServerMessage.setPendingRecordID(-1L);
            }
        }
    }

    private void schedulePageDelivery(Transaction tx, Map.Entry<SimpleString, RouteContextList> entry) {
        if (tx != null) {
            PageDelivery delivery = (PageDelivery)tx.getProperty(7);
            if (delivery == null) {
                delivery = new PageDelivery();
                tx.putProperty(7, delivery);
                tx.addOperation(delivery);
            }
            delivery.addQueues(entry.getValue().getDurableQueues());
            delivery.addQueues(entry.getValue().getNonDurableQueues());
        } else {
            List<Queue> durableQueues = entry.getValue().getDurableQueues();
            List<Queue> nonDurableQueues = entry.getValue().getNonDurableQueues();
            final ArrayList<Queue> queues = new ArrayList<Queue>(durableQueues.size() + nonDurableQueues.size());
            queues.addAll(durableQueues);
            queues.addAll(nonDurableQueues);
            this.storageManager.afterCompleteOperations(new IOCallback(){

                public void onError(int errorCode, String errorMessage) {
                }

                public void done() {
                    for (Queue queue : queues) {
                        queue.deliverAsync();
                    }
                }
            });
        }
    }

    private boolean checkDuplicateID(Message message, RoutingContext context, boolean rejectDuplicates, AtomicBoolean startedTX) throws Exception {
        byte[] bridgeDup = message.removeExtraBytesProperty(Message.HDR_BRIDGE_DUPLICATE_ID);
        if (bridgeDup != null) {
            byte[] bridgeDupBytes = bridgeDup;
            DuplicateIDCache cacheBridge = this.getDuplicateIDCache(BRIDGE_CACHE_STR.concat(context.getAddress(message).toString()));
            if (context.getTransaction() == null) {
                context.setTransaction(new TransactionImpl(this.storageManager));
                startedTX.set(true);
            }
            if (!cacheBridge.atomicVerify(bridgeDupBytes, context.getTransaction())) {
                context.getTransaction().rollback();
                startedTX.set(false);
                message.decrementRefCount();
                return false;
            }
        } else {
            byte[] duplicateIDBytes = message.getDuplicateIDBytes();
            DuplicateIDCache cache = null;
            boolean isDuplicate = false;
            if (duplicateIDBytes != null) {
                cache = this.getDuplicateIDCache(context.getAddress(message));
                isDuplicate = cache.contains(duplicateIDBytes);
                if (rejectDuplicates && isDuplicate) {
                    ActiveMQServerLogger.LOGGER.duplicateMessageDetected(message);
                    String warnMessage = "Duplicate message detected - message will not be routed. Message information:" + message.toString();
                    if (context.getTransaction() != null) {
                        context.getTransaction().markAsRollbackOnly((ActiveMQException)new ActiveMQDuplicateIdException(warnMessage));
                    }
                    message.decrementRefCount();
                    return false;
                }
            }
            if (cache != null && !isDuplicate) {
                if (context.getTransaction() == null) {
                    context.setTransaction(new TransactionImpl(this.storageManager));
                    startedTX.set(true);
                }
                cache.addToCache(duplicateIDBytes, context.getTransaction(), startedTX.get());
            }
        }
        return true;
    }

    @Override
    public synchronized void startExpiryScanner() {
        if (this.expiryReaperPeriod > 0L) {
            if (this.expiryReaperRunnable != null) {
                this.expiryReaperRunnable.stop();
            }
            this.expiryReaperRunnable = new ExpiryReaper(this.server.getScheduledPool(), (Executor)this.server.getExecutorFactory().getExecutor(), this.expiryReaperPeriod, TimeUnit.MILLISECONDS, false);
            this.expiryReaperRunnable.start();
        }
    }

    @Override
    public synchronized void startAddressQueueScanner() {
        if (this.addressQueueReaperPeriod > 0L) {
            if (this.addressQueueReaperRunnable != null) {
                this.addressQueueReaperRunnable.stop();
            }
            this.addressQueueReaperRunnable = new AddressQueueReaper(this.server.getScheduledPool(), (Executor)this.server.getExecutorFactory().getExecutor(), this.addressQueueReaperPeriod, TimeUnit.MILLISECONDS, false);
            this.addressQueueReaperRunnable.start();
        }
    }

    private Message createQueueInfoMessage(NotificationType type, SimpleString queueName) {
        CoreMessage message = new CoreMessage().initBuffer(50).setMessageID(this.storageManager.generateID());
        message.setAddress(queueName);
        String uid = UUIDGenerator.getInstance().generateStringUUID();
        message.putStringProperty(ManagementHelper.HDR_NOTIFICATION_TYPE, new SimpleString(type.toString()));
        message.putLongProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP, System.currentTimeMillis());
        message.putStringProperty(new SimpleString("foobar"), new SimpleString(uid));
        return message;
    }

    private List<Queue> getLocalQueues() {
        Map<SimpleString, Binding> nameMap = this.addressManager.getBindings();
        ArrayList<Queue> queues = new ArrayList<Queue>();
        for (Binding binding : nameMap.values()) {
            if (binding.getType() != BindingType.LOCAL_QUEUE) continue;
            Queue queue = (Queue)binding.getBindable();
            queues.add(queue);
        }
        return queues;
    }

    @Override
    public Bindings createBindings(SimpleString address) {
        GroupingHandler groupingHandler = this.server.getGroupingHandler();
        BindingsImpl bindings = new BindingsImpl(CompositeAddress.extractAddressName((SimpleString)address), groupingHandler);
        if (groupingHandler != null) {
            groupingHandler.addListener(bindings);
        }
        return bindings;
    }

    public AddressManager getAddressManager() {
        return this.addressManager;
    }

    public ActiveMQServer getServer() {
        return this.server;
    }

    public static final class AddOperation
    implements TransactionOperation {
        private final List<MessageReference> refs;

        AddOperation(List<MessageReference> refs) {
            this.refs = refs;
        }

        @Override
        public void afterCommit(Transaction tx) {
            for (MessageReference ref : this.refs) {
                if (ref.isAlreadyAcked()) continue;
                ref.getQueue().addTail(ref, false);
            }
        }

        @Override
        public void afterPrepare(Transaction tx) {
            for (MessageReference ref : this.refs) {
                if (!ref.isAlreadyAcked()) continue;
                ref.getQueue().referenceHandled(ref);
                ref.getQueue().incrementMesssagesAdded();
            }
        }

        @Override
        public void afterRollback(Transaction tx) {
        }

        @Override
        public void beforeCommit(Transaction tx) throws Exception {
        }

        @Override
        public void beforePrepare(Transaction tx) throws Exception {
        }

        @Override
        public void beforeRollback(Transaction tx) throws Exception {
            for (MessageReference ref : this.refs) {
                Message message = ref.getMessage();
                if (message.isDurable() && ref.getQueue().isDurable()) {
                    message.decrementDurableRefCount();
                }
                message.decrementRefCount();
            }
        }

        @Override
        public List<MessageReference> getRelatedMessageReferences() {
            return this.refs;
        }

        @Override
        public List<MessageReference> getListOnConsumer(long consumerID) {
            return Collections.emptyList();
        }
    }

    private final class AddressQueueReaper
    extends ActiveMQScheduledComponent {
        AddressQueueReaper(ScheduledExecutorService scheduledExecutorService, Executor executor, long checkPeriod, TimeUnit timeUnit, boolean onDemand) {
            super(scheduledExecutorService, executor, checkPeriod, timeUnit, onDemand);
        }

        public void run() {
            for (Queue queue : PostOfficeImpl.this.getLocalQueues()) {
                if (queue.isInternalQueue() || !QueueManagerImpl.isAutoDelete(queue) || !QueueManagerImpl.consumerCountCheck(queue) || !QueueManagerImpl.delayCheck(queue) || !QueueManagerImpl.messageCountCheck(queue)) continue;
                QueueManagerImpl.performAutoDeleteQueue(PostOfficeImpl.this.server, queue);
            }
            Set<SimpleString> addresses = PostOfficeImpl.this.addressManager.getAddresses();
            for (SimpleString address : addresses) {
                AddressInfo addressInfo = PostOfficeImpl.this.getAddressInfo(address);
                AddressSettings settings = (AddressSettings)PostOfficeImpl.this.addressSettingsRepository.getMatch(address.toString());
                try {
                    if (!settings.isAutoDeleteAddresses() || addressInfo == null || !addressInfo.isAutoCreated() || PostOfficeImpl.this.isAddressBound(address) || addressInfo.getBindingRemovedTimestamp() == -1L || System.currentTimeMillis() - addressInfo.getBindingRemovedTimestamp() < settings.getAutoDeleteAddressesDelay()) continue;
                    if (ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
                        ActiveMQServerLogger.LOGGER.debug("deleting auto-created address \"" + address + ".\"");
                    }
                    PostOfficeImpl.this.server.removeAddressInfo(address, null);
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorRemovingAutoCreatedQueue(e, address);
                }
            }
        }
    }

    private final class ExpiryReaper
    extends ActiveMQScheduledComponent {
        ExpiryReaper(ScheduledExecutorService scheduledExecutorService, Executor executor, long checkPeriod, TimeUnit timeUnit, boolean onDemand) {
            super(scheduledExecutorService, executor, checkPeriod, timeUnit, onDemand);
        }

        public void run() {
            for (Queue queue : PostOfficeImpl.this.getLocalQueues()) {
                try {
                    queue.expireReferences();
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorExpiringMessages(e);
                }
            }
        }
    }

    private static class PageDelivery
    extends TransactionOperationAbstract {
        private final Set<Queue> queues = new HashSet<Queue>();

        private PageDelivery() {
        }

        public void addQueues(List<Queue> queueList) {
            this.queues.addAll(queueList);
        }

        @Override
        public void afterCommit(Transaction tx) {
            for (Queue queue : this.queues) {
                queue.deliverAsync();
            }
        }

        @Override
        public List<MessageReference> getRelatedMessageReferences() {
            return Collections.emptyList();
        }
    }
}

