/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.wildfly.sp;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormData;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.util.AttachmentKey;
import javax.servlet.http.HttpServletRequest;
import org.picketlink.identity.federation.bindings.wildfly.sp.SPFormAuthenticationRequestWrapper;

public class SPFormAuthrenticationRequestUtil {
    public static final AttachmentKey<SPFAMFormDataWrapper> FORM_DATA_ATTACHMENT_KEY = AttachmentKey.create(SPFAMFormDataWrapper.class);

    public static void store(byte[] buffer, FormData formData, HttpServerExchange exchange, int contentLength) {
        exchange.putAttachment(FORM_DATA_ATTACHMENT_KEY, (Object)new SPFAMFormDataWrapper(formData, buffer, contentLength));
    }

    public static byte[] getStoredBuffer(HttpServerExchange exchange) {
        SPFAMFormDataWrapper formData = (SPFAMFormDataWrapper)exchange.getAttachment(FORM_DATA_ATTACHMENT_KEY);
        if (formData != null) {
            return formData.getBuffer();
        }
        return null;
    }

    public static int getStoredBufferLength(HttpServerExchange exchange) {
        SPFAMFormDataWrapper formData = (SPFAMFormDataWrapper)exchange.getAttachment(FORM_DATA_ATTACHMENT_KEY);
        if (formData != null) {
            return formData.getContentLength();
        }
        return -1;
    }

    public static HttpServletRequest wrapRequest(HttpServerExchange exchange) {
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpServletRequest request = (HttpServletRequest)servletRequestContext.getServletRequest();
        if (request instanceof SPFormAuthenticationRequestWrapper) {
            return request;
        }
        SPFAMFormDataWrapper formData = (SPFAMFormDataWrapper)exchange.getAttachment(FORM_DATA_ATTACHMENT_KEY);
        if (formData != null) {
            return new SPFormAuthenticationRequestWrapper(request, formData.getFormData(), formData.buffer);
        }
        return request;
    }

    public static class SPFAMFormDataWrapper {
        private final FormData formData;
        private final byte[] buffer;
        private final int contentLength;

        public SPFAMFormDataWrapper(FormData formData, byte[] buffer, int contentLength) {
            this.formData = formData;
            this.buffer = buffer;
            this.contentLength = contentLength;
        }

        public FormData getFormData() {
            return this.formData;
        }

        public byte[] getBuffer() {
            return this.buffer;
        }

        public int getContentLength() {
            return this.contentLength;
        }
    }
}

