/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.health.deployment;

import io.smallrye.health.SmallRyeHealthReporter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.util.AnnotationLiteral;
import org.eclipse.microprofile.health.Health;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.Liveness;
import org.eclipse.microprofile.health.Readiness;
import org.wildfly.extension.microprofile.health.HealthReporter;

public class CDIExtension
implements Extension {
    private final HealthReporter reporter;
    private Instance<Object> instance;
    private final List<HealthCheck> healthChecks = new ArrayList<HealthCheck>();
    private final List<HealthCheck> livenessChecks = new ArrayList<HealthCheck>();
    private final List<HealthCheck> readinessChecks = new ArrayList<HealthCheck>();

    public CDIExtension(HealthReporter healthReporter) {
        this.reporter = healthReporter;
    }

    private void afterDeploymentValidation(@Observes AfterDeploymentValidation avd, BeanManager bm) {
        this.instance = bm.createInstance();
        this.addHealthChecks(HealthLiteral.INSTANCE, this.reporter::addHealthCheck, this.healthChecks);
        this.addHealthChecks(LivenessLiteral.INSTANCE, this.reporter::addLivenessCheck, this.livenessChecks);
        this.addHealthChecks(ReadinessLiteral.INSTANCE, this.reporter::addReadinessCheck, this.readinessChecks);
    }

    private void addHealthChecks(AnnotationLiteral qualifier, Consumer<HealthCheck> healthFunction, List<HealthCheck> healthChecks) {
        for (HealthCheck healthCheck : this.instance.select(HealthCheck.class, new Annotation[]{qualifier})) {
            healthFunction.accept(healthCheck);
            healthChecks.add(healthCheck);
        }
    }

    public void beforeShutdown(@Observes BeforeShutdown bs) {
        this.removeHealthCheck(this.healthChecks, this.reporter::removeHealthCheck);
        this.removeHealthCheck(this.livenessChecks, this.reporter::removeLivenessCheck);
        this.removeHealthCheck(this.readinessChecks, this.reporter::removeReadinessCheck);
        this.instance = null;
    }

    private void removeHealthCheck(List<HealthCheck> healthChecks, Consumer<HealthCheck> healthFunction) {
        for (HealthCheck healthCheck : healthChecks) {
            healthFunction.accept(healthCheck);
            this.instance.destroy((Object)healthCheck);
        }
        healthChecks.clear();
    }

    public void vetoSmallryeHealthReporter(@Observes ProcessAnnotatedType<SmallRyeHealthReporter> pat) {
        pat.veto();
    }

    static final class ReadinessLiteral
    extends AnnotationLiteral<Readiness>
    implements Readiness {
        static final ReadinessLiteral INSTANCE = new ReadinessLiteral();
        private static final long serialVersionUID = 1L;

        ReadinessLiteral() {
        }
    }

    static final class LivenessLiteral
    extends AnnotationLiteral<Liveness>
    implements Liveness {
        static final LivenessLiteral INSTANCE = new LivenessLiteral();
        private static final long serialVersionUID = 1L;

        LivenessLiteral() {
        }
    }

    static final class HealthLiteral
    extends AnnotationLiteral<Health>
    implements Health {
        static final HealthLiteral INSTANCE = new HealthLiteral();
        private static final long serialVersionUID = 1L;

        HealthLiteral() {
        }
    }
}

