/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import io.netty.channel.Channel;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.HttpUpgradeListener;
import io.undertow.server.ListenerRegistry;
import io.undertow.server.handlers.ChannelUpgradeHandler;
import io.undertow.server.handlers.HttpUpgradeHandshake;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyAcceptor;
import org.apache.activemq.artemis.core.remoting.server.RemotingService;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.cluster.ClusterManager;
import org.apache.activemq.artemis.core.server.cluster.ha.HAManager;
import org.jboss.as.remoting.HttpListenerRegistryService;
import org.jboss.as.remoting.SimpleHttpUpgradeHandshake;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.messaging.activemq.ActiveMQActivationService;
import org.wildfly.extension.messaging.activemq.HTTPAcceptorDefinition;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.StreamConnection;
import org.xnio.netty.transport.WrappingXnioSocketChannel;

public class HTTPUpgradeService
implements Service<HTTPUpgradeService> {
    private final String activeMQServerName;
    private final String acceptorName;
    private final String httpListenerName;
    protected InjectedValue<ChannelUpgradeHandler> injectedRegistry = new InjectedValue();
    protected InjectedValue<ListenerRegistry> listenerRegistry = new InjectedValue();
    private HttpUpgradeListener httpUpgradeListener;
    private ListenerRegistry.HttpUpgradeMetadata httpUpgradeMetadata;

    public HTTPUpgradeService(String activeMQServerName, String acceptorName, String httpListenerName) {
        this.activeMQServerName = activeMQServerName;
        this.acceptorName = acceptorName;
        this.httpListenerName = httpListenerName;
    }

    public static void installService(ServiceTarget serviceTarget, String activeMQServerName, String acceptorName, String httpListenerName) {
        HTTPUpgradeService service = new HTTPUpgradeService(activeMQServerName, acceptorName, httpListenerName);
        ServiceBuilder sb = serviceTarget.addService(HTTPAcceptorDefinition.CAPABILITY.getCapabilityServiceName(new String[]{activeMQServerName, "http-upgrade-service", acceptorName}), (Service)service);
        sb.addAliases(new ServiceName[]{MessagingServices.getHttpUpgradeServiceName(activeMQServerName, acceptorName)});
        sb.addDependency(MessagingServices.HTTP_UPGRADE_REGISTRY.append(new String[]{httpListenerName}), ChannelUpgradeHandler.class, service.injectedRegistry);
        sb.addDependency(HttpListenerRegistryService.SERVICE_NAME, ListenerRegistry.class, service.listenerRegistry);
        sb.requires(ActiveMQActivationService.getServiceName(MessagingServices.getActiveMQServiceName(activeMQServerName)));
        sb.setInitialMode(ServiceController.Mode.PASSIVE);
        sb.install();
    }

    public void start(StartContext context) throws StartException {
        ListenerRegistry.Listener listenerInfo = ((ListenerRegistry)this.listenerRegistry.getValue()).getListener(this.httpListenerName);
        assert (listenerInfo != null);
        this.httpUpgradeMetadata = new ListenerRegistry.HttpUpgradeMetadata(this.getProtocol(), "core");
        listenerInfo.addHttpUpgradeMetadata(this.httpUpgradeMetadata);
        MessagingLogger.ROOT_LOGGER.registeredHTTPUpgradeHandler("activemq-remoting", this.acceptorName);
        ServiceController activeMQService = context.getController().getServiceContainer().getService(MessagingServices.getActiveMQServiceName(this.activeMQServerName));
        final ActiveMQServer activeMQServer = (ActiveMQServer)ActiveMQServer.class.cast(activeMQService.getValue());
        this.httpUpgradeListener = HTTPUpgradeService.switchToMessagingProtocol(activeMQServer, this.acceptorName, this.getProtocol());
        ((ChannelUpgradeHandler)this.injectedRegistry.getValue()).addProtocol(this.getProtocol(), this.httpUpgradeListener, (HttpUpgradeHandshake)new SimpleHttpUpgradeHandshake("CF70DEB8-70F9-4FBA-8B4F-DFC3E723B4CD", this.getSecKeyHeader(), this.getSecAcceptHeader()){

            public boolean handleUpgrade(HttpServerExchange exchange) throws IOException {
                if (super.handleUpgrade(exchange)) {
                    ActiveMQServer server = HTTPUpgradeService.selectServer(exchange, activeMQServer);
                    if (server == null) {
                        return false;
                    }
                    RemotingService remotingService = server.getRemotingService();
                    String endpoint = exchange.getRequestHeaders().getFirst(HTTPUpgradeService.this.getHttpUpgradeEndpointKey());
                    if (!server.isActive() || !remotingService.isStarted()) {
                        return false;
                    }
                    if (endpoint == null) {
                        return true;
                    }
                    return HTTPUpgradeService.this.acceptorName.equals(endpoint);
                }
                return false;
            }
        });
    }

    private static ActiveMQServer selectServer(HttpServerExchange exchange, ActiveMQServer rootServer) {
        HAManager haManager;
        String activemqServerName = exchange.getRequestHeaders().getFirst("activemqServerName");
        if (activemqServerName == null) {
            return rootServer;
        }
        ClusterManager clusterManager = rootServer.getClusterManager();
        if (clusterManager != null && (haManager = clusterManager.getHAManager()) != null) {
            for (Map.Entry entry : haManager.getBackupServers().entrySet()) {
                if (!((String)entry.getKey()).equals(activemqServerName)) continue;
                return (ActiveMQServer)entry.getValue();
            }
        }
        if (activemqServerName.equals(rootServer.getConfiguration().getName())) {
            return rootServer;
        }
        return null;
    }

    public void stop(StopContext context) {
        ((ListenerRegistry)this.listenerRegistry.getValue()).getListener(this.httpListenerName).removeHttpUpgradeMetadata(this.httpUpgradeMetadata);
        this.httpUpgradeMetadata = null;
        ((ChannelUpgradeHandler)this.injectedRegistry.getValue()).removeProtocol(this.getProtocol(), this.httpUpgradeListener);
        this.httpUpgradeListener = null;
    }

    public HTTPUpgradeService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    private static HttpUpgradeListener switchToMessagingProtocol(final ActiveMQServer activemqServer, final String acceptorName, final String protocolName) {
        return new HttpUpgradeListener(){

            public void handleUpgrade(StreamConnection streamConnection, final HttpServerExchange exchange) {
                ChannelListener<StreamConnection> listener = new ChannelListener<StreamConnection>(){

                    public void handleEvent(StreamConnection connection) {
                        MessagingLogger.ROOT_LOGGER.debugf("Switching to %s protocol for %s http-acceptor", protocolName, acceptorName);
                        ActiveMQServer server = HTTPUpgradeService.selectServer(exchange, activemqServer);
                        RemotingService remotingService = server.getRemotingService();
                        if (!server.isActive() || !remotingService.isStarted()) {
                            IoUtils.safeClose((Closeable)connection);
                            return;
                        }
                        NettyAcceptor acceptor = (NettyAcceptor)remotingService.getAcceptor(acceptorName);
                        WrappingXnioSocketChannel channel = new WrappingXnioSocketChannel(connection);
                        try {
                            acceptor.transfer((Channel)channel);
                            connection.getSourceChannel().resumeReads();
                        }
                        catch (IllegalStateException e) {
                            IoUtils.safeClose((Closeable)connection);
                        }
                    }
                };
                ChannelListeners.invokeChannelListener((java.nio.channels.Channel)streamConnection, (ChannelListener)listener);
            }
        };
    }

    protected String getProtocol() {
        return "activemq-remoting";
    }

    protected String getSecKeyHeader() {
        return "Sec-ActiveMQRemoting-Key";
    }

    protected String getSecAcceptHeader() {
        return "Sec-ActiveMQRemoting-Accept";
    }

    protected String getHttpUpgradeEndpointKey() {
        return "httpUpgradeEndpoint";
    }

    static class LegacyHttpUpgradeService
    extends HTTPUpgradeService {
        public static void installService(ServiceTarget serviceTarget, String activeMQServerName, String acceptorName, String httpListenerName) {
            LegacyHttpUpgradeService service = new LegacyHttpUpgradeService(activeMQServerName, acceptorName, httpListenerName);
            ServiceBuilder sb = serviceTarget.addService(MessagingServices.getLegacyHttpUpgradeServiceName(activeMQServerName, acceptorName), (Service)service);
            sb.addDependency(MessagingServices.HTTP_UPGRADE_REGISTRY.append(new String[]{httpListenerName}), ChannelUpgradeHandler.class, (Injector)service.injectedRegistry);
            sb.addDependency(HttpListenerRegistryService.SERVICE_NAME, ListenerRegistry.class, (Injector)service.listenerRegistry);
            sb.requires(ActiveMQActivationService.getServiceName(MessagingServices.getActiveMQServiceName(activeMQServerName)));
            sb.setInitialMode(ServiceController.Mode.PASSIVE);
            sb.install();
        }

        private LegacyHttpUpgradeService(String activeMQServerName, String acceptorName, String httpListenerName) {
            super(activeMQServerName, acceptorName, httpListenerName);
        }

        @Override
        protected String getProtocol() {
            return "hornetq-remoting";
        }

        @Override
        protected String getHttpUpgradeEndpointKey() {
            return "http-upgrade-endpoint";
        }

        @Override
        protected String getSecKeyHeader() {
            return "Sec-HornetQRemoting-Key";
        }

        @Override
        protected String getSecAcceptHeader() {
            return "Sec-HornetQRemoting-Accept";
        }
    }
}

