/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class CustomizeColor
extends AbstractAction
implements Layer.LayerAction,
Layer.MultiLayerAction {
    private final transient List<Layer> colorLayers;

    public CustomizeColor(List<Layer> l) {
        super(I18n.tr("Customize Color", new Object[0]));
        new ImageProvider("colorchooser").getResource().attachImageIcon(this, true);
        this.colorLayers = l.stream().filter(Objects::nonNull).filter(Layer::hasColor).collect(Collectors.toList());
        this.putValue("help", HelpUtil.ht("/Action/LayerCustomizeColor"));
    }

    public CustomizeColor(Layer l) {
        this(Collections.singletonList(l));
    }

    @Override
    public boolean supportLayers(List<Layer> layers) {
        return layers.stream().allMatch(Layer::hasColor);
    }

    @Override
    public Component createMenuComponent() {
        return new JMenuItem(this);
    }

    @Override
    public Action getMultiLayerAction(List<Layer> layers) {
        return new CustomizeColor(layers);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Color cl = this.colorLayers.stream().filter(Objects::nonNull).map(Layer::getColor).filter(Objects::nonNull).findAny().orElse(Color.GRAY);
        JColorChooser c = new JColorChooser(cl);
        Object[] options = new Object[]{I18n.tr("OK", new Object[0]), I18n.tr("Cancel", new Object[0]), I18n.tr("Default", new Object[0])};
        int answer = JOptionPane.showOptionDialog(MainApplication.getMainFrame(), c, I18n.tr("Choose a color", new Object[0]), 2, -1, null, options, options[0]);
        switch (answer) {
            case 0: {
                this.colorLayers.stream().forEach(l -> l.setColor(c.getColor()));
                break;
            }
            case 1: {
                return;
            }
            case 2: {
                this.colorLayers.stream().forEach(l -> l.setColor(null));
            }
        }
        LayerListDialog.getInstance().repaint();
    }
}

