/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#include "typedef.h"
#include "gmp.h"
#include "getput.h"
#include "zass.h"
#include "matrix.h"

void convert_cocycle_to_column(matrix_TYP **Y,
                               int number,
                               int dim,
                               int gen_no)
{
   matrix_TYP *A;

   int i,
       j,
       k,
       kgv;


   for (i=0;i<number;i++){

       if (dim != Y[i]->rows || gen_no != Y[i]->cols){
          fprintf(stderr,"error in convert_cocycle_to_column\n");
          exit(3);
       }
       Check_mat(Y[i]);

       A = init_mat(dim*gen_no,1,"i");

       for (j=0;j<Y[i]->rows;j++){
          for (k=0;k<Y[i]->cols;k++){
             A->array.SZ[j+k*dim][0] = Y[i]->array.SZ[j][k];
          }
       }

       kgv = Y[i]->kgv;
       free_mat(Y[i]);
       Y[i] = A;
       Y[i]->kgv  = kgv;
       Check_mat(Y[i]);

   }

   return;

}

