/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.AboutBox;
import com.lightdev.app.shtm.AnchorDialog;
import com.lightdev.app.shtm.AttributeComponent;
import com.lightdev.app.shtm.ColorPanel;
import com.lightdev.app.shtm.DialogShell;
import com.lightdev.app.shtm.DocumentPane;
import com.lightdev.app.shtm.FontDialog;
import com.lightdev.app.shtm.ImageDialog;
import com.lightdev.app.shtm.LinkDialog;
import com.lightdev.app.shtm.ListDialog;
import com.lightdev.app.shtm.ParaStyleDialog;
import com.lightdev.app.shtm.PrefsDialog;
import com.lightdev.app.shtm.SHTMLAction;
import com.lightdev.app.shtm.SHTMLDocument;
import com.lightdev.app.shtm.SHTMLEditorPane;
import com.lightdev.app.shtm.SHTMLPanelImpl;
import com.lightdev.app.shtm.SHTMLPanelMultipleDocImpl;
import com.lightdev.app.shtm.StyleSelector;
import com.lightdev.app.shtm.TableDialog;
import com.lightdev.app.shtm.Util;
import com.sun.demo.ElementTreePanel;
import com.sun.demo.ExampleFileFilter;
import de.calcom.cclib.text.FindReplaceDialog;
import de.calcom.cclib.text.FindReplaceEvent;
import de.calcom.cclib.text.FindReplaceListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.undo.CannotRedoException;

class SHTMLEditorKitActions {
    SHTMLEditorKitActions() {
    }

    static class SetDefaultStyleRefAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public SetDefaultStyleRefAction(SHTMLPanelImpl panel) {
            super("setDefaultStyleRef");
            this.panel = panel;
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ae) {
            this.panel.getSHTMLDocument().insertStyleRef();
            this.panel.updateActions();
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            if (this.panel.getSHTMLEditorPane() != null && !this.panel.getSHTMLDocument().hasStyleRef()) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class SHTMLHelpAppInfoAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public SHTMLHelpAppInfoAction(SHTMLPanelImpl panel) {
            super("about");
            this.panel = panel;
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ae) {
            Frame parent = JOptionPane.getFrameForComponent(this.panel);
            AboutBox dlg = new AboutBox(parent);
            Util.center(parent, dlg);
            dlg.setModal(true);
            dlg.setVisible(true);
            this.panel.repaint();
            this.panel.updateActions();
        }

        public void update() {
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class SHTMLTestAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public SHTMLTestAction(SHTMLPanelImpl panel) {
            super("test");
            this.panel = panel;
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ae) {
            this.panel.getSHTMLEditorPane().insertBreak();
        }

        public void update() {
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class SHTMLFileSaveAsAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelMultipleDocImpl panel;

        public SHTMLFileSaveAsAction(SHTMLPanelMultipleDocImpl panel) {
            super("saveAs");
            this.panel = panel;
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ae) {
            String fName;
            URL sourceUrl;
            boolean canSave = true;
            Preferences prefs = Preferences.userNodeForPackage(this.panel.getClass());
            JFileChooser chooser = new JFileChooser();
            ExampleFileFilter filter = new ExampleFileFilter();
            filter.addExtension("htm");
            filter.addExtension("html");
            filter.setDescription(Util.getResourceString("htmlFileDesc"));
            chooser.setFileFilter(filter);
            String lastSaveFileName = prefs.get("lastSaveFileName", "");
            if (lastSaveFileName.length() > 0) {
                chooser.setCurrentDirectory(new File(lastSaveFileName).getParentFile());
            }
            if ((sourceUrl = this.panel.getDocumentPane().getSource()) != null) {
                fName = sourceUrl.getFile();
            } else {
                fName = this.panel.getDocumentPane().getDocumentName();
                fName = Util.removeChar(fName, ' ');
            }
            if (fName.indexOf(".") < 0) {
                chooser.setSelectedFile(new File(fName + ".htm"));
            } else {
                chooser.setSelectedFile(new File(fName));
            }
            int result = chooser.showSaveDialog((Component)ae.getSource());
            if (result == 0) {
                File selection = chooser.getSelectedFile();
                prefs.put("lastSaveFileName", selection.getAbsolutePath());
                if (selection.exists()) {
                    String newName = selection.getName();
                    canSave = Util.msg(0, "confirmSaveAs", "fileExistsQuery", newName, " ");
                }
                if (canSave) {
                    try {
                        NewFileSaver saver = new NewFileSaver(this.panel.getDocumentPane(), selection.toURI().toURL(), this.panel.getActiveTabNo());
                        saver.setName("NewFileSaver");
                        saver.start();
                    }
                    catch (Exception ex) {
                        Util.errMsg((Component)ae.getSource(), Util.getResourceString("cantCreateURLError") + selection.getAbsolutePath(), ex);
                    }
                }
            }
            this.panel.updateActions();
        }

        public NewFileSaver createNewFileSaver(URL url) {
            return new NewFileSaver(this.panel.getDocumentPane(), url, this.panel.getActiveTabNo());
        }

        public NewFileSaver createNewFileSaver(URL url, DocumentPane.DocumentPaneListener listener) {
            return new NewFileSaver(this.panel.getDocumentPane(), url, this.panel.getActiveTabNo(), listener);
        }

        public void update() {
            boolean isEnabled = this.panel.getSHTMLEditorPane() != null;
            boolean saveInProgress = false;
            if (isEnabled) {
                saveInProgress = this.panel.getDocumentPane().saveInProgress();
            }
            this.setEnabled(isEnabled && !saveInProgress);
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }

        class NewFileSaver
        extends Thread {
            DocumentPane dp;
            URL url;
            int activeTabNo;
            DocumentPane.DocumentPaneListener l;

            NewFileSaver(DocumentPane dp, URL url, int activeTabNo) {
                this.dp = dp;
                this.url = url;
                this.activeTabNo = activeTabNo;
            }

            NewFileSaver(DocumentPane dp, URL url, int activeTabNo, DocumentPane.DocumentPaneListener listener) {
                this(dp, url, activeTabNo);
                this.l = listener;
            }

            public void run() {
                this.dp.setSource(this.url);
                SHTMLFileSaveAsAction.this.panel.doSave(this.dp);
                if (this.dp.saveSuccessful) {
                    SHTMLFileSaveAsAction.this.panel.getTabbedPaneForDocuments().setTitleAt(SHTMLFileSaveAsAction.this.panel.getTabbedPaneForDocuments().indexOfComponent(this.dp), this.dp.getDocumentName());
                    if (this.l != null) {
                        this.dp.addDocumentPaneListener(this.l);
                    }
                }
            }
        }
    }

    static class SHTMLFileSaveAllAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelMultipleDocImpl panel;

        public SHTMLFileSaveAllAction(SHTMLPanelMultipleDocImpl panel) {
            super("saveAll");
            this.panel = panel;
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ae) {
            int count = this.panel.getTabbedPaneForDocuments().getTabCount();
            for (int i = 0; i < count; ++i) {
                this.panel.getTabbedPaneForDocuments().setSelectedIndex(i);
                this.panel.setDocumentPane((DocumentPane)this.panel.getTabbedPaneForDocuments().getSelectedComponent());
                if (!this.panel.getDocumentPane().needsSaving()) continue;
                this.panel.dynRes.getAction("save").actionPerformed(ae);
            }
            this.panel.updateActions();
        }

        public void update() {
            if (this.panel.getSHTMLEditorPane() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class SHTMLFileSaveAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public SHTMLFileSaveAction(SHTMLPanelImpl panel) {
            super("save");
            this.panel = panel;
            this.getProperties();
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 2));
        }

        public void actionPerformed(ActionEvent ae) {
            if (!this.panel.getDocumentPane().isNewDoc()) {
                FileSaver saver = new FileSaver(this.panel.getDocumentPane());
                saver.setName("FileSaver");
                saver.start();
            } else {
                this.panel.dynRes.getAction("saveAs").actionPerformed(ae);
            }
            this.panel.updateActions();
        }

        public void update() {
            boolean isEnabled = this.panel.getSHTMLEditorPane() != null;
            boolean saveInProgress = false;
            boolean needsSaving = false;
            if (isEnabled) {
                saveInProgress = this.panel.getDocumentPane().saveInProgress();
                needsSaving = this.panel.getDocumentPane().needsSaving();
            }
            this.setEnabled(isEnabled && needsSaving && !saveInProgress);
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }

        class FileSaver
        extends Thread {
            DocumentPane dp;
            Component owner;

            FileSaver(DocumentPane dp) {
                this.setPriority(1);
                this.dp = dp;
            }

            public void run() {
                SHTMLFileSaveAction.this.panel.doSave(this.dp);
            }
        }
    }

    static class SHTMLFileOpenAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelMultipleDocImpl panel;

        public SHTMLFileOpenAction(SHTMLPanelMultipleDocImpl panel) {
            super("open");
            this.panel = panel;
            this.getProperties();
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, 2));
        }

        public void actionPerformed(ActionEvent ae) {
            int returnVal;
            Preferences prefs = Preferences.userNodeForPackage(this.panel.getClass());
            JFileChooser chooser = new JFileChooser();
            ExampleFileFilter filter = new ExampleFileFilter();
            filter.addExtension("htm");
            filter.addExtension("html");
            filter.setDescription(Util.getResourceString("htmlFileDesc"));
            chooser.setFileFilter(filter);
            String lastFileName = prefs.get("lastOpenFileName", "");
            if (lastFileName.length() > 0) {
                chooser.setCurrentDirectory(new File(lastFileName).getParentFile());
            }
            if ((returnVal = chooser.showOpenDialog((Component)ae.getSource())) == 0) {
                File file = chooser.getSelectedFile();
                prefs.put("lastOpenFileName", file.getAbsolutePath());
                this.openDocument(file);
            }
            this.panel.updateActions();
        }

        public void openDocument(File file) {
            this.openDocument(file, null);
        }

        public void openDocument(File file, DocumentPane.DocumentPaneListener listener) {
            int openDocNo = -1;
            try {
                openDocNo = this.getOpenDocument(file.toURI().toURL().toString());
            }
            catch (MalformedURLException mue) {
                // empty catch block
            }
            if (openDocNo > -1) {
                this.panel.getTabbedPaneForDocuments().setSelectedIndex(openDocNo);
            } else {
                FileLoader loader = new FileLoader(file, null, listener);
                loader.start();
            }
        }

        public int getOpenDocument(String url) {
            int tabNo = -1;
            int openDocCount = this.panel.getTabbedPaneForDocuments().getTabCount();
            for (int i = 0; i < openDocCount && tabNo < 0; ++i) {
                URL source = ((DocumentPane)this.panel.getTabbedPaneForDocuments().getComponentAt(i)).getSource();
                if (source == null || !source.toString().equalsIgnoreCase(url)) continue;
                tabNo = i;
            }
            return tabNo;
        }

        public FileLoader createFileLoader(URL url) {
            return new FileLoader(new File(url.getFile()), null);
        }

        public void update() {
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }

        class FileLoader
        extends Thread {
            File file;
            Component owner;
            DocumentPane.DocumentPaneListener l;

            public FileLoader(File file, Component owner) {
                this.file = file;
                this.owner = owner;
            }

            public FileLoader(File file, Component owner, DocumentPane.DocumentPaneListener listener) {
                this(file, owner);
                this.l = listener;
            }

            public void run() {
                try {
                    JOptionPane.getFrameForComponent(SHTMLFileOpenAction.this.panel);
                    SHTMLFileOpenAction.this.panel.setDocumentPane(new DocumentPane(this.file.toURI().toURL(), 0));
                    if (this.l != null) {
                        SHTMLFileOpenAction.this.panel.getDocumentPane().addDocumentPaneListener(this.l);
                    }
                    SHTMLFileOpenAction.this.panel.getTabbedPaneForDocuments().setSelectedComponent(SHTMLFileOpenAction.this.panel.getTabbedPaneForDocuments().add(SHTMLFileOpenAction.this.panel.getDocumentPane().getDocumentName(), SHTMLFileOpenAction.this.panel.getDocumentPane()));
                    SHTMLFileOpenAction.this.panel.registerDocument();
                }
                catch (Exception e) {
                    Util.errMsg(this.owner, Util.getResourceString("unableToOpenFileError"), e);
                }
            }
        }
    }

    static class SHTMLFileNewAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelMultipleDocImpl panel;

        public SHTMLFileNewAction(SHTMLPanelMultipleDocImpl panel) {
            super("new");
            this.panel = panel;
            this.getProperties();
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, 2));
        }

        public void actionPerformed(ActionEvent ae) {
            this.panel.createNewDocumentPane();
            this.panel.getTabbedPaneForDocuments().setSelectedComponent(this.panel.getTabbedPaneForDocuments().add(this.panel.getDocumentPane().getDocumentName(), this.panel.getDocumentPane()));
            this.panel.registerDocument();
            this.panel.updateActions();
        }

        public void update() {
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class SHTMLFileExitAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelMultipleDocImpl panel;

        public SHTMLFileExitAction(SHTMLPanelMultipleDocImpl panel) {
            super("exit");
            this.panel = panel;
            this.getProperties();
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(81, 2));
        }

        public void actionPerformed(ActionEvent ae) {
            this.saveRelevantPrefs();
            new SHTMLFileCloseAllAction(this.panel).actionPerformed(ae);
            if (this.panel.getTabbedPaneForDocuments().getTabCount() == 0) {
                System.exit(0);
            }
            this.panel.updateActions();
        }

        public void saveRelevantPrefs() {
            this.panel.savePrefs();
        }

        public void update() {
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class SHTMLFileCloseAllAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelMultipleDocImpl panel;

        public SHTMLFileCloseAllAction(SHTMLPanelMultipleDocImpl panel) {
            super("closeAll");
            this.panel = panel;
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ae) {
            SHTMLFileCloseAction a = (SHTMLFileCloseAction)this.panel.dynRes.getAction("close");
            for (int i = this.panel.getTabbedPaneForDocuments().getTabCount(); i > 0; --i) {
                a.closeDocument(i - 1, ae, false);
            }
            this.panel.updateActions();
        }

        public void update() {
            if (this.panel.getSHTMLEditorPane() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class SHTMLFileCloseAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelMultipleDocImpl panel;
        private boolean exitApp = false;

        public SHTMLFileCloseAction(SHTMLPanelMultipleDocImpl panel) {
            super("close");
            this.panel = panel;
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ae) {
            if (this.panel.getSHTMLEditorPane() != null) {
                this.closeDocument(this.panel.getActiveTabNo(), ae, false);
            }
            this.panel.updateActions();
        }

        public void closeDocument(int index, ActionEvent ae, boolean ignoreChanges) {
            this.exitApp = ae.getActionCommand().indexOf("exit") > -1;
            DocumentPane dp = (DocumentPane)this.panel.getTabbedPaneForDocuments().getComponentAt(index);
            if (!dp.saveInProgress()) {
                if (ignoreChanges) {
                    this.closeDoc(dp);
                } else if (dp.needsSaving()) {
                    this.panel.selectTabbedPane(index);
                    String docName = dp.getDocumentName();
                    int choice = Util.msgChoice(1, "confirmClosing", "saveChangesQuery", docName, "\r\n\r\n");
                    switch (choice) {
                        case 0: {
                            if (dp.isNewDoc()) {
                                this.panel.dynRes.getAction("saveAs").actionPerformed(ae);
                            } else {
                                this.panel.dynRes.getAction("save").actionPerformed(ae);
                            }
                            this.scheduleClose(dp);
                            break;
                        }
                        case 1: {
                            this.closeDoc(dp);
                            break;
                        }
                    }
                } else {
                    this.closeDoc(dp);
                }
            } else {
                this.scheduleClose(dp);
            }
        }

        private void scheduleClose(final DocumentPane dp) {
            final Timer timer = new Timer();
            TimerTask task = new TimerTask(){

                public void run() {
                    if (!dp.saveInProgress() && dp.saveSuccessful) {
                        SHTMLFileCloseAction.this.closeDoc(dp);
                        this.cancel();
                        timer.cancel();
                    }
                }
            };
            timer.schedule(task, 0L, 400L);
        }

        private void closeDoc(DocumentPane dp) {
            try {
                dp.deleteTempDir();
                this.panel.unregisterDocument();
                this.panel.getTabbedPaneForDocuments().remove(dp);
            }
            catch (IndexOutOfBoundsException e) {
                this.catchCloseErr(dp);
            }
            if (this.exitApp && this.panel.getTabbedPaneForDocuments().getTabCount() == 0) {
                System.exit(0);
            }
        }

        private void catchCloseErr(DocumentPane dp) {
            try {
                int i = this.panel.getTabbedPaneForDocuments().indexOfComponent(dp);
                if (i < 0 && this.panel.getSHTMLEditorPane() != null) {
                    this.panel.setActiveTabNo(this.panel.getTabbedPaneForDocuments().getSelectedIndex());
                    dp = (DocumentPane)this.panel.getTabbedPaneForDocuments().getComponentAt(this.panel.getActiveTabNo());
                    i = this.panel.getTabbedPaneForDocuments().indexOfComponent(dp);
                    this.panel.unregisterDocument();
                    this.panel.getTabbedPaneForDocuments().remove(i);
                } else {
                    while (i > 0 && i > this.panel.getTabbedPaneForDocuments().getTabCount()) {
                        i = this.panel.getTabbedPaneForDocuments().indexOfComponent(dp);
                    }
                    this.panel.unregisterDocument();
                    this.panel.getTabbedPaneForDocuments().remove(i);
                }
            }
            catch (IndexOutOfBoundsException e) {
                this.catchCloseErr(dp);
            }
        }

        public void update() {
            if (this.panel.getSHTMLEditorPane() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class SHTMLEditSelectAllAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public SHTMLEditSelectAllAction(SHTMLPanelImpl panel) {
            this.panel = panel;
            this.putValue("Name", "selectAll");
            this.getProperties();
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, 2));
        }

        public void actionPerformed(ActionEvent ae) {
            if (this.panel.isHtmlEditorActive()) {
                this.panel.getDocumentPane().getHtmlEditor().selectAll();
            } else {
                this.panel.getSHTMLEditorPane().selectAll();
                this.panel.updateActions();
            }
        }

        public void update() {
            if (this.panel.getSHTMLEditorPane() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class SHTMLEditPrefsAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public SHTMLEditPrefsAction(SHTMLPanelImpl panel) {
            this.panel = panel;
            this.putValue("Name", "editPrefs");
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ae) {
            Frame parent = JOptionPane.getFrameForComponent(this.panel);
            PrefsDialog dlg = new PrefsDialog(parent, Util.getResourceString("prefsDialogTitle"));
            dlg.addPrefChangeListener(this.panel);
            Util.center(parent, dlg);
            dlg.setModal(true);
            dlg.setVisible(true);
            if (dlg.getResult() == DialogShell.RESULT_OK) {
                // empty if block
            }
            this.panel.updateActions();
            dlg.removePrefChangeListener(this.panel);
        }

        public void update() {
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class SHTMLEditPasteOtherAction
    extends DefaultEditorKit.PasteAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public SHTMLEditPasteOtherAction(SHTMLPanelImpl panel) {
            this.panel = panel;
            this.updateActionName(SHTMLEditorPane.PasteMode.getValueFromPrefs().invert());
        }

        public void updateActionName(SHTMLEditorPane.PasteMode pm) {
            if (pm == SHTMLEditorPane.PasteMode.PASTE_HTML) {
                this.putValue("Name", Util.getResourceString("pasteHTMLLabel"));
            } else if (pm == SHTMLEditorPane.PasteMode.PASTE_PLAIN_TEXT) {
                this.putValue("Name", Util.getResourceString("pastePlainTextLabel"));
            } else {
                throw new RuntimeException("Unknown SHTMLEditorPane.PasteMode: " + pm.toString());
            }
            this.getProperties();
            this.panel.updateActions();
        }

        public void actionPerformed(ActionEvent e) {
            SHTMLEditorPane.PasteMode pm = this.panel.getSHTMLEditorPane().getPasteMode().invert();
            this.panel.getSHTMLEditorPane().setPasteMode(pm);
            super.actionPerformed(e);
            this.panel.updateActions();
            this.panel.getSHTMLEditorPane().setPasteModeFromPrefs();
        }

        public void update() {
            if (this.panel.getSHTMLEditorPane() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, "pasteOther");
        }
    }

    static class SHTMLEditPasteAction
    extends DefaultEditorKit.PasteAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public SHTMLEditPasteAction(SHTMLPanelImpl panel) {
            this.panel = panel;
            this.putValue("Name", "paste");
            this.getProperties();
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, 2));
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            this.panel.updateActions();
        }

        public void update() {
            if (this.panel.getSHTMLEditorPane() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class SHTMLEditCutAction
    extends DefaultEditorKit.CutAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public SHTMLEditCutAction(SHTMLPanelImpl panel) {
            this.panel = panel;
            this.putValue("Name", "cut");
            this.getProperties();
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, 2));
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            this.panel.updateActions();
        }

        public void update() {
            if (this.panel.getSHTMLEditorPane() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class SHTMLEditCopyAction
    extends DefaultEditorKit.CopyAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public SHTMLEditCopyAction(SHTMLPanelImpl panel) {
            this.panel = panel;
            this.putValue("Name", "copy");
            this.getProperties();
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, 2));
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            this.panel.updateActions();
        }

        public void update() {
            if (this.panel.getSHTMLEditorPane() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class RedoAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public RedoAction(SHTMLPanelImpl panel) {
            super("redo");
            this.panel = panel;
            this.setEnabled(false);
            this.getProperties();
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(89, 2));
        }

        public void actionPerformed(ActionEvent e) {
            if (this.panel.getCurrentDocumentPane().getSelectedTab() != 0) {
                return;
            }
            try {
                this.panel.getUndo().redo();
                this.panel.getSHTMLEditorPane();
            }
            catch (CannotRedoException ex) {
                Util.errMsg((Component)e.getSource(), Util.getResourceString("unableToRedoError") + ex, ex);
            }
            this.panel.updateActions();
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(this.panel.getUndo().canRedo());
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class PrintAction
    extends AbstractAction
    implements SHTMLAction {
        private static Method printMethod;
        private final SHTMLPanelImpl panel;

        static boolean canPrint() {
            return printMethod != null;
        }

        public PrintAction(SHTMLPanelImpl panel) {
            super("print");
            this.getProperties();
            this.panel = panel;
        }

        public void actionPerformed(ActionEvent e) {
            if (PrintAction.canPrint()) {
                try {
                    printMethod.invoke((Object)this.panel.getEditorPane(), new Object[0]);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                JOptionPane.showMessageDialog(this.panel, Util.getResourceString("printing_not_supported"));
                this.setEnabled(false);
            }
        }

        public void update() {
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }

        static {
            Method printMethod = null;
            try {
                printMethod = JTextComponent.class.getMethod("print", new Class[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            PrintAction.printMethod = printMethod;
        }
    }

    static class PrevTableCellAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public PrevTableCellAction(SHTMLPanelImpl panel) {
            super("prevTableCell");
            this.panel = panel;
            this.getProperties();
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(9, 1));
        }

        public void actionPerformed(ActionEvent ae) {
            Element cell = this.panel.getSHTMLEditorPane().getCurrentTableCell();
            if (cell != null) {
                this.panel.getSHTMLEditorPane().goPrevCell(cell);
                this.panel.updateActions();
            }
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            if (this.panel.getSHTMLEditorPane() != null && this.panel.getSHTMLEditorPane().getCurrentTableCell() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class NextTableCellAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public NextTableCellAction(SHTMLPanelImpl panel) {
            super("nextTableCell");
            this.panel = panel;
            this.getProperties();
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(9, 0));
        }

        public void actionPerformed(ActionEvent ae) {
            Element cell = this.panel.getSHTMLEditorPane().getCurrentTableCell();
            if (cell != null) {
                this.panel.getSHTMLEditorPane().goNextCell(cell);
                this.panel.updateActions();
            }
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            if (this.panel.getSHTMLEditorPane() != null && this.panel.getSHTMLEditorPane().getCurrentTableCell() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class ItalicAction
    extends StyledEditorKit.ItalicAction
    implements SHTMLAction,
    AttributeComponent {
        private final SHTMLPanelImpl panel;

        public ItalicAction(SHTMLPanelImpl panel) {
            this.panel = panel;
            this.putValue("Name", "fontItalic");
            this.putValue("selected", "false");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(73, 2));
            SHTMLPanelImpl.getActionProperties(this, "fontItalic");
        }

        public void actionPerformed(ActionEvent e) {
            SHTMLDocument doc;
            super.actionPerformed(e);
            if (this.panel.getSHTMLEditorPane() != null && (doc = (SHTMLDocument)this.panel.getSHTMLEditorPane().getDocument()) != null) {
                AttributeSet a = doc.getCharacterElement(this.panel.getSHTMLEditorPane().getSelectionStart()).getAttributes();
                boolean isItalic = StyleConstants.isItalic(a);
                if (isItalic) {
                    this.putValue("selected", "true");
                } else {
                    this.putValue("selected", "false");
                }
            }
            this.panel.updateActions();
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, "fontItalic");
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            if (this.panel.getSHTMLEditorPane() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public boolean setValue(AttributeSet a) {
            Object value;
            boolean success = false;
            boolean isItalic = StyleConstants.isItalic(a);
            if (a.isDefined(CSS.Attribute.FONT_STYLE) && (value = a.getAttribute(CSS.Attribute.FONT_STYLE)).toString().equalsIgnoreCase(StyleConstants.Italic.toString())) {
                isItalic = true;
            }
            if (isItalic) {
                this.putValue("selected", "true");
            } else {
                this.putValue("selected", "false");
            }
            success = true;
            return success;
        }

        public AttributeSet getValue() {
            SimpleAttributeSet set = new SimpleAttributeSet();
            if (this.getValue("selected").toString().equals("true")) {
                Util.styleSheet().addCSSAttribute(set, CSS.Attribute.FONT_STYLE, "normal".toString());
            } else {
                Util.styleSheet().addCSSAttribute(set, CSS.Attribute.FONT_STYLE, StyleConstants.Italic.toString());
            }
            return set;
        }

        public AttributeSet getValue(boolean includeUnchanged) {
            return this.getValue();
        }
    }

    static class ToggleTableHeaderCellAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public ToggleTableHeaderCellAction(SHTMLPanelImpl panel) {
            this.panel = panel;
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ae) {
            this.panel.getSHTMLEditorPane().toggleTableHeaderCell();
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            if (this.panel.getSHTMLEditorPane() != null && this.panel.getSHTMLEditorPane().getCurrentTableCell() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class MoveTableColumnRightAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public MoveTableColumnRightAction(SHTMLPanelImpl panel) {
            super("moveTableColumnRight");
            this.panel = panel;
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ae) {
            this.panel.getSHTMLEditorPane().moveTableColumnRight();
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            if (this.panel.getSHTMLEditorPane() != null && this.panel.getSHTMLEditorPane().getCurrentTableCell() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class MoveTableColumnLeftAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public MoveTableColumnLeftAction(SHTMLPanelImpl panel) {
            super("moveTableColumnLeft");
            this.panel = panel;
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ae) {
            this.panel.getSHTMLEditorPane().moveTableColumnLeft();
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            if (this.panel.getSHTMLEditorPane() != null && this.panel.getSHTMLEditorPane().getCurrentTableCell() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class MoveTableRowDownAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public MoveTableRowDownAction(SHTMLPanelImpl panel) {
            super("moveTableRowUp");
            this.panel = panel;
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ae) {
            this.panel.getSHTMLEditorPane().moveTableRowDown();
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            if (this.panel.getSHTMLEditorPane() != null && this.panel.getSHTMLEditorPane().getCurrentTableCell() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class MoveTableRowUpAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public MoveTableRowUpAction(SHTMLPanelImpl panel) {
            super("moveTableRowUp");
            this.panel = panel;
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ae) {
            this.panel.getSHTMLEditorPane().moveTableRowUp();
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            if (this.panel.getSHTMLEditorPane() != null && this.panel.getSHTMLEditorPane().getCurrentTableCell() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class InsertTableRowAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;
        private final String forcedCellName;

        public InsertTableRowAction(SHTMLPanelImpl panel, String forcedCellName, String titleID) {
            super(titleID);
            this.panel = panel;
            this.forcedCellName = forcedCellName;
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ae) {
            this.panel.getSHTMLEditorPane().insertTableRow(this.forcedCellName);
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            if (this.panel.getSHTMLEditorPane() != null && this.panel.getSHTMLEditorPane().getCurrentTableCell() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class InsertTableColAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public InsertTableColAction(SHTMLPanelImpl panel) {
            super("insertTableCol");
            this.panel = panel;
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ae) {
            this.panel.getSHTMLEditorPane().insertTableColumn();
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            if (this.panel.getSHTMLEditorPane() != null && this.panel.getSHTMLEditorPane().getCurrentTableCell() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class InsertTableAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public InsertTableAction(SHTMLPanelImpl panel) {
            super("insertTable");
            this.panel = panel;
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ae) {
            Frame parent = JOptionPane.getFrameForComponent(this.panel);
            Object input = null;
            boolean showPopup = Util.preferenceIsTrue("table.popupBeforeInserting", "true");
            if (showPopup) {
                input = Util.nameInput(parent, "3", "\\d+", "insertTableTitle", "insertTableMsg");
            }
            if (input != null || !showPopup) {
                int choice;
                int n = choice = input != null ? Integer.parseInt(input.toString()) : 3;
                if (choice > 0) {
                    this.panel.getSHTMLEditorPane().insertNewTable(choice);
                }
            }
            this.panel.updateActions();
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            if (this.panel.getSHTMLEditorPane() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class InsertImageAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public InsertImageAction(SHTMLPanelImpl panel) {
            this.panel = panel;
            this.putValue("Name", "insertImage");
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ae) {
            Frame parent = JOptionPane.getFrameForComponent(this.panel);
            ImageDialog dlg = new ImageDialog(parent, Util.getResourceString("imageDialogTitle"), this.panel.getDocumentPane().getImageDir());
            Util.center(parent, dlg);
            dlg.setModal(true);
            dlg.setVisible(true);
            if (dlg.getResult() == DialogShell.RESULT_OK) {
                try {
                    this.panel.getSHTMLDocument().insertBeforeStart(this.panel.getSHTMLDocument().getCharacterElement(this.panel.getSHTMLEditorPane().getSelectionEnd()), dlg.getImageHTML());
                }
                catch (Exception e) {
                    Util.errMsg(null, e.getMessage(), e);
                }
            }
            this.panel.updateActions();
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            if (this.panel.getSHTMLEditorPane() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class GarbageCollectionAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public GarbageCollectionAction(SHTMLPanelImpl panel) {
            super("gc");
            this.panel = panel;
            this.getProperties();
        }

        public void actionPerformed(ActionEvent e) {
            System.gc();
            this.panel.updateActions();
        }

        public void update() {
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class FormatTableAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public FormatTableAction(SHTMLPanelImpl panel) {
            super("formatTable");
            this.panel = panel;
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ae) {
            Frame parent = JOptionPane.getFrameForComponent(this.panel);
            SHTMLEditorPane editor = this.panel.getSHTMLEditorPane();
            editor.requestFocus();
            editor.getSelectionStart();
            TableDialog td = new TableDialog(parent, Util.getResourceString("tableDialogTitle"));
            td.setTableAttributes(this.panel.getMaxAttributes(editor, HTML.Tag.TABLE.toString()));
            td.setCellAttributes(this.panel.getMaxAttributes(editor, HTML.Tag.TD.toString()));
            Util.center(parent, td);
            td.setModal(true);
            td.setVisible(true);
            if (td.getResult() == DialogShell.RESULT_OK) {
                SHTMLDocument doc = (SHTMLDocument)editor.getDocument();
                doc.startCompoundEdit();
                AttributeSet a = td.getTableAttributes();
                if (a.getAttributeCount() > 0) {
                    editor.applyTableAttributes(a);
                }
                if ((a = td.getCellAttributes()).getAttributeCount() > 0) {
                    editor.applyCellAttributes(a, td.getCellRange());
                }
                doc.endCompoundEdit();
            }
            this.panel.updateActions();
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            if (this.panel.getSHTMLEditorPane() != null && this.panel.getSHTMLEditorPane().getCurrentTableCell() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class FormatParaAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public FormatParaAction(SHTMLPanelImpl panel) {
            super("formatPara");
            this.panel = panel;
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ae) {
            Frame parent = JOptionPane.getFrameForComponent(this.panel);
            ParaStyleDialog dlg = new ParaStyleDialog(parent, Util.getResourceString("paraStyleDialogTitle"));
            Util.center(parent, dlg);
            dlg.setModal(true);
            int caretPosition = this.panel.getSHTMLEditorPane().getCaretPosition();
            dlg.setValue(this.panel.getMaxAttributes(caretPosition));
            dlg.setVisible(true);
            if (dlg.getResult() == DialogShell.RESULT_OK) {
                this.panel.getSHTMLEditorPane().applyAttributes(dlg.getValue(), true);
            }
            this.panel.updateActions();
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            if (this.panel.getSHTMLEditorPane() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class FormatListAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public FormatListAction(SHTMLPanelImpl panel) {
            super("formatList");
            this.panel = panel;
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ae) {
            Frame parent = JOptionPane.getFrameForComponent(this.panel);
            this.panel.getSHTMLEditorPane().requestFocus();
            this.panel.getSHTMLEditorPane().getSelectionStart();
            ListDialog dlg = new ListDialog(parent, Util.getResourceString("listDialogTitle"));
            SimpleAttributeSet set = new SimpleAttributeSet(this.panel.getMaxAttributes(this.panel.getSHTMLEditorPane(), HTML.Tag.UL.toString()));
            set.addAttributes(this.panel.getMaxAttributes(this.panel.getSHTMLEditorPane(), HTML.Tag.OL.toString()));
            dlg.setListAttributes(set);
            String currentTag = dlg.getListTag();
            Util.center(parent, dlg);
            dlg.setModal(true);
            dlg.setVisible(true);
            if (dlg.getResult() == DialogShell.RESULT_OK) {
                AttributeSet a = dlg.getListAttributes();
                String newTag = dlg.getListTag();
                if (newTag == null) {
                    this.panel.getSHTMLEditorPane().toggleList(newTag, a, true);
                } else if (newTag.equalsIgnoreCase(currentTag)) {
                    if (a.getAttributeCount() > 0) {
                        this.panel.getSHTMLEditorPane().applyListAttributes(a);
                    }
                } else {
                    this.panel.getSHTMLEditorPane().toggleList(newTag, a, false);
                }
            }
            this.panel.updateActions();
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            if (this.panel.getSHTMLEditorPane() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class FormatImageAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public FormatImageAction(SHTMLPanelImpl panel) {
            this.panel = panel;
            this.putValue("Name", "formatImage");
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ae) {
            Frame parent = JOptionPane.getFrameForComponent(this.panel);
            ImageDialog dlg = new ImageDialog(parent, Util.getResourceString("imageDialogTitle"), this.panel.getDocumentPane().getImageDir(), (SHTMLDocument)this.panel.getDocumentPane().getDocument());
            Element img = this.panel.getSHTMLDocument().getCharacterElement(this.panel.getSHTMLEditorPane().getCaretPosition());
            if (img.getName().equalsIgnoreCase(HTML.Tag.IMG.toString())) {
                Util.center(parent, dlg);
                dlg.setImageAttributes(img.getAttributes());
                dlg.setModal(true);
                dlg.setVisible(true);
                if (dlg.getResult() == DialogShell.RESULT_OK) {
                    try {
                        this.panel.getSHTMLDocument().setOuterHTML(img, dlg.getImageHTML());
                    }
                    catch (Exception e) {
                        Util.errMsg(null, e.getMessage(), e);
                    }
                }
                this.panel.updateActions();
            }
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            if (this.panel.getSHTMLEditorPane() != null) {
                Element img = this.panel.getSHTMLDocument().getCharacterElement(this.panel.getSHTMLEditorPane().getCaretPosition());
                if (img.getName().equalsIgnoreCase(HTML.Tag.IMG.toString())) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class FontSizeAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public FontSizeAction(SHTMLPanelImpl panel) {
            super("fontSize");
            this.panel = panel;
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ae) {
            SHTMLPanelImpl.FontSizePicker fsp = (SHTMLPanelImpl.FontSizePicker)ae.getSource();
            if (!fsp.ignore()) {
                this.panel.getSHTMLEditorPane().applyAttributes(fsp.getValue(), false);
            }
            this.panel.updateActions();
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            if (this.panel.getSHTMLEditorPane() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class FontFamilyAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public FontFamilyAction(SHTMLPanelImpl panel) {
            super("fontFamily");
            this.panel = panel;
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ae) {
            SHTMLPanelImpl.FontFamilyPicker ffp = (SHTMLPanelImpl.FontFamilyPicker)ae.getSource();
            if (!ffp.ignore()) {
                this.panel.getSHTMLEditorPane().applyAttributes(ffp.getValue(), false);
            }
            this.panel.updateActions();
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(this.panel.getSHTMLEditorPane() != null);
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class FontAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public FontAction(SHTMLPanelImpl panel) {
            super("font");
            this.panel = panel;
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ae) {
            Frame parent = JOptionPane.getFrameForComponent(this.panel);
            this.panel.getSHTMLEditorPane().requestFocus();
            FontDialog fd = new FontDialog(parent, Util.getResourceString("fontDialogTitle"), this.panel.getMaxAttributes(this.panel.getSHTMLEditorPane(), null));
            Util.center(parent, fd);
            fd.setModal(true);
            fd.setVisible(true);
            if (fd.getResult() == FontDialog.RESULT_OK) {
                this.panel.getSHTMLEditorPane().applyAttributes(fd.getAttributes(), false);
                this.panel.updateFormatControls();
            }
            this.panel.updateActions();
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            if (this.panel.getSHTMLEditorPane() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class SingleDocFindReplaceAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;
        private int caretPos;
        private DocumentPane currentDocumentPane;

        public SingleDocFindReplaceAction(SHTMLPanelImpl panel) {
            super("findReplace");
            this.panel = panel;
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, 2));
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ae) {
            this.currentDocumentPane = this.panel.getDocumentPane();
            if (this.currentDocumentPane != null) {
                this.caretPos = this.currentDocumentPane.getEditor().getCaretPosition();
                new FindReplaceDialog(this.panel.getMainFrame(), this.panel.getSHTMLEditorPane());
            }
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            if (this.panel.getDocumentPane() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }

        public void findReplaceTerminated(FindReplaceEvent e) {
            if (this.currentDocumentPane.isVisible()) {
                SHTMLEditorPane editor = this.currentDocumentPane.getEditor();
                editor.setCaretPosition(this.caretPos);
                editor.requestFocus();
            }
        }
    }

    static class MultipleDocFindReplaceAction
    extends AbstractAction
    implements SHTMLAction,
    FindReplaceListener {
        private final SHTMLPanelMultipleDocImpl panel;
        private int caretPos;
        private int currentTab;

        public MultipleDocFindReplaceAction(SHTMLPanelMultipleDocImpl panel) {
            super("findReplace");
            this.panel = panel;
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, 2));
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ae) {
            this.currentTab = this.panel.getTabbedPaneForDocuments().getSelectedIndex();
            this.caretPos = this.panel.getDocumentPane().getEditor().getCaretPosition();
            if (this.panel.getTabbedPaneForDocuments().getTabCount() > 1) {
                new FindReplaceDialog(this.panel.getMainFrame(), this.panel.getSHTMLEditorPane(), this);
            } else {
                new FindReplaceDialog(this.panel.getMainFrame(), this.panel.getSHTMLEditorPane());
            }
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            if (this.panel.getTabbedPaneForDocuments().getTabCount() > 0) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelMultipleDocImpl.getActionProperties(this, (String)this.getValue("Name"));
        }

        public void getNextDocument(FindReplaceEvent e) {
            FindReplaceDialog frd = (FindReplaceDialog)e.getSource();
            int tabCount = this.panel.getTabbedPaneForDocuments().getTabCount();
            int curTab = this.panel.getTabbedPaneForDocuments().getSelectedIndex();
            System.out.println("FindReplaceAction.getNextDocument curTab=" + curTab + ", tabCount=" + tabCount);
            if (++curTab < tabCount) {
                System.out.println("FindReplaceAction.getNextDocument next tab no=" + curTab);
                this.resumeWithNewEditor(frd, curTab);
            } else {
                frd.terminateOperation();
            }
        }

        public void getFirstDocument(FindReplaceEvent e) {
            FindReplaceDialog frd = (FindReplaceDialog)e.getSource();
            this.resumeWithNewEditor(frd, 0);
        }

        public void findReplaceTerminated(FindReplaceEvent e) {
            this.panel.getTabbedPaneForDocuments().setSelectedIndex(this.currentTab);
            DocumentPane docPane = (DocumentPane)this.panel.getTabbedPaneForDocuments().getSelectedComponent();
            SHTMLEditorPane editor = docPane.getEditor();
            editor.setCaretPosition(this.caretPos);
            editor.requestFocus();
        }

        private void resumeWithNewEditor(FindReplaceDialog frd, int tabNo) {
            this.panel.getTabbedPaneForDocuments().setSelectedIndex(tabNo);
            DocumentPane docPane = (DocumentPane)this.panel.getTabbedPaneForDocuments().getComponentAt(tabNo);
            SHTMLEditorPane editor = docPane.getEditor();
            editor.requestFocus();
            frd.setEditor(editor);
            frd.resumeOperation();
        }
    }

    static class ClearFormatAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public ClearFormatAction(SHTMLPanelImpl panel) {
            this.panel = panel;
            this.putValue("Name", "clearFormat");
            this.putValue("selected", "false");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(66, 2));
            SHTMLPanelImpl.getActionProperties(this, "clearFormat");
        }

        public void actionPerformed(ActionEvent e) {
            SHTMLEditorPane editor = this.panel.getSHTMLEditorPane();
            if (editor != null) {
                if (editor.getSelectionStart() != editor.getSelectionEnd()) {
                    editor.removeCharacterAttributes();
                } else {
                    editor.removeParagraphAttributes();
                }
            }
            this.panel.updateActions();
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, "clearFormat");
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            SHTMLEditorPane editor = this.panel.getSHTMLEditorPane();
            this.setEnabled(editor != null);
        }
    }

    static class EditNamedStyleAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public EditNamedStyleAction(SHTMLPanelImpl panel) {
            super("editNamedStyle");
            this.panel = panel;
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ae) {
            Frame parent = JOptionPane.getFrameForComponent(this.panel);
            ParaStyleDialog dlg = new ParaStyleDialog(parent, Util.getResourceString("namedStyleDialogTitle"), this.panel.getSHTMLDocument());
            Util.center(parent, dlg);
            dlg.setModal(true);
            dlg.setValue(this.panel.getMaxAttributes(this.panel.getSHTMLEditorPane(), null));
            dlg.setVisible(true);
            this.panel.updateActions();
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            if (this.panel.getSHTMLEditorPane() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class UndoAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public UndoAction(SHTMLPanelImpl panel) {
            super("undo");
            this.panel = panel;
            this.setEnabled(false);
            this.getProperties();
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, 2));
        }

        public void actionPerformed(ActionEvent e) {
            if (this.panel.getCurrentDocumentPane().getSelectedTab() != 0) {
                return;
            }
            try {
                this.panel.getUndo().undo();
                this.panel.getSHTMLEditorPane();
            }
            catch (Exception ex) {
                Util.errMsg((Component)e.getSource(), Util.getResourceString("unableToUndoError") + ex, ex);
            }
            this.panel.updateActions();
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(this.panel.getUndo().canUndo());
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class OpenLinkAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public OpenLinkAction(SHTMLPanelImpl panel) {
            super("openLink");
            this.panel = panel;
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ae) {
            String linkURL = this.panel.getSHTMLEditorPane().getURLOfExistingLink();
            if (linkURL != null) {
                this.panel.openHyperlink(linkURL);
            }
            this.panel.updateActions();
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            if (this.panel.getSHTMLEditorPane() != null) {
                if (this.panel.getSHTMLEditorPane().getSelectionEnd() > this.panel.getSHTMLEditorPane().getSelectionStart() || this.panel.getSHTMLEditorPane().getCurrentLinkElement() != null) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class EditLinkAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public EditLinkAction(SHTMLPanelImpl panel) {
            super("editLink");
            this.panel = panel;
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ae) {
            Frame parent = JOptionPane.getFrameForComponent(this.panel);
            LinkDialog dialog = new LinkDialog(parent, Util.getResourceString("linkDialogTitle"), this.panel.getSHTMLEditorPane(), this.panel.getDocumentPane().getImageDir());
            if (parent != null) {
                Util.center(parent, dialog);
            }
            dialog.setModal(true);
            dialog.setVisible(true);
            if (dialog.getResult() == DialogShell.RESULT_OK) {
                this.panel.getSHTMLEditorPane().setLink(dialog.getLinkText(), dialog.getHref(), dialog.getStyleName(), dialog.getLinkImage(), dialog.getLinkImageSize());
            }
            this.panel.updateActions();
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            if (this.panel.getSHTMLEditorPane() != null) {
                if (this.panel.getSHTMLEditorPane().getSelectionEnd() > this.panel.getSHTMLEditorPane().getSelectionStart() || this.panel.getSHTMLEditorPane().getCurrentLinkElement() != null) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class EditAnchorsAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public EditAnchorsAction(SHTMLPanelImpl panel) {
            super("editAnchors");
            this.panel = panel;
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ae) {
            Frame parent = JOptionPane.getFrameForComponent(this.panel);
            AnchorDialog dlg = new AnchorDialog(parent, Util.getResourceString("anchorDialogTitle"), (Document)this.panel.getSHTMLDocument());
            Util.center(parent, dlg);
            dlg.setModal(true);
            dlg.setVisible(true);
            this.panel.updateActions();
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            if (this.panel.getSHTMLEditorPane() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class FontColorAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;
        private ColorPanel hiddenColorPanel;

        public FontColorAction(SHTMLPanelImpl panel) {
            this.panel = panel;
            this.putValue("Name", "fontColor");
            this.putValue("selected", "false");
            this.getProperties();
            this.hiddenColorPanel = null;
        }

        public void actionPerformed(ActionEvent e) {
            SHTMLEditorPane editorPane = this.panel.getSHTMLEditorPane();
            if (editorPane != null) {
                if (this.hiddenColorPanel == null) {
                    this.hiddenColorPanel = new ColorPanel("Select Color", Color.BLACK, CSS.Attribute.COLOR);
                }
                this.hiddenColorPanel.setValue(this.panel.getMaxAttributes(editorPane, null));
                this.hiddenColorPanel.actionPerformed(null);
                editorPane.applyAttributes(this.hiddenColorPanel.getValue(), false);
            }
            this.panel.updateActions();
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, "fontColor");
        }

        public void update() {
        }
    }

    static class UnderlineAction
    extends StyledEditorKit.UnderlineAction
    implements SHTMLAction,
    AttributeComponent {
        private final SHTMLPanelImpl panel;

        public UnderlineAction(SHTMLPanelImpl panel) {
            this.panel = panel;
            this.putValue("Name", "fontUnderline");
            this.putValue("selected", "false");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(85, 2));
            SHTMLPanelImpl.getActionProperties(this, "fontUnderline");
        }

        public void actionPerformed(ActionEvent e) {
            SHTMLDocument doc;
            super.actionPerformed(e);
            if (this.panel.getSHTMLEditorPane() != null && (doc = (SHTMLDocument)this.panel.getSHTMLEditorPane().getDocument()) != null) {
                AttributeSet a = doc.getCharacterElement(this.panel.getSHTMLEditorPane().getSelectionStart()).getAttributes();
                boolean isUnderlined = StyleConstants.isUnderline(a);
                if (isUnderlined) {
                    this.putValue("selected", "true");
                } else {
                    this.putValue("selected", "false");
                }
            }
            this.panel.updateActions();
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, "fontUnderline");
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            if (this.panel.getSHTMLEditorPane() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public boolean setValue(AttributeSet a) {
            Object value;
            boolean success = false;
            boolean isUnderlined = StyleConstants.isUnderline(a);
            if (a.isDefined(CSS.Attribute.TEXT_DECORATION) && (value = a.getAttribute(CSS.Attribute.TEXT_DECORATION)).toString().equalsIgnoreCase("underline")) {
                isUnderlined = true;
            }
            if (isUnderlined) {
                this.putValue("selected", "true");
            } else {
                this.putValue("selected", "false");
            }
            success = true;
            return success;
        }

        public AttributeSet getValue() {
            SimpleAttributeSet set = new SimpleAttributeSet();
            if (this.getValue("selected").toString().equals("true")) {
                Util.styleSheet().addCSSAttribute(set, CSS.Attribute.TEXT_DECORATION, "underline");
            } else {
                Util.styleSheet().addCSSAttribute(set, CSS.Attribute.TEXT_DECORATION, "none");
            }
            return set;
        }

        public AttributeSet getValue(boolean includeUnchanged) {
            return this.getValue();
        }
    }

    static class DocumentTitleAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public DocumentTitleAction(SHTMLPanelImpl panel) {
            super("documentTitle");
            this.panel = panel;
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ae) {
            String currentTitle = this.panel.getSHTMLDocument().getDocumentTitle();
            String newTitle = currentTitle != null ? currentTitle : "";
            newTitle = Util.nameInput(JOptionPane.getFrameForComponent(this.panel), newTitle, ".*", "docTitleTitle", "docTitleQuery");
            if (newTitle != null && newTitle.length() > 0) {
                this.panel.getSHTMLDocument().setDocumentTitle(newTitle);
            }
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            if (this.panel.getSHTMLEditorPane() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class ToggleListAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;
        private final HTML.Tag listTag;

        public ToggleListAction(SHTMLPanelImpl panel, String name, HTML.Tag listTag) {
            super(name);
            this.panel = panel;
            this.listTag = listTag;
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ae) {
            this.panel.getSHTMLEditorPane().toggleList(this.listTag.toString(), null, false);
            this.panel.updateActions();
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            if (this.panel.getSHTMLEditorPane() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class DeleteTableRowAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public DeleteTableRowAction(SHTMLPanelImpl panel) {
            super("deleteTableRow");
            this.panel = panel;
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ae) {
            this.panel.getSHTMLEditorPane().deleteTableRow();
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            if (this.panel.getSHTMLEditorPane() != null && this.panel.getSHTMLEditorPane().getCurrentTableCell() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class ShowElementTreeAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;
        private JFrame elementTreeFrame = null;

        public ShowElementTreeAction(SHTMLPanelImpl panel) {
            super("elemTree");
            this.panel = panel;
            this.getProperties();
        }

        public void actionPerformed(ActionEvent e) {
            if (this.elementTreeFrame == null) {
                String title = Util.getResourceString("elementTreeTitle");
                this.elementTreeFrame = new JFrame(title);
                this.elementTreeFrame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent we) {
                        ShowElementTreeAction.this.elementTreeFrame.dispose();
                        ShowElementTreeAction.this.elementTreeFrame = null;
                    }
                });
                Container fContentPane = this.elementTreeFrame.getContentPane();
                fContentPane.setLayout(new BorderLayout());
                ElementTreePanel elementTreePanel = new ElementTreePanel(this.panel.getSHTMLEditorPane());
                fContentPane.add(elementTreePanel);
                this.elementTreeFrame.pack();
            }
            this.elementTreeFrame.setVisible(true);
            this.panel.updateActions();
        }

        public void update() {
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class DeleteTableColAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public DeleteTableColAction(SHTMLPanelImpl panel) {
            super("deleteTableCol");
            this.panel = panel;
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ae) {
            this.panel.getSHTMLEditorPane().deleteTableCol();
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            if (this.panel.getSHTMLEditorPane() != null && this.panel.getSHTMLEditorPane().getCurrentTableCell() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class ApplyCSSAttributeAction
    extends AbstractAction
    implements SHTMLAction,
    AttributeComponent {
        private final SHTMLPanelImpl panel;
        Object attributeName;
        private final Object attributeValue;
        private final boolean applyToParagraph;

        public ApplyCSSAttributeAction(SHTMLPanelImpl panel, String actionName, Object attributeName, Object attributeValue, boolean applyToParagraph) {
            super(actionName);
            this.panel = panel;
            this.putValue("selected", "false");
            this.attributeName = attributeName;
            this.attributeValue = attributeValue;
            this.applyToParagraph = applyToParagraph;
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ev) {
            boolean performTheAction = false;
            if (ev.getSource() instanceof JToggleButton) {
                JToggleButton button = (JToggleButton)ev.getSource();
                performTheAction = button.isSelected();
            } else {
                performTheAction = true;
            }
            if (performTheAction) {
                this.panel.getSHTMLEditorPane().applyAttributes(this.getValue(), this.applyToParagraph);
                this.putValue("selected", "true");
                this.panel.updateActions();
            }
        }

        public Object getAttributeName() {
            return this.attributeName;
        }

        public boolean setValue(AttributeSet a) {
            boolean success = false;
            if (a.isDefined(this.attributeName)) {
                Object value = a.getAttribute(this.attributeName);
                if (value.toString().equalsIgnoreCase(this.attributeValue.toString())) {
                    this.putValue("selected", "true");
                } else {
                    this.putValue("selected", "false");
                }
                success = true;
            } else {
                this.putValue("selected", "false");
            }
            return success;
        }

        public AttributeSet getValue() {
            SimpleAttributeSet attributeSet = new SimpleAttributeSet();
            Util.styleSheet().addCSSAttribute(attributeSet, (CSS.Attribute)this.getAttributeName(), this.attributeValue.toString());
            return attributeSet;
        }

        public AttributeSet getValue(boolean includeUnchanged) {
            return this.getValue();
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(this.panel.getSHTMLEditorPane() != null);
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class BoldAction
    extends StyledEditorKit.BoldAction
    implements SHTMLAction,
    AttributeComponent {
        private final SHTMLPanelImpl panel;

        public BoldAction(SHTMLPanelImpl panel) {
            this.panel = panel;
            this.putValue("Name", "fontBold");
            this.putValue("selected", "false");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(66, 2));
            SHTMLPanelImpl.getActionProperties(this, "fontBold");
        }

        public void actionPerformed(ActionEvent e) {
            SHTMLDocument doc;
            super.actionPerformed(e);
            if (this.panel.getSHTMLEditorPane() != null && (doc = (SHTMLDocument)this.panel.getSHTMLEditorPane().getDocument()) != null) {
                AttributeSet a = doc.getCharacterElement(this.panel.getSHTMLEditorPane().getSelectionStart()).getAttributes();
                boolean isBold = StyleConstants.isBold(a);
                this.putValue("selected", isBold ? "true" : "false");
            }
            this.panel.updateActions();
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, "fontItalic");
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(this.panel.getSHTMLEditorPane() != null);
        }

        public boolean setValue(AttributeSet a) {
            Object value;
            boolean success = false;
            boolean isBold = StyleConstants.isBold(a);
            if (a.isDefined(CSS.Attribute.FONT_WEIGHT) && (value = a.getAttribute(CSS.Attribute.FONT_WEIGHT)).toString().equalsIgnoreCase(StyleConstants.Bold.toString())) {
                isBold = true;
            }
            if (isBold) {
                this.putValue("selected", "true");
            } else {
                this.putValue("selected", "false");
            }
            success = true;
            return success;
        }

        public AttributeSet getValue() {
            SimpleAttributeSet set = new SimpleAttributeSet();
            if (this.getValue("selected").toString().equals("true")) {
                Util.styleSheet().addCSSAttribute(set, CSS.Attribute.FONT_WEIGHT, StyleConstants.Bold.toString());
            } else {
                Util.styleSheet().addCSSAttribute(set, CSS.Attribute.FONT_WEIGHT, "normal".toString());
            }
            return set;
        }

        public AttributeSet getValue(boolean includeUnchanged) {
            return this.getValue();
        }
    }

    static class AppendTableRowAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public AppendTableRowAction(SHTMLPanelImpl panel) {
            super("appendTableRow");
            this.panel = panel;
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ae) {
            this.panel.getSHTMLEditorPane().appendTableRow();
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            if (this.panel.getSHTMLEditorPane() != null && this.panel.getSHTMLEditorPane().getCurrentTableCell() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class SetTagAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;
        private boolean ignoreActions = false;
        private String tag = null;

        public SetTagAction(SHTMLPanelImpl panel) {
            super("setTag");
            this.panel = panel;
            this.getProperties();
        }

        public SetTagAction(SHTMLPanelImpl panel, String tag) {
            super("setTag");
            this.panel = panel;
            this.tag = tag;
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ae) {
            if (!this.ignoreActions) {
                if (this.tag != null) {
                    this.panel.getSHTMLEditorPane().applyParagraphTag(this.tag, null);
                    this.panel.updateActions();
                } else {
                    String tagFromSelector = this.panel.getTagSelector().getSelectedTag();
                    this.panel.getSHTMLEditorPane().applyParagraphTag(tagFromSelector, this.panel.getTagSelector().getTags());
                    this.panel.updateActions();
                }
            }
        }

        public void setIgnoreActions(boolean ignore) {
            this.ignoreActions = ignore;
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            if (this.panel.getSHTMLEditorPane() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class AppendTableColAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;

        public AppendTableColAction(SHTMLPanelImpl panel) {
            super("appendTableCol");
            this.panel = panel;
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ae) {
            this.panel.getSHTMLEditorPane().appendTableColumn();
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            SHTMLEditorPane editor = this.panel.getSHTMLEditorPane();
            if (editor != null && editor.getCurrentTableCell() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }

    static class SetStyleAction
    extends AbstractAction
    implements SHTMLAction {
        private final SHTMLPanelImpl panel;
        private boolean ignoreActions = false;

        public SetStyleAction(SHTMLPanelImpl panel) {
            super("setStyle");
            this.panel = panel;
            this.getProperties();
        }

        public void actionPerformed(ActionEvent ae) {
            if (!this.ignoreActions) {
                StyleSelector styleSelector = (StyleSelector)ae.getSource();
                AttributeSet attributeSet = styleSelector.getValue();
                if (attributeSet != null) {
                    this.panel.getSHTMLEditorPane().applyAttributes(attributeSet, true);
                }
                this.panel.updateActions();
            }
        }

        public void setIgnoreActions(boolean ignore) {
            this.ignoreActions = ignore;
        }

        public void update() {
            if (this.panel.isHtmlEditorActive()) {
                this.setEnabled(false);
                return;
            }
            if (this.panel.getSHTMLEditorPane() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void getProperties() {
            SHTMLPanelImpl.getActionProperties(this, (String)this.getValue("Name"));
        }
    }
}

