/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.i18n;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.swing.UIManager;
import net.sf.freecol.common.ObjectWithId;
import net.sf.freecol.common.i18n.Number;
import net.sf.freecol.common.i18n.NumberRules;
import net.sf.freecol.common.i18n.Selector;
import net.sf.freecol.common.io.FreeColDataFile;
import net.sf.freecol.common.io.FreeColDirectories;
import net.sf.freecol.common.io.FreeColModFile;
import net.sf.freecol.common.io.Mods;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.util.CollectionUtils;

public class Messages {
    private static final Logger logger = Logger.getLogger(Messages.class.getName());
    public static final String MESSAGE_FILE_PREFIX = "FreeColMessages";
    public static final String MOD_MESSAGE_FILE_PREFIX = "ModMessages";
    public static final String MESSAGE_FILE_SUFFIX = ".properties";
    public static final String DESCRIPTION_SUFFIX = ".description";
    public static final String SHORT_DESCRIPTION_SUFFIX = ".shortDescription";
    public static final String NAME_SUFFIX = ".name";
    public static final String RULER_SUFFIX = ".ruler";
    private static final String[] DESCRIPTION_KEYS = new String[]{".description", ".shortDescription", ".name"};
    public static final String AUTOMATIC = "automatic";
    private static final Map<String, String> messageBundle = new HashMap<String, String>();
    private static final Map<String, Selector> tagMap = new HashMap<String, Selector>();

    private static Selector getSelector(String tag) {
        return tagMap.get(tag.toLowerCase(Locale.US));
    }

    public static void setGrammaticalNumber(Number number) {
        tagMap.put("plural", number);
    }

    private static List<String> getMessageFileNames(Locale locale) {
        return FreeColDataFile.getFileNames(MESSAGE_FILE_PREFIX, MESSAGE_FILE_SUFFIX, locale);
    }

    private static List<String> getModMessageFileNames(Locale locale) {
        return FreeColDataFile.getFileNames(MOD_MESSAGE_FILE_PREFIX, MESSAGE_FILE_SUFFIX, locale);
    }

    public static void loadMessageBundle(Locale locale) {
        messageBundle.clear();
        if (!Locale.getDefault().equals(locale)) {
            Locale.setDefault(locale);
        }
        File i18nDirectory = FreeColDirectories.getI18nDirectory();
        if (!NumberRules.isInitialized()) {
            File cldr = new File(i18nDirectory, "plurals.xml");
            if (cldr.exists()) {
                try (FileInputStream in = new FileInputStream(cldr);){
                    NumberRules.load(in);
                }
                catch (IOException e) {
                    System.err.println("Failed to read CLDR rules: " + e.getMessage());
                }
            } else {
                System.err.println("Could not find CLDR rules: " + cldr.getPath());
            }
        }
        Locale loc = AUTOMATIC.equalsIgnoreCase(locale.getLanguage()) ? Locale.getDefault() : locale;
        Messages.setGrammaticalNumber(NumberRules.getNumberForLanguage(loc.getLanguage()));
        for (String name : Messages.getMessageFileNames(locale)) {
            File file = new File(i18nDirectory, name);
            if (!file.exists()) continue;
            try {
                Messages.loadMessages(new FileInputStream(file));
            }
            catch (IOException e) {
                System.err.println("Failed to load messages from " + name + ": " + e.getMessage());
            }
        }
    }

    public static void loadMessages(InputStream is) throws IOException {
        InputStreamReader inputReader;
        try {
            inputReader = new InputStreamReader(is, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return;
        }
        BufferedReader in = new BufferedReader(inputReader);
        String line = null;
        while ((line = in.readLine()) != null) {
            int index = (line = line.trim()).indexOf(35);
            if (index == 0 || (index = line.indexOf(61)) <= 0) continue;
            String key = line.substring(0, index).trim();
            String value = line.substring(index + 1).trim().replace("\\n", "\n").replace("\\t", "\t");
            messageBundle.put(key, value);
            if (!key.startsWith("FileChooser.")) continue;
            UIManager.put(key, value);
        }
    }

    public static void loadModMessageBundle(Locale locale) {
        ArrayList<FreeColModFile> allMods = new ArrayList<FreeColModFile>();
        allMods.addAll(Mods.getAllMods());
        allMods.addAll(Mods.getRuleSets());
        List<String> filenames = Messages.getMessageFileNames(locale);
        for (FreeColModFile fcmf : allMods) {
            for (String name : filenames) {
                try {
                    Messages.loadMessages(fcmf.getInputStream(name));
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void loadActiveModMessageBundle(List<FreeColModFile> mods, Locale locale) {
        for (FreeColModFile fcmf : mods) {
            for (String name : Messages.getModMessageFileNames(locale)) {
                try {
                    Messages.loadMessages(fcmf.getInputStream(name));
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static Locale getLocale(String languageID) {
        String country = "";
        String variant = "";
        StringTokenizer st = new StringTokenizer(languageID, "_", true);
        String language = st.nextToken();
        if (st.hasMoreTokens()) {
            st.nextToken();
        }
        if (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!"_".equals(token)) {
                country = token;
            }
            if (st.hasMoreTokens()) {
                token = st.nextToken();
                if ("_".equals(token) && st.hasMoreTokens()) {
                    token = st.nextToken();
                }
                if (!"_".equals(token)) {
                    variant = token;
                }
            }
        }
        return new Locale(language, country, variant);
    }

    public static String nameKey(String id) {
        return id + NAME_SUFFIX;
    }

    public static String nameKey(ObjectWithId object) {
        return Messages.nameKey(object.getId());
    }

    public static String getName(String id) {
        return Messages.message(Messages.nameKey(id));
    }

    public static String getName(Named named) {
        return Messages.message(named.getNameKey());
    }

    public static String descriptionKey(String id) {
        return id + DESCRIPTION_SUFFIX;
    }

    public static String descriptionKey(ObjectWithId object) {
        return Messages.descriptionKey(object.getId());
    }

    public static String getDescription(String id) {
        return Messages.message(Messages.descriptionKey(id));
    }

    public static String getDescription(ObjectWithId object) {
        return Messages.message(Messages.descriptionKey(object));
    }

    public static String shortDescriptionKey(String id) {
        return id + SHORT_DESCRIPTION_SUFFIX;
    }

    public static String getShortDescription(String id) {
        return Messages.message(Messages.shortDescriptionKey(id));
    }

    public static String getShortDescription(ObjectWithId object) {
        return Messages.getShortDescription(object.getId());
    }

    public static String rulerKey(String id) {
        return id + RULER_SUFFIX;
    }

    public static String getRulerName(String id) {
        return Messages.message(Messages.rulerKey(id));
    }

    public static boolean containsKey(String key) {
        return messageBundle.get(key) != null;
    }

    public static String getKey(String preferredKey, String defaultKey) {
        if (Messages.containsKey(preferredKey)) {
            return preferredKey;
        }
        return defaultKey;
    }

    public static String getBestDescription(ObjectWithId object) {
        return Messages.getBestDescription(object.getId());
    }

    public static String getBestDescription(String id) {
        String key = CollectionUtils.find(CollectionUtils.map(DESCRIPTION_KEYS, s -> id + s), k -> Messages.containsKey(k), null);
        return key == null ? id : Messages.message(key);
    }

    public static String[] getBestNameAndDescription(Named named) {
        return Messages.getBestNameAndDescription(named.getNameKey());
    }

    public static String[] getBestNameAndDescription(String id) {
        if (id != null && id.endsWith(NAME_SUFFIX)) {
            id = id.substring(0, id.length() - NAME_SUFFIX.length());
        }
        String name = Messages.containsKey(Messages.nameKey(id)) ? Messages.getName(id) : null;
        String desc = null;
        if (name == null) {
            String string = name = Messages.containsKey(id) ? Messages.message(id) : null;
            if (name == null) {
                name = id;
            }
        } else {
            desc = Messages.getBestDescription(id);
            if (id.equals(desc)) {
                desc = null;
            }
        }
        return new String[]{name, desc};
    }

    public static StringTemplate getUnitLabel(String name, String typeId, int number, String nationId, String roleId, StringTemplate extra) {
        String roleKey;
        StringTemplate type;
        String baseKey = typeId + "." + Role.getRoleSuffix(roleId);
        if (Messages.containsKey(baseKey)) {
            type = StringTemplate.template(baseKey).addAmount("%number%", number);
            roleKey = null;
        } else {
            type = StringTemplate.template(Messages.nameKey(typeId)).addAmount("%number%", number);
            String string = roleKey = Role.isDefaultRoleId(roleId) ? null : roleId;
        }
        StringTemplate ret = name == null ? (nationId == null ? (roleKey == null ? (extra == null ? type : StringTemplate.label("").addStringTemplate(type).addName(" (").addStringTemplate(extra).addName(")")) : (extra == null ? StringTemplate.label("").add(Messages.nameKey(roleKey)).addName(" (").addStringTemplate(type).addName(")") : StringTemplate.label("").add(Messages.nameKey(roleKey)).addName(" (").addStringTemplate(type).addName("/").addStringTemplate(extra).addName(")"))) : (roleKey == null ? (extra == null ? StringTemplate.label("").add(Messages.nameKey(nationId)).addName(" ").addStringTemplate(type) : StringTemplate.label("").add(Messages.nameKey(nationId)).addName(" ").addStringTemplate(type).addName(" (").addStringTemplate(extra).addName(")")) : (extra == null ? StringTemplate.label("").add(Messages.nameKey(nationId)).addName(" ").add(Messages.nameKey(roleKey)).addName(" (").addStringTemplate(type).addName(")") : StringTemplate.label("").add(Messages.nameKey(nationId)).addName(" ").add(Messages.nameKey(roleKey)).addName(" (").addStringTemplate(type).addName("/").addStringTemplate(extra).addName(")")))) : (nationId == null ? (roleKey == null ? (extra == null ? StringTemplate.label("").addName(name).addName(" (").addStringTemplate(type).addName(")") : StringTemplate.label("").addName(name).addName(" (").addStringTemplate(type).addName("/").addStringTemplate(extra).addName(")")) : (extra == null ? StringTemplate.label("").addName(name).addName(" (").add(Messages.nameKey(roleKey)).addName("/").addStringTemplate(type).addName(")") : StringTemplate.label("").addName(name).addName(" (").add(Messages.nameKey(roleKey)).addName("/").addStringTemplate(type).addName("/").addStringTemplate(extra).addName(")"))) : (roleKey == null ? (extra == null ? StringTemplate.label("").addName(name).addName(" (").add(Messages.nameKey(nationId)).addName(" ").addStringTemplate(type).addName(")") : StringTemplate.label("").addName(name).addName(" (").add(Messages.nameKey(nationId)).addName(" ").addStringTemplate(type).addName("/").addStringTemplate(extra).addName(")")) : (extra == null ? StringTemplate.label("").addName(name).addName(" (").add(Messages.nameKey(nationId)).addName(" ").add(Messages.nameKey(roleKey)).addName("/").addStringTemplate(type).addName(")") : StringTemplate.label("").addName(name).addName(" (").add(Messages.nameKey(nationId)).addName(" ").add(Messages.nameKey(roleKey)).addName("/").addStringTemplate(type).addName("/").addStringTemplate(extra).addName(")"))));
        return ret;
    }

    public static String message(String messageId) {
        if (messageId == null) {
            throw new NullPointerException("Message id must not be null!");
        }
        String message = messageBundle.get(messageId);
        if (message == null) {
            return messageId;
        }
        message = Messages.replaceChoices(message, null);
        return message.trim();
    }

    public static String message(StringTemplate template) {
        if (template == null) {
            return null;
        }
        String result = "";
        switch (template.getTemplateType()) {
            case LABEL: {
                List<StringTemplate> replacements = template.getReplacements();
                if (replacements.isEmpty()) {
                    result = Messages.message(template.getId());
                    break;
                }
                for (StringTemplate other : replacements) {
                    result = result + template.getId() + Messages.message(other);
                }
                if (result.length() >= template.getId().length()) {
                    result = result.substring(template.getId().length());
                    break;
                }
                logger.warning("incorrect use of template " + template);
                break;
            }
            case TEMPLATE: {
                if (Messages.containsKey(template.getId())) {
                    result = messageBundle.get(template.getId());
                } else if (template.getDefaultId() != null) {
                    result = messageBundle.get(template.getDefaultId());
                }
                result = Messages.replaceChoices(result, template);
                for (String key : template.getKeys()) {
                    result = result.replace(key, Messages.message(template.getReplacement(key)));
                }
                break;
            }
            case KEY: {
                String key = messageBundle.get(template.getId());
                result = key == null ? template.getId() : Messages.replaceChoices(key, null);
                break;
            }
            default: {
                result = template.getId();
            }
        }
        return result;
    }

    private static String replaceChoices(String input, StringTemplate template) {
        int openChoice = 0;
        int closeChoice = 0;
        int highWaterMark = 0;
        StringBuilder result = new StringBuilder();
        while ((openChoice = input.indexOf("{{", highWaterMark)) >= 0) {
            int end;
            String replacement;
            result.append(input.substring(highWaterMark, openChoice));
            closeChoice = Messages.findMatchingBracket(input, openChoice + 2);
            if (closeChoice < 0) {
                logger.warning("Mismatched brackets: " + input);
                return result.toString();
            }
            highWaterMark = closeChoice + 2;
            int colonIndex = input.indexOf(58, openChoice + 2);
            if (colonIndex < 0 || colonIndex > closeChoice) {
                logger.warning("No tag found: " + input);
                continue;
            }
            String tag = input.substring(openChoice + 2, colonIndex);
            int pipeIndex = input.indexOf(124, colonIndex + 1);
            if (pipeIndex < 0 || pipeIndex > closeChoice) {
                logger.warning("No choices found: " + input);
                continue;
            }
            String selector = input.substring(colonIndex + 1, pipeIndex);
            if (selector.isEmpty()) {
                selector = "default";
            } else if (selector.startsWith("%") && selector.endsWith("%")) {
                if (template == null) {
                    selector = "default";
                } else {
                    StringTemplate replacement2 = template.getReplacement(selector);
                    if (replacement2 == null) {
                        logger.warning("Failed to find replacement for " + selector);
                        continue;
                    }
                    selector = Messages.message(replacement2);
                    Selector taggedSelector = Messages.getSelector(tag);
                    if (taggedSelector != null) {
                        selector = taggedSelector.getKey(selector, input);
                    }
                }
            } else {
                Selector taggedSelector = Messages.getSelector(tag);
                if (taggedSelector != null) {
                    selector = taggedSelector.getKey(selector, input);
                }
            }
            int keyIndex = input.indexOf(selector, pipeIndex + 1);
            if (keyIndex < 0 || keyIndex > closeChoice) {
                String otherKey = input.substring(pipeIndex + 1, closeChoice);
                if (otherKey.startsWith("%") && otherKey.endsWith("%") && template != null) {
                    StringTemplate replacement3 = template.getReplacement(otherKey);
                    if (replacement3 == null) {
                        logger.warning("Failed to find replacement for " + otherKey);
                        continue;
                    }
                    if (replacement3.getTemplateType() == StringTemplate.TemplateType.KEY) {
                        otherKey = messageBundle.get(replacement3.getId());
                        keyIndex = otherKey.indexOf("{{");
                        if (keyIndex < 0) {
                            result.append(otherKey);
                            continue;
                        }
                        if ((keyIndex = otherKey.indexOf(selector, keyIndex)) < 0) {
                            logger.warning("Failed to find key " + selector + " in replacement " + replacement3.getId());
                            continue;
                        }
                        result.append(Messages.getChoice(otherKey, selector));
                        continue;
                    }
                    logger.warning("Choice substitution attempted, but template type was " + (Object)((Object)replacement3.getTemplateType()));
                    continue;
                }
                if (Messages.containsKey(otherKey)) {
                    otherKey = Messages.getChoice(messageBundle.get(otherKey), selector);
                    result.append(otherKey);
                    continue;
                }
                logger.warning("Unknown key or untagged choice: '" + otherKey + "', selector was '" + selector + "', trying 'default' instead");
                int defaultStart = otherKey.indexOf("default=");
                if (defaultStart >= 0) {
                    int defaultEnd = otherKey.indexOf(124, defaultStart += 8);
                    String defaultChoice = defaultEnd < 0 ? otherKey.substring(defaultStart) : otherKey.substring(defaultStart, defaultEnd);
                    result.append(defaultChoice);
                    continue;
                }
                logger.warning("No default choice found.");
                continue;
            }
            int start = keyIndex + selector.length() + 1;
            int replacementIndex = input.indexOf(124, start);
            int nextOpenIndex = input.indexOf("{{", start);
            if (nextOpenIndex >= 0 && nextOpenIndex < replacementIndex) {
                replacementIndex = input.indexOf(124, Messages.findMatchingBracket(input, nextOpenIndex + 2) + 2);
            }
            if (!(replacement = input.substring(start, end = replacementIndex < 0 || replacementIndex > closeChoice ? closeChoice : replacementIndex)).contains("{{")) {
                result.append(replacement);
                continue;
            }
            result.append(Messages.replaceChoices(replacement, template));
        }
        result.append(input.substring(highWaterMark));
        return result.toString();
    }

    private static String getChoice(String input, String key) {
        int keyIndex = input.indexOf(key);
        if (keyIndex < 0) {
            return null;
        }
        int start = keyIndex + key.length() + 1;
        int end = input.indexOf(124, start);
        if (end < 0 && (end = input.indexOf("}}", start)) < 0) {
            logger.warning("Failed to find end of choice for key " + key + " in input " + input);
            return null;
        }
        return input.substring(start, end);
    }

    private static int findMatchingBracket(String input, int start) {
        int last = 0;
        int level = 0;
        block4: for (int index = start; index < input.length(); ++index) {
            switch (input.charAt(index)) {
                case '{': {
                    if (last == 123) {
                        last = 0;
                        ++level;
                        continue block4;
                    }
                    last = 123;
                    continue block4;
                }
                case '}': {
                    if (last == 125) {
                        if (level == 0) {
                            return index - 1;
                        }
                        last = 0;
                        --level;
                        continue block4;
                    }
                    last = 125;
                    continue block4;
                }
            }
        }
        return -1;
    }
}

