/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.path.PathTrie;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.core.internal.io.Streams;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.DeprecationRestHandler;
import org.elasticsearch.rest.MethodHandlers;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.usage.UsageService;

public class RestController
implements HttpServerTransport.Dispatcher {
    private static final Logger logger = LogManager.getLogger(RestController.class);
    private final PathTrie<MethodHandlers> handlers = new PathTrie(RestUtils.REST_DECODER);
    private final UnaryOperator<RestHandler> handlerWrapper;
    private final NodeClient client;
    private final CircuitBreakerService circuitBreakerService;
    private final Set<String> headersToCopy;
    private final UsageService usageService;

    public RestController(Set<String> headersToCopy, UnaryOperator<RestHandler> handlerWrapper, NodeClient client, CircuitBreakerService circuitBreakerService, UsageService usageService) {
        this.headersToCopy = headersToCopy;
        this.usageService = usageService;
        if (handlerWrapper == null) {
            handlerWrapper = h -> h;
        }
        this.handlerWrapper = handlerWrapper;
        this.client = client;
        this.circuitBreakerService = circuitBreakerService;
    }

    public void registerAsDeprecatedHandler(RestRequest.Method method, String path, RestHandler handler, String deprecationMessage, DeprecationLogger logger) {
        assert (!(handler instanceof DeprecationRestHandler));
        this.registerHandler(method, path, new DeprecationRestHandler(handler, deprecationMessage, logger));
    }

    public void registerWithDeprecatedHandler(RestRequest.Method method, String path, RestHandler handler, RestRequest.Method deprecatedMethod, String deprecatedPath, DeprecationLogger logger) {
        String deprecationMessage = "[" + deprecatedMethod.name() + " " + deprecatedPath + "] is deprecated! Use [" + method.name() + " " + path + "] instead.";
        this.registerHandler(method, path, handler);
        this.registerAsDeprecatedHandler(deprecatedMethod, deprecatedPath, handler, deprecationMessage, logger);
    }

    public void registerHandler(RestRequest.Method method, String path, RestHandler handler) {
        if (handler instanceof BaseRestHandler) {
            this.usageService.addRestHandler((BaseRestHandler)handler);
        }
        RestHandler maybeWrappedHandler = (RestHandler)this.handlerWrapper.apply(handler);
        this.handlers.insertOrUpdate(path, new MethodHandlers(path, maybeWrappedHandler, method), (mHandlers, newMHandler) -> mHandlers.addMethods(maybeWrappedHandler, method));
    }

    @Override
    public void dispatchRequest(RestRequest request, RestChannel channel, ThreadContext threadContext) {
        if (request.rawPath().equals("/favicon.ico")) {
            this.handleFavicon(request.method(), request.uri(), channel);
            return;
        }
        try {
            this.tryAllHandlers(request, channel, threadContext);
        }
        catch (Exception e) {
            try {
                channel.sendResponse(new BytesRestResponse(channel, e));
            }
            catch (Exception inner) {
                inner.addSuppressed(e);
                logger.error(() -> new ParameterizedMessage("failed to send failure response for uri [{}]", (Object)request.uri()), (Throwable)inner);
            }
        }
    }

    @Override
    public void dispatchBadRequest(RestChannel channel, ThreadContext threadContext, Throwable cause) {
        try {
            Exception e = cause == null ? new ElasticsearchException("unknown cause", new Object[0]) : (cause instanceof Exception ? (Exception)cause : new ElasticsearchException(cause));
            channel.sendResponse(new BytesRestResponse(channel, RestStatus.BAD_REQUEST, e));
        }
        catch (IOException e) {
            if (cause != null) {
                e.addSuppressed(cause);
            }
            logger.warn("failed to send bad request response", (Throwable)e);
            channel.sendResponse(new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, "text/plain; charset=UTF-8", BytesArray.EMPTY));
        }
    }

    private void dispatchRequest(RestRequest request, RestChannel channel, RestHandler handler) throws Exception {
        int contentLength = request.content().length();
        if (contentLength > 0) {
            XContentType xContentType = request.getXContentType();
            if (xContentType == null) {
                this.sendContentTypeErrorMessage(request.getAllHeaderValues("Content-Type"), channel);
                return;
            }
            if (handler.supportsContentStream() && xContentType != XContentType.JSON && xContentType != XContentType.SMILE) {
                channel.sendResponse(BytesRestResponse.createSimpleErrorResponse(channel, RestStatus.NOT_ACCEPTABLE, "Content-Type [" + xContentType + "] does not support stream parsing. Use JSON or SMILE instead"));
                return;
            }
        }
        RestChannel responseChannel = channel;
        try {
            if (handler.canTripCircuitBreaker()) {
                RestController.inFlightRequestsBreaker(this.circuitBreakerService).addEstimateBytesAndMaybeBreak(contentLength, "<http_request>");
            } else {
                RestController.inFlightRequestsBreaker(this.circuitBreakerService).addWithoutBreaking(contentLength);
            }
            responseChannel = new ResourceHandlingHttpChannel(channel, this.circuitBreakerService, contentLength);
            handler.handleRequest(request, responseChannel, this.client);
        }
        catch (Exception e) {
            responseChannel.sendResponse(new BytesRestResponse(responseChannel, e));
        }
    }

    private boolean handleNoHandlerFound(String rawPath, RestRequest.Method method, String uri, RestChannel channel) {
        Set<RestRequest.Method> validMethodSet = this.getValidHandlerMethodSet(rawPath);
        if (!validMethodSet.contains((Object)method)) {
            if (method == RestRequest.Method.OPTIONS) {
                this.handleOptionsRequest(channel, validMethodSet);
                return true;
            }
            if (!validMethodSet.isEmpty()) {
                this.handleUnsupportedHttpMethod(uri, method, channel, validMethodSet, null);
                return true;
            }
        }
        return false;
    }

    private void sendContentTypeErrorMessage(@Nullable List<String> contentTypeHeader, RestChannel channel) throws IOException {
        String errorMessage = contentTypeHeader == null ? "Content-Type header is missing" : "Content-Type header [" + Strings.collectionToCommaDelimitedString(contentTypeHeader) + "] is not supported";
        channel.sendResponse(BytesRestResponse.createSimpleErrorResponse(channel, RestStatus.NOT_ACCEPTABLE, errorMessage));
    }

    private void tryAllHandlers(RestRequest request, RestChannel channel, ThreadContext threadContext) throws Exception {
        RestRequest.Method requestMethod;
        for (String key : this.headersToCopy) {
            String httpHeader = request.header(key);
            if (httpHeader == null) continue;
            threadContext.putHeader(key, httpHeader);
        }
        if (request.paramAsBoolean("error_trace", false) && !channel.detailedErrorsEnabled()) {
            channel.sendResponse(BytesRestResponse.createSimpleErrorResponse(channel, RestStatus.BAD_REQUEST, "error traces in responses are disabled."));
            return;
        }
        String rawPath = request.rawPath();
        String uri = request.uri();
        try {
            requestMethod = request.method();
            Iterator<MethodHandlers> allHandlers = this.getAllHandlers(request.params(), rawPath);
            while (allHandlers.hasNext()) {
                MethodHandlers handlers = allHandlers.next();
                RestHandler handler = handlers == null ? null : handlers.getHandler(requestMethod);
                if (handler == null) {
                    if (!this.handleNoHandlerFound(rawPath, requestMethod, uri, channel)) continue;
                    return;
                }
                this.dispatchRequest(request, channel, handler);
                return;
            }
        }
        catch (IllegalArgumentException e) {
            this.handleUnsupportedHttpMethod(uri, null, channel, this.getValidHandlerMethodSet(rawPath), e);
            return;
        }
        this.handleBadRequest(uri, requestMethod, channel);
    }

    Iterator<MethodHandlers> getAllHandlers(@Nullable Map<String, String> requestParamsRef, String rawPath) {
        Supplier<Map<String, String>> paramsSupplier;
        if (requestParamsRef == null) {
            paramsSupplier = () -> null;
        } else {
            HashMap<String, String> originalParams = new HashMap<String, String>(requestParamsRef);
            paramsSupplier = () -> {
                requestParamsRef.clear();
                requestParamsRef.putAll(originalParams);
                return requestParamsRef;
            };
        }
        return this.handlers.retrieveAll(rawPath, paramsSupplier);
    }

    private void handleUnsupportedHttpMethod(String uri, @Nullable RestRequest.Method method, RestChannel channel, Set<RestRequest.Method> validMethodSet, @Nullable IllegalArgumentException exception) {
        try {
            StringBuilder msg = new StringBuilder();
            if (exception == null) {
                msg.append("Incorrect HTTP method for uri [").append(uri);
                msg.append("] and method [").append((Object)method).append("]");
            } else {
                msg.append(exception.getMessage());
            }
            if (!validMethodSet.isEmpty()) {
                msg.append(", allowed: ").append(validMethodSet);
            }
            BytesRestResponse bytesRestResponse = BytesRestResponse.createSimpleErrorResponse(channel, RestStatus.METHOD_NOT_ALLOWED, msg.toString());
            if (!validMethodSet.isEmpty()) {
                bytesRestResponse.addHeader("Allow", Strings.collectionToDelimitedString(validMethodSet, ","));
            }
            channel.sendResponse(bytesRestResponse);
        }
        catch (IOException e) {
            logger.warn("failed to send bad request response", (Throwable)e);
            channel.sendResponse(new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, "text/plain; charset=UTF-8", BytesArray.EMPTY));
        }
    }

    private void handleOptionsRequest(RestChannel channel, Set<RestRequest.Method> validMethodSet) {
        BytesRestResponse bytesRestResponse = new BytesRestResponse(RestStatus.OK, "text/plain; charset=UTF-8", BytesArray.EMPTY);
        if (!validMethodSet.isEmpty()) {
            bytesRestResponse.addHeader("Allow", Strings.collectionToDelimitedString(validMethodSet, ","));
        }
        channel.sendResponse(bytesRestResponse);
    }

    private void handleBadRequest(String uri, RestRequest.Method method, RestChannel channel) throws IOException {
        try (XContentBuilder builder = channel.newErrorBuilder();){
            builder.startObject();
            builder.field("error", "no handler found for uri [" + uri + "] and method [" + (Object)((Object)method) + "]");
            builder.endObject();
            channel.sendResponse(new BytesRestResponse(RestStatus.BAD_REQUEST, builder));
        }
    }

    private Set<RestRequest.Method> getValidHandlerMethodSet(String rawPath) {
        HashSet<RestRequest.Method> validMethods = new HashSet<RestRequest.Method>();
        Iterator<MethodHandlers> allHandlers = this.getAllHandlers(null, rawPath);
        while (allHandlers.hasNext()) {
            MethodHandlers methodHandlers = allHandlers.next();
            if (methodHandlers == null) continue;
            validMethods.addAll(methodHandlers.getValidMethods());
        }
        return validMethods;
    }

    private void handleFavicon(RestRequest.Method method, String uri, RestChannel channel) {
        block11: {
            try {
                if (method != RestRequest.Method.GET) {
                    this.handleUnsupportedHttpMethod(uri, method, channel, Collections.singleton(RestRequest.Method.GET), null);
                    break block11;
                }
                try (InputStream stream = this.getClass().getResourceAsStream("/config/favicon.ico");){
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    Streams.copy((InputStream)stream, (OutputStream)out);
                    BytesRestResponse restResponse = new BytesRestResponse(RestStatus.OK, "image/x-icon", out.toByteArray());
                    channel.sendResponse(restResponse);
                }
                catch (IOException e) {
                    channel.sendResponse(new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, "text/plain; charset=UTF-8", BytesArray.EMPTY));
                }
            }
            catch (IllegalArgumentException e) {
                this.handleUnsupportedHttpMethod(uri, null, channel, Collections.singleton(RestRequest.Method.GET), e);
            }
        }
    }

    private static CircuitBreaker inFlightRequestsBreaker(CircuitBreakerService circuitBreakerService) {
        return circuitBreakerService.getBreaker("in_flight_requests");
    }

    private static final class ResourceHandlingHttpChannel
    implements RestChannel {
        private final RestChannel delegate;
        private final CircuitBreakerService circuitBreakerService;
        private final int contentLength;
        private final AtomicBoolean closed = new AtomicBoolean();

        ResourceHandlingHttpChannel(RestChannel delegate, CircuitBreakerService circuitBreakerService, int contentLength) {
            this.delegate = delegate;
            this.circuitBreakerService = circuitBreakerService;
            this.contentLength = contentLength;
        }

        @Override
        public XContentBuilder newBuilder() throws IOException {
            return this.delegate.newBuilder();
        }

        @Override
        public XContentBuilder newErrorBuilder() throws IOException {
            return this.delegate.newErrorBuilder();
        }

        @Override
        public XContentBuilder newBuilder(@Nullable XContentType xContentType, boolean useFiltering) throws IOException {
            return this.delegate.newBuilder(xContentType, useFiltering);
        }

        @Override
        public XContentBuilder newBuilder(XContentType xContentType, XContentType responseContentType, boolean useFiltering) throws IOException {
            return this.delegate.newBuilder(xContentType, responseContentType, useFiltering);
        }

        @Override
        public BytesStreamOutput bytesOutput() {
            return this.delegate.bytesOutput();
        }

        @Override
        public RestRequest request() {
            return this.delegate.request();
        }

        @Override
        public boolean detailedErrorsEnabled() {
            return this.delegate.detailedErrorsEnabled();
        }

        @Override
        public void sendResponse(RestResponse response) {
            this.close();
            this.delegate.sendResponse(response);
        }

        private void close() {
            if (!this.closed.compareAndSet(false, true)) {
                throw new IllegalStateException("Channel is already closed");
            }
            RestController.inFlightRequestsBreaker(this.circuitBreakerService).addWithoutBreaking(-this.contentLength);
        }
    }
}

