/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTPointer;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTReferenceOperator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTypeId;
import org.eclipse.cdt.internal.core.dom.parser.ASTAmbiguousNode;
import org.eclipse.cdt.internal.qt.core.parser.QtParser;

public class QtMethodUtil {
    public static String getQtNormalizedMethodSignature(String signature) {
        ICPPASTFunctionDeclarator function = QtParser.parseQtMethodReference(signature);
        if (function == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        String fnName = function.getName().getLastName().toString();
        result.append(QtMethodUtil.stripWS(fnName));
        result.append('(');
        boolean first = true;
        ICPPASTParameterDeclaration[] iCPPASTParameterDeclarationArray = function.getParameters();
        int n = iCPPASTParameterDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPASTParameterDeclaration param = iCPPASTParameterDeclarationArray[n2];
            if (first) {
                first = false;
            } else {
                result.append(',');
            }
            IASTDeclSpecifier spec = param.getDeclSpecifier();
            ICPPASTDeclarator declarator = param.getDeclarator();
            StringBuilder paramSig = new StringBuilder();
            QtMethodUtil.append(paramSig, spec, (IASTDeclarator)declarator, true);
            result.append(QtMethodUtil.stripWS(paramSig.toString()));
            ++n2;
        }
        result.append(')');
        return result.toString();
    }

    public static Collection<String> getDecodedQtMethodSignatures(String qtEncSignatures) {
        if (qtEncSignatures == null) {
            return null;
        }
        StringBuilder signature = new StringBuilder();
        int i = qtEncSignatures.indexOf(40);
        String name = qtEncSignatures.substring(0, i);
        signature.append(name);
        signature.append('(');
        boolean first = true;
        ArrayList<String> signatures = new ArrayList<String>();
        qtEncSignatures = qtEncSignatures.substring(i + 1);
        Pattern p = Pattern.compile("^([a-zA-Z0-9+/=]*)(@?).*$");
        while (!qtEncSignatures.isEmpty()) {
            Matcher m = p.matcher(qtEncSignatures);
            if (!m.matches()) break;
            int next = m.end(2) + 1;
            qtEncSignatures = qtEncSignatures.substring(next);
            String param = new String(DatatypeConverter.parseBase64Binary((String)m.group(1)));
            if (!m.group(2).isEmpty()) {
                signatures.add(String.valueOf(signature.toString()) + ')');
            }
            if (first) {
                first = false;
            } else {
                signature.append(',');
            }
            signature.append(param);
        }
        signature.append(')');
        signatures.add(signature.toString());
        return signatures;
    }

    public static String getEncodedQtMethodSignatures(ICPPASTFunctionDeclarator function) {
        StringBuilder result = new StringBuilder();
        String fnName = function.getName().getLastName().toString();
        result.append(QtMethodUtil.stripWS(fnName));
        result.append('(');
        boolean first = true;
        ICPPASTParameterDeclaration[] iCPPASTParameterDeclarationArray = function.getParameters();
        int n = iCPPASTParameterDeclarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPASTParameterDeclaration param = iCPPASTParameterDeclarationArray[n2];
            if (first) {
                first = false;
            } else {
                result.append(',');
            }
            IASTDeclSpecifier spec = param.getDeclSpecifier();
            ICPPASTDeclarator declarator = param.getDeclarator();
            StringBuilder paramSig = new StringBuilder();
            QtMethodUtil.append(paramSig, spec, (IASTDeclarator)declarator, true);
            String paramStr = QtMethodUtil.stripWS(paramSig.toString());
            result.append(DatatypeConverter.printBase64Binary((byte[])paramStr.getBytes()));
            if (declarator.getInitializer() != null) {
                result.append('@');
            }
            ++n2;
        }
        result.append(')');
        return result.toString();
    }

    private static String stripWS(String str) {
        return str.trim().replaceAll("\\s+", " ").replaceAll(" ([\\*&,()<>]+)", "$1").replaceAll("([\\*&,()<>]+) ", "$1");
    }

    private static String asString(IASTPointerOperator ptr) {
        if (ptr instanceof ICPPASTReferenceOperator) {
            return "&";
        }
        if (ptr instanceof IASTPointer) {
            StringBuilder str = new StringBuilder();
            IASTPointer astPtr = (IASTPointer)ptr;
            str.append('*');
            if (astPtr.isConst()) {
                str.append(" const");
            }
            if (astPtr.isVolatile()) {
                str.append(" volatile");
            }
            return str.toString();
        }
        return ptr.toString();
    }

    private static void append(StringBuilder result, IASTDeclSpecifier spec, IASTDeclarator declarator, boolean pruneConst) {
        IASTNode[] children;
        boolean stripLastPtrConst;
        IASTPointerOperator[] ptrs = declarator.getPointerOperators();
        if (ptrs == null) {
            ptrs = new IASTPointerOperator[]{};
        }
        if (!(spec instanceof ICPPASTDeclSpecifier)) {
            result.append(spec.toString());
            return;
        }
        ICPPASTDeclSpecifier cppSpec = (ICPPASTDeclSpecifier)spec;
        boolean isConst = cppSpec.isConst();
        boolean bl = stripLastPtrConst = pruneConst && !isConst && ptrs.length >= 2 && ptrs[ptrs.length - 1] instanceof ICPPASTReferenceOperator && ptrs[ptrs.length - 2] instanceof IASTPointer && ((IASTPointer)ptrs[ptrs.length - 2]).isConst();
        if (isConst || stripLastPtrConst) {
            if (!pruneConst) {
                result.append("const ");
            } else if (ptrs.length > 0) {
                IASTPointerOperator lastPtr = ptrs[ptrs.length - 1];
                if (lastPtr instanceof ICPPASTReferenceOperator) {
                    ptrs = Arrays.copyOf(ptrs, ptrs.length - 1);
                } else if (!(lastPtr instanceof IASTPointer) || !((IASTPointer)lastPtr).isConst()) {
                    result.append("const ");
                }
            }
        }
        if (cppSpec.isVolatile()) {
            result.append("volatile ");
        }
        if ((children = cppSpec.getChildren()) == null || children.length <= 0) {
            String raw = cppSpec.toString();
            raw = raw.replaceAll("const\\s", "");
            raw = raw.replaceAll("\\sconst", "");
            result.append(raw);
        } else {
            IASTNode[] iASTNodeArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IASTNode child = iASTNodeArray[n2];
                result.append(' ');
                if (child instanceof ICPPASTTemplateId) {
                    ICPPASTTemplateId templId = (ICPPASTTemplateId)child;
                    result.append(templId.getTemplateName());
                    result.append('<');
                    IASTNode[] iASTNodeArray2 = templId.getTemplateArguments();
                    int n3 = iASTNodeArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IASTNode templArg = iASTNodeArray2[n4];
                        QtMethodUtil.append(result, templArg);
                        ++n4;
                    }
                    result.append('>');
                } else {
                    result.append(child.toString());
                }
                ++n2;
            }
        }
        int i = 0;
        while (i < ptrs.length) {
            if (!stripLastPtrConst || i < ptrs.length - 1) {
                result.append(QtMethodUtil.asString(ptrs[i]));
            } else {
                result.append(QtMethodUtil.asString(ptrs[i]).replaceAll("const", ""));
            }
            ++i;
        }
    }

    private static void append(StringBuilder result, IASTNode node) {
        IASTNode[] nodes;
        if (node instanceof ASTAmbiguousNode && (nodes = ((ASTAmbiguousNode)node).getNodes()) != null && nodes.length > 0) {
            QtMethodUtil.append(result, nodes[0]);
            return;
        }
        if (node instanceof ICPPASTTypeId) {
            ICPPASTTypeId typeId = (ICPPASTTypeId)node;
            IASTDeclSpecifier spec = typeId.getDeclSpecifier();
            IASTDeclarator declarator = typeId.getAbstractDeclarator();
            QtMethodUtil.append(result, spec, declarator, false);
            return;
        }
        if (!(node instanceof ICPPASTTemplateId)) {
            result.append(node.toString());
            return;
        }
        ICPPASTTemplateId templId = (ICPPASTTemplateId)node;
        result.append(templId.getTemplateName());
        result.append('<');
        boolean first = true;
        IASTNode[] iASTNodeArray = templId.getTemplateArguments();
        int n = iASTNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNode child = iASTNodeArray[n2];
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            QtMethodUtil.append(result, child);
            ++n2;
        }
        result.append('>');
    }
}

