/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
// tslint:disable:comment-format binary-expression-operand-order max-line-length
const /** @type {?} */ symbolMap = {
    1: '١',
    2: '٢',
    3: '٣',
    4: '٤',
    5: '٥',
    6: '٦',
    7: '٧',
    8: '٨',
    9: '٩',
    0: '٠'
};
const /** @type {?} */ numberMap = {
    '١': '1',
    '٢': '2',
    '٣': '3',
    '٤': '4',
    '٥': '5',
    '٦': '6',
    '٧': '7',
    '٨': '8',
    '٩': '9',
    '٠': '0'
};
const /** @type {?} */ pluralForm = function (num) {
    return num === 0 ? 0 : num === 1 ? 1 : num === 2 ? 2 : num % 100 >= 3 && num % 100 <= 10 ? 3 : num % 100 >= 11 ? 4 : 5;
};
const ɵ0 = pluralForm;
const /** @type {?} */ plurals = {
    s: ['أقل من ثانية', 'ثانية واحدة', ['ثانيتان', 'ثانيتين'], '%d ثوان', '%d ثانية', '%d ثانية'],
    m: ['أقل من دقيقة', 'دقيقة واحدة', ['دقيقتان', 'دقيقتين'], '%d دقائق', '%d دقيقة', '%d دقيقة'],
    h: ['أقل من ساعة', 'ساعة واحدة', ['ساعتان', 'ساعتين'], '%d ساعات', '%d ساعة', '%d ساعة'],
    d: ['أقل من يوم', 'يوم واحد', ['يومان', 'يومين'], '%d أيام', '%d يومًا', '%d يوم'],
    M: ['أقل من شهر', 'شهر واحد', ['شهران', 'شهرين'], '%d أشهر', '%d شهرا', '%d شهر'],
    y: ['أقل من عام', 'عام واحد', ['عامان', 'عامين'], '%d أعوام', '%d عامًا', '%d عام']
};
const /** @type {?} */ pluralize = function (u) {
    return function (num, withoutSuffix) {
        const /** @type {?} */ f = pluralForm(num);
        let /** @type {?} */ str = plurals[u][pluralForm(num)];
        if (f === 2) {
            str = str[withoutSuffix ? 0 : 1];
        }
        return (/** @type {?} */ (str)).replace(/%d/i, num.toString());
    };
};
const ɵ1 = pluralize;
const /** @type {?} */ months = [
    'يناير',
    'فبراير',
    'مارس',
    'أبريل',
    'مايو',
    'يونيو',
    'يوليو',
    'أغسطس',
    'سبتمبر',
    'أكتوبر',
    'نوفمبر',
    'ديسمبر'
];
export const /** @type {?} */ arLocale = {
    abbr: 'ar',
    months,
    monthsShort: months,
    weekdays: 'الأحد_الإثنين_الثلاثاء_الأربعاء_الخميس_الجمعة_السبت'.split('_'),
    weekdaysShort: 'أحد_إثنين_ثلاثاء_أربعاء_خميس_جمعة_سبت'.split('_'),
    weekdaysMin: 'ح_ن_ث_ر_خ_ج_س'.split('_'),
    weekdaysParseExact: true,
    longDateFormat: {
        LT: 'HH:mm',
        LTS: 'HH:mm:ss',
        L: 'D/\u200FM/\u200FYYYY',
        LL: 'D MMMM YYYY',
        LLL: 'D MMMM YYYY HH:mm',
        LLLL: 'dddd D MMMM YYYY HH:mm'
    },
    meridiemParse: /ص|م/,
    /**
     * @param {?} input
     * @return {?}
     */
    isPM(input) {
        return 'م' === input;
    },
    /**
     * @param {?} hour
     * @param {?} minute
     * @param {?} isLower
     * @return {?}
     */
    meridiem(hour, minute, isLower) {
        if (hour < 12) {
            return 'ص';
        }
        else {
            return 'م';
        }
    },
    calendar: {
        sameDay: '[اليوم عند الساعة] LT',
        nextDay: '[غدًا عند الساعة] LT',
        nextWeek: 'dddd [عند الساعة] LT',
        lastDay: '[أمس عند الساعة] LT',
        lastWeek: 'dddd [عند الساعة] LT',
        sameElse: 'L'
    },
    relativeTime: {
        future: 'بعد %s',
        past: 'منذ %s',
        s: pluralize('s'),
        ss: pluralize('s'),
        m: pluralize('m'),
        mm: pluralize('m'),
        h: pluralize('h'),
        hh: pluralize('h'),
        d: pluralize('d'),
        dd: pluralize('d'),
        M: pluralize('M'),
        MM: pluralize('M'),
        y: pluralize('y'),
        yy: pluralize('y')
    },
    /**
     * @param {?} str
     * @return {?}
     */
    preparse(str) {
        return str.replace(/[١٢٣٤٥٦٧٨٩٠]/g, function (match) {
            return numberMap[match];
        }).replace(/،/g, ',');
    },
    /**
     * @param {?} str
     * @return {?}
     */
    postformat(str) {
        return str.replace(/\d/g, function (match) {
            return symbolMap[match];
        }).replace(/,/g, '،');
    },
    week: {
        dow: 6,
        // Saturday is the first day of the week.
        doy: 12 // The week that contains Jan 1st is the first week of the year.
    }
};
export { ɵ0, ɵ1 };

//# sourceMappingURL=data:application/json;base64,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