"use strict";
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var constants_1 = require("./constants");
var typescript_1 = require("typescript");
var path_1 = require("path");
var fs_1 = require("fs");
var format_diagnostics_1 = require("./format-diagnostics");
var closest_file_data_1 = require("closest-file-data");
var lodash_1 = require("lodash");
var logger_1 = require("./logger");
var get_ts_jest_config_1 = require("./get-ts-jest-config");
var getTSConfig = lodash_1.memoize(getTSConfig_local, function (jestConfig) {
    return JSON.stringify(__assign({}, jestConfig, { name: null, cacheDirectory: null }));
});
exports.default = getTSConfig;
function getTSConfig_local(jestConfig) {
    var configMeta = findTSConfigPath(jestConfig);
    if (!configMeta) {
        throw new ReferenceError("[ts-jest] Unable to find TS configuration file given current configuration");
    }
    var configPath = configMeta.path;
    logger_1.logOnce("Reading tsconfig file from path " + configPath);
    var config = readCompilerOptions(configPath);
    logger_1.logOnce('Original typescript config before modifications: ', __assign({}, config));
    config.declaration = false;
    config.declarationMap = false;
    config.emitDeclarationOnly = false;
    config.inlineSourceMap = false;
    config.sourceMap = true;
    config.inlineSources = true;
    delete config.outDir;
    delete config.outFile;
    if (!configMeta.isUserDefined) {
        config.module = typescript_1.ModuleKind.CommonJS;
    }
    config.module = config.module || typescript_1.ModuleKind.CommonJS;
    config.jsx = config.jsx || typescript_1.JsxEmit.React;
    return config;
}
function readCompilerOptions(configPath) {
    var _a = typescript_1.readConfigFile(configPath, typescript_1.sys.readFile), config = _a.config, error = _a.error;
    if (error) {
        throw error;
    }
    var _b = typescript_1.parseJsonConfigFileContent(config, typescript_1.sys, path_1.dirname(configPath)), errors = _b.errors, options = _b.options;
    if (errors.length > 0) {
        var formattedErrors = format_diagnostics_1.default(errors);
        throw new Error("Some errors occurred while attempting to read from " + configPath + ": " + formattedErrors);
    }
    return options;
}
var tsConfigReader = { basename: constants_1.TSCONFIG_FILENAME, read: function () { return 0; } };
function findTSConfigPath(jestConfig) {
    var tsConfigFile = get_ts_jest_config_1.default(jestConfig).tsConfigFile;
    if (tsConfigFile) {
        var givenConfigFile = tsConfigFile;
        tsConfigFile = tsConfigFile.replace('<rootDir>', "" + jestConfig.rootDir + path_1.sep);
        if (!tsConfigFile.startsWith('/') && jestConfig.rootDir) {
            tsConfigFile = path_1.resolve(jestConfig.rootDir, tsConfigFile);
        }
        else {
            tsConfigFile = path_1.resolve(tsConfigFile);
        }
        if (!fs_1.existsSync(tsConfigFile)) {
            throw new Error([
                "Unable to find tsconfig file given \"" + givenConfigFile + "\". If you gave a relative path,",
                "it'll be relative to the resolved \"rootDir\".\nTo avoid issues, use <rootDir> followed",
                "by a relative path to it in \"tsConfigFile\" config key.",
            ].join(' '));
        }
        return { path: tsConfigFile, isUserDefined: true };
    }
    return closest_file_data_1.default(jestConfig.rootDir, tsConfigReader);
}
//# sourceMappingURL=data:application/json;base64,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