"use strict";
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var logger_1 = require("./utils/logger");
var get_ts_jest_config_1 = require("./utils/get-ts-jest-config");
var imports_1 = require("./utils/imports");
var babel;
var istanbulPlugin;
var jestPreset;
function importBabelDeps() {
    if (babel)
        return;
    babel = imports_1.importBabelCore();
    if (babel.version && parseInt(babel.version.split('.')[0], 10) === 6) {
        var File = require('babel-core/lib/transformation/file/index.js').File;
        File.prototype.initOptions = (function (original) {
            return function (opt) {
                var before = opt.sourceMaps;
                var result = original.apply(this, arguments);
                if (opt.sourceMaps != null && opt.sourceMaps !== result.sourceMaps) {
                    result.sourceMaps = opt.sourceMaps;
                }
                return result;
            };
        })(File.prototype.initOptions);
    }
    istanbulPlugin = imports_1.importBabelPluginIstanbul();
    jestPreset = imports_1.importBabelPresetJest();
}
function postProcessCode(jestConfig, transformOptions, transpileOutput, filePath) {
    var postHook = exports.getPostProcessHook(jestConfig);
    return postHook(transpileOutput, filePath, jestConfig, transformOptions);
}
exports.postProcessCode = postProcessCode;
function createBabelTransformer(options) {
    importBabelDeps();
    var presets = options.presets.slice();
    var plugins = options.plugins.slice();
    if (!hasBabelAddon(presets, jestPreset)) {
        presets.push(jestPreset);
    }
    var hasIstanbul = hasBabelAddon(plugins, istanbulPlugin);
    var optionsBase = __assign({}, options, { presets: presets, plugins: plugins });
    delete optionsBase.cacheDirectory;
    var babelTransformer = function (codeSourcemapPair, filename, config, transformOptions) {
        var inputSourceMap = typeof codeSourcemapPair.map === 'string'
            ? JSON.parse(codeSourcemapPair.map)
            : codeSourcemapPair.map;
        var theseOptions = __assign({}, optionsBase, { filename: filename,
            inputSourceMap: inputSourceMap });
        if (transformOptions && transformOptions.instrument) {
            theseOptions.auxiliaryCommentBefore = ' istanbul ignore next ';
            if (!hasIstanbul) {
                theseOptions.plugins = theseOptions.plugins.concat([
                    istanbulPluginConfig(config),
                ]);
            }
        }
        return babel.transform(codeSourcemapPair.code, theseOptions);
    };
    return babelTransformer;
}
exports.getPostProcessHook = function (jestConfig) {
    var tsJestConfig = get_ts_jest_config_1.default(jestConfig);
    if (tsJestConfig.skipBabel) {
        logger_1.logOnce('Not using any postprocess hook.');
        return function (input) { return input; };
    }
    var tsJestBabelConfig = tsJestConfig.babelConfig || {};
    var babelOptions = __assign({}, tsJestBabelConfig, { babelrc: tsJestConfig.useBabelrc || false, plugins: toArray(tsJestBabelConfig.plugins), presets: toArray(tsJestBabelConfig.presets), sourceMaps: tsJestConfig.disableSourceMapSupport ? false : 'both' });
    logger_1.logOnce('Using babel with options:', babelOptions);
    return createBabelTransformer(babelOptions);
};
function toArray(iter) {
    return iter ? Array.from(iter) : [];
}
function istanbulPluginConfig(jestConfig) {
    return [
        istanbulPlugin,
        {
            cwd: jestConfig.rootDir,
            exclude: [],
        },
    ];
}
function hasBabelAddon(inputList) {
    var addonMatches = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        addonMatches[_i - 1] = arguments[_i];
    }
    return inputList.some(function (item) {
        return addonMatches.indexOf(Array.isArray(item) ? item[0] : item) !== -1;
    });
}
//# sourceMappingURL=data:application/json;base64,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