'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});
exports.default = void 0;

function _events() {
  const data = _interopRequireDefault(require('events'));

  _events = function _events() {
    return data;
  };

  return data;
}

function _interopRequireDefault(obj) {
  return obj && obj.__esModule ? obj : {default: obj};
}

/**
 * Copyright (c) Facebook, Inc. and its affiliates. All Rights Reserved.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 *
 */
class TestWatcher extends _events().default {
  constructor({isWatchMode}) {
    super();
    this.state = {
      interrupted: false
    };
    this._isWatchMode = isWatchMode;
  }

  setState(state) {
    Object.assign(this.state, state);
    this.emit('change', this.state);
  }

  isInterrupted() {
    return this.state.interrupted;
  }

  isWatchMode() {
    return this._isWatchMode;
  }
}

exports.default = TestWatcher;
