"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const config_1 = require("../utility/config");
const workspace_models_1 = require("../utility/workspace-models");
/**
 * Build a default project path for generating.
 * @param project The project to build the path for.
 */
function buildDefaultPath(project) {
    const root = project.sourceRoot
        ? `/${project.sourceRoot}/`
        : `/${project.root}/src/`;
    const projectDirName = project.projectType === workspace_models_1.ProjectType.Application ? 'app' : 'lib';
    return `${root}${projectDirName}`;
}
exports.buildDefaultPath = buildDefaultPath;
function getProject(workspaceOrHost, projectName) {
    const workspace = isWorkspaceSchema(workspaceOrHost)
        ? workspaceOrHost
        : config_1.getWorkspace(workspaceOrHost);
    return workspace.projects[projectName];
}
exports.getProject = getProject;
// TODO(hans): change this any to unknown when google3 supports TypeScript 3.0.
// tslint:disable-next-line:no-any
function isWorkspaceSchema(workspace) {
    return !!(workspace && workspace.projects);
}
exports.isWorkspaceSchema = isWorkspaceSchema;
// TODO(hans): change this any to unknown when google3 supports TypeScript 3.0.
// tslint:disable-next-line:no-any
function isWorkspaceProject(project) {
    return !!(project && project.projectType);
}
exports.isWorkspaceProject = isWorkspaceProject;
//# sourceMappingURL=data:application/json;base64,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