"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const electron_1 = require("electron");
const electron_util_1 = require("electron-util");
const config_1 = require("./config");
const tray_1 = require("./tray");
const menuBarShortcut = 'Command+Shift+y';
function toggleMenuBarMode(window) {
    const isEnabled = config_1.default.get('menuBarMode');
    const menuItem = electron_1.Menu.getApplicationMenu().getMenuItemById('menuBarMode');
    menuItem.checked = isEnabled;
    window.setVisibleOnAllWorkspaces(isEnabled);
    if (isEnabled) {
        electron_1.globalShortcut.register(menuBarShortcut, () => {
            if (window.isVisible()) {
                window.hide();
            }
            else {
                window.show();
            }
        });
        tray_1.default.create(window);
    }
    else {
        electron_1.globalShortcut.unregister(menuBarShortcut);
        tray_1.default.destroy();
        electron_1.app.dock.show();
        window.show();
    }
}
exports.toggleMenuBarMode = toggleMenuBarMode;
function setUpMenuBarMode(window) {
    if (electron_util_1.is.macos) {
        toggleMenuBarMode(window);
    }
    else if (config_1.default.get('showTrayIcon') && !config_1.default.get('quitOnWindowClose')) {
        tray_1.default.create(window);
    }
}
exports.setUpMenuBarMode = setUpMenuBarMode;
