/*
 * Copyright © 2012 - 2014 Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
 */
#ifndef __OCL_MATH_20_H__
#define __OCL_MATH_20_H__

#include "ocl_types.h"
#include "ocl_math_common.h"

OVERLOADABLE float lgamma_r(float x, int *signgamp);
OVERLOADABLE float sincos(float x, float *cosval);
OVERLOADABLE float modf(float x, float *i);
OVERLOADABLE float frexp(float x, int *exp);
OVERLOADABLE float fract(float x, float *p);
OVERLOADABLE float remquo(float x, float y, int *quo);

OVERLOADABLE half lgamma_r(half x, int *signgamp);
OVERLOADABLE half sincos(half x, half *cosval);
OVERLOADABLE half frexp(half x, int *exp);
OVERLOADABLE half modf(half x, half *i);
OVERLOADABLE half fract(half x, half *p);
OVERLOADABLE half remquo(half x, half y, int *quo);

//------- double -----------
OVERLOADABLE double fract(double x, double *p);
OVERLOADABLE double frexp(double x, int *exp);
OVERLOADABLE double lgamma_r(double x, int *signgamp);
OVERLOADABLE double modf(double x, double *i);
OVERLOADABLE double remquo(double x, double y, int *quo);
OVERLOADABLE double sincos(double x, double *cosval);

//Begin from this part is autogenerated.
//Don't modify it manually.
//math builtin functions
//gentype fract (gentype x, __generic gentype *iptr)

OVERLOADABLE float2 fract (float2 param0, __generic float2 *param1);
OVERLOADABLE float3 fract (float3 param0, __generic float3 *param1);
OVERLOADABLE float4 fract (float4 param0, __generic float4 *param1);
OVERLOADABLE float8 fract (float8 param0, __generic float8 *param1);
OVERLOADABLE float16 fract (float16 param0, __generic float16 *param1);
OVERLOADABLE double2 fract (double2 param0, __generic double2 *param1);
OVERLOADABLE double3 fract (double3 param0, __generic double3 *param1);
OVERLOADABLE double4 fract (double4 param0, __generic double4 *param1);
OVERLOADABLE double8 fract (double8 param0, __generic double8 *param1);
OVERLOADABLE double16 fract (double16 param0, __generic double16 *param1);
OVERLOADABLE half2 fract (half2 param0, __generic half2 *param1);
OVERLOADABLE half3 fract (half3 param0, __generic half3 *param1);
OVERLOADABLE half4 fract (half4 param0, __generic half4 *param1);
OVERLOADABLE half8 fract (half8 param0, __generic half8 *param1);
OVERLOADABLE half16 fract (half16 param0, __generic half16 *param1);

//floatn frexp (floatn x, __generic intn *exp)

OVERLOADABLE float2 frexp (float2 param0, __generic int2 *param1);
OVERLOADABLE float3 frexp (float3 param0, __generic int3 *param1);
OVERLOADABLE float4 frexp (float4 param0, __generic int4 *param1);
OVERLOADABLE float8 frexp (float8 param0, __generic int8 *param1);
OVERLOADABLE float16 frexp (float16 param0, __generic int16 *param1);

//float frexp (float x, __generic int *exp)


//halfn frexp (halfn x, __generic intn *exp)

OVERLOADABLE half2 frexp (half2 param0, __generic int2 *param1);
OVERLOADABLE half3 frexp (half3 param0, __generic int3 *param1);
OVERLOADABLE half4 frexp (half4 param0, __generic int4 *param1);
OVERLOADABLE half8 frexp (half8 param0, __generic int8 *param1);
OVERLOADABLE half16 frexp (half16 param0, __generic int16 *param1);

//half frexp (half x, __generic int *exp)


//doublen frexp (doublen x, __generic intn *exp)

OVERLOADABLE double2 frexp (double2 param0, __generic int2 *param1);
OVERLOADABLE double3 frexp (double3 param0, __generic int3 *param1);
OVERLOADABLE double4 frexp (double4 param0, __generic int4 *param1);
OVERLOADABLE double8 frexp (double8 param0, __generic int8 *param1);
OVERLOADABLE double16 frexp (double16 param0, __generic int16 *param1);

//double frexp (double x, __generic int *exp)


//floatn lgamma_r (floatn x, __generic intn *signp)

OVERLOADABLE float2 lgamma_r (float2 param0, __generic int2 *param1);
OVERLOADABLE float3 lgamma_r (float3 param0, __generic int3 *param1);
OVERLOADABLE float4 lgamma_r (float4 param0, __generic int4 *param1);
OVERLOADABLE float8 lgamma_r (float8 param0, __generic int8 *param1);
OVERLOADABLE float16 lgamma_r (float16 param0, __generic int16 *param1);

//float lgamma_r (float x, __generic int *signp)


//halfn lgamma_r (halfn x, __generic intn *signp)

OVERLOADABLE half2 lgamma_r (half2 param0, __generic int2 *param1);
OVERLOADABLE half3 lgamma_r (half3 param0, __generic int3 *param1);
OVERLOADABLE half4 lgamma_r (half4 param0, __generic int4 *param1);
OVERLOADABLE half8 lgamma_r (half8 param0, __generic int8 *param1);
OVERLOADABLE half16 lgamma_r (half16 param0, __generic int16 *param1);

//half lgamma_r (half x, __generic int *signp)


//doublen lgamma_r (doublen x, __generic intn *signp)

OVERLOADABLE double2 lgamma_r (double2 param0, __generic int2 *param1);
OVERLOADABLE double3 lgamma_r (double3 param0, __generic int3 *param1);
OVERLOADABLE double4 lgamma_r (double4 param0, __generic int4 *param1);
OVERLOADABLE double8 lgamma_r (double8 param0, __generic int8 *param1);
OVERLOADABLE double16 lgamma_r (double16 param0, __generic int16 *param1);

//double lgamma_r (double x, __generic int *signp)


//gentype modf (gentype x, __generic gentype *iptr)

OVERLOADABLE float2 modf (float2 param0, __generic float2 *param1);
OVERLOADABLE float3 modf (float3 param0, __generic float3 *param1);
OVERLOADABLE float4 modf (float4 param0, __generic float4 *param1);
OVERLOADABLE float8 modf (float8 param0, __generic float8 *param1);
OVERLOADABLE float16 modf (float16 param0, __generic float16 *param1);
OVERLOADABLE double2 modf (double2 param0, __generic double2 *param1);
OVERLOADABLE double3 modf (double3 param0, __generic double3 *param1);
OVERLOADABLE double4 modf (double4 param0, __generic double4 *param1);
OVERLOADABLE double8 modf (double8 param0, __generic double8 *param1);
OVERLOADABLE double16 modf (double16 param0, __generic double16 *param1);
OVERLOADABLE half2 modf (half2 param0, __generic half2 *param1);
OVERLOADABLE half3 modf (half3 param0, __generic half3 *param1);
OVERLOADABLE half4 modf (half4 param0, __generic half4 *param1);
OVERLOADABLE half8 modf (half8 param0, __generic half8 *param1);
OVERLOADABLE half16 modf (half16 param0, __generic half16 *param1);

//floatn remquo (floatn x, floatn y, __generic intn *quo)

OVERLOADABLE float2 remquo (float2 param0, float2 param1, __generic int2 *param2);
OVERLOADABLE float3 remquo (float3 param0, float3 param1, __generic int3 *param2);
OVERLOADABLE float4 remquo (float4 param0, float4 param1, __generic int4 *param2);
OVERLOADABLE float8 remquo (float8 param0, float8 param1, __generic int8 *param2);
OVERLOADABLE float16 remquo (float16 param0, float16 param1, __generic int16 *param2);

//float remquo (float x, float y, __generic int *quo)


//halfn remquo (halfn x, halfn y, __generic intn *quo)

OVERLOADABLE half2 remquo (half2 param0, half2 param1, __generic int2 *param2);
OVERLOADABLE half3 remquo (half3 param0, half3 param1, __generic int3 *param2);
OVERLOADABLE half4 remquo (half4 param0, half4 param1, __generic int4 *param2);
OVERLOADABLE half8 remquo (half8 param0, half8 param1, __generic int8 *param2);
OVERLOADABLE half16 remquo (half16 param0, half16 param1, __generic int16 *param2);

//half remquo (half x, half y, __generic int *quo)


//doublen remquo (doublen x, doublen y, __generic intn *quo)

OVERLOADABLE double2 remquo (double2 param0, double2 param1, __generic int2 *param2);
OVERLOADABLE double3 remquo (double3 param0, double3 param1, __generic int3 *param2);
OVERLOADABLE double4 remquo (double4 param0, double4 param1, __generic int4 *param2);
OVERLOADABLE double8 remquo (double8 param0, double8 param1, __generic int8 *param2);
OVERLOADABLE double16 remquo (double16 param0, double16 param1, __generic int16 *param2);

//double remquo (double x, double y, __generic int *quo)


//gentype sincos (gentype x, __generic gentype *cosval)

OVERLOADABLE float2 sincos (float2 param0, __generic float2 *param1);
OVERLOADABLE float3 sincos (float3 param0, __generic float3 *param1);
OVERLOADABLE float4 sincos (float4 param0, __generic float4 *param1);
OVERLOADABLE float8 sincos (float8 param0, __generic float8 *param1);
OVERLOADABLE float16 sincos (float16 param0, __generic float16 *param1);
OVERLOADABLE double2 sincos (double2 param0, __generic double2 *param1);
OVERLOADABLE double3 sincos (double3 param0, __generic double3 *param1);
OVERLOADABLE double4 sincos (double4 param0, __generic double4 *param1);
OVERLOADABLE double8 sincos (double8 param0, __generic double8 *param1);
OVERLOADABLE double16 sincos (double16 param0, __generic double16 *param1);
OVERLOADABLE half2 sincos (half2 param0, __generic half2 *param1);
OVERLOADABLE half3 sincos (half3 param0, __generic half3 *param1);
OVERLOADABLE half4 sincos (half4 param0, __generic half4 *param1);
OVERLOADABLE half8 sincos (half8 param0, __generic half8 *param1);
OVERLOADABLE half16 sincos (half16 param0, __generic half16 *param1);

#endif
