/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.BootstrapMethodInfo;
import proguard.classfile.attribute.BootstrapMethodsAttribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.editor.BootstrapMethodRemapper;
import proguard.classfile.editor.ConstantPoolRemapper;
import proguard.classfile.editor.InterfaceDeleter;
import proguard.classfile.util.DescriptorClassEnumeration;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.shrink.UsageMarker;

public class ClassShrinker
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor,
AttributeVisitor,
AnnotationVisitor,
ElementValueVisitor {
    private final UsageMarker usageMarker;
    private int[] constantIndexMap = new int[256];
    private int[] bootstrapMethodIndexMap = new int[256];
    private final ConstantPoolRemapper constantPoolRemapper = new ConstantPoolRemapper();
    private final BootstrapMethodRemapper bootstrapMethodRemapper = new BootstrapMethodRemapper();

    public ClassShrinker(UsageMarker usageMarker) {
        this.usageMarker = usageMarker;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        if (programClass.u2interfacesCount > 0) {
            new InterfaceDeleter(this.shrinkFlags(programClass.constantPool, programClass.u2interfaces, programClass.u2interfacesCount)).visitProgramClass(programClass);
        }
        int n = this.shrinkConstantPool(programClass.constantPool, programClass.u2constantPoolCount);
        programClass.u2fieldsCount = this.shrinkArray(programClass.fields, programClass.u2fieldsCount);
        programClass.u2methodsCount = this.shrinkArray(programClass.methods, programClass.u2methodsCount);
        programClass.u2attributesCount = this.shrinkArray(programClass.attributes, programClass.u2attributesCount);
        programClass.fieldsAccept(this);
        programClass.methodsAccept(this);
        programClass.attributesAccept(this);
        if (n < programClass.u2constantPoolCount) {
            programClass.u2constantPoolCount = n;
            this.constantPoolRemapper.setConstantIndexMap(this.constantIndexMap);
            this.constantPoolRemapper.visitProgramClass(programClass);
        }
        MySignatureCleaner mySignatureCleaner = new MySignatureCleaner();
        programClass.fieldsAccept(new AllAttributeVisitor(mySignatureCleaner));
        programClass.methodsAccept(new AllAttributeVisitor(mySignatureCleaner));
        programClass.attributesAccept(mySignatureCleaner);
        programClass.subClasses = this.shrinkToNewArray(programClass.subClasses);
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        libraryClass.subClasses = this.shrinkToNewArray(libraryClass.subClasses);
    }

    @Override
    public void visitProgramMember(ProgramClass programClass, ProgramMember programMember) {
        programMember.u2attributesCount = this.shrinkArray(programMember.attributes, programMember.u2attributesCount);
        programMember.attributesAccept(programClass, this);
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitBootstrapMethodsAttribute(Clazz clazz, BootstrapMethodsAttribute bootstrapMethodsAttribute) {
        int n = this.shrinkBootstrapMethodArray(bootstrapMethodsAttribute.bootstrapMethods, bootstrapMethodsAttribute.u2bootstrapMethodsCount);
        if (n < bootstrapMethodsAttribute.u2bootstrapMethodsCount) {
            bootstrapMethodsAttribute.u2bootstrapMethodsCount = n;
            this.bootstrapMethodRemapper.setConstantIndexMap(this.bootstrapMethodIndexMap);
            clazz.constantPoolEntriesAccept(this.bootstrapMethodRemapper);
        }
    }

    @Override
    public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
        innerClassesAttribute.u2classesCount = this.shrinkArray(innerClassesAttribute.classes, innerClassesAttribute.u2classesCount);
    }

    @Override
    public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
        if (enclosingMethodAttribute.referencedMethod != null && !this.usageMarker.isUsed(enclosingMethodAttribute.referencedMethod)) {
            enclosingMethodAttribute.u2nameAndTypeIndex = 0;
            enclosingMethodAttribute.referencedMethod = null;
        }
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.u2attributesCount = this.shrinkArray(codeAttribute.attributes, codeAttribute.u2attributesCount);
        codeAttribute.attributesAccept(clazz, method, this);
    }

    @Override
    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        localVariableTableAttribute.u2localVariableTableLength = this.shrinkArray(localVariableTableAttribute.localVariableTable, localVariableTableAttribute.u2localVariableTableLength);
    }

    @Override
    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        localVariableTypeTableAttribute.u2localVariableTypeTableLength = this.shrinkArray(localVariableTypeTableAttribute.localVariableTypeTable, localVariableTypeTableAttribute.u2localVariableTypeTableLength);
    }

    @Override
    public void visitAnyAnnotationsAttribute(Clazz clazz, AnnotationsAttribute annotationsAttribute) {
        annotationsAttribute.u2annotationsCount = this.shrinkArray(annotationsAttribute.annotations, annotationsAttribute.u2annotationsCount);
        annotationsAttribute.annotationsAccept(clazz, this);
    }

    @Override
    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        for (int i = 0; i < parameterAnnotationsAttribute.u1parametersCount; ++i) {
            parameterAnnotationsAttribute.u2parameterAnnotationsCount[i] = this.shrinkArray(parameterAnnotationsAttribute.parameterAnnotations[i], parameterAnnotationsAttribute.u2parameterAnnotationsCount[i]);
        }
        parameterAnnotationsAttribute.annotationsAccept(clazz, method, this);
    }

    @Override
    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        annotation.u2elementValuesCount = this.shrinkArray(annotation.elementValues, annotation.u2elementValuesCount);
        annotation.elementValuesAccept(clazz, this);
    }

    @Override
    public void visitAnyElementValue(Clazz clazz, Annotation annotation, ElementValue elementValue) {
    }

    @Override
    public void visitAnnotationElementValue(Clazz clazz, Annotation annotation, AnnotationElementValue annotationElementValue) {
        annotationElementValue.annotationAccept(clazz, this);
    }

    @Override
    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        arrayElementValue.u2elementValuesCount = this.shrinkArray(arrayElementValue.elementValues, arrayElementValue.u2elementValuesCount);
        arrayElementValue.elementValuesAccept(clazz, annotation, this);
    }

    private int shrinkConstantPool(Constant[] constantArray, int n) {
        if (this.constantIndexMap.length < n) {
            this.constantIndexMap = new int[n];
        }
        int n2 = 1;
        boolean bl = false;
        for (int i = 1; i < n; ++i) {
            this.constantIndexMap[i] = n2;
            Constant constant = constantArray[i];
            if (constant != null) {
                bl = this.usageMarker.isUsed(constant);
            }
            if (bl) {
                this.constantIndexMap[i] = n2;
                constantArray[n2++] = constant;
                continue;
            }
            this.constantIndexMap[i] = -1;
        }
        Arrays.fill(constantArray, n2, n, null);
        return n2;
    }

    private boolean[] shrinkFlags(Constant[] constantArray, int[] nArray, int n) {
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            if (this.usageMarker.isUsed(constantArray[nArray[i]])) continue;
            blArray[i] = true;
        }
        return blArray;
    }

    private int shrinkConstantIndexArray(Constant[] constantArray, int[] nArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!this.usageMarker.isUsed(constantArray[nArray[i]])) continue;
            nArray[n2++] = nArray[i];
        }
        Arrays.fill(nArray, n2, n, 0);
        return n2;
    }

    private Clazz[] shrinkToNewArray(Clazz[] clazzArray) {
        if (clazzArray == null) {
            return null;
        }
        int n = this.shrinkArray(clazzArray, clazzArray.length);
        if (n == 0) {
            return null;
        }
        if (n == clazzArray.length) {
            return clazzArray;
        }
        Clazz[] clazzArray2 = new Clazz[n];
        System.arraycopy(clazzArray, 0, clazzArray2, 0, n);
        return clazzArray2;
    }

    private int shrinkBootstrapMethodArray(BootstrapMethodInfo[] bootstrapMethodInfoArray, int n) {
        if (this.bootstrapMethodIndexMap.length < n) {
            this.bootstrapMethodIndexMap = new int[n];
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            BootstrapMethodInfo bootstrapMethodInfo = bootstrapMethodInfoArray[i];
            if (this.usageMarker.isUsed(bootstrapMethodInfo)) {
                this.bootstrapMethodIndexMap[i] = n2;
                bootstrapMethodInfoArray[n2++] = bootstrapMethodInfo;
                continue;
            }
            this.bootstrapMethodIndexMap[i] = -1;
        }
        Arrays.fill(bootstrapMethodInfoArray, n2, n, null);
        return n2;
    }

    private int shrinkArray(VisitorAccepter[] visitorAccepterArray, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            VisitorAccepter visitorAccepter = visitorAccepterArray[i];
            if (!this.usageMarker.isUsed(visitorAccepter)) continue;
            visitorAccepterArray[n2++] = visitorAccepter;
        }
        if (n2 < n) {
            Arrays.fill(visitorAccepterArray, n2, n, null);
        }
        return n2;
    }

    private class MySignatureCleaner
    extends SimplifiedVisitor
    implements AttributeVisitor {
        private MySignatureCleaner() {
        }

        @Override
        public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        }

        @Override
        public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
            Clazz[] clazzArray = signatureAttribute.referencedClasses;
            if (clazzArray != null) {
                String string = signatureAttribute.getSignature(clazz);
                DescriptorClassEnumeration descriptorClassEnumeration = new DescriptorClassEnumeration(string);
                int n = 0;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(descriptorClassEnumeration.nextFluff());
                while (descriptorClassEnumeration.hasMoreClassNames()) {
                    String string2 = descriptorClassEnumeration.nextClassName();
                    Clazz clazz2 = clazzArray[n];
                    if (clazz2 != null && !ClassShrinker.this.usageMarker.isUsed(clazz2)) {
                        string2 = "java/lang/Object";
                        clazzArray[n] = null;
                    } else if (descriptorClassEnumeration.isInnerClassName()) {
                        string2 = string2.substring(string2.lastIndexOf(36) + 1);
                    }
                    ++n;
                    stringBuffer.append(string2);
                    stringBuffer.append(descriptorClassEnumeration.nextFluff());
                }
                ((Utf8Constant)((ProgramClass)clazz).constantPool[signatureAttribute.u2signatureIndex]).setString(stringBuffer.toString());
            }
        }
    }
}

