/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.MandatoryWarningHandler;
import com.sun.tools.javac.util.Options;
import java.util.HashMap;
import java.util.Map;
import javax.tools.JavaFileObject;

public class Preview {
    private final boolean enabled;
    private final MandatoryWarningHandler previewHandler;
    private final boolean forcePreview;
    private final Map<Integer, Source> majorVersionToSource;
    private final Lint lint;
    private final Log log;
    private static final Context.Key<Preview> previewKey = new Context.Key();

    public static Preview instance(Context context) {
        Preview instance = context.get(previewKey);
        if (instance == null) {
            instance = new Preview(context);
        }
        return instance;
    }

    Preview(Context context) {
        context.put(previewKey, this);
        Options options = Options.instance(context);
        this.enabled = options.isSet(Option.PREVIEW);
        this.log = Log.instance(context);
        this.lint = Lint.instance(context);
        this.previewHandler = new MandatoryWarningHandler(this.log, this.lint.isEnabled(Lint.LintCategory.PREVIEW), true, "preview", Lint.LintCategory.PREVIEW);
        this.forcePreview = options.isSet("forcePreview");
        this.majorVersionToSource = this.initMajorVersionToSourceMap();
    }

    private Map<Integer, Source> initMajorVersionToSourceMap() {
        HashMap<Integer, Source> majorVersionToSource = new HashMap<Integer, Source>();
        for (Target t : Target.values()) {
            int major = t.majorVersion;
            Source source = Source.lookup(t.name);
            if (source == null) continue;
            majorVersionToSource.put(major, source);
        }
        return majorVersionToSource;
    }

    public void warnPreview(int pos, Source.Feature feature) {
        this.warnPreview(new JCDiagnostic.SimpleDiagnosticPosition(pos), feature);
    }

    public void warnPreview(JCDiagnostic.DiagnosticPosition pos, Source.Feature feature) {
        Assert.check(this.isEnabled());
        Assert.check(this.isPreview(feature));
        if (!this.lint.isSuppressed(Lint.LintCategory.PREVIEW)) {
            this.previewHandler.report(pos, feature.isPlural() ? CompilerProperties.Warnings.PreviewFeatureUsePlural(feature.nameFragment()) : CompilerProperties.Warnings.PreviewFeatureUse(feature.nameFragment()));
        }
    }

    public void warnPreview(JavaFileObject classfile, int majorVersion) {
        Assert.check(this.isEnabled());
        if (!this.lint.isSuppressed(Lint.LintCategory.PREVIEW)) {
            this.previewHandler.report(null, CompilerProperties.Warnings.PreviewFeatureUseClassfile(classfile, this.majorVersionToSource.get((Object)Integer.valueOf((int)majorVersion)).name));
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isPreview(Source.Feature feature) {
        return this.forcePreview;
    }

    public JCDiagnostic.Error disabledError(Source.Feature feature) {
        Assert.check(!this.isEnabled());
        return feature.isPlural() ? CompilerProperties.Errors.PreviewFeatureDisabledPlural(feature.nameFragment()) : CompilerProperties.Errors.PreviewFeatureDisabled(feature.nameFragment());
    }

    public JCDiagnostic.Error disabledError(JavaFileObject classfile, int majorVersion) {
        Assert.check(!this.isEnabled());
        return CompilerProperties.Errors.PreviewFeatureDisabledClassfile(classfile, this.majorVersionToSource.get((Object)Integer.valueOf((int)majorVersion)).name);
    }

    public void reportDeferredDiagnostics() {
        this.previewHandler.reportDeferredDiagnostic();
    }
}

