(function() {
  var CommentScopeRegex, Token, TokenizedLine, idCounter, isWhitespaceOnly;

  Token = require('./token');

  CommentScopeRegex = /(\b|\.)comment/;

  idCounter = 1;

  module.exports = TokenizedLine = (function() {
    function TokenizedLine(properties) {
      var tokens;
      this.id = idCounter++;
      if (properties == null) {
        return;
      }
      this.openScopes = properties.openScopes, this.text = properties.text, this.tags = properties.tags, this.ruleStack = properties.ruleStack, this.tokenIterator = properties.tokenIterator, this.grammar = properties.grammar, tokens = properties.tokens;
      this.cachedTokens = tokens;
    }

    TokenizedLine.prototype.getTokenIterator = function() {
      return this.tokenIterator.reset(this);
    };

    Object.defineProperty(TokenizedLine.prototype, 'tokens', {
      get: function() {
        var iterator, tokens;
        if (this.cachedTokens) {
          return this.cachedTokens;
        } else {
          iterator = this.getTokenIterator();
          tokens = [];
          while (iterator.next()) {
            tokens.push(new Token({
              value: iterator.getText(),
              scopes: iterator.getScopes().slice()
            }));
          }
          return tokens;
        }
      }
    });

    TokenizedLine.prototype.tokenAtBufferColumn = function(bufferColumn) {
      return this.tokens[this.tokenIndexAtBufferColumn(bufferColumn)];
    };

    TokenizedLine.prototype.tokenIndexAtBufferColumn = function(bufferColumn) {
      var column, i, index, len, ref, token;
      column = 0;
      ref = this.tokens;
      for (index = i = 0, len = ref.length; i < len; index = ++i) {
        token = ref[index];
        column += token.value.length;
        if (column > bufferColumn) {
          return index;
        }
      }
      return index - 1;
    };

    TokenizedLine.prototype.tokenStartColumnForBufferColumn = function(bufferColumn) {
      var delta, i, len, nextDelta, ref, token;
      delta = 0;
      ref = this.tokens;
      for (i = 0, len = ref.length; i < len; i++) {
        token = ref[i];
        nextDelta = delta + token.bufferDelta;
        if (nextDelta > bufferColumn) {
          break;
        }
        delta = nextDelta;
      }
      return delta;
    };

    TokenizedLine.prototype.isComment = function() {
      var i, j, len, len1, ref, ref1, startIndex, tag;
      if (this.isCommentLine != null) {
        return this.isCommentLine;
      }
      this.isCommentLine = false;
      ref = this.openScopes;
      for (i = 0, len = ref.length; i < len; i++) {
        tag = ref[i];
        if (this.isCommentOpenTag(tag)) {
          this.isCommentLine = true;
          return this.isCommentLine;
        }
      }
      startIndex = 0;
      ref1 = this.tags;
      for (j = 0, len1 = ref1.length; j < len1; j++) {
        tag = ref1[j];
        if (tag > 0) {
          if (!isWhitespaceOnly(this.text.substr(startIndex, tag))) {
            break;
          }
          startIndex += tag;
        }
        if (this.isCommentOpenTag(tag)) {
          this.isCommentLine = true;
          return this.isCommentLine;
        }
      }
      return this.isCommentLine;
    };

    TokenizedLine.prototype.isCommentOpenTag = function(tag) {
      var scope;
      if (tag < 0 && (tag & 1) === 1) {
        scope = this.grammar.scopeForId(tag);
        if (CommentScopeRegex.test(scope)) {
          return true;
        }
      }
      return false;
    };

    TokenizedLine.prototype.tokenAtIndex = function(index) {
      return this.tokens[index];
    };

    TokenizedLine.prototype.getTokenCount = function() {
      var count, i, len, ref, tag;
      count = 0;
      ref = this.tags;
      for (i = 0, len = ref.length; i < len; i++) {
        tag = ref[i];
        if (tag >= 0) {
          count++;
        }
      }
      return count;
    };

    return TokenizedLine;

  })();

  isWhitespaceOnly = function(text) {
    var char, i, len;
    for (i = 0, len = text.length; i < len; i++) {
      char = text[i];
      if (char !== '\t' && char !== ' ') {
        return false;
      }
    }
    return true;
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
