(function() {
  var ChildProcess, Emitter, Grim, Task, _,
    slice = [].slice;

  _ = require('underscore-plus');

  ChildProcess = require('child_process');

  Emitter = require('event-kit').Emitter;

  Grim = require('grim');

  module.exports = Task = (function() {
    Task.once = function() {
      var args, task, taskPath;
      taskPath = arguments[0], args = 2 <= arguments.length ? slice.call(arguments, 1) : [];
      task = new Task(taskPath);
      task.once('task:completed', function() {
        return task.terminate();
      });
      task.start.apply(task, args);
      return task;
    };

    Task.prototype.callback = null;

    function Task(taskPath) {
      var compileCachePath, env;
      this.emitter = new Emitter;
      compileCachePath = require('./compile-cache').getCacheDirectory();
      taskPath = require.resolve(taskPath);
      env = Object.assign({}, process.env, {
        userAgent: navigator.userAgent
      });
      this.childProcess = ChildProcess.fork(require.resolve('./task-bootstrap'), [compileCachePath, taskPath], {
        env: env,
        silent: true
      });
      this.on("task:log", function() {
        return console.log.apply(console, arguments);
      });
      this.on("task:warn", function() {
        return console.warn.apply(console, arguments);
      });
      this.on("task:error", function() {
        return console.error.apply(console, arguments);
      });
      this.on("task:deprecations", function(deprecations) {
        var deprecation, i, len;
        for (i = 0, len = deprecations.length; i < len; i++) {
          deprecation = deprecations[i];
          Grim.addSerializedDeprecation(deprecation);
        }
      });
      this.on("task:completed", (function(_this) {
        return function() {
          var args;
          args = 1 <= arguments.length ? slice.call(arguments, 0) : [];
          return typeof _this.callback === "function" ? _this.callback.apply(_this, args) : void 0;
        };
      })(this));
      this.handleEvents();
    }

    Task.prototype.handleEvents = function() {
      this.childProcess.removeAllListeners('message');
      this.childProcess.on('message', (function(_this) {
        return function(arg) {
          var args, event;
          event = arg.event, args = arg.args;
          if (_this.childProcess != null) {
            return _this.emitter.emit(event, args);
          }
        };
      })(this));
      if (this.childProcess.stdout != null) {
        this.childProcess.stdout.removeAllListeners('data');
        this.childProcess.stdout.on('data', function(data) {
          return console.log(data.toString());
        });
      }
      if (this.childProcess.stderr != null) {
        this.childProcess.stderr.removeAllListeners('data');
        return this.childProcess.stderr.on('data', function(data) {
          return console.error(data.toString());
        });
      }
    };

    Task.prototype.start = function() {
      var args, callback, i;
      args = 2 <= arguments.length ? slice.call(arguments, 0, i = arguments.length - 1) : (i = 0, []), callback = arguments[i++];
      if (this.childProcess == null) {
        throw new Error('Cannot start terminated process');
      }
      this.handleEvents();
      if (_.isFunction(callback)) {
        this.callback = callback;
      } else {
        args.push(callback);
      }
      this.send({
        event: 'start',
        args: args
      });
      return void 0;
    };

    Task.prototype.send = function(message) {
      if (this.childProcess != null) {
        this.childProcess.send(message);
      } else {
        throw new Error('Cannot send message to terminated process');
      }
      return void 0;
    };

    Task.prototype.on = function(eventName, callback) {
      return this.emitter.on(eventName, function(args) {
        return callback.apply(null, args);
      });
    };

    Task.prototype.once = function(eventName, callback) {
      var disposable;
      return disposable = this.on(eventName, function() {
        var args;
        args = 1 <= arguments.length ? slice.call(arguments, 0) : [];
        disposable.dispose();
        return callback.apply(null, args);
      });
    };

    Task.prototype.terminate = function() {
      var ref, ref1;
      if (this.childProcess == null) {
        return false;
      }
      this.childProcess.removeAllListeners('message');
      if ((ref = this.childProcess.stdout) != null) {
        ref.removeAllListeners('data');
      }
      if ((ref1 = this.childProcess.stderr) != null) {
        ref1.removeAllListeners('data');
      }
      this.childProcess.kill();
      this.childProcess = null;
      return true;
    };

    Task.prototype.cancel = function() {
      var didForcefullyTerminate;
      didForcefullyTerminate = this.terminate();
      if (didForcefullyTerminate) {
        this.emitter.emit('task:cancelled');
      }
      return didForcefullyTerminate;
    };

    return Task;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
