(function() {
  var Grim, copyPathToClipboard, ipcRenderer, showCursorScope, showSyntaxTree, stopEventPropagation, stopEventPropagationAndGroupUndo;

  ipcRenderer = require('electron').ipcRenderer;

  Grim = require('grim');

  module.exports = function(arg) {
    var clipboard, commandInstaller, commandRegistry, config, notificationManager, project;
    commandRegistry = arg.commandRegistry, commandInstaller = arg.commandInstaller, config = arg.config, notificationManager = arg.notificationManager, project = arg.project, clipboard = arg.clipboard;
    commandRegistry.add('atom-workspace', {
      'pane:show-next-recently-used-item': function() {
        return this.getModel().getActivePane().activateNextRecentlyUsedItem();
      },
      'pane:show-previous-recently-used-item': function() {
        return this.getModel().getActivePane().activatePreviousRecentlyUsedItem();
      },
      'pane:move-active-item-to-top-of-stack': function() {
        return this.getModel().getActivePane().moveActiveItemToTopOfStack();
      },
      'pane:show-next-item': function() {
        return this.getModel().getActivePane().activateNextItem();
      },
      'pane:show-previous-item': function() {
        return this.getModel().getActivePane().activatePreviousItem();
      },
      'pane:show-item-1': function() {
        return this.getModel().getActivePane().activateItemAtIndex(0);
      },
      'pane:show-item-2': function() {
        return this.getModel().getActivePane().activateItemAtIndex(1);
      },
      'pane:show-item-3': function() {
        return this.getModel().getActivePane().activateItemAtIndex(2);
      },
      'pane:show-item-4': function() {
        return this.getModel().getActivePane().activateItemAtIndex(3);
      },
      'pane:show-item-5': function() {
        return this.getModel().getActivePane().activateItemAtIndex(4);
      },
      'pane:show-item-6': function() {
        return this.getModel().getActivePane().activateItemAtIndex(5);
      },
      'pane:show-item-7': function() {
        return this.getModel().getActivePane().activateItemAtIndex(6);
      },
      'pane:show-item-8': function() {
        return this.getModel().getActivePane().activateItemAtIndex(7);
      },
      'pane:show-item-9': function() {
        return this.getModel().getActivePane().activateLastItem();
      },
      'pane:move-item-right': function() {
        return this.getModel().getActivePane().moveItemRight();
      },
      'pane:move-item-left': function() {
        return this.getModel().getActivePane().moveItemLeft();
      },
      'window:increase-font-size': function() {
        return this.getModel().increaseFontSize();
      },
      'window:decrease-font-size': function() {
        return this.getModel().decreaseFontSize();
      },
      'window:reset-font-size': function() {
        return this.getModel().resetFontSize();
      },
      'application:about': function() {
        return ipcRenderer.send('command', 'application:about');
      },
      'application:show-preferences': function() {
        return ipcRenderer.send('command', 'application:show-settings');
      },
      'application:show-settings': function() {
        return ipcRenderer.send('command', 'application:show-settings');
      },
      'application:quit': function() {
        return ipcRenderer.send('command', 'application:quit');
      },
      'application:hide': function() {
        return ipcRenderer.send('command', 'application:hide');
      },
      'application:hide-other-applications': function() {
        return ipcRenderer.send('command', 'application:hide-other-applications');
      },
      'application:install-update': function() {
        return ipcRenderer.send('command', 'application:install-update');
      },
      'application:unhide-all-applications': function() {
        return ipcRenderer.send('command', 'application:unhide-all-applications');
      },
      'application:new-window': function() {
        return ipcRenderer.send('command', 'application:new-window');
      },
      'application:new-file': function() {
        return ipcRenderer.send('command', 'application:new-file');
      },
      'application:open': function() {
        var defaultPath, ref, ref1, ref2;
        defaultPath = (ref = (ref1 = atom.workspace.getActiveTextEditor()) != null ? ref1.getPath() : void 0) != null ? ref : (ref2 = atom.project.getPaths()) != null ? ref2[0] : void 0;
        return ipcRenderer.send('open-chosen-any', defaultPath);
      },
      'application:open-file': function() {
        var defaultPath, ref, ref1, ref2;
        defaultPath = (ref = (ref1 = atom.workspace.getActiveTextEditor()) != null ? ref1.getPath() : void 0) != null ? ref : (ref2 = atom.project.getPaths()) != null ? ref2[0] : void 0;
        return ipcRenderer.send('open-chosen-file', defaultPath);
      },
      'application:open-folder': function() {
        var defaultPath, ref, ref1, ref2;
        defaultPath = (ref = (ref1 = atom.workspace.getActiveTextEditor()) != null ? ref1.getPath() : void 0) != null ? ref : (ref2 = atom.project.getPaths()) != null ? ref2[0] : void 0;
        return ipcRenderer.send('open-chosen-folder', defaultPath);
      },
      'application:open-dev': function() {
        return ipcRenderer.send('command', 'application:open-dev');
      },
      'application:open-safe': function() {
        return ipcRenderer.send('command', 'application:open-safe');
      },
      'application:add-project-folder': function() {
        return atom.addProjectFolder();
      },
      'application:minimize': function() {
        return ipcRenderer.send('command', 'application:minimize');
      },
      'application:zoom': function() {
        return ipcRenderer.send('command', 'application:zoom');
      },
      'application:bring-all-windows-to-front': function() {
        return ipcRenderer.send('command', 'application:bring-all-windows-to-front');
      },
      'application:open-your-config': function() {
        return ipcRenderer.send('command', 'application:open-your-config');
      },
      'application:open-your-init-script': function() {
        return ipcRenderer.send('command', 'application:open-your-init-script');
      },
      'application:open-your-keymap': function() {
        return ipcRenderer.send('command', 'application:open-your-keymap');
      },
      'application:open-your-snippets': function() {
        return ipcRenderer.send('command', 'application:open-your-snippets');
      },
      'application:open-your-stylesheet': function() {
        return ipcRenderer.send('command', 'application:open-your-stylesheet');
      },
      'application:open-license': function() {
        return this.getModel().openLicense();
      },
      'window:run-package-specs': function() {
        return this.runPackageSpecs();
      },
      'window:run-benchmarks': function() {
        return this.runBenchmarks();
      },
      'window:toggle-left-dock': function() {
        return this.getModel().getLeftDock().toggle();
      },
      'window:toggle-right-dock': function() {
        return this.getModel().getRightDock().toggle();
      },
      'window:toggle-bottom-dock': function() {
        return this.getModel().getBottomDock().toggle();
      },
      'window:focus-next-pane': function() {
        return this.getModel().activateNextPane();
      },
      'window:focus-previous-pane': function() {
        return this.getModel().activatePreviousPane();
      },
      'window:focus-pane-above': function() {
        return this.focusPaneViewAbove();
      },
      'window:focus-pane-below': function() {
        return this.focusPaneViewBelow();
      },
      'window:focus-pane-on-left': function() {
        return this.focusPaneViewOnLeft();
      },
      'window:focus-pane-on-right': function() {
        return this.focusPaneViewOnRight();
      },
      'window:move-active-item-to-pane-above': function() {
        return this.moveActiveItemToPaneAbove();
      },
      'window:move-active-item-to-pane-below': function() {
        return this.moveActiveItemToPaneBelow();
      },
      'window:move-active-item-to-pane-on-left': function() {
        return this.moveActiveItemToPaneOnLeft();
      },
      'window:move-active-item-to-pane-on-right': function() {
        return this.moveActiveItemToPaneOnRight();
      },
      'window:copy-active-item-to-pane-above': function() {
        return this.moveActiveItemToPaneAbove({
          keepOriginal: true
        });
      },
      'window:copy-active-item-to-pane-below': function() {
        return this.moveActiveItemToPaneBelow({
          keepOriginal: true
        });
      },
      'window:copy-active-item-to-pane-on-left': function() {
        return this.moveActiveItemToPaneOnLeft({
          keepOriginal: true
        });
      },
      'window:copy-active-item-to-pane-on-right': function() {
        return this.moveActiveItemToPaneOnRight({
          keepOriginal: true
        });
      },
      'window:save-all': function() {
        return this.getModel().saveAll();
      },
      'window:toggle-invisibles': function() {
        return config.set("editor.showInvisibles", !config.get("editor.showInvisibles"));
      },
      'window:log-deprecation-warnings': function() {
        return Grim.logDeprecations();
      },
      'window:toggle-auto-indent': function() {
        return config.set("editor.autoIndent", !config.get("editor.autoIndent"));
      },
      'pane:reopen-closed-item': function() {
        return this.getModel().reopenItem();
      },
      'core:close': function() {
        return this.getModel().closeActivePaneItemOrEmptyPaneOrWindow();
      },
      'core:save': function() {
        return this.getModel().saveActivePaneItem();
      },
      'core:save-as': function() {
        return this.getModel().saveActivePaneItemAs();
      }
    }, false);
    if (process.platform === 'darwin') {
      commandRegistry.add('atom-workspace', 'window:install-shell-commands', (function() {
        return commandInstaller.installShellCommandsInteractively();
      }), false);
    }
    commandRegistry.add('atom-pane', {
      'pane:save-items': function() {
        return this.getModel().saveItems();
      },
      'pane:split-left': function() {
        return this.getModel().splitLeft();
      },
      'pane:split-right': function() {
        return this.getModel().splitRight();
      },
      'pane:split-up': function() {
        return this.getModel().splitUp();
      },
      'pane:split-down': function() {
        return this.getModel().splitDown();
      },
      'pane:split-left-and-copy-active-item': function() {
        return this.getModel().splitLeft({
          copyActiveItem: true
        });
      },
      'pane:split-right-and-copy-active-item': function() {
        return this.getModel().splitRight({
          copyActiveItem: true
        });
      },
      'pane:split-up-and-copy-active-item': function() {
        return this.getModel().splitUp({
          copyActiveItem: true
        });
      },
      'pane:split-down-and-copy-active-item': function() {
        return this.getModel().splitDown({
          copyActiveItem: true
        });
      },
      'pane:split-left-and-move-active-item': function() {
        return this.getModel().splitLeft({
          moveActiveItem: true
        });
      },
      'pane:split-right-and-move-active-item': function() {
        return this.getModel().splitRight({
          moveActiveItem: true
        });
      },
      'pane:split-up-and-move-active-item': function() {
        return this.getModel().splitUp({
          moveActiveItem: true
        });
      },
      'pane:split-down-and-move-active-item': function() {
        return this.getModel().splitDown({
          moveActiveItem: true
        });
      },
      'pane:close': function() {
        return this.getModel().close();
      },
      'pane:close-other-items': function() {
        return this.getModel().destroyInactiveItems();
      },
      'pane:increase-size': function() {
        return this.getModel().increaseSize();
      },
      'pane:decrease-size': function() {
        return this.getModel().decreaseSize();
      }
    }, false);
    commandRegistry.add('atom-text-editor', stopEventPropagation({
      'core:move-left': function() {
        return this.moveLeft();
      },
      'core:move-right': function() {
        return this.moveRight();
      },
      'core:select-left': function() {
        return this.selectLeft();
      },
      'core:select-right': function() {
        return this.selectRight();
      },
      'core:select-up': function() {
        return this.selectUp();
      },
      'core:select-down': function() {
        return this.selectDown();
      },
      'core:select-all': function() {
        return this.selectAll();
      },
      'editor:select-word': function() {
        return this.selectWordsContainingCursors();
      },
      'editor:consolidate-selections': function(event) {
        if (!this.consolidateSelections()) {
          return event.abortKeyBinding();
        }
      },
      'editor:move-to-beginning-of-next-paragraph': function() {
        return this.moveToBeginningOfNextParagraph();
      },
      'editor:move-to-beginning-of-previous-paragraph': function() {
        return this.moveToBeginningOfPreviousParagraph();
      },
      'editor:move-to-beginning-of-screen-line': function() {
        return this.moveToBeginningOfScreenLine();
      },
      'editor:move-to-beginning-of-line': function() {
        return this.moveToBeginningOfLine();
      },
      'editor:move-to-end-of-screen-line': function() {
        return this.moveToEndOfScreenLine();
      },
      'editor:move-to-end-of-line': function() {
        return this.moveToEndOfLine();
      },
      'editor:move-to-first-character-of-line': function() {
        return this.moveToFirstCharacterOfLine();
      },
      'editor:move-to-beginning-of-word': function() {
        return this.moveToBeginningOfWord();
      },
      'editor:move-to-end-of-word': function() {
        return this.moveToEndOfWord();
      },
      'editor:move-to-beginning-of-next-word': function() {
        return this.moveToBeginningOfNextWord();
      },
      'editor:move-to-previous-word-boundary': function() {
        return this.moveToPreviousWordBoundary();
      },
      'editor:move-to-next-word-boundary': function() {
        return this.moveToNextWordBoundary();
      },
      'editor:move-to-previous-subword-boundary': function() {
        return this.moveToPreviousSubwordBoundary();
      },
      'editor:move-to-next-subword-boundary': function() {
        return this.moveToNextSubwordBoundary();
      },
      'editor:select-to-beginning-of-next-paragraph': function() {
        return this.selectToBeginningOfNextParagraph();
      },
      'editor:select-to-beginning-of-previous-paragraph': function() {
        return this.selectToBeginningOfPreviousParagraph();
      },
      'editor:select-to-end-of-line': function() {
        return this.selectToEndOfLine();
      },
      'editor:select-to-beginning-of-line': function() {
        return this.selectToBeginningOfLine();
      },
      'editor:select-to-end-of-word': function() {
        return this.selectToEndOfWord();
      },
      'editor:select-to-beginning-of-word': function() {
        return this.selectToBeginningOfWord();
      },
      'editor:select-to-beginning-of-next-word': function() {
        return this.selectToBeginningOfNextWord();
      },
      'editor:select-to-next-word-boundary': function() {
        return this.selectToNextWordBoundary();
      },
      'editor:select-to-previous-word-boundary': function() {
        return this.selectToPreviousWordBoundary();
      },
      'editor:select-to-next-subword-boundary': function() {
        return this.selectToNextSubwordBoundary();
      },
      'editor:select-to-previous-subword-boundary': function() {
        return this.selectToPreviousSubwordBoundary();
      },
      'editor:select-to-first-character-of-line': function() {
        return this.selectToFirstCharacterOfLine();
      },
      'editor:select-line': function() {
        return this.selectLinesContainingCursors();
      },
      'editor:select-larger-syntax-node': function() {
        return this.selectLargerSyntaxNode();
      },
      'editor:select-smaller-syntax-node': function() {
        return this.selectSmallerSyntaxNode();
      }
    }), false);
    commandRegistry.add('atom-text-editor:not([readonly])', stopEventPropagation({
      'core:undo': function() {
        return this.undo();
      },
      'core:redo': function() {
        return this.redo();
      }
    }), false);
    commandRegistry.add('atom-text-editor', stopEventPropagationAndGroupUndo(config, {
      'core:copy': function() {
        return this.copySelectedText();
      },
      'editor:copy-selection': function() {
        return this.copyOnlySelectedText();
      }
    }), false);
    commandRegistry.add('atom-text-editor:not([readonly])', stopEventPropagationAndGroupUndo(config, {
      'core:backspace': function() {
        return this.backspace();
      },
      'core:delete': function() {
        return this["delete"]();
      },
      'core:cut': function() {
        return this.cutSelectedText();
      },
      'core:paste': function() {
        return this.pasteText();
      },
      'editor:paste-without-reformatting': function() {
        return this.pasteText({
          normalizeLineEndings: false,
          autoIndent: false,
          preserveTrailingLineIndentation: true
        });
      },
      'editor:delete-to-previous-word-boundary': function() {
        return this.deleteToPreviousWordBoundary();
      },
      'editor:delete-to-next-word-boundary': function() {
        return this.deleteToNextWordBoundary();
      },
      'editor:delete-to-beginning-of-word': function() {
        return this.deleteToBeginningOfWord();
      },
      'editor:delete-to-beginning-of-line': function() {
        return this.deleteToBeginningOfLine();
      },
      'editor:delete-to-end-of-line': function() {
        return this.deleteToEndOfLine();
      },
      'editor:delete-to-end-of-word': function() {
        return this.deleteToEndOfWord();
      },
      'editor:delete-to-beginning-of-subword': function() {
        return this.deleteToBeginningOfSubword();
      },
      'editor:delete-to-end-of-subword': function() {
        return this.deleteToEndOfSubword();
      },
      'editor:delete-line': function() {
        return this.deleteLine();
      },
      'editor:cut-to-end-of-line': function() {
        return this.cutToEndOfLine();
      },
      'editor:cut-to-end-of-buffer-line': function() {
        return this.cutToEndOfBufferLine();
      },
      'editor:transpose': function() {
        return this.transpose();
      },
      'editor:upper-case': function() {
        return this.upperCase();
      },
      'editor:lower-case': function() {
        return this.lowerCase();
      }
    }), false);
    commandRegistry.add('atom-text-editor:not([mini])', stopEventPropagation({
      'core:move-up': function() {
        return this.moveUp();
      },
      'core:move-down': function() {
        return this.moveDown();
      },
      'core:move-to-top': function() {
        return this.moveToTop();
      },
      'core:move-to-bottom': function() {
        return this.moveToBottom();
      },
      'core:page-up': function() {
        return this.pageUp();
      },
      'core:page-down': function() {
        return this.pageDown();
      },
      'core:select-to-top': function() {
        return this.selectToTop();
      },
      'core:select-to-bottom': function() {
        return this.selectToBottom();
      },
      'core:select-page-up': function() {
        return this.selectPageUp();
      },
      'core:select-page-down': function() {
        return this.selectPageDown();
      },
      'editor:add-selection-below': function() {
        return this.addSelectionBelow();
      },
      'editor:add-selection-above': function() {
        return this.addSelectionAbove();
      },
      'editor:split-selections-into-lines': function() {
        return this.splitSelectionsIntoLines();
      },
      'editor:toggle-soft-tabs': function() {
        return this.toggleSoftTabs();
      },
      'editor:toggle-soft-wrap': function() {
        return this.toggleSoftWrapped();
      },
      'editor:fold-all': function() {
        return this.foldAll();
      },
      'editor:unfold-all': function() {
        return this.unfoldAll();
      },
      'editor:fold-current-row': function() {
        this.foldCurrentRow();
        return this.scrollToCursorPosition();
      },
      'editor:unfold-current-row': function() {
        this.unfoldCurrentRow();
        return this.scrollToCursorPosition();
      },
      'editor:fold-selection': function() {
        return this.foldSelectedLines();
      },
      'editor:fold-at-indent-level-1': function() {
        this.foldAllAtIndentLevel(0);
        return this.scrollToCursorPosition();
      },
      'editor:fold-at-indent-level-2': function() {
        this.foldAllAtIndentLevel(1);
        return this.scrollToCursorPosition();
      },
      'editor:fold-at-indent-level-3': function() {
        this.foldAllAtIndentLevel(2);
        return this.scrollToCursorPosition();
      },
      'editor:fold-at-indent-level-4': function() {
        this.foldAllAtIndentLevel(3);
        return this.scrollToCursorPosition();
      },
      'editor:fold-at-indent-level-5': function() {
        this.foldAllAtIndentLevel(4);
        return this.scrollToCursorPosition();
      },
      'editor:fold-at-indent-level-6': function() {
        this.foldAllAtIndentLevel(5);
        return this.scrollToCursorPosition();
      },
      'editor:fold-at-indent-level-7': function() {
        this.foldAllAtIndentLevel(6);
        return this.scrollToCursorPosition();
      },
      'editor:fold-at-indent-level-8': function() {
        this.foldAllAtIndentLevel(7);
        return this.scrollToCursorPosition();
      },
      'editor:fold-at-indent-level-9': function() {
        this.foldAllAtIndentLevel(8);
        return this.scrollToCursorPosition();
      },
      'editor:log-cursor-scope': function() {
        return showCursorScope(this.getCursorScope(), notificationManager);
      },
      'editor:log-cursor-syntax-tree-scope': function() {
        return showSyntaxTree(this.getCursorSyntaxTreeScope(), notificationManager);
      },
      'editor:copy-path': function() {
        return copyPathToClipboard(this, project, clipboard, false);
      },
      'editor:copy-project-path': function() {
        return copyPathToClipboard(this, project, clipboard, true);
      },
      'editor:toggle-indent-guide': function() {
        return config.set('editor.showIndentGuide', !config.get('editor.showIndentGuide'));
      },
      'editor:toggle-line-numbers': function() {
        return config.set('editor.showLineNumbers', !config.get('editor.showLineNumbers'));
      },
      'editor:scroll-to-cursor': function() {
        return this.scrollToCursorPosition();
      }
    }), false);
    return commandRegistry.add('atom-text-editor:not([mini]):not([readonly])', stopEventPropagationAndGroupUndo(config, {
      'editor:indent': function() {
        return this.indent();
      },
      'editor:auto-indent': function() {
        return this.autoIndentSelectedRows();
      },
      'editor:indent-selected-rows': function() {
        return this.indentSelectedRows();
      },
      'editor:outdent-selected-rows': function() {
        return this.outdentSelectedRows();
      },
      'editor:newline': function() {
        return this.insertNewline();
      },
      'editor:newline-below': function() {
        return this.insertNewlineBelow();
      },
      'editor:newline-above': function() {
        return this.insertNewlineAbove();
      },
      'editor:toggle-line-comments': function() {
        return this.toggleLineCommentsInSelection();
      },
      'editor:checkout-head-revision': function() {
        return atom.workspace.checkoutHeadRevision(this);
      },
      'editor:move-line-up': function() {
        return this.moveLineUp();
      },
      'editor:move-line-down': function() {
        return this.moveLineDown();
      },
      'editor:move-selection-left': function() {
        return this.moveSelectionLeft();
      },
      'editor:move-selection-right': function() {
        return this.moveSelectionRight();
      },
      'editor:duplicate-lines': function() {
        return this.duplicateLines();
      },
      'editor:join-lines': function() {
        return this.joinLines();
      }
    }), false);
  };

  stopEventPropagation = function(commandListeners) {
    var commandListener, commandName, fn, newCommandListeners;
    newCommandListeners = {};
    fn = function(commandListener) {
      return newCommandListeners[commandName] = function(event) {
        event.stopPropagation();
        return commandListener.call(this.getModel(), event);
      };
    };
    for (commandName in commandListeners) {
      commandListener = commandListeners[commandName];
      fn(commandListener);
    }
    return newCommandListeners;
  };

  stopEventPropagationAndGroupUndo = function(config, commandListeners) {
    var commandListener, commandName, fn, newCommandListeners;
    newCommandListeners = {};
    fn = function(commandListener) {
      return newCommandListeners[commandName] = function(event) {
        var model;
        event.stopPropagation();
        model = this.getModel();
        return model.transact(model.getUndoGroupingInterval(), function() {
          return commandListener.call(model, event);
        });
      };
    };
    for (commandName in commandListeners) {
      commandListener = commandListeners[commandName];
      fn(commandListener);
    }
    return newCommandListeners;
  };

  showCursorScope = function(descriptor, notificationManager) {
    var content, list;
    list = descriptor.scopes.toString().split(',');
    list = list.map(function(item) {
      return "* " + item;
    });
    content = "Scopes at Cursor\n" + (list.join('\n'));
    return notificationManager.addInfo(content, {
      dismissable: true
    });
  };

  showSyntaxTree = function(descriptor, notificationManager) {
    var content, list;
    list = descriptor.scopes.toString().split(',');
    list = list.map(function(item) {
      return "* " + item;
    });
    content = "Syntax tree at Cursor\n" + (list.join('\n'));
    return notificationManager.addInfo(content, {
      dismissable: true
    });
  };

  copyPathToClipboard = function(editor, project, clipboard, relative) {
    var filePath;
    if (filePath = editor.getPath()) {
      if (relative) {
        filePath = project.relativize(filePath);
      }
      return clipboard.write(filePath);
    }
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
