(function() {
  var PaneResizeHandleElement,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  PaneResizeHandleElement = (function(superClass) {
    extend(PaneResizeHandleElement, superClass);

    function PaneResizeHandleElement() {
      return PaneResizeHandleElement.__super__.constructor.apply(this, arguments);
    }

    PaneResizeHandleElement.prototype.createdCallback = function() {
      this.resizePane = this.resizePane.bind(this);
      this.resizeStopped = this.resizeStopped.bind(this);
      return this.subscribeToDOMEvents();
    };

    PaneResizeHandleElement.prototype.subscribeToDOMEvents = function() {
      this.addEventListener('dblclick', this.resizeToFitContent.bind(this));
      return this.addEventListener('mousedown', this.resizeStarted.bind(this));
    };

    PaneResizeHandleElement.prototype.attachedCallback = function() {
      if (this.parentElement) {
        this.isHorizontal = this.parentElement.classList.contains("horizontal");
        return this.classList.add(this.isHorizontal ? 'horizontal' : 'vertical');
      }
    };

    PaneResizeHandleElement.prototype.detachedCallback = function() {
      return this.resizeStopped();
    };

    PaneResizeHandleElement.prototype.resizeToFitContent = function() {
      var ref, ref1;
      if ((ref = this.previousSibling) != null) {
        ref.model.setFlexScale(1);
      }
      return (ref1 = this.nextSibling) != null ? ref1.model.setFlexScale(1) : void 0;
    };

    PaneResizeHandleElement.prototype.resizeStarted = function(e) {
      e.stopPropagation();
      document.addEventListener('mousemove', this.resizePane);
      return document.addEventListener('mouseup', this.resizeStopped);
    };

    PaneResizeHandleElement.prototype.resizeStopped = function() {
      document.removeEventListener('mousemove', this.resizePane);
      return document.removeEventListener('mouseup', this.resizeStopped);
    };

    PaneResizeHandleElement.prototype.calcRatio = function(ratio1, ratio2, total) {
      var allRatio;
      allRatio = ratio1 + ratio2;
      return [total * ratio1 / allRatio, total * ratio2 / allRatio];
    };

    PaneResizeHandleElement.prototype.setFlexGrow = function(prevSize, nextSize) {
      var flexGrows, totalScale;
      this.prevModel = this.previousSibling.model;
      this.nextModel = this.nextSibling.model;
      totalScale = this.prevModel.getFlexScale() + this.nextModel.getFlexScale();
      flexGrows = this.calcRatio(prevSize, nextSize, totalScale);
      this.prevModel.setFlexScale(flexGrows[0]);
      return this.nextModel.setFlexScale(flexGrows[1]);
    };

    PaneResizeHandleElement.prototype.fixInRange = function(val, minValue, maxValue) {
      return Math.min(Math.max(val, minValue), maxValue);
    };

    PaneResizeHandleElement.prototype.resizePane = function(arg) {
      var bottomHeight, clientX, clientY, leftWidth, rightWidth, topHeight, totalHeight, totalWidth, which;
      clientX = arg.clientX, clientY = arg.clientY, which = arg.which;
      if (which !== 1) {
        return this.resizeStopped();
      }
      if (!((this.previousSibling != null) && (this.nextSibling != null))) {
        return this.resizeStopped();
      }
      if (this.isHorizontal) {
        totalWidth = this.previousSibling.clientWidth + this.nextSibling.clientWidth;
        leftWidth = clientX - this.previousSibling.getBoundingClientRect().left;
        leftWidth = this.fixInRange(leftWidth, 0, totalWidth);
        rightWidth = totalWidth - leftWidth;
        return this.setFlexGrow(leftWidth, rightWidth);
      } else {
        totalHeight = this.previousSibling.clientHeight + this.nextSibling.clientHeight;
        topHeight = clientY - this.previousSibling.getBoundingClientRect().top;
        topHeight = this.fixInRange(topHeight, 0, totalHeight);
        bottomHeight = totalHeight - topHeight;
        return this.setFlexGrow(topHeight, bottomHeight);
      }
    };

    return PaneResizeHandleElement;

  })(HTMLElement);

  module.exports = PaneResizeHandleElement = document.registerElement('atom-pane-resize-handle', {
    prototype: PaneResizeHandleElement.prototype
  });

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
