(function() {
  var CompositeDisposable, PaneAxisElement, PaneResizeHandleElement,
    extend = function(child, parent) { for (var key in parent) { if (hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    hasProp = {}.hasOwnProperty;

  CompositeDisposable = require('event-kit').CompositeDisposable;

  PaneResizeHandleElement = require('./pane-resize-handle-element');

  PaneAxisElement = (function(superClass) {
    extend(PaneAxisElement, superClass);

    function PaneAxisElement() {
      return PaneAxisElement.__super__.constructor.apply(this, arguments);
    }

    PaneAxisElement.prototype.attachedCallback = function() {
      var child, i, index, len, ref, results;
      if (this.subscriptions == null) {
        this.subscriptions = this.subscribeToModel();
      }
      ref = this.model.getChildren();
      results = [];
      for (index = i = 0, len = ref.length; i < len; index = ++i) {
        child = ref[index];
        results.push(this.childAdded({
          child: child,
          index: index
        }));
      }
      return results;
    };

    PaneAxisElement.prototype.detachedCallback = function() {
      var child, i, len, ref, results;
      this.subscriptions.dispose();
      this.subscriptions = null;
      ref = this.model.getChildren();
      results = [];
      for (i = 0, len = ref.length; i < len; i++) {
        child = ref[i];
        results.push(this.childRemoved({
          child: child
        }));
      }
      return results;
    };

    PaneAxisElement.prototype.initialize = function(model, viewRegistry) {
      var child, i, index, len, ref;
      this.model = model;
      this.viewRegistry = viewRegistry;
      if (this.subscriptions == null) {
        this.subscriptions = this.subscribeToModel();
      }
      ref = this.model.getChildren();
      for (index = i = 0, len = ref.length; i < len; index = ++i) {
        child = ref[index];
        this.childAdded({
          child: child,
          index: index
        });
      }
      switch (this.model.getOrientation()) {
        case 'horizontal':
          this.classList.add('horizontal', 'pane-row');
          break;
        case 'vertical':
          this.classList.add('vertical', 'pane-column');
      }
      return this;
    };

    PaneAxisElement.prototype.subscribeToModel = function() {
      var subscriptions;
      subscriptions = new CompositeDisposable;
      subscriptions.add(this.model.onDidAddChild(this.childAdded.bind(this)));
      subscriptions.add(this.model.onDidRemoveChild(this.childRemoved.bind(this)));
      subscriptions.add(this.model.onDidReplaceChild(this.childReplaced.bind(this)));
      subscriptions.add(this.model.observeFlexScale(this.flexScaleChanged.bind(this)));
      return subscriptions;
    };

    PaneAxisElement.prototype.isPaneResizeHandleElement = function(element) {
      return (element != null ? element.nodeName.toLowerCase() : void 0) === 'atom-pane-resize-handle';
    };

    PaneAxisElement.prototype.childAdded = function(arg) {
      var child, index, nextElement, prevElement, resizeHandle, view;
      child = arg.child, index = arg.index;
      view = this.viewRegistry.getView(child);
      this.insertBefore(view, this.children[index * 2]);
      prevElement = view.previousSibling;
      if ((prevElement != null) && !this.isPaneResizeHandleElement(prevElement)) {
        resizeHandle = document.createElement('atom-pane-resize-handle');
        this.insertBefore(resizeHandle, view);
      }
      nextElement = view.nextSibling;
      if ((nextElement != null) && !this.isPaneResizeHandleElement(nextElement)) {
        resizeHandle = document.createElement('atom-pane-resize-handle');
        return this.insertBefore(resizeHandle, nextElement);
      }
    };

    PaneAxisElement.prototype.childRemoved = function(arg) {
      var child, siblingView, view;
      child = arg.child;
      view = this.viewRegistry.getView(child);
      siblingView = view.previousSibling;
      if ((siblingView != null) && this.isPaneResizeHandleElement(siblingView)) {
        siblingView.remove();
      }
      return view.remove();
    };

    PaneAxisElement.prototype.childReplaced = function(arg) {
      var focusedElement, index, newChild, oldChild;
      index = arg.index, oldChild = arg.oldChild, newChild = arg.newChild;
      if (this.hasFocus()) {
        focusedElement = document.activeElement;
      }
      this.childRemoved({
        child: oldChild,
        index: index
      });
      this.childAdded({
        child: newChild,
        index: index
      });
      if (document.activeElement === document.body) {
        return focusedElement != null ? focusedElement.focus() : void 0;
      }
    };

    PaneAxisElement.prototype.flexScaleChanged = function(flexScale) {
      return this.style.flexGrow = flexScale;
    };

    PaneAxisElement.prototype.hasFocus = function() {
      return this === document.activeElement || this.contains(document.activeElement);
    };

    return PaneAxisElement;

  })(HTMLElement);

  module.exports = PaneAxisElement = document.registerElement('atom-pane-axis', {
    prototype: PaneAxisElement.prototype
  });

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
